<?php
class Revenue {
	function __construct($module = "") {
		foreach ($GLOBALS as $key => $values) {
			$this->$key = $values;
		}
	}
	public function getPageContent(){
		$content = '';
		$data = $this->getUserWalletDetails();
		$tplUrl = DIR_TMPL . $this->module . "/" . $this->module . ".tpl.php";
		$btn_redeem = '';
		if($data['data']['amount'] > 0){
			$btn_redeem = get_view(DIR_TMPL . $this->module . "/redeem-btn-nct.tpl.php");
		}
		else{
			$btn_redeem = get_view(DIR_TMPL . $this->module . "/no-amount-nct.tpl.php");
		}
		/*multi currency change*/
    	$spentAmount = exchange($data['data']['spentAmount'],DEFAULT_CURRENCY_CODE,$this->cCode,null,'','display');
    	$pendingAmount = exchange($data['data']['pendingAmount'],DEFAULT_CURRENCY_CODE,$this->cCode,null,'','display');
    	$amount = exchange($data['data']['amount'],DEFAULT_CURRENCY_CODE,$this->cCode,null,'','display');
    	$withdrawalAmount = exchange($data['data']['withdrawalAmount'],DEFAULT_CURRENCY_CODE,$this->cCode,null,'','display');
    	$earningAmount = exchange($data['data']['earningAmount'],DEFAULT_CURRENCY_CODE,$this->cCode,null,'','display');
    	$earnedAmount = exchange($data['data']['earnedAmount'],DEFAULT_CURRENCY_CODE,$this->cCode,null,'','display');
    	$referralAmount = exchange($data['data']['referralAmount'],DEFAULT_CURRENCY_CODE,$this->cCode,null,'','display');
    	/*multi currency change*/
		$replace = array(
			'%SPENT_AMOUNT%'		=>$spentAmount,
			'%PENDING_AMOUNT%'		=>$pendingAmount,
			'%AVAILABLE_AMOUNT%'	=>$amount,
			'%WITHDRAWAL_AMOUNT%'	=>$withdrawalAmount,
			'%EARNING_AMOUNT%'		=>$earningAmount,
			'%EARNED_AMOUNT%'		=>$earnedAmount,
			'%REFERRAL_AMOUNT%'		=>$referralAmount,
			'%REDEEM_BTN%'			=>$btn_redeem
		);
		$content = get_view($tplUrl,$replace);
		return $content;
	}

	public function getUserWalletDetails($data=array()){
		extract($data);
		$return = array();
		$return['status'] = false;
		$return['redirectLink'] = '';
		$return['message'] = '';
		$return['data'] = array();
		
        $q = $this->db->pdoQuery("SELECT u.id,u.userName,u.slug,w.amount,w.earningAmount,w.pendingAmount,w.earnedAmount,w.spentAmount,w.cancelledAmount,w.withdrawalAmount,w.referralAmount
			FROM tbl_users AS u 
			LEFT JOIN tbl_wallet AS w ON w.userId = u.id
			WHERE u.id = ? LIMIT 1 ",array($this->sessUserId));

		if($q->affectedRows() > 0){
			$q_res = $q->result();

			$return['data'] = array(
				'id'							=>$q_res['id'],
				'userName'						=>filtering($q_res['userName']),
				'slug'							=>$q_res['slug'],
				'amount'						=>$q_res['amount'],
				'earningAmount'					=>$q_res['earningAmount'],
				'pendingAmount'					=>$q_res['pendingAmount'],
				'earnedAmount'					=>$q_res['earnedAmount'],
				'spentAmount'					=>$q_res['spentAmount'],
				'cancelledAmount'				=>$q_res['cancelledAmount'],
				'withdrawalAmount'				=>$q_res['withdrawalAmount'],
				'referralAmount'				=>$q_res['referralAmount']
			);
			$return['status'] = true;
		}	
		else{
			$return['message'] = REVENUE_PAGE_MSG_NRF;
			$return['status'] = false;
		}
		return $return;
	}

	public function getRedeemRequestList($data=array()){
		extract($data);
		$status = (isset($status) && $status != '') ? $status : '';
		$from_date = (isset($from_date) && $from_date != '') ? $from_date : '';
		$to_date = (isset($to_date) && $to_date != '') ? $to_date : '';

		$return = array();
		$return['status'] = false;
		$return['redirectLink'] = '';
		$return['message'] = '';
		$return['data'] = array();
		$return['pagination'] = array();
		
		$content = array();
		$content['html'] ='';
		$content['status'] = false;
		$content['pagination'] ='';
 		
 		$sWhere = '  WHERE r.userId = ?  ';
		$aWhere = array($this->sessUserId);

		$page =  isset($_REQUEST['page']) ? (int) $_REQUEST['page'] : 1;
		$per_page_limit = $rows = (isset($per_page_limit) && $per_page_limit > 0)  ? (int) $per_page_limit : PER_PAGE_LIMIT;
        $offset = ($page != 0) ? (int) ($page - 1) * $rows : 0;
		
		$sorting = ' r.id DESC  ';

		//filters
		if($status != ''){
			$sWhere .= ' AND r.status = ? ';
			$aWhere[] = $status;
		}

		if (isset($from_date) && $from_date != ''){
            $sWhere .= " AND ( DATE_FORMAT(r.createdDate,'%Y-%m-%d') >= ? ) ";
            $aWhere[] = $from_date;
        }
        if (isset($to_date) && $to_date != ''){
            $sWhere .= " AND DATE_FORMAT(r.createdDate,'%Y-%m-%d') <= ?  ";
            $aWhere[] = "$to_date";
        }
        //filters
		
		$totalRowCount = $this->db->pdoQuery("SELECT r.id
        		FROM tbl_redeem_request AS r
                $sWhere GROUP BY r.id ", $aWhere);
        $totalRow =  $totalRowCount->affectedRows();

		$pager = getPagerData($totalRow, $per_page_limit, $page);
        $q = $this->db->pdoQuery("SELECT r.id,r.requestId,r.userId,r.amount,r.status,r.paymentMode,r.fundedDate,r.createdDate
    		FROM tbl_redeem_request AS r 
			$sWhere  GROUP BY r.id  ORDER BY $sorting LIMIT  $offset , $rows", $aWhere);

		if($q->affectedRows() > 0){

			foreach ($q->results() as $key => $value){

				if($this->sessRequestType == 'web'){

					/*multi currency change*/
	            	$amount = exchange($value['amount'],DEFAULT_CURRENCY_CODE,$this->cCode,null,'','display');
	            	/*multi currency change*/
	            	$replace = array(
	            		'%R_ID%'=>$value['id']
	            	);
	            	$cancel_btn = ($value['status'] == 'p' ? get_view(DIR_TMPL . $this->module . "/cancel-btn-nct.tpl.php",$replace) : '');

					$replace = array(
						'%TXN_ID%'			=>$value['requestId'],
						'%PAYMENT_TYPE%'	=>($value['paymentMode'] == 'p' ? REVENUE_PAGE_LBL_PAYPAL_PAYMENT : REVENUE_PAGE_LBL_BANK_PAYMENT),
						'%AMOUNT%'			=>$amount,
						'%CLASS%'			=>(($value['status'] == 'p' || $value['status'] == 'c') ? 'reject-color' : 'success-color'),
						'%REQUEST_DATE%'	=>convertDate($value['createdDate']),
						'%CANCEL_BTN%'		=>$cancel_btn,
						'%STATUS%'			=>($value['status'] == 'p' ? REVENUE_PAGE_LBL_PAYMENT_PENDING : ($value['status'] == 'c' ? REVENUE_PAGE_LBL_CANCELLED : REVENUE_PAGE_LBL_PAYMENT_FUNDED)),
						'%PAID_DATE%'		=>($value['status'] == 'f' ? convertDate($value['fundedDate']) : '-')
					);
					$content['html'].= get_view(DIR_TMPL . $this->module . "/redeem-request-nct.tpl.php",$replace);
					$content['pagination'] = pagination($pager, $page, $totalRow);
				}
				else{
					$return['pagination']['current_page'] = issetor($pager->page,0);
					$return['pagination']['total_pages'] = issetor($pager->numPages,0);
					$return['pagination']['total'] = issetor($totalRow,0);
					$return['data'][] = array(
					);
				}
			}
			$return['status'] = true;
			$content['status'] = true;
		}	
		else{
			$return['message'] = REVENUE_PAGE_MSG_NO_REQUEST_FOUND; 
			$content['html'].=getNoRecordFoundContent(REVENUE_PAGE_MSG_NO_REQUEST_FOUND,DIR_TMPL . $this->module . "/no-record-nct.tpl.php");
			$return['status'] = false;
		}
		return getreturnType($return,$content);
	}

	public function getReddemRequestContent($data=array()){
		$return = array();
		$return['status'] = false;
		$return['redirectLink'] = '';
		$return['message'] = '';
		$return['data'] = '';
		$q = $this->db->pdoQuery("SELECT w.amount
			FROM tbl_wallet AS w
			WHERE w.userId = ? AND w.amount > ? LIMIT 1 ",array($this->sessUserId,0));
		if($q->affectedRows() > 0){
			$udata = $q->result();

			$replace = array(
				'%USER_NAME%'=>$udata['amount']
			);
			$return['status'] = true;
			$return['data'] = get_view(DIR_TMPL . $this->module . "/redeem-request-popup-nct.tpl.php",$replace);
		}
		else{
			$return['message'] = REVENUE_PAGE_MSG_DONT_HAVE_AMT_TO_WITHDRAWAL;
		}
		return $return;
	}

	public function RedeemMoney($data=array()){
		extract($data);
        $return = array();
        $return['status'] = false;
        $return['redirectLink'] = SITE_URL.'revenue/';
        $return['message'] = '';
        $return['data'] = array();

        $amount 		= issetor($amount,0);
        $amount 		= (int)$amount;
        $paymentMode 	= filtering(issetor($paymentMode,''),'string');
        
        if($amount > 0 && ($paymentMode == 'p' || $paymentMode == 'b')){

        	$q = $this->db->pdoQuery("SELECT w.amount,w.withdrawalAmount,u.slug,u.userName,u.paypalEmail,u.bankName,u.bankAccountNumber,u.bankIfscCode,u.bankAccountName
				FROM tbl_wallet AS w
				INNER JOIN tbl_users AS u ON u.id = w.userId
				WHERE w.userId = ? AND w.amount >= ? LIMIT 1 ",array($this->sessUserId,$amount));
			if($q->affectedRows() > 0){
				$udata = $q->result();

				//checking bank details or paypal email
	        	if(($paymentMode == 'p' && $udata['paypalEmail'] != '') || ($paymentMode == 'b' && $udata['bankName'] != '' && $udata['bankAccountNumber'] != '' && $udata['bankIfscCode'] != '' && $udata['bankAccountName'] != '')){
	        		$method = ($paymentMode == 'p' ? 'paypal' : 'bank');
	        		$insertArray = array(
						'requestId'		=>generateUpdateRedeemRequestCounter($method),
						'userId'		=>$this->sessUserId,
						'paymentMode'	=>$paymentMode,
						'amount'		=>strval($amount),
						'createdDate'	=>date('Y-m-d H:i:s'),
						'updatedDate'	=>date('Y-m-d H:i:s')
					);
					$rid = $this->db->insert('tbl_redeem_request',$insertArray)->getLastInsertId();
					if($rid > 0){
						$newAmount = ($udata['amount'] - $amount);
						$withdrawalAmount = ($udata['withdrawalAmount'] + $amount);
						$this->db->update('tbl_wallet',array('amount'=>strval($newAmount),'updatedDate'	=>date('Y-m-d H:i:s')),array('userId'=>$this->sessUserId));
						//send mail to admin
						$mailarray = array(
							'greetings'=>'Admin',
							'user_name'=>$udata['userName'],
							'user_url'=>SITE_URL.'prifile/'.$udata['slug'].'/',
							'amount'=>DEFAULT_CURRENCY_SIGN.$amount
						);
						$array = generateEmailTemplate('redeem_request_from_user', $mailarray);
	            		sendEmailAddress(ADMIN_EMAIL, $array['subject'], $array['message']);
	            		//send mail to admin

						$return['status'] = true;
						$msgType = $_SESSION["msgType"] = disMessage(array('type' => 'suc','var' => REVENUE_PAGE_MSG_SUCCESS_REDEEM));
						//$return['message'] = REVENUE_PAGE_MSG_SUCCESS_REDEEM;
					}
					else{
						$msgType = $_SESSION["msgType"] = disMessage(array('type' => 'err','var' => SERVICE_DETAILS_PAGE_MSG_SOMETHING_WENT_WRONG));
						//$return['message'] = SERVICE_DETAILS_PAGE_MSG_SOMETHING_WENT_WRONG;
					}
	        	}
	        	else{
	        		$return['redirectLink'] = SITE_URL.'account-settings/';
	        		$msgType = $_SESSION["msgType"] = disMessage(array('type' => 'err','var' => REVENUE_PAGE_MSG_PROVIDE_PAYMENT_DETAILS));
	        		//$return['message'] = REVENUE_PAGE_MSG_PROVIDE_PAYMENT_DETAILS;
	        	}
	        	//checking bank details or paypal email
			}
			else{
				$msgType = $_SESSION["msgType"] = disMessage(array('type' => 'err','var' => REVENUE_PAGE_MSG_DONT_HAVE_AMT_TO_WITHDRAWAL));
				//$return['message'] = REVENUE_PAGE_MSG_DONT_HAVE_AMT_TO_WITHDRAWAL;
			}
        }
        else{
        	$msgType = $_SESSION["msgType"] = disMessage(array('type' => 'err','var' => ADD_SERVICE_PAGE_MSG_PLEASE_FILL_ALL_VALUES));
        	//$return['message'] =  ADD_SERVICE_PAGE_MSG_PLEASE_FILL_ALL_VALUES;
        }
        return $return;
	}

	public function cancelRedeemRequest($data=array()){
		extract($data);
        $return = array();
        $return['status'] = false;
        $return['redirectLink'] = SITE_URL.'revenue/';
        $return['message'] = '';
        $return['data'] = array();

        $rid 		= issetor($rid,0);
        
        if($rid > 0){
        	$q = $this->db->pdoQuery("SELECT r.id,w.amount,w.withdrawalAmount,r.amount as ramount
        		FROM tbl_redeem_request AS r
        		INNER JOIN tbl_wallet AS w ON w.userId = r.userId 
        		WHERE r.id = ? AND r.userId = ? AND r.status =  ? ",array($rid,$this->sessUserId,'p'));
			if($q->affectedRows() > 0){
				$udata = $q->result();
				$updateArray = array(
					'status'=>'c',
					'updatedDate'=>date('Y-m-d H:i:s')
				);
				$this->db->update('tbl_redeem_request',$updateArray,array('id'=>$udata['id']));
				//updating wallet
				$newAmount = ($udata['amount'] + $udata['ramount']);
				$withdrawalAmount = ($udata['withdrawalAmount'] - $udata['ramount']);
				$this->db->update('tbl_wallet',array('amount'=>strval($newAmount),'updatedDate'	=>date('Y-m-d H:i:s')),array('userId'=>$this->sessUserId));
				//updating wallet
				$return['status'] = true;
				$msgType = $_SESSION["msgType"] = disMessage(array('type' => 'suc','var' => REVENUE_PAGE_MSG_CANCEL_SUCCESS));
				$return['message'] = REVENUE_PAGE_MSG_CANCEL_SUCCESS;
			}
			else{
				$return['message'] = REVENUE_PAGE_MSG_REQUEST_NOT_FOUND;
			}
        }
        else{
        	$return['message'] =  ADD_SERVICE_PAGE_MSG_PLEASE_FILL_ALL_VALUES;
        }
        return $return;
	}

	public function exportReddemRequestToCsv($data=array()){
		extract($data);
		$status = (isset($status) && $status != '') ? $status : '';
		$from_date = (isset($from_date) && $from_date != '') ? $from_date : '';
		$to_date = (isset($to_date) && $to_date != '') ? $to_date : '';

		$return = array();
		$return['status'] = false;
		$return['redirectLink'] = '';
		$return['message'] = '';
		$return['data'] = array();
		
		$content = array();
		$content['html'] ='';
		$content['status'] = false;

		$sWhere = '  WHERE r.userId = ?  ';
		$aWhere = array($this->sessUserId);
		
		$sorting = ' r.id DESC  ';

		//filters
		if($status != ''){
			$sWhere .= ' AND r.status = ? ';
			$aWhere[] = $status;
		}

		if (isset($from_date) && $from_date != ''){
            $sWhere .= " AND ( DATE_FORMAT(r.createdDate,'%Y-%m-%d') >= ? ) ";
            $aWhere[] = $from_date;
        }
        if (isset($to_date) && $to_date != ''){
            $sWhere .= " AND DATE_FORMAT(r.createdDate,'%Y-%m-%d') <= ?  ";
            $aWhere[] = "$to_date";
        }
        //filters

        $q = $this->db->pdoQuery("SELECT r.id,r.requestId,r.userId,r.amount,r.status,r.paymentMode,r.fundedDate,r.createdDate
    		FROM tbl_redeem_request AS r 
			$sWhere  GROUP BY r.id  ORDER BY $sorting", $aWhere);

		if($q->affectedRows() > 0){
			$fileContent = '';
			foreach ($q->results() as $key => $value){

				if($this->sessRequestType == 'web'){
					/*multi currency change*/
	            	$amount = exchange($value['amount'],DEFAULT_CURRENCY_CODE,$this->cCode,null,'','display');
	            	/*multi currency change*/

	            	$status = ($value['status'] == 'p' ? REVENUE_PAGE_LBL_PAYMENT_PENDING : ($value['status'] == 'c' ? REVENUE_PAGE_LBL_CANCELLED : REVENUE_PAGE_LBL_PAYMENT_FUNDED));
	            	$paid_date = ($value['status'] == 'f' ? convertDate($value['fundedDate']) : '-');
	            	$paymentMode = ($value['paymentMode'] == 'p' ? REVENUE_PAGE_LBL_PAYPAL_PAYMENT : REVENUE_PAGE_LBL_BANK_PAYMENT);

	            	$fileContent .= "".$value['requestId'].",".$paymentMode.",".DEFAULT_CURRENCY_CODE.' '.$value['amount'].",".convertDate($value['createdDate']).",'".$status."',".$paid_date."\n";
				}
				else{
					$return['data'][] = array();
				}
			}

			$t_name = 'Redeem-Requests-'.time().".csv";
			$filepath = DIR_UPD.'redeem-request/'.$t_name;
			$fd = fopen ($filepath, "w");
			ob_end_clean();
			fputs($fd, $fileContent);
			fclose($fd);
			$content['redirectLink'] = SITE_URL.'download-csv/'.$t_name;
			$return['status'] = true;
			$content['status'] = true;
		}	
		else{
			$return['message'] = REVENUE_PAGE_MSG_NO_REQUEST_FOUND; 
			$return['status'] = false;
		}
		return getreturnType($return,$content);
	}
}

?>
