<?php
class PromoteBusinessView {
	function __construct($module = "", $embedUrlCode='') {
		foreach ($GLOBALS as $key => $values) {
			$this->$key = $values;
		}
		$this->module = $module;
		$this->embedUrlCode = $embedUrlCode;
	}

	public function getPageContent(){
		$content = array();
		$data = $this->getPromoteDetails();
		if($data['status'] == true){
			$tplUrl = DIR_TMPL . $this->module . "/" . $this->module . ".tpl.php";

			$replace = array(
				'%EMBEDED_CODE%'=>$data['data']['embedCode']
			);
			$content['html'] = get_view($tplUrl,$replace);
			$content['data'] = $data['data'];
		}
		else{
			$msgType = $_SESSION["msgType"] = disMessage(array('type' => 'err','var' => $data['message']));
			redirectPage(SITE_URL);
		}
		return $content;
	}

	public function getPromoteDetails($data=array()){
		extract($data);
		$return = array();
		$return['status'] = false;
		$return['redirectLink'] = '';
		$return['message'] = '';
		$return['data'] = array();
		$embedUrlCode = (isset($embedUrlCode) && $embedUrlCode != '') ? $embedUrlCode : $this->embedUrlCode;
		
        $q = $this->db->pdoQuery("SELECT p.id,p.embedCode,p.embedUrlCode,s.id as sid,s.title,s.slug,p.description,sg.fileName,p.charge,p.deliveryDays,p.expiryDate,p.createdDate
            FROM tbl_promote_business AS p 
            INNER JOIN tbl_services AS s ON s.id = p.serviceId 
            LEFT JOIN tbl_service_gallery AS sg ON (sg.serviceId = s.id AND sg.fileType = 'i') 
            WHERE p.embedUrlCode = ?  LIMIT 1 ",array($embedUrlCode));

		if($q->affectedRows() > 0){
			$q_res = $q->result();
			$sImg = checkImage($q_res['fileName'],8,$q_res['sid']);
			$return['data'] = array(
				'id'							=>$q_res['id'],
				'embedCode'						=>$q_res['embedCode'],
				'title'							=>filtering($q_res['title']),
				'embedUrlCode'					=>filtering($q_res['embedUrlCode'],'output'),
				'description'					=>filtering($q_res['description'],'output'),
				'sid'							=>$q_res['sid'],
				'service_image'					=>$sImg,
				'slug'							=>$q_res['slug']
			);
			$return['status'] = true;
		}	
		else{
			$return['message'] = PROMOTE_BUSINESS_PAGE_VIEW_INVALID_LINK;
			$return['status'] = false;
		}
		return $return;
	}

}

?>
