<?php
class ManagePurchase {
	function __construct($contentArray=array()) {
		foreach ($GLOBALS as $key => $values) {
			$this->$key = $values;
		}
		extract($contentArray);
		$this->module = $module;
		$this->keyword = issetor($keyword);
		$this->orderStatus = issetor($orderStatus);
		$this->orderType = issetor($orderType);
		$this->orderTxnId = issetor($orderTxnId);
		$this->pageNo = issetor($pageNo,1);

	}
	public function getPageContent() {
		$purchaseList = $this->getPurchaseList();

		$replaceArr = array(
						'%ORDER_LIST%'=>$purchaseList['data']['html'],
						'%ORDER_PAGINATION%'=>$purchaseList['data']['pagination']
					);
		$tplUrl = DIR_TMPL . $this->module . "/" . $this->module . ".tpl.php";
		$content = get_view($tplUrl,$replaceArr);
		return $content;
	}

	public function getPurchaseList(){
		$whrCondition = $content = "";
		$returnResponse = array();
		if($this->keyword != ""){
			$whrCondition =  " AND (s.title LIKE '%$this->keyword%' OR r.description LIKE '%$this->keyword%') ";
		}

		if($this->orderStatus != ""){
			$whrCondition .=  " AND o.status = '$this->orderStatus' ";
		}
		if($this->orderType != ""){
			$whrCondition .=  " AND o.orderType = '$this->orderType' ";
		}

		$qry = "SELECT o.*,u.userName,u.slug AS userSlug,u.profileImage,s.title,s.slug AS serviceSlug,r.description FROM tbl_orders AS o LEFT JOIN tbl_request AS r ON r.id = o.entityId AND o.orderType = 'r' LEFT JOIN tbl_services AS s ON s.id = o.entityId AND o.orderType = 's' INNER JOIN tbl_users AS u ON u.id = o.sellerId WHERE o.userId = ? $whrCondition ORDER BY o.id DESC ";

		$whrArr[] = $this->sessUserId;
		$purchase = $this->db->pdoQuery($qry,$whrArr);
		$affRows = $purchase->affectedRows();


		$pager = getPagerData($affRows, SCROLL_LIMIT, $this->pageNo);

		if($this->sessRequestType == 'app'){
			$pagination['current_page'] = issetor($pager ->page,0);
			$pagination['total_pages'] = issetor($pager ->numPages,0);
			$pagination['total'] = issetor($affRows,0);
		}else{
			$pagination = pagination($pager, $this->pageNo, $affRows);
		}
		$offset = $pager -> offset;
		if ($offset < 0) {
			$offset = 0;
		}

		$limit = $pager -> limit;

		$page = $pager -> page;

		$limit_cond = " LIMIT $offset, $limit";

		$purchaseQuery = $this->db->pdoQuery($qry.$limit_cond,$whrArr);

		$NoOfrows = $purchaseQuery->affectedRows();
		if($NoOfrows > 0){
			$purchaseList = $purchaseQuery ->results();
			foreach ($purchaseList as $key => $purchaseValue) {
				$orderId      = $purchaseValue['id']; //orderId
				$userId       = $purchaseValue['userId']; //buyerId
				$sellerId     = $purchaseValue['sellerId'];
				$txnId        = $purchaseValue['txnId'];
				$entityId     = $purchaseValue['entityId'];
				$amount       = $purchaseValue['amount'];
				$extraAmount  = $purchaseValue['extraAmount'];
				$dispAmount   = $amount;
				$deliveryDate = $purchaseValue['deliveryDate'];
				$userSlug     = filtering($purchaseValue['userSlug']);
				$userName     = filtering($purchaseValue['userName']);
				$orderType    = filtering($purchaseValue['orderType']);
				$serviceSlug  = filtering($purchaseValue['serviceSlug']);
				$title        = filtering($purchaseValue['title']);
				$title        = issetor($title);
				$description  = filtering($purchaseValue['description']);
				$description  = issetor($description);
				$profileImage = checkImage($purchaseValue['profileImage'],9,$sellerId);
				$status       = filtering($purchaseValue['status']);
				if($orderType == 'r'){
					$exchangeType = 'o';
					$url = 'javascript:void(0);';
					$dispOrderType = LBL_REQUEST;
					$descDetail = myTruncate($description,50);
					$orderImg = $profileImage;
					$exchangeEntityId = getTableValue('tbl_seller_request_notification','id',array('requestId'=>$entityId,'buyerPaid'=>'y'));

				}else{
					$exchangeType = 's';
					$exchangeEntityId = $entityId;
					$dispOrderType = LBL_SERVICE;
					$url = SITE_URL.'service-details/'.$serviceSlug;
					$descDetail = myTruncate($title,50);

					$serviceImg = $this->db->pdoQuery("SELECT fileName FROM tbl_service_gallery WHERE serviceId = ? AND fileType = ?",array($entityId,'i'))->result();

					$orderImg = checkImage($serviceImg['fileName'],8,$entityId);
				}
				$extraClass = 'btn-primary';
				$showCancel = 'y';
				$showInvoice = 'n';
				$extractAttr = '';
				switch ($status) {
					case 'n':
						$dispStatus    = LBL_NEW;
						$extractAttr   = 'disabled';
						$extraClass    = 'btn-warning';
						$operationText = WAITING_FOR_RESPONSE;
						break;
					case 'a':
						$dispStatus    = ACTIVE;
						$extractAttr   = 'data-type="c"';
						$extraClass    = 'btn-primary operation';
						$operationText = COMPLETE;
						break;
					case 'c':
						$dispStatus    = COMPLETED;
						$extractAttr   = 'disabled';
						$extraClass    = 'btn-success';
						$operationText = COMPLETED;
						$showCancel    = 'n';
						$showInvoice   = 'y';
						break;
					case 'ca':
						$dispStatus    = CANCELLED;
						$extractAttr   = 'disabled';
						$extraClass    = 'btn-danger';
						$operationText = CANCELLED;
						$showCancel    = 'n';
						break;
					case 'l':
						$dispStatus    = LATE;
						$extractAttr   = 'disabled';
						$extraClass    = 'btn-danger';
						$operationText = LATE;
						$showCancel    = 'n';
						break;
					case 'e':
						$dispStatus    = EXPIRED;
						$extractAttr   = 'disabled';
						$extraClass    = 'btn-danger';
						$operationText = EXPIRED;
						$showCancel    = 'n';
						break;
					default:
						$dispStatus    = LBL_NEW;
						$extractAttr   = 'disabled';
						$extraClass    = 'btn-warning';
						$operationText = WAITING_FOR_RESPONSE;
						break;
				}

				if($this->sessRequestType == 'web'){
					$invoiceBtn = $cancelBtn = $operation = "";
					if($showCancel == 'y'){

						$cancelOperationReplace = array(
												'%CANCEL_EXTRA_CLASS%'=>'',
												'%CANCEL_EXTRA_ATTR%'=>'data-type="ca"',
											 );
						$cancelBtn = get_view(DIR_TMPL . $this->module . "/cancel-operation-nct.tpl.php",$cancelOperationReplace);

					}
					$requireInvoice = getTableValue('tbl_user_billing_detail','requireInvoice',array('userId'=>$this->sessUserId));
					if($showInvoice == 'y' && $requireInvoice == 'y'){

						$invoiceOperationReplace = array(
												'%INVOICE_CLASS%'=>'btn-info',
												'%INVOICE_ATTR%'=>'',
												'%INVOICE_URL%'=>SITE_URL.'generate-invoice/'.$txnId,
											 );
						$invoiceBtn = get_view(DIR_TMPL . $this->module . "/generate-invoice-nct.tpl.php",$invoiceOperationReplace);
					}
					$operationReplace = array(
												'%EXTRA_CLASS%'  =>$extraClass,
												'%EXTRA_ATTR%'   =>$extractAttr,
												'%OPERATION%'    =>$operationText,
												'%SHOW_CANCEL%'  =>$cancelBtn,
												'%SHOW_INVOICE%' =>$invoiceBtn
											 );
					$operation = get_view(DIR_TMPL . $this->module . "/operation-nct.tpl.php",$operationReplace);

					/*multi currency change*/
					$dispAmount = exchange($dispAmount,DEFAULT_CURRENCY_CODE,$this->cCode,$exchangeEntityId,$exchangeType);
					/*multi currency change*/

					$replace = array(
									'%ORDER_PHOTO%' => $orderImg,
									'%URL%'         => $url,
									'%USER_PHOTO%'  => $profileImage,
									'%USER_NAME%'   => ucwords($userName),
									'%USER_URL%'    => SITE_URL.'profile/'.$userSlug.'/',
									'%DESC%'        => $descDetail,
									'%AMOUNT%'      => CURRENCY_SIGN.$dispAmount,
									'%ORDER_TYPE%'  => $dispOrderType,
									'%STATUS%'      => $dispStatus,
									'%DATE%'        => convertDate($deliveryDate),
									'%OPERATION%'   => $operation,
									'%ORDER_ID%'    => $txnId,
									);
					$content .= get_view(DIR_TMPL . $this->module . "/single-entery-nct.tpl.php",$replace);
					$retData['html'] = $content;
					$retData['pagination'] = $pagination;
					$returnResponse = array(
									'status' => true,
									'message'=> '',
									'data'=> $retData,
								);
				}else{
					/*app data*/
				}
			}
		}else{
			$retData['html'] = $content;
			if($this->pageNo == 1){
				$retData['html'] =get_view(DIR_TMPL . $this->module . "/no-record-nct.tpl.php");
			}
			$retData['pagination'] = $pagination;
			$returnResponse = array(
									'status' => true,
									'message'=> '',
									'data'=> $retData,
								);
		}
		return $returnResponse;
	}

	public function changeStatus($requestArr = array()){
		extract($requestArr);
		$date = date('Y-m-d H:i:s');

		if($orderId != "" && $actionType != ""){
			$dispStatus = $operation = $invoiceBtn = $cancelBtn = $whrCondition = "";
			if($actionType == 'ca'){
				$whrCondition  = ' AND status NOT IN ("c","ca","l","e") ';
				$dispStatus    = CANCELLED;
				$extractAttr   = 'disabled';
				$extraClass    = 'btn-danger';
				$operationText = CANCELLED;

				$orderData = $this->db->pdoQuery("SELECT o.* FROM tbl_orders AS o WHERE txnId = ? ",array($orderId))->result();

				$adminCommission = $orderData['adminCommission'];
				$amount          = $orderData['amount'];
				$sellerId        = $orderData['sellerId'];
				$userId          = $orderData['userId'];
				$orderType       = $orderData['orderType'];
				$discount        = $orderData['discount'];

				/*udpate buyer wallet*/
				$this->db->pdoQuery("UPDATE tbl_wallet SET pendingAmount = pendingAmount - ?,amount = amount + ?,updatedDate = ? WHERE userId = ?",array($amount,$amount,$date,$userId));

				if($orderType == 's' && $discount > 0){
					$amount += $discount;
				}

				/*udpate seller wallet*/
				$sellerUpdateAmount = $amount - $adminCommission;
				$this->db->pdoQuery("UPDATE tbl_wallet SET earningAmount = earningAmount - ?,updatedDate = ? WHERE userId = ?",array($sellerUpdateAmount,$date,$sellerId));




			}else if($actionType == 'c'){
				$whrCondition  = ' AND status = "a" ';
				$dispStatus    = COMPLETED;
				$extractAttr   = 'disabled';
				$extraClass    = 'btn-success';
				$operationText = COMPLETED;



				$orderData = $this->db->pdoQuery("SELECT o.* FROM tbl_orders AS o WHERE txnId = ? ",array($orderId))->result();

				$adminCommission = $orderData['adminCommission'];
				$amount          = $orderData['amount'];
				$sellerId        = $orderData['sellerId'];
				$userId          = $orderData['userId'];
				$orderType       = $orderData['orderType'];
				$discount        = $orderData['discount'];

				/*udpate buyer wallet*/
				$this->db->pdoQuery("UPDATE tbl_wallet SET pendingAmount = pendingAmount - ?,spentAmount = spentAmount + ?,updatedDate = ? WHERE userId = ?",array($amount,$amount,$date,$userId));

				if($orderType == 's' && $discount > 0){
					$amount += $discount;
				}

				/*udpate seller wallet*/
				$sellerUpdateAmount = $amount - $adminCommission;
				$this->db->pdoQuery("UPDATE tbl_wallet SET earningAmount = earningAmount - ?,earnedAmount = earnedAmount + ?,amount = amount + ?,updatedDate = ? WHERE userId = ?",array($sellerUpdateAmount,$sellerUpdateAmount,$sellerUpdateAmount,$date,$sellerId));


				$requireInvoice = $this->db->pdoQuery("SELECT requireInvoice FROM tbl_user_billing_detail WHERE userId = ?",array($this->sessUserId))->result();
				$requireInvoice = $requireInvoice['requireInvoice'];
				if($requireInvoice == 'y'){
					$invoiceOperationReplace = array(
													'%INVOICE_CLASS%'=>'btn-info',
													'%INVOICE_ATTR%'=>'',
													'%INVOICE_URL%'=>SITE_URL.'generate-invoice/'.$orderId,
												 );
					$invoiceBtn = get_view(DIR_TMPL . $this->module . "/generate-invoice-nct.tpl.php",$invoiceOperationReplace);
				}

				updateUserLevelViaCompletedOrders(array('userId'=>$sellerId));

			}



			$qry = "UPDATE tbl_orders SET status = ?,buyerUpdatedDate = ? WHERE  txnId = ? AND userId = ? $whrCondition";

			$isAffected = $this->db->pdoQuery($qry,array($actionType,$date,$orderId,$this->sessUserId))->affectedRows();
			if($isAffected > 0){
				$message = "";
				$status = true;
				$orderData = $this->db->pdoQuery("SELECT * FROM tbl_orders WHERE txnId = ?",array($orderId))->result();
				$operationReplace = array(
										'%EXTRA_CLASS%'=>$extraClass,
										'%EXTRA_ATTR%'=>$extractAttr,
										'%OPERATION%'=>$operationText,
										'%SHOW_CANCEL%'=>$cancelBtn,
										'%SHOW_INVOICE%'=>$invoiceBtn

									 );
				$operation = get_view(DIR_TMPL . $this->module . "/operation-nct.tpl.php",$operationReplace);



				$sellerId = $orderData['sellerId'];
				$id = $orderData['id'];
				$notification_type =  $actionType == "c" ? 'order_completed' : 'order_cancelled';
				$data_array = array(
					'receiverId'=>$sellerId,
					'senderId'=>$this->sessUserId,
					'buyerId' => $this->sessUserId,
					'sellerId' => $sellerId,
					'notifyId'=>$notification_type,
					'txnId'     =>$orderId,
					'entityId'=>$id//order id
				);

				addNewNotificationForUser($notification_type,$data_array);
			}else{
				$message = MSG_PERMISSION_DENIED;
				$status = false;
			}
			$returnResponse = array(
							'redirectLink'  => SITE_URL.'manage-purchase/',
							'status'        => $status,
							'message'       => $message,
							'data'          => $operation,
							'dispStatus'    => $dispStatus,
						);

		}else{
			$returnResponse = array(
			'redirectLink'  => SITE_URL.'manage-purchase/',
			'status'        => false,
			'message'       => MSG_SOMETHING_WRONG,
			'data'          => array());
		}
		return $returnResponse;
	}

	public function generateInvoice($txnId = 0) {
		$final_result = NULL;

		$qry = "SELECT o.*,seller.userName AS sellerUserName,seller.profileImage AS sellerImg,buyer.userName AS buyerUserName,buyer.profileImage AS buyerImg,s.title,s.slug AS serviceSlug,r.description,payment.adminCommission FROM tbl_orders AS o LEFT JOIN tbl_request AS r ON r.id = o.entityId AND o.orderType = 'r' LEFT JOIN tbl_services AS s ON s.id = o.entityId AND o.orderType = 's' INNER JOIN tbl_users AS seller ON seller.id = o.sellerId INNER JOIN tbl_users AS buyer ON buyer.id = o.userId INNER JOIN tbl_payment_history AS payment ON payment.id = o.paymentId WHERE o.status = 'c' AND o.userId = ? AND o.txnId = ?";

		$fetchRes = $this->db->pdoQuery($qry,array($this->sessUserId,$txnId));

		if($fetchRes->affectedRows() > 0){
				$result             = $fetchRes->result();
				$txnId              = $result['txnId'];
				$buyerId            = $result['userId'];
				$sellerId           = $result['sellerId'];
				$amount             = $result['amount'];
				$extraAmount        = $result['extraAmount'];
				$final_amount       = $orderTotalPrice = $amount;

				$couponCode         = issetor($result['couponCode'],"");
				$discountPercentage = issetor($result['discountPercentage'],0);
				$couponeDiscount    = issetor($result['discount'],0);
				$discountHideShow   = 'n';
				$otherFields        = "";
			if($couponCode != "" && $discountPercentage > 0 && $couponeDiscount > 0){
				$discountHideShow = 'y';
				$DiscountFields = array(
									"%COUPON_CODE%" => $couponCode,
									"%DISCOUNT_PERCENTAGE%" => $discountPercentage,
									"%COUPON_DISCOUNT%" => DEFAULT_CURRENCY_CODE.' '.$couponeDiscount,
								);
				$otherFields .= get_view(DIR_TMPL . "discount-invoice-field-nct.tpl.php",$DiscountFields);
				$orderTotalPrice += $couponeDiscount;

			}
			$orderType = $result['orderType'] == 'r' ? LBL_REQUEST : LBL_SERVICE ;
			$deliveryDate = convertDate($result['deliveryDate']);

			$buyerUserName = ucwords(filtering($result['buyerUserName']));
			$sellerUserName = ucwords(filtering($result['sellerUserName']));
			$buyerImg = checkImage($result['buyerImg'],9,$buyerId);
			$sellerImg = checkImage($result['sellerImg'],9,$sellerId);
			$adminCommission = $result['adminCommission'];


			/*"%INVOICE_LBL%"=>($this->sessRequestType != 'app') ? INVOICE : $_REQUEST['invoice'],
				"%BOOKING_ID_LBL%"=>($this->sessRequestType != 'app') ? BOOKING_ID : $_REQUEST['booking_id'],
				"%SERVICE_START_TIME_LBL%"=>($this->sessRequestType != 'app') ? SERVICE_START_TIME : $_REQUEST['service_start_time'],
				"%SERVICE_END_TIME_LBL%"=>($this->sessRequestType != 'app') ? SERVICE_END_TIME : $_REQUEST['service_end_time'],
				"%BOOKING_DETAILS_LBL%"=>($this->sessRequestType != 'app') ? BOOKING_DETAILS : $_REQUEST['booking_details'],
				"%BOOKING_AMOUNT_LBL%"=>($this->sessRequestType != 'app') ? BOOKING_AMOUNT : $_REQUEST['booking_amount'],
				"%ADMIN_FEES_LBL%"=>($this->sessRequestType != 'app') ? ADMIN_FEES : $_REQUEST['admin_fees'],
				"%PAYMENT_TYPE_LBL%"=>($this->sessRequestType != 'app') ? PAYMENT_TYPE : $_REQUEST['payment_type'],
				"%COMPLETED_LBL%"=>($this->sessRequestType != 'app') ? COMPLETED : $_REQUEST['complete'],*/

				/*multi currency change*/
			$orderTotalPrice = exchange($orderTotalPrice,DEFAULT_CURRENCY_CODE,$this->cCode,null,'','display');
			$final_amount = exchange($final_amount,DEFAULT_CURRENCY_CODE,$this->cCode,null,'','display');
			/*multi currency change*/
			global $cCode;
			$fields = array(
				"%ORDER_ID%" => $txnId,
				"%BUYER_IMAGE%" => $buyerImg,
				"%BUYER_NAME%" => $buyerUserName,
				"%SELLER_IMAGE%" => $sellerImg,
				"%SELLER_NAME%" => $sellerUserName,
				"%ORDER_PRICE%" => $cCode.' '. $orderTotalPrice,
				"%TYPE%" => $orderType,
				"%DELIVERY_DATE%" => $deliveryDate,
				"%FINAL_AMOUNT%" => $cCode.' '. $final_amount,
				"%OTHER_FIELDS%" => $otherFields,
			);
			/* $message = "<pre>" . print_r($fields, TRUE);
			sendEmailAddress('gaurav.chavda@ncrypted.com', 'Service Details' . ' - ' . SITE_NM, $message);*/

			$html = get_view(DIR_TMPL . "invoice-nct.tpl.php",$fields);

			if ($txnId != "") {
				$data_array = array(
					"html" => $html,
					"output_file_name" => $txnId . "-invoice.pdf",
					"download" => ($this->sessRequestType == "app") ? "false" : "true",
				);
				$file_name = generatePdfFile($data_array);
			}
			$final_result["data"] = array("file_name" => $file_name);
			$final_result["message"] = "";
			$final_result["type"] = "success";
			$final_result["status"] = true;
			echo json_encode($final_result);
			exit;
		}else{

			$msgType = $_SESSION["msgType"] = disMessage(array('type'=>'err','var'=>MSG_SOMETHING_WRONG));
			redirectPage(SITE_URL.'manage-purchase/');
		}
	}
}

?>
