<?php
class Cart {
	function __construct($contentArray=array()) {
		foreach ($GLOBALS as $key => $values) {
			$this->$key = $values;

		}
		extract($contentArray);
		$this->module = $module;
		$this->id = $id;

	}
	public function getPageContent() {
		$cartList = $this->cartList();
		$tplUrl = DIR_TMPL . $this->module . "/" . $this->module . ".tpl.php";
		$classHideShowForPayment = 'show';
		if($cartList['data']['totalAmount'] <= 0){
			$classHideShowForPayment = 'hide';
		}
		$replaceArr = array('%CART_LIST%'=>$cartList['data']['html'],'%TOTAL_AMOUNT%'=>CURRENCY_SIGN.$cartList['data']['totalAmount'],'%PAYMENT_HIDE_SHOW%'=>$classHideShowForPayment);
		$content = get_view($tplUrl,$replaceArr);
		return $content;
	}

	public function cartList()
	{
		$content = NULL;
		$totalAmount = 0;
		$qry = "SELECT c.*,s.userId AS sellerId,s.title,s.slug,sp.price,sp.extraServicePrice,s.duration,s.durationType
					FROM tbl_cart AS c
				INNER JOIN tbl_services AS s
					ON s.id = c.serviceId
				INNER JOIN tbl_service_packages AS sp
					ON sp.serviceId = c.serviceId AND sp.packageId = c.packageId
				INNER JOIN tbl_users AS u
					ON u.id = s.userId
				WHERE u.isActive = 'y'
					AND s.status = 'a'
					AND s.isActive = 'y'
					AND c.userId = ?
				ORDER BY c.id DESC";

		$list = $this->db->pdoQuery($qry,array($this->sessUserId));
		$NoOfrows = $list->affectedRows();
		if($NoOfrows > 0){
			$cartResults = $list ->results();
			foreach ($cartResults as $key => $cartValue) {
				$cartId            = $cartValue['id'];
				$sellerId          = $cartValue['sellerId'];
				$serviceId         = $cartValue['serviceId'];
				$packageId         = $cartValue['packageId'];
				$title             = filtering($cartValue['title']);
				$slug              = $cartValue['slug'];
				$duration          = $cartValue['duration'];
				$durationType      = $cartValue['durationType'];
				$price             = $cartValue['price'];
				$extraServicePrice = $cartValue['extraServicePrice'];

				$vacationMode =  getTableValue('tbl_users','vacationMode',array('id'=>$sellerId));
				if($vacationMode == 'y'){
					$this->db->pdoQuery("DELETE c FROM tbl_cart AS c INNER JOIN tbl_services AS s ON s.id = c.serviceId WHERE s.userId = ?",array($sellerId));
					$msgType = $_SESSION["msgType"] = disMessage(array('type'=>'err','var'=>MSG_USER_ON_VACATION_MODE));
					redirectPage(SITE_URL.'cart/');
				}

				/*multi currency change*/
	            $price = exchange($price,DEFAULT_CURRENCY_CODE,$this->cCode,$serviceId,'s');
	            $extraServicePrice = exchange($extraServicePrice,DEFAULT_CURRENCY_CODE,$this->cCode,$serviceId,'s');
	            /*multi currency change*/
				$singleTotalAmount = $price + $extraServicePrice;
				$serviceImg        = $this->db->pdoQuery("SELECT fileName FROM tbl_service_gallery WHERE serviceId = ? AND fileType = ?",array($serviceId,'i'))->result();
				$sImg              = checkImage($serviceImg['fileName'],8,$serviceId);
				$totalAmount += $singleTotalAmount;

				if($this->sessRequestType == 'web'){

					$calDeliveryDate = getDeliveryDateForCartItem($duration,$durationType);
					$replaceArr = array(
										'%KEY%'=>$key,
										'%SERVICE_ID%'=>$serviceId,
										'%SERVICE_URL%'=>SITE_URL.'service-details/'.$slug.'/',
										'%SERVICE_IMG%'=>$sImg,
										'%SERVICE_TITILE%'=>$title,
										'%BASE_PRICE%'=>CURRENCY_SIGN.$price,
										'%EXTRA_PRICE%'=>CURRENCY_SIGN.$extraServicePrice,
										'%SINGLE_TOTAL_PRTICE%'=>CURRENCY_SIGN.$singleTotalAmount,
										'%CART_ID%'=>$cartId,
										'%DELIVERY_DATE%'=>convertDate($calDeliveryDate)
										);
					$content .= get_view(DIR_TMPL . $this->module . "/single-cart-list-nct.tpl.php",$replaceArr);
				}
			}
			$retData['html'] = $content;
			$retData['totalAmount'] = $totalAmount;
			$returnResponse = array(
									'status' => true,
									'message'=> '',
									'data'=> $retData,
								);
		}else{
			$retData['html'] = $content;
			$retData['totalAmount'] = $totalAmount;
			if($this->sessRequestType == 'web'){
				$retData['html'] =get_view(DIR_TMPL . $this->module . "/no-record-found-nct.tpl.php");
			}
			$returnResponse = array(
									'status' => true,
									'message'=> '',
									'data'=> $retData,
								);
		}
		return $returnResponse;
	}

	public function removeItem($couponCode = "")
	{
		$whrCond = "";
		if($this->id > 0){
			$whrCond = " AND id = ".$this->id;
		}else{
			$msgType = $_SESSION["msgType"] = disMessage(array('type'=>'suc','var'=>ITEM_REMOVED_FROM_CART_SUC));
		}

		$qry = "DELETE FROM tbl_cart WHERE userId = $this->sessUserId $whrCond";
		$this->db->pdoQuery($qry);

		$sumQuery = "SELECT s.price , s.extraServicePrice,c.serviceId FROM tbl_cart AS c INNER JOIN tbl_service_packages AS s ON s.serviceId = c.serviceId AND s.packageId = c.packageId WHERE c.userId = ?";
		$list = $this->db->pdoQuery($sumQuery,array($this->sessUserId));
		$sumExtraPrice= $sumPrice = 0;
		if($list->affectedRows() > 0){
			$getListItems = $list->results();
			foreach ($getListItems as $key => $listValue) {
				$serviceId = $listValue['serviceId'];
				$price = $listValue['price'];
				$extraServicePrice = $listValue['extraServicePrice'];

				/*multi currency change*/
	            $price = exchange($price,DEFAULT_CURRENCY_CODE,$this->cCode,$serviceId,'s');
	            $extraServicePrice = exchange($extraServicePrice,DEFAULT_CURRENCY_CODE,$this->cCode,$serviceId,'s');
	            /*multi currency change*/
				$sumPrice += $price;
				$sumExtraPrice += $extraServicePrice;
			}

			$amount = $totalAmount = $sumPrice + $sumExtraPrice;
			$retData['totalAmount'] = CURRENCY_SIGN.$totalAmount;
			$retData['finalTotalAmount'] = CURRENCY_SIGN.$amount;
			if($couponCode != ""){
				$discount = getTableValue('tbl_coupon_code','discount',array('code'=>$couponCode));
				$discountAmount= ($totalAmount * $discount) / 100;
				$retData['discountAmount'] = CURRENCY_SIGN.$discountAmount;
				$amount = $totalAmount - $discountAmount;
				$retData['finalTotalAmount'] = CURRENCY_SIGN.$amount;
			}
			if($amount <= 0){

				$retData['reloadPage'] = 'y';
				$msgType = $_SESSION["msgType"] = disMessage(array('type'=>'suc','var'=>ITEM_REMOVED_FROM_CART_SUC));
			}


		}else{
			$retData['reloadPage'] = 'y';
			$msgType = $_SESSION["msgType"] = disMessage(array('type'=>'suc','var'=>ITEM_REMOVED_FROM_CART_SUC));
		}
		$returnResponse = array(
								'status'=>true,
								'message'=>'success',
								'data'=>$retData
									);
		return $returnResponse;
		exit;
	}

	public function applyCouponCode($couponCode='')
	{
		if($couponCode != ""){
			$date = date('Y-m-d H:i:s');


			$sumQuery = "SELECT s.price , s.extraServicePrice,c.serviceId FROM tbl_cart AS c INNER JOIN tbl_service_packages AS s ON s.serviceId = c.serviceId AND s.packageId = c.packageId WHERE c.userId = ?";
			$list = $this->db->pdoQuery($sumQuery,array($this->sessUserId));
			$sumExtraPrice= $sumPrice = 0;
			$getListItems = $list->results();
			foreach ($getListItems as $key => $listValue) {
				$serviceId = $listValue['serviceId'];
				$price = $listValue['price'];
				$extraServicePrice = $listValue['extraServicePrice'];

				/*multi currency change*/
	            $price = exchange($price,DEFAULT_CURRENCY_CODE,$this->cCode,$serviceId,'s');
	            $extraServicePrice = exchange($extraServicePrice,DEFAULT_CURRENCY_CODE,$this->cCode,$serviceId,'s');
	            /*multi currency change*/
				$sumPrice += $price;
				$sumExtraPrice += $extraServicePrice;
			}

			$amount = $totalAmount = $sumPrice + $sumExtraPrice;
			$retData['totalAmount'] = CURRENCY_SIGN.$totalAmount;
			$retData['finalTotalAmount'] = CURRENCY_SIGN.$amount;

			$discountQry = $this->db->pdoQuery("SELECT cc.discount FROM tbl_coupon_code AS cc INNER JOIN tbl_coupon_code_users AS ccu ON cc.id = ccu.couponId WHERE cc.code = ? AND ccu.userId = ? AND ccu.remain > 0 AND cc.startDate <= '$date' AND cc.endDate >= '$date' AND cc.isActive ='y'",array($couponCode,$this->sessUserId));
			if($discountQry->affectedRows() > 0){
				$getData = $discountQry->result();
				$discount = $getData['discount'];
				$discountAmount= ($totalAmount * $discount) / 100;
				$amount = $totalAmount - $discountAmount;
				$amount = round($amount,2);
				$discountAmount = round($discountAmount,2);
				$retData['finalTotalAmount'] = CURRENCY_SIGN.$amount;
				$retData['discountPercentage'] = $discount.'%';
				$retData['discountAmount'] = CURRENCY_SIGN.$discountAmount;
				$returnResponse = array(
									'status'=>true,
									'message'=>'success',
									'data'=>$retData
										);
			}else{

				$returnResponse = array(
									'status'=>false,
									'message'=>INVALID_COUPON_CODE,
									'data'=>array()
										);
			}

		}else{
			$returnResponse = array(
									'status'=>false,
									'message'=>MSG_SOMETHING_WRONG,
									'data'=>array()
										);
		}
		return $returnResponse;
		exit;
	}

	public function submitCart($request=array())
	{
		extract($request);
		$applyedCouponCode = issetor($applyedCouponCode);

		/*foreach ($deliveryDate as $key => $value) {
			$this->db->pdoQuery("UPDATE tbl_cart SET deliveryDate = ? WHERE id = ?",array($value,$key));
		}*/
		$date = date('Y-m-d H:i:s');

		$qry = "SELECT c.*,sp.price,sp.extraServicePrice,s.userId AS sellerId,s.duration,s.durationType
					FROM tbl_cart AS c
				INNER JOIN tbl_services AS s
					ON s.id = c.serviceId
				INNER JOIN tbl_service_packages AS sp
					ON sp.serviceId = c.serviceId AND sp.packageId = c.packageId
				INNER JOIN tbl_users AS u
					ON u.id = s.userId
				WHERE u.isActive = 'y'
					AND s.status = 'a'
					AND s.isActive = 'y'
					AND c.userId = ?";

		$cartList = $this->db->pdoQuery($qry,array($this->sessUserId));
		if($cartList->affectedRows() > 0){
			$cartResult = $cartList->results();
			$totalAmount = 0;
			foreach ($cartResult as $key => $cartValue) {
				//updateting cart delivery date
				$calDeliveryDate = getDeliveryDateForCartItem($cartValue['duration'],$cartValue['durationType']);
				$this->db->pdoQuery("UPDATE tbl_cart SET deliveryDate = ? WHERE id = ?",array($calDeliveryDate,$cartValue['id']));
				//updateting cart delivery date

				$sellerId = $cartValue['sellerId'];
				$vacationMode =  getTableValue('tbl_users','vacationMode',array('id'=>$sellerId));
				if($vacationMode == 'y'){
					$this->db->pdoQuery("DELETE c FROM tbl_cart AS c INNER JOIN tbl_services AS s ON s.id = c.serviceId WHERE s.userId = ?",array($sellerId));
					$msgType = $_SESSION["msgType"] = disMessage(array('type'=>'err','var'=>MSG_USER_ON_VACATION_MODE));
					redirectPage(SITE_URL.'cart/');
				}

				$price             = $cartValue['price'];
				$extraServicePrice = $cartValue['extraServicePrice'];
				$singleTotalAmount = $price + $extraServicePrice;
				$totalAmount += $singleTotalAmount;
			}
			$amount = strval($totalAmount);
			$adminCommission = ($amount * ADMIN_COMMISSION) / 100;

			if($applyedCouponCode != ""){
				$discountQry = $this->db->pdoQuery("SELECT cc.discount AS discountPercentage,cc.id AS couponCodeId FROM tbl_coupon_code AS cc INNER JOIN tbl_coupon_code_users AS ccu ON cc.id = ccu.couponId WHERE cc.code = ? AND ccu.userId = ? AND ccu.remain > 0 AND cc.startDate <= '$date' AND cc.endDate >= '$date' AND cc.isActive ='y'",array($applyedCouponCode,$this->sessUserId));
				if($discountQry->affectedRows() > 0){
					$getData = $discountQry->result();

					$couponCodeId = $getData['couponCodeId'];

					$discountPercentage = $getData['discountPercentage'];

					$discount= ($amount * $discountPercentage) / 100;

					$amount = $amount - $discount;

					$paymentInsArr['couponCode'] = $applyedCouponCode;
					$paymentInsArr['couponCodeId'] = $couponCodeId;
					$paymentInsArr['discount'] = strval($discount);
					$paymentInsArr['discountPercentage'] = $discountPercentage;
				}else{
					$msgType = $_SESSION["msgType"] = disMessage(array('type'=>'err','var'=>INVALID_COUPON_CODE));
					redirectPage(SITE_URL.'cart/');
				}
			}

			$paymentInsArr['userId'] = $this->sessUserId;
			$paymentInsArr['txnTypeId'] = 1; //1 is used for cart_purchase
			$paymentInsArr['amount'] = strval($amount);
			$paymentInsArr['adminCommission'] = strval($adminCommission);
			$paymentInsArr['createdDate'] = $date;
			$paymentInsArr['ipAddress'] = get_ip_address();
			$payment_history_id = $this->db->insert('tbl_payment_history', $paymentInsArr)->lastInsertId();

			$en_action_cancel = '/' . base64_encode($payment_history_id);
			$url_paypal = PAYPAL_URL;
			$url_paypal .= "?business=" . urlencode(PAYPAL_EMAIL);
			$url_paypal .= "&cmd=" . urlencode('_xclick');
			$url_paypal .= "&item_name=Deposit to wallet- " . urlencode(SITE_NM);
			$url_paypal .= "&item_number=" . urlencode($payment_history_id);
			$url_paypal .= "&custom=" . urlencode($payment_history_id . '__' . $this->sessUserId);
			$url_paypal .= "&amount=" . urlencode($amount);
			$url_paypal .= "&currency_code=" . urlencode(PAYPAL_CURRENCY_CODE);
			$url_paypal .= "&handling=" . urlencode('0');
			$url_paypal .= "&rm=" . urlencode('2');
			$url_paypal .= "&bn=" . urlencode('NCryptedTechnologies_SP_EC');

			if (strpos($_SERVER["SERVER_NAME"], '192.168.100') !== false || $_SERVER["SERVER_NAME"] == 'localhost' || strpos($_SERVER["SERVER_NAME"], 'nct') !== false) {
				$url_paypal .= "&return=" . urlencode(SITE_URL . 'cart-notify/');
			} else {
				$url_paypal .= "&return=" . urlencode(SITE_URL . 'cart-thankyou/');
			}
			$url_paypal .= "&cancel_return=" . urlencode(SITE_URL . 'cart-failed' . $en_action_cancel);
			$url_paypal .= "&notify_url=" . urlencode(SITE_URL . 'cart-notify/');

			redirectPage($url_paypal);

		}else{

			$msgType = $_SESSION["msgType"] = disMessage(array('type'=>'err','var'=>MSG_SOMETHING_WRONG));
			redirectPage(SITE_URL.'cart/');
		}


	}
}

?>
