function getPaginationData(page){
	page = (page && page !== null && page !== undefined && page > 0) ? page : 1;
	var fil_status = $("#fil_status").val();
	var fil_from_date = $("#fil_from_date").val();
	var fil_to_date = $("#fil_to_date").val();
	$.ajax({
		url: currentPageURL,
		type: "POST",
		cache:false,
		data: {
			action: 'ajaxPagination',
			page: page,
			status:fil_status,
			from_date:fil_from_date,
			to_date:fil_to_date
		},
		dataType : 'json',
		beforeSend : function(){
			showLoader();
		},
		success: function(data) {
			$(".contact-table .inner_loader").remove();
			$(".contact-table .tbody").remove();
			$(".redeem_request_div").append(data.html);
			if(data.status == true){
				$(".pagination_div").html(data.pagination);
				$('.export_tocsv_records_div').show();
			}
			else{
				$('.export_tocsv_records_div').hide();
				$(".pagination_div").html('');
			}
			//scrollToElement(".cvv-form");
			hideLoader();

		}
	});
}

function completesubmit(response){
	$(".redeem_request_modal_content #RedeemRequestModal").modal('hide');
	if(response.redirectLink && response.redirectLink !== null && response.redirectLink !== undefined && response.redirectLink != ''){
		window.location.href = response.redirectLink;
	}
}

$(document).on('change', '.chkBox', function(event) {
	if($("#user_view").prop('checked') == true){
		$(".seller_values").hide();
		$(".buyer_values").show();
	}
	else{
		$(".buyer_values").hide();
		$(".seller_values").show();
	}
	$("#user_view").closest('.switch').toggleClass('checked');
});

$(document).ready(function(){
	var startDate;
    var endDate;
   $("#fil_from_date").datetimepicker({
       format: "yyyy-mm-dd",
       minView : 2,
       pickTime: false,
       autoclose:true
   }).on('change', function (ev) {
        $('#fil_to_date').val('');
        startDate = $("#fil_from_date").val();
        $('#fil_to_date').datetimepicker('setStartDate', startDate);
        getPaginationData(1);
   });
   $("#fil_to_date").datetimepicker({
       format: "yyyy-mm-dd",
       minView : 2,
       pickTime: false,
       autoclose:true
   }).on('change', function (ev) {
        endDate = $("#fil_to_date").val();
        if($('#fil_from_date').val() == '') {$('#fil_from_date').datetimepicker('setEndDate', endDate); }
        getPaginationData(1);
   });
    getPaginationData(1);
});

$(document).on("click",".buttonPage",function(){
	var pageNo = $(this).data('page');
	getPaginationData(pageNo);
});

$(document).on('change','#fil_status',function(){
	getPaginationData(1);
});

$(document).on('click','.clear_from_date',function(){
	$("#fil_from_date").val('');
	$('#fil_from_date').datetimepicker('setEndDate', null);
	getPaginationData(1);
});

$(document).on('click','.clear_to_date',function(){
	$("#fil_to_date").val('');
	$('#fil_to_date').datetimepicker('setStartDate', null);
	getPaginationData(1);
});



$(document).on("click",".redeem_money_mow",function(){
	$.ajax({
		url: currentPageURL,
		type: "POST",
		cache:false,
		data: {
			action: 'getReddemRequestContent'
		},
		dataType : 'json',
		beforeSend : function(){
			showLoader();
		},
		success: function(data) {
			if(data.status == true){
				$(".redeem_request_modal_content").html(data.data);
				$("#paymentMode").selectpicker();
				$(".redeem_request_modal_content #RedeemRequestModal").modal('show');
			}
			else{
				if(data.message != ''){
					toastr['error'](data.message);
				}
			}
			hideLoader();
		}
	});
});
$(document).on("click",".cancel_redeem_now",function(){
	var rid = $(this).data('id');
	if(confirm(lang.REVENUE_PAGE_MSG_CONFIRM_CANCEL) && rid > 0 ){
		$.ajax({
			url: currentPageURL,
			type: "POST",
			cache:false,
			data: {
				action: 'cancelRedeemRequest',
				rid : rid
			},
			dataType : 'json',
			beforeSend : function(){
				showLoader();
			},
			success: function(data) {
				
				if(data.status == true){
					if(data.message != ''){
						//toastr['success'](data.message);
					}
					if(data.redirectLink && data.redirectLink !== null && data.redirectLink !== undefined && data.redirectLink != ''){
						window.location.href = data.redirectLink;
					}
				}
				else{
					if(data.message != ''){
						toastr['success'](data.message);
					}
				}
				hideLoader();
			}
		});
	}
});
$(document).on("click",".export_tocsv_records",function(){
	var fil_status = $("#fil_status").val();
	var fil_from_date = $("#fil_from_date").val();
	var fil_to_date = $("#fil_to_date").val();
	$.ajax({
		url: currentPageURL,
		type: "POST",
		cache:false,
		data: {
			action: 'exportReddemRequestToCsv',
			status:fil_status,
			from_date:fil_from_date,
			to_date:fil_to_date
		},
		dataType : 'json',
		beforeSend : function(){
			showLoader();
		},
		success: function(data) {
			
			if(data.status == true){
				if(data.message != ''){
					toastr['success'](data.message);
				}
				if(data.redirectLink && data.redirectLink !== null && data.redirectLink !== undefined && data.redirectLink != ''){
					window.location.href = data.redirectLink;
				}
			}
			else{
				if(data.message != ''){
					toastr['success'](data.message);
				}
			}
			hideLoader();
		}
	});
});


$(document).on('submit','#frmReddemRequest',function(){
	$("#frmReddemRequest").validate({
		rules:{
			amount:{required:true,digits:true,min:1},
			paymentMode:{required:true},
		},
		messages:{
			amount:{required:lang.REVENUE_PAGE_MSG_ENTER_AMOUNT,digits:lang.REVENUE_PAGE_MSG_ONLY_DIGITS,min:lang.REVENUE_PAGE_MSG_MINIMUM_ONE},
			paymentMode:{required:lang.REVENUE_PAGE_MSG_SELECT_PAYMENT_METHOD},
		},
		highlight: function (element, errorClass, validClass) {
		},            
		unhighlight: function (element, errorClass, validClass) {
		},
		errorPlacement: function (error, element) { 
			if (element.attr("data-error-container")){
				error.appendTo(element.attr("data-error-container"));
			} else {
				error.insertAfter(element);
			}
			error.addClass('error');
		}
	});
	if($("#frmReddemRequest").valid()){
        ajaxFormSubmit("form#frmReddemRequest","completesubmit");
        return false;
    }else{
        return false;
    }
});