function getPaginationData(page){
	page = (page && page !== null && page !== undefined && page > 0) ? page : 1;
	$.ajax({
		url: window.location.href,
		type: "POST",
		cache:false,
		data: {
			action: 'ajaxPagination',
			page: page,
		},
		dataType : 'json',
		beforeSend : function(){
			showLoader();
		},
		success: function(data) {
			$(".services_list_div").html(data.html);
			if(data.status == true){
				$(".pagination_div").html(data.pagination);
			}
			else{
				$(".pagination_div").html('');
			}
			dispRatting();
			scrollToElement(".trending_upper_block");
			hideLoader();
		}
	});
}

$(document).ready(function($) {
	$(document).on("click",".buttonPage",function(){
		var pageNo = $(this).data('page');
		getPaginationData(pageNo);
	});
	$('[data-toggle="tooltip"]').tooltip();
	getPaginationData(1);

	$(document).on('click', '.deleteCollectionService', function(event) {
		if (confirm(lang.MSG_CONFIRM_DELETE_SERVICE_COLLECTION)) {
			return true;
		}else{
			return false;
		}
	});
});