cartUrl = siteUrl+'cart/'
var todayDate = new Date().getDate();

$(document).ready(function() {
    $formCart = "#formCart";

    $($formCart).validate({
        highlight: function(element, errorClass, validClass) {
            $(element).closest('.form-group').addClass('has-error');
        },
        unhighlight: function(element, errorClass, validClass) {
            $(element).closest('.form-group').removeClass('has-error');
        },
        errorPlacement: function(error, element) {
            if (element.attr("data-error-container")) {
                error.appendTo(element.attr("data-error-container"));
            } else {
                error.insertAfter(element);
            }
        }
    });
    $(document).on('submit', $formCart, function() {
        if ($($formCart).valid()) {
            $("#sbtCart").addClass('btn_disabled');
            showLoader();
            return true;
        } else {
            return false;
        }
    });
    $("[name^=deliveryDate").each(function() {
        $(this).rules("add", {
            required: true,
            messages: {
                required: lang.MSG_DELE_DATE_REQ
            }
        });
    });
    $('.deliveryDatePicker').each(function(){
            $(this).datetimepicker({
                startDate: new Date(new Date().setDate(todayDate + 7)),
                format: "yyyy-mm-dd",
                minView : 2,
                pickTime: false,
                autoclose:true
           });
    });

    $(document).on('click', '#removeAll', function(event) {
        event.preventDefault();
        var $this = $(this);
        if($('.cartData').length > 0){
            removeItem($this);
        }
    });
    $(document).on('click', '.removeSingle', function(event) {
        event.preventDefault();
        var $this = $(this);
        var cartId = $this.attr('data-id');
        removeItem($this,cartId);
    });
    $("#couponCode").keypress(function(e) {
        if (e.which === 13) {
        $("#applyCode").trigger('click');
        return false;
      }
    });
    $(document).on('click', '#applyCode', function(event) {
        event.preventDefault();
        var couponCode = $("#couponCode").val();
        if(couponCode.length > 0){
             $.ajax({
                url: cartUrl,
                type: 'POST',
                data: {
                        couponCode : couponCode,
                        action: 'applyCouponCode'
                    },
                dataType: 'json',
                beforeSend: function() {
                    showLoader();
                },
                success: function(response) {
                    if(response.status){
                        addCoupon();
                        $(".discountDiv").removeClass('hide');
                        $("#applyedCouponCode").val(couponCode);
                        $('#finalTotalAmount').html(response.data.finalTotalAmount);
                        $('#discountPercentage').html(response.data.discountPercentage);
                        $('#totalAmount').html(response.data.totalAmount);
                        $('#discountAmount').html(response.data.discountAmount);
                    }else{
                        removeCoupon();
                        toastr['error'](response.message);
                    }
                    hideLoader();
                },
                error: function(response) {
                    hideLoader();
                    $(function() {
                        toastr['error'](lang.MSG_SOMETHING_WRONG);
                    });
                }
            });
         }
    });

    $(document).on('click', '#removeCode', function(event) {
        event.preventDefault();
        if (confirm(lang.MSG_CONF_REMOVE_COUPON_CODE)) {
            removeCoupon();
            $("#applyCode").removeAttr('disabled');
            $("#couponCode").removeAttr('disabled');
            $("#applyCode").html(APPLY);
            $(this).addClass('hide');
            $("#couponCode").val('');
            $("#applyedCouponCode").val('');
        }
    });


});

function addCoupon() {
    $("#applyCode").attr('disabled', 'true');
    $("#couponCode").attr('disabled', 'true');
    $("#applyCode").html(APPLIED);
    $("#removeCode").removeClass('hide');
}
function removeCoupon() {
    $(".discountDiv").addClass('hide');
    $("#applyedCouponCode").val();
    $('#finalTotalAmount').html($('#totalAmount').html());
}
function removeItem($this = "" ,cartId = 0) {
    var couponCode = $("#applyedCouponCode").val();
    if (confirm(lang.MSG_CONFIRM_DELETE_ITEM)) {
        $.ajax({
            url: cartUrl,
            type: 'POST',
            data: {
                    id : cartId,
                    couponCode : couponCode,
                    action: 'removeItem'
                },
            dataType: 'json',
            beforeSend: function() {
                showLoader();
            },
            success: function(response) {
                if(response.status){
                    if(cartId <= 0){
                        window.location.reload();
                    }else{
                        if(response.data.reloadPage == 'y'){
                            window.location.reload();
                        }else{
                            $this.closest('.tbody').remove();
                            $('#finalTotalAmount').html(response.data.finalTotalAmount);
                            $('#discountAmount').html(response.data.discountAmount);
                            $('#totalAmount').html(response.data.totalAmount);
                        }
                    }
                }
                hideLoader();
            },
            error: function(response) {
                hideLoader();
                $(function() {
                    toastr['error'](lang.MSG_SOMETHING_WRONG);
                });
            }
        });
    }
}