$(document).ready(function() {
    $.validator.addMethod('customvalidation',function (value, element) {
        if(this.optional(element) || /<\/?[^>]+(>|$)/g.test(value)){
            return false;
        } else {
            return true;
        }
        },lang.INVALID_VALUE_ENTERED
    );
	$('#formCollection').validate({
		ignore:"",
        rules: {
            name: {
                required: true,
                customvalidation:true
            },
            description: {
                required: true,
                customvalidation:true
            },
            image:{
            	required:true,
            }
        },
        messages: {
            name: {
                required: lang.MSG_PLEASE_ENTER_NAME,
            },
            description: {
                required: lang.MSG_DESC_REQ
            },
            image: {
                required: lang.MSG_PLEASE_SELECT_IMAGE
            }
        },
        highlight: function (element, errorClass, validClass) {
            $(element).closest('.form-group').addClass('has-error');
        },
        unhighlight: function (element, errorClass, validClass) {
            $(element).closest('.form-group').removeClass('has-error');
        },
        errorPlacement: function (error, element) {
            if (element.attr("data-error-container")) {
                error.appendTo(element.attr("data-error-container"));
            } else {
                error.insertAfter(element);
            }
        }
    });

    //////cropping/////

    $(document).on('change', '#file', function(event) {
        var _this = $(this);
        var value = _this.val();
        var allowedFiles = ["jpg", "jpeg", "png"];
        var extension = value.split('.').pop().toLowerCase();
        if (value && value != '') {
            if ($.inArray(extension, allowedFiles) < 0) {
                toastr['info'](lang.MSG_PLEASE_SELECT_VALID_IMAGE);
                _this.val("");
            } else {
                if ($.inArray(extension, allowedFiles) >= 0) {
                    if (getSize(this.files[0].size) > IMG_SIZE) {
						var msgValidation =  lang.MSG_IMAGE_SIZE_VALIDATION.replace("%SIZE%", IMG_SIZE);
						_this.val("");
                        toastr['info'](msgValidation);
                    } else {
                        var url = URL.createObjectURL(event.target.files[0]);
                        var img = $('<img src="' + url + '">');
                        $('.avatar-wrapper').empty().html('<img src="' + url + '">');
                        $('#avatar-modal').modal('show');
                    }
                } else {
                    toastr['info'](lang.MSG_PLEASE_SELECT_VALID_IMAGE);
                  	_this.val("");

                }
            }
        } else {
        	_this.val("");
            event.preventDefault();
        }
    });
    $(document).on('hidden.bs.modal', '#avatar-modal', function() {
        $('.avatar-wrapper img').cropper('destroy');
        $('.avatar-wrapper').empty();
        $("#file").val("");
    });
    $(document).on('shown.bs.modal', '#avatar-modal', function() {
        $('.avatar-wrapper img').cropper({
            aspectRatio: 1 / 1,
            strict: true,
            responsive: true,
            viewMode: 1,
            zoomable: true,
            zoomOnTouch: true,
            zoomOnWheel: true,
            responsive: true,
            movable: true,
            crop: function(e) {
                var json = ['{"x":' + e.x, '"y":' + e.y, '"height":' + e.height, '"width":' + e.width, '"rotate":' + e.rotate + '}'].join();
                $('.avatar-data').val(json);
            }
        });
    });
    $(document).on('click', '#btnCrop', function(evn) {
        evn.preventDefault();
        var avatarForm = $('.avatar-form');
        var frmCont = $('#formCollection');
        var url = siteUrl+'collection-crop';
        var data = new FormData(frmCont[0]);
        data.append('avatar_src', $('#avatar_src').val());
        data.append('avatar_data', $('#avatar_data').val());
        $.ajax(url, {
            type: 'post',
            data: data,
            dataType: 'json',
            processData: false,
            contentType: false,
            beforeSend: function() {
                showLoader();
            },
            success: function(data) {
                console.log(data);
                if (data.state == 200) {
                	$("#divImg").removeClass('hide');
                	$("#divImg").find('img').attr('src',data.source);
                    $('#fileCnt').html('<img src="' + data.source + '" width="300px" style="margin-top: 10px;">');
                    $("#file").val("");
                    $('#hiddenImg').val(data.image);
                    $('#image').val(data.image);
                    $('#image').valid();
                    $('#avatar-modal').modal('hide');
                } else {}
            },
            complete: function() {
                hideLoader();
            }
        });
    });
    //////cropping/////

    $(document).on('click', '.removeIcon', function(event) {
    	event.preventDefault();
    	/* Act on the event */
    	$('#divImg').addClass('hide');
    	$("#image").val("");
    });
});

function getSize(size = 0){

    fileSize = size / 1048576; //size in mb
    fileSize = Math.round(fileSize);
	return fileSize;
}