$(document).ready(function() {
	$("#connectFrm").validate({
        ignore:"",
        rules: {
            fbLink: {
                /*required: true,*/
                url: true
            },
            gpLink: {
                /*required: true,*/
                url: true
            },
            linkedinLink: {
                /*required: true,*/
                url: true
            },
            stackLink: {
                /*required: true,*/
                url: true
            },
            dribbleLink: {
                /*required: true,*/
                url: true
            }
        },
        messages: {
            fbLink: {
                required: lang.MSG_FB_LINK_REQ,
                url:lang.MSG_ENTER_VALID_URL,
            },
            gpLink: {
                required: lang.MSG_GP_LINK_REQ,
                url:lang.MSG_ENTER_VALID_URL,
            },
            linkedinLink: {
                required: lang.MSG_LI_LINK_REQ,
                url:lang.MSG_ENTER_VALID_URL,
            },
            stackLink: {
                required: lang.MSG_SO_LINK_REQ,
                url:lang.MSG_ENTER_VALID_URL,
            },
            dribbleLink: {
                required: lang.MSG_DL_LINK_REQ,
                url:lang.MSG_ENTER_VALID_URL,
            },
        },
        errorPlacement: function (error, element) {
            if (element.attr("data-error-container")) {
              error.appendTo(element.attr("data-error-container"));
            } else {
              error.insertAfter(element);
            }
        }
    });
    $(document).on('submit', '#connectFrm', function(event) {
    	event.preventDefault();
    	var formData = new FormData(this);
		formData.append('action', 'submitSocialDetail');
    	postSubmitForm(formData);
    });

    $("#deactivateForm").validate({
        ignore:"",
        rules: {
            reason: {
                required: true,
            }

        },
        messages: {
            reason: {
                required: lang.MSG_PLEASE_SELECT_REASON,
            },
        },
        errorPlacement: function (error, element) {
            if (element.attr("data-error-container")) {
              error.appendTo(element.attr("data-error-container"));
            } else {
              error.insertAfter(element);
            }
        }
    });
    $(document).on('submit', '#deactivateForm', function(event) {
        event.preventDefault();
        if($('#deactivateForm').valid()){
            if (confirm(lang.MSG_CONFIRM_DEACTIVATE_ACCOUNT)) {
                var formData = new FormData(this);
                formData.append('action', 'submitDeactivateAccount');
                postSubmitForm(formData);
            }
        }
    });

    $("#securityForm").validate({
        ignore:"",
        rules: {
            questionId: {
                required: true,
            },
            answer: {
                required: true,
            },

        },
        messages: {
            questionId: {
                required: lang.MSG_PLEASE_SELECT_QUESTION,
            },
            answer: {
                required: lang.MSG_ENTER_ANSWER,
            },
        },
        errorPlacement: function (error, element) {
            if (element.attr("data-error-container")) {
              error.appendTo(element.attr("data-error-container"));
            } else {
              error.insertAfter(element);
            }
        }
    });
    $(document).on('submit', '#securityForm', function(event) {
        event.preventDefault();
        if($('#securityForm').valid()){
            var formData = new FormData(this);
            formData.append('action', 'submitSecurityQuestion');
            postSubmitForm(formData);
        }
    });

    $("#billingForm").validate({
        ignore:"",
        rules: {
            countryId: {
                required: true,
            },
            businessName: {
                required: true,
            },
            address1: {
                required: true,
            },
            address2: {
                required: true,
            },
            vatId: {
                required: true,
            },

        },
        messages: {
            countryId: {
                required: lang.MSG_PLEASE_SELECT_COUNTY,
            },
            businessName: {
                required: lang.MSG_ENTER_BUSINESS_NAME,
            },
            address1: {
                required: lang.MSG_ENTER_ADDRESS_ONE,
            },
            address2: {
                required: lang.MSG_ENTER_ADDRESS_TWO,
            },
            vatId: {
                required: lang.MSG_ENTER_VATID,
            },
        },
        errorPlacement: function (error, element) {
            if (element.attr("data-error-container")) {
              error.appendTo(element.attr("data-error-container"));
            } else {
              error.insertAfter(element);
            }
        }
    });
    $(document).on('submit', '#billingForm', function(event) {
        event.preventDefault();
        if($('#billingForm').valid()){
            var formData = new FormData(this);
            formData.append('action', 'submitBillingDetail');
            postSubmitForm(formData);
        }
    });

    /*
    $(document).on('submit', '#notificationForm', function(event) {
        event.preventDefault();
        if($('#notificationForm').valid()){
            var formData = new FormData(this);
            formData.append('action', 'submitNotification');
            postSubmitForm(formData);
        }
    });
    */
    $(document).on('change', '.chkBox', function(event) {
        $(this).closest('.switch').toggleClass('checked');
    });
    $(document).on('change', '.notification_checkbox', function(event) {
        var notification = $(this).val();
        var formData = new FormData();
        formData.append('action', 'submitNotification');
        formData.append('notification', notification);
        postSubmitForm(formData);
    });

    $("#bankDetailForm").validate({
        ignore:"",
        rules: {
            bankName: {
                required: true,
            },
            bankAccountNumber: {
                required: true,
            },
            bankIfscCode: {
                required: true,
            },
            bankAccountName: {
                required: true,
            },
            paypalEmail: {
                required: true,
                email: true,
            },
        },
        messages: {
            bankName: {
                required: lang.MSG_PLEASE_ENTER_BANK_NAME,
            },
            bankAccountNumber: {
                required: lang.MSG_PLEASE_ENTER_BANK_AC_NO,
            },
            bankIfscCode: {
                required: lang.PLEASE_ENTER_BANK_IFSC_CODE,
            },
            bankAccountName: {
                required: lang.PLEASE_ENTER_BANK_AC_HOLDER_NAME,
            },
            paypalEmail: {
                required: lang.PLEASE_ENTER_PAYMENT_GATEWAY_ID,
                email:lang.PLEASE_ENTER_VALID_PAYMENT_GATEWAY_ID,
            },
        },
        errorPlacement: function (error, element) {
            if (element.attr("data-error-container")) {
              error.appendTo(element.attr("data-error-container"));
            } else {
              error.insertAfter(element);
            }
        }
    });
    $(document).on('submit', '#bankDetailForm', function(event) {
        event.preventDefault();
        if($('#bankDetailForm').valid()){
            var formData = new FormData(this);
            formData.append('action', 'submitBankDetails');
            postSubmitForm(formData);
        }
    });

    window.fbAsyncInit = function() {
    FB.init({
        appId: FB_APP_ID,
        cookie: true,
        xfbml: true,
        version: 'v2.11'
    });

    FB.AppEvents.logPageView();

    };
    (function(d, s, id) {
        var js, fjs = d.getElementsByTagName(s)[0];
        if (d.getElementById(id)) {
            return;
        }
        js = d.createElement(s);
        js.id = id;
        js.src = "https://connect.facebook.net/en_US/sdk.js";
        fjs.parentNode.insertBefore(js, fjs);
    }(document, 'script', 'facebook-jssdk'));

    $(document).on('click', '#fb_login', function() {
        fb_login(); /*function located in includes-nct/javascript-nct/nct-js.js*/
    });

    (function() {
        var po = document.createElement('script');
        po.type = 'text/javascript';
        po.async = true;
        po.src = 'https://apis.google.com/js/client.js?onload=onLoadCallback';
        var s = document.getElementsByTagName('script')[0];
        s.parentNode.insertBefore(po, s);
    })();

    $("#google_login").click(function() {
        initGmailLogin(); /*function located in includes-nct/javascript-nct/nct-js.js*/
    });
    $("#li_login").click(function() {
        onLinkedInLoad(); /*function located in includes-nct/javascript-nct/nct-js.js*/
    });
});


function postSubmitForm(formData) {
    $.ajax({
        url: SITE_URL+'account-settings/',
        type: 'post',
        data: formData,
        dataType: 'json',
        contentType: false,
        processData: false,
        beforeSend: function() {
            showLoader();
        },
        success: function(response) {
            if(response.redirectLink != ""){
                window.location.href = response.redirectLink;
            }else if(response.message !=""){
                toastr[response.type](response.message);
                hideLoader();
            }else{
                hideLoader();
            }

        },
        error: function(response) {
            hideLoader();
            $(function() {
                toastr['error'](lang.MSG_SOMETHING_WRONG);
            });
        }
    });
}