<?php

class Users extends Home {

    public $data = array();

    public function __construct($module, $id = 0, $objPost = NULL, $searchArray = array(), $type = '') {
        global $db, $fields, $sessCataId;
        $this->db = $db;
        $this->data['id'] = $this->id = $id;
        $this->fields = $fields;
        $this->module = $module;
        $this->table = 'tbl_users';

        $this->type = ($this->id > 0 ? 'edit' : 'add');
        $this->searchArray = $searchArray;
        parent::__construct();
        if ($this->id > 0) {
            $query = "SELECT u.*
                    FROM tbl_users u
                    WHERE u.isActive != 'd' AND u.id = '" . $this->id . "' ";

            $qrySel = $this->db->pdoQuery($query)->result();

            $fetchRes = $qrySel;

            $this->data['userName'] = $this->userName = filtering($fetchRes['userName']);
            $this->data['email'] = $this->email = filtering($fetchRes['email']);
            $this->data['createdDate']    = $this->createdDate = filtering($fetchRes['createdDate']);
            $this->data['aboutMe']        = $this->aboutMe = isset($fetchRes['aboutMe']) ? filtering($fetchRes['aboutMe']) : '';
            $this->data['profileImage']     = $this->profileImage = checkImage('profile/'.$this->id.'/th3_',$fetchRes['profileImage']);
            $this->data['profileImageName'] = $this->profileImageName = filtering($fetchRes['profileImage']);
            $this->data['isActive']       = $this->isActive = $fetchRes['isActive'];
            $this->data['profileVideo']       = $this->profileVideo = $fetchRes['profileVideo'];
            $this->data['profileVideoStatus']       = $this->profileVideoStatus = $fetchRes['profileVideoStatus'];

        } else {

            $this->data['userName'] = $this->userName = "";
            $this->data['email'] = $this->email = "";
            $this->data['createdDate']    = $this->createdDate = "";
            $this->data['aboutMe']        = $this->aboutMe = "";
            $this->data['profileImage']     = $this->profileImage = "";
            $this->data['profileImageName'] = $this->profileImageName = "";
            $this->data['profileVideo']       = $this->profileVideo = '';
            $this->data['profileVideoStatus']       = $this->profileVideoStatus = 'p';
            $this->data['isActive']       = $this->isActive = 'n';

        }
        switch ($type) {
            case 'add' : {
                    $this->data['content'] = (in_array('add', $this->Permission)) ? $this->getForm() : '';
                    break;
                }
            case 'edit' : {
                    $this->data['content'] = (in_array('edit', $this->Permission)) ? $this->getForm() : '';
                    break;
                }
            case 'view' : {
                    $this->data['content'] = (in_array('view', $this->Permission)) ? $this->viewForm() : '';
                    break;
                }
            case 'viewProfileVideo' : {
                    $this->data['content'] =$this->viewProfileVideo();
                    break;
                }
            case 'delete' : {
                    $this->data['content'] = (in_array('delete', $this->Permission)) ? json_encode($this->dataGrid()) : '';
                    break;
                }
            case 'datagrid' : {
                    $this->data['content'] = (in_array('module', $this->Permission)) ? json_encode($this->dataGrid()) : '';
                }
        }
    }

    public function viewForm() {
        $content = NULL;
        $content =
                $this->displayBox(array("label" => "UserName&nbsp;:", "value" => $this->userName)) .
                $this->displayBox(array("label" => "Email&nbsp;:", "value" => $this->email)) .
                $this->displayBox(array("label" => "About User&nbsp;:", "value" => $this->aboutMe)) .
                $this->displayBox(array("label" => "Created Date&nbsp;:", "value" => $this->createdDate)) .
                $this->displayBox(array("label" => "Status&nbsp;:", "value" => $this->isActive == 'y' ? 'Active' : 'Deactive'));

        return $content;
    }


    public function viewProfileVideo() {
        $content = NULL;
        if($this->profileVideo != "" && file_exists(DIR_UPD.'profile-video/'.$this->id.'/'.$this->profileVideo)){
            $videoUrl = SITE_UPD.'profile-video/'.$this->id.'/'.$this->profileVideo;
            $videoHtml = '<video width="320" height="240" controls>
                              <source src="'.$videoUrl.'" type="video/mp4">
                              <source src="'.$videoUrl.'" type="video/ogg">
                            Your browser does not support the video tag.
                            </video>';

            if($this->profileVideoStatus == 'p'){

                $profileVideoStatusHtml =  '<span><a href="ajax.'. $this->module . '.php?action=profileVideoStatus&id='.$this->id.'&status=a" data-action ="Accepted" class="btn default btn-xs green btn-accept approval"><i class="fa fa-check">
                    </i>&nbsp;Accept</a></span>';
                $profileVideoStatusHtml .=  '&nbsp;<span> <a href="ajax.'. $this->module . '.php?action=profileVideoStatus&id='.$this->id.'&status=r" data-action ="Rejected" class="btn default btn-xs red btn-accept approval"><i class="fa fa-times"></i>&nbsp;Reject</a></span>';
            }else{
                $profileVideoStatusHtml =  $this->profileVideoStatus == 'a' ? 'Accepted' : 'Rejected';
            }
            $content =
                $this->displayBox(array("label" => "Video &nbsp;:", "value" => $videoHtml)) .'<BR>'.
                $this->displayBox(array("label" => "Video Status&nbsp;:", "value" => $profileVideoStatusHtml));
        }else{
            $content = '<center>No video found</center>';
        }

        return $content;
    }

    public function getForm() {
        $content = '';

        $getSelectBoxOption = $this->getSelectBoxOption();
        $fields = array("%VALUE%", "%SELECTED%", "%DISPLAY_VALUE%");

        $main_content = new MainTemplater(DIR_ADMIN_TMPL . $this->module . "/form-nct.tpl.php");
        $main_content = $main_content->parse();
        $static_a = ($this->isActive == 'y' ? 'checked' : '');
        $static_d = ($this->isActive != 'y' ? 'checked' : '');


        $fields = array(
            "%USER_NAME%",
            "%EMAIL_ADDRESS%",
            "%STATUS_A%",
            "%STATUS_D%",
            "%TYPE%",
            "%ID%"
        );

        $fields_replace = array(
            $this->data['userName'],
            $this->data['email'],
            $static_a,
            $static_d,
            $this->type,
            $this->id
        );

        $content = str_replace($fields, $fields_replace, $main_content);
        return filtering($content, 'output', 'text');
    }

   public function dataGrid() {
        $content = $operation = $whereCond = $totalRow = NULL;
        $result = $tmp_rows = $row_data = array();
        extract($this->searchArray);
        $chr = str_replace(array('_', '%'), array('\_', '\%'), $chr);
        //$whereCond = ' where  status!=\'a\'';
        $aWhere[] = "%$chr%";
        $aWhere[] = "%$chr%";



        if (isset($sort)) {
            $sorting = $sort . ' ' . $order;
        } else {
            $sorting = 'id DESC';
        }
        if(strlen($whereCond) <= 0 || $whereCond == ""){
           // $whereCond = " WHERE 1 ";
        }
        if($_SESSION["adminType"] == 'g'){
            $whereCond .= ' AND openUser = "o"';
        }
        $query = "SELECT u.*
                    FROM tbl_users u WHERE u.isActive != 'd' AND (email LIKE ? OR DATE_FORMAT(createdDate, '" . MYSQL_DATE_FORMAT . "') LIKE ?)
                    " . $whereCond . " ORDER BY " . $sorting;

        $query_with_limit = $query . " LIMIT " . $offset . " ," . $rows . " ";

        $totalUsers = $this->db->pdoQuery($query,$aWhere)->results();

        $qrySel = $this->db->pdoQuery($query_with_limit,$aWhere)->results();
        $totalRow = count($totalUsers);

        foreach ($qrySel as $fetchRes) {
            $isActive = ($fetchRes['isActive'] == "y") ? "checked" : "";
            $isCertified = ($fetchRes['isCertified'] == "y") ? "checked" : "";
            $profileVideo = issetor($fetchRes['profileVideo'],"");
            $profileVideoStatus = issetor($fetchRes['profileVideoStatus'],'n');

            $switch = (in_array('status', $this->Permission)) ? $this->toggel_switch(array("action" => "ajax." . $this->module . ".php?id=" . $fetchRes['id'] . "", "check" => $isActive)) : '';
            $isCertifiedswitch = (in_array('status', $this->Permission)) ? $this->toggel_switch(array("action" => "ajax." . $this->module . ".php?id=" . $fetchRes['id'] . "&type=isCertified", "check" => $isCertified)) : '';
            $operation = '';

            /*$operation .= (in_array('edit', $this->Permission)) ? $this->operation(array("href" => "ajax." . $this->module . ".php?action=edit&id=" . $fetchRes['id'] . "", "class" => "btn default btn-xs black btnEdit", "value" => '<i class="fa fa-edit"></i>&nbsp;Edit')) : '';*/
            $operation .=(in_array('delete', $this->Permission)) ? '&nbsp;&nbsp;' . $this->operation(array("href" => "ajax." . $this->module . ".php?action=delete&id=" . $fetchRes['id'] . "", "class" => "btn default btn-xs red btn-delete", "value" => '<i class="fa fa-trash-o"></i>&nbsp;Delete')) : '';
            if($profileVideo != ""){
                $operation .= '&nbsp;&nbsp; '.$this->operation(array("href" => "ajax." . $this->module . ".php?action=viewProfileVideo&id=" . $fetchRes['id'] . "", "class" => "btn default green btn-xs btn-viewbtn", "value" => '<i class="fa fa-laptop"></i>&nbsp;View Profile Video'));
            }
            /*$operation .=(in_array('view', $this->Permission)) ? '&nbsp;&nbsp;' . $this->operation(array("href" => "ajax." . $this->module . ".php?action=view&id=" . $fetchRes['id'] . "", "class" => "btn default blue btn-xs btn-viewbtn", "value" => '<i class="fa fa-laptop"></i>&nbsp;View')) : '';*/


            $email = (isset($fetchRes["email"]) && $fetchRes["email"] != '') ? $fetchRes["email"] : 'N/A';

            $final_array = array(
                filtering($fetchRes['id'], 'output', 'int'),
                filtering($email),
                ($fetchRes['createdDate']),
                $isCertifiedswitch
            );
            if (in_array('status', $this->Permission)) {
                $final_array = array_merge($final_array, array($switch));
            }
            if (in_array('edit', $this->Permission) || in_array('delete', $this->Permission) || in_array('view', $this->Permission)) {
                $final_array = array_merge($final_array, array($operation));
            }
            //echo "<pre>";print_r($final_array);exit;
            $row_data[] = $final_array;
        }

        $result["sEcho"] = $sEcho;
        $result["iTotalRecords"] = (int) $totalRow;
        $result["iTotalDisplayRecords"] = (int) $totalRow;
        $result["aaData"] = $row_data;
        return $result;
    }


    public function displaybox($text) {

        $text['label'] = isset($text['label']) ? $text['label'] : 'Enter Text Here: ';
        $text['value'] = isset($text['value']) ? $text['value'] : '';
        $text['name'] = isset($text['name']) ? $text['name'] : '';
        $text['class'] = isset($text['class']) ? 'form-control-static ' . trim($text['class']) : 'form-control-static';
        $text['onlyField'] = isset($text['onlyField']) ? $text['onlyField'] : false;
        $text['extraAtt'] = isset($text['extraAtt']) ? $text['extraAtt'] : '';

        $main_content = new MainTemplater(DIR_ADMIN_TMPL . $this->module . '/displaybox.tpl.php');
        $main_content = $main_content->parse();
        $fields = array("%LABEL%", "%CLASS%", "%VALUE%");
        $fields_replace = array($text['label'], $text['class'], $text['value']);
        return str_replace($fields, $fields_replace, $main_content);
    }

    public function getSelectBoxOption() {
        $content = '';
        $main_content = new MainTemplater(DIR_ADMIN_TMPL . $this->module . "/select_option-nct.tpl.php");
        $content.= $main_content->parse();
        return sanitize_output($content);
    }

    public function toggel_switch($text) {
        $text['action'] = isset($text['action']) ? $text['action'] : 'Enter Action Here: ';
        $text['check'] = isset($text['check']) ? $text['check'] : '';
        $text['name'] = isset($text['name']) ? $text['name'] : '';
        $text['class'] = isset($text['class']) ? '' . trim($text['class']) : '';
        $text['extraAtt'] = isset($text['extraAtt']) ? $text['extraAtt'] : '';

        $main_content = new MainTemplater(DIR_ADMIN_TMPL . $this->module . '/switch-nct.tpl.php');
        $main_content = $main_content->parse();
        $fields = array("%NAME%", "%CLASS%", "%ACTION%", "%EXTRA%", "%CHECK%");
        $fields_replace = array($text['name'], $text['class'], $text['action'], $text['extraAtt'], $text['check']);
        return str_replace($fields, $fields_replace, $main_content);
    }

    public function operation($text) {

        $text['href'] = isset($text['href']) ? $text['href'] : 'Enter Link Here: ';
        $text['value'] = isset($text['value']) ? $text['value'] : '';
        $text['name'] = isset($text['name']) ? $text['name'] : '';
        $text['class'] = isset($text['class']) ? '' . trim($text['class']) : '';
        $text['extraAtt'] = isset($text['extraAtt']) ? $text['extraAtt'] : '';
        $main_content = new MainTemplater(DIR_ADMIN_TMPL . $this->module . '/operation-nct.tpl.php');
        $main_content = $main_content->parse();
        $fields = array("%HREF%", "%CLASS%", "%VALUE%", "%EXTRA%");
        $fields_replace = array($text['href'], $text['class'], $text['value'], $text['extraAtt']);
        return str_replace($fields, $fields_replace, $main_content);
    }

    public function getPageContent() {
        $final_result = NULL;
        $main_content = new MainTemplater(DIR_ADMIN_TMPL . $this->module . "/" . $this->module . ".tpl.php");
        $main_content->breadcrumb = $this->getBreadcrumb();

        $main_content_parsed = $final_result = $main_content->parse();

        $fields = array(
            "%VIEW_ALL_RECORDS_BTN%"
        );

        $view_all_records_btn = '';
        if (( isset($_GET['day']) && $_GET['day'] != '' ) || ( isset($_GET['month']) && $_GET['month'] != '' ) || ( isset($_GET['year']) && $_GET['year'] != '' )) {
            $view_all_records_btn = $this->getViewAllBtn();
        }

        $fields_replace = array(
            $view_all_records_btn
        );

        $final_result = str_replace($fields, $fields_replace, $main_content_parsed);

        return $final_result;
    }

}
