<?php

$reqAuth = true;
require_once ("../../../includes-nct/config-nct.php");
include ("class.user-level-nct.php");
$module = "user-level-nct";
$table = "tbl_users_level";

$styles = array(
    array("data-tables/DT_bootstrap.css",SITE_ADM_PLUGIN),
    array("bootstrap-switch/css/bootstrap-switch.min.css",SITE_ADM_PLUGIN)
);

$scripts = array(
    "core/datatable.js",
    array("data-tables/jquery.dataTables.js",SITE_ADM_PLUGIN),
    array("data-tables/DT_bootstrap.js",SITE_ADM_PLUGIN),
    array("bootstrap-switch/js/bootstrap-switch.min.js",SITE_ADM_PLUGIN)
);

chkPermission($module);
$Permission = chkModulePermission($module);

$metaTag = getMetaTags(array(
    "description" => "Admin Panel",
    "keywords" => 'Admin Panel',
    'author' => AUTHOR
));

$id = isset($_GET["id"]) ? (int) trim($_GET["id"]) : 0;
$postType = isset($_POST["type"]) ? trim($_POST["type"]) : '';
$type = isset($_GET["type"]) ? trim($_GET["type"]) : $postType;

$headTitle = $type == 'add' ? 'Add' : ($type == 'edit' ? 'Edit' : 'Manage') . ' User Level';
$winTitle = $headTitle . ' - ' . SITE_NM;
$breadcrumb = array($headTitle);


if (isset($_POST["submitAddForm"]) && $_SERVER["REQUEST_METHOD"] == "POST") {
    $response = array();
    $response['status'] = false;
    extract($_POST);
    $value = isset($value) ? filtering($value,'input','int') : '';

    if ($type == 'edit' && $id > 0) {
        if ($type == 'edit' && $id > 0) {
            $db->update($table, array('value'=>$value),array("id" => $id));
            $response['status'] = true;
            $response['success'] =  'Record has been updated successfully.';
            echo json_encode($response);
            exit;
        }
        else {
            $response['status'] = false;
            $response['success'] =  'You are not authorised to perform this action';
            echo json_encode($response);
            exit;
        }
    }
    else {
        $response['status'] = false;
        $response['success'] =  'Invalid action.';
        echo json_encode($response);
        exit;
    }
}

$objTemplate = new UserLevel($module);
$pageContent = $objTemplate -> getPageContent();
require_once (DIR_ADMIN_TMPL . "parsing-nct.tpl.php");
