<?php
class TrendingCollections extends Home{
    public $constantValue;
    public $constantName;
    public $data = array();
    public function __construct($module, $id = 0, $searchArray = array(), $type = ''){
        global $db, $fb, $fields, $sessCataId;
        $this->db         = $db;
        $this->data['id'] = $this->id = $id;
        $this->fields     = $fields;
        $this->module     = $module;
        $this->table      = 'tbl_trending_collections';

        $this->type        = ($this->id > 0 ? 'edit' : 'add');
        $this->searchArray = $searchArray;
        parent::__construct();
        if ($this->id > 0) {
            $fetchRes = $this->db->pdoQuery("SELECT tc.*,
                    (SELECT COUNT(id) FROM tbl_trending_collections_services WHERE trendingId = tc.id ) as no_of_services
                    FROM tbl_trending_collections AS tc
                    WHERE tc.id = ? ",array($this->id))->result();

            foreach ($fetchRes as $k => $v) {
                $this->{$k} = filtering($v);
            }

        } else {
            $fetchRes = $this->db->pdoQuery("SHOW COLUMNS FROM " . $this->table)->results();
            foreach ($fetchRes as $k => $v) {
                $this->{$v["Field"]} = $v["Default"];
            }
            $this->no_of_services = 0;
        }
        switch ($type) {
            case 'add':{
                    $this->data['content'] = (in_array('add', $this->Permission)) ? $this->getForm() : '';
                    break;
                }
            case 'import_excel':{
                    $this->data['content'] = (in_array('import', $this->Permission)) ? $this->getImportCsvForm() : '';
                    break;
                }
            case 'edit':{
                    $this->data['content'] = (in_array('edit', $this->Permission)) ? $this->getForm() : '';
                    break;
                }
            case 'view':{
                    $this->data['content'] = $this->viewForm();
                    break;
                }
            case 'delete':{
                    $this->data['content'] = (in_array('delete', $this->Permission)) ? json_encode($this->dataGrid()) : '';
                    break;
                }
            case 'datagrid':{
                    $this->data['content'] = (in_array('module', $this->Permission)) ? json_encode($this->dataGrid()) : '';
                }
        }
    }
    public function viewForm(){  
        $content = '';  	
        $image = '<img width="100px" height="100px" src="'.checkImage($this->image,5).'" alt="'.$this->name.'" />';
        $backgroundImage = '<img width="100px" height="100px" src="'.checkImage($this->backgroundImage,6).'" alt="'.$this->name.'" />';
        $languages = $this->db->select("tbl_language", '*', array("1" => '1'))->results();
        foreach ($languages as $key => $value) {
            $content .= $this->displayBox(array("label" => "Collection Name&nbsp;(".($value['languageName'])."):", "value" => $this->{"name_" . $value['id']})) .
            $this->displayBox(array("label" => "Descrption&nbsp;(".($value['languageName'])."):", "value" => filtering($this->{"description_" . $value['id']}, 'output', 'text')));
        }
        $content .= $this->displayBox(array("label" => "No of Service&nbsp;:", "value" => $this->no_of_services));
        $content .= $this->getCollectionServicesContent();
        $content .= $this->displayBox(array("label" => "Image&nbsp;:", "value" => $image));
        $content .= $this->displayBox(array("label" => "Background Image&nbsp;:", "value" => $backgroundImage));
        return $content;
    }

    public function getCollectionServicesContent(){
        $content = '';  
        $q = $this->db->pdoQuery("SELECT s.title
                FROM tbl_trending_collections_services AS tcs 
                LEFT JOIN tbl_services AS s ON s.id =  tcs.serviceId 
                WHERE tcs.trendingId = ? ",array($this->id));
        if($q->affectedRows() > 0){
            foreach ($q->results() as $key => $value) {
                $content .= $this->displayBox(array("label" => "Service ".($key + 1)."&nbsp;:", "value" => $value['title']));
            }
        }
        return $content;
    }

    public function getForm(){
    	$content = '';
        $languages = $this->db->select("tbl_language", '*', array("1" => '1'))->results();
        $html = null;
        foreach ($languages as $key => $value) {    
            $html .= get_view(DIR_ADMIN_TMPL . $this->module . "/textfield.tpl.php", array(
            	'%label%'          => 'Trending Collection Name',
            	'%id%'             => $value['id'], 
            	'%languageName%'   => $value['languageName'], 
                '%IS_ENG%'         => ($value['langCode'] == 'en' ? 'is_english' : ''),
            	'%fieldName%'      => 'name['.$value['id'].']',
            	'%fieldValue%'     => (isset($this->{"name_" . $value['id']}) ? $this->{"name_" . $value['id']} : null)));
            $html .= get_view(DIR_ADMIN_TMPL . $this->module . "/textarea.tpl.php", array(
            	'%label%' => 'Description',
            	'%id%' => $value['id'], 
            	'%languageName%' => $value['languageName'], 
            	'%fieldName%' => 'description['.$value['id'].']',
            	'%fieldValue%' => (isset($this->{"description_" . $value['id']}) ? $this->{"description_" . $value['id']} : null)));

        }
        $replace = array(
            "%SERVICES_OPTION%" =>$this->getServicesSelection(),
            "%html%"            => $html,
            '%IMAGE%'           => checkImage($this->image,5),
            '%IMAGE_BACK%'      => checkImage($this->backgroundImage,6),
            '%IGNORECLASS%'     => ($this->type == 'add' ? '' : 'ignore'),
            '%REQUIRED%'        => ($this->type == 'add' ? 'required' : ''),
            "%DEST_SITE_URL%"   => SITE_UPD.'trending-collections/temp_dir/',
            "%DEST_DIR_URL%"    => DIR_UPD.'trending-collections/temp_dir/',
            "%STATUS_A%"        => ($this->isActive == 'y' ? 'checked' : ''),
            "%STATUS_D%"        => ($this->isActive == 'n' ? 'checked' : ''),
            "%TYPE%"            => $this->type,
            "%ID%"              => $this->id,
        );

        $content = get_view(DIR_ADMIN_TMPL . $this->module . "/form-nct.tpl.php", $replace);
        return sanitize_output($content);
        
    }

    public function getServicesSelection($categoryId = ''){
        $content= '';
        $c_q= $this->db->pdoQuery("SELECT id,title
                FROM tbl_services 
                WHERE status = ?  ",array('a'));
        $main_content = new MainTemplater(DIR_ADMIN_TMPL."/option-nct.tpl.php");
        $main_content = $main_content->parse();
        if($c_q->affectedRows() > 0){
            foreach ($c_q->results() as $key => $value) {
                $check = $this->db->pdoQuery("SELECT id FROM tbl_trending_collections_services WHERE trendingId = ? AND serviceId = ? LIMIT 1 ",array($this->id,$value['id']))->affectedRows();
                $selected = ($check > 0 ? 'selected' : '');
                $replace = array(
                    '%OPT_VALUE%'   =>$value['id'],
                    '%EXTRA%'       =>'',
                    '%SELECTED%'    =>$selected,
                    '%OPT_TEXT%'    =>$value['title']
                );
                $content .= str_replace(array_keys($replace),array_values($replace),$main_content); 
            }
        }
        return $content;
    }

    public function dataGrid(){
        $content = $operation = $whereCond = $whereCond1 = $totalRow = null;
        $result  = $tmp_rows  = $row_data  = array();
        extract($this->searchArray);
        $sWhere = ' WHERE 1 = ? ';
        $aWhere = array(1);
        $chr     = isset($chr) ? str_replace(array('_', '%', "'"), array('\_', '\%', "\'"), $chr) : '';
        if(isset($chr) && $chr != ''){
            $sWhere .= " AND (tc.name LIKE ? OR  tc.description LIKE ? )";
            $aWhere[] = "%$chr%";
            $aWhere[] = "%$chr%";
        }
        if(isset($sort))
            $sorting = $sort . ' ' . $order;
        else
            $sorting = 'tc.id DESC';


        $totalRowTmp = $this->db->pdoQuery("SELECT COUNT(tc.id) AS nmrows 
                    FROM tbl_trending_collections AS tc
                    $sWhere", $aWhere)->result();
        $totalRow = $totalRowTmp['nmrows'];


        $qrySel = $this->db->pdoQuery("SELECT tc.*,
                    (SELECT COUNT(id) FROM tbl_trending_collections_services WHERE trendingId = tc.id ) as no_of_services
                    FROM tbl_trending_collections AS tc
                    $sWhere ORDER BY $sorting limit $offset , $rows", $aWhere)->results();

        foreach ($qrySel as $fetchRes){
            $status = ($fetchRes['isActive'] == "y") ? "checked" : "";
            $id     = $fetchRes['id'];
            $switch = (in_array('status', $this->Permission)) ? $this->toggel_switch(array("action" => "ajax." . $this->module . ".php?id=" . $id . "", "check" => $status)) : '';
            $operation =(in_array('view', $this->Permission)) ? '&nbsp;&nbsp;' . $this->operation(array("href" => "ajax." . $this->module . ".php?action=view&id=" . $fetchRes['id'] . "", "class" => "btn default blue btn-xs btn-viewbtn", "value" => '<i class="fa fa-laptop"></i>&nbsp;View')) : '';

            $operation .= (in_array('edit', $this->Permission)) ? '&nbsp;&nbsp;' . $this->operation(array("href" => SITE_ADM_MOD . $this->module . "/ajax." . $this->module . ".php?action=edit&id=" . $id, "class" => "btn default btn-xs black btnEdit", "value" => '<i class="fa fa-edit"></i>&nbsp;Edit')) : '';

            $operation .= (in_array('delete', $this->Permission)) ? '&nbsp;&nbsp;' . $this->operation(array("href" => "ajax." . $this->module . ".php?action=delete&id=" . $fetchRes['id'] . "", "class" => "btn default btn-xs red btn-delete", "value" => '<i class="fa fa-trash-o"></i>&nbsp;Delete')) : '';
            $image = '<img width="100px" height="100px" src="'.checkImage($fetchRes['image'],5).'" alt="'.$fetchRes["name"].'" />';
            $final_array = array(
                $id,
                $image,
                stripslashes($fetchRes["name"]),
                stripslashes($fetchRes["no_of_services"]),
                convertDate($fetchRes['createdDate'])
            );
            if (in_array('status', $this->Permission)) {
                $final_array = array_merge($final_array, array($switch));
            }
            if (in_array('edit', $this->Permission) || in_array('delete', $this->Permission) || in_array('view', $this->Permission)) {
                $final_array = array_merge($final_array, array($operation));
            }
            $row_data[] = $final_array;
        }
        $result["sEcho"]                = $sEcho;
        $result["iTotalRecords"]        = (int) $totalRow;
        $result["iTotalDisplayRecords"] = (int) $totalRow;
        $result["aaData"]               = $row_data;
        return $result;
    }

    public function displaybox($text) {
        $text['label'] = isset($text['label']) ? $text['label'] : 'Enter Text Here: ';
        $text['value'] = isset($text['value']) ? $text['value'] : '';
        $text['name'] = isset($text['name']) ? $text['name'] : '';
        $text['class'] = isset($text['class']) ? 'form-control-static ' . trim($text['class']) : 'form-control-static';
        $text['onlyField'] = isset($text['onlyField']) ? $text['onlyField'] : false;
        $text['extraAtt'] = isset($text['extraAtt']) ? $text['extraAtt'] : '';

        $main_content = new MainTemplater(DIR_ADMIN_TMPL . $this->module . '/displaybox.tpl.php');
        $main_content = $main_content->parse();
        $fields = array("%LABEL%", "%CLASS%", "%VALUE%");
        $fields_replace = array($text['label'], $text['class'], $text['value']);
        return str_replace($fields, $fields_replace, $main_content);
    }

    public function toggel_switch($text){
        $text['action']   = isset($text['action']) ? $text['action'] : 'Enter Action Here: ';
        $text['check']    = isset($text['check']) ? $text['check'] : '';
        $text['name']     = isset($text['name']) ? $text['name'] : '';
        $text['class']    = isset($text['class']) ? '' . trim($text['class']) : '';
        $text['extraAtt'] = isset($text['extraAtt']) ? $text['extraAtt'] : '';

        $main_content   = new MainTemplater(DIR_ADMIN_TMPL . $this->module . '/switch-nct.tpl.php');
        $main_content   = $main_content->parse();
        $fields         = array("%NAME%", "%CLASS%", "%ACTION%", "%EXTRA%", "%CHECK%");
        $fields_replace = array($text['name'], $text['class'], $text['action'], $text['extraAtt'], $text['check']);
        return str_replace($fields, $fields_replace, $main_content);
    }
    public function operation($text){
        $text['href']     = isset($text['href']) ? $text['href'] : 'Enter Link Here: ';
        $text['value']    = isset($text['value']) ? $text['value'] : '';
        $text['name']     = isset($text['name']) ? $text['name'] : '';
        $text['class']    = isset($text['class']) ? '' . trim($text['class']) : '';
        $text['extraAtt'] = isset($text['extraAtt']) ? $text['extraAtt'] : '';
        $main_content     = new MainTemplater(DIR_ADMIN_TMPL . $this->module . '/operation-nct.tpl.php');
        $main_content     = $main_content->parse();
        $fields           = array("%HREF%", "%CLASS%", "%VALUE%", "%EXTRA%");
        $fields_replace   = array($text['href'], $text['class'], $text['value'], $text['extraAtt']);
        return str_replace($fields, $fields_replace, $main_content);
    }
    public function getPageContent(){
        $final_result             = null;
        $main_content             = new MainTemplater(DIR_ADMIN_TMPL . $this->module . "/" . $this->module . ".tpl.php");
        $main_content->breadcrumb = $this->getBreadcrumb();
        $main_content->getForm    = $this->getForm();
        $final_result = $main_content->parse();
        return $final_result;
    }
}
