<?php
$reqAuth=true;
require_once("../../../includes-nct/config-nct.php");
require_once("class.redeem-requests-nct.php");
$module = "redeem-requests-nct";
$table = "tbl_redeem_request";
$styles = array(array("data-tables/DT_bootstrap.css",SITE_ADM_PLUGIN),
	array("bootstrap-switch/css/bootstrap-switch.min.css",SITE_ADM_PLUGIN));

$scripts= array("core/datatable.js",
		array("data-tables/jquery.dataTables.js",SITE_ADM_PLUGIN),
		array("data-tables/DT_bootstrap.js",SITE_ADM_PLUGIN),
		array("bootstrap-switch/js/bootstrap-switch.min.js",SITE_ADM_PLUGIN));

chkPermission($module);
$Permission=chkModulePermission($module);
$metaTag = getMetaTags(array("description"=>"Admin Panel",
		"keywords"=>'Admin Panel',
		'author'=>AUTHOR));

$id = isset($_GET["id"]) ? (int)trim($_GET["id"]) : 0;
$postType = isset($_POST["type"])?trim($_POST["type"]):'';
$type = isset($_GET["type"])?trim($_GET["type"]):$postType;

$headTitle = $type == 'add' ? 'Add' : ($type == 'edit' ? 'Edit' : 'Manage').' Redeem Requests';
$winTitle = $headTitle.' - '.SITE_NM;
$breadcrumb = array($headTitle);

if(isset($_POST["submitAddForm"]) && $_SERVER["REQUEST_METHOD"] == "POST") {
	extract($_POST);
	$response = array();
    $response['status'] = false;
	$objPost = new stdClass();


	$objPost->referenceNo     	= isset($referenceNo) ? filtering($referenceNo,'input','text') : '';

	$objPost->fundedDate   = isset($transactionDate) ? $transactionDate : '';
	$objPost->updatedDate 	= date('Y-m-d H:i:s');

	if($type == 'edit' && $id > 0){
		if(in_array('edit',$Permission)){
			if($objPost->referenceNo != '' && $objPost->fundedDate != ''){


				$check = $db->pdoQuery("SELECT r.id,r.userId,r.amount,w.withdrawalAmount
					FROM tbl_redeem_request AS r
					INNER JOIN tbl_wallet AS w ON w.userId = r.userId

					WHERE r.status = ? AND r.id = ? AND r.paymentMode = ?  ",array('p',$id,'b'));
				if($check->affectedRows() > 0){
					$check_data = $check->result();
					$objPost->status = 'f';
					$db->update($table,(array)$objPost,array('id'=>$id));

					//updatting user wallet
		            $withdrawalAmount = ($check_data['withdrawalAmount'] + $check_data['amount']);
		            $db->update('tbl_wallet',array('withdrawalAmount'=>strval($withdrawalAmount),'updatedDate' =>date('Y-m-d H:i:s')),array('userId'=>$check_data['userId']));
		            //updatting user wallet

					//insert payment hisrory
					$insertArrayPayment = array(
						'txnTypeId'		=>2,
						'txnId'			=>generateUpdateRedeemRequestPaymentCounter('bank'),
						'paymentTxnId'	=>$referenceNo,
						'userId'		=>$check_data['userId'],
						'entityId'		=>$id,
						'paymentStatus'	=>'s',
						'amount'		=>strval($check_data['amount']),
						'ipAddress'		=>get_ip_address(),
						'createdDate'	=>date('Y-m-d H:i:s'),
						'updatedDate'	=>date('Y-m-d H:i:s')
					);
					$payment_history_id = $db->insert('tbl_payment_history',$insertArrayPayment)->getLastInsertId();
					//insert payment hisrory

					$activity_array = array("id"=>$id,"module"=>$module,"activity"=>'edit');
					add_admin_activity($activity_array);
					$response['status'] = true;

					//send notification
		            $notification_type = 'redeem_payment_done_by_admin';
		            $data_array = array(
		                'receiverId'=>$check_data['userId'],
		                'notifyId'=>$notification_type,
		                'entityId'=>$check_data['id'],
		                'amount'=>$check_data['amount']
		            );
		            addNewNotificationForUser($notification_type,$data_array);
		            //send notification

		            $response['success'] =  'Record has been updated successfully.';
		            echo json_encode($response);
		            exit;
				}
				else{
					$response['status'] = false;
		            $response['error'] =  'Redeem request not found.';
		            echo json_encode($response);
		            exit;
				}
			}
			else{
				$response['status'] = false;
	            $response['error'] =  "Please fill all values properly.";
	            echo json_encode($response);
	            exit;
			}
		}else{
			$response['status'] = false;
            $response['error'] =  "You don't have permission to perform this action.";
            echo json_encode($response);
            exit;
		}
	} else {
	}
	redirectPage(SITE_ADM_MOD.$module);
}
if(isset($_REQUEST['action']) && $_REQUEST['action'] == 'payViaPaypal' && $id > 0){
	$check = $db->pdoQuery("SELECT r.id,u.paypalEmail,r.amount,r.userId
		FROM tbl_redeem_request AS r
		INNER JOIN tbl_users AS u ON u.id = r.userId
		WHERE r.status = ? AND r.id = ? AND r.paymentMode = ? LIMIT 1 ",
		array('p',$id,'p'));
	if($check->affectedRows() > 0){
		$check_data = $check->result();
		if($check_data['paypalEmail'] != ''){
			$insertArrayPayment = array(
				'userId'=>$check_data['userId'],
				'txnTypeId'=>2,
				'entityId'=>$id,
				'amount'=>strval($check_data['amount']),
				'ipAddress'=>get_ip_address(),
				'createdDate'=>date('Y-m-d H:i:s')
			);
			$payment_history_id = $db->insert('tbl_payment_history',$insertArrayPayment)->getLastInsertId();

			// Paypal
	        $en_action = base64_encode('redeem');
	        $url_paypal  = PAYPAL_URL;
	        $url_paypal .= "?business=".urlencode($check_data['paypalEmail']);
	        $url_paypal .= "&cmd=".urlencode('_xclick');
	        $url_paypal .= "&item_name=Redeem Amount to user - ".urlencode(SITE_NM);
	        $url_paypal .= "&item_number=".urlencode($id);
	        $url_paypal .= "&custom=".urlencode($payment_history_id.'__'.$id.'__'.$check_data['amount']);
	        $url_paypal .= "&amount=".urlencode($check_data['amount']);
	        $url_paypal .= "&currency_code=".urlencode(PAYPAL_CURRENCY_CODE);
	        $url_paypal .= "&handling=".urlencode('0');

			$url_paypal .= "&rm=" . urlencode('2');

	        $url_paypal .= "&bn=".urlencode('NCryptedTechnologies_SP_EC');
	        $url_paypal .= "&return=".urlencode(SITE_ADM_MOD.$module.'/request-thankyou.php');
	        $url_paypal .= "&cancel_return=".urlencode(SITE_ADM_MOD.$module.'/request-failed.php?paymentId='.base64_encode($payment_history_id));
	        $url_paypal .= "&notify_url=".urlencode(SITE_ADM_MOD.$module.'/request-notify.php');
	        header('Location:'.$url_paypal);
	        exit;
		}
		else{
			$toastr_message =$_SESSION['toastr_message'] = disMessage(array('type'=>'err','var'=>'User has not provided paypal email address.'));
    		redirectPage(SITE_ADM_MOD . $module);
		}
	}
	else{
		$toastr_message =$_SESSION['toastr_message'] = disMessage(array('type'=>'err','var'=>'Redeem request not found.'));
		redirectPage(SITE_ADM_MOD.$module);
	}
}

$objCategory = new redeemRequest($id);
$pageContent = $objCategory->getPageContent();

require_once(DIR_ADMIN_TMPL."parsing-nct.tpl.php");