<?php

class redeemRequest extends Home {
	public $page_name;
	public $page_title;
	public $meta_keyword;
	public $meta_desc;
	public $page_desc;
	public $isActive;
	public $data = array();
	public function __construct($id=0, $searchArray=array(), $type='') {
		$this->data['id'] = $this->id = $id;
		$this->table = 'tbl_redeem_request';
		$this->type = ($this->id > 0 ? 'edit' : 'add');
		$this->searchArray = $searchArray;
		$this->langArray = array();
		parent::__construct();
		if($this->id>0){
			$qrySel = $this->db->pdoQuery("SELECT r.*,u.userName,u.paypalEmail,u.bankName,u.bankAccountNumber,u.bankIfscCode,u.bankAccountName
                    FROM tbl_redeem_request AS r
                    LEFT JOIN tbl_users AS u ON u.id = r.userId
                    WHERE r.id = ? ",array($this->id))->result();
			foreach ($qrySel as $k => $v) {
                $this->{$k} = filtering($v);
            }
		}else{
			$fetchRes = $this->db->pdoQuery("SHOW COLUMNS FROM " . $this->table)->results();
            foreach ($fetchRes as $k => $v) {
                $this->{$v["Field"]} = $v["Default"];
            }
            $this->userName = '';
            $this->paypalEmail = '';
            $this->bankName = '';
            $this->bankAccountNumber = '';
            $this->bankIfscCode = '';
            $this->bankAccountName = '';
		}

		switch($type){
			case 'add' : {
				$this->data['content'] =  (in_array('add',$this->Permission))?$this->getForm():'';
				break;
			}
			case 'edit' : {
				$this->data['content'] =  (in_array('edit',$this->Permission))?$this->getForm():'';
				break;
			}
			case 'view' : {
				$this->data['content'] =  (in_array('view',$this->Permission))?$this->viewForm():'';
				break;
			}
			case 'viewBankTransfer' : {
				$this->data['content'] =  (in_array('view',$this->Permission))?$this->getBankTransferForm():'';
				break;
			}
			case 'delete' : {
				$this->data['content'] =  (in_array('delete',$this->Permission))?json_encode($this->dataGrid()):'';
				break;
			}

			case 'datagrid' : {
				$this->data['content'] =  (in_array('module',$this->Permission))?json_encode($this->dataGrid()):'';
			}
		}
	}

	public function viewForm(){
		$content = '';
		$content .=$this->displayBox(array("label"=>"Reddem id&nbsp;:","value"=>$this->requestId)).
				   $this->displayBox(array("label"=>"User Name&nbsp;:","value"=>$this->userName)).
				   $this->displayBox(array("label"=>"Amount&nbsp;:","value"=>$this->amount)).
				   $this->displayBox(array("label"=>"Payment Mode&nbsp;:","value"=>($this->paymentMode == 'p' ? 'Paypal Gateway' : 'Bank Transfer')));
		if($this->paymentMode == 'p'){
			$content .= $this->displayBox(array("label"=>"Paypal Email&nbsp;:","value"=>$this->paypalEmail));
		}
		else{
			$content .= $this->displayBox(array("label"=>"Bank Name&nbsp;:","value"=>$this->bankName)).
			$this->displayBox(array("label"=>"Bank Account Number&nbsp;:","value"=>$this->bankAccountNumber)).
			$this->displayBox(array("label"=>"Bank Account Name&nbsp;:","value"=>$this->bankAccountName)).
			$this->displayBox(array("label"=>"IFSC Code&nbsp;:","value"=>$this->bankIfscCode));
		}
		$content .= $this->displayBox(array("label"=>"Status&nbsp;:","value"=>(($this->status  == 'f' ? 'Funded' : ($this->status  == 'p' ? 'Pending' : 'Cancelled' ))))).
		   $this->displayBox(array("label"=>"Created Date&nbsp;:","value"=>convertDate($this->createdDate,true))).
		   $this->displayBox(array("label"=>"Funded Date&nbsp;:","value"=>($this->status == 'f' ? convertDate($this->fundedDate,true) : '-' )));
		return $content;
	}

	
	public function getForm() {
		$content = '';;
		return $content;
	}

	public function getBankTransferForm() {
		$content = '';
        $replace = array(
            '%REDEEM_ID%'=>$this->requestId,
            '%USER_NAME%'=>$this->userName,
            '%BANK_NAME%'=>$this->bankName,
            '%BANK_ACCOUNT_NO%'=>$this->bankAccountNumber,
            '%BANK_ACCOUNT_NAME%'=>$this->bankAccountName,
            '%BANK_IFSC_NO%'=>$this->bankIfscCode,
            '%TYPE%'=>$this->type,
            '%ID%'=>$this->id
        );
        $content = get_view(DIR_ADMIN_TMPL . $this->module . "/form-nct.tpl.php",$replace);
        return sanitize_output($content);
	}

	public function dataGrid() {
		$content = $operation = $whereCond = $totalRow = NULL;
        $result = $tmp_rows = $row_data = array();
        extract($this->searchArray);
        $chr = str_replace(array('_','%'), array('\_','\%'), $chr);
        $aWhere = array(1);
        $sWhere = ' WHERE  1 = ?  ';

        if (isset($chr) && $chr != '') {
            $sWhere .= " AND ( u.userName LIKE ? OR r.amount LIKE ? OR r.requestId LIKE ?  )";
            $aWhere[] = "%$chr%";
            $aWhere[] = "%$chr%";
            $aWhere[] = "%$chr%";
        }

        if (isset($fil_status) && $fil_status != '') {
            $sWhere .= " AND r.status = ? ";
            $aWhere[] = $fil_status;
        }

        if (isset($fil_paymentMode) && $fil_paymentMode != '') {
            $sWhere .= " AND r.paymentMode = ?  ";
            $aWhere[] = $fil_paymentMode;
        }

        if (isset($sort))
            $sorting = $sort . ' ' . $order;
        else
            $sorting = 'r.id DESC';

        $totalRowTmp = $this->db->pdoQuery("SELECT COUNT(r.id) AS nmrows 
                    FROM tbl_redeem_request AS r
                    LEFT JOIN tbl_users AS u ON u.id = r.userId
                    $sWhere", $aWhere)->result();
        $totalRow = $totalRowTmp['nmrows'];


        $qrySel = $this->db->pdoQuery("SELECT r.*,u.userName
                    FROM tbl_redeem_request AS r
                    LEFT JOIN tbl_users AS u ON u.id = r.userId
                    $sWhere ORDER BY $sorting limit $offset , $rows", $aWhere)->results();
        foreach ($qrySel as $fetchRes) {
            $id = $fetchRes['id'];

            $operation = '';
            if($fetchRes['paymentMode']  == 'p' && $fetchRes['status']  == 'p'){
            	$operation .=(in_array('view', $this->Permission)) ? '&nbsp;&nbsp;' . $this->operation(array("href" =>  SITE_ADM_MOD.$this->module."/?action=payViaPaypal&id=" . $fetchRes['id'] . "", "class" => "btn default green btn-xs btn-redeem-pay", "value" => '<i class="fa fa-money"></i>&nbsp;Pay Now')) : '';
            }
            if($fetchRes['paymentMode']  == 'b' && $fetchRes['status']  == 'p'){
            	$operation .=(in_array('view', $this->Permission)) ? '&nbsp;&nbsp;' . $this->operation(array("href" => "ajax." . $this->module . ".php?action=viewBankTransfer&id=" . $fetchRes['id'] . "", "class" => "btn default green btn-xs btn-viewbtn", "value" => '<i class="fa fa-money"></i>&nbsp;Paid')) : '';
            }
            $operation .= (in_array('view', $this->Permission)) ? '&nbsp;&nbsp;' . $this->operation(array("href" => "ajax." . $this->module . ".php?action=view&id=" . $fetchRes['id'] . "", "class" => "btn default blue btn-xs btn-viewbtn", "value" => '<i class="fa fa-laptop"></i>&nbsp;View',"extraAtt"=>"data-page_title='Bank Payment'")) : '';

            if($fetchRes['status']  == 'p'){
            	$operation .= (in_array('view', $this->Permission)) ? '&nbsp;&nbsp;' . $this->operation(array("href" => "ajax." . $this->module . ".php?action=cancelRedeem&id=" . $fetchRes['id'] . "", "class" => "btn default red btn-xs btn-cancelRedeem", "value" => '<i class="fa fa-times"></i>&nbsp;Cancel Rdeeem',"extraAtt"=>"data-page_title='Bank Payment'")) : '';
            }

            $paymentMode = ($fetchRes['paymentMode']  == 'p' ? 'Paypal gateway' : ($fetchRes['paymentMode']  == 'b' ? 'Bank Transfer' : 'N/A'));
            $paymentStatus = ($fetchRes['status']  == 'f' ? 'Funded' : ($fetchRes['status']  == 'p' ? 'Pending' : 'Cancelled' ));
            $final_array = array(
                $id,
                filtering($fetchRes['requestId'], 'output', 'string'),
                filtering($fetchRes['userName'], 'output', 'string'),
                DEFAULT_CURRENCY_SIGN.filtering($fetchRes['amount'], 'output', 'string'),
                $paymentMode,
                $paymentStatus,
               	($fetchRes['status'] == 'f' ? convertDate($fetchRes['fundedDate'],true) : '-'),
               	convertDate($fetchRes['createdDate'])
            );
            if (in_array('edit', $this->Permission) || in_array('delete', $this->Permission) || in_array('view', $this->Permission)) {
                $final_array = array_merge($final_array, array(
                    $operation));
            }
            $row_data[] = $final_array;
        }

        $result["sEcho"] = $sEcho;
        $result["iTotalRecords"] = (int) $totalRow;
        $result["iTotalDisplayRecords"] = (int) $totalRow;
        $result["aaData"] = $row_data;

        return $result;
	}
	
	public function toggel_switch($text) {
		$text['action']   = isset($text['action']) ? $text['action'] : 'Enter Action Here: ';
		$text['check']    = isset($text['check']) ? $text['check'] : '';
		$text['name']     = isset($text['name']) ? $text['name'] : '';
		$text['class']    = isset($text['class']) ? '' . trim($text['class']) : '';
		$text['extraAtt'] = isset($text['extraAtt']) ? $text['extraAtt'] : '';
		$main_content     = new MainTemplater(DIR_ADMIN_TMPL . $this->module . '/switch-nct.tpl.php');
		$main_content     = $main_content->parse();
		$fields           = array("%NAME%", "%CLASS%", "%ACTION%", "%EXTRA%", "%CHECK%");
		$fields_replace   = array($text['name'], $text['class'], $text['action'], $text['extraAtt'], $text['check']);
		return str_replace($fields, $fields_replace, $main_content);
	}
	 public function textArea($text) {
		$text['label']     = isset($text['label']) ? $text['label'] : 'Enter Password Here: ';
		$text['value']     = isset($text['value']) ? $text['value'] : '';
		$text['name']      = isset($text['name']) ? $text['name'] : '';
		$text['class']     = isset($text['class']) ? "form-control " . $text['class'] : 'form-control';
		$text['extraAtt']  = isset($text['extraAtt']) ? ' ' . $text['extraAtt'] : '';
		$text['onlyField'] = isset($text['onlyField']) ? $text['onlyField'] : false;
		if ($text["onlyField"] == true) {
			$main_content = new MainTemplater(DIR_ADMIN_TMPL . $this->module . '/textarea_onlyfield.tpl.php');
		} else {
			$main_content = new MainTemplater(DIR_ADMIN_TMPL . $this->module . '/textarea.tpl.php');
		}
		$main_content   = $main_content->parse();
		$fields         = array("%CLASS%", "%NAME%", "%ID%", "%VALUE%", "%EXTRA%", "%LABEL%");
		$fields_replace = array($text['class'], $text['name'], $text['name'], $text['value'], $text['extraAtt'], $text['label']);
		return str_replace($fields, $fields_replace, $main_content);
	}
	public function operation($text) {

		$text['href']     = isset($text['href']) ? $text['href'] : 'Enter Link Here: ';
		$text['value']    = isset($text['value']) ? $text['value'] : '';
		$text['name']     = isset($text['name']) ? $text['name'] : '';
		$text['class']    = isset($text['class']) ? '' . trim($text['class']) : '';
		$text['extraAtt'] = isset($text['extraAtt']) ? $text['extraAtt'] : '';
		$main_content     = new MainTemplater(DIR_ADMIN_TMPL . $this->module . '/operation-nct.tpl.php');
		$main_content     = $main_content->parse();
		$fields           = array("%HREF%", "%CLASS%", "%VALUE%", "%EXTRA%");
		$fields_replace   = array($text['href'], $text['class'], $text['value'], $text['extraAtt']);
		return str_replace($fields, $fields_replace, $main_content);
	}
	public function displaybox($text) {

		$text['label']     = isset($text['label']) ? $text['label'] : 'Enter Text Here: ';
		$text['value']     = isset($text['value']) ? $text['value'] : '';
		$text['name']      = isset($text['name']) ? $text['name'] : '';
		$text['class']     = isset($text['class']) ? 'form-control-static ' . trim($text['class']) : 'form-control-static';
		$text['onlyField'] = isset($text['onlyField']) ? $text['onlyField'] : false;
		$text['extraAtt']  = isset($text['extraAtt']) ? $text['extraAtt'] : '';

		$main_content      = new MainTemplater(DIR_ADMIN_FIELDS_HTML. '/displaybox.tpl.php');
		$main_content      = $main_content->parse();
		$fields            = array("%LABEL%", "%CLASS%", "%VALUE%");
		$fields_replace    = array($text['label'], $text['class'], $text['value']);
		return str_replace($fields, $fields_replace, $main_content);
	}

	public function getPageContent(){
		$final_result             = NULL;
		$main_content             = new MainTemplater(DIR_ADMIN_TMPL.$this->module."/".$this->module.".tpl.php");
		$main_content->breadcrumb = $this->getBreadcrumb();
		$main_content->langArray  = $this->langArray;
		$main_content->getForm    = $this->getForm();
		$final_result             = $main_content->parse();
		return $final_result;
	}

}