<?php
class ManagePayment extends Home
{

    public $constantValue;
    public $constantName;
    public $data = array();

    public function __construct($module, $id = 0, $searchArray = array(), $type = '')
    {
        global $db, $fb, $fields, $sessCataId;
        $this->db         = $db;
        $this->data['id'] = $this->id = $id;
        $this->fields     = $fields;
        $this->module     = $module;
        $this->table      = 'tbl_subcategories';

        $this->type        = ($this->id > 0 ? 'edit' : 'add');
        $this->searchArray = $searchArray;
        parent::__construct();
        if ($this->id > 0) {
            $fetchRes = $this->db->pdoQuery("SELECT o.*,b.userName AS buyerName , s.userName AS sellerName  FROM tbl_orders AS o INNER JOIN tbl_users AS b ON b.id = o.userId  INNER JOIN tbl_users AS s ON s.id = o.sellerId  WHERE o.paymentId = ? ",array($this->id))->result();

            /*foreach ($fetchRes as $k => $v) {
                $this->{$k} = filtering($v);
            }*/

        } else {
        }

        switch ($type) {
            case 'view':{
                    $this->data['content'] = $this->viewForm();
                    break;
                }
            case 'datagrid':{
                    $this->data['content'] = (in_array('module', $this->Permission)) ? json_encode($this->dataGrid()) : '';
                }
        }

    }
    public function viewForm(){
        $content = "";
        $fetchRes = $this->db->pdoQuery("SELECT o.*,b.userName  AS buyerName,s.title,s.description AS serviceDesc,r.description AS requestDesc , seller.userName AS sellerName  FROM tbl_orders AS o LEFT JOIN tbl_request AS r ON r.id = o.entityId AND o.orderType = 'r' LEFT JOIN tbl_services AS s ON s.id = o.entityId AND o.orderType = 's' INNER JOIN tbl_users AS b ON b.id = o.userId  INNER JOIN tbl_users AS seller ON seller.id = o.sellerId  WHERE o.paymentId = ? ",array($this->id))->results();
            foreach ($fetchRes as $k => $v) {
                $orderId = $v['id'];
                $orderTxnId = $v['txnId'];
                $amount = $v['amount'];
                $extraAmount = $v['extraAmount'];
                $couponCode = $v['couponCode'];
                $couponDiscount = $v['discount'];
                $discountPercentage = $v['discountPercentage'];
                $deliveryDate = convertDate($v['deliveryDate']);
                $status = $v['status'];
                switch ($status) {
                    case 'n':
                        $dispStatus = LBL_NEW;
                        break;
                    case 'a':
                        $dispStatus = ACTIVE;
                        break;
                    case 'c':
                        $dispStatus = COMPLETED;
                        break;
                    case 'ca':
                        $dispStatus = CANCELLED;
                        break;
                    case 'l':
                        $dispStatus = LATE;
                        break;
                    case 'e':
                        $dispStatus = EXPIRED;
                        break;
                    default:
                        $dispStatus = LBL_NEW;
                        break;
                }
                $entityId = $v['entityId'];
                $orderType = $v['orderType'];
                $dispOrderType = $v['orderType'] == 's' ? 'Service' : 'Request';
                $buyerName = filtering($v['buyerName']);
                $sellerName = filtering($v['sellerName']);

                $content .= $this->displayBox(array("label" => "Order Transaction Id&nbsp;:", "value" => $orderTxnId));
                $content .= $this->displayBox(array("label" => "Buyer Name&nbsp;:", "value" => ucwords($buyerName)));
                $content .= $this->displayBox(array("label" => "Seller Name&nbsp;:", "value" => ucwords($sellerName)));
                $content .= $this->displayBox(array("label" => "Order Amount&nbsp;:", "value" => DEFAULT_CURRENCY_SIGN.$amount));
                if($extraAmount > 0){
                    $content .= $this->displayBox(array("label" => "Extra Amount&nbsp;:", "value" => DEFAULT_CURRENCY_SIGN.$extraAmount));

                }
                $content .= $this->displayBox(array("label" => "Delivery Date&nbsp;:", "value" => $deliveryDate));
                $content .= $this->displayBox(array("label" => "Order Status&nbsp;:", "value" => $dispStatus));
                $content .= $this->displayBox(array("label" => "Order Type&nbsp;:", "value" => $dispOrderType));
                if($orderType == 's'){
                    $title = filtering($v['title']);
                    $description = filtering($v['serviceDesc']);
                    $serviceImg = $this->db->pdoQuery("SELECT * FROM tbl_service_gallery WHERE serviceId = ? AND fileType = 'i'",array($entityId))->results();
                    $imgs= "";
                    foreach ($serviceImg as $key => $value) {
                        $sImg = checkImage($value['fileName'],8,$entityId);
                        $imgs .= '<img src="'.$sImg.'" height="100px" width="100px" style="margin-right:10px">';
                    }

                    $content .= $this->displayBox(array("label" => "Service Title&nbsp;:", "value" => $title));
                    $content .= $this->displayBox(array("label" => "Service Description&nbsp;:", "value" => '<p class="readmore">'.$description.'</p>'));
                    $content .= $this->displayBox(array("label" => "Service Images&nbsp;:", "value" => $imgs));
                }else{

                    $description = filtering($v['requestDesc']);
                    $content .= $this->displayBox(array("label" => "Request Description&nbsp;:", "value" => '<p class="readmore">'.$description.'</p>'));

                }
                $content .= '<script>
                            $(".readmore").shorten({
                                "showChars" : 100,
                                "moreText"  : "View More",
                                "lessText"  : "View Less",
                            });</script>';
                if($couponCode != "" && $couponDiscount > 0 && $discountPercentage > 0){

                    $content .= $this->displayBox(array("label" => "Coupon Code&nbsp;:", "value" => $couponCode));
                    $content .= $this->displayBox(array("label" => "Coupon Discount&nbsp;:", "value" => DEFAULT_CURRENCY_SIGN.$couponDiscount));
                    $content .= $this->displayBox(array("label" => "Coupon Percentage&nbsp;:", "value" => $discountPercentage.'%'));
                }
                $content .= '<hr>';
            }
        return $content;
    }


    public function dataGrid(){
        $sWhere = $content = $operation = $whereCond = $whereCond1 = $totalRow = null;
        $result  = $tmp_rows  = $row_data  = array();
        extract($this->searchArray);
        $chr     = isset($chr) ? str_replace(array('_', '%', "'"), array('\_', '\%', "\'"), $chr) : '';
        $aWhere = array();
        if (isset($chr) && $chr != '') {
            $sWhere .= " AND (u.userName LIKE ? OR  p.txnId LIKE ? )";
            $aWhere[] = "%$chr%";
            $aWhere[] = "%$chr%";
        }
        if (isset($sort))
            $sorting = $sort . ' ' . $order;
        else
            $sorting = 'p.id DESC';

        if (isset($txn_type) && $txn_type != '') {
            $txnWhr = " AND txnTypeId = ?";
            if($txn_type == 'cp'){
                $aWhere[] = 1;
            }elseif($txn_type == 'rp'){
                $aWhere[] = 4;
            }elseif($txn_type == 'sf'){
                $aWhere[] = 6;
            }elseif($txn_type == 'rr'){
                $aWhere[] = 2;
            }elseif($txn_type == 'co'){
                $aWhere[] = 3;
            }else{
                $txnWhr = "";
            }
            $sWhere .= $txnWhr;
        }

        $qry = "SELECT p.*,wt.title AS transactionType,u.userName AS userName FROM tbl_payment_history AS p INNER JOIN tbl_users AS u ON u.id = p.userId INNER JOIN tbl_wallet_transaction_type AS wt ON wt.id = p.txnTypeId WHERE p.paymentStatus = 's' $sWhere";

        $totalRow = $this->db->pdoQuery($qry, $aWhere)->affectedRows();



        $qrySel = $this->db->pdoQuery($qry." ORDER BY $sorting limit $offset , $rows", $aWhere)->results();

        foreach ($qrySel as $fetchRes){

            $operation= "";
            $id       = $fetchRes['id'];
            $txnId    = $fetchRes['txnId'];
            $userName = filtering($fetchRes['userName']);
            $amount = filtering($fetchRes['amount']);
            $amount = number_format($amount,2);
            $createdDate = convertDate($fetchRes['createdDate']);
            $paymentStatus = $fetchRes['transactionType'];
            $txnTypeId = $fetchRes['txnTypeId'];
            if($txnTypeId != 2 && $txnTypeId != 6){

                $operation =(in_array('view', $this->Permission)) ? '&nbsp;&nbsp;' . $this->operation(array("href" => "ajax." . $this->module . ".php?action=view&id=" . $fetchRes['id'] . "", "class" => "btn default blue btn-xs btn-viewbtn", "value" => '<i class="fa fa-laptop"></i>&nbsp;View')) : '';
            }

            //$operation .= (in_array('edit', $this->Permission)) ? '&nbsp;&nbsp;' . $this->operation(array("href" => SITE_ADM_MOD . $this->module . "/ajax." . $this->module . ".php?action=edit&id=" . $id, "class" => "btn default btn-xs black btnEdit", "value" => '<i class="fa fa-edit"></i>&nbsp;Edit')) : '';

            //$operation .= (in_array('delete', $this->Permission)) ? '&nbsp;&nbsp;' . $this->operation(array("href" => "ajax." . $this->module . ".php?action=delete&id=" . $fetchRes['id'] . "", "class" => "btn default btn-xs red btn-delete", "value" => '<i class="fa fa-trash-o"></i>&nbsp;Delete')) : '';

            $final_array = array(
                $txnId,
                $userName,
                DEFAULT_CURRENCY_SIGN.$amount,
                $paymentStatus,
                $createdDate,
            );
            /*if (in_array('status', $this->Permission)) {
                $final_array = array_merge($final_array, array($switch));
            }*/
            if (in_array('edit', $this->Permission) || in_array('delete', $this->Permission) || in_array('view', $this->Permission)) {
                $final_array = array_merge($final_array, array($operation));
            }

            $row_data[] = $final_array;
        }
        $result["sEcho"]                = $sEcho;
        $result["iTotalRecords"]        = (int) $totalRow;
        $result["iTotalDisplayRecords"] = (int) $totalRow;
        $result["aaData"]               = $row_data;
        return $result;

    }

    public function displaybox($text) {

        $text['label'] = isset($text['label']) ? $text['label'] : 'Enter Text Here: ';
        $text['value'] = isset($text['value']) ? $text['value'] : '';
        $text['name'] = isset($text['name']) ? $text['name'] : '';
        $text['class'] = isset($text['class']) ? 'form-control-static ' . trim($text['class']) : 'form-control-static';
        $text['onlyField'] = isset($text['onlyField']) ? $text['onlyField'] : false;
        $text['extraAtt'] = isset($text['extraAtt']) ? $text['extraAtt'] : '';

        $main_content = new MainTemplater(DIR_ADMIN_TMPL . $this->module . '/displaybox.tpl.php');
        $main_content = $main_content->parse();
        $fields = array("%LABEL%", "%CLASS%", "%VALUE%");
        $fields_replace = array($text['label'], $text['class'], $text['value']);
        return str_replace($fields, $fields_replace, $main_content);
    }

    public function toggel_switch($text)
    {
        $text['action']   = isset($text['action']) ? $text['action'] : 'Enter Action Here: ';
        $text['check']    = isset($text['check']) ? $text['check'] : '';
        $text['name']     = isset($text['name']) ? $text['name'] : '';
        $text['class']    = isset($text['class']) ? '' . trim($text['class']) : '';
        $text['extraAtt'] = isset($text['extraAtt']) ? $text['extraAtt'] : '';

        $main_content   = new MainTemplater(DIR_ADMIN_TMPL . $this->module . '/switch-nct.tpl.php');
        $main_content   = $main_content->parse();
        $fields         = array("%NAME%", "%CLASS%", "%ACTION%", "%EXTRA%", "%CHECK%");
        $fields_replace = array($text['name'], $text['class'], $text['action'], $text['extraAtt'], $text['check']);
        return str_replace($fields, $fields_replace, $main_content);
    }
    public function operation($text)
    {

        $text['href']     = isset($text['href']) ? $text['href'] : 'Enter Link Here: ';
        $text['value']    = isset($text['value']) ? $text['value'] : '';
        $text['name']     = isset($text['name']) ? $text['name'] : '';
        $text['class']    = isset($text['class']) ? '' . trim($text['class']) : '';
        $text['extraAtt'] = isset($text['extraAtt']) ? $text['extraAtt'] : '';
        $main_content     = new MainTemplater(DIR_ADMIN_TMPL . $this->module . '/operation-nct.tpl.php');
        $main_content     = $main_content->parse();
        $fields           = array("%HREF%", "%CLASS%", "%VALUE%", "%EXTRA%");
        $fields_replace   = array($text['href'], $text['class'], $text['value'], $text['extraAtt']);
        return str_replace($fields, $fields_replace, $main_content);
    }
    public function getPageContent()
    {
        $final_result             = null;
        $main_content             = new MainTemplater(DIR_ADMIN_TMPL . $this->module . "/" . $this->module . ".tpl.php");
        $main_content->breadcrumb = $this->getBreadcrumb();
        /*$main_content->getForm    = $this->getForm();*/

        $final_result = $main_content->parse();
        return $final_result;
    }
}
