<?php

class ManageServices extends Home {
	public $page_name;
	public $page_title;
	public $meta_keyword;
	public $meta_desc;
	public $page_desc;
	public $isActive;
	public $data = array();
	public function __construct($id=0, $searchArray=array(), $type='') {
		$this->data['id'] = $this->id = $id;
		$this->table = 'tbl_services';
		$this->type = ($this->id > 0 ? 'edit' : 'add');
		$this->searchArray = $searchArray;
		$this->langArray = array();
		parent::__construct();
		if($this->id>0){
			$qrySel = $this->db->pdoQuery("SELECT s.id,s.userId,s.categoryId,s.subCategoryId,s.title,s.slug,s.status,s.isFeatured,s.createdDate,sc.subCategoryName,c.cateName,u.userName,s.description,s.durationType,s.duration,s.additionalInfo,s.isActive,u.profileImage,u.email,sr.requirement,sr.type as srtype,sr.text,sr.file,sr.id as requirementId
                FROM tbl_services AS s
                INNER JOIN tbl_users AS u ON u.id = s.userId
                LEFT JOIN tbl_categories AS c ON c.id = s.categoryId
                LEFT JOIN tbl_subcategories AS sc ON sc.id = s.subCategoryId
                LEFT JOIN tbl_service_requirement AS sr ON sr.serviceId = s.id
                WHERE s.id = ? AND s.status != ? ",array($this->id,'i'))->result();
			foreach ($qrySel as $k => $v) {
                $this->{$k} = filtering($v);
            }
		}else{
			$fetchRes = $this->db->pdoQuery("SHOW COLUMNS FROM " . $this->table)->results();
            foreach ($fetchRes as $k => $v) {
                $this->{$v["Field"]} = $v["Default"];
            }
            $this->id = 0;
		}

		switch($type){
			case 'add' : {
				$this->data['content'] =  (in_array('add',$this->Permission))?$this->getForm():'';
				break;
			}
			case 'edit' : {
				$this->data['content'] =  (in_array('edit',$this->Permission))?$this->getForm():'';
				break;
			}
            case 'editstep1' : {
                $this->data['content'] =  (in_array('edit',$this->Permission))?$this->getStep1Form():'';
                break;
            }
            case 'editstep2' : {
                $this->data['content'] =  (in_array('edit',$this->Permission))?$this->getStep2Form():'';
                break;
            }
            case 'editstep3' : {
                $this->data['content'] =  (in_array('edit',$this->Permission))?$this->getStep3Form():'';
                break;
            }
            case 'editstep4' : {
                $this->data['content'] =  (in_array('edit',$this->Permission))?$this->getStep4Form():'';
                break;
            }
            case 'editstep5' : {
                $this->data['content'] =  (in_array('edit',$this->Permission))?$this->getStep5Form():'';
                break;
            }
			case 'view' : {
				$this->data['content'] =  (in_array('view',$this->Permission))?$this->viewForm():'';
				break;
			}
			case 'addRemoveCollection' : {
				$this->data['content'] =  (in_array('view',$this->Permission))?$this->getaddRemoveCollectionForm():'';
				break;
			}
			case 'delete' : {
				$this->data['content'] =  (in_array('delete',$this->Permission))?json_encode($this->dataGrid()):'';
				break;
			}

			case 'datagrid' : {
				$this->data['content'] =  (in_array('module',$this->Permission))?json_encode($this->dataGrid()):'';
			}
		}
	}

	public function viewForm(){
        $content = '';
        $duration = ($this->durationType == 'h' ? 'Hour' : 'Day');
        $duration = $this->duration.' '.($this->duration > 1 ? $duration.'s' : $duration);
        $display_status = 'Pending';
        if($this->status == 'p')
            $display_status = 'Pending';
        else if($this->status == 'd')
            $display_status = 'Denied';
        else if($this->status == 'a')
            $display_status = 'Approved';
        else
            $display_status = 'Pending';
        $replace = array(
            '%SERVICE_NAME%'        =>$this->title,
            '%CATEGORY%'            =>$this->cateName,
            '%SUB_CATEGORY%'        =>$this->subCategoryName,
            '%DESCRIPTION%'         =>$this->description,
            '%DURATION%'            =>$duration,
            '%ADD_INFO%'            =>($this->additionalInfo != '' ? $this->additionalInfo : 'N/A'),
            '%STATUS%'              =>$display_status,
            '%TAGS%'                =>$this->getServiceTagsHtml(),
            '%SERVICE_PACKAGES%'    =>$this->getServicePackagesHtml(),
            '%SERVICE_FAQ%'         =>$this->getServiceFAQsHtml(),
            '%SERVICE_GALLERY%'     =>$this->getServiceGalleryHtml(),
            '%CREATED_DATE%'        =>convertDate($this->createdDate,true),
            '%USER_NAME%'           =>ucfirst($this->userName),
            '%PRO_IMAGE%'           =>checkImage($this->profileImage,9,$this->userId),
            '%EMAIL%'               =>$this->email,
            '%REQUIREMNT%'          =>($this->requirement != '' ? $this->requirement : 'N/A'),
            '%EXTRA_REQUIREMENTS%'  =>$this->getExtraServiceDetails(),
            
        );
        $content = get_view(DIR_ADMIN_TMPL . $this->module . "/service-details-nct.tpl.php",$replace);
        return sanitize_output($content);
	}

    public function getExtraServiceDetails(){
        $content = '';
        if($this->srtype == 'fr'){
            $replace = array(
                '%TEXT_TYPE%'=>'Text',
                '%TEXT%'=>$this->text
            );
            $content = get_view(DIR_ADMIN_TMPL . $this->module . "/service-requirement-text-nct.tpl.php",$replace);
        }
        else if($this->srtype == 'f'){
            $file_icon = '';
            if($this->file != ''){
                $file_icon = getFileDisplayIcon(DIR_UPD.'services/'.$this->id.'/'.$this->file);
            }
            $replace = array(
                '%FILE_ICON%'           =>$file_icon,
                '%DOWNLOAD_URL%'        =>($this->file != '' ? SITE_ADM_MOD.$this->module.'/download_service_file.php?id='.$this->id.'&file='.$this->file.'&type=requirement' : 'javascript:void(0);'),
                '%FILE_NAME%'           =>$this->file
            );
            $content = get_view(DIR_ADMIN_TMPL . $this->module . "/service-requirement-file-nct.tpl.php",$replace);
        }
        else{
            $q = $this->db->pdoQuery("SELECT rl.text
                FROM tbl_service_requirement_list AS rl WHERE rl.requirementId = ? ",array($this->requirementId));
            if($q->affectedRows() > 0){
                $main_content = (new MainTemplater(DIR_ADMIN_TMPL . $this->module . "/service-requirement-text-nct.tpl.php"))->parse();
                foreach ($q->results() as $key => $value) {
                    $replace = array(
                        '%TEXT_TYPE%'=>'Description',
                        '%TEXT%'=>$value['text']
                    );
                    $content .= str_replace(array_keys($replace), array_values($replace),$main_content);
                }
            }
        }
        return sanitize_output($content);
    }

    public function getServiceGalleryHtml(){
        $content = '';
        $main_content = (new MainTemplater(DIR_ADMIN_TMPL . $this->module . "/service-gallery-files-nct.tpl.php"))->parse();
        $q = $this->db->pdoQuery("SELECT sg.fileType,sg.fileName
            FROM tbl_service_gallery AS sg
            WHERE sg.serviceId = ? ",array($this->id));
        if($q->affectedRows() > 0){
            foreach ($q->results() as $key => $value){
                $replace = array(
                    '%DOWNLOAD_URL%'    =>($value['fileName'] != '' ? SITE_ADM_MOD.$this->module.'/download_service_file.php?id='.$this->id.'&file='.$value['fileName'].'&type=gallery' : 'javascript:void(0);'),
                    '%FILE_ICON%'       =>getFileDisplayIcon(DIR_UPD.'services/'.$this->id.'/'.$value['fileName']),
                    '%FILE_NAME%'       =>$value['fileName']
                );
                $content .= str_replace(array_keys($replace), array_values($replace),$main_content);
            }
        }
        return ($content != '' ? $content : NRF);
    }

    public function getServicePackagesHtml(){
        $content = '';
        $main_content = (new MainTemplater(DIR_ADMIN_TMPL . $this->module . "/service-packages-nct.tpl.php"))->parse();
        $q = $this->db->pdoQuery("SELECT p.name,sp.description,sp.deliveryDays,sp.price,sp.extraService,sp.extraServicePrice
            FROM tbl_service_packages AS sp 
            LEFT JOIN tbl_packages AS p ON p.id = sp.packageId
            WHERE sp.serviceId = ? ",array($this->id));
        if($q->affectedRows() > 0){
            foreach ($q->results() as $key => $value){
                $replace = array(
                    '%PACKAGE_NAME%'        =>$value['name'],
                    '%DESCRIPTION%'         =>$value['description'],
                    '%DELIVERY_DAYS%'       =>$value['deliveryDays'],
                    '%PRICE%'               =>$this->cSign.$value['price'],
                    '%EXTRA_SERVICE%'       =>$value['extraService'],
                    '%EXTRA_SERVICE_PRICE%'  =>$this->cSign.$value['extraServicePrice']
                );
                $content .= str_replace(array_keys($replace), array_values($replace),$main_content);
            }
        }
        return ($content != '' ? $content : NRF);
    }

    public function getServiceFAQsHtml(){
        $content = '';
        $main_content = (new MainTemplater(DIR_ADMIN_TMPL . $this->module . "/service-faq-nct.tpl.php"))->parse();
        $q = $this->db->pdoQuery("SELECT sf.question,sf.answer
            FROM tbl_service_faq AS sf 
            WHERE sf.serviceId = ? ",array($this->id));
        if($q->affectedRows() > 0){
            foreach ($q->results() as $key => $value){
                $replace = array(
                    '%NO%'              =>($key + 1),
                    '%QUESTION%'        =>$value['question'],
                    '%ANSWERR%'         =>$value['answer']
                );
                $content .= str_replace(array_keys($replace), array_values($replace),$main_content);
            }
        }
        return ($content != '' ? $content : NRF);
    }

    public function getServiceTagsHtml(){
        $content = '';
        $main_content = (new MainTemplater(DIR_ADMIN_TMPL . $this->module . "/service-tags-nct.tpl.php"))->parse();
        $q = $this->db->pdoQuery("SELECT t.tagName
            FROM tbl_service_tags AS st 
            LEFT JOIN tbl_tags AS t ON t.id = st.tagId
            WHERE st.serviceId = ? ",array($this->id));
        if($q->affectedRows() > 0){
            foreach ($q->results() as $key => $value){
                $replace = array(
                    '%TAG_NAME%'  =>$value['tagName']
                );
                $content .= str_replace(array_keys($replace), array_values($replace),$main_content);
            }
        }
        return $content;
    }

	public function getaddRemoveCollectionForm() {
		$content = '';
        $replace = array(
            '%COLLECTION_OPTION%'=>$this->getCollectionSelections(),
            '%SERVICE_NAME%'=>$this->title,
            '%TYPE%'=>$this->type,
            '%ID%'=>$this->id
        );
        $content = get_view(DIR_ADMIN_TMPL . $this->module . "/add-remove-collection-nct.tpl.php",$replace);
        return sanitize_output($content);
	}

	public function getCollectionSelections(){
        $content= '';
        $c_q= $this->db->pdoQuery("SELECT t.id,t.name,
        		( SELECT id FROM tbl_trending_collections_services WHERE trendingId = t.id AND serviceId = ? ) as count
                FROM tbl_trending_collections AS t
                WHERE 1 = ?  ",array($this->id,1));
        $main_content = new MainTemplater(DIR_ADMIN_TMPL."/option-nct.tpl.php");
        $main_content = $main_content->parse();
        if($c_q->affectedRows() > 0){
            foreach ($c_q->results() as $key => $value) {
                $selected = ($value['count'] > 0 ? 'selected' : '');
                $replace = array(
                    '%OPT_VALUE%'   =>$value['id'],
                    '%EXTRA%'       =>'',
                    '%SELECTED%'    =>$selected,
                    '%OPT_TEXT%'    =>$value['name']
                );
                $content .= str_replace(array_keys($replace),array_values($replace),$main_content); 
            }
        }
        return $content;
    }

	public function getForm() {
		$content = '';
        $status_a = ($this->isActive == 'y' ? 'checked' : '');
        $status_d = ($this->isActive != 'y' ? 'checked' : '');

        $replace = array(
        );
        $content = get_view(DIR_ADMIN_TMPL . $this->module . "/form-step1-nct.tpl.php",$replace);
        return sanitize_output($content);
	}

    public function getFormStepContent($active_step = 1) {
        $content = '';
        $replace = array(
            '%ID%'=>$this->id,
            '%STEP1_CLASS%'=>($active_step >= 1 ? 'active' : ''),
            '%STEP2_CLASS%'=>($active_step >= 2 ? 'active' : ''),
            '%STEP3_CLASS%'=>($active_step >= 3 ? 'active' : ''),
            '%STEP4_CLASS%'=>($active_step >= 4 ? 'active' : ''),
            '%STEP5_CLASS%'=>($active_step >= 5 ? 'active' : ''),
            '%STEP1_ACTION%'=>'1',
            '%STEP2_ACTION%'=>'2',
            '%STEP3_ACTION%'=>'3',
            '%STEP4_ACTION%'=>'4',
            '%STEP5_ACTION%'=>'5'
        );
        $content = get_view(DIR_ADMIN_TMPL . $this->module . "/steps-process-nct.tpl.php",$replace);
        return sanitize_output($content);
    }

    public function getDurationSelection() {
        $main_content = (new MainTemplater(DIR_ADMIN_TMPL."/option-nct.tpl.php"))->parse();
        $content = '';
        $count = ($this->durationType == 'h' ? 23 : 31);
        for ($i=1; $i <= $count ;$i++) { 
            $replace = array(
                '%OPT_VALUE%'   =>$i,
                '%EXTRA%'       =>'',
                '%SELECTED%'    =>($this->duration == $i ? 'selected="selected"' : ''),
                '%OPT_TEXT%'    =>$i
            );
            $content .= str_replace(array_keys($replace),array_values($replace),$main_content); 
        }
        return sanitize_output($content);
    }

    public function getCategorySelection($categoryId=0){
        $content= '';
        $c_q= $this->db->pdoQuery("SELECT id,cateName FROM tbl_categories WHERE isActive = ? ",array('y'));
        $main_content = new MainTemplater(DIR_ADMIN_TMPL."/option-nct.tpl.php");
        $main_content = $main_content->parse();
        if($c_q->affectedRows() > 0){
            foreach ($c_q->results() as $key => $value) {
                $selected = ($categoryId == $value['id'] ? 'selected' : '');
                $replace = array(
                    '%OPT_VALUE%'=>$value['id'],
                    '%EXTRA%'=>'',
                    '%SELECTED%'=>$selected,
                    '%OPT_TEXT%'=>$value['cateName']
                );
                $content .= str_replace(array_keys($replace),array_values($replace),$main_content); 
            }
        }
        return $content;
    }

    public function getSubCategorySelection($categoryId=0,$subCategoryId=0){
        $content= '';
        $c_q= $this->db->pdoQuery("SELECT id,subCategoryName FROM tbl_subcategories WHERE categoryId = ? AND isActive = ? ",array($categoryId,'y'));
        $main_content = new MainTemplater(DIR_ADMIN_TMPL."/option-nct.tpl.php");
        $main_content = $main_content->parse();
        if($c_q->affectedRows() > 0){
            foreach ($c_q->results() as $key => $value) {
                $selected = ($subCategoryId == $value['id'] ? 'selected' : '');
                $replace = array(
                    '%OPT_VALUE%'=>$value['id'],
                    '%EXTRA%'=>'',
                    '%SELECTED%'=>$selected,
                    '%OPT_TEXT%'=>$value['subCategoryName']
                );
                $content .= str_replace(array_keys($replace),array_values($replace),$main_content); 
            }
        }
        return $content;
    }

    public function getServiceTags($id,$return_type='array'){
        $q = $this->db->pdoQuery("SELECT GROUP_CONCAT(t.tagName) as tags
                FROM tbl_service_tags AS st
                LEFT JOIN tbl_tags AS t ON t.id = st.tagId 
                WHERE st.serviceId = ? ",array($id))->result();
        if(isset($q['tags']) && $q['tags'] != ''){
            if($return_type == 'string'){
                return $q['tags'];
            }
            else if($return_type == 'json'){
                return json_encode(explode(',',$q['tags']));
            }
            else{
                return explode(',',$q['tags']);
            }
        }
        else{
            if($return_type == 'string'){
                return '';
            }
            else if($return_type == 'json'){
                return json_encode(array());
            }
            else{
                return array();
            }
        }
    }

    public function getServiceTagsSuggestions($data=array()){
        extract($data);
        if(isset($query) && $query != ''){
            $q = $this->db->pdoQuery("SELECT GROUP_CONCAT(t.tagName) as tags
                    FROM tbl_tags AS t
                    WHERE tagName LIKE '%$query%'  ")->result();
            if(isset($q['tags']) && $q['tags'] != ''){
                if($return_type == 'string'){
                    return $q['tags'];
                }
                else if($return_type == 'json'){
                    return json_encode(explode(',',$q['tags']));
                }
                else{
                    return explode(',',$q['tags']);
                }
            }
            else{
                if($return_type == 'string'){
                    return '';
                }
                else if($return_type == 'json'){
                    return json_encode(array());
                }
                else{
                    return array();
                }
            }
        }
    }

    public function getServicePackageContent($count = 0,$data = array()){
        $content = '';
        $replace = array(
            '%PID%'                 =>$count,
            '%PACKAGE_NAME%'        =>(!empty($data) ? $data['name'] : ''),
            '%DESCRIPTION%'         =>((!empty($data) && isset($data['description'])) ? $data['description'] : ''),
            '%DELIVERYDAYS%'        =>((!empty($data) && isset($data['deliveryDays'])) ? $data['deliveryDays'] : ''),
            '%PRICE%'               =>((!empty($data) && isset($data['price'])) ? $data['price'] : ''),
            '%EXTRA_SERVICE%'       =>((!empty($data) && isset($data['extraService'])) ? $data['extraService'] : ''),
            '%EXTRA_SERVICE_PRICE%' =>((!empty($data) && isset($data['extraServicePrice'])) ? $data['extraServicePrice'] : '')
        );
        $content .= get_view(DIR_ADMIN_TMPL . $this->module . "/packages-form-nct.tpl.php",$replace);
        return sanitize_output($content);
    }

    public function getServiceFaqContent($count = 0,$data = array()){
        $content = '';
        $replace = array(
            '%FID%'                 =>$count,
            '%COUNT%'               =>$data['count'],
            '%QUESTION%'            =>((!empty($data) && isset($data['question'])) ? $data['question'] : ''),
            '%ANSWER%'              =>((!empty($data) && isset($data['answer'])) ? $data['answer'] : '')
        );
        $content .= get_view(DIR_ADMIN_TMPL . $this->module . "/faq-form-nct.tpl.php",$replace);
        return sanitize_output($content);
    }

    public function getServiceRequirementTextContent($count = 0,$data = array()){
        $content = '';
        $replace = array(
            '%RID%'     =>$count,
            '%COUNT%'   =>$data['count'],
            '%TEXT%'    =>((!empty($data) && isset($data['text'])) ? $data['text'] : '')
        );
        $content .= get_view(DIR_ADMIN_TMPL . $this->module . "/text-list-nct.tpl.php",$replace);
        return sanitize_output($content);
    }

    public function getServiceGalleryContent($count = 0,$data = array()){
        $content = '';
        $id             = issetor($data['id'],0);
        $count          = issetor($data['count'],0);
        $count          = ($id > 0 ? $id : $count);
        $fileName       = filtering(issetor($data['fileName'],''),'output','string');
        $fileType       = filtering(issetor($data['fileType'],''),'output','string');
        $replace = array(
            '%GID%'             =>$count,
            '%COUNT%'           =>$count,
            '%IMAGE%'           =>checkImage($data['fileName'],8,$this->id),
            '%IMAGE_CLASS%'     =>($fileType == 'v' ? 'hide1' : ''),
            '%VIDEO_CLASS%'     =>(($fileType == 'i' || $fileType == '') ? 'hide1' : ''),
            '%VIDEO%'           =>($fileType == 'v' ? SITE_UPD.'services/'.$this->id.'/'.$fileName : ''),
            '%FILE_NAME%'       =>$fileName,
            '%DEST_SITE_URL%'   =>SITE_UPD.'services/temp_dir/'.$this->id.'/',
            "%DEST_DIR_URL%"    =>DIR_UPD.'services/temp_dir/'.$this->id.'/'
        );
        $temp_file = 'gallery-nct.tpl.php';
        if($id > 0 && $fileName != ''){
            $temp_file = 'preview-gallery-nct.tpl.php';
        }
        else{
            $temp_file = 'gallery-nct.tpl.php';
        }
        $content .= get_view(DIR_ADMIN_TMPL . $this->module . "/".$temp_file,$replace);
        return sanitize_output($content);
    }
 
    public function getStep1Form(){
        $content = '';
        $replace = array(
            '%STEP_PROCESS%'    =>$this->getFormStepContent(1),
            '%TITLE%'           =>$this->title,
            '%CATEGORY_OPT%'    =>$this->getCategorySelection($this->categoryId),
            '%SUBCATEGORY_OPT%' =>$this->getSubCategorySelection($this->categoryId,$this->subCategoryId),
            '%DESCRIPTION%'     =>$this->description,
            '%DURATION_TYPE_H%' =>($this->durationType == 'h' ? 'checked' : ''),
            '%DURATION_TYPE_D%' =>($this->durationType == 'd' ? 'checked' : ''),
            '%STATUS_A%'        =>($this->isActive == 'y' ? 'checked' : ''),
            '%STATUS_D%'        =>($this->isActive == 'n' ? 'checked' : ''),
            '%DURATION_OPT%'    =>$this->getDurationSelection(),
            '%ADDITIONAL_INFO%' =>$this->additionalInfo,
            '%TAGS%'            =>$this->getServiceTags($this->id,'json'),
            '%SUG_TAGS%'        =>json_encode(array()),
            '%TYPE%'            =>$this->type,
            '%ID%'              =>$this->id
        );
        $content = get_view(DIR_ADMIN_TMPL . $this->module . "/form-step1-nct.tpl.php",$replace);
        return sanitize_output($content);
    }

    public function getStep2Form(){
        $content = '';
        $packages_list = '';
        $q = $this->db->pdoQuery("SELECT sp.*,p.name
            FROM tbl_service_packages AS sp
            INNER JOIN tbl_packages AS p ON p.id = sp.packageId
            WHERE sp.serviceId = ? ",array($this->id));
        if($q->affectedRows() > 0){
            foreach ($q->results() as $key => $value) {
                $packages_list .= $this->getServicePackageContent($value['packageId'],$value);
            }
        }
        $replace = array(
            '%STEP_PROCESS%'    =>$this->getFormStepContent(2),
            '%PACKAHES_LIST%'   =>$packages_list,
            '%AJAX_URL%'        =>SITE_ADM_MOD.$this->module.'/ajax.'.$this->module.'.php',
            '%TYPE%'            =>$this->type,
            '%ID%'              =>$this->id
        );
        $content = get_view(DIR_ADMIN_TMPL . $this->module . "/form-step2-nct.tpl.php",$replace);
        return sanitize_output($content);
    }

    public function getStep3Form(){
        $content = '';
        $faq_list = '';
        $q = $this->db->pdoQuery("SELECT sf.id,sf.question,sf.answer
            FROM tbl_service_faq AS sf
            WHERE sf.serviceId = ? ",array($this->id));
        if($q->affectedRows() > 0){
            foreach ($q->results() as $key => $value) {
                $value['count'] = ($key+1);
                $faq_list .= $this->getServiceFaqContent($value['id'],$value);
            }
        }
        $replace = array(
            '%FAQ_LIST%'        =>$faq_list,
            '%STEP_PROCESS%'    =>$this->getFormStepContent(3),
            '%AJAX_URL%'        =>SITE_ADM_MOD.$this->module.'/ajax.'.$this->module.'.php',
            '%TYPE%'            =>$this->type,
            '%ID%'              =>$this->id
        );
        $content = get_view(DIR_ADMIN_TMPL . $this->module . "/form-step3-nct.tpl.php",$replace);
        return sanitize_output($content);
    }

    public function getStep4Form() {
        $content = '';
        $text_list = '';
        $q = $this->db->pdoQuery("SELECT rl.id,rl.text
            FROM tbl_service_requirement_list AS rl
            WHERE rl.requirementId = ? ",array($this->requirementId));
        if($q->affectedRows() > 0){
            foreach ($q->results() as $key => $value) {
                $value['count'] = ($key+1);
                $text_list .= $this->getServiceRequirementTextContent($value['id'],$value);
            }
        }
        $replace = array(
            '%REQUIREMENT_ID%'  =>$this->requirementId,
            '%TEXT_LIST%'       =>$text_list,
            '%REQUIRMENT%'      =>$this->requirement,
            '%SELECT_TYPE%'     =>($this->srtype != '' ? $this->srtype : 'fr'),
            '%TEXT%'            =>$this->text,
            '%STEP_PROCESS%'    =>$this->getFormStepContent(4),
            '%AJAX_URL%'        =>SITE_ADM_MOD.$this->module.'/ajax.'.$this->module.'.php',
            '%TYPE%'            =>$this->type,
            '%ID%'              =>$this->id
        );
        $content = get_view(DIR_ADMIN_TMPL . $this->module . "/form-step4-nct.tpl.php",$replace);
        return sanitize_output($content);
    }

    public function getStep5Form(){
        $content = '';
        $gallery_list = '';
        $q = $this->db->pdoQuery("SELECT sg.id,sg.fileType,sg.fileName
            FROM tbl_service_gallery AS sg
            WHERE sg.serviceId = ? ",array($this->id));
        if($q->affectedRows() > 0){
            foreach ($q->results() as $key => $value) {
                $value['count'] = ($key+1);
                $gallery_list .= $this->getServiceGalleryContent($value['id'],$value);
            }
        }
        $replace = array(
            '%GALLERY_LIST%'    =>$gallery_list,
            '%STEP_PROCESS%'    =>$this->getFormStepContent(5),
            '%AJAX_URL%'        =>SITE_ADM_MOD.$this->module.'/ajax.'.$this->module.'.php',
            '%TYPE%'            =>$this->type,
            '%ID%'              =>$this->id
        );
        $content = get_view(DIR_ADMIN_TMPL . $this->module . "/form-step5-nct.tpl.php",$replace);
        return sanitize_output($content);
    }

	public function dataGrid() {
		$content = $operation = $whereCond = $totalRow = NULL;
        $result = $tmp_rows = $row_data = array();
        extract($this->searchArray);
        $chr = str_replace(array('_','%'), array('\_','\%'), $chr);
        $sWhere = ' WHERE  s.isActive != ?  ';
        $aWhere = array('i');

        if (isset($chr) && $chr != '') {
            $sWhere .= " AND (s.title LIKE ? OR c.cateName LIKE ? OR sc.subCategoryName LIKE ? OR u.userName LIKE ?  )";
            $aWhere[] = "%$chr%";
            $aWhere[] = "%$chr%";
            $aWhere[] = "%$chr%";
            $aWhere[] = "%$chr%";
        }

        if (isset($sort))
            $sorting = $sort . ' ' . $order;
        else
            $sorting = 's.id DESC';

        if (isset($fil_status) && $fil_status != '') {
            $sWhere .= " AND s.status = ? ";
            $aWhere[] = $fil_status;
        }


        $totalRowTmp = $this->db->pdoQuery("SELECT COUNT(s.id) AS nmrows 
                    FROM tbl_services AS s
                    INNER JOIN tbl_users AS u ON u.id = s.userId
                    LEFT JOIN tbl_categories AS c ON c.id = s.categoryId
                    LEFT JOIN tbl_subcategories AS sc ON sc.id = s.subCategoryId 
                    $sWhere", $aWhere)->result();
        $totalRow = $totalRowTmp['nmrows'];


        $qrySel = $this->db->pdoQuery("SELECT s.id,s.userId,s.categoryId,s.subCategoryId,s.title,s.slug,s.status,s.isFeatured,s.createdDate,sc.subCategoryName,c.cateName,u.userName,s.isActive
                    FROM tbl_services AS s
                    INNER JOIN tbl_users AS u ON u.id = s.userId
                    LEFT JOIN tbl_categories AS c ON c.id = s.categoryId
                    LEFT JOIN tbl_subcategories AS sc ON sc.id = s.subCategoryId
                    $sWhere ORDER BY $sorting limit $offset , $rows", $aWhere)->results();
        foreach ($qrySel as $fetchRes) {
            $id = $fetchRes['id'];

            $display_status = 'Pending';
            if($fetchRes['status'] == 'p')
            	$display_status = 'Pending';
            else if($fetchRes['status'] == 'd')
            	$display_status = 'Denied';
            else if($fetchRes['status'] == 'a')
            	$display_status = 'Approved';
            else
            	$display_status = 'Pending';

            
            $id_disable = '';
            if($fetchRes['status'] == "a" || $fetchRes['status'] == "d"){
            	$id_disable = ' disabled ';
            }

            $check_approve = ($fetchRes['status'] == "a") ? "checked" : "";
        	$check_pending = ($fetchRes['status'] == "p") ? "checked" : "";
        	$check_disapprove = ($fetchRes['status'] == "d") ? "checked" : "";
        	$switchApprove = (in_array('status', $this->Permission)) ? $this->toggel_switch_approve(array("action" => "ajax." . $this->module . ".php?id=" . $id . "&action=approveService", "id" => $id, "check_approve" => $check_approve, "check_pending" => $check_pending, "check_disapprove" => $check_disapprove,"extraAtt"=>$id_disable)) : '';

            $id_disable = '';
            if($fetchRes['status'] == "p" || $fetchRes['status'] == "d"){
            	$id_disable = ' disabled="disabled" ';
            }
        	$status = ($fetchRes['isActive'] == "y") ? "checked" : "";
        	$isFeatured = ($fetchRes['isFeatured'] == "y") ? "checked" : "";

        	$switch = (in_array('status', $this->Permission)) ? $this->toggel_switch(array("action" => "ajax." . $this->module . ".php?id=" . $id . "", "check" => $status,"extraAtt"=>$id_disable)) : '';

        	$switch_action = "data-switch_action='is_popular'";
        	$switchFeature = (in_array('status', $this->Permission)) ? $this->toggel_switch(array("action" => "ajax." . $this->module . ".php?id=" . $id . "", "check" => $isFeatured,"extraAtt"=>$switch_action.$id_disable)) : '';
            
            $operation = '';
            if($fetchRes['status'] == "a"){
            	$operation = (in_array('view', $this->Permission)) ? '&nbsp;&nbsp;' . $this->operation(array("href" => "ajax." . $this->module . ".php?action=addRemoveCollection&id=" . $fetchRes['id'] . "", "class" => "btn default green btn-xs btn-viewbtn", "value" => '<i class="fa fa-bars"></i>',"extraAtt"=>"data-page_title='Add/Remove Service To Collections'")) : '';
            }

            $operation .= (in_array('view', $this->Permission)) ? '&nbsp;&nbsp;' . $this->operation(array("href" => "ajax." . $this->module . ".php?action=view&id=" . $fetchRes['id'] . "", "class" => "btn default blue btn-xs btnEdit", "value" => '<i class="fa fa-laptop"></i>')) : '';
            if($fetchRes['status'] == "a"){
                $operation .= (in_array('edit', $this->Permission)) ? '&nbsp;&nbsp;' . $this->operation(array("href" => SITE_ADM_MOD . $this->module . "/ajax." . $this->module . ".php?action=editstep1&id=" . $id, "class" => "btn default btn-xs black btnEdit", "value" => '<i class="fa fa-edit"></i>')) : '';
            }

            $operation .= (in_array('delete', $this->Permission)) ? '&nbsp;&nbsp;' . $this->operation(array("href" => "ajax." . $this->module . ".php?action=delete&id=" . $fetchRes['id'] . "", "class" => "btn default btn-xs red btn-delete", "value" => '<i class="fa fa-trash-o"></i>')) : '';
            $final_array = array(
                $id,
                filtering($fetchRes['title'], 'output', 'string'),
                filtering($fetchRes['userName'], 'output', 'string'),
                filtering($fetchRes['cateName'], 'output', 'string'),
                filtering($fetchRes['subCategoryName'], 'output', 'string'),
                $display_status/*,
               	convertDate($fetchRes['createdDate'],true)*/
            );

            if (in_array('status', $this->Permission)) {
                $final_array = array_merge($final_array, array($switchApprove));
                $final_array = array_merge($final_array, array($switch));
                $final_array = array_merge($final_array, array($switchFeature));
            }
            if (in_array('edit', $this->Permission) || in_array('delete', $this->Permission) || in_array('view', $this->Permission)) {
                $final_array = array_merge($final_array, array(
                    $operation));
            }

            $row_data[] = $final_array;
        }

        $result["sEcho"] = $sEcho;
        $result["iTotalRecords"] = (int) $totalRow;
        $result["iTotalDisplayRecords"] = (int) $totalRow;
        $result["aaData"] = $row_data;

        return $result;
	}
	
	public function toggel_switch_approve($text) {
		$text['id']    = isset($text['id']) ? '' . trim($text['id']) : '0';
		$text['check_approve']    = isset($text['check_approve']) ? '' . trim($text['check_approve']) : '';
		$text['check_pending']    = isset($text['check_pending']) ? '' . trim($text['check_pending']) : '';
		$text['check_disapprove']    = isset($text['check_disapprove']) ? '' . trim($text['check_disapprove']) : '';
		$text['value_approve']    = isset($text['value_approve']) ? '' . trim($text['value_approve']) : 'a';
		$text['value_pending']    = isset($text['value_pending']) ? '' . trim($text['value_pending']) : 'p';
		$text['value_disapprove']    = isset($text['value_disapprove']) ? '' . trim($text['value_disapprove']) : 'd';
		$text['class']    = isset($text['class']) ? '' . trim($text['class']) : '';
		$text['action']    = isset($text['action']) ? '' . trim($text['action']) : '';
		$text['extraAtt'] = isset($text['extraAtt']) ? $text['extraAtt'] : '';
		$main_content     = new MainTemplater(DIR_ADMIN_TMPL . $this->module . '/switch-approve-nct.tpl.php');
		$main_content     = $main_content->parse();

		$replace = array(
			"%ID%" 					=> $text['id'],
			"%VALUE_APPROVE%" 		=> $text['value_approve'],
			"%VALUE_PENDING%" 		=> $text['value_pending'],
			"%VALUE_DISAPPROVE%" 	=> $text['value_disapprove'],
			"%CHECKED_APPROVE%" 	=> $text['check_approve'],
			"%CHECKED_PENDING%" 	=> $text['check_pending'],
			"%CHECKED_DISAPPROVE%" 	=> $text['check_disapprove'],
			"%CLASS%" 				=> $text['class'],
			"%ACTION%" 				=> $text['action'],
			"%EXTRA%" 				=> $text['extraAtt']
		);
		return str_replace(array_keys($replace),array_values($replace), $main_content);
	}

	public function toggel_switch($text) {
		$text['action']   = isset($text['action']) ? $text['action'] : 'Enter Action Here: ';
		$text['check']    = isset($text['check']) ? $text['check'] : '';
		$text['name']     = isset($text['name']) ? $text['name'] : '';
		$text['class']    = isset($text['class']) ? '' . trim($text['class']) : '';
		$text['extraAtt'] = isset($text['extraAtt']) ? $text['extraAtt'] : '';
		$main_content     = new MainTemplater(DIR_ADMIN_TMPL . $this->module . '/switch-nct.tpl.php');
		$main_content     = $main_content->parse();
		$fields           = array("%NAME%", "%CLASS%", "%ACTION%", "%EXTRA%", "%CHECK%");
		$fields_replace   = array($text['name'], $text['class'], $text['action'], $text['extraAtt'], $text['check']);
		return str_replace($fields, $fields_replace, $main_content);
	}
	
	public function textArea($text) {
		$text['label']     = isset($text['label']) ? $text['label'] : 'Enter Password Here: ';
		$text['value']     = isset($text['value']) ? $text['value'] : '';
		$text['name']      = isset($text['name']) ? $text['name'] : '';
		$text['class']     = isset($text['class']) ? "form-control " . $text['class'] : 'form-control';
		$text['extraAtt']  = isset($text['extraAtt']) ? ' ' . $text['extraAtt'] : '';
		$text['onlyField'] = isset($text['onlyField']) ? $text['onlyField'] : false;
		if ($text["onlyField"] == true) {
			$main_content = new MainTemplater(DIR_ADMIN_TMPL . $this->module . '/textarea_onlyfield.tpl.php');
		} else {
			$main_content = new MainTemplater(DIR_ADMIN_TMPL . $this->module . '/textarea.tpl.php');
		}
		$main_content   = $main_content->parse();
		$fields         = array("%CLASS%", "%NAME%", "%ID%", "%VALUE%", "%EXTRA%", "%LABEL%");
		$fields_replace = array($text['class'], $text['name'], $text['name'], $text['value'], $text['extraAtt'], $text['label']);
		return str_replace($fields, $fields_replace, $main_content);
	}
	public function operation($text) {

		$text['href']     = isset($text['href']) ? $text['href'] : 'Enter Link Here: ';
		$text['value']    = isset($text['value']) ? $text['value'] : '';
		$text['name']     = isset($text['name']) ? $text['name'] : '';
		$text['class']    = isset($text['class']) ? '' . trim($text['class']) : '';
		$text['extraAtt'] = isset($text['extraAtt']) ? $text['extraAtt'] : '';
		$main_content     = new MainTemplater(DIR_ADMIN_TMPL . $this->module . '/operation-nct.tpl.php');
		$main_content     = $main_content->parse();
		$fields           = array("%HREF%", "%CLASS%", "%VALUE%", "%EXTRA%");
		$fields_replace   = array($text['href'], $text['class'], $text['value'], $text['extraAtt']);
		return str_replace($fields, $fields_replace, $main_content);
	}
	public function displaybox($text) {

		$text['label']     = isset($text['label']) ? $text['label'] : 'Enter Text Here: ';
		$text['value']     = isset($text['value']) ? $text['value'] : '';
		$text['name']      = isset($text['name']) ? $text['name'] : '';
		$text['class']     = isset($text['class']) ? 'form-control-static ' . trim($text['class']) : 'form-control-static';
		$text['onlyField'] = isset($text['onlyField']) ? $text['onlyField'] : false;
		$text['extraAtt']  = isset($text['extraAtt']) ? $text['extraAtt'] : '';

		$main_content      = new MainTemplater(DIR_ADMIN_FIELDS_HTML. '/displaybox.tpl.php');
		$main_content      = $main_content->parse();
		$fields            = array("%LABEL%", "%CLASS%", "%VALUE%");
		$fields_replace    = array($text['label'], $text['class'], $text['value']);
		return str_replace($fields, $fields_replace, $main_content);
	}

	public function getPageContent(){
		$final_result             = NULL;
		$main_content             = new MainTemplater(DIR_ADMIN_TMPL.$this->module."/".$this->module.".tpl.php");
		$main_content->breadcrumb = $this->getBreadcrumb();
		$main_content->langArray  = $this->langArray;
        $main_content->id = $this->id;
		$final_result             = $main_content->parse();
		return $final_result;
	}

}