<?php

class Feedback extends Home {

    public $category;
    public $status;
    public $data = array();

    public function __construct($module, $id = 0, $objPost = NULL, $searchArray = array(), $type = '') {
        global $db, $fields, $sessCataId;
        $this->db = $db;
        $this->data['id'] = $this->id = $id;
        $this->fields = $fields;
        $this->module = $module;
        $this->table = 'tbl_feedback';

        $this->type = ($this->id > 0 ? 'edit' : 'add');
        $this->searchArray = $searchArray;
        parent::__construct();
        if ($this->id > 0) {
            $qrySel = $this->db->select('tbl_feedback', "*", array("id" => $id))->result();
            $fetchRes = $qrySel;
            $this->data['firstName'] = $this->firstName = filtering($fetchRes['firstName']);
            $this->data['lastName']  = $this->lastName = filtering($fetchRes['lastName'], 'output', 'text');
            $this->data['message']   = $this->message = filtering($fetchRes['message']);
            $this->data['email']     = $this->email = filtering($fetchRes['email']);
            $this->data['status']    = $this->status = filtering($fetchRes['status']);
            $this->data['user_img']  = $this->user_img = $fetchRes['user_img'];
            $this->data['createdDate']  = $this->createdDate = $fetchRes['createdDate'];
        } else {
            $this->data['firstName'] = $this->firstName = '';
            $this->data['lastName']  = $this->lastName = '';
            $this->data['message']   = $this->message = '';
            $this->data['email']     = $this->email = '';
            $this->data['status']    = $this->status = 'y';
            $this->data['createdDate']  = $this->createdDate = '';
            $this->data['user_img']  = $this->user_img = '';
        }
        switch ($type) {
            case 'add' : {
                    $this->data['content'] = (in_array('add', $this->Permission)) ? $this->getForm() : '';
                    break;
                }
            case 'edit' : {
                    $this->data['content'] = (in_array('edit', $this->Permission)) ? $this->getForm() : '';
                    break;
                }
            case 'view' : {
                    $this->data['content'] = (in_array('view', $this->Permission)) ? $this->viewForm() : '';
                    break;
                }
            case 'delete' : {
                    $this->data['content'] = (in_array('delete', $this->Permission)) ? json_encode($this->dataGrid()) : '';
                    break;
                }
            case 'datagrid' : {
                    $this->data['content'] = (in_array('module', $this->Permission)) ? json_encode($this->dataGrid()) : '';
                }
        }
    }

    public function viewForm() {
        if($this->user_img!="" && file_exists(DIR_UPD.'feedback/th1_'.$this->user_img)){
            $image = SITE_UPD.'feedback/th1_'.$this->user_img;
        }else{
            $image = SITE_UPD.'th2_no_user_image.png';
        }
        $content = $this->displayBox(array("label" => "Username&nbsp;:", "value" =>  $this->firstName.' '. $this->lastName)) .
        $this->displayBox(array("label" => "Feedback&nbsp;:", "value" => $this->message)).
        $this->displayBox(array("label" => "Date&nbsp;:", "value" => $this->createdDate)).
        $this->displayBox(array("label" => "Image&nbsp;:", "value" => '<img src='.$image.'>')).
        $this->displayBox(array("label" => "Status&nbsp;:", "value" => $this->status == 'y' ? 'Active' : 'Deactive'));

        return $content;
    }

    public function getForm() {
        $content = '';

        $main_content = new MainTemplater(DIR_ADMIN_TMPL . $this->module . "/form-nct.tpl.php");
        $main_content = $main_content->parse();
        if($this->user_img!="" && file_exists(DIR_UPD.'feedback/th1_'.$this->user_img)){
            $image = SITE_UPD.'feedback/th1_'.$this->user_img;
        }else{
            $image = SITE_UPD.'th2_no_user_image.png';
        }
        $fields = array("%MEND_SIGN%","%USER_IMG%", "%FIRSTNAME%", "%MESSAGE%", "%LASTNAME%", "%EMAIL%", "%ID%",  "%TYPE%" );

        $fields_replace = array(MEND_SIGN,$image, $this->firstName, $this->message,$this->lastName, $this->email, $this->id,$this->type);

        $content = str_replace($fields, $fields_replace, $main_content);
        return sanitize_output($content);
    }

    public function dataGrid() {

        $content = $operation = $whereCond = $totalRow = NULL;
        $result = $tmp_rows = $row_data = array();
        extract($this->searchArray);
        $chr = str_replace(array('_', '%'), array('\_', '\%'), $chr);
        $whereCond = '';
        $aWhere[] = "%$chr%";
        $aWhere[] = "%$chr%";
        $aWhere[] = "%$chr%";
        $aWhere[] = "%$chr%";

        if (isset($chr) && $chr != '') {

        }

        if (isset($sort))
            $sorting = $sort . ' ' . $order;
        else
            $sorting = 'id DESC';

        $totalRow = $this->db->pdoQuery("SELECT  *
                                       FROM tbl_feedback
                                        WHERE email LIKE ? OR firstName LIKE ? OR lastName LIKE ? OR message LIKE ? ", $aWhere)->affectedRows();
        $qrySel = $this->db->pdoQuery("SELECT  *
									   FROM tbl_feedback
									    WHERE email LIKE ? OR firstName LIKE ? OR lastName LIKE ? OR message LIKE ?  order by " . $sorting . " limit " . $offset . " ," . $rows . " ",$aWhere)->results();
        $totalRow = count($qrySel);
        foreach ($qrySel as $fetchRes) {
            $id        = $fetchRes['id'];
            $status    = ($fetchRes['status'] == "y") ? "checked" : "";
            $switch    = (in_array('status', $this->Permission)) ? $this->toggel_switch(array("action" => "ajax." . $this->module . ".php?id=" . $fetchRes['id'] . "", "check" => $status)) : '';
            $operation = '';
            $operation .= (in_array('edit', $this->Permission)) ? $this->operation(array("href" => "ajax." . $this->module . ".php?action=edit&id=" . $fetchRes['id'] . "", "class" => "btn default btn-xs black btnEdit", "value" => '<i class="fa fa-edit"></i>&nbsp;Edit')) : '';
            $operation .=(in_array('delete', $this->Permission)) ? '&nbsp;&nbsp;' . $this->operation(array("href" => "ajax." . $this->module . ".php?action=delete&id=" . $fetchRes['id'] . "", "class" => "btn default btn-xs red btn-delete", "value" => '<i class="fa fa-trash-o"></i>&nbsp;Delete')) : '';
            $operation .=(in_array('view', $this->Permission)) ? '&nbsp;&nbsp;' . $this->operation(array("href" => "ajax." . $this->module . ".php?action=view&id=" . $fetchRes['id'] . "", "class" => "btn default blue btn-xs btn-viewbtn", "value" => '<i class="fa fa-laptop"></i>&nbsp;View')) : '';

            if($fetchRes['user_img']!="" && file_exists(DIR_UPD.'feedback/th1_'.$fetchRes['user_img'])){
            $user_img = '<image src="'.SITE_UPD.'feedback/th1_'.$fetchRes['user_img'].'">';
            }else{
            $user_img = '<image src="'.SITE_UPD.'th2_no_user_image.png">';
            }
            $final_array = array(
                filtering($fetchRes["id"]),
                $user_img,
                filtering($fetchRes["firstName"]).' '.filtering($fetchRes["lastName"]),
                wordwrap(filtering($fetchRes['email']),10,"<br>\n"),
                wordwrap(myTruncate(filtering($fetchRes["message"]),200).'...',50,"<br>\n")

            );

            if (in_array('status', $this->Permission)) {
                $final_array = array_merge($final_array, array($switch));
            }
            if (in_array('edit', $this->Permission) || in_array('delete', $this->Permission) || in_array('view', $this->Permission)) {
                $final_array = array_merge($final_array, array($operation));
            }
            $row_data[] = $final_array;
        }

        $result["sEcho"]                = $sEcho;
        $result["iTotalRecords"]        = (int) $totalRow;
        $result["iTotalDisplayRecords"] = (int) $totalRow;
        $result["aaData"]               = $row_data;
        return $result;
    }

    public function toggel_switch($text) {
        $text['action']   = isset($text['action']) ? $text['action'] : 'Enter Action Here: ';
        $text['check']    = isset($text['check']) ? $text['check'] : '';
        $text['name']     = isset($text['name']) ? $text['name'] : '';
        $text['class']    = isset($text['class']) ? '' . trim($text['class']) : '';
        $text['extraAtt'] = isset($text['extraAtt']) ? $text['extraAtt'] : '';
        $main_content     = new MainTemplater(DIR_ADMIN_TMPL . $this->module . '/switch-nct.tpl.php');
        $main_content     = $main_content->parse();
        $fields           = array("%NAME%", "%CLASS%", "%ACTION%", "%EXTRA%", "%CHECK%");
        $fields_replace   = array($text['name'], $text['class'], $text['action'], $text['extraAtt'], $text['check']);
        return str_replace($fields, $fields_replace, $main_content);
    }

    public function operation($text) {

        $text['href']     = isset($text['href']) ? $text['href'] : 'Enter Link Here: ';
        $text['value']    = isset($text['value']) ? $text['value'] : '';
        $text['name']     = isset($text['name']) ? $text['name'] : '';
        $text['class']    = isset($text['class']) ? '' . trim($text['class']) : '';
        $text['extraAtt'] = isset($text['extraAtt']) ? $text['extraAtt'] : '';
        $main_content     = new MainTemplater(DIR_ADMIN_TMPL . $this->module . '/operation-nct.tpl.php');
        $main_content     = $main_content->parse();
        $fields           = array("%HREF%", "%CLASS%", "%VALUE%", "%EXTRA%");
        $fields_replace   = array($text['href'], $text['class'], $text['value'], $text['extraAtt']);
        return str_replace($fields, $fields_replace, $main_content);
    }

    public function getPageContent() {
        $final_result = NULL;
        $main_content = new MainTemplater(DIR_ADMIN_TMPL . $this->module . "/" . $this->module . ".tpl.php");
        $main_content->breadcrumb = $this->getBreadcrumb();
        $final_result = $main_content->parse();
        return $final_result;

    }
     public function displaybox($text) {

        $text['label']     = isset($text['label']) ? $text['label'] : 'Enter Text Here: ';
        $text['value']     = isset($text['value']) ? $text['value'] : '';
        $text['name']      = isset($text['name']) ? $text['name'] : '';
        $text['class']     = isset($text['class']) ? 'form-control-static ' . trim($text['class']) : 'form-control-static';
        $text['onlyField'] = isset($text['onlyField']) ? $text['onlyField'] : false;
        $text['extraAtt']  = isset($text['extraAtt']) ? $text['extraAtt'] : '';

        $main_content      = new MainTemplater(DIR_ADMIN_TMPL . $this->module . '/displaybox.tpl.php');
        $main_content      = $main_content->parse();
        $fields            = array("%LABEL%", "%CLASS%", "%VALUE%");
        $fields_replace    = array($text['label'], $text['class'], $text['value']);
        return str_replace($fields, $fields_replace, $main_content);
    }

}
