<?php
class Product extends Home {

	public $constantValue;
	public $constantName;
	public $data = array();

	public function __construct($module,$id=0, $searchArray=array(), $type='') {
		global $db, $fields, $sessCataId;
		$this->db = $db;
		$this->data['id'] = $this->id = $id;
		$this->fields = $fields;
		$this->module = $module;
		$this->table = 'tbl_product';

		$this->type = ($this->id > 0 ? 'edit' : 'add');
		$this->searchArray = $searchArray;
		parent::__construct();
		$this->image1 = array();
		if($this->id>0){
			$qrySel = $this->db->select($this->table, array("id","productName","subcategoryID","categoryID","image","createdDate","description","quantity","price","isActive"),array("id"=>$id))->result();
			$fetchRes = $qrySel;

			$this->data['productName']   = $this->productName = $fetchRes['productName'];
			$this->data['id']            = $this->id = $fetchRes['id'];
			$this->data['subcategoryID'] = $this->subcategoryID = $fetchRes['subcategoryID'];
			$this->data['categoryID']    = $this->categoryID = $fetchRes['categoryID'];
			$this->data['image']         = $this->image = $fetchRes['image'];
			$this->data['description']   = $this->description = $fetchRes['description'];
			$this->data['quantity']      = $this->quantity = $fetchRes['quantity'];
			$this->data['price']         = $this->price = $fetchRes['price'];
			$this->data['createdDate']   = $this->createdDate = $fetchRes['createdDate'];
			$this->data['isActive']      = $this->isActive = $fetchRes['isActive'];
		}
		else{
			$this->data['id']            = $this->id = '';
			$this->data['productName']   = $this->productName = '';
			$this->data['subcategoryID'] = $this->subcategoryID = '';
			$this->data['categoryID']    = $this->categoryID = '';
			$this->data['image']         = $this->image = '';
			$this->data['description']   = $this->description = '';
			$this->data['quantity']      = $this->quantity = '';
			$this->data['price']         = $this->price = '';
			$this->data['createdDate']   = $this->createdDate = '';
			$this->data['isActive']      = $this->isActive = 'a';
		}

		switch($type){
			case 'add' : {
				$this->data['content'] =  (in_array('add',$this->Permission))?$this->getForm():'';
				break;
			}
			case 'edit' : {
				$this->data['content'] =  (in_array('edit',$this->Permission))?$this->getForm():'';
				break;
			}
			case 'view' : {
				$this->data['content'] =  (in_array('view',$this->Permission))?$this->viewForm():'';
				break;
			}
			case 'delete' : {
				$this->data['content'] = (in_array('delete',$this->Permission))?json_encode($this->dataGrid()):'';
				break;
			}
			case 'datagrid' :  {
				$this->data['content'] = (in_array('module',$this->Permission))?json_encode($this->dataGrid()):'';
			}
		}

	}

	public function displaybox($text){

	}

	public function getChildCat($cid=0,$selId = 0){

		$category_opt= new MainTemplater(DIR_ADMIN_TMPL.$this->module."/option-nct.tpl.php");
		$category_opt = $category_opt->parse();
		$fields = array('%VALUE%','%SELECTED%','%LABEL%');
		$selCats = $this->db->select('tbl_categories',array('id','categoryLevel','categoryName'),array('isActive'=>'y','parent_id'=>$cid))->results();
		if(count($selCats) > 0){
			$category_name_field = NULL;
			$lvl = 0;
			foreach ($selCats as $category) {
				if($lvl == 0){
					$lvl = ++$category['categoryLevel'];
				}
				$selected = ($selId == $category['id'] ? "selected='selected'" : '');
				$fields_replace = array($category['id'],$selected,$category['categoryName']);
				$category_name_field .= str_replace($fields,$fields_replace,$category_opt);
			}
			$select_opt         = new MainTemplater(DIR_ADMIN_TMPL.$this->module."/select-nct.tpl.php");
			$select_opt         = $select_opt->parse();
			$fields_cat         = array('%CATEGORY_NAME_FIELD%','%LVL%');
			$fields_cat_replace = array($category_name_field,$lvl);
			$fields_cat         = str_replace($fields_cat,$fields_cat_replace,$select_opt);
		}else{
			$fields_cat = NULL;
		}
		return $fields_cat;
	}
	public function getListChildCat(){
		$content = NULL;
		$catList = $this->db->pdoQuery("SELECT * FROM tbl_product_category WHERE pId = ? ORDER BY level ASC",array($this->id));
		if($catList->affectedRows() > 0){
			$catResult = $catList->results();
			foreach ($catResult as $key => $resultValue) {
				$parent_id = getTableValue('tbl_categories','parent_id',array('id'=>$resultValue['cId']));
				$content .= $this->getChildCat($parent_id,$resultValue['cId']);
			}
		}else{
			$content = $this->getChildCat();
		}
		return $content;
	}
	public function getForm() {

		$content='';
		if($this->id > 0){
			$fields_cat = $this->getListChildCat();
		}else{
			$fields_cat = $this->getChildCat();
		}


		$main_content = new MainTemplater(DIR_ADMIN_TMPL.$this->module."/form-nct.tpl.php");
		$main_content = $main_content->parse();

		$status_a=($this->isActive == 'y' ? 'checked':'');
		$status_d=($this->isActive != 'y' ? 'checked':'');
		if(isset($this->image) && $this->image!=""){
			$file = SITE_UPD.'product/th1_'.$this->image;
		}else{
			$file = SITE_UPD.'product/th1_no_image.jpg';
		}
		$proNmContent = $proDescContent = NULL;
		$qrySel = $this->db->select("tbl_language", array("id","languageName","created_date"),array("status"=>'a'))->results();
		foreach($qrySel as $fetchRes){
			if($this->id > 0 && $this->type=='edit'){
				$qrysel1 = $this->db->select($this->table, array("*"),array("id"=>$this->id))->result();
				$fetchRow = $qrysel1;
				$productName = $fetchRow['productName_'.$fetchRes["id"].''];
				$proNmContent .= $this->textBox(array("label"=>"".MEND_SIGN."Product Name : (".$fetchRes['languageName'].") ","name"=>"productName[".$fetchRes['id']."]","class"=>"logintextbox-bg required","value"=>stripslashes($productName)));
			}else{
				$proNmContent .= $this->textBox(array("label"=>"".MEND_SIGN."Product Name : (".$fetchRes['languageName'].") ","name"=>"productName[".$fetchRes['id']."]","class"=>"logintextbox-bg required"));
			}
		}
		foreach($qrySel as $fetchRes){
			if($this->id > 0 && $this->type=='edit'){
				$qrysel1 = $this->db->select($this->table, array("*"),array("id"=>$this->id))->result();
				$fetchRow = $qrysel1;
				$description = $fetchRow['productName_'.$fetchRes["id"].''];
				$proDescContent .= $this->textArea(array("label"=>"".MEND_SIGN."Product Description : (".$fetchRes['languageName'].") ","name"=>"description[".$fetchRes['id']."]","class"=>"logintextbox-bg required","value"=>stripslashes($description)));
			}else{
				$proDescContent .= $this->textArea(array("label"=>"".MEND_SIGN."Product Description : (".$fetchRes['languageName'].") ","name"=>"description[".$fetchRes['id']."]","class"=>"logintextbox-bg required"));
			}
		}


		$fields = array("%CAT_LIST%","%PRODUCT_NAME%","%PRODUCT_IMG%",
			"%DESCRIPTION%","%QUANTITY%","%PRICE%","%STATUS_A%","%STATUS_D%","%TYPE%","%ID%",'%REQUIRED%',"%IMAGE_1%","%W%","%H%");

		$fields_replace = array($fields_cat,$proNmContent,$file,$proDescContent,$this->quantity,$this->price,$status_a,$status_d,$this->type,$this->id,($this->type != 'edit' ? 'required' : ''),$this->image,"100px","100px");

		$content=str_replace($fields,$fields_replace,$main_content);
		return sanitize_output($content);

	}
	public function textBox($text) {

		$text['label']     = isset($text['label']) ? $text['label'] : 'Enter Text Here: ';
		$text['value']     = isset($text['value']) ? $text['value'] : '';
		$text['name']      = isset($text['name']) ? $text['name'] : '';
		$text['class']     = isset($text['class']) ? 'form-control ' . trim($text['class']) : 'form-control';
		$text['onlyField'] = isset($text['onlyField']) ? $text['onlyField'] : false;
		$text['extraAtt']  = isset($text['extraAtt']) ? $text['extraAtt'] : '';

        if ($text["onlyField"] == true) {
            $main_content = new MainTemplater(DIR_ADMIN_TMPL . $this->module  . '/textbox_onlyfield.tpl.php');
        } else {
            $main_content = new MainTemplater(DIR_ADMIN_TMPL . $this->module  . '/textbox.tpl.php');
        }
        $main_content = $main_content->parse();
        $fields = array("%CLASS%", "%NAME%", "%ID%", "%VALUE%", "%EXTRA%", "%LABEL%");
        $fields_replace = array($text['class'], $text['name'], $text['name'], $text['value'], $text['extraAtt'], $text['label']);
        return str_replace($fields, $fields_replace, $main_content);
    }
 	public function textArea($text) {
		$text['label']     = isset($text['label']) ? $text['label'] : 'Enter Password Here: ';
		$text['value']     = isset($text['value']) ? $text['value'] : '';
		$text['name']      = isset($text['name']) ? $text['name'] : '';
		$text['class']     = isset($text['class']) ? "form-control " . $text['class'] : 'form-control';
		$text['extraAtt']  = isset($text['extraAtt']) ? ' ' . $text['extraAtt'] : '';
		$text['onlyField'] = isset($text['onlyField']) ? $text['onlyField'] : false;
		if ($text["onlyField"] == true) {
			$main_content = new MainTemplater(DIR_ADMIN_TMPL . $this->module . '/textarea_onlyfield.tpl.php');
		} else {
			$main_content = new MainTemplater(DIR_ADMIN_TMPL . $this->module . '/textarea.tpl.php');
		}
		$main_content   = $main_content->parse();
		$fields         = array("%CLASS%", "%NAME%", "%ID%", "%VALUE%", "%EXTRA%", "%LABEL%");
		$fields_replace = array($text['class'], $text['name'], $text['name'], $text['value'], $text['extraAtt'], $text['label']);
		return str_replace($fields, $fields_replace, $main_content);
	}
	public function dataGrid() {
		$content = $operation = $whereCond = $whereCond1= $totalRow = NULL;
		$result = $tmp_rows = $row_data = array();
		extract($this->searchArray);
		$langId = isset($langId)?$langId:1;
		$chr = isset($chr)?str_replace(array('_', '%'), array('\_', '\%'),$chr ) : '';
		$whrCond = '';
		/*$whrArr = array();*/
		$aWhere[] = "%$chr%";

		if(isset($sort))
			$sorting = $sort.' '. $order;
		else
			$sorting = 'productName ASC';

		$totalRowTmp = $this->db->pdoQuery('SELECT p.id,p.categoryID,p.subcategoryID,p.productName,p.image,p.description,p.quantity,p.price,p.isActive
			FROM tbl_product AS p WHERE   p.productName LIKE ?  ORDER BY '.$sorting,$aWhere)->affectedRows();

		$totalRow = $totalRowTmp;


		$qrysel = $this->db->pdoQuery("SELECT p.id,p.categoryID,p.subcategoryID,p.productName,p.image,p.description,p.quantity,p.price,p.isActive
			FROM tbl_product AS p  WHERE   p.productName LIKE ? ORDER BY $sorting ",$aWhere)->results();



		foreach($qrysel as $fetchRes) {

			$id = $fetchRes['id'];
			$status = ($fetchRes['isActive']=="y") ? "checked" : "";
			$switch  =(in_array('status',$this->Permission))?$this->toggel_switch(array("action"=>"ajax.".$this->module.".php?id=".$fetchRes['id']."","check"=>$status)):'';

			$operation ='';
			$operation .=(in_array('edit',$this->Permission))?'&nbsp;&nbsp;'.$this->operation(array("href"=>SITE_ADM_MOD.$this->module."/ajax.".$this->module.".php?action=edit&id=".$id,"class"=>"btn default btn-xs black btnEdit","value"=>'<i class="fa fa-edit"></i>&nbsp;Edit')):'';
			$operation .=(in_array('delete',$this->Permission))?'&nbsp;&nbsp;'.$this->operation(array("href"=>"ajax.".$this->module.".php?action=delete&id=".$id."&image=".$fetchRes['image']."","class"=>"btn default btn-xs red btn-delete","value"=>'<i class="fa fa-trash-o"></i>&nbsp;Delete')):'';
			/*$operation .=(in_array('view',$this->Permission))?'&nbsp;&nbsp;'.$this->operation(array("href"=>"ajax.".$this->module.".php?action=view&id=".$id."","class"=>"btn default blue btn-xs btn-viewbtn","value"=>'<i class="fa fa-laptop"></i>&nbsp;View')):'';*/


			$url = (isset($fetchRes["image"])  && $fetchRes["image"]!='')?$fetchRes["image"]:'no_image.jpg';
			$profile = SITE_UPD.'product/th1_'.$url;
			$image='<img src='.$profile.' width="100px" height="100px">';
			$final_array = array($id,$image,stripslashes($fetchRes["productName"]),stripslashes($fetchRes["quantity"]),stripslashes($fetchRes["price"]));

			if(in_array('status',$this->Permission)){
				$final_array =  array_merge($final_array, array($switch));
			}
			if(in_array('edit',$this->Permission) || in_array('delete',$this->Permission) || in_array('view',$this->Permission) ){
				$final_array =  array_merge($final_array, array($operation));
			}

			$row_data[] = $final_array;
		}
		$result["sEcho"]=$sEcho;
		$result["iTotalRecords"] = (int)$totalRow;
		$result["iTotalDisplayRecords"] = (int)$totalRow;
		$result["aaData"] = $row_data;
		return $result;

	}
	public function toggel_switch($text){
		$text['action']   = isset($text['action']) ? $text['action'] : 'Enter Action Here: ';
		$text['check']    = isset($text['check']) ? $text['check'] : '';
		$text['name']     = isset($text['name']) ? $text['name'] : '';
		$text['class']    = isset($text['class']) ? ''.trim($text['class']) : '';
		$text['extraAtt'] = isset($text['extraAtt']) ? $text['extraAtt'] : '';
		$main_content     = new MainTemplater(DIR_ADMIN_TMPL.$this->module.'/switch-nct.tpl.php');
		$main_content     =$main_content->parse();
		$fields           = array("%NAME%","%CLASS%","%ACTION%","%EXTRA%","%CHECK%");
		$fields_replace   = array($text['name'],$text['class'],$text['action'],$text['extraAtt'],$text['check']);
		return str_replace($fields,$fields_replace,$main_content);
	}
	public function operation($text){

		$text['href']     = isset($text['href']) ? $text['href'] : 'Enter Link Here: ';
		$text['value']    = isset($text['value']) ? $text['value'] : '';
		$text['name']     = isset($text['name']) ? $text['name'] : '';
		$text['class']    = isset($text['class']) ? ''.trim($text['class']) : '';
		$text['extraAtt'] = isset($text['extraAtt']) ? $text['extraAtt'] : '';
		$main_content     = new MainTemplater(DIR_ADMIN_TMPL.$this->module.'/operation-nct.tpl.php');
		$main_content     =$main_content->parse();
		$fields           = array("%HREF%","%CLASS%","%VALUE%","%EXTRA%");
		$fields_replace   = array($text['href'],$text['class'],$text['value'],$text['extraAtt']);
		return str_replace($fields,$fields_replace,$main_content);
	}
	public function getPageContent(){
		$final_result             = NULL;
		$main_content             = new MainTemplater(DIR_ADMIN_TMPL.$this->module."/".$this->module.".tpl.php");
		$main_content->breadcrumb = $this->getBreadcrumb();
		$main_content->getForm    = $this->getForm();
		$final_result             = $main_content->parse();
		return $final_result;
	}

}