<?php

class Category extends Home {
	public $page_name;
	public $page_title;
	public $meta_keyword;
	public $meta_desc;
	public $page_desc;
	public $isActive;
	public $data = array();
	public function __construct($id=0, $searchArray=array(), $type='') {
		$this->data['id'] = $this->id = $id;
		$this->table = 'tbl_categories';
		$this->type = ($this->id > 0 ? 'edit' : 'add');
		$this->searchArray = $searchArray;
		$this->langArray = array();
		parent::__construct();
		if($this->id>0){
			$qrySel = $this->db->select($this->table, array("*"),array("id"=>$id))->result();
			$fetchRes = $qrySel;
			$this->data['categoryName']  = $this->categoryName = $fetchRes['categoryName'];
			$this->data['id']            = $this->id = $fetchRes['id'];
			$this->data['parent_id']     = $this->parent_id = $fetchRes['parent_id'];
			$this->data['form_asing_id'] = $this->form_asing_id = $fetchRes['form_asing_id'];
			$this->data['description']   = $this->description = $fetchRes['description'];
			$this->data['created_date']  = $this->created_date = $fetchRes['created_date'];
			$this->data['updated_date']  = $this->updated_date = $fetchRes['updated_date'];
			$this->data['isActive']      = $this->isActive = $fetchRes['isActive'];
		}else{
			$this->data['categoryName']  = $this->categoryName = '';
			$this->data['parent_id']     = $this->parent_id = 0;
			$this->data['form_asing_id'] = $this->form_asing_id = 0;
			$this->data['description']   = $this->description = '';
			$this->data['created_date']  = $this->created_date = '';
			$this->data['updated_date']  = $this->updated_date = '';
			$this->data['isActive']      = $this->isActive = 'y';
		}

		switch($type){
			case 'add' : {
				$this->data['content'] =  (in_array('add',$this->Permission))?$this->getForm():'';
				break;
			}
			case 'edit' : {
				$this->data['content'] =  (in_array('edit',$this->Permission))?$this->getForm():'';
				break;
			}
			case 'view' : {
				$this->data['content'] =  (in_array('view',$this->Permission))?$this->viewForm():'';
				break;
			}

			case 'delete' : {
				$this->data['content'] =  (in_array('delete',$this->Permission))?json_encode($this->dataGrid()):'';
				break;
			}

			case 'datagrid' : {
				$this->data['content'] =  (in_array('module',$this->Permission))?json_encode($this->dataGrid()):'';
			}

			case 'langArray' : {
				$qryLang = $this->db->select("tbl_language",array("id","languageName","default_lan"),array("status"=>'a'),"ORDER BY languageName")->results();
				foreach($qryLang as $fetchLang){
					if($fetchLang['default_lan'] == 'y') {
						$this->defaultLang = $fetchLang['languageName'];
						$this->defaultLangId = $fetchLang['id'];
					}
					$this->langArray[$fetchLang['id']] = $fetchLang['languageName'];
				}
				break;
			}
		}
	}

	public function viewForm(){
		$content = $this->displayBox(array("label"=>"Category Name&nbsp;:","value"=>$this->categoryName)).
				   $this->displayBox(array("label"=>"Description&nbsp;:","value"=>$this->description)).
				   $this->displayBox(array("label"=>"Created Date&nbsp;:","value"=>$this->created_date)).
				   $this->displayBox(array("label"=>"Updated Date&nbsp;:","value"=>$this->updated_date));
		return $content;
	}

	public function category_tree($parent = 0, $spacing = '', $user_tree_array = '') {
		if (!is_array($user_tree_array))
			$user_tree_array = array();

		$sqlCategory = "SELECT id,categoryName,parent_id FROM tbl_categories WHERE parent_id = '".$parent."'  AND isActive = 'y' AND id != ".$this->id." ORDER BY id ASC";

		$resCategory = $this->db->pdoQuery($sqlCategory)->results();
		$num_rows = $this->db->pdoQuery($sqlCategory)->affectedRows();
		if ($num_rows > 0) {
			foreach ($resCategory as $rowCategories) {
			  $user_tree_array[] =  array("id"=>$rowCategories['id'],"categoryName"=>$spacing . $rowCategories['categoryName']);
			  $user_tree_array = $this->category_tree($rowCategories['id'], '&nbsp;&nbsp;&nbsp;'.$spacing . '-&nbsp;', $user_tree_array);
			}
		}
		return $user_tree_array;
	}

	public function getForm() {
		$content ='';

		$qrySel = $this->db->select("tbl_language", array("id","languageName","created_date"),array("status"=>'a'))->results();

		$opt = '<option value="">Select Parent Category</option>';

		$categoryDetails = $this->category_tree();

		foreach ($categoryDetails as $k => $v) {
			$selected = ($v['id'] == $this->parent_id) ? 'selected' : '';
			$opt .= '<option value="'.$v['id'].'" '.$selected.'>'.$v['categoryName'].'</option>';
		}

		$content .= '<div class="form-group">
						<label class="control-label col-md-3">Parent Category:&nbsp;</label>
						<div class="col-md-4">
							<select name="categoryId" id="categoryId" class="form-control selectBox-bg">
								'.$opt.'
							</select>
						</div>
					</div>';

		foreach($qrySel as $fetchRes){
			if($this->type=='edit')
			{
				$qrysel1 = $this->db->select($this->table, array("*"),array("id"=>$this->id))->results();
				$fetchRow = $qrysel1;
				$this->categoryName = ($this->type=='edit') ? $fetchRow[0]['categoryName'] : '';
				if($this->categoryName != '')
				{
					$categoryName = $fetchRow[0]['categoryName_'.$fetchRes["id"].''];
					$content .= $this->textArea(array("label"=>"".MEND_SIGN."Category Name : (".$fetchRes['languageName'].") ","name"=>"categoryName[".$fetchRes['id']."]","class"=>"logintextbox-bg required","value"=>stripslashes($categoryName)));
				}
			}
			else
			{
				$content .= $this->textArea(array("label"=>"".MEND_SIGN."Category Name : (".$fetchRes['languageName'].") ","name"=>"categoryName[".$fetchRes['id']."]","class"=>"logintextbox-bg required"));
			}
		}
		foreach($qrySel as $fetchRes){
			if($this->type=='edit')
			{

				$qrysel1 = $this->db->select($this->table, array("*"),array("id"=>$this->id))->results();
				$fetchRow = $qrysel1;
				$this->description = ($this->type=='edit') ? $fetchRow[0]['description'] : '';
				if( $this->description !='')
				{
					$description = $fetchRow[0]['description_'.$fetchRes["id"].''];
					$content .= $this->textArea(array("label"=>"".MEND_SIGN."Category Description : (".$fetchRes['languageName'].") ","name"=>"description[".$fetchRes['id']."]","class"=>"logintextbox-bg required","value"=>stripslashes($description)));
				}
			}
			else
			{
				$content .= $this->textArea(array("label"=>"".MEND_SIGN."Category Description : (".$fetchRes['languageName'].") ","name"=>"description[".$fetchRes['id']."]","class"=>"logintextbox-bg required"));
			}
		}
		$content .=
                 $this->selectBox(array(
                "label" => "Select form:",
                "name" => "form_asing_id",
                "defaultValue" => false,
                "extraAtt" => "",
                "allow_null" => 1,
                "allow_null_value" => "",
                "class" => "selectBox-bg",
                "choices" => array(
                    "" => ""
                ),
                "value" => $this->form_asing_id,
                "defaultValue" => true,
                "multiple" => false,
                "optgroup" => false,
                "intoDB" => array(
                    "val" => true,
                    "custom" => true,
                    "table" => "tbl_forms",
                    "fields" => "*",
                    "where" => "status='y' ",
                    "orderBy" => "name",
                    "valField" => "id",
                    "dispField" => "name"
                )
            ));
		$main_content = new MainTemplater(DIR_ADMIN_TMPL.$this->module."/form-nct.tpl.php");

		$main_content->category = $content;
		$main_content->type = $this->type;
		$main_content->isActive = $this->isActive;
		$main_content->id = $this->id;
		return $main_content->parse();
	}

	public function child_tree($parent, $spacing = '', $user_tree_array = '',$langId) {
		if (!is_array($user_tree_array))
			$user_tree_array = array();
		$sqlCategory = "SELECT * FROM tbl_categories WHERE id = '".$parent."' ORDER BY id ASC";
		$resCategory = $this->db->pdoQuery($sqlCategory)->result();
		$num_rows = $this->db->pdoQuery($sqlCategory)->affectedRows();
		if ($num_rows > 0) {
			$user_tree_array[] =  array("categoryId"=>$resCategory['parent_id'],"categoryName"=>$spacing . $resCategory['categoryName_'.$langId.'']);
			$user_tree_array = $this->child_tree($resCategory['parent_id'], '&nbsp;'.$spacing.'&nbsp;', $user_tree_array,$langId);
		}
		return $user_tree_array;
	}

	public function parents_tree_t($child, $spacing = '', $user_tree_array = '',$whereS='') {
		if (!is_array($user_tree_array))
			$user_tree_array = array();

		$sqlCategory = "SELECT id,categoryName,parent_id,isActive FROM tbl_categories WHERE id = '".$child."' ORDER BY id ASC";

		$resCategory = $this->db->pdoQuery($sqlCategory)->result();
		$num_rows = $this->db->pdoQuery($sqlCategory)->affectedRows();

		if ($num_rows > 0) {
			$user_tree_array[] =  array("categoryId"=>$resCategory['id'],"categoryName"=>$spacing . $resCategory['categoryName'],"isActive"=>$resCategory['isActive']);
			$user_tree_array = $this->parents_tree($resCategory['parent_id'], '&nbsp;'.$spacing.'&nbsp;', $user_tree_array);
		}
	   // pr($user_tree_array);
		return $user_tree_array;
	}

	public function dataGrid() {
//$this->parents_tree(8);
		$content = $operation = $whereCond = $totalRow = NULL;
		$result = $tmp_rows = $row_data = array();
		extract($this->searchArray);
		$langId = isset($langId)?$langId:0;
		if($langId == 0)
		{
			$defIdQry = $this->db->pdoQuery("select * from tbl_language where default_lan='y'")->result();
			$langId = $defIdQry['id'];
		}

		$chr = str_replace(array('_', '%',"'","\\", "\x00", "\n", "\r", "'", '"', "\x1a"), array('\_', '\%',"\'","\\\\","\\0","\\n", "\\r", "\'", '\"', "\\Z"),$chr);

		if(isset($chr) && $chr != '') {
			$whereCond .= " where (categoryName LIKE '%".$chr."%' or description LIKE '%".$chr."%')";
		}

		if(isset($sort))
			$sorting = $sort.' '. $order;
		else
			$sorting = 'id DESC';

		$totalRow = $this->db->pdoQuery("select id from tbl_categories $whereCond")->affectedRows();

		$qrySel = $this->db->pdoQuery("select * from tbl_categories $whereCond  ORDER BY $sorting limit $offset , $rows")->results();

		foreach($qrySel as $fetchRes) {
//pr($fetchRes);
			$status = ($fetchRes['isActive']=="y") ? "checked" : "";

			$level = '';
			if($fetchRes['parent_id'] != 0){
				$level = $fetchRes['categoryName_'.$langId.''].'&nbsp;';
				$categoryDetails = $this->child_tree($fetchRes['parent_id'],' <i class="fa fa-arrow-right" aria-hidden="true"></i> ','',$langId);
				foreach ($categoryDetails as $k => $v) {
					$level .= $v['categoryName'];
				}
			}

			$switch  =(in_array('status',$this->Permission))?$this->toggel_switch(array("action"=>"ajax.".$this->module.".php?id=".$fetchRes['id']."","check"=>$status)):'';

			 $operation = (in_array('edit', $this->Permission)) ? $this->operation(array("href" => "ajax." . $this->module . ".php?action=edit&id=" . $fetchRes['id'] . "", "class" => "btn default btn-xs black btnEdit", "value" => '<i class="fa fa-edit"></i>&nbsp;Edit')) : '';
			$operation .=(in_array('delete', $this->Permission)) ? '&nbsp;&nbsp;' . $this->operation(array("href" => "ajax." . $this->module . ".php?action=delete&id=" . $fetchRes['id'] . "", "class" => "btn default btn-xs red btn-delete", "value" => '<i class="fa fa-trash-o"></i>&nbsp;Delete')) : '';

			$operation .=(in_array('view', $this->Permission)) ? '&nbsp;&nbsp;' . $this->operation(array("href" => "ajax." . $this->module . ".php?action=view&id=" . $fetchRes['id'] . "", "class" => "btn default blue btn-xs btn-viewbtn", "value" => '<i class="fa fa-laptop"></i>&nbsp;View')) : '';

			//$level = '<span title='.$level.'></span>';
			$categoryName = $fetchRes["categoryName_".$langId.""];

			$final_array =  array($categoryName,$level);
			if(in_array('status',$this->Permission)){
				$final_array =  array_merge($final_array, array($switch));
			}
			if(in_array('edit',$this->Permission) || in_array('delete',$this->Permission) || in_array('view',$this->Permission) ){
				$final_array =  array_merge($final_array, array($operation));
			}
			$row_data[] = $final_array;
		}
		$result["sEcho"]                =$sEcho;
		$result["iTotalRecords"]        = (int)$totalRow;
		$result["iTotalDisplayRecords"] = (int)$totalRow;
		$result["aaData"]               = $row_data;
		return $result;
	}
	function selectBox($field = array()) {
        global $db;
        $fields                     = '';
        $field['label']             = isset($field['label']) ? $field['label'] : array();
        $field['id']                = isset($field['id']) ? $field['id'] : $field['name'];
        $field['value']             = isset($field['value']) ? $field['value'] : '';
        $field['class']             = isset($field['class']) ? 'form-control ' . $field['class'] : 'form-control';
        $field['multiple']          = isset($field['multiple']) ? $field['multiple'] : false;
        $field['arr']               = isset($field['arr']) ? $field['arr'] : true;
        $field['defaultValue']      = isset($field['defaultValue']) ? $field['defaultValue'] : false;
        $field['allow_null']        = isset($field['allow_null']) ? $field['allow_null'] : false;
        $field['allow_null_value']  = isset($field['allow_null_value']) ? $field['allow_null_value'] : 0;
        $field['choices']           = isset($field['choices']) ? $field['choices'] : array();
        $field['optgroup']          = isset($field['optgroup']) ? $field['optgroup'] : false;
        $field['onlyField']         = isset($field['onlyField']) ? $field['onlyField'] : false;
        $field['intoDB']            = isset($field['intoDB']) ? $field['intoDB'] : array();

        $field['intoDB']["val"]     = isset($field['intoDB']["val"]) ? $field['intoDB']["val"] : false;
        $field['intoDB']["groupBy"] = isset($field['intoDB']["groupBy"]) ? ' ' . $field['intoDB']["groupBy"] : '';
        $field['intoDB']["orderBy"] = isset($field['intoDB']["orderBy"]) ? ' ' . $field['intoDB']["orderBy"] : '';
        $field['intoDB']["where"] = isset($field['intoDB']["where"]) ? ' ' . $field['intoDB']["where"] : '';
        $field['intoDB']["custom"] = isset($field['intoDB']["custom"]) ? ' ' . $field['intoDB']["custom"] : '';

        $field['extraAtt']          = isset($field['extraAtt']) ? ' ' . $field['extraAtt'] : '';
        $field['isArray']           = isset($field['isArray']) ? $field['isArray'] : '';
        $optiongroup_flag           = false;
        $final_result_suboptions    = NULL;
        if (empty($field['choices'])) {
            return false;
        }
        if ($field['intoDB']["val"] == true) {
            $field['choices'] = array();

            if ($field['intoDB']["custom"] == true) {
                $get1 = $db->pdoQuery("select " . $field['intoDB']["fields"] . " from " . $field['intoDB']["table"] . " where " . $field['intoDB']["where"] . " order by " . $field['intoDB']["orderBy"] . " ")->results();
            } else {
                $get1 = $db->select($field['intoDB']["table"], $field['intoDB']["fields"], $field['intoDB']["where"], "ORDER BY " . $field['intoDB']["orderBy"])->results();
            }
            foreach ($get1 as $checkVal) {
                $field['choices'][$checkVal[$field['intoDB']["valField"]]] = $checkVal[$field['intoDB']["dispField"]];
            }
        }

        $multiple = '';
        if ($field['multiple'] == 'true' || $field['multiple'] == true) {
            $multiple = ' multiple="multiple" size="5" ';
            if ($field['arr'] == 'true') {
                $field['name'] .= '[]';
            }
        }
        $id = ($field['isArray'] != 'true') ? $field['id'] : "";

        $main_content_only_field = new MainTemplater(DIR_ADMIN_FIELDS_HTML . 'select_onlyfield.tpl.php');
        $main_content_only_field = $main_content_only_field->parse();

        $fields.='<select name="' . $field['name'] . '" id="' . $id . '"  class="' . $field['class'] . '" ' . $multiple . ' ' . $field['extraAtt'] . '>';

        // null
        $main_content_options = new MainTemplater(DIR_ADMIN_FIELDS_HTML . 'select_options.tpl.php');
        $main_content_options = $main_content_options->parse();
        $content_fields = array("%VALUE%", "%SELECTED%", "%DISPLAY_VALUE%");
        $final_result_options = '';
        if ($field['allow_null'] == '1') {
            //$fields.= '<option value="'.$field['allow_null_value'].'">Please Select</option>';
            $content_fields_replace = array($field['allow_null_value'], '', 'Please Select');
            $final_result_options .= str_replace($content_fields, $content_fields_replace, $main_content_options);
        }


        // loop through values and add them as options
        foreach ($field['choices'] as $key => $value) {
            if ($field['optgroup']) {
                $main_content_optiongroup = new MainTemplater(DIR_ADMIN_FIELDS_HTML . 'select_optiongroup.tpl.php');
                $main_content_optiongroup = $main_content_optiongroup->parse();
                $content_fields_optiongroup = array("%VALUE%", "%OPTIONS%");

                // this select is grouped with optgroup

                if ($value) {
                    foreach ($value as $id => $label) {
                        $selected = '';
                        if (is_array($field['value']) && in_array($id, $field['value'])) {
                            $selected = 'selected="selected"';
                        } else {
                            // 3. this is not a multiple select, just check normaly
                            if ($id == $field['value']) {
                                $selected = 'selected="selected"';
                            }
                        }
                        $content_fields_replace = array($id, $selected, $label);
                        $final_result_suboptions .= str_replace($content_fields, $content_fields_replace, $main_content_options);
                    }
                }
                if ($key != '') {
                    $optiongroup_flag = true;
                    $content_fields_optiongroup_replace = array($key, '', $final_result_suboptions);
                    $final_result_optiongroup .= str_replace($content_fields_optiongroup, $content_fields_optiongroup_replace, $main_content_optiongroup);
                }
            } else {
                $selected = '';
                if (is_array($field['value']) && in_array($key, $field['value'])) {
                    // 2. If the value is an array (multiple select), loop through values and check if it is selected
                    $selected = 'selected="selected"';
                } else {
                    // 3. this is not a multiple select, just check normaly
                    if ($key == $field['value']) {
                        $selected = 'selected="selected"';
                    }
                }

                $content_fields_replace = array($key, $selected, ucfirst(stripslashes($value)));
                $final_result_options .= str_replace($content_fields, $content_fields_replace, $main_content_options);
            }
        }
        $final_result_options .=($optiongroup_flag == true) ? $final_result_optiongroup : $final_result_suboptions;

        $content_fields = array("%NAME%", "%ID%", "%CLASS%", "%MULTIPLE%", "%EXTRA%", "%OPTIONS%");
        $content_fields_replace = array($field['name'], $id, $field['class'], $multiple, $field['extraAtt'], $final_result_options);
        $final_result_only_field = str_replace($content_fields, $content_fields_replace, $main_content_only_field);

        if ($field["onlyField"] == true) {
            return $final_result_only_field;
        } else {
            $main_content           = new MainTemplater(DIR_ADMIN_FIELDS_HTML . 'select.tpl.php');
            $main_content           = $main_content->parse();
            $content_fields         = array("%LABEL%", "%SELECT_BOX%");
            $content_fields_replace = array($field['label'], $final_result_only_field);
            $final_result           = str_replace($content_fields, $content_fields_replace, $main_content);
            return $final_result;
        }
    }
	public function toggel_switch($text) {
		$text['action']   = isset($text['action']) ? $text['action'] : 'Enter Action Here: ';
		$text['check']    = isset($text['check']) ? $text['check'] : '';
		$text['name']     = isset($text['name']) ? $text['name'] : '';
		$text['class']    = isset($text['class']) ? '' . trim($text['class']) : '';
		$text['extraAtt'] = isset($text['extraAtt']) ? $text['extraAtt'] : '';
		$main_content     = new MainTemplater(DIR_ADMIN_TMPL . $this->module . '/switch-nct.tpl.php');
		$main_content     = $main_content->parse();
		$fields           = array("%NAME%", "%CLASS%", "%ACTION%", "%EXTRA%", "%CHECK%");
		$fields_replace   = array($text['name'], $text['class'], $text['action'], $text['extraAtt'], $text['check']);
		return str_replace($fields, $fields_replace, $main_content);
	}
	 public function textArea($text) {
		$text['label']     = isset($text['label']) ? $text['label'] : 'Enter Password Here: ';
		$text['value']     = isset($text['value']) ? $text['value'] : '';
		$text['name']      = isset($text['name']) ? $text['name'] : '';
		$text['class']     = isset($text['class']) ? "form-control " . $text['class'] : 'form-control';
		$text['extraAtt']  = isset($text['extraAtt']) ? ' ' . $text['extraAtt'] : '';
		$text['onlyField'] = isset($text['onlyField']) ? $text['onlyField'] : false;
		if ($text["onlyField"] == true) {
			$main_content = new MainTemplater(DIR_ADMIN_TMPL . $this->module . '/textarea_onlyfield.tpl.php');
		} else {
			$main_content = new MainTemplater(DIR_ADMIN_TMPL . $this->module . '/textarea.tpl.php');
		}
		$main_content   = $main_content->parse();
		$fields         = array("%CLASS%", "%NAME%", "%ID%", "%VALUE%", "%EXTRA%", "%LABEL%");
		$fields_replace = array($text['class'], $text['name'], $text['name'], $text['value'], $text['extraAtt'], $text['label']);
		return str_replace($fields, $fields_replace, $main_content);
	}
	public function operation($text) {

		$text['href']     = isset($text['href']) ? $text['href'] : 'Enter Link Here: ';
		$text['value']    = isset($text['value']) ? $text['value'] : '';
		$text['name']     = isset($text['name']) ? $text['name'] : '';
		$text['class']    = isset($text['class']) ? '' . trim($text['class']) : '';
		$text['extraAtt'] = isset($text['extraAtt']) ? $text['extraAtt'] : '';
		$main_content     = new MainTemplater(DIR_ADMIN_TMPL . $this->module . '/operation-nct.tpl.php');
		$main_content     = $main_content->parse();
		$fields           = array("%HREF%", "%CLASS%", "%VALUE%", "%EXTRA%");
		$fields_replace   = array($text['href'], $text['class'], $text['value'], $text['extraAtt']);
		return str_replace($fields, $fields_replace, $main_content);
	}
	public function displaybox($text) {

		$text['label']     = isset($text['label']) ? $text['label'] : 'Enter Text Here: ';
		$text['value']     = isset($text['value']) ? $text['value'] : '';
		$text['name']      = isset($text['name']) ? $text['name'] : '';
		$text['class']     = isset($text['class']) ? 'form-control-static ' . trim($text['class']) : 'form-control-static';
		$text['onlyField'] = isset($text['onlyField']) ? $text['onlyField'] : false;
		$text['extraAtt']  = isset($text['extraAtt']) ? $text['extraAtt'] : '';

		$main_content      = new MainTemplater(DIR_ADMIN_FIELDS_HTML. '/displaybox.tpl.php');
		$main_content      = $main_content->parse();
		$fields            = array("%LABEL%", "%CLASS%", "%VALUE%");
		$fields_replace    = array($text['label'], $text['class'], $text['value']);
		return str_replace($fields, $fields_replace, $main_content);
	}

	public function getPageContent(){
		$final_result             = NULL;
		$main_content             = new MainTemplater(DIR_ADMIN_TMPL.$this->module."/".$this->module.".tpl.php");
		$main_content->breadcrumb = $this->getBreadcrumb();
		$main_content->langArray  = $this->langArray;
		$main_content->getForm    = $this->getForm();
		$final_result             = $main_content->parse();
		return $final_result;
	}

}