<?php

$reqAuth = true;
require_once("../../../includes-nct/config-nct.php");
include("class.country-nct.php");
$module = "country-nct";
$table = "tbl_country";
$styles = array(array("data-tables/DT_bootstrap.css", SITE_ADM_PLUGIN),
    array("bootstrap-switch/css/bootstrap-switch.min.css", SITE_ADM_PLUGIN));

$scripts = array("core/datatable.js",
    array("data-tables/jquery.dataTables.js", SITE_ADM_PLUGIN),
    array("data-tables/DT_bootstrap.js", SITE_ADM_PLUGIN),
    array("bootstrap-switch/js/bootstrap-switch.min.js", SITE_ADM_PLUGIN));

chkPermission($module);
$Permission = chkModulePermission($module);
$metaTag = getMetaTags(array("description" => "Admin Panel",
    "keywords" => 'Admin Panel',
    "author" => SITE_NM));

$id = isset($_GET["id"]) ? (int) trim($_GET["id"]) : 0;
$postType = isset($_POST["type"]) ? trim($_POST["type"]) : '';
$type = isset($_GET["type"]) ? trim($_GET["type"]) : $postType;

$headTitle = $type == 'add' ? 'Add' : ($type == 'edit' ? 'Edit' : 'Manage') . ' Countries';
$winTitle = $headTitle . ' - ' . SITE_NM;
$breadcrumb = array($headTitle);
if (isset($_POST["submitAddForm"]) && $_SERVER["REQUEST_METHOD"] == "POST") {
    extract($_POST);
    //p($_POST);
    $objPost->countryName = isset($countryName) ? filtering($countryName, 'input') : '';
    $objPost->isActive = isset($isActive) && $isActive == 'y' ? 'y' : 'n';

    if ($countryName[1] != "") {

        if ($type == 'edit' && $id > 0) {
            if (in_array('edit', $Permission)) {
                $db->update($table, array('countryName' => $countryName[1], 'isActive' => $objPost->isActive), array("CountryId" => $id));
                //////////////
                $languages = $db->select("tbl_language", array("id", "languageName"), array("1" => '1'))->results();
                foreach ($languages as $key => $value) {
                    $db->update($table, array('countryName_'.$value["id"]=>$countryName[$value["id"]], 'isActive' => $objPost->isActive), array("CountryId" => $id));
                }
                //////////////
                $activity_array = array("id" => $id, "module" => $module, "activity" => 'edit');
                add_admin_activity($activity_array);
                $_SESSION["toastr_message"] = disMessage(array('type' => 'suc', 'var' => recEdited));
            } else {
                $toastr_message = $_SESSION["toastr_message"] = disMessage(array('type' => 'err', 'var' => 'NoPermission'));
            }
        } else {
            if (in_array('add', $Permission)) {
                if (getTotalRows($table, "countryName='" . $objPost->countryName . "'", 'CountryId') == 0) {
                    $valArray = array("countryName" => $countryName[1], "isActive" => $objPost->isActive);
                    $id = $db->insert("tbl_country", $valArray)->getLastInsertId();

                    //////////////
                    $languages = $db->select("tbl_language", array("id", "languageName"), array("1" => '1'))->results();
                    foreach ($languages as $key => $value) {
                        $db->update($table, array('countryName_'.$value["id"]=>$countryName[$value["id"]], 'isActive' => $objPost->isActive), array("CountryId" => $id));
                    }
                    //////////////

                    $activity_array = array("id" => $id, "module" => $module, "activity" => 'add');
                    add_admin_activity($activity_array);
                    $_SESSION["toastr_message"] = disMessage(array('type' => 'suc', 'var' => recAdded));
                } else {
                    $_SESSION["toastr_message"] = disMessage(array('type' => 'err', 'var' => recExist));
                }
            } else {
                $toastr_message = $_SESSION["toastr_message"] = disMessage(array('type' => 'err', 'var' => 'NoPermission'));
            }
        }
        redirectPage(SITE_ADM_MOD . $module);
    } else {
        $toastr_message = array('type' => 'err', 'var' => 'fillAllvalues');
    }
}

$objCountry = new Country($module, $id, NULL);

$pageContent = $objCountry->getPageContent();

require_once(DIR_ADMIN_TMPL . "parsing-nct.tpl.php");
