DROP TABLE IF EXISTS wpax_commentmeta;

CREATE TABLE `wpax_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


DROP TABLE IF EXISTS wpax_comments;

CREATE TABLE `wpax_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT '0',
  `comment_author` tinytext COLLATE utf8mb4_unicode_ci NOT NULL,
  `comment_author_email` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT '0',
  `comment_approved` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_type` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10))
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO wpax_comments VALUES("1", "1", "A WordPress Commenter", "wapuu@wordpress.example", "https://wordpress.org/", "", "2016-12-15 00:39:41", "2016-12-15 00:39:41", "Hi, this is a comment.\nTo get started with moderating, editing, and deleting comments, please visit the Comments screen in the dashboard.\nCommenter avatars come from <a href=\"https://gravatar.com\">Gravatar</a>.", "0", "1", "", "", "0", "0");

DROP TABLE IF EXISTS wpax_links;

CREATE TABLE `wpax_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_image` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_target` varchar(25) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_description` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_visible` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT '1',
  `link_rating` int(11) NOT NULL DEFAULT '0',
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_notes` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `link_rss` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


DROP TABLE IF EXISTS wpax_loginizer_logs;

CREATE TABLE `wpax_loginizer_logs` (
  `username` varchar(255) NOT NULL DEFAULT '',
  `time` int(10) NOT NULL DEFAULT '0',
  `count` int(10) NOT NULL DEFAULT '0',
  `lockout` int(10) NOT NULL DEFAULT '0',
  `ip` varchar(255) NOT NULL DEFAULT '',
  UNIQUE KEY `ip` (`ip`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO wpax_loginizer_logs VALUES("administrator", "1484632225", "1", "0", "87.117.15.182");
INSERT INTO wpax_loginizer_logs VALUES("gramgro", "1484575363", "2", "0", "178.49.152.122");

DROP TABLE IF EXISTS wpax_options;

CREATE TABLE `wpax_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `option_value` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `autoload` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`)
) ENGINE=InnoDB AUTO_INCREMENT=46198 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO wpax_options VALUES("1", "siteurl", "http://gramgro.com", "yes");
INSERT INTO wpax_options VALUES("2", "home", "http://gramgro.com", "yes");
INSERT INTO wpax_options VALUES("3", "blogname", "GramGro", "yes");
INSERT INTO wpax_options VALUES("4", "blogdescription", "Instagram Automation tool to gain real followers", "yes");
INSERT INTO wpax_options VALUES("5", "users_can_register", "0", "yes");
INSERT INTO wpax_options VALUES("6", "admin_email", "gramgropro@gmail.com", "yes");
INSERT INTO wpax_options VALUES("7", "start_of_week", "1", "yes");
INSERT INTO wpax_options VALUES("8", "use_balanceTags", "0", "yes");
INSERT INTO wpax_options VALUES("9", "use_smilies", "1", "yes");
INSERT INTO wpax_options VALUES("10", "require_name_email", "1", "yes");
INSERT INTO wpax_options VALUES("11", "comments_notify", "1", "yes");
INSERT INTO wpax_options VALUES("12", "posts_per_rss", "10", "yes");
INSERT INTO wpax_options VALUES("13", "rss_use_excerpt", "0", "yes");
INSERT INTO wpax_options VALUES("14", "mailserver_url", "mail.example.com", "yes");
INSERT INTO wpax_options VALUES("15", "mailserver_login", "login@example.com", "yes");
INSERT INTO wpax_options VALUES("16", "mailserver_pass", "password", "yes");
INSERT INTO wpax_options VALUES("17", "mailserver_port", "110", "yes");
INSERT INTO wpax_options VALUES("18", "default_category", "1", "yes");
INSERT INTO wpax_options VALUES("19", "default_comment_status", "open", "yes");
INSERT INTO wpax_options VALUES("20", "default_ping_status", "open", "yes");
INSERT INTO wpax_options VALUES("21", "default_pingback_flag", "1", "yes");
INSERT INTO wpax_options VALUES("22", "posts_per_page", "10", "yes");
INSERT INTO wpax_options VALUES("23", "date_format", "F j, Y", "yes");
INSERT INTO wpax_options VALUES("24", "time_format", "g:i a", "yes");
INSERT INTO wpax_options VALUES("25", "links_updated_date_format", "F j, Y g:i a", "yes");
INSERT INTO wpax_options VALUES("26", "comment_moderation", "0", "yes");
INSERT INTO wpax_options VALUES("27", "moderation_notify", "1", "yes");
INSERT INTO wpax_options VALUES("28", "permalink_structure", "/%postname%/", "yes");
INSERT INTO wpax_options VALUES("29", "rewrite_rules", "a:126:{s:74:\"customer-area/pages-2/my-pages/([0-9]{4})/([0-9]{2})/([0-9]{2})/([^/]+)/?$\";s:93:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&cuar_private_page=$matches[4]\";s:82:\"customer-area/pages-2/my-pages/([0-9]{4})/([0-9]{2})/([0-9]{2})/([^/]+)/([^/]+)/?$\";s:117:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&cuar_private_page=$matches[4]&cuar_action=$matches[5]\";s:90:\"customer-area/pages-2/my-pages/([0-9]{4})/([0-9]{2})/([0-9]{2})/([^/]+)/([^/]+)/([^/]+)/?$\";s:147:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&cuar_private_page=$matches[4]&cuar_action=$matches[5]&cuar_action_param=$matches[6]\";s:50:\"customer-area/pages-2/my-pages/category/([^/]+)/?$\";s:47:\"index.php?page_id=136&cuar_category=$matches[1]\";s:53:\"customer-area/pages-2/my-pages/created-by/([0-9]+)/?$\";s:45:\"index.php?page_id=136&cuar_author=$matches[1]\";s:52:\"customer-area/pages-2/my-pages/archive/([0-9]{4})/?$\";s:43:\"index.php?page_id=136&cuar_year=$matches[1]\";s:63:\"customer-area/pages-2/my-pages/archive/([0-9]{4})/([0-9]{2})/?$\";s:66:\"index.php?page_id=136&cuar_year=$matches[1]&cuar_month=$matches[2]\";s:74:\"customer-area/files-2/my-files/([0-9]{4})/([0-9]{2})/([0-9]{2})/([^/]+)/?$\";s:93:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&cuar_private_file=$matches[4]\";s:82:\"customer-area/files-2/my-files/([0-9]{4})/([0-9]{2})/([0-9]{2})/([^/]+)/([^/]+)/?$\";s:117:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&cuar_private_file=$matches[4]&cuar_action=$matches[5]\";s:90:\"customer-area/files-2/my-files/([0-9]{4})/([0-9]{2})/([0-9]{2})/([^/]+)/([^/]+)/([^/]+)/?$\";s:147:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&cuar_private_file=$matches[4]&cuar_action=$matches[5]&cuar_action_param=$matches[6]\";s:50:\"customer-area/files-2/my-files/category/([^/]+)/?$\";s:47:\"index.php?page_id=134&cuar_category=$matches[1]\";s:53:\"customer-area/files-2/my-files/created-by/([0-9]+)/?$\";s:45:\"index.php?page_id=134&cuar_author=$matches[1]\";s:52:\"customer-area/files-2/my-files/archive/([0-9]{4})/?$\";s:43:\"index.php?page_id=134&cuar_year=$matches[1]\";s:63:\"customer-area/files-2/my-files/archive/([0-9]{4})/([0-9]{2})/?$\";s:66:\"index.php?page_id=134&cuar_year=$matches[1]&cuar_month=$matches[2]\";s:11:\"^wp-json/?$\";s:22:\"index.php?rest_route=/\";s:14:\"^wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:21:\"^index.php/wp-json/?$\";s:22:\"index.php?rest_route=/\";s:24:\"^index.php/wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:14:\"testimonial/?$\";s:39:\"index.php?post_type=jetpack-testimonial\";s:31:\"testimonial/page/([0-9]{1,})/?$\";s:57:\"index.php?post_type=jetpack-testimonial&paged=$matches[1]\";s:47:\"category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:42:\"category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:23:\"category/(.+?)/embed/?$\";s:46:\"index.php?category_name=$matches[1]&embed=true\";s:35:\"category/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?category_name=$matches[1]&paged=$matches[2]\";s:17:\"category/(.+?)/?$\";s:35:\"index.php?category_name=$matches[1]\";s:44:\"tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:39:\"tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:20:\"tag/([^/]+)/embed/?$\";s:36:\"index.php?tag=$matches[1]&embed=true\";s:32:\"tag/([^/]+)/page/?([0-9]{1,})/?$\";s:43:\"index.php?tag=$matches[1]&paged=$matches[2]\";s:14:\"tag/([^/]+)/?$\";s:25:\"index.php?tag=$matches[1]\";s:45:\"type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:40:\"type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:21:\"type/([^/]+)/embed/?$\";s:44:\"index.php?post_format=$matches[1]&embed=true\";s:33:\"type/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?post_format=$matches[1]&paged=$matches[2]\";s:15:\"type/([^/]+)/?$\";s:33:\"index.php?post_format=$matches[1]\";s:60:\"cuar_log_event_type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:58:\"index.php?cuar_log_event_type=$matches[1]&feed=$matches[2]\";s:55:\"cuar_log_event_type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:58:\"index.php?cuar_log_event_type=$matches[1]&feed=$matches[2]\";s:36:\"cuar_log_event_type/([^/]+)/embed/?$\";s:52:\"index.php?cuar_log_event_type=$matches[1]&embed=true\";s:48:\"cuar_log_event_type/([^/]+)/page/?([0-9]{1,})/?$\";s:59:\"index.php?cuar_log_event_type=$matches[1]&paged=$matches[2]\";s:30:\"cuar_log_event_type/([^/]+)/?$\";s:41:\"index.php?cuar_log_event_type=$matches[1]\";s:39:\"testimonial/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:49:\"testimonial/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:69:\"testimonial/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:64:\"testimonial/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:64:\"testimonial/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:45:\"testimonial/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:28:\"testimonial/([^/]+)/embed/?$\";s:44:\"index.php?testimonial=$matches[1]&embed=true\";s:32:\"testimonial/([^/]+)/trackback/?$\";s:38:\"index.php?testimonial=$matches[1]&tb=1\";s:40:\"testimonial/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?testimonial=$matches[1]&paged=$matches[2]\";s:47:\"testimonial/([^/]+)/comment-page-([0-9]{1,})/?$\";s:51:\"index.php?testimonial=$matches[1]&cpage=$matches[2]\";s:36:\"testimonial/([^/]+)(?:/([0-9]+))?/?$\";s:50:\"index.php?testimonial=$matches[1]&page=$matches[2]\";s:28:\"testimonial/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:38:\"testimonial/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:58:\"testimonial/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:53:\"testimonial/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:53:\"testimonial/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:34:\"testimonial/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:12:\"robots\\.txt$\";s:18:\"index.php?robots=1\";s:48:\".*wp-(atom|rdf|rss|rss2|feed|commentsrss2)\\.php$\";s:18:\"index.php?feed=old\";s:20:\".*wp-app\\.php(/.*)?$\";s:19:\"index.php?error=403\";s:18:\".*wp-register.php$\";s:23:\"index.php?register=true\";s:32:\"feed/(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:27:\"(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:8:\"embed/?$\";s:21:\"index.php?&embed=true\";s:20:\"page/?([0-9]{1,})/?$\";s:28:\"index.php?&paged=$matches[1]\";s:27:\"comment-page-([0-9]{1,})/?$\";s:40:\"index.php?&page_id=146&cpage=$matches[1]\";s:41:\"comments/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:36:\"comments/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:17:\"comments/embed/?$\";s:21:\"index.php?&embed=true\";s:44:\"search/(.+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:39:\"search/(.+)/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:20:\"search/(.+)/embed/?$\";s:34:\"index.php?s=$matches[1]&embed=true\";s:32:\"search/(.+)/page/?([0-9]{1,})/?$\";s:41:\"index.php?s=$matches[1]&paged=$matches[2]\";s:14:\"search/(.+)/?$\";s:23:\"index.php?s=$matches[1]\";s:47:\"author/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:42:\"author/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:23:\"author/([^/]+)/embed/?$\";s:44:\"index.php?author_name=$matches[1]&embed=true\";s:35:\"author/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?author_name=$matches[1]&paged=$matches[2]\";s:17:\"author/([^/]+)/?$\";s:33:\"index.php?author_name=$matches[1]\";s:69:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:45:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/embed/?$\";s:74:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&embed=true\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&paged=$matches[4]\";s:39:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/?$\";s:63:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]\";s:56:\"([0-9]{4})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:51:\"([0-9]{4})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:32:\"([0-9]{4})/([0-9]{1,2})/embed/?$\";s:58:\"index.php?year=$matches[1]&monthnum=$matches[2]&embed=true\";s:44:\"([0-9]{4})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&paged=$matches[3]\";s:26:\"([0-9]{4})/([0-9]{1,2})/?$\";s:47:\"index.php?year=$matches[1]&monthnum=$matches[2]\";s:43:\"([0-9]{4})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:38:\"([0-9]{4})/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:19:\"([0-9]{4})/embed/?$\";s:37:\"index.php?year=$matches[1]&embed=true\";s:31:\"([0-9]{4})/page/?([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&paged=$matches[2]\";s:13:\"([0-9]{4})/?$\";s:26:\"index.php?year=$matches[1]\";s:27:\".?.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\".?.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\".?.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\".?.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"(.?.+?)/embed/?$\";s:41:\"index.php?pagename=$matches[1]&embed=true\";s:20:\"(.?.+?)/trackback/?$\";s:35:\"index.php?pagename=$matches[1]&tb=1\";s:40:\"(.?.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:35:\"(.?.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:28:\"(.?.+?)/page/?([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&paged=$matches[2]\";s:35:\"(.?.+?)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&cpage=$matches[2]\";s:24:\"(.?.+?)(?:/([0-9]+))?/?$\";s:47:\"index.php?pagename=$matches[1]&page=$matches[2]\";s:27:\"[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\"[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\"[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\"[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"([^/]+)/embed/?$\";s:37:\"index.php?name=$matches[1]&embed=true\";s:20:\"([^/]+)/trackback/?$\";s:31:\"index.php?name=$matches[1]&tb=1\";s:40:\"([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:35:\"([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:28:\"([^/]+)/page/?([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&paged=$matches[2]\";s:35:\"([^/]+)/comment-page-([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&cpage=$matches[2]\";s:24:\"([^/]+)(?:/([0-9]+))?/?$\";s:43:\"index.php?name=$matches[1]&page=$matches[2]\";s:16:\"[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:26:\"[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:46:\"[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:22:\"[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";}", "yes");
INSERT INTO wpax_options VALUES("30", "hack_file", "0", "yes");
INSERT INTO wpax_options VALUES("31", "blog_charset", "UTF-8", "yes");
INSERT INTO wpax_options VALUES("32", "moderation_keys", "", "no");
INSERT INTO wpax_options VALUES("33", "active_plugins", "a:10:{i:0;s:45:\"custom-login-page-wp/custom-login-page-wp.php\";i:1;s:35:\"easy-accordion-free/plugin-main.php\";i:2;s:35:\"illdy-companion/illdy-companion.php\";i:3;s:35:\"insert-headers-and-footers/ihaf.php\";i:4;s:19:\"jetpack/jetpack.php\";i:5;s:23:\"loginizer/loginizer.php\";i:6;s:39:\"powr-form-builder/powr-form-builder.php\";i:7;s:57:\"ultimate-form-builder-lite/ultimate-form-builder-lite.php\";i:8;s:23:\"wordfence/wordfence.php\";i:9;s:34:\"wp-clone-by-wp-academy/wpclone.php\";}", "yes");
INSERT INTO wpax_options VALUES("34", "category_base", "", "yes");
INSERT INTO wpax_options VALUES("35", "ping_sites", "http://rpc.pingomatic.com/", "yes");
INSERT INTO wpax_options VALUES("36", "comment_max_links", "2", "yes");
INSERT INTO wpax_options VALUES("37", "gmt_offset", "0", "yes");
INSERT INTO wpax_options VALUES("38", "default_email_category", "1", "yes");
INSERT INTO wpax_options VALUES("39", "recently_edited", "a:4:{i:0;s:94:\"/home/uctgnqkd/public_html/gramgro.com/wp-content/plugins/contact-form-7/wp-contact-form-7.php\";i:1;s:72:\"/home/uctgnqkd/public_html/gramgro.com/wp-content/themes/illdy/style.css\";i:2;s:75:\"/home/uctgnqkd/public_html/gramgro.com/wp-content/themes/fruitful/style.css\";i:3;s:0:\"\";}", "no");
INSERT INTO wpax_options VALUES("40", "template", "illdy", "yes");
INSERT INTO wpax_options VALUES("41", "stylesheet", "illdy", "yes");
INSERT INTO wpax_options VALUES("42", "comment_whitelist", "1", "yes");
INSERT INTO wpax_options VALUES("43", "blacklist_keys", "", "no");
INSERT INTO wpax_options VALUES("44", "comment_registration", "0", "yes");
INSERT INTO wpax_options VALUES("45", "html_type", "text/html", "yes");
INSERT INTO wpax_options VALUES("46", "use_trackback", "0", "yes");
INSERT INTO wpax_options VALUES("47", "default_role", "subscriber", "yes");
INSERT INTO wpax_options VALUES("48", "db_version", "38590", "yes");
INSERT INTO wpax_options VALUES("49", "uploads_use_yearmonth_folders", "1", "yes");
INSERT INTO wpax_options VALUES("50", "upload_path", "", "yes");
INSERT INTO wpax_options VALUES("51", "blog_public", "1", "yes");
INSERT INTO wpax_options VALUES("52", "default_link_category", "2", "yes");
INSERT INTO wpax_options VALUES("53", "show_on_front", "page", "yes");
INSERT INTO wpax_options VALUES("54", "tag_base", "", "yes");
INSERT INTO wpax_options VALUES("55", "show_avatars", "1", "yes");
INSERT INTO wpax_options VALUES("56", "avatar_rating", "G", "yes");
INSERT INTO wpax_options VALUES("57", "upload_url_path", "", "yes");
INSERT INTO wpax_options VALUES("58", "thumbnail_size_w", "150", "yes");
INSERT INTO wpax_options VALUES("59", "thumbnail_size_h", "150", "yes");
INSERT INTO wpax_options VALUES("60", "thumbnail_crop", "1", "yes");
INSERT INTO wpax_options VALUES("61", "medium_size_w", "300", "yes");
INSERT INTO wpax_options VALUES("62", "medium_size_h", "300", "yes");
INSERT INTO wpax_options VALUES("63", "avatar_default", "mystery", "yes");
INSERT INTO wpax_options VALUES("64", "large_size_w", "1024", "yes");
INSERT INTO wpax_options VALUES("65", "large_size_h", "1024", "yes");
INSERT INTO wpax_options VALUES("66", "image_default_link_type", "none", "yes");
INSERT INTO wpax_options VALUES("67", "image_default_size", "", "yes");
INSERT INTO wpax_options VALUES("68", "image_default_align", "", "yes");
INSERT INTO wpax_options VALUES("69", "close_comments_for_old_posts", "0", "yes");
INSERT INTO wpax_options VALUES("70", "close_comments_days_old", "14", "yes");
INSERT INTO wpax_options VALUES("71", "thread_comments", "1", "yes");
INSERT INTO wpax_options VALUES("72", "thread_comments_depth", "5", "yes");
INSERT INTO wpax_options VALUES("73", "page_comments", "0", "yes");
INSERT INTO wpax_options VALUES("74", "comments_per_page", "50", "yes");
INSERT INTO wpax_options VALUES("75", "default_comments_page", "newest", "yes");
INSERT INTO wpax_options VALUES("76", "comment_order", "asc", "yes");
INSERT INTO wpax_options VALUES("77", "sticky_posts", "a:0:{}", "yes");
INSERT INTO wpax_options VALUES("78", "widget_categories", "a:2:{i:2;a:4:{s:5:\"title\";s:0:\"\";s:5:\"count\";i:0;s:12:\"hierarchical\";i:0;s:8:\"dropdown\";i:0;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO wpax_options VALUES("79", "widget_text", "a:7:{i:2;a:2:{s:5:\"title\";s:7:\"Find Us\";s:4:\"text\";s:200:\"<p><strong>Address</strong><br />123 Main Street<br />New York, NY 10001</p><p><strong>Hours</strong><br />Monday&mdash;Friday: 9:00AM&ndash;5:00PM<br />Saturday &amp; Sunday: 11:00AM&ndash;3:00PM</p>\";}i:3;a:2:{s:5:\"title\";s:15:\"About This Site\";s:4:\"text\";s:85:\"This may be a good place to introduce yourself and your site or include some credits.\";}i:4;a:2:{s:5:\"title\";s:7:\"Find Us\";s:4:\"text\";s:200:\"<p><strong>Address</strong><br />123 Main Street<br />New York, NY 10001</p><p><strong>Hours</strong><br />Monday&mdash;Friday: 9:00AM&ndash;5:00PM<br />Saturday &amp; Sunday: 11:00AM&ndash;3:00PM</p>\";}i:5;a:3:{s:5:\"title\";s:13:\"About Gramgro\";s:4:\"text\";s:104:\"GramGro helps Instagram users reach thousands of other users daily by automatically engaging with them. \";s:6:\"filter\";b:0;}s:12:\"_multiwidget\";i:1;i:6;a:3:{s:5:\"title\";s:11:\"INFORMATION\";s:4:\"text\";s:197:\"<ul><li><a href=\"#\" title=\"Pricing\">Pricing</a></li><li><a href=\"#\" title=\"Terms\">Terms</a></li><li><a href=\"#\" title=\"Affiliates\">Affiliates</a></li><li><a href=\"#\" title=\"Blog\">Blog</a></li></ul>\";s:6:\"filter\";b:0;}i:7;a:3:{s:5:\"title\";s:7:\"SUPPORT\";s:4:\"text\";s:205:\"<ul><li><a href=\"#\" title=\"Documentation\">Documentation</a></li><li><a href=\"#\" title=\"FAQs\">FAQs</a></li><li><a href=\"#\" title=\"Forums\">Forums</a></li><li><a href=\"#\" title=\"Contact\">Contact</a></li></ul>\";s:6:\"filter\";b:0;}}", "yes");
INSERT INTO wpax_options VALUES("80", "widget_rss", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO wpax_options VALUES("81", "uninstall_plugins", "a:1:{s:23:\"loginizer/loginizer.php\";s:22:\"loginizer_deactivation\";}", "no");
INSERT INTO wpax_options VALUES("82", "timezone_string", "", "yes");
INSERT INTO wpax_options VALUES("84", "page_on_front", "146", "yes");
INSERT INTO wpax_options VALUES("85", "default_post_format", "0", "yes");
INSERT INTO wpax_options VALUES("86", "link_manager_enabled", "0", "yes");
INSERT INTO wpax_options VALUES("87", "finished_splitting_shared_terms", "1", "yes");
INSERT INTO wpax_options VALUES("88", "site_icon", "87", "yes");
INSERT INTO wpax_options VALUES("89", "medium_large_size_w", "768", "yes");
INSERT INTO wpax_options VALUES("90", "medium_large_size_h", "0", "yes");
INSERT INTO wpax_options VALUES("91", "initial_db_version", "38590", "yes");
INSERT INTO wpax_options VALUES("92", "wpax_user_roles", "a:5:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:87:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;s:17:\"cuar_view_account\";b:1;s:17:\"cuar_edit_account\";b:1;s:16:\"cuar_pp_list_all\";b:1;s:12:\"cuar_pp_edit\";b:1;s:14:\"cuar_pp_delete\";b:1;s:12:\"cuar_pp_read\";b:1;s:25:\"cuar_pp_manage_categories\";b:1;s:23:\"cuar_pp_edit_categories\";b:1;s:25:\"cuar_pp_delete_categories\";b:1;s:25:\"cuar_pp_assign_categories\";b:1;s:15:\"cuar_view_pages\";b:1;s:31:\"cuar_view_any_cuar_private_page\";b:1;s:26:\"cuar_pf_manage_attachments\";b:1;s:16:\"cuar_pf_list_all\";b:1;s:12:\"cuar_pf_edit\";b:1;s:14:\"cuar_pf_delete\";b:1;s:12:\"cuar_pf_read\";b:1;s:25:\"cuar_pf_manage_categories\";b:1;s:23:\"cuar_pf_edit_categories\";b:1;s:25:\"cuar_pf_delete_categories\";b:1;s:25:\"cuar_pf_assign_categories\";b:1;s:15:\"cuar_view_files\";b:1;s:31:\"cuar_view_any_cuar_private_file\";b:1;s:23:\"cuar_access_admin_panel\";b:1;s:23:\"view-customer-area-menu\";b:1;s:17:\"cuar_view_top_bar\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:34:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:10:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:5:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:7:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;s:17:\"cuar_view_account\";b:1;s:17:\"cuar_edit_account\";b:1;s:15:\"cuar_view_pages\";b:1;s:31:\"cuar_view_any_cuar_private_page\";b:1;s:15:\"cuar_view_files\";b:1;}}}", "yes");
INSERT INTO wpax_options VALUES("93", "fresh_site", "0", "yes");
INSERT INTO wpax_options VALUES("94", "widget_search", "a:2:{i:2;a:1:{s:5:\"title\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO wpax_options VALUES("95", "widget_recent-posts", "a:2:{i:2;a:2:{s:5:\"title\";s:0:\"\";s:6:\"number\";i:5;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO wpax_options VALUES("96", "widget_recent-comments", "a:2:{i:2;a:2:{s:5:\"title\";s:0:\"\";s:6:\"number\";i:5;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO wpax_options VALUES("97", "widget_archives", "a:2:{i:2;a:3:{s:5:\"title\";s:0:\"\";s:5:\"count\";i:0;s:8:\"dropdown\";i:0;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO wpax_options VALUES("98", "widget_meta", "a:2:{i:2;a:1:{s:5:\"title\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO wpax_options VALUES("99", "sidebars_widgets", "a:14:{s:19:\"wp_inactive_widgets\";a:5:{i:0;s:6:\"text-2\";i:1;s:6:\"text-3\";i:2;s:6:\"text-4\";i:3;s:6:\"text-5\";i:4;s:15:\"illdy_counter-2\";}s:9:\"sidebar-1\";a:6:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";i:3;s:10:\"archives-2\";i:4;s:12:\"categories-2\";i:5;s:6:\"meta-2\";}s:9:\"sidebar-2\";a:0:{}s:9:\"sidebar-3\";a:0:{}s:9:\"sidebar-4\";N;s:13:\"array_version\";i:3;s:16:\"footer-sidebar-1\";a:1:{i:0;s:6:\"text-5\";}s:16:\"footer-sidebar-2\";a:1:{i:0;s:6:\"text-6\";}s:16:\"footer-sidebar-3\";a:1:{i:0;s:6:\"text-7\";}s:24:\"front-page-about-sidebar\";a:1:{i:0;s:15:\"illdy_service-6\";}s:27:\"front-page-projects-sidebar\";a:4:{i:0;s:15:\"illdy_project-3\";i:1;s:15:\"illdy_project-4\";i:2;s:15:\"illdy_project-5\";i:3;s:15:\"illdy_project-6\";}s:27:\"front-page-services-sidebar\";a:6:{i:0;s:15:\"illdy_service-8\";i:1;s:15:\"illdy_service-9\";i:2;s:16:\"illdy_service-10\";i:3;s:15:\"illdy_service-2\";i:4;s:15:\"illdy_service-3\";i:5;s:15:\"illdy_service-4\";}s:26:\"front-page-counter-sidebar\";a:2:{i:0;s:15:\"illdy_counter-4\";i:1;s:15:\"illdy_counter-3\";}s:23:\"front-page-team-sidebar\";a:3:{i:0;s:14:\"illdy_person-5\";i:1;s:14:\"illdy_person-4\";i:2;s:14:\"illdy_person-2\";}}", "yes");
INSERT INTO wpax_options VALUES("100", "widget_pages", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO wpax_options VALUES("101", "widget_calendar", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO wpax_options VALUES("102", "widget_tag_cloud", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO wpax_options VALUES("103", "widget_nav_menu", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO wpax_options VALUES("104", "cron", "a:21:{i:1484685835;a:2:{s:17:\"jetpack_sync_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:21:\"jetpack_sync_interval\";s:4:\"args\";a:0:{}s:8:\"interval\";i:300;}}s:22:\"jetpack_sync_full_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:21:\"jetpack_sync_interval\";s:4:\"args\";a:0:{}s:8:\"interval\";i:300;}}}i:1484686000;a:1:{s:40:\"jetpack_display_posts_widget_cron_update\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"minutes_10\";s:4:\"args\";a:0:{}s:8:\"interval\";i:600;}}}i:1484689000;a:1:{s:20:\"jetpack_clean_nonces\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1484689107;a:1:{s:21:\"wordfence_hourly_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1484695146;a:1:{s:30:\"wordfence_start_scheduled_scan\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1484696203;a:1:{s:20:\"jetpack_v2_heartbeat\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1484696421;a:1:{s:24:\"jp_purge_transients_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1484699981;a:1:{s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1484699982;a:2:{s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:16:\"wp_update_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1484700069;a:1:{s:19:\"wp_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1484719292;a:1:{s:30:\"wp_scheduled_auto_draft_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1484763174;a:1:{s:24:\"grunion_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1484771907;a:1:{s:20:\"wordfence_daily_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1484782707;a:1:{s:30:\"wordfence_start_scheduled_scan\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1484867425;a:1:{s:30:\"wordfence_start_scheduled_scan\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1484955380;a:1:{s:30:\"wordfence_start_scheduled_scan\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1485040309;a:1:{s:30:\"wordfence_start_scheduled_scan\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1485128430;a:1:{s:30:\"wordfence_start_scheduled_scan\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1485187200;a:1:{s:31:\"wordfence_email_activity_report\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1485214534;a:1:{s:30:\"wordfence_start_scheduled_scan\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}s:7:\"version\";i:2;}", "yes");
INSERT INTO wpax_options VALUES("105", "theme_mods_twentyseventeen", "a:3:{s:18:\"custom_css_post_id\";i:-1;s:18:\"nav_menu_locations\";a:2:{s:14:\"cuar_main_menu\";i:2;s:12:\"primary-menu\";i:5;}s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1482349544;s:4:\"data\";a:5:{s:19:\"wp_inactive_widgets\";a:4:{i:0;s:6:\"text-2\";i:1;s:6:\"text-3\";i:2;s:6:\"text-4\";i:3;s:6:\"text-5\";}s:9:\"sidebar-1\";a:6:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";i:3;s:10:\"archives-2\";i:4;s:12:\"categories-2\";i:5;s:6:\"meta-2\";}s:9:\"sidebar-2\";a:0:{}s:9:\"sidebar-3\";a:0:{}s:9:\"sidebar-4\";N;}}}", "yes");
INSERT INTO wpax_options VALUES("106", "loginizer_version", "1.3.2", "yes");
INSERT INTO wpax_options VALUES("107", "loginizer_options", "a:0:{}", "yes");
INSERT INTO wpax_options VALUES("108", "loginizer_last_reset", "1484631799", "yes");
INSERT INTO wpax_options VALUES("109", "loginizer_whitelist", "a:0:{}", "yes");
INSERT INTO wpax_options VALUES("110", "loginizer_blacklist", "a:0:{}", "yes");
INSERT INTO wpax_options VALUES("111", "loginizer_ins_time", "1481762382", "yes");
INSERT INTO wpax_options VALUES("112", "loginizer_promo_time", "1481762382", "yes");
INSERT INTO wpax_options VALUES("123", "_site_transient_timeout_browser_34f676f9c342b94e657bdc22b061ef1c", "1482367270", "no");
INSERT INTO wpax_options VALUES("124", "_site_transient_browser_34f676f9c342b94e657bdc22b061ef1c", "a:9:{s:8:\"platform\";s:7:\"Windows\";s:4:\"name\";s:6:\"Chrome\";s:7:\"version\";s:12:\"54.0.2840.99\";s:10:\"update_url\";s:28:\"http://www.google.com/chrome\";s:7:\"img_src\";s:49:\"http://s.wordpress.org/images/browsers/chrome.png\";s:11:\"img_src_ssl\";s:48:\"https://wordpress.org/images/browsers/chrome.png\";s:15:\"current_version\";s:2:\"18\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;}", "no");
INSERT INTO wpax_options VALUES("126", "can_compress_scripts", "0", "no");
INSERT INTO wpax_options VALUES("176", "recently_activated", "a:0:{}", "yes");
INSERT INTO wpax_options VALUES("182", "wordfence_version", "6.2.10", "yes");
INSERT INTO wpax_options VALUES("184", "wordfenceActivated", "1", "yes");
INSERT INTO wpax_options VALUES("185", "wf_plugin_act_error", "", "yes");
INSERT INTO wpax_options VALUES("189", "wordfence_syncAttackDataAttempts", "0", "no");
INSERT INTO wpax_options VALUES("190", "wordfence_syncingAttackData", "0", "no");
INSERT INTO wpax_options VALUES("191", "wordfence_lastSyncAttackData", "1484440374", "no");
INSERT INTO wpax_options VALUES("212", "current_theme", "Illdy", "yes");
INSERT INTO wpax_options VALUES("213", "theme_mods_fruitful", "a:3:{i:0;b:0;s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1481862623;s:4:\"data\";a:5:{s:19:\"wp_inactive_widgets\";a:4:{i:0;s:6:\"text-2\";i:1;s:6:\"text-3\";i:2;s:6:\"text-4\";i:3;s:6:\"text-5\";}s:9:\"sidebar-1\";a:6:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";i:3;s:10:\"archives-2\";i:4;s:12:\"categories-2\";i:5;s:6:\"meta-2\";}s:9:\"sidebar-2\";a:0:{}s:9:\"sidebar-3\";a:0:{}s:9:\"sidebar-4\";N;}}}", "yes");
INSERT INTO wpax_options VALUES("214", "theme_switched", "", "yes");
INSERT INTO wpax_options VALUES("215", "widget_widget_news_archive", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO wpax_options VALUES("227", "fruitful_theme_options", "a:121:{s:10:\"responsive\";s:2:\"on\";s:11:\"postcomment\";s:2:\"on\";s:11:\"pagecomment\";s:2:\"on\";s:18:\"latest_posts_templ\";s:1:\"0\";s:17:\"layout_page_templ\";s:1:\"1\";s:19:\"layout_single_templ\";s:1:\"1\";s:20:\"layout_archive_templ\";s:1:\"1\";s:19:\"layout_author_templ\";s:1:\"1\";s:16:\"layout_cat_templ\";s:1:\"1\";s:16:\"layout_tag_templ\";s:1:\"1\";s:16:\"layout_404_templ\";s:1:\"1\";s:19:\"layout_search_templ\";s:1:\"1\";s:20:\"show_featured_single\";s:2:\"on\";s:15:\"is_fixed_header\";s:2:\"on\";s:13:\"menu_position\";s:1:\"2\";s:20:\"menu_type_responsive\";s:14:\"inside_content\";s:15:\"menu_icon_color\";s:7:\"#333333\";s:10:\"header_img\";s:0:\"\";s:15:\"header_bg_color\";s:7:\"#ffffff\";s:15:\"header_img_size\";s:4:\"full\";s:13:\"header_height\";s:2:\"80\";s:14:\"backgroung_img\";s:0:\"\";s:16:\"background_color\";s:7:\"#ffffff\";s:18:\"container_bg_color\";s:7:\"#ffffff\";s:13:\"logo_position\";s:1:\"0\";s:6:\"logo_w\";s:1:\"0\";s:6:\"logo_h\";s:1:\"0\";s:8:\"logo_img\";s:0:\"\";s:15:\"logo_img_retina\";s:0:\"\";s:8:\"fav_icon\";s:0:\"\";s:15:\"fav_icon_iphone\";s:0:\"\";s:22:\"fav_icon_iphone_retina\";s:0:\"\";s:13:\"fav_icon_ipad\";s:0:\"\";s:20:\"fav_icon_ipad_retina\";s:0:\"\";s:13:\"menu_bg_color\";s:7:\"#ffffff\";s:14:\"menu_btn_color\";s:7:\"#F15A23\";s:15:\"menu_font_color\";s:7:\"#333333\";s:16:\"menu_hover_color\";s:7:\"#ffffff\";s:16:\"dd_menu_bg_color\";s:7:\"#ffffff\";s:17:\"dd_menu_btn_color\";s:7:\"#F15A23\";s:18:\"dd_menu_font_color\";s:7:\"#333333\";s:19:\"dd_menu_hover_color\";s:7:\"#ffffff\";s:12:\"p_font_color\";s:7:\"#333333\";s:12:\"a_font_color\";s:7:\"#333333\";s:18:\"a_hover_font_color\";s:7:\"#FF5D2A\";s:18:\"a_focus_font_color\";s:7:\"#FF5D2A\";s:19:\"a_active_font_color\";s:7:\"#FF5D2A\";s:17:\"widgets_sep_color\";s:7:\"#F15A23\";s:20:\"date_of_post_b_color\";s:7:\"#F15A23\";s:20:\"date_of_post_f_color\";s:7:\"#ffffff\";s:9:\"btn_color\";s:7:\"#333333\";s:16:\"btn_active_color\";s:7:\"#F15A23\";s:17:\"soc_icon_bg_color\";s:7:\"#333333\";s:14:\"soc_icon_color\";s:7:\"#ffffff\";s:20:\"woo_sale_price_color\";s:7:\"#919191\";s:24:\"woo_rating_color_regular\";s:7:\"#333333\";s:23:\"woo_rating_color_active\";s:7:\"#FF5D2A\";s:13:\"h_font_family\";s:21:\"Open Sans, sans-serif\";s:13:\"m_font_family\";s:21:\"Open Sans, sans-serif\";s:13:\"p_font_family\";s:21:\"Open Sans, sans-serif\";s:7:\"h1_size\";s:2:\"27\";s:7:\"h2_size\";s:2:\"34\";s:7:\"h3_size\";s:2:\"18\";s:7:\"h4_size\";s:2:\"17\";s:7:\"h5_size\";s:2:\"14\";s:7:\"h6_size\";s:2:\"12\";s:6:\"m_size\";s:2:\"14\";s:6:\"p_size\";s:2:\"14\";s:13:\"select_slider\";s:1:\"2\";s:11:\"s_animation\";s:4:\"fade\";s:11:\"s_direction\";s:10:\"horizontal\";s:9:\"s_reverse\";s:5:\"false\";s:11:\"s_slideshow\";s:4:\"true\";s:16:\"s_slideshowSpeed\";s:4:\"7000\";s:16:\"s_animationSpeed\";s:3:\"600\";s:11:\"s_initDelay\";s:1:\"0\";s:11:\"s_randomize\";s:5:\"false\";s:12:\"s_controlnav\";s:4:\"true\";s:7:\"s_touch\";s:4:\"true\";s:8:\"nv_skins\";s:9:\"theme-bar\";s:12:\"nv_animation\";s:6:\"random\";s:8:\"nv_slice\";s:2:\"15\";s:10:\"nv_boxCols\";s:1:\"8\";s:10:\"nv_boxRows\";s:1:\"4\";s:12:\"nv_animSpeed\";s:3:\"500\";s:12:\"nv_pauseTime\";s:4:\"3000\";s:13:\"nv_startSlide\";s:1:\"0\";s:15:\"nv_directionNav\";s:4:\"true\";s:13:\"nv_controlNav\";s:4:\"true\";s:19:\"nv_controlNavThumbs\";s:5:\"false\";s:15:\"nv_pauseOnHover\";s:4:\"true\";s:16:\"nv_manualAdvance\";s:5:\"false\";s:11:\"nv_prevText\";s:4:\"Prev\";s:11:\"nv_nextText\";s:4:\"Next\";s:14:\"nv_randomStart\";s:5:\"false\";s:6:\"slides\";a:1:{s:7:\"slide-1\";a:2:{s:4:\"link\";s:10:\"google.com\";s:9:\"attach_id\";s:2:\"24\";}}s:11:\"sl_position\";s:1:\"0\";s:12:\"facebook_url\";s:0:\"\";s:11:\"twitter_url\";s:0:\"\";s:12:\"linkedin_url\";s:0:\"\";s:11:\"myspace_url\";s:0:\"\";s:14:\"googleplus_url\";s:0:\"\";s:12:\"dribbble_url\";s:0:\"\";s:10:\"skype_link\";s:0:\"\";s:11:\"flickr_link\";s:0:\"\";s:11:\"youtube_url\";s:0:\"\";s:9:\"vimeo_url\";s:0:\"\";s:8:\"rss_link\";s:0:\"\";s:7:\"vk_link\";s:0:\"\";s:13:\"instagram_url\";s:0:\"\";s:13:\"pinterest_url\";s:0:\"\";s:8:\"yelp_url\";s:0:\"\";s:10:\"email_link\";s:0:\"\";s:11:\"github_link\";s:0:\"\";s:11:\"tumblr_link\";s:0:\"\";s:15:\"soundcloud_link\";s:0:\"\";s:16:\"tripadvisor_link\";s:0:\"\";s:11:\"footer_text\";s:134:\"Fruitful theme by <a href=\"https://github.com/fruitfulcode/\">fruitfulcode</a> Powered by: <a href=\"http://wordpress.org\">WordPress</a>\";s:10:\"custom_css\";s:0:\"\";s:12:\"bg_repeating\";s:3:\"off\";s:5:\"reset\";s:5:\"reset\";}", "yes");
INSERT INTO wpax_options VALUES("229", "_site_transient_timeout_wporg_theme_feature_list", "1481873204", "no");
INSERT INTO wpax_options VALUES("230", "_site_transient_wporg_theme_feature_list", "a:3:{s:6:\"Layout\";a:7:{i:0;s:11:\"grid-layout\";i:1;s:10:\"one-column\";i:2;s:11:\"two-columns\";i:3;s:13:\"three-columns\";i:4;s:12:\"four-columns\";i:5;s:12:\"left-sidebar\";i:6;s:13:\"right-sidebar\";}s:8:\"Features\";a:20:{i:0;s:19:\"accessibility-ready\";i:1;s:10:\"buddypress\";i:2;s:17:\"custom-background\";i:3;s:13:\"custom-colors\";i:4;s:13:\"custom-header\";i:5;s:11:\"custom-menu\";i:6;s:12:\"editor-style\";i:7;s:21:\"featured-image-header\";i:8;s:15:\"featured-images\";i:9;s:15:\"flexible-header\";i:10;s:14:\"footer-widgets\";i:11;s:20:\"front-page-post-form\";i:12;s:19:\"full-width-template\";i:13;s:12:\"microformats\";i:14;s:12:\"post-formats\";i:15;s:20:\"rtl-language-support\";i:16;s:11:\"sticky-post\";i:17;s:13:\"theme-options\";i:18;s:17:\"threaded-comments\";i:19;s:17:\"translation-ready\";}s:7:\"Subject\";a:9:{i:0;s:4:\"blog\";i:1;s:10:\"e-commerce\";i:2;s:9:\"education\";i:3;s:13:\"entertainment\";i:4;s:14:\"food-and-drink\";i:5;s:7:\"holiday\";i:6;s:4:\"news\";i:7;s:11:\"photography\";i:8;s:9:\"portfolio\";}}", "no");
INSERT INTO wpax_options VALUES("234", "theme_mods_illdy", "a:85:{s:18:\"custom_css_post_id\";i:153;s:29:\"illdy_preloader_primary_color\";s:7:\"#6793bf\";s:32:\"illdy_preloader_background_color\";s:7:\"#ffffff\";s:37:\"illdy_jumbotron_enable_featured_image\";i:0;s:40:\"illdy_jumbotron_general_first_button_url\";s:30:\"http://gramgro.com/learn-more/\";s:41:\"illdy_jumbotron_general_second_button_url\";s:23:\"http://gramgro.com/try/\";s:29:\"illdy_jumbotron_general_image\";s:79:\"http://gramgro.com/wp-content/uploads/2016/12/36912781-business-wallpaper-1.jpg\";s:43:\"illdy_jumbotron_general_second_button_title\";s:11:\"Get Started\";s:18:\"nav_menu_locations\";a:2:{s:14:\"cuar_main_menu\";i:2;s:12:\"primary-menu\";i:5;}s:44:\"illdy_jumbotron_general_first_row_from_title\";s:34:\"reach thousands a day on instagram\";s:45:\"illdy_jumbotron_general_second_row_from_title\";s:19:\"gain real followers\";s:44:\"illdy_jumbotron_general_third_row_from_title\";s:0:\"\";s:24:\"illdy_about_general_show\";i:1;s:38:\"illdy_jumbotron_enable_parallax_effect\";i:1;s:29:\"illdy_jumbotron_general_entry\";s:0:\"\";s:11:\"custom_logo\";i:117;s:15:\"illdy_text_logo\";s:7:\"GramGro\";s:21:\"illdy_img_footer_logo\";s:63:\"http://gramgro.com/wp-content/uploads/2016/12/GramGro01redo.png\";s:22:\"illdy_services_general\";i:1;s:28:\"illdy_services_general_title\";s:17:\"How GramGro works\";s:28:\"illdy_services_general_entry\";s:0:\"\";s:22:\"illdy_preloader_enable\";i:1;s:30:\"illdy_preloader_secondly_color\";s:7:\"#ffffff\";s:30:\"illdy_contact_bar_facebook_url\";s:0:\"\";s:29:\"illdy_contact_bar_twitter_url\";s:0:\"\";s:30:\"illdy_contact_bar_linkedin_url\";s:0:\"\";s:11:\"illdy_email\";s:20:\"gramgropro@gmail.com\";s:11:\"illdy_phone\";s:0:\"\";s:14:\"illdy_address1\";s:0:\"\";s:14:\"illdy_address2\";s:0:\"\";s:38:\"illdy_general_footer_display_copyright\";i:1;s:22:\"illdy_footer_copyright\";s:43:\"&copy; Copyright 2016. All Rights Reserved.\";s:38:\"illdy_enable_post_posted_on_blog_posts\";i:1;s:37:\"illdy_enable_post_category_blog_posts\";i:1;s:33:\"illdy_enable_post_tags_blog_posts\";i:1;s:37:\"illdy_enable_post_comments_blog_posts\";i:1;s:38:\"illdy_enable_social_sharing_blog_posts\";i:1;s:34:\"illdy_enable_author_box_blog_posts\";i:1;s:23:\"illdy_team_general_show\";i:0;s:24:\"illdy_team_general_title\";s:4:\"Team\";s:24:\"illdy_team_general_entry\";s:71:\"Meet the people that are going to take your business to the next level.\";s:31:\"illdy_testimonials_general_show\";i:1;s:32:\"illdy_testimonials_general_title\";s:42:\"Hear from our clients (scroll to read all)\";s:34:\"illdy_testimonials_number_of_posts\";s:1:\"6\";s:25:\"illdy_about_general_title\";s:5:\"About\";s:25:\"illdy_about_general_entry\";s:0:\"\";s:29:\"illdy_contact_us_general_show\";i:0;s:30:\"illdy_contact_us_general_title\";s:10:\"Contact us\";s:30:\"illdy_contact_us_general_entry\";s:45:\"And we will get in touch as soon as possible.\";s:38:\"illdy_contact_us_general_address_title\";s:7:\"Address\";s:47:\"illdy_contact_us_general_customer_support_title\";s:16:\"Customer Support\";s:26:\"illdy_counter_general_show\";i:1;s:29:\"illdy_counter_background_type\";s:5:\"color\";s:30:\"illdy_counter_background_image\";s:69:\"http://gramgro.com/wp-content/uploads/2016/12/new-york-city-guide.jpg\";s:30:\"illdy_counter_background_color\";s:7:\"#efefef\";s:42:\"illdy_jumbotron_general_first_button_title\";s:10:\"Learn more\";s:45:\"illdyilldy_jumbotron_general_first_button_url\";s:1:\"#\";s:46:\"illdyilldy_jumbotron_general_second_button_url\";s:1:\"#\";s:30:\"illdy_latest_news_general_show\";i:0;s:31:\"illdy_latest_news_general_title\";s:0:\"\";s:31:\"illdy_latest_news_general_entry\";s:65:\"[youtube https://www.youtube.com/watch?v=-TDAfnU_2bY&w=560&h=315]\";s:29:\"illdy_latest_news_button_text\";s:0:\"\";s:33:\"illdy_latest_news_number_of_posts\";s:0:\"\";s:27:\"illdy_projects_general_show\";i:1;s:28:\"illdy_projects_general_title\";s:8:\"Projects\";s:28:\"illdy_projects_general_entry\";s:35:\"You\'ll love our work. Check it out!\";s:42:\"illdy_general_sections_order_first_section\";i:4;s:43:\"illdy_general_sections_order_second_section\";i:6;s:42:\"illdy_general_sections_order_third_section\";i:3;s:43:\"illdy_general_sections_order_fourth_section\";i:7;s:42:\"illdy_general_sections_order_fifth_section\";i:8;s:42:\"illdy_general_sections_order_sixth_section\";i:2;s:44:\"illdy_general_sections_order_seventh_section\";i:2;s:43:\"illdy_general_sections_order_eighth_section\";i:7;s:27:\"illdy_services_general_show\";i:1;s:18:\"jetpack_custom_css\";a:3:{s:12:\"preprocessor\";s:0:\"\";s:7:\"replace\";b:0;s:13:\"content_width\";i:0;}s:43:\"illdy_testimonials_general_background_image\";s:67:\"http://gramgro.com/wp-content/uploads/2016/12/city-background-3.jpg\";s:29:\"illdy_contact_bar_googlep_url\";s:0:\"\";s:31:\"illdy_contact_bar_pinterest_url\";s:0:\"\";s:31:\"illdy_contact_bar_instagram_url\";s:0:\"\";s:29:\"illdy_contact_bar_youtube_url\";s:0:\"\";s:27:\"illdy_contact_bar_vimeo_url\";s:0:\"\";s:12:\"header_image\";s:75:\"http://gramgro.com/wp-content/uploads/2016/12/cropped-city-background-3.jpg\";s:37:\"illdy_archive_page_background_stretch\";i:1;s:17:\"header_image_data\";O:8:\"stdClass\":5:{s:13:\"attachment_id\";i:223;s:3:\"url\";s:75:\"http://gramgro.com/wp-content/uploads/2016/12/cropped-city-background-3.jpg\";s:13:\"thumbnail_url\";s:75:\"http://gramgro.com/wp-content/uploads/2016/12/cropped-city-background-3.jpg\";s:6:\"height\";i:387;s:5:\"width\";i:1920;}}", "yes");
INSERT INTO wpax_options VALUES("236", "theme_mods_allegiant", "a:1:{s:18:\"custom_css_post_id\";i:-1;}", "yes");
INSERT INTO wpax_options VALUES("238", "_transient_all_the_cool_cats", "1", "yes");
INSERT INTO wpax_options VALUES("239", "theme_switched_via_customizer", "", "yes");
INSERT INTO wpax_options VALUES("240", "customize_stashed_theme_mods", "a:0:{}", "no");
INSERT INTO wpax_options VALUES("256", "ihaf_insert_header", "", "yes");
INSERT INTO wpax_options VALUES("257", "ihaf_insert_footer", "<script>\r\n  (function(i,s,o,g,r,a,m){i[\\\'GoogleAnalyticsObject\\\']=r;i[r]=i[r]||function(){\r\n  (i[r].q=i[r].q||[]).push(arguments)},i[r].l=1*new Date();a=s.createElement(o),\r\n  m=s.getElementsByTagName(o)[0];a.async=1;a.src=g;m.parentNode.insertBefore(a,m)\r\n  })(window,document,\\\'script\\\',\\\'https://www.google-analytics.com/analytics.js\\\',\\\'ga\\\');\r\n\r\n  ga(\\\'create\\\', \\\'UA-89103701-1\\\', \\\'auto\\\');\r\n  ga(\\\'send\\\', \\\'pageview\\\');\r\n\r\n</script>", "yes");
INSERT INTO wpax_options VALUES("258", "_site_transient_timeout_available_translations", "1481878887", "no");
INSERT INTO wpax_options VALUES("259", "_site_transient_available_translations", "a:88:{s:2:\"af\";a:8:{s:8:\"language\";s:2:\"af\";s:7:\"version\";s:3:\"4.7\";s:7:\"updated\";s:19:\"2016-12-09 16:12:38\";s:12:\"english_name\";s:9:\"Afrikaans\";s:11:\"native_name\";s:9:\"Afrikaans\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/translation/core/4.7/af.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"af\";i:2;s:3:\"afr\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"Gaan voort\";}}s:2:\"ar\";a:8:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:3:\"4.7\";s:7:\"updated\";s:19:\"2016-12-06 12:56:13\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/translation/core/4.7/ar.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ar\";i:2;s:3:\"ara\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:16:\"المتابعة\";}}s:3:\"ary\";a:8:{s:8:\"language\";s:3:\"ary\";s:7:\"version\";s:3:\"4.7\";s:7:\"updated\";s:19:\"2016-12-06 19:24:17\";s:12:\"english_name\";s:15:\"Moroccan Arabic\";s:11:\"native_name\";s:31:\"العربية المغربية\";s:7:\"package\";s:60:\"https://downloads.wordpress.org/translation/core/4.7/ary.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ar\";i:3;s:3:\"ary\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:16:\"المتابعة\";}}s:2:\"az\";a:8:{s:8:\"language\";s:2:\"az\";s:7:\"version\";s:5:\"4.6.1\";s:7:\"updated\";s:19:\"2016-09-29 08:38:56\";s:12:\"english_name\";s:11:\"Azerbaijani\";s:11:\"native_name\";s:16:\"Azərbaycan dili\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.6.1/az.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"az\";i:2;s:3:\"aze\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:5:\"Davam\";}}s:3:\"azb\";a:8:{s:8:\"language\";s:3:\"azb\";s:7:\"version\";s:5:\"4.4.2\";s:7:\"updated\";s:19:\"2015-12-11 22:42:10\";s:12:\"english_name\";s:17:\"South Azerbaijani\";s:11:\"native_name\";s:29:\"گؤنئی آذربایجان\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.4.2/azb.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"az\";i:3;s:3:\"azb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"bg_BG\";a:8:{s:8:\"language\";s:5:\"bg_BG\";s:7:\"version\";s:3:\"4.7\";s:7:\"updated\";s:19:\"2016-12-07 08:41:41\";s:12:\"english_name\";s:9:\"Bulgarian\";s:11:\"native_name\";s:18:\"Български\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7/bg_BG.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"bg\";i:2;s:3:\"bul\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"Напред\";}}s:5:\"bn_BD\";a:8:{s:8:\"language\";s:5:\"bn_BD\";s:7:\"version\";s:5:\"4.6.1\";s:7:\"updated\";s:19:\"2016-10-20 16:53:20\";s:12:\"english_name\";s:7:\"Bengali\";s:11:\"native_name\";s:15:\"বাংলা\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.6.1/bn_BD.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"bn\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:23:\"এগিয়ে চল.\";}}s:2:\"bo\";a:8:{s:8:\"language\";s:2:\"bo\";s:7:\"version\";s:5:\"4.6.1\";s:7:\"updated\";s:19:\"2016-09-05 09:44:12\";s:12:\"english_name\";s:7:\"Tibetan\";s:11:\"native_name\";s:21:\"བོད་ཡིག\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.6.1/bo.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"bo\";i:2;s:3:\"tib\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:24:\"མུ་མཐུད།\";}}s:5:\"bs_BA\";a:8:{s:8:\"language\";s:5:\"bs_BA\";s:7:\"version\";s:5:\"4.5.4\";s:7:\"updated\";s:19:\"2016-04-19 23:16:37\";s:12:\"english_name\";s:7:\"Bosnian\";s:11:\"native_name\";s:8:\"Bosanski\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.5.4/bs_BA.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"bs\";i:2;s:3:\"bos\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:7:\"Nastavi\";}}s:2:\"ca\";a:8:{s:8:\"language\";s:2:\"ca\";s:7:\"version\";s:3:\"4.7\";s:7:\"updated\";s:19:\"2016-12-15 10:44:02\";s:12:\"english_name\";s:7:\"Catalan\";s:11:\"native_name\";s:7:\"Català\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/translation/core/4.7/ca.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ca\";i:2;s:3:\"cat\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continua\";}}s:3:\"ceb\";a:8:{s:8:\"language\";s:3:\"ceb\";s:7:\"version\";s:5:\"4.4.3\";s:7:\"updated\";s:19:\"2016-02-16 15:34:57\";s:12:\"english_name\";s:7:\"Cebuano\";s:11:\"native_name\";s:7:\"Cebuano\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.4.3/ceb.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"ceb\";i:3;s:3:\"ceb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:7:\"Padayun\";}}s:5:\"cs_CZ\";a:8:{s:8:\"language\";s:5:\"cs_CZ\";s:7:\"version\";s:5:\"4.4.2\";s:7:\"updated\";s:19:\"2016-02-11 18:32:36\";s:12:\"english_name\";s:5:\"Czech\";s:11:\"native_name\";s:12:\"Čeština‎\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.4.2/cs_CZ.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"cs\";i:2;s:3:\"ces\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:11:\"Pokračovat\";}}s:2:\"cy\";a:8:{s:8:\"language\";s:2:\"cy\";s:7:\"version\";s:3:\"4.7\";s:7:\"updated\";s:19:\"2016-12-05 11:08:55\";s:12:\"english_name\";s:5:\"Welsh\";s:11:\"native_name\";s:7:\"Cymraeg\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/translation/core/4.7/cy.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"cy\";i:2;s:3:\"cym\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Parhau\";}}s:5:\"da_DK\";a:8:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:3:\"4.7\";s:7:\"updated\";s:19:\"2016-12-06 11:33:59\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7/da_DK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"da\";i:2;s:3:\"dan\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"Forts&#230;t\";}}s:5:\"de_DE\";a:8:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:3:\"4.7\";s:7:\"updated\";s:19:\"2016-12-06 22:06:38\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7/de_DE.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Weiter\";}}s:12:\"de_DE_formal\";a:8:{s:8:\"language\";s:12:\"de_DE_formal\";s:7:\"version\";s:3:\"4.7\";s:7:\"updated\";s:19:\"2016-12-06 22:06:45\";s:12:\"english_name\";s:15:\"German (Formal)\";s:11:\"native_name\";s:13:\"Deutsch (Sie)\";s:7:\"package\";s:69:\"https://downloads.wordpress.org/translation/core/4.7/de_DE_formal.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Weiter\";}}s:5:\"de_CH\";a:8:{s:8:\"language\";s:5:\"de_CH\";s:7:\"version\";s:3:\"4.7\";s:7:\"updated\";s:19:\"2016-12-06 15:48:14\";s:12:\"english_name\";s:20:\"German (Switzerland)\";s:11:\"native_name\";s:17:\"Deutsch (Schweiz)\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7/de_CH.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Weiter\";}}s:14:\"de_CH_informal\";a:8:{s:8:\"language\";s:14:\"de_CH_informal\";s:7:\"version\";s:3:\"4.7\";s:7:\"updated\";s:19:\"2016-12-06 15:44:48\";s:12:\"english_name\";s:30:\"German (Switzerland, Informal)\";s:11:\"native_name\";s:21:\"Deutsch (Schweiz, Du)\";s:7:\"package\";s:71:\"https://downloads.wordpress.org/translation/core/4.7/de_CH_informal.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Weiter\";}}s:2:\"el\";a:8:{s:8:\"language\";s:2:\"el\";s:7:\"version\";s:3:\"4.7\";s:7:\"updated\";s:19:\"2016-12-04 07:46:23\";s:12:\"english_name\";s:5:\"Greek\";s:11:\"native_name\";s:16:\"Ελληνικά\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/translation/core/4.7/el.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"el\";i:2;s:3:\"ell\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:16:\"Συνέχεια\";}}s:5:\"en_AU\";a:8:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:3:\"4.7\";s:7:\"updated\";s:19:\"2016-12-03 23:03:48\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7/en_AU.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"en_NZ\";a:8:{s:8:\"language\";s:5:\"en_NZ\";s:7:\"version\";s:3:\"4.7\";s:7:\"updated\";s:19:\"2016-12-15 04:56:31\";s:12:\"english_name\";s:21:\"English (New Zealand)\";s:11:\"native_name\";s:21:\"English (New Zealand)\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7/en_NZ.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"en_CA\";a:8:{s:8:\"language\";s:5:\"en_CA\";s:7:\"version\";s:3:\"4.7\";s:7:\"updated\";s:19:\"2016-12-06 00:34:14\";s:12:\"english_name\";s:16:\"English (Canada)\";s:11:\"native_name\";s:16:\"English (Canada)\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7/en_CA.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"en_ZA\";a:8:{s:8:\"language\";s:5:\"en_ZA\";s:7:\"version\";s:3:\"4.7\";s:7:\"updated\";s:19:\"2016-12-05 08:11:17\";s:12:\"english_name\";s:22:\"English (South Africa)\";s:11:\"native_name\";s:22:\"English (South Africa)\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7/en_ZA.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"en_GB\";a:8:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:3:\"4.7\";s:7:\"updated\";s:19:\"2016-12-11 18:03:11\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7/en_GB.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:2:\"eo\";a:8:{s:8:\"language\";s:2:\"eo\";s:7:\"version\";s:3:\"4.7\";s:7:\"updated\";s:19:\"2016-12-04 17:16:39\";s:12:\"english_name\";s:9:\"Esperanto\";s:11:\"native_name\";s:9:\"Esperanto\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/translation/core/4.7/eo.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"eo\";i:2;s:3:\"epo\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Daŭrigi\";}}s:5:\"es_VE\";a:8:{s:8:\"language\";s:5:\"es_VE\";s:7:\"version\";s:3:\"4.7\";s:7:\"updated\";s:19:\"2016-12-03 12:46:56\";s:12:\"english_name\";s:19:\"Spanish (Venezuela)\";s:11:\"native_name\";s:21:\"Español de Venezuela\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7/es_VE.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"es\";i:2;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_ES\";a:8:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:3:\"4.7\";s:7:\"updated\";s:19:\"2016-12-14 12:28:59\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7/es_ES.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"es\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_CO\";a:8:{s:8:\"language\";s:5:\"es_CO\";s:7:\"version\";s:3:\"4.7\";s:7:\"updated\";s:19:\"2016-12-15 16:12:14\";s:12:\"english_name\";s:18:\"Spanish (Colombia)\";s:11:\"native_name\";s:20:\"Español de Colombia\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7/es_CO.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"es\";i:2;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_GT\";a:8:{s:8:\"language\";s:5:\"es_GT\";s:7:\"version\";s:3:\"4.7\";s:7:\"updated\";s:19:\"2016-12-07 12:13:31\";s:12:\"english_name\";s:19:\"Spanish (Guatemala)\";s:11:\"native_name\";s:21:\"Español de Guatemala\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7/es_GT.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"es\";i:2;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_AR\";a:8:{s:8:\"language\";s:5:\"es_AR\";s:7:\"version\";s:5:\"4.6.1\";s:7:\"updated\";s:19:\"2016-08-19 13:48:04\";s:12:\"english_name\";s:19:\"Spanish (Argentina)\";s:11:\"native_name\";s:21:\"Español de Argentina\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.6.1/es_AR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"es\";i:2;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_PE\";a:8:{s:8:\"language\";s:5:\"es_PE\";s:7:\"version\";s:5:\"4.6.1\";s:7:\"updated\";s:19:\"2016-09-09 09:36:22\";s:12:\"english_name\";s:14:\"Spanish (Peru)\";s:11:\"native_name\";s:17:\"Español de Perú\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.6.1/es_PE.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"es\";i:2;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_CL\";a:8:{s:8:\"language\";s:5:\"es_CL\";s:7:\"version\";s:5:\"4.6.1\";s:7:\"updated\";s:19:\"2016-08-17 22:11:44\";s:12:\"english_name\";s:15:\"Spanish (Chile)\";s:11:\"native_name\";s:17:\"Español de Chile\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.6.1/es_CL.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"es\";i:2;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_MX\";a:8:{s:8:\"language\";s:5:\"es_MX\";s:7:\"version\";s:3:\"4.7\";s:7:\"updated\";s:19:\"2016-12-05 22:19:40\";s:12:\"english_name\";s:16:\"Spanish (Mexico)\";s:11:\"native_name\";s:19:\"Español de México\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7/es_MX.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"es\";i:2;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:2:\"et\";a:8:{s:8:\"language\";s:2:\"et\";s:7:\"version\";s:5:\"4.6.1\";s:7:\"updated\";s:19:\"2016-10-22 16:41:36\";s:12:\"english_name\";s:8:\"Estonian\";s:11:\"native_name\";s:5:\"Eesti\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.6.1/et.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"et\";i:2;s:3:\"est\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Jätka\";}}s:2:\"eu\";a:8:{s:8:\"language\";s:2:\"eu\";s:7:\"version\";s:3:\"4.7\";s:7:\"updated\";s:19:\"2016-12-07 18:34:12\";s:12:\"english_name\";s:6:\"Basque\";s:11:\"native_name\";s:7:\"Euskara\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/translation/core/4.7/eu.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"eu\";i:2;s:3:\"eus\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Jarraitu\";}}s:5:\"fa_IR\";a:8:{s:8:\"language\";s:5:\"fa_IR\";s:7:\"version\";s:5:\"4.6.1\";s:7:\"updated\";s:19:\"2016-10-23 20:20:40\";s:12:\"english_name\";s:7:\"Persian\";s:11:\"native_name\";s:10:\"فارسی\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.6.1/fa_IR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fa\";i:2;s:3:\"fas\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"ادامه\";}}s:2:\"fi\";a:8:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:3:\"4.7\";s:7:\"updated\";s:19:\"2016-12-06 18:04:09\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/translation/core/4.7/fi.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fi\";i:2;s:3:\"fin\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:5:\"Jatka\";}}s:5:\"fr_BE\";a:8:{s:8:\"language\";s:5:\"fr_BE\";s:7:\"version\";s:3:\"4.7\";s:7:\"updated\";s:19:\"2016-12-05 16:41:35\";s:12:\"english_name\";s:16:\"French (Belgium)\";s:11:\"native_name\";s:21:\"Français de Belgique\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7/fr_BE.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fr\";i:2;s:3:\"fra\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuer\";}}s:5:\"fr_FR\";a:8:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:3:\"4.7\";s:7:\"updated\";s:19:\"2016-12-08 10:49:30\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7/fr_FR.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"fr\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuer\";}}s:5:\"fr_CA\";a:8:{s:8:\"language\";s:5:\"fr_CA\";s:7:\"version\";s:3:\"4.7\";s:7:\"updated\";s:19:\"2016-12-10 17:48:28\";s:12:\"english_name\";s:15:\"French (Canada)\";s:11:\"native_name\";s:19:\"Français du Canada\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7/fr_CA.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fr\";i:2;s:3:\"fra\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuer\";}}s:2:\"gd\";a:8:{s:8:\"language\";s:2:\"gd\";s:7:\"version\";s:5:\"4.6.1\";s:7:\"updated\";s:19:\"2016-08-23 17:41:37\";s:12:\"english_name\";s:15:\"Scottish Gaelic\";s:11:\"native_name\";s:9:\"Gàidhlig\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.6.1/gd.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"gd\";i:2;s:3:\"gla\";i:3;s:3:\"gla\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:15:\"Lean air adhart\";}}s:5:\"gl_ES\";a:8:{s:8:\"language\";s:5:\"gl_ES\";s:7:\"version\";s:3:\"4.7\";s:7:\"updated\";s:19:\"2016-12-04 01:43:25\";s:12:\"english_name\";s:8:\"Galician\";s:11:\"native_name\";s:6:\"Galego\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7/gl_ES.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"gl\";i:2;s:3:\"glg\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:2:\"gu\";a:8:{s:8:\"language\";s:2:\"gu\";s:7:\"version\";s:3:\"4.7\";s:7:\"updated\";s:19:\"2016-12-06 21:13:09\";s:12:\"english_name\";s:8:\"Gujarati\";s:11:\"native_name\";s:21:\"ગુજરાતી\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/translation/core/4.7/gu.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"gu\";i:2;s:3:\"guj\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:31:\"ચાલુ રાખવું\";}}s:3:\"haz\";a:8:{s:8:\"language\";s:3:\"haz\";s:7:\"version\";s:5:\"4.4.2\";s:7:\"updated\";s:19:\"2015-12-05 00:59:09\";s:12:\"english_name\";s:8:\"Hazaragi\";s:11:\"native_name\";s:15:\"هزاره گی\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.4.2/haz.zip\";s:3:\"iso\";a:1:{i:3;s:3:\"haz\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"ادامه\";}}s:5:\"he_IL\";a:8:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:3:\"4.7\";s:7:\"updated\";s:19:\"2016-12-08 02:27:42\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7/he_IL.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"he\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"המשך\";}}s:5:\"hi_IN\";a:8:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:3:\"4.7\";s:7:\"updated\";s:19:\"2016-12-09 01:48:54\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7/hi_IN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"hi\";i:2;s:3:\"hin\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"जारी\";}}s:2:\"hr\";a:8:{s:8:\"language\";s:2:\"hr\";s:7:\"version\";s:3:\"4.7\";s:7:\"updated\";s:19:\"2016-12-10 14:04:11\";s:12:\"english_name\";s:8:\"Croatian\";s:11:\"native_name\";s:8:\"Hrvatski\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/translation/core/4.7/hr.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"hr\";i:2;s:3:\"hrv\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:7:\"Nastavi\";}}s:5:\"hu_HU\";a:8:{s:8:\"language\";s:5:\"hu_HU\";s:7:\"version\";s:5:\"4.6.1\";s:7:\"updated\";s:19:\"2016-12-06 20:18:25\";s:12:\"english_name\";s:9:\"Hungarian\";s:11:\"native_name\";s:6:\"Magyar\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.6.1/hu_HU.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"hu\";i:2;s:3:\"hun\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"Folytatás\";}}s:2:\"hy\";a:8:{s:8:\"language\";s:2:\"hy\";s:7:\"version\";s:5:\"4.4.2\";s:7:\"updated\";s:19:\"2016-02-04 07:13:54\";s:12:\"english_name\";s:8:\"Armenian\";s:11:\"native_name\";s:14:\"Հայերեն\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.4.2/hy.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"hy\";i:2;s:3:\"hye\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Շարունակել\";}}s:5:\"id_ID\";a:8:{s:8:\"language\";s:5:\"id_ID\";s:7:\"version\";s:3:\"4.7\";s:7:\"updated\";s:19:\"2016-12-06 17:00:36\";s:12:\"english_name\";s:10:\"Indonesian\";s:11:\"native_name\";s:16:\"Bahasa Indonesia\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7/id_ID.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"id\";i:2;s:3:\"ind\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Lanjutkan\";}}s:5:\"is_IS\";a:8:{s:8:\"language\";s:5:\"is_IS\";s:7:\"version\";s:3:\"4.7\";s:7:\"updated\";s:19:\"2016-12-14 15:32:24\";s:12:\"english_name\";s:9:\"Icelandic\";s:11:\"native_name\";s:9:\"Íslenska\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7/is_IS.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"is\";i:2;s:3:\"isl\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Áfram\";}}s:5:\"it_IT\";a:8:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:3:\"4.7\";s:7:\"updated\";s:19:\"2016-12-11 11:11:09\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7/it_IT.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"it\";i:2;s:3:\"ita\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continua\";}}s:2:\"ja\";a:8:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:3:\"4.7\";s:7:\"updated\";s:19:\"2016-12-05 13:03:24\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/translation/core/4.7/ja.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"ja\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"続ける\";}}s:5:\"ka_GE\";a:8:{s:8:\"language\";s:5:\"ka_GE\";s:7:\"version\";s:3:\"4.7\";s:7:\"updated\";s:19:\"2016-12-03 10:10:56\";s:12:\"english_name\";s:8:\"Georgian\";s:11:\"native_name\";s:21:\"ქართული\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7/ka_GE.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ka\";i:2;s:3:\"kat\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:30:\"გაგრძელება\";}}s:5:\"ko_KR\";a:8:{s:8:\"language\";s:5:\"ko_KR\";s:7:\"version\";s:3:\"4.7\";s:7:\"updated\";s:19:\"2016-12-11 11:21:27\";s:12:\"english_name\";s:6:\"Korean\";s:11:\"native_name\";s:9:\"한국어\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7/ko_KR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ko\";i:2;s:3:\"kor\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"계속\";}}s:5:\"lt_LT\";a:8:{s:8:\"language\";s:5:\"lt_LT\";s:7:\"version\";s:3:\"4.7\";s:7:\"updated\";s:19:\"2016-12-06 12:39:15\";s:12:\"english_name\";s:10:\"Lithuanian\";s:11:\"native_name\";s:15:\"Lietuvių kalba\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7/lt_LT.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"lt\";i:2;s:3:\"lit\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Tęsti\";}}s:2:\"lv\";a:8:{s:8:\"language\";s:2:\"lv\";s:7:\"version\";s:3:\"4.7\";s:7:\"updated\";s:19:\"2016-12-06 06:17:03\";s:12:\"english_name\";s:7:\"Latvian\";s:11:\"native_name\";s:16:\"Latviešu valoda\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/translation/core/4.7/lv.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"lv\";i:2;s:3:\"lav\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Turpināt\";}}s:5:\"mk_MK\";a:8:{s:8:\"language\";s:5:\"mk_MK\";s:7:\"version\";s:3:\"4.7\";s:7:\"updated\";s:19:\"2016-12-06 16:31:57\";s:12:\"english_name\";s:10:\"Macedonian\";s:11:\"native_name\";s:31:\"Македонски јазик\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7/mk_MK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"mk\";i:2;s:3:\"mkd\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:16:\"Продолжи\";}}s:2:\"mr\";a:8:{s:8:\"language\";s:2:\"mr\";s:7:\"version\";s:3:\"4.7\";s:7:\"updated\";s:19:\"2016-12-11 08:51:51\";s:12:\"english_name\";s:7:\"Marathi\";s:11:\"native_name\";s:15:\"मराठी\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/translation/core/4.7/mr.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"mr\";i:2;s:3:\"mar\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:25:\"सुरु ठेवा\";}}s:5:\"ms_MY\";a:8:{s:8:\"language\";s:5:\"ms_MY\";s:7:\"version\";s:3:\"4.7\";s:7:\"updated\";s:19:\"2016-12-09 14:23:37\";s:12:\"english_name\";s:5:\"Malay\";s:11:\"native_name\";s:13:\"Bahasa Melayu\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7/ms_MY.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ms\";i:2;s:3:\"msa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Teruskan\";}}s:5:\"my_MM\";a:8:{s:8:\"language\";s:5:\"my_MM\";s:7:\"version\";s:6:\"4.1.13\";s:7:\"updated\";s:19:\"2015-03-26 15:57:42\";s:12:\"english_name\";s:17:\"Myanmar (Burmese)\";s:11:\"native_name\";s:15:\"ဗမာစာ\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/4.1.13/my_MM.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"my\";i:2;s:3:\"mya\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:54:\"ဆက်လက်လုပ်ဆောင်ပါ။\";}}s:5:\"nb_NO\";a:8:{s:8:\"language\";s:5:\"nb_NO\";s:7:\"version\";s:3:\"4.7\";s:7:\"updated\";s:19:\"2016-12-05 22:24:43\";s:12:\"english_name\";s:19:\"Norwegian (Bokmål)\";s:11:\"native_name\";s:13:\"Norsk bokmål\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7/nb_NO.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nb\";i:2;s:3:\"nob\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Fortsett\";}}s:5:\"nl_NL\";a:8:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:3:\"4.7\";s:7:\"updated\";s:19:\"2016-12-14 14:03:31\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7/nl_NL.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nl\";i:2;s:3:\"nld\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Doorgaan\";}}s:12:\"nl_NL_formal\";a:8:{s:8:\"language\";s:12:\"nl_NL_formal\";s:7:\"version\";s:5:\"4.6.1\";s:7:\"updated\";s:19:\"2016-10-14 13:24:10\";s:12:\"english_name\";s:14:\"Dutch (Formal)\";s:11:\"native_name\";s:20:\"Nederlands (Formeel)\";s:7:\"package\";s:71:\"https://downloads.wordpress.org/translation/core/4.6.1/nl_NL_formal.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nl\";i:2;s:3:\"nld\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Doorgaan\";}}s:5:\"nn_NO\";a:8:{s:8:\"language\";s:5:\"nn_NO\";s:7:\"version\";s:5:\"4.6.1\";s:7:\"updated\";s:19:\"2016-10-28 08:58:28\";s:12:\"english_name\";s:19:\"Norwegian (Nynorsk)\";s:11:\"native_name\";s:13:\"Norsk nynorsk\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.6.1/nn_NO.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nn\";i:2;s:3:\"nno\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Hald fram\";}}s:3:\"oci\";a:8:{s:8:\"language\";s:3:\"oci\";s:7:\"version\";s:5:\"4.6.1\";s:7:\"updated\";s:19:\"2016-09-23 13:45:11\";s:12:\"english_name\";s:7:\"Occitan\";s:11:\"native_name\";s:7:\"Occitan\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.6.1/oci.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"oc\";i:2;s:3:\"oci\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Contunhar\";}}s:5:\"pl_PL\";a:8:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:3:\"4.7\";s:7:\"updated\";s:19:\"2016-12-06 20:27:29\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7/pl_PL.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"pl\";i:2;s:3:\"pol\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Kontynuuj\";}}s:2:\"ps\";a:8:{s:8:\"language\";s:2:\"ps\";s:7:\"version\";s:6:\"4.1.13\";s:7:\"updated\";s:19:\"2015-03-29 22:19:48\";s:12:\"english_name\";s:6:\"Pashto\";s:11:\"native_name\";s:8:\"پښتو\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.1.13/ps.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ps\";i:2;s:3:\"pus\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:19:\"دوام ورکړه\";}}s:5:\"pt_BR\";a:8:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:3:\"4.7\";s:7:\"updated\";s:19:\"2016-12-04 21:26:34\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7/pt_BR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"pt\";i:2;s:3:\"por\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"pt_PT\";a:8:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:3:\"4.7\";s:7:\"updated\";s:19:\"2016-12-14 22:17:48\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7/pt_PT.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"pt\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"ro_RO\";a:8:{s:8:\"language\";s:5:\"ro_RO\";s:7:\"version\";s:3:\"4.7\";s:7:\"updated\";s:19:\"2016-12-06 22:16:39\";s:12:\"english_name\";s:8:\"Romanian\";s:11:\"native_name\";s:8:\"Română\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7/ro_RO.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ro\";i:2;s:3:\"ron\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuă\";}}s:5:\"ru_RU\";a:8:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:3:\"4.7\";s:7:\"updated\";s:19:\"2016-12-07 12:56:07\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7/ru_RU.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ru\";i:2;s:3:\"rus\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Продолжить\";}}s:5:\"sk_SK\";a:8:{s:8:\"language\";s:5:\"sk_SK\";s:7:\"version\";s:3:\"4.7\";s:7:\"updated\";s:19:\"2016-12-09 11:05:20\";s:12:\"english_name\";s:6:\"Slovak\";s:11:\"native_name\";s:11:\"Slovenčina\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7/sk_SK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sk\";i:2;s:3:\"slk\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"Pokračovať\";}}s:5:\"sl_SI\";a:8:{s:8:\"language\";s:5:\"sl_SI\";s:7:\"version\";s:3:\"4.7\";s:7:\"updated\";s:19:\"2016-12-05 08:28:07\";s:12:\"english_name\";s:9:\"Slovenian\";s:11:\"native_name\";s:13:\"Slovenščina\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7/sl_SI.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sl\";i:2;s:3:\"slv\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Nadaljuj\";}}s:2:\"sq\";a:8:{s:8:\"language\";s:2:\"sq\";s:7:\"version\";s:3:\"4.7\";s:7:\"updated\";s:19:\"2016-12-03 20:47:33\";s:12:\"english_name\";s:8:\"Albanian\";s:11:\"native_name\";s:5:\"Shqip\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/translation/core/4.7/sq.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sq\";i:2;s:3:\"sqi\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Vazhdo\";}}s:5:\"sr_RS\";a:8:{s:8:\"language\";s:5:\"sr_RS\";s:7:\"version\";s:3:\"4.7\";s:7:\"updated\";s:19:\"2016-12-04 20:17:20\";s:12:\"english_name\";s:7:\"Serbian\";s:11:\"native_name\";s:23:\"Српски језик\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7/sr_RS.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sr\";i:2;s:3:\"srp\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:14:\"Настави\";}}s:5:\"sv_SE\";a:8:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:3:\"4.7\";s:7:\"updated\";s:19:\"2016-12-06 19:42:34\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7/sv_SE.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sv\";i:2;s:3:\"swe\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Fortsätt\";}}s:3:\"szl\";a:8:{s:8:\"language\";s:3:\"szl\";s:7:\"version\";s:5:\"4.6.1\";s:7:\"updated\";s:19:\"2016-09-24 19:58:14\";s:12:\"english_name\";s:8:\"Silesian\";s:11:\"native_name\";s:17:\"Ślōnskŏ gŏdka\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.6.1/szl.zip\";s:3:\"iso\";a:1:{i:3;s:3:\"szl\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:13:\"Kōntynuować\";}}s:2:\"th\";a:8:{s:8:\"language\";s:2:\"th\";s:7:\"version\";s:5:\"4.6.1\";s:7:\"updated\";s:19:\"2016-10-12 07:04:13\";s:12:\"english_name\";s:4:\"Thai\";s:11:\"native_name\";s:9:\"ไทย\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.6.1/th.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"th\";i:2;s:3:\"tha\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:15:\"ต่อไป\";}}s:2:\"tl\";a:8:{s:8:\"language\";s:2:\"tl\";s:7:\"version\";s:5:\"4.4.2\";s:7:\"updated\";s:19:\"2015-11-27 15:51:36\";s:12:\"english_name\";s:7:\"Tagalog\";s:11:\"native_name\";s:7:\"Tagalog\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.4.2/tl.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"tl\";i:2;s:3:\"tgl\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"Magpatuloy\";}}s:5:\"tr_TR\";a:8:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:3:\"4.7\";s:7:\"updated\";s:19:\"2016-12-06 09:45:13\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7/tr_TR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"tr\";i:2;s:3:\"tur\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:5:\"Devam\";}}s:5:\"ug_CN\";a:8:{s:8:\"language\";s:5:\"ug_CN\";s:7:\"version\";s:5:\"4.6.1\";s:7:\"updated\";s:19:\"2016-12-01 16:07:46\";s:12:\"english_name\";s:6:\"Uighur\";s:11:\"native_name\";s:9:\"Uyƣurqə\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.6.1/ug_CN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ug\";i:2;s:3:\"uig\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:26:\"داۋاملاشتۇرۇش\";}}s:2:\"uk\";a:8:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:3:\"4.7\";s:7:\"updated\";s:19:\"2016-12-08 16:20:54\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/translation/core/4.7/uk.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"uk\";i:2;s:3:\"ukr\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Продовжити\";}}s:2:\"ur\";a:8:{s:8:\"language\";s:2:\"ur\";s:7:\"version\";s:3:\"4.7\";s:7:\"updated\";s:19:\"2016-12-15 08:56:41\";s:12:\"english_name\";s:4:\"Urdu\";s:11:\"native_name\";s:8:\"اردو\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/translation/core/4.7/ur.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ur\";i:2;s:3:\"urd\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:19:\"جاری رکھیں\";}}s:2:\"vi\";a:8:{s:8:\"language\";s:2:\"vi\";s:7:\"version\";s:5:\"4.4.2\";s:7:\"updated\";s:19:\"2015-12-09 01:01:25\";s:12:\"english_name\";s:10:\"Vietnamese\";s:11:\"native_name\";s:14:\"Tiếng Việt\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.4.2/vi.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"vi\";i:2;s:3:\"vie\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"Tiếp tục\";}}s:5:\"zh_TW\";a:8:{s:8:\"language\";s:5:\"zh_TW\";s:7:\"version\";s:3:\"4.7\";s:7:\"updated\";s:19:\"2016-12-07 09:57:58\";s:12:\"english_name\";s:16:\"Chinese (Taiwan)\";s:11:\"native_name\";s:12:\"繁體中文\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7/zh_TW.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"zh\";i:2;s:3:\"zho\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"繼續\";}}s:5:\"zh_CN\";a:8:{s:8:\"language\";s:5:\"zh_CN\";s:7:\"version\";s:3:\"4.7\";s:7:\"updated\";s:19:\"2016-12-08 04:30:37\";s:12:\"english_name\";s:15:\"Chinese (China)\";s:11:\"native_name\";s:12:\"简体中文\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7/zh_CN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"zh\";i:2;s:3:\"zho\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"继续\";}}s:5:\"zh_HK\";a:8:{s:8:\"language\";s:5:\"zh_HK\";s:7:\"version\";s:5:\"4.6.1\";s:7:\"updated\";s:19:\"2016-12-05 11:58:02\";s:12:\"english_name\";s:19:\"Chinese (Hong Kong)\";s:11:\"native_name\";s:16:\"香港中文版	\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.6.1/zh_HK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"zh\";i:2;s:3:\"zho\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"繼續\";}}}", "no");
INSERT INTO wpax_options VALUES("270", "cuar/core/status/warning-messages", "a:0:{}", "yes");
INSERT INTO wpax_options VALUES("271", "cuar_deferred_actions", "a:0:{}", "yes");
INSERT INTO wpax_options VALUES("272", "widget_cuar_private_file_categories", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO wpax_options VALUES("273", "widget_cuar_private_file_archives", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO wpax_options VALUES("274", "widget_cuar_private_files", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO wpax_options VALUES("275", "widget_cuar_private_file_authors", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO wpax_options VALUES("276", "widget_cuar_private_page_categories", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO wpax_options VALUES("277", "widget_cuar_private_page_archives", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO wpax_options VALUES("278", "widget_cuar_private_pages", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO wpax_options VALUES("279", "widget_cuar_private_page_authors", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO wpax_options VALUES("280", "cuar_options", "a:62:{s:16:\"cuar_include_css\";b:1;s:20:\"cuar_debug_templates\";b:0;s:20:\"cuar_admin_theme_url\";s:20:\"plugin%%default-wp38\";s:23:\"cuar_frontend_theme_url\";s:14:\"plugin%%master\";s:27:\"cuar_license_key_admin-area\";s:0:\"\";s:31:\"cuar_restrict_admin_area_access\";b:1;s:26:\"cuar_license_key_installer\";s:0:\"\";s:32:\"cuar/core/installer/is_installed\";b:1;s:36:\"cuar/core/installer/pending_redirect\";s:0:\"\";s:20:\"cuar_license_key_log\";s:0:\"\";s:24:\"cuar_log_view_first_only\";b:1;s:28:\"cuar_log_download_first_only\";b:1;s:27:\"cuar_license_key_post-owner\";s:0:\"\";s:32:\"cuar_license_key_container-owner\";s:0:\"\";s:37:\"cuar_license_key_capabilities-manager\";s:0:\"\";s:31:\"cuar_license_key_customer-pages\";s:0:\"\";s:41:\"customer_page_auto_menu_on_single_content\";b:1;s:32:\"customer_page_auto_menu_on_pages\";b:1;s:36:\"cuar_permalink_category_archive_slug\";s:8:\"category\";s:32:\"cuar_permalink_date_archive_slug\";s:7:\"archive\";s:34:\"cuar_permalink_author_archive_slug\";s:10:\"created-by\";s:34:\"cuar_permalink_update_content_slug\";s:6:\"update\";s:34:\"cuar_permalink_delete_content_slug\";s:6:\"delete\";s:23:\"cuar_license_key_status\";s:0:\"\";s:29:\"cuar_license_key_user-profile\";s:0:\"\";s:27:\"cuar_license_key_shortcodes\";s:0:\"\";s:32:\"cuar_license_key_address-manager\";s:0:\"\";s:30:\"cuar_license_key_private-pages\";s:0:\"\";s:20:\"enable_private_pages\";b:1;s:30:\"cuar_license_key_private-files\";s:0:\"\";s:20:\"enable_private_files\";b:1;s:24:\"frontend_ftp_upload_path\";s:75:\"/home/uctgnqkd/public_html/gramgro.com/wp-content/customer-area/ftp-uploads\";s:21:\"frontend_storage_path\";s:0:\"\";s:30:\"cuar_license_key_customer-home\";s:0:\"\";s:35:\"cuar_license_key_customer-dashboard\";s:0:\"\";s:38:\"cuar_license_key_customer-account-home\";s:0:\"\";s:38:\"cuar_license_key_customer-account-edit\";s:0:\"\";s:33:\"cuar_license_key_customer-account\";s:0:\"\";s:32:\"cuar_license_key_customer-logout\";s:0:\"\";s:44:\"cuar_license_key_customer-private-files-home\";s:0:\"\";s:39:\"cuar_license_key_customer-private-files\";s:0:\"\";s:49:\"customer-private-files-show_in_single_post_footer\";b:1;s:40:\"customer-private-files-show_in_dashboard\";b:1;s:45:\"customer-private-files-max_items_on_dashboard\";i:5;s:43:\"customer-private-files-max_items_on_listing\";i:10;s:44:\"cuar_license_key_customer-private-pages-home\";s:0:\"\";s:39:\"cuar_license_key_customer-private-pages\";s:0:\"\";s:49:\"customer-private-pages-show_in_single_post_footer\";b:1;s:40:\"customer-private-pages-show_in_dashboard\";b:1;s:45:\"customer-private-pages-max_items_on_dashboard\";i:5;s:43:\"customer-private-pages-max_items_on_listing\";i:10;s:20:\"cuar_current_version\";s:5:\"7.1.0\";s:27:\"customer_page_customer-home\";s:2:\"42\";s:32:\"customer_page_customer-dashboard\";s:2:\"43\";s:41:\"customer_page_customer-private-files-home\";i:133;s:36:\"customer_page_customer-private-files\";i:134;s:41:\"customer_page_customer-private-pages-home\";i:135;s:36:\"customer_page_customer-private-pages\";i:136;s:35:\"customer_page_customer-account-home\";s:2:\"48\";s:30:\"customer_page_customer-account\";s:2:\"49\";s:35:\"customer_page_customer-account-edit\";s:2:\"50\";s:29:\"customer_page_customer-logout\";s:2:\"51\";}", "yes");
INSERT INTO wpax_options VALUES("281", "cuar/core/status/ignored-warnings", "a:1:{s:25:\"unconfigured-capabilities\";b:1;}", "yes");
INSERT INTO wpax_options VALUES("288", "cuar_owner_addresses|usr|2", "a:2:{s:12:\"home_address\";a:10:{s:4:\"name\";s:0:\"\";s:7:\"company\";s:0:\"\";s:10:\"vat_number\";s:0:\"\";s:8:\"logo_url\";s:0:\"\";s:5:\"line1\";s:0:\"\";s:5:\"line2\";s:0:\"\";s:3:\"zip\";s:0:\"\";s:4:\"city\";s:0:\"\";s:7:\"country\";s:0:\"\";s:5:\"state\";s:0:\"\";}s:15:\"billing_address\";a:10:{s:4:\"name\";s:0:\"\";s:7:\"company\";s:0:\"\";s:10:\"vat_number\";s:0:\"\";s:8:\"logo_url\";s:0:\"\";s:5:\"line1\";s:0:\"\";s:5:\"line2\";s:0:\"\";s:3:\"zip\";s:0:\"\";s:4:\"city\";s:0:\"\";s:7:\"country\";s:0:\"\";s:5:\"state\";s:0:\"\";}}", "yes");
INSERT INTO wpax_options VALUES("295", "cuar_private_file_category_children", "a:0:{}", "yes");
INSERT INTO wpax_options VALUES("302", "customize-login-page", "a:3:{s:9:\"image_url\";s:59:\"http://gramgro.com/wp-content/uploads/2016/12/GramGro01.jpg\";s:6:\"height\";s:3:\"900\";s:5:\"width\";s:4:\"1600\";}", "yes");
INSERT INTO wpax_options VALUES("305", "seed_cl_settings_content", "a:1:{s:6:\"status\";s:1:\"1\";}", "yes");
INSERT INTO wpax_options VALUES("306", "seed_cl_customizer_settings", "a:27:{s:6:\"action\";s:17:\"seed_cl_save_page\";s:8:\"_wpnonce\";s:10:\"80aa9b1719\";s:15:\"disabled_fields\";s:0:\"\";s:9:\"first_run\";s:0:\"\";s:7:\"page_id\";s:1:\"1\";s:11:\"logo_height\";s:4:\"2333\";s:10:\"logo_width\";s:4:\"4000\";s:4:\"logo\";s:59:\"http://gramgro.com/wp-content/uploads/2016/12/GramGro01.png\";s:16:\"rich_description\";s:0:\"\";s:16:\"background_color\";s:7:\"#ffffff\";s:16:\"background_image\";s:69:\"http://gramgro.com/wp-content/uploads/2016/12/new-york-city-guide.jpg\";s:30:\"enable_background_adv_settings\";s:1:\"1\";s:15:\"background_size\";s:4:\"auto\";s:17:\"background_repeat\";s:6:\"repeat\";s:19:\"background_position\";s:11:\"left center\";s:21:\"background_attachment\";s:6:\"scroll\";s:12:\"button_color\";s:7:\"#000000\";s:10:\"text_color\";s:7:\"#72777c\";s:15:\"text_link_color\";s:7:\"#fffafa\";s:9:\"text_font\";s:23:\"\'Open Sans\', sans-serif\";s:11:\"text_weight\";s:3:\"400\";s:11:\"text_subset\";s:0:\"\";s:9:\"text_size\";s:2:\"17\";s:16:\"text_line_height\";s:4:\"1.36\";s:9:\"theme_css\";s:0:\"\";s:13:\"theme_scripts\";s:0:\"\";s:10:\"custom_css\";s:0:\"\";}", "yes");
INSERT INTO wpax_options VALUES("321", "widget_illdy_recent_posts", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO wpax_options VALUES("322", "widget_illdy_skill", "a:4:{s:12:\"_multiwidget\";i:1;i:2;a:4:{s:5:\"title\";s:10:\"Typography\";s:10:\"percentage\";i:100;s:4:\"icon\";s:7:\"fa-font\";s:5:\"color\";s:7:\"#f18b6d\";}i:3;a:4:{s:5:\"title\";s:6:\"Design\";s:10:\"percentage\";i:82;s:4:\"icon\";s:9:\"fa-pencil\";s:5:\"color\";s:7:\"#f1d204\";}i:4;a:4:{s:5:\"title\";s:11:\"Development\";s:10:\"percentage\";i:86;s:4:\"icon\";s:7:\"fa-code\";s:5:\"color\";s:7:\"#6a4d8a\";}}", "yes");
INSERT INTO wpax_options VALUES("323", "widget_illdy_project", "a:5:{s:12:\"_multiwidget\";i:1;i:3;a:3:{s:5:\"title\";s:9:\"Project 1\";s:5:\"image\";s:50:\"/layout/images/front-page/front-page-project-1.jpg\";s:3:\"url\";s:1:\"#\";}i:4;a:3:{s:5:\"title\";s:9:\"Project 2\";s:5:\"image\";s:50:\"/layout/images/front-page/front-page-project-2.jpg\";s:3:\"url\";s:1:\"#\";}i:5;a:3:{s:5:\"title\";s:9:\"Project 3\";s:5:\"image\";s:50:\"/layout/images/front-page/front-page-project-3.jpg\";s:3:\"url\";s:1:\"#\";}i:6;a:3:{s:5:\"title\";s:9:\"Project 4\";s:5:\"image\";s:50:\"/layout/images/front-page/front-page-project-4.jpg\";s:3:\"url\";s:1:\"#\";}}", "yes");
INSERT INTO wpax_options VALUES("324", "widget_illdy_service", "a:8:{s:12:\"_multiwidget\";i:1;i:2;a:4:{s:5:\"title\";s:8:\"Location\";s:4:\"icon\";s:13:\"fa-map-marker\";s:5:\"entry\";s:213:\"GramGro can help you target by location, whether its an entire city or a popular location of your targeted community, GramGro can  find users who have tagged those locations and interact with them on your behalf. \";s:5:\"color\";s:7:\"#4c68d7\";}i:3;a:4:{s:5:\"title\";s:5:\"Users\";s:4:\"icon\";s:7:\"fa-user\";s:5:\"entry\";s:191:\"Interact with users who already follow a specific user. Scrape from your competitors or from the top industry profiles to target those who are already interested in content similar to yours. \";s:5:\"color\";s:7:\"#8a3ab9\";}i:4;a:4:{s:5:\"title\";s:8:\"Hashtags\";s:4:\"icon\";s:12:\"fa-instagram\";s:5:\"entry\";s:177:\"Hashtags are a great way to find people interested in content you sure, from #fitness to #makeup, and much more hashtags can help you attract followers from all over the world. \";s:5:\"color\";s:7:\"#fbad50\";}i:6;a:0:{}i:8;a:4:{s:5:\"title\";s:6:\"Follow\";s:4:\"icon\";s:12:\"fa-user-plus\";s:5:\"entry\";s:142:\"Follow users based on the targeting settings. You will have the option to unfollow them, or just unfollow the ones who don\'t follow you back. \";s:5:\"color\";s:7:\"#fccc63\";}i:9;a:4:{s:5:\"title\";s:4:\"Like\";s:4:\"icon\";s:8:\"fa-heart\";s:5:\"entry\";s:134:\"Like images of users based on targeting settings below, including those who use hashtags or tag their pictures in specific locations. \";s:5:\"color\";s:7:\"#e95950\";}i:10;a:4:{s:5:\"title\";s:7:\"Comment\";s:4:\"icon\";s:16:\"fa-pencil-square\";s:5:\"entry\";s:150:\"Comment on pictures of users based on targeting settings, comments can be short and sweet,  or can be a unique message designed to explain your page. \";s:5:\"color\";s:7:\"#bc2a8d\";}}", "yes");
INSERT INTO wpax_options VALUES("325", "widget_illdy_counter", "a:4:{s:12:\"_multiwidget\";i:1;i:4;a:5:{s:5:\"title\";s:7:\"Clients\";s:9:\"data_from\";i:1;s:7:\"data_to\";i:486;s:10:\"data_speed\";i:2000;s:21:\"data_refresh_interval\";i:100;}i:3;a:5:{s:5:\"title\";s:16:\"Followers Gained\";s:9:\"data_from\";i:5211;s:7:\"data_to\";i:26104709;s:10:\"data_speed\";i:2000;s:21:\"data_refresh_interval\";i:100;}i:2;a:5:{s:5:\"title\";s:22:\"[Illdy] - Recent Posts\";s:9:\"data_from\";i:1;s:7:\"data_to\";i:260;s:10:\"data_speed\";i:2000;s:21:\"data_refresh_interval\";i:100;}}", "yes");
INSERT INTO wpax_options VALUES("326", "widget_illdy_person", "a:5:{s:12:\"_multiwidget\";i:1;i:5;a:8:{s:5:\"title\";s:13:\"Mark Lawrance\";s:5:\"image\";s:47:\"/layout/images/front-page/front-page-team-1.jpg\";s:8:\"position\";s:12:\"Web Designer\";s:5:\"entry\";s:42:\"Creative, detail-oriented, always focused.\";s:12:\"facebook_url\";s:1:\"#\";s:11:\"twitter_url\";s:1:\"#\";s:12:\"linkedin_url\";s:1:\"#\";s:5:\"color\";s:7:\"#f18b6d\";}i:4;a:8:{s:5:\"title\";s:13:\"Jane  Stenton\";s:5:\"image\";s:47:\"/layout/images/front-page/front-page-team-2.jpg\";s:8:\"position\";s:14:\"SEO Specialist\";s:5:\"entry\";s:59:\"Curious, tech-geeck and gets serious when it comes to work.\";s:12:\"facebook_url\";s:1:\"#\";s:11:\"twitter_url\";s:1:\"#\";s:12:\"linkedin_url\";s:1:\"#\";s:5:\"color\";s:7:\"#f1d204\";}i:2;a:8:{s:5:\"title\";s:10:\"John Smith\";s:5:\"image\";s:47:\"/layout/images/front-page/front-page-team-3.jpg\";s:8:\"position\";s:9:\"Developer\";s:5:\"entry\";s:51:\"Enthusiastic, passionate with great sense of humor.\";s:12:\"facebook_url\";s:1:\"#\";s:11:\"twitter_url\";s:1:\"#\";s:12:\"linkedin_url\";s:1:\"#\";s:5:\"color\";s:7:\"#6a4d8a\";}i:7;a:0:{}}", "yes");
INSERT INTO wpax_options VALUES("338", "nav_menu_options", "a:1:{s:8:\"auto_add\";a:0:{}}", "yes");
INSERT INTO wpax_options VALUES("363", "category_children", "a:0:{}", "yes");
INSERT INTO wpax_options VALUES("379", "_transient_timeout_wflginfl_00000000000000000000ffffd572edcc", "1481926988", "no");
INSERT INTO wpax_options VALUES("380", "_transient_wflginfl_00000000000000000000ffffd572edcc", "2", "no");
INSERT INTO wpax_options VALUES("657", "_transient_timeout_wflginfl_00000000000000000000ffff2573bfef", "1482372666", "no");
INSERT INTO wpax_options VALUES("658", "_transient_wflginfl_00000000000000000000ffff2573bfef", "4", "no");
INSERT INTO wpax_options VALUES("668", "illdy_show_required_actions", "a:1:{s:24:\"illdy-req-import-content\";b:1;}", "yes");
INSERT INTO wpax_options VALUES("707", "jetpack_activated", "1", "yes");
INSERT INTO wpax_options VALUES("708", "jetpack_sync_settings_disable", "0", "yes");
INSERT INTO wpax_options VALUES("709", "jetpack_file_data", "a:1:{s:3:\"4.5\";a:51:{s:32:\"31e5b9ae08b62c2b0cd8a7792242298b\";a:14:{s:4:\"name\";s:20:\"Spelling and Grammar\";s:11:\"description\";s:40:\"Check your spelling, style, and grammar.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:1:\"6\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"1.1\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:7:\"Writing\";s:7:\"feature\";s:7:\"Writing\";s:25:\"additional_search_queries\";s:115:\"after the deadline, afterthedeadline, spell, spellchecker, spelling, grammar, proofreading, style, language, cliche\";}s:32:\"3f41b2d629265b5de8108b463abbe8e2\";a:14:{s:4:\"name\";s:8:\"Carousel\";s:11:\"description\";s:76:\"Display images and galleries in a gorgeous, full-screen browsing experience.\";s:14:\"jumpstart_desc\";s:79:\"Brings your photos and images to life as full-size, easily navigable galleries.\";s:4:\"sort\";s:2:\"22\";s:20:\"recommendation_order\";s:2:\"12\";s:10:\"introduced\";s:3:\"1.5\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:17:\"Photos and Videos\";s:7:\"feature\";s:21:\"Appearance, Jumpstart\";s:25:\"additional_search_queries\";s:80:\"gallery, carousel, diaporama, slideshow, images, lightbox, exif, metadata, image\";}s:32:\"c6ebb418dde302de09600a6025370583\";a:14:{s:4:\"name\";s:8:\"Comments\";s:11:\"description\";s:65:\"Allow comments with WordPress.com, Twitter, Facebook, or Google+.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:2:\"20\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"1.4\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:6:\"Social\";s:7:\"feature\";s:10:\"Engagement\";s:25:\"additional_search_queries\";s:53:\"comments, comment, facebook, twitter, google+, social\";}s:32:\"836f9485669e1bbb02920cb474730df0\";a:14:{s:4:\"name\";s:12:\"Contact Form\";s:11:\"description\";s:57:\"Insert a customizable contact form anywhere on your site.\";s:14:\"jumpstart_desc\";s:111:\"Adds a button to your post and page editors, allowing you to build simple forms to help visitors stay in touch.\";s:4:\"sort\";s:2:\"15\";s:20:\"recommendation_order\";s:2:\"14\";s:10:\"introduced\";s:3:\"1.3\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:5:\"Other\";s:7:\"feature\";s:18:\"Writing, Jumpstart\";s:25:\"additional_search_queries\";s:44:\"contact, form, grunion, feedback, submission\";}s:32:\"ea3970eebf8aac55fc3eca5dca0e0157\";a:14:{s:4:\"name\";s:20:\"Custom Content Types\";s:11:\"description\";s:61:\"Organize and display different types of content on your site.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:2:\"34\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"3.1\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:7:\"Writing\";s:7:\"feature\";s:7:\"Writing\";s:25:\"additional_search_queries\";s:72:\"cpt, custom post types, portfolio, portfolios, testimonial, testimonials\";}s:32:\"d2bb05ccad3d8789df40ca3abb97336c\";a:14:{s:4:\"name\";s:10:\"Custom CSS\";s:11:\"description\";s:53:\"Tweak your site’s CSS without modifying your theme.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:1:\"2\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"1.7\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:10:\"Appearance\";s:7:\"feature\";s:10:\"Appearance\";s:25:\"additional_search_queries\";s:108:\"css, customize, custom, style, editor, less, sass, preprocessor, font, mobile, appearance, theme, stylesheet\";}s:32:\"a2064eec5b9c7e0d816af71dee7a715f\";a:14:{s:4:\"name\";s:0:\"\";s:11:\"description\";s:0:\"\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:0:\"\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:0:\"\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:0:\"\";s:13:\"auto_activate\";s:0:\"\";s:11:\"module_tags\";s:0:\"\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:0:\"\";}s:32:\"53a4ec755022ef3953699734c343da02\";a:14:{s:4:\"name\";s:21:\"Enhanced Distribution\";s:11:\"description\";s:27:\"Increase reach and traffic.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:1:\"5\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"1.2\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:6:\"Public\";s:11:\"module_tags\";s:7:\"Writing\";s:7:\"feature\";s:10:\"Engagement\";s:25:\"additional_search_queries\";s:54:\"google, seo, firehose, search, broadcast, broadcasting\";}s:32:\"72fecb67ee6704ba0a33e0225316ad06\";a:14:{s:4:\"name\";s:0:\"\";s:11:\"description\";s:0:\"\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:0:\"\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:0:\"\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:0:\"\";s:13:\"auto_activate\";s:0:\"\";s:11:\"module_tags\";s:0:\"\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:0:\"\";}s:32:\"d56e2886185a9eace719cc57d46770df\";a:14:{s:4:\"name\";s:19:\"Gravatar Hovercards\";s:11:\"description\";s:58:\"Enable pop-up business cards over commenters’ Gravatars.\";s:14:\"jumpstart_desc\";s:131:\"Let commenters link their profiles to their Gravatar accounts, making it easy for your visitors to learn more about your community.\";s:4:\"sort\";s:2:\"11\";s:20:\"recommendation_order\";s:2:\"13\";s:10:\"introduced\";s:3:\"1.1\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:18:\"Social, Appearance\";s:7:\"feature\";s:21:\"Appearance, Jumpstart\";s:25:\"additional_search_queries\";s:20:\"gravatar, hovercards\";}s:32:\"e391e760617bd0e0736550e34a73d7fe\";a:14:{s:4:\"name\";s:0:\"\";s:11:\"description\";s:0:\"\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:0:\"\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:8:\"2.0.3 ??\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:0:\"\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:0:\"\";}s:32:\"2e345370766346c616b3c5046e817720\";a:14:{s:4:\"name\";s:15:\"Infinite Scroll\";s:11:\"description\";s:54:\"Automatically load new content when a visitor scrolls.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:2:\"26\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"2.0\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:10:\"Appearance\";s:7:\"feature\";s:10:\"Appearance\";s:25:\"additional_search_queries\";s:33:\"scroll, infinite, infinite scroll\";}s:32:\"bd69edbf134de5fae8fdcf2e70a45b56\";a:14:{s:4:\"name\";s:8:\"JSON API\";s:11:\"description\";s:51:\"Allow applications to securely access your content.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:2:\"19\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"1.9\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:6:\"Public\";s:11:\"module_tags\";s:19:\"Writing, Developers\";s:7:\"feature\";s:7:\"General\";s:25:\"additional_search_queries\";s:50:\"api, rest, develop, developers, json, klout, oauth\";}s:32:\"8110b7a4423aaa619dfa46b8843e10d1\";a:14:{s:4:\"name\";s:14:\"Beautiful Math\";s:11:\"description\";s:57:\"Use LaTeX markup for complex equations and other geekery.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:2:\"12\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"1.1\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:7:\"Writing\";s:7:\"feature\";s:7:\"Writing\";s:25:\"additional_search_queries\";s:47:\"latex, math, equation, equations, formula, code\";}s:32:\"fd7e85d3b4887fa6b6f997d6592c1f33\";a:14:{s:4:\"name\";s:5:\"Likes\";s:11:\"description\";s:63:\"Give visitors an easy way to show they appreciate your content.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:2:\"23\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"2.2\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:6:\"Social\";s:7:\"feature\";s:10:\"Engagement\";s:25:\"additional_search_queries\";s:26:\"like, likes, wordpress.com\";}s:32:\"c5dfef41fad5bcdcaae8e315e5cfc420\";a:14:{s:4:\"name\";s:6:\"Manage\";s:11:\"description\";s:54:\"Manage all of your sites from a centralized dashboard.\";s:14:\"jumpstart_desc\";s:151:\"Helps you remotely manage plugins, turn on automated updates, and more from <a href=\"https://wordpress.com/plugins/\" target=\"_blank\">wordpress.com</a>.\";s:4:\"sort\";s:1:\"1\";s:20:\"recommendation_order\";s:1:\"3\";s:10:\"introduced\";s:3:\"3.4\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:35:\"Centralized Management, Recommended\";s:7:\"feature\";s:7:\"General\";s:25:\"additional_search_queries\";s:26:\"manage, management, remote\";}s:32:\"fd6dc399b92bce76013427e3107c314f\";a:14:{s:4:\"name\";s:8:\"Markdown\";s:11:\"description\";s:51:\"Write posts or pages in plain-text Markdown syntax.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:2:\"31\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"2.8\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:7:\"Writing\";s:7:\"feature\";s:7:\"Writing\";s:25:\"additional_search_queries\";s:12:\"md, markdown\";}s:32:\"c49a35b6482b0426cb07ad28ecf5d7df\";a:14:{s:4:\"name\";s:12:\"Mobile Theme\";s:11:\"description\";s:47:\"Optimize your site for smartphones and tablets.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:2:\"21\";s:20:\"recommendation_order\";s:2:\"11\";s:10:\"introduced\";s:3:\"1.8\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:31:\"Appearance, Mobile, Recommended\";s:7:\"feature\";s:10:\"Appearance\";s:25:\"additional_search_queries\";s:24:\"mobile, theme, minileven\";}s:32:\"b42e38f6fafd2e4104ebe5bf39b4be47\";a:14:{s:4:\"name\";s:0:\"\";s:11:\"description\";s:0:\"\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:0:\"\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:0:\"\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:0:\"\";s:13:\"auto_activate\";s:0:\"\";s:11:\"module_tags\";s:0:\"\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:0:\"\";}s:32:\"771cfeeba0d3d23ec344d5e781fb0ae2\";a:14:{s:4:\"name\";s:0:\"\";s:11:\"description\";s:0:\"\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:0:\"\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:0:\"\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:0:\"\";s:13:\"auto_activate\";s:0:\"\";s:11:\"module_tags\";s:0:\"\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:0:\"\";}s:32:\"54f0661d27c814fc8bde39580181d939\";a:14:{s:4:\"name\";s:0:\"\";s:11:\"description\";s:0:\"\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:0:\"\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:0:\"\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:0:\"\";s:13:\"auto_activate\";s:0:\"\";s:11:\"module_tags\";s:0:\"\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:0:\"\";}s:32:\"46c4c413b5c72bbd3c3dbd14ff8f8adc\";a:14:{s:4:\"name\";s:0:\"\";s:11:\"description\";s:0:\"\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:0:\"\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:0:\"\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:0:\"\";s:13:\"auto_activate\";s:0:\"\";s:11:\"module_tags\";s:0:\"\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:0:\"\";}s:32:\"9ea52fa25783e5ceeb6bfaed3268e64e\";a:14:{s:4:\"name\";s:7:\"Monitor\";s:11:\"description\";s:61:\"Receive immediate notifications if your site goes down, 24/7.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:2:\"28\";s:20:\"recommendation_order\";s:2:\"10\";s:10:\"introduced\";s:3:\"2.6\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:11:\"Recommended\";s:7:\"feature\";s:8:\"Security\";s:25:\"additional_search_queries\";s:37:\"monitor, uptime, downtime, monitoring\";}s:32:\"cfcaafd0fcad087899d715e0b877474d\";a:14:{s:4:\"name\";s:13:\"Notifications\";s:11:\"description\";s:57:\"Receive instant notifications of site comments and likes.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:2:\"13\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"1.9\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:5:\"Other\";s:7:\"feature\";s:7:\"General\";s:25:\"additional_search_queries\";s:62:\"notification, notifications, toolbar, adminbar, push, comments\";}s:32:\"0d18bfa69bec61550c1d813ce64149b0\";a:14:{s:4:\"name\";s:10:\"Omnisearch\";s:11:\"description\";s:66:\"Search your entire database from a single field in your dashboard.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:2:\"16\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"2.3\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:10:\"Developers\";s:7:\"feature\";s:7:\"General\";s:25:\"additional_search_queries\";s:6:\"search\";}s:32:\"3f0a11e23118f0788d424b646a6d465f\";a:14:{s:4:\"name\";s:6:\"Photon\";s:11:\"description\";s:27:\"Speed up images and photos.\";s:14:\"jumpstart_desc\";s:141:\"Mirrors and serves your images from our free and fast image CDN, improving your site’s performance with no additional load on your servers.\";s:4:\"sort\";s:2:\"25\";s:20:\"recommendation_order\";s:1:\"1\";s:10:\"introduced\";s:3:\"2.0\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:42:\"Photos and Videos, Appearance, Recommended\";s:7:\"feature\";s:34:\"Recommended, Jumpstart, Appearance\";s:25:\"additional_search_queries\";s:38:\"photon, image, cdn, performance, speed\";}s:32:\"e37cfbcb72323fb1fe8255a2edb4d738\";a:14:{s:4:\"name\";s:13:\"Post by Email\";s:11:\"description\";s:34:\"Publish posts by sending an email.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:2:\"14\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"2.0\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:7:\"Writing\";s:7:\"feature\";s:7:\"Writing\";s:25:\"additional_search_queries\";s:20:\"post by email, email\";}s:32:\"728290d131a480bfe7b9e405d7cd925f\";a:14:{s:4:\"name\";s:7:\"Protect\";s:11:\"description\";s:43:\"Prevent and block malicious login attempts.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:1:\"1\";s:20:\"recommendation_order\";s:1:\"4\";s:10:\"introduced\";s:3:\"3.4\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:11:\"Recommended\";s:7:\"feature\";s:8:\"Security\";s:25:\"additional_search_queries\";s:65:\"security, secure, protection, botnet, brute force, protect, login\";}s:32:\"f9ce784babbbf4dcca99b8cd2ceb420c\";a:14:{s:4:\"name\";s:9:\"Publicize\";s:11:\"description\";s:27:\"Automated social marketing.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:2:\"10\";s:20:\"recommendation_order\";s:1:\"7\";s:10:\"introduced\";s:3:\"2.0\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:19:\"Social, Recommended\";s:7:\"feature\";s:10:\"Engagement\";s:25:\"additional_search_queries\";s:107:\"facebook, twitter, google+, googleplus, google, path, tumblr, linkedin, social, tweet, connections, sharing\";}s:32:\"052c03877dd3d296a71531cb07ad939a\";a:14:{s:4:\"name\";s:0:\"\";s:11:\"description\";s:0:\"\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:0:\"\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:0:\"\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:0:\"\";s:13:\"auto_activate\";s:0:\"\";s:11:\"module_tags\";s:0:\"\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:0:\"\";}s:32:\"52edecb2a75222e75b2dce4356a4efce\";a:14:{s:4:\"name\";s:13:\"Related Posts\";s:11:\"description\";s:64:\"Increase page views by showing related content to your visitors.\";s:14:\"jumpstart_desc\";s:113:\"Keep visitors engaged on your blog by highlighting relevant and new content at the bottom of each published post.\";s:4:\"sort\";s:2:\"29\";s:20:\"recommendation_order\";s:1:\"9\";s:10:\"introduced\";s:3:\"2.9\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:11:\"Recommended\";s:7:\"feature\";s:21:\"Engagement, Jumpstart\";s:25:\"additional_search_queries\";s:22:\"related, related posts\";}s:32:\"68b0d01689803c0ea7e4e60a86de2519\";a:14:{s:4:\"name\";s:9:\"SEO tools\";s:11:\"description\";s:50:\"Better results on search engines and social media.\";s:14:\"jumpstart_desc\";s:50:\"Better results on search engines and social media.\";s:4:\"sort\";s:2:\"35\";s:20:\"recommendation_order\";s:2:\"15\";s:10:\"introduced\";s:3:\"4.4\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:18:\"Social, Appearance\";s:7:\"feature\";s:18:\"Traffic, Jumpstart\";s:25:\"additional_search_queries\";s:81:\"search engine optimization, social preview, meta description, custom title format\";}s:32:\"8b059cb50a66b717f1ec842e736b858c\";a:14:{s:4:\"name\";s:7:\"Sharing\";s:11:\"description\";s:37:\"Allow visitors to share your content.\";s:14:\"jumpstart_desc\";s:116:\"Twitter, Facebook and Google+ buttons at the bottom of each post, making it easy for visitors to share your content.\";s:4:\"sort\";s:1:\"7\";s:20:\"recommendation_order\";s:1:\"6\";s:10:\"introduced\";s:3:\"1.1\";s:7:\"changed\";s:3:\"1.2\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:19:\"Social, Recommended\";s:7:\"feature\";s:21:\"Engagement, Jumpstart\";s:25:\"additional_search_queries\";s:141:\"share, sharing, sharedaddy, buttons, icons, email, facebook, twitter, google+, linkedin, pinterest, pocket, press this, print, reddit, tumblr\";}s:32:\"a6d2394329871857401255533a9873f7\";a:14:{s:4:\"name\";s:16:\"Shortcode Embeds\";s:11:\"description\";s:50:\"Embed media from popular sites without any coding.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:1:\"3\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"1.1\";s:7:\"changed\";s:3:\"1.2\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:46:\"Photos and Videos, Social, Writing, Appearance\";s:7:\"feature\";s:7:\"Writing\";s:25:\"additional_search_queries\";s:236:\"shortcodes, shortcode, embeds, media, bandcamp, dailymotion, facebook, flickr, google calendars, google maps, google+, polldaddy, recipe, recipes, scribd, slideshare, slideshow, slideshows, soundcloud, ted, twitter, vimeo, vine, youtube\";}s:32:\"21496e2897ea5f81605e2f2ac3beb921\";a:14:{s:4:\"name\";s:16:\"WP.me Shortlinks\";s:11:\"description\";s:54:\"Create short and simple links for all posts and pages.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:1:\"8\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"1.1\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:6:\"Social\";s:7:\"feature\";s:7:\"Writing\";s:25:\"additional_search_queries\";s:17:\"shortlinks, wp.me\";}s:32:\"e2a54a5d7879a4162709e6ffb540dd08\";a:14:{s:4:\"name\";s:0:\"\";s:11:\"description\";s:0:\"\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:0:\"\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:0:\"\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:0:\"\";s:13:\"auto_activate\";s:0:\"\";s:11:\"module_tags\";s:0:\"\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:0:\"\";}s:32:\"f5c537bc304f55b29c1a87e30be0cd24\";a:14:{s:4:\"name\";s:8:\"Sitemaps\";s:11:\"description\";s:50:\"Make it easy for search engines to find your site.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:2:\"13\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"3.9\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:6:\"Public\";s:11:\"module_tags\";s:20:\"Recommended, Traffic\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:39:\"sitemap, traffic, search, site map, seo\";}s:32:\"59a23643437358a9b557f1d1e20ab040\";a:14:{s:4:\"name\";s:0:\"\";s:11:\"description\";s:0:\"\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:0:\"\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:0:\"\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:0:\"\";s:13:\"auto_activate\";s:0:\"\";s:11:\"module_tags\";s:0:\"\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:0:\"\";}s:32:\"6a90f97c3194cfca5671728eaaeaf15e\";a:14:{s:4:\"name\";s:14:\"Single Sign On\";s:11:\"description\";s:46:\"Secure user authentication with WordPress.com.\";s:14:\"jumpstart_desc\";s:98:\"Lets you log in to all your Jetpack-enabled sites with one click using your WordPress.com account.\";s:4:\"sort\";s:2:\"30\";s:20:\"recommendation_order\";s:1:\"5\";s:10:\"introduced\";s:3:\"2.6\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:10:\"Developers\";s:7:\"feature\";s:19:\"Security, Jumpstart\";s:25:\"additional_search_queries\";s:34:\"sso, single sign on, login, log in\";}s:32:\"b65604e920392e2f7134b646760b75e8\";a:14:{s:4:\"name\";s:10:\"Site Stats\";s:11:\"description\";s:44:\"Collect valuable traffic stats and insights.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:1:\"1\";s:20:\"recommendation_order\";s:1:\"2\";s:10:\"introduced\";s:3:\"1.1\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:23:\"Site Stats, Recommended\";s:7:\"feature\";s:10:\"Engagement\";s:25:\"additional_search_queries\";s:54:\"statistics, tracking, analytics, views, traffic, stats\";}s:32:\"23a586dd7ead00e69ec53eb32ef740e4\";a:14:{s:4:\"name\";s:13:\"Subscriptions\";s:11:\"description\";s:55:\"Notify your readers of new posts and comments by email.\";s:14:\"jumpstart_desc\";s:126:\"Give visitors two easy subscription options — while commenting, or via a separate email subscription widget you can display.\";s:4:\"sort\";s:1:\"9\";s:20:\"recommendation_order\";s:1:\"8\";s:10:\"introduced\";s:3:\"1.2\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:6:\"Social\";s:7:\"feature\";s:21:\"Engagement, Jumpstart\";s:25:\"additional_search_queries\";s:74:\"subscriptions, subscription, email, follow, followers, subscribers, signup\";}s:32:\"1d978b8d84d2f378fe1a702a67633b6d\";a:14:{s:4:\"name\";s:0:\"\";s:11:\"description\";s:0:\"\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:0:\"\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:0:\"\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:0:\"\";s:13:\"auto_activate\";s:0:\"\";s:11:\"module_tags\";s:0:\"\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:0:\"\";}s:32:\"b3b983461d7f3d27322a3551ed8a9405\";a:14:{s:4:\"name\";s:15:\"Tiled Galleries\";s:11:\"description\";s:61:\"Display image galleries in a variety of elegant arrangements.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:2:\"24\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"2.1\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:17:\"Photos and Videos\";s:7:\"feature\";s:10:\"Appearance\";s:25:\"additional_search_queries\";s:43:\"gallery, tiles, tiled, grid, mosaic, images\";}s:32:\"d924e5b05722b0e104448543598f54c0\";a:14:{s:4:\"name\";s:0:\"\";s:11:\"description\";s:0:\"\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:0:\"\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:0:\"\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:0:\"\";s:13:\"auto_activate\";s:0:\"\";s:11:\"module_tags\";s:0:\"\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:0:\"\";}s:32:\"36741583b10c521997e563ad8e1e8b77\";a:14:{s:4:\"name\";s:12:\"Data Backups\";s:11:\"description\";s:54:\"Off-site backups, security scans, and automatic fixes.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:2:\"32\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:5:\"0:1.2\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:5:\"false\";s:4:\"free\";s:5:\"false\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:0:\"\";s:7:\"feature\";s:16:\"Security, Health\";s:25:\"additional_search_queries\";s:28:\"vaultpress, backup, security\";}s:32:\"2b9b44f09b5459617d68dd82ee17002a\";a:14:{s:4:\"name\";s:17:\"Site Verification\";s:11:\"description\";s:58:\"Establish your site\'s authenticity with external services.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:2:\"33\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"3.0\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:0:\"\";s:7:\"feature\";s:10:\"Engagement\";s:25:\"additional_search_queries\";s:56:\"webmaster, seo, google, bing, pinterest, search, console\";}s:32:\"5ab4c0db7c42e10e646342da0274c491\";a:14:{s:4:\"name\";s:10:\"VideoPress\";s:11:\"description\";s:45:\"Powerful, simple video hosting for WordPress.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:2:\"27\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"2.5\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:5:\"false\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:0:\"\";s:11:\"module_tags\";s:17:\"Photos and Videos\";s:7:\"feature\";s:7:\"Writing\";s:25:\"additional_search_queries\";s:25:\"video, videos, videopress\";}s:32:\"60a1d3aa38bc0fe1039e59dd60888543\";a:14:{s:4:\"name\";s:17:\"Widget Visibility\";s:11:\"description\";s:42:\"Control where widgets appear on your site.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:2:\"17\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"2.4\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:10:\"Appearance\";s:7:\"feature\";s:10:\"Appearance\";s:25:\"additional_search_queries\";s:54:\"widget visibility, logic, conditional, widgets, widget\";}s:32:\"174ed3416476c2cb9ff5b0f671280b15\";a:14:{s:4:\"name\";s:21:\"Extra Sidebar Widgets\";s:11:\"description\";s:54:\"Add images, Twitter streams, and more to your sidebar.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:1:\"4\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"1.2\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:18:\"Social, Appearance\";s:7:\"feature\";s:10:\"Appearance\";s:25:\"additional_search_queries\";s:65:\"widget, widgets, facebook, gallery, twitter, gravatar, image, rss\";}s:32:\"a668bc9418d6de87409f867892fcdd7f\";a:14:{s:4:\"name\";s:3:\"Ads\";s:11:\"description\";s:60:\"Earn income by allowing Jetpack to display high quality ads.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:1:\"1\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:5:\"4.5.0\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:19:\"Traffic, Appearance\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:26:\"advertising, ad codes, ads\";}s:32:\"28b931a1db19bd24869bd54b14e733d5\";a:14:{s:4:\"name\";s:0:\"\";s:11:\"description\";s:0:\"\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:0:\"\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:0:\"\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:0:\"\";s:13:\"auto_activate\";s:0:\"\";s:11:\"module_tags\";s:0:\"\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:0:\"\";}}}", "yes");
INSERT INTO wpax_options VALUES("710", "jetpack_available_modules", "a:1:{s:3:\"4.5\";a:38:{s:18:\"after-the-deadline\";s:3:\"1.1\";s:8:\"carousel\";s:3:\"1.5\";s:8:\"comments\";s:3:\"1.4\";s:12:\"contact-form\";s:3:\"1.3\";s:20:\"custom-content-types\";s:3:\"3.1\";s:10:\"custom-css\";s:3:\"1.7\";s:21:\"enhanced-distribution\";s:3:\"1.2\";s:19:\"gravatar-hovercards\";s:3:\"1.1\";s:15:\"infinite-scroll\";s:3:\"2.0\";s:8:\"json-api\";s:3:\"1.9\";s:5:\"latex\";s:3:\"1.1\";s:5:\"likes\";s:3:\"2.2\";s:6:\"manage\";s:3:\"3.4\";s:8:\"markdown\";s:3:\"2.8\";s:9:\"minileven\";s:3:\"1.8\";s:7:\"monitor\";s:3:\"2.6\";s:5:\"notes\";s:3:\"1.9\";s:10:\"omnisearch\";s:3:\"2.3\";s:6:\"photon\";s:3:\"2.0\";s:13:\"post-by-email\";s:3:\"2.0\";s:7:\"protect\";s:3:\"3.4\";s:9:\"publicize\";s:3:\"2.0\";s:13:\"related-posts\";s:3:\"2.9\";s:9:\"seo-tools\";s:3:\"4.4\";s:10:\"sharedaddy\";s:3:\"1.1\";s:10:\"shortcodes\";s:3:\"1.1\";s:10:\"shortlinks\";s:3:\"1.1\";s:8:\"sitemaps\";s:3:\"3.9\";s:3:\"sso\";s:3:\"2.6\";s:5:\"stats\";s:3:\"1.1\";s:13:\"subscriptions\";s:3:\"1.2\";s:13:\"tiled-gallery\";s:3:\"2.1\";s:10:\"vaultpress\";s:5:\"0:1.2\";s:18:\"verification-tools\";s:3:\"3.0\";s:10:\"videopress\";s:3:\"2.5\";s:17:\"widget-visibility\";s:3:\"2.4\";s:7:\"widgets\";s:3:\"1.2\";s:7:\"wordads\";s:5:\"4.5.0\";}}", "yes");
INSERT INTO wpax_options VALUES("711", "jetpack_options", "a:10:{s:7:\"version\";s:14:\"4.5:1484685535\";s:11:\"old_version\";s:16:\"4.4.2:1482363309\";s:28:\"fallback_no_verify_ssl_certs\";i:0;s:9:\"time_diff\";i:0;s:2:\"id\";i:121564914;s:6:\"public\";i:1;s:9:\"jumpstart\";s:19:\"jumpstart_activated\";s:11:\"master_user\";i:1;s:14:\"last_heartbeat\";i:1484609917;s:24:\"custom_css_4.7_migration\";b:1;}", "yes");
INSERT INTO wpax_options VALUES("713", "do_activate", "0", "yes");
INSERT INTO wpax_options VALUES("716", "_transient_timeout_jetpack_https_test_message", "1484696317", "no");
INSERT INTO wpax_options VALUES("717", "_transient_jetpack_https_test_message", "", "no");
INSERT INTO wpax_options VALUES("718", "sharing-options", "a:1:{s:6:\"global\";a:5:{s:12:\"button_style\";s:4:\"icon\";s:13:\"sharing_label\";s:11:\"Share this:\";s:10:\"open_links\";s:4:\"same\";s:4:\"show\";a:1:{i:0;s:4:\"post\";}s:6:\"custom\";a:0:{}}}", "yes");
INSERT INTO wpax_options VALUES("719", "stats_options", "a:7:{s:9:\"admin_bar\";b:1;s:5:\"roles\";a:1:{i:0;s:13:\"administrator\";}s:11:\"count_roles\";a:0:{}s:7:\"blog_id\";b:0;s:12:\"do_not_track\";b:1;s:10:\"hide_smile\";b:1;s:7:\"version\";s:1:\"9\";}", "yes");
INSERT INTO wpax_options VALUES("720", "jetpack_log", "a:11:{i:0;a:4:{s:4:\"time\";i:1482363369;s:7:\"user_id\";i:1;s:7:\"blog_id\";b:0;s:4:\"code\";s:8:\"register\";}i:1;a:5:{s:4:\"time\";i:1482363492;s:7:\"user_id\";i:1;s:7:\"blog_id\";i:121564914;s:4:\"code\";s:24:\"custom_css_4.7_migration\";s:4:\"data\";s:5:\"start\";}i:2;a:5:{s:4:\"time\";i:1482363506;s:7:\"user_id\";i:1;s:7:\"blog_id\";i:121564914;s:4:\"code\";s:8:\"activate\";s:4:\"data\";s:8:\"carousel\";}i:3;a:5:{s:4:\"time\";i:1482363506;s:7:\"user_id\";i:1;s:7:\"blog_id\";i:121564914;s:4:\"code\";s:8:\"activate\";s:4:\"data\";s:12:\"contact-form\";}i:4;a:5:{s:4:\"time\";i:1482363506;s:7:\"user_id\";i:1;s:7:\"blog_id\";i:121564914;s:4:\"code\";s:8:\"activate\";s:4:\"data\";s:19:\"gravatar-hovercards\";}i:5;a:5:{s:4:\"time\";i:1482363506;s:7:\"user_id\";i:1;s:7:\"blog_id\";i:121564914;s:4:\"code\";s:8:\"activate\";s:4:\"data\";s:6:\"photon\";}i:6;a:5:{s:4:\"time\";i:1482363506;s:7:\"user_id\";i:1;s:7:\"blog_id\";i:121564914;s:4:\"code\";s:8:\"activate\";s:4:\"data\";s:13:\"related-posts\";}i:7;a:5:{s:4:\"time\";i:1482363506;s:7:\"user_id\";i:1;s:7:\"blog_id\";i:121564914;s:4:\"code\";s:8:\"activate\";s:4:\"data\";s:9:\"seo-tools\";}i:8;a:5:{s:4:\"time\";i:1482363506;s:7:\"user_id\";i:1;s:7:\"blog_id\";i:121564914;s:4:\"code\";s:8:\"activate\";s:4:\"data\";s:10:\"sharedaddy\";}i:9;a:5:{s:4:\"time\";i:1482363506;s:7:\"user_id\";i:1;s:7:\"blog_id\";i:121564914;s:4:\"code\";s:8:\"activate\";s:4:\"data\";s:3:\"sso\";}i:10;a:5:{s:4:\"time\";i:1482363506;s:7:\"user_id\";i:1;s:7:\"blog_id\";i:121564914;s:4:\"code\";s:8:\"activate\";s:4:\"data\";s:13:\"subscriptions\";}}", "no");
INSERT INTO wpax_options VALUES("721", "jetpack_private_options", "a:4:{s:8:\"register\";s:78:\"T1yf2SJDLWm5y8Wl14dObyrE5W20ln9A:1yqkhkEGqHJyKtkP3atvm8kkbhL4tL56:1482363969:1\";s:10:\"blog_token\";s:65:\"VbvT8sx%c9R^4MLgivoI&7fbKtaDsLFk.xSTRdklhTo@zy0EJU%5Pp$Rn&!9KJV%n\";s:11:\"user_tokens\";a:1:{i:1;s:67:\"KYJ^9csK4Z0w$(0&Msu)CSu1@KxKMqwd.4VgEpInofvuW43sneVorz3UWBKy3REt*.1\";}s:9:\"authorize\";s:78:\"es6VoLF0zrb0i7nxPj3mfmrdG53fjDaF:TNioOwg8RvQRYL7L6HXKdUegc8bukwoh:1482364102:1\";}", "yes");
INSERT INTO wpax_options VALUES("722", "jetpack_unique_connection", "a:3:{s:9:\"connected\";i:1;s:12:\"disconnected\";i:0;s:7:\"version\";s:5:\"3.6.1\";}", "yes");
INSERT INTO wpax_options VALUES("723", "jetpack_active_modules", "a:29:{i:0;s:18:\"after-the-deadline\";i:1;s:12:\"contact-form\";i:2;s:20:\"custom-content-types\";i:3;s:10:\"custom-css\";i:4;s:21:\"enhanced-distribution\";i:5;s:19:\"gravatar-hovercards\";i:6;s:8:\"json-api\";i:7;s:5:\"latex\";i:8;s:6:\"manage\";i:9;s:5:\"notes\";i:10;s:10:\"omnisearch\";i:11;s:13:\"post-by-email\";i:12;s:9:\"publicize\";i:13;s:10:\"sharedaddy\";i:14;s:10:\"shortcodes\";i:15;s:10:\"shortlinks\";i:16;s:8:\"sitemaps\";i:17;s:5:\"stats\";i:18;s:13:\"subscriptions\";i:20;s:18:\"verification-tools\";i:21;s:17:\"widget-visibility\";i:22;s:7:\"widgets\";i:23;s:8:\"carousel\";i:24;s:6:\"photon\";i:25;s:13:\"related-posts\";i:26;s:9:\"seo-tools\";i:27;s:3:\"sso\";i:29;s:7:\"protect\";i:30;s:7:\"monitor\";}", "yes");
INSERT INTO wpax_options VALUES("724", "widget_blog_subscription", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO wpax_options VALUES("725", "widget_facebook-likebox", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO wpax_options VALUES("726", "widget_wpcom-goodreads", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO wpax_options VALUES("727", "widget_google_translate_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO wpax_options VALUES("728", "widget_googleplus-badge", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO wpax_options VALUES("729", "widget_grofile", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO wpax_options VALUES("730", "widget_image", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO wpax_options VALUES("731", "widget_jetpack_my_community", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO wpax_options VALUES("732", "widget_rss_links", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO wpax_options VALUES("733", "widget_wpcom_social_media_icons_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO wpax_options VALUES("734", "widget_twitter_timeline", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO wpax_options VALUES("735", "widget_jetpack_display_posts_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO wpax_options VALUES("737", "jetpack_portfolio", "0", "yes");
INSERT INTO wpax_options VALUES("738", "sharedaddy_disable_resources", "0", "yes");
INSERT INTO wpax_options VALUES("739", "jetpack_testimonial", "1", "yes");
INSERT INTO wpax_options VALUES("740", "jetpack_sync_settings_sync_via_cron", "1", "yes");
INSERT INTO wpax_options VALUES("741", "jetpack_sync_settings_max_queue_size", "1000", "yes");
INSERT INTO wpax_options VALUES("742", "jetpack_sync_settings_max_queue_lag", "900", "yes");
INSERT INTO wpax_options VALUES("743", "jetpack_sync_settings_dequeue_max_bytes", "500000", "yes");
INSERT INTO wpax_options VALUES("744", "jetpack_sync_settings_upload_max_bytes", "600000", "yes");
INSERT INTO wpax_options VALUES("745", "jetpack_sync_settings_upload_max_rows", "500", "yes");
INSERT INTO wpax_options VALUES("746", "jetpack_sync_settings_sync_wait_time", "10", "yes");
INSERT INTO wpax_options VALUES("747", "jetpack_sync_settings_sync_wait_threshold", "5", "yes");
INSERT INTO wpax_options VALUES("748", "jetpack_sync_settings_enqueue_wait_time", "10", "yes");
INSERT INTO wpax_options VALUES("749", "jetpack_sync_settings_queue_max_writes_sec", "100", "yes");
INSERT INTO wpax_options VALUES("750", "jetpack_sync_settings_post_types_blacklist", "a:0:{}", "yes");
INSERT INTO wpax_options VALUES("751", "jetpack_sync_settings_render_filtered_content", "0", "yes");
INSERT INTO wpax_options VALUES("752", "jetpack_sync_settings_post_meta_whitelist", "a:0:{}", "yes");
INSERT INTO wpax_options VALUES("753", "jetpack_sync_settings_comment_meta_whitelist", "a:0:{}", "yes");
INSERT INTO wpax_options VALUES("754", "jetpack_sync_settings_max_enqueue_full_sync", "100", "yes");
INSERT INTO wpax_options VALUES("755", "jetpack_sync_settings_max_queue_size_full_sync", "1000", "yes");
INSERT INTO wpax_options VALUES("767", "jetpack_constants_sync_checksum", "a:16:{s:16:\"EMPTY_TRASH_DAYS\";i:2473281379;s:17:\"WP_POST_REVISIONS\";i:4261170317;s:26:\"AUTOMATIC_UPDATER_DISABLED\";i:634125391;s:7:\"ABSPATH\";i:1606362220;s:14:\"WP_CONTENT_DIR\";i:1823292420;s:9:\"FS_METHOD\";i:634125391;s:18:\"DISALLOW_FILE_EDIT\";i:634125391;s:18:\"DISALLOW_FILE_MODS\";i:634125391;s:19:\"WP_AUTO_UPDATE_CORE\";i:634125391;s:22:\"WP_HTTP_BLOCK_EXTERNAL\";i:634125391;s:19:\"WP_ACCESSIBLE_HOSTS\";i:634125391;s:16:\"JETPACK__VERSION\";i:1373516444;s:12:\"IS_PRESSABLE\";i:634125391;s:15:\"DISABLE_WP_CRON\";i:634125391;s:17:\"ALTERNATE_WP_CRON\";i:634125391;s:20:\"WP_CRON_LOCK_TIMEOUT\";i:3994858278;}", "yes");
INSERT INTO wpax_options VALUES("768", "jpsq_sync_checkout", "0:0", "no");
INSERT INTO wpax_options VALUES("769", "jetpack_next_sync_time_full-sync-enqueue", "1484685542", "yes");
INSERT INTO wpax_options VALUES("771", "jetpack_active_plan", "a:6:{s:10:\"product_id\";i:2002;s:12:\"product_slug\";s:12:\"jetpack_free\";s:18:\"product_name_short\";s:4:\"Free\";s:10:\"free_trial\";b:0;s:7:\"expired\";b:0;s:13:\"user_is_owner\";b:0;}", "yes");
INSERT INTO wpax_options VALUES("776", "post_by_email_address1", "NULL", "yes");
INSERT INTO wpax_options VALUES("777", "monitor_receive_notifications", "1", "yes");
INSERT INTO wpax_options VALUES("779", "_transient_timeout_jetpack_connected_user_data_1", "1482449894", "no");
INSERT INTO wpax_options VALUES("780", "_transient_jetpack_connected_user_data_1", "a:5:{s:2:\"ID\";i:114690915;s:5:\"login\";s:7:\"gramgro\";s:5:\"email\";s:20:\"gramgropro@gmail.com\";s:10:\"site_count\";i:1;s:15:\"jetpack_connect\";s:0:\"\";}", "no");
INSERT INTO wpax_options VALUES("783", "jetpack_sync_https_history_main_network_site_url", "a:5:{i:0;s:4:\"http\";i:1;s:4:\"http\";i:2;s:4:\"http\";i:3;s:4:\"http\";i:4;s:4:\"http\";}", "yes");
INSERT INTO wpax_options VALUES("784", "jetpack_sync_https_history_site_url", "a:5:{i:0;s:4:\"http\";i:1;s:4:\"http\";i:2;s:4:\"http\";i:3;s:4:\"http\";i:4;s:4:\"http\";}", "yes");
INSERT INTO wpax_options VALUES("785", "jetpack_sync_https_history_home_url", "a:5:{i:0;s:4:\"http\";i:1;s:4:\"http\";i:2;s:4:\"http\";i:3;s:4:\"http\";i:4;s:4:\"http\";}", "yes");
INSERT INTO wpax_options VALUES("814", "jetpack_callables_sync_checksum", "a:26:{s:18:\"wp_max_upload_size\";i:869269328;s:15:\"is_main_network\";i:734881840;s:13:\"is_multi_site\";i:734881840;s:17:\"main_network_site\";i:2431186620;s:8:\"site_url\";i:2431186620;s:8:\"home_url\";i:2431186620;s:16:\"single_user_site\";i:734881840;s:7:\"updates\";i:1883083510;s:28:\"has_file_system_write_access\";i:4261170317;s:21:\"is_version_controlled\";i:734881840;s:10:\"taxonomies\";i:1129921981;s:10:\"post_types\";i:25607944;s:18:\"post_type_features\";i:19285604;s:27:\"rest_api_allowed_post_types\";i:2508398024;s:32:\"rest_api_allowed_public_metadata\";i:223132457;s:24:\"sso_is_two_step_required\";i:734881840;s:26:\"sso_should_hide_login_form\";i:734881840;s:18:\"sso_match_by_email\";i:4261170317;s:21:\"sso_new_user_override\";i:734881840;s:29:\"sso_bypass_default_login_form\";i:734881840;s:10:\"wp_version\";i:1749470897;s:11:\"get_plugins\";i:256385311;s:14:\"active_modules\";i:2518029490;s:16:\"hosting_provider\";i:769900095;s:6:\"locale\";i:110763218;s:13:\"site_icon_url\";i:8847293;}", "yes");
INSERT INTO wpax_options VALUES("815", "jetpack_restapi_stats_cache", "a:1:{s:32:\"cf7029c89c22f0d8ac97862d40e040e5\";a:1:{i:1482364253;O:8:\"stdClass\":3:{s:4:\"date\";s:10:\"2016-12-21\";s:5:\"stats\";O:8:\"stdClass\":22:{s:14:\"visitors_today\";i:1;s:18:\"visitors_yesterday\";i:0;s:8:\"visitors\";i:0;s:11:\"views_today\";i:6;s:15:\"views_yesterday\";i:0;s:14:\"views_best_day\";s:10:\"2016-12-21\";s:20:\"views_best_day_total\";i:6;s:5:\"views\";i:0;s:8:\"comments\";i:1;s:5:\"posts\";i:1;s:14:\"followers_blog\";i:0;s:18:\"followers_comments\";i:0;s:18:\"comments_per_month\";i:0;s:31:\"comments_most_active_recent_day\";s:19:\"2016-12-15 00:39:41\";s:25:\"comments_most_active_time\";s:5:\"00:00\";s:13:\"comments_spam\";i:0;s:10:\"categories\";i:1;s:4:\"tags\";i:0;s:6:\"shares\";i:0;s:14:\"shares_twitter\";i:0;s:20:\"shares_google-plus-1\";i:0;s:15:\"shares_facebook\";i:0;}s:6:\"visits\";O:8:\"stdClass\":3:{s:4:\"unit\";s:3:\"day\";s:6:\"fields\";a:3:{i:0;s:6:\"period\";i:1;s:5:\"views\";i:2;s:8:\"visitors\";}s:4:\"data\";a:1:{i:0;a:3:{i:0;s:10:\"2016-12-21\";i:1;i:6;i:2;i:1;}}}}}}", "no");
INSERT INTO wpax_options VALUES("830", "sharing-services", "a:2:{s:7:\"visible\";a:3:{i:0;s:7:\"twitter\";i:1;s:8:\"facebook\";i:2;s:13:\"google-plus-1\";}s:6:\"hidden\";a:0:{}}", "yes");
INSERT INTO wpax_options VALUES("836", "jetpack_sync_full_config", "a:9:{s:9:\"constants\";b:1;s:9:\"functions\";b:1;s:7:\"options\";b:1;s:5:\"terms\";b:1;s:6:\"themes\";b:1;s:5:\"users\";b:1;s:5:\"posts\";b:1;s:8:\"comments\";b:1;s:7:\"updates\";b:1;}", "no");
INSERT INTO wpax_options VALUES("837", "jetpack_sync_full_enqueue_status", "a:16:{s:9:\"constants\";a:3:{i:0;i:1;i:1;i:1;i:2;b:1;}s:9:\"functions\";a:3:{i:0;i:1;i:1;i:1;i:2;b:1;}s:7:\"options\";a:3:{i:0;i:1;i:1;i:1;i:2;b:1;}s:15:\"network_options\";b:0;s:5:\"terms\";a:3:{i:0;i:3;i:1;i:3;i:2;b:1;}s:6:\"themes\";a:3:{i:0;i:1;i:1;i:1;i:2;b:1;}s:5:\"users\";a:3:{i:0;i:1;i:1;i:1;i:2;b:1;}s:5:\"posts\";a:3:{i:0;i:14;i:1;i:14;i:2;b:1;}s:8:\"comments\";a:3:{i:0;i:1;i:1;i:1;i:2;b:1;}s:7:\"updates\";a:3:{i:0;i:1;i:1;i:1;i:2;b:1;}s:11:\"attachments\";b:0;s:4:\"meta\";b:0;s:7:\"plugins\";b:0;s:7:\"protect\";b:0;s:9:\"full-sync\";b:0;s:5:\"stats\";b:0;}", "no");
INSERT INTO wpax_options VALUES("867", "jpsq_full_sync_checkout", "0:0", "no");
INSERT INTO wpax_options VALUES("868", "jetpack_next_sync_time_full_sync", "1482364123", "yes");
INSERT INTO wpax_options VALUES("900", "wp_mobile_app_promos", "0", "yes");
INSERT INTO wpax_options VALUES("904", "wp_mobile_disable", "0", "yes");
INSERT INTO wpax_options VALUES("959", "gravatar_disable_hovercards", "0", "yes");
INSERT INTO wpax_options VALUES("961", "verification_services_codes", "0", "yes");
INSERT INTO wpax_options VALUES("963", "open_graph_protocol_site_type", "", "yes");
INSERT INTO wpax_options VALUES("964", "facebook_admins", "a:0:{}", "yes");
INSERT INTO wpax_options VALUES("965", "jetpack-twitter-cards-site-tag", "", "yes");
INSERT INTO wpax_options VALUES("998", "jetpack_protect_key", "d5d75ce520265f8a1a2dda721d85c45bb0155fc9", "no");
INSERT INTO wpax_options VALUES("1045", "theme_mods_pub/minileven", "a:1:{s:18:\"custom_css_post_id\";i:-1;}", "yes");
INSERT INTO wpax_options VALUES("1055", "trusted_ip_header", "O:8:\"stdClass\":3:{s:14:\"trusted_header\";s:11:\"REMOTE_ADDR\";s:8:\"segments\";i:1;s:7:\"reverse\";b:0;}", "no");
INSERT INTO wpax_options VALUES("1106", "_transient_timeout_jetpack_sync_last_checked_queue_state_full_sync", "1482364352", "no");
INSERT INTO wpax_options VALUES("1107", "_transient_jetpack_sync_last_checked_queue_state_full_sync", "a:2:{i:0;i:0;i:1;i:0;}", "no");
INSERT INTO wpax_options VALUES("1198", "jetpack_sync_full__started", "1482364276", "no");
INSERT INTO wpax_options VALUES("1199", "jetpack_sync_full__params", "", "no");
INSERT INTO wpax_options VALUES("1226", "jetpack_sync_full__queue_finished", "1482364276", "yes");
INSERT INTO wpax_options VALUES("1228", "jetpack_sync_full__send_started", "1482364280", "no");
INSERT INTO wpax_options VALUES("1229", "jetpack_sync_full__constants_sent", "1", "no");
INSERT INTO wpax_options VALUES("1230", "jetpack_sync_full__functions_sent", "1", "no");
INSERT INTO wpax_options VALUES("1231", "jetpack_sync_full__options_sent", "1", "no");
INSERT INTO wpax_options VALUES("1232", "jetpack_sync_full__terms_sent", "3", "no");
INSERT INTO wpax_options VALUES("1233", "jetpack_sync_full__themes_sent", "1", "no");
INSERT INTO wpax_options VALUES("1234", "jetpack_sync_full__users_sent", "1", "no");
INSERT INTO wpax_options VALUES("1235", "jetpack_sync_full__posts_sent", "14", "no");
INSERT INTO wpax_options VALUES("1236", "jetpack_sync_full__comments_sent", "1", "no");
INSERT INTO wpax_options VALUES("1237", "jetpack_sync_full__updates_sent", "1", "no");
INSERT INTO wpax_options VALUES("1238", "jetpack_sync_full__finished", "1482364280", "no");
INSERT INTO wpax_options VALUES("1261", "widget_widget_contact_info", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO wpax_options VALUES("1262", "widget_top-posts", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO wpax_options VALUES("1279", "stats_cache", "a:2:{s:32:\"b65f289bc2230366483db5d3c5bfc337\";a:1:{i:1484685437;a:2:{i:0;a:4:{s:7:\"post_id\";s:3:\"279\";s:10:\"post_title\";s:20:\"Connect Your Account\";s:14:\"post_permalink\";s:27:\"http://gramgro.com/connect/\";s:5:\"views\";s:1:\"3\";}i:1;a:4:{s:7:\"post_id\";s:3:\"146\";s:10:\"post_title\";s:10:\"Front Page\";s:14:\"post_permalink\";s:19:\"http://gramgro.com/\";s:5:\"views\";s:1:\"1\";}}}s:32:\"289e978cba3521ab30f5107b87029a6c\";a:1:{i:1484685437;a:0:{}}}", "yes");
INSERT INTO wpax_options VALUES("2461", "EWD_UFAQ_Toggle", "Yes", "yes");
INSERT INTO wpax_options VALUES("2462", "EWD_UFAQ_Display_Back_To_Top", "No", "yes");
INSERT INTO wpax_options VALUES("2463", "EWD_UFAQ_Comments_On", "No", "yes");
INSERT INTO wpax_options VALUES("2464", "EWD_UFAQ_Display_Style", "Default", "yes");
INSERT INTO wpax_options VALUES("2465", "EWD_UFAQ_FAQ_Ratings", "No", "yes");
INSERT INTO wpax_options VALUES("2466", "EWD_UFAQ_WooCommerce_FAQs", "No", "yes");
INSERT INTO wpax_options VALUES("2467", "EWD_UFAQ_Use_Product", "Yes", "yes");
INSERT INTO wpax_options VALUES("2468", "EWD_UFAQ_Color_Block_Shape", "Square", "yes");
INSERT INTO wpax_options VALUES("2469", "FAQ_Auto_Complete_Titles", "Yes", "yes");
INSERT INTO wpax_options VALUES("2470", "EWD_UFAQ_Permalink_Type", "SamePage", "yes");
INSERT INTO wpax_options VALUES("2471", "EWD_UFAQ_Slug_Base", "ufaqs", "yes");
INSERT INTO wpax_options VALUES("2472", "EWD_UFAQ_Hide_Blank_Fields", "Yes", "yes");
INSERT INTO wpax_options VALUES("2473", "EWD_UFAQ_Styling_Category_Heading_Type", "h4", "yes");
INSERT INTO wpax_options VALUES("2474", "EWD_UFAQ_Styling_FAQ_Heading_Type", "h4", "yes");
INSERT INTO wpax_options VALUES("2475", "EWD_UFAQ_Version", "1.5.11", "yes");
INSERT INTO wpax_options VALUES("2476", "EWD_UFAQ_Category_Toggle", "No", "yes");
INSERT INTO wpax_options VALUES("2477", "EWD_UFAQ_Expand_Collapse_All", "No", "yes");
INSERT INTO wpax_options VALUES("2478", "EWD_UFAQ_FAQ_Accordion", "No", "yes");
INSERT INTO wpax_options VALUES("2479", "EWD_UFAQ_Hide_Categories", "No", "yes");
INSERT INTO wpax_options VALUES("2480", "EWD_UFAQ_Hide_Tags", "No", "yes");
INSERT INTO wpax_options VALUES("2481", "EWD_UFAQ_Scroll_To_Top", "Yes", "yes");
INSERT INTO wpax_options VALUES("2482", "EWD_UFAQ_Display_All_Answers", "No", "yes");
INSERT INTO wpax_options VALUES("2483", "EWD_UFAQ_Display_Author", "Yes", "yes");
INSERT INTO wpax_options VALUES("2484", "EWD_UFAQ_Display_Date", "Yes", "yes");
INSERT INTO wpax_options VALUES("2485", "EWD_UFAQ_Include_Permalink", "Yes", "yes");
INSERT INTO wpax_options VALUES("2486", "EWD_UFAQ_Show_TinyMCE", "Yes", "yes");
INSERT INTO wpax_options VALUES("2487", "EWD_UFAQ_Reveal_Effect", "none", "yes");
INSERT INTO wpax_options VALUES("2488", "EWD_UFAQ_Pretty_Permalinks", "No", "yes");
INSERT INTO wpax_options VALUES("2489", "EWD_UFAQ_Allow_Proposed_Answer", "No", "yes");
INSERT INTO wpax_options VALUES("2490", "EWD_UFAQ_Admin_Question_Notification", "No", "yes");
INSERT INTO wpax_options VALUES("2491", "EWD_UFAQ_Auto_Complete_Titles", "Yes", "yes");
INSERT INTO wpax_options VALUES("2492", "EWD_UFAQ_Group_By_Category", "No", "yes");
INSERT INTO wpax_options VALUES("2493", "EWD_UFAQ_Group_By_Order_By", "name", "yes");
INSERT INTO wpax_options VALUES("2494", "EWD_UFAQ_Group_By_Order", "ASC", "yes");
INSERT INTO wpax_options VALUES("2495", "EWD_UFAQ_Order_By", "date", "yes");
INSERT INTO wpax_options VALUES("2496", "EWD_UFAQ_Order", "DESC", "yes");
INSERT INTO wpax_options VALUES("2497", "EWD_UFAQ_Toggle_Symbol", "A", "yes");
INSERT INTO wpax_options VALUES("2498", "EWD_UFAQ_Full_Version", "No", "yes");
INSERT INTO wpax_options VALUES("2499", "EWD_UFAQ_Update_Flag", "Yes", "yes");
INSERT INTO wpax_options VALUES("2500", "EWD_UFAQ_Install_Flag", "Yes", "yes");
INSERT INTO wpax_options VALUES("2501", "UFAQ_Run_Tutorial", "Yes", "yes");
INSERT INTO wpax_options VALUES("2504", "plugin_error", "", "yes");
INSERT INTO wpax_options VALUES("2505", "widget_ewd_ufaq_display_faq_post_list", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO wpax_options VALUES("2506", "widget_ewd_ufaq_display_recent_faqs", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO wpax_options VALUES("2507", "widget_ewd_ufaq_display_popular_faqs", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO wpax_options VALUES("2508", "widget_ewd_ufaq_display_faq_categories", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO wpax_options VALUES("2521", "EWD_UFAQ_Hide_Dash_Review_Ask", "No", "yes");
INSERT INTO wpax_options VALUES("2522", "EWD_UFAQ_Blog_Content", "<a target=\'_blank\' href=\'http://www.etoilewebdesign.com/completely-customizable-lightbox/\'><h3>NEW COMPLETELY CUSTOMIZABLE LIGHTBOX</h3></a>\r\n<p>Product Catalog now has a new customizable lightbox, using the <a href=\'https://wordpress.org/plugins/ultimate-lightbox/\'>Ultimate Lightbox</a> plugin.</p>", "yes");
INSERT INTO wpax_options VALUES("2523", "EWD_UFAQ_Changelog_Content", "\r\n<h3>1.5.12</h3>\r\n<br />- Introducing a free new premium 7-day trial feature, which users can choose to test out before buying the premium version\r\n\r\n<h3>1.5.11</h3>\r\n<br />- Added an \"Expand/Collapse All\" optional set of controls\r\n<br />- Added in a \"Retrieving Results\" label for the search shortcode\r\n<br />- Added a \"Link\" custom field type\r\n<br />- Added in helper text when you\'re editing a category, to show the shortcode required to display only the selected category of FAQs\r\n<br />- Fixed a problem with sharing an FAQ on Facebook\r\n\r\n", "yes");
INSERT INTO wpax_options VALUES("2596", "faq_default_Settings", "s:649:\"a:20:{s:13:\"acc_sec_title\";s:3:\"yes\";s:10:\"op_cl_icon\";s:1:\"1\";s:14:\"acc_title_icon\";s:2:\"no\";s:10:\"acc_radius\";s:3:\"yes\";s:10:\"acc_margin\";s:3:\"yes\";s:13:\"enable_toggle\";s:2:\"no\";s:16:\"enable_ac_border\";s:3:\"yes\";s:15:\"acc_op_cl_align\";s:4:\"left\";s:16:\"acc_title_bg_clr\";s:7:\"#ffffff\";s:18:\"acc_title_icon_clr\";s:7:\"#000000\";s:23:\"acc_open_cl_icon_bg_clr\";s:7:\"#dd3333\";s:23:\"acc_open_cl_icon_ft_clr\";s:7:\"#ffffff\";s:15:\"acc_desc_bg_clr\";s:7:\"#ffffff\";s:17:\"acc_desc_font_clr\";s:7:\"#000000\";s:10:\"title_size\";s:2:\"18\";s:8:\"des_size\";s:2:\"16\";s:11:\"font_family\";s:9:\"Open Sans\";s:13:\"expand_option\";i:1;s:9:\"ac_styles\";i:1;s:10:\"custom_css\";s:0:\"\";}\";", "yes");
INSERT INTO wpax_options VALUES("2599", "widget_wpsm_faq_widget_is", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO wpax_options VALUES("2660", "jetpack_next_sync_time_sync", "1484527206", "yes");
INSERT INTO wpax_options VALUES("3382", "widget_powr_form_builder", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO wpax_options VALUES("3529", "powr_token", "bdcOLGKG7a1482456239", "yes");
INSERT INTO wpax_options VALUES("3613", "_transient_timeout_wpcom_subscribers_total", "1482461974", "no");
INSERT INTO wpax_options VALUES("3614", "_transient_wpcom_subscribers_total", "a:4:{s:6:\"status\";s:6:\"failed\";s:4:\"code\";i:-32300;s:7:\"message\";s:46:\"transport error - HTTP status code was not 200\";s:5:\"value\";i:0;}", "no");
INSERT INTO wpax_options VALUES("4797", "feedback_unread_count", "0", "yes");
INSERT INTO wpax_options VALUES("6458", "jetpack_protect_blocked_attempts", "9756", "no");
INSERT INTO wpax_options VALUES("18302", "_transient_timeout_wflginfl_00000000000000000000ffff5cf0d3ee", "1483912674", "no");
INSERT INTO wpax_options VALUES("18303", "_transient_wflginfl_00000000000000000000ffff5cf0d3ee", "1", "no");
INSERT INTO wpax_options VALUES("26631", "_transient_timeout_wflginfl_00000000000000000000ffff5b4d56b9", "1484165982", "no");
INSERT INTO wpax_options VALUES("26632", "_transient_wflginfl_00000000000000000000ffff5b4d56b9", "1", "no");
INSERT INTO wpax_options VALUES("26949", "_transient_timeout_wflginfl_00000000000000000000ffff2e9293d9", "1484172454", "no");
INSERT INTO wpax_options VALUES("26950", "_transient_wflginfl_00000000000000000000ffff2e9293d9", "1", "no");
INSERT INTO wpax_options VALUES("27304", "_site_transient_update_core", "O:8:\"stdClass\":4:{s:7:\"updates\";a:1:{i:0;O:8:\"stdClass\":10:{s:8:\"response\";s:6:\"latest\";s:8:\"download\";s:59:\"https://downloads.wordpress.org/release/wordpress-4.7.1.zip\";s:6:\"locale\";s:5:\"en_US\";s:8:\"packages\";O:8:\"stdClass\":5:{s:4:\"full\";s:59:\"https://downloads.wordpress.org/release/wordpress-4.7.1.zip\";s:10:\"no_content\";s:70:\"https://downloads.wordpress.org/release/wordpress-4.7.1-no-content.zip\";s:11:\"new_bundled\";s:71:\"https://downloads.wordpress.org/release/wordpress-4.7.1-new-bundled.zip\";s:7:\"partial\";b:0;s:8:\"rollback\";b:0;}s:7:\"current\";s:5:\"4.7.1\";s:7:\"version\";s:5:\"4.7.1\";s:11:\"php_version\";s:5:\"5.2.4\";s:13:\"mysql_version\";s:3:\"5.0\";s:11:\"new_bundled\";s:3:\"4.7\";s:15:\"partial_version\";s:0:\"\";}}s:12:\"last_checked\";i:1484685527;s:15:\"version_checked\";s:5:\"4.7.1\";s:12:\"translations\";a:0:{}}", "no");
INSERT INTO wpax_options VALUES("27309", "auto_core_update_notified", "a:4:{s:4:\"type\";s:7:\"success\";s:5:\"email\";s:20:\"gramgropro@gmail.com\";s:7:\"version\";s:5:\"4.7.1\";s:9:\"timestamp\";i:1484167697;}", "no");
INSERT INTO wpax_options VALUES("27878", "_transient_timeout_wflginfl_00000000000000000000ffff4df0a8ae", "1484203885", "no");
INSERT INTO wpax_options VALUES("27879", "_transient_wflginfl_00000000000000000000ffff4df0a8ae", "1", "no");
INSERT INTO wpax_options VALUES("31993", "_transient_timeout_wflginfl_00000000000000000000ffffc4352c05", "1484320010", "no");
INSERT INTO wpax_options VALUES("31994", "_transient_wflginfl_00000000000000000000ffffc4352c05", "1", "no");
INSERT INTO wpax_options VALUES("32457", "_transient_timeout_wflginfl_00000000000000000000ffff558c5c90", "1484328984", "no");
INSERT INTO wpax_options VALUES("32458", "_transient_wflginfl_00000000000000000000ffff558c5c90", "1", "no");
INSERT INTO wpax_options VALUES("33680", "_site_transient_timeout_browser_3724cf524ce46cd3376f6aebb4c04837", "1484950407", "no");
INSERT INTO wpax_options VALUES("33681", "_site_transient_browser_3724cf524ce46cd3376f6aebb4c04837", "a:9:{s:8:\"platform\";s:7:\"Windows\";s:4:\"name\";s:6:\"Chrome\";s:7:\"version\";s:12:\"55.0.2883.87\";s:10:\"update_url\";s:28:\"http://www.google.com/chrome\";s:7:\"img_src\";s:49:\"http://s.wordpress.org/images/browsers/chrome.png\";s:11:\"img_src_ssl\";s:48:\"https://wordpress.org/images/browsers/chrome.png\";s:15:\"current_version\";s:2:\"18\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;}", "no");
INSERT INTO wpax_options VALUES("33734", "_transient_is_multi_author", "0", "yes");
INSERT INTO wpax_options VALUES("34796", "_transient_timeout_wflginfl_00000000000000000000ffff4df4152e", "1484398304", "no");
INSERT INTO wpax_options VALUES("34797", "_transient_wflginfl_00000000000000000000ffff4df4152e", "1", "no");
INSERT INTO wpax_options VALUES("35636", "_transient_timeout_wflginfl_00000000000000000000ffffb2bbfbe0", "1484418217", "no");
INSERT INTO wpax_options VALUES("35637", "_transient_wflginfl_00000000000000000000ffffb2bbfbe0", "1", "no");
INSERT INTO wpax_options VALUES("41142", "_transient_timeout_wflginfl_00000000000000000000ffffb231987a", "1484589763", "no");
INSERT INTO wpax_options VALUES("41143", "_transient_wflginfl_00000000000000000000ffffb231987a", "2", "no");
INSERT INTO wpax_options VALUES("42577", "_transient_timeout_jpp_li_a88c322434d498238bd3f75dc87382dc", "1484607269", "no");
INSERT INTO wpax_options VALUES("42578", "_transient_jpp_li_a88c322434d498238bd3f75dc87382dc", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:45:\"This IP is currently blocked (109.106.142.48)\";s:17:\"seconds_remaining\";i:3492;s:16:\"blocked_attempts\";s:4:\"8439\";s:6:\"expire\";i:1484607269;}", "no");
INSERT INTO wpax_options VALUES("42605", "_transient_timeout_jpp_li_3f3dc7ce5dbc0121eb3196805faeac2d", "1484607096", "no");
INSERT INTO wpax_options VALUES("42606", "_transient_jpp_li_3f3dc7ce5dbc0121eb3196805faeac2d", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:43:\"This IP is currently blocked (188.0.167.85)\";s:17:\"seconds_remaining\";i:2728;s:16:\"blocked_attempts\";s:4:\"8449\";s:6:\"expire\";i:1484607096;}", "no");
INSERT INTO wpax_options VALUES("42661", "_transient_timeout_jpp_li_9869d5c1b0683604acc08840bed3db15", "1484609000", "no");
INSERT INTO wpax_options VALUES("42662", "_transient_jpp_li_9869d5c1b0683604acc08840bed3db15", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:45:\"This IP is currently blocked (37.115.191.239)\";s:17:\"seconds_remaining\";i:3428;s:16:\"blocked_attempts\";s:4:\"8473\";s:6:\"expire\";i:1484609000;}", "no");
INSERT INTO wpax_options VALUES("42682", "_transient_timeout_jpp_li_236531b020c42beff83872992016d89a", "1484608764", "no");
INSERT INTO wpax_options VALUES("42683", "_transient_jpp_li_236531b020c42beff83872992016d89a", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:44:\"This IP is currently blocked (5.137.208.234)\";s:17:\"seconds_remaining\";i:3046;s:16:\"blocked_attempts\";s:4:\"8482\";s:6:\"expire\";i:1484608764;}", "no");
INSERT INTO wpax_options VALUES("42688", "_transient_timeout_jpp_li_0b9c69f7eaf33155c50e934ebe6f7496", "1484609350", "no");
INSERT INTO wpax_options VALUES("42689", "_transient_jpp_li_0b9c69f7eaf33155c50e934ebe6f7496", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:45:\"This IP is currently blocked (93.181.241.104)\";s:17:\"seconds_remaining\";i:3556;s:16:\"blocked_attempts\";s:4:\"8485\";s:6:\"expire\";i:1484609350;}", "no");
INSERT INTO wpax_options VALUES("42697", "_transient_timeout_jpp_li_615cb8e6240d9bd7ef9425cb8a3ec2eb", "1484608510", "no");
INSERT INTO wpax_options VALUES("42698", "_transient_jpp_li_615cb8e6240d9bd7ef9425cb8a3ec2eb", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:43:\"This IP is currently blocked (86.62.123.82)\";s:17:\"seconds_remaining\";i:2542;s:16:\"blocked_attempts\";s:4:\"8488\";s:6:\"expire\";i:1484608510;}", "no");
INSERT INTO wpax_options VALUES("42717", "_transient_timeout_jpp_li_21eda6819539ac336874126eeac3c70c", "1484609829", "no");
INSERT INTO wpax_options VALUES("42718", "_transient_jpp_li_21eda6819539ac336874126eeac3c70c", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:45:\"This IP is currently blocked (37.230.208.108)\";s:17:\"seconds_remaining\";i:3454;s:16:\"blocked_attempts\";s:4:\"8491\";s:6:\"expire\";i:1484609829;}", "no");
INSERT INTO wpax_options VALUES("42736", "_transient_timeout_jpp_li_dd97aea5ae606fd56573fb602a74cb78", "1484610222", "no");
INSERT INTO wpax_options VALUES("42737", "_transient_jpp_li_dd97aea5ae606fd56573fb602a74cb78", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:43:\"This IP is currently blocked (92.244.224.6)\";s:17:\"seconds_remaining\";i:2929;s:16:\"blocked_attempts\";s:4:\"8497\";s:6:\"expire\";i:1484610222;}", "no");
INSERT INTO wpax_options VALUES("42742", "_transient_timeout_jpp_li_a70b580a99e726a69d05a954d9010a3f", "1484609222", "no");
INSERT INTO wpax_options VALUES("42743", "_transient_jpp_li_a70b580a99e726a69d05a954d9010a3f", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:44:\"This IP is currently blocked (109.229.17.29)\";s:17:\"seconds_remaining\";i:1848;s:16:\"blocked_attempts\";s:4:\"8500\";s:6:\"expire\";i:1484609222;}", "no");
INSERT INTO wpax_options VALUES("42754", "_transient_timeout_jpp_li_86ca4f2041224bc09bdea240bedd3bc8", "1484611220", "no");
INSERT INTO wpax_options VALUES("42755", "_transient_jpp_li_86ca4f2041224bc09bdea240bedd3bc8", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:43:\"This IP is currently blocked (94.79.32.243)\";s:17:\"seconds_remaining\";i:3482;s:16:\"blocked_attempts\";s:4:\"8503\";s:6:\"expire\";i:1484611220;}", "no");
INSERT INTO wpax_options VALUES("42776", "_transient_timeout_jpp_li_7d45a5335a35a01fa28eb651ad37e054", "1484611939", "no");
INSERT INTO wpax_options VALUES("42777", "_transient_jpp_li_7d45a5335a35a01fa28eb651ad37e054", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:44:\"This IP is currently blocked (188.17.80.141)\";s:17:\"seconds_remaining\";i:3541;s:16:\"blocked_attempts\";s:4:\"8510\";s:6:\"expire\";i:1484611939;}", "no");
INSERT INTO wpax_options VALUES("42778", "_transient_timeout_jpp_li_a58ab623b1c8bfee1c0aeb32e75d100d", "1484608816", "no");
INSERT INTO wpax_options VALUES("42779", "_transient_jpp_li_a58ab623b1c8bfee1c0aeb32e75d100d", "a:5:{s:6:\"status\";s:12:\"blocked-hard\";s:3:\"msg\";s:44:\"This IP is currently blocked (178.209.98.30)\";s:17:\"seconds_remaining\";i:351;s:16:\"blocked_attempts\";s:4:\"8511\";s:6:\"expire\";i:1484608816;}", "no");
INSERT INTO wpax_options VALUES("42788", "_transient_timeout_jpp_li_b120be9827b9bf52fd80f5efd70aaca6", "1484611761", "no");
INSERT INTO wpax_options VALUES("42789", "_transient_jpp_li_b120be9827b9bf52fd80f5efd70aaca6", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:45:\"This IP is currently blocked (92.240.211.238)\";s:17:\"seconds_remaining\";i:2806;s:16:\"blocked_attempts\";s:4:\"8514\";s:6:\"expire\";i:1484611761;}", "no");
INSERT INTO wpax_options VALUES("42805", "_transient_timeout_jpp_li_9d747d06e35440ba2860c2ba2903b8b9", "1484612775", "no");
INSERT INTO wpax_options VALUES("42806", "_transient_jpp_li_9d747d06e35440ba2860c2ba2903b8b9", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:44:\"This IP is currently blocked (79.126.99.226)\";s:17:\"seconds_remaining\";i:3394;s:16:\"blocked_attempts\";s:4:\"8520\";s:6:\"expire\";i:1484612775;}", "no");
INSERT INTO wpax_options VALUES("42817", "_transient_timeout_jetpack_https_test", "1484696317", "no");
INSERT INTO wpax_options VALUES("42818", "_transient_jetpack_https_test", "1", "no");
INSERT INTO wpax_options VALUES("42859", "_transient_timeout_jpp_li_2a6a45a1b3c83f3036296e81e098605b", "1484614712", "no");
INSERT INTO wpax_options VALUES("42860", "_transient_jpp_li_2a6a45a1b3c83f3036296e81e098605b", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:43:\"This IP is currently blocked (89.232.69.33)\";s:17:\"seconds_remaining\";i:3571;s:16:\"blocked_attempts\";s:4:\"8535\";s:6:\"expire\";i:1484614712;}", "no");
INSERT INTO wpax_options VALUES("42871", "_transient_timeout_jpp_li_68cbca19a9998745730eef62fa91139e", "1484614986", "no");
INSERT INTO wpax_options VALUES("42872", "_transient_jpp_li_68cbca19a9998745730eef62fa91139e", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:44:\"This IP is currently blocked (83.219.146.14)\";s:17:\"seconds_remaining\";i:3160;s:16:\"blocked_attempts\";s:4:\"8538\";s:6:\"expire\";i:1484614986;}", "no");
INSERT INTO wpax_options VALUES("42877", "_transient_timeout_jetpack_news_sitemap", "1484698693", "no");
INSERT INTO wpax_options VALUES("42878", "_transient_jetpack_news_sitemap", "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<?xml-stylesheet type=\"text/xsl\" href=\"http://gramgro.com/news-sitemap.xsl\"?>\n<!-- generator=\"jetpack-4.4.2\" -->\n	<!-- generator=\"jetpack\" -->\n	<urlset xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n	        xsi:schemaLocation=\"http://www.sitemaps.org/schemas/sitemap/0.9 http://www.sitemaps.org/schemas/sitemap/0.9/sitemap.xsd\"\n	        xmlns=\"http://www.sitemaps.org/schemas/sitemap/0.9\"\n	        xmlns:news=\"http://www.google.com/schemas/sitemap-news/0.9\"\n	        xmlns:image=\"http://www.google.com/schemas/sitemap-image/1.1\"\n		>\n			</urlset>\n	", "no");
INSERT INTO wpax_options VALUES("42896", "_transient_timeout_jpp_li_47a99cf165d393094b956b2454fdc2cd", "1484615922", "no");
INSERT INTO wpax_options VALUES("42897", "_transient_jpp_li_47a99cf165d393094b956b2454fdc2cd", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:44:\"This IP is currently blocked (31.163.97.106)\";s:17:\"seconds_remaining\";i:2769;s:16:\"blocked_attempts\";s:4:\"8544\";s:6:\"expire\";i:1484615922;}", "no");
INSERT INTO wpax_options VALUES("42904", "_transient_timeout_jpp_li_c6015a90902ca49f151360863428b1fb", "1484616823", "no");
INSERT INTO wpax_options VALUES("42905", "_transient_jpp_li_c6015a90902ca49f151360863428b1fb", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:43:\"This IP is currently blocked (93.177.17.65)\";s:17:\"seconds_remaining\";i:3546;s:16:\"blocked_attempts\";s:4:\"8547\";s:6:\"expire\";i:1484616823;}", "no");
INSERT INTO wpax_options VALUES("42913", "_transient_timeout_jpp_li_4cfffff4e57cc71bf11994ba0f56a64f", "1484616340", "no");
INSERT INTO wpax_options VALUES("42914", "_transient_jpp_li_4cfffff4e57cc71bf11994ba0f56a64f", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:45:\"This IP is currently blocked (83.217.217.198)\";s:17:\"seconds_remaining\";i:2784;s:16:\"blocked_attempts\";s:4:\"8550\";s:6:\"expire\";i:1484616340;}", "no");
INSERT INTO wpax_options VALUES("42995", "_transient_timeout_jpp_li_e56f53f2d0a861f2d0d1fe94431edf76", "1484619819", "no");
INSERT INTO wpax_options VALUES("42996", "_transient_jpp_li_e56f53f2d0a861f2d0d1fe94431edf76", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:44:\"This IP is currently blocked (180.254.4.171)\";s:17:\"seconds_remaining\";i:2537;s:16:\"blocked_attempts\";s:4:\"8565\";s:6:\"expire\";i:1484619819;}", "no");
INSERT INTO wpax_options VALUES("43010", "_transient_timeout_jpp_li_61b7df20d9c8ee36a1ac9de3de30afdc", "1484621018", "no");
INSERT INTO wpax_options VALUES("43011", "_transient_jpp_li_61b7df20d9c8ee36a1ac9de3de30afdc", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:45:\"This IP is currently blocked (188.162.228.18)\";s:17:\"seconds_remaining\";i:2979;s:16:\"blocked_attempts\";s:4:\"8568\";s:6:\"expire\";i:1484621018;}", "no");
INSERT INTO wpax_options VALUES("43019", "_transient_timeout_jpp_li_c1ae9f7a82bf06b72fe978d5d7afeaa5", "1484621673", "no");
INSERT INTO wpax_options VALUES("43020", "_transient_jpp_li_c1ae9f7a82bf06b72fe978d5d7afeaa5", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:43:\"This IP is currently blocked (5.143.86.230)\";s:17:\"seconds_remaining\";i:3242;s:16:\"blocked_attempts\";s:4:\"8571\";s:6:\"expire\";i:1484621673;}", "no");
INSERT INTO wpax_options VALUES("43064", "_transient_timeout_jpp_li_3c533e2e947b5dcb7b867036e30ee8e6", "1484623596", "no");
INSERT INTO wpax_options VALUES("43065", "_transient_jpp_li_3c533e2e947b5dcb7b867036e30ee8e6", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:43:\"This IP is currently blocked (91.200.160.4)\";s:17:\"seconds_remaining\";i:3468;s:16:\"blocked_attempts\";s:4:\"8581\";s:6:\"expire\";i:1484623596;}", "no");
INSERT INTO wpax_options VALUES("43082", "_transient_timeout_jpp_li_c1af140068572b982e1db356f91b22ac", "1484624112", "no");
INSERT INTO wpax_options VALUES("43083", "_transient_jpp_li_c1af140068572b982e1db356f91b22ac", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:45:\"This IP is currently blocked (109.195.183.85)\";s:17:\"seconds_remaining\";i:3324;s:16:\"blocked_attempts\";s:4:\"8588\";s:6:\"expire\";i:1484624112;}", "no");
INSERT INTO wpax_options VALUES("43091", "_transient_timeout_jpp_li_50f501c7053d6ef6d64ae71a63f76505", "1484624182", "no");
INSERT INTO wpax_options VALUES("43092", "_transient_jpp_li_50f501c7053d6ef6d64ae71a63f76505", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:42:\"This IP is currently blocked (93.81.46.73)\";s:17:\"seconds_remaining\";i:3083;s:16:\"blocked_attempts\";s:4:\"8591\";s:6:\"expire\";i:1484624182;}", "no");
INSERT INTO wpax_options VALUES("43113", "_transient_timeout_jpp_li_30f1c6553e6a571b095e044f06df4955", "1484624828", "no");
INSERT INTO wpax_options VALUES("43114", "_transient_jpp_li_30f1c6553e6a571b095e044f06df4955", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:44:\"This IP is currently blocked (83.146.116.16)\";s:17:\"seconds_remaining\";i:3221;s:16:\"blocked_attempts\";s:4:\"8600\";s:6:\"expire\";i:1484624828;}", "no");
INSERT INTO wpax_options VALUES("43137", "_transient_timeout_jpp_li_1975c942124e0e9c6fa1e8ad6408d3ef", "1484626222", "no");
INSERT INTO wpax_options VALUES("43138", "_transient_jpp_li_1975c942124e0e9c6fa1e8ad6408d3ef", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:43:\"This IP is currently blocked (95.29.55.171)\";s:17:\"seconds_remaining\";i:3374;s:16:\"blocked_attempts\";s:4:\"8606\";s:6:\"expire\";i:1484626222;}", "no");
INSERT INTO wpax_options VALUES("43155", "_transient_timeout_jpp_li_36df05bf92c8ee1fdd8d19ade47436e4", "1484627347", "no");
INSERT INTO wpax_options VALUES("43156", "_transient_jpp_li_36df05bf92c8ee1fdd8d19ade47436e4", "a:5:{s:6:\"status\";s:12:\"blocked-hard\";s:3:\"msg\";s:42:\"This IP is currently blocked (2.228.136.2)\";s:17:\"seconds_remaining\";i:3322;s:16:\"blocked_attempts\";s:4:\"8610\";s:6:\"expire\";i:1484627347;}", "no");
INSERT INTO wpax_options VALUES("43161", "_transient_timeout_jpp_li_57747eae98071d71e4212e4e15662678", "1484627692", "no");
INSERT INTO wpax_options VALUES("43162", "_transient_jpp_li_57747eae98071d71e4212e4e15662678", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:44:\"This IP is currently blocked (5.137.190.209)\";s:17:\"seconds_remaining\";i:3533;s:16:\"blocked_attempts\";s:4:\"8613\";s:6:\"expire\";i:1484627692;}", "no");
INSERT INTO wpax_options VALUES("43170", "_transient_timeout_jpp_li_0476b15916da58c54de840bfb6919e12", "1484627892", "no");
INSERT INTO wpax_options VALUES("43171", "_transient_jpp_li_0476b15916da58c54de840bfb6919e12", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:43:\"This IP is currently blocked (117.203.73.1)\";s:17:\"seconds_remaining\";i:3576;s:16:\"blocked_attempts\";s:4:\"8616\";s:6:\"expire\";i:1484627892;}", "no");
INSERT INTO wpax_options VALUES("43176", "_transient_timeout_jpp_li_33adad61bdd29efe0dbd2aa1117cd3b8", "1484624912", "no");
INSERT INTO wpax_options VALUES("43177", "_transient_jpp_li_33adad61bdd29efe0dbd2aa1117cd3b8", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:46:\"This IP is currently blocked (212.164.214.191)\";s:17:\"seconds_remaining\";i:556;s:16:\"blocked_attempts\";s:4:\"8619\";s:6:\"expire\";i:1484624912;}", "no");
INSERT INTO wpax_options VALUES("43185", "_transient_timeout_jpp_li_ac2b87c785d6f5e935d166602374a68f", "1484626856", "no");
INSERT INTO wpax_options VALUES("43186", "_transient_jpp_li_ac2b87c785d6f5e935d166602374a68f", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:45:\"This IP is currently blocked (178.120.98.150)\";s:17:\"seconds_remaining\";i:2144;s:16:\"blocked_attempts\";s:4:\"8622\";s:6:\"expire\";i:1484626856;}", "no");
INSERT INTO wpax_options VALUES("43219", "_transient_timeout_jpp_li_db041ce04a869eab2251420f52bfe0e2", "1484628095", "no");
INSERT INTO wpax_options VALUES("43220", "_transient_jpp_li_db041ce04a869eab2251420f52bfe0e2", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:44:\"This IP is currently blocked (109.162.93.14)\";s:17:\"seconds_remaining\";i:2186;s:16:\"blocked_attempts\";s:4:\"8633\";s:6:\"expire\";i:1484628095;}", "no");
INSERT INTO wpax_options VALUES("43234", "_transient_timeout_jpp_li_55bc88edbc445fe0c52d9953639f52d5", "1484627574", "no");
INSERT INTO wpax_options VALUES("43235", "_transient_jpp_li_55bc88edbc445fe0c52d9953639f52d5", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:45:\"This IP is currently blocked (80.246.253.186)\";s:17:\"seconds_remaining\";i:1410;s:16:\"blocked_attempts\";s:4:\"8640\";s:6:\"expire\";i:1484627574;}", "no");
INSERT INTO wpax_options VALUES("43246", "_transient_timeout_jpp_li_350cadc9444503fdbb5b835e01051a4c", "1484629224", "no");
INSERT INTO wpax_options VALUES("43247", "_transient_jpp_li_350cadc9444503fdbb5b835e01051a4c", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:45:\"This IP is currently blocked (212.119.216.18)\";s:17:\"seconds_remaining\";i:2595;s:16:\"blocked_attempts\";s:4:\"8643\";s:6:\"expire\";i:1484629224;}", "no");
INSERT INTO wpax_options VALUES("43257", "_transient_timeout_jpp_li_808cce00f36309c2f52a2927edfca827", "1484629862", "no");
INSERT INTO wpax_options VALUES("43258", "_transient_jpp_li_808cce00f36309c2f52a2927edfca827", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:45:\"This IP is currently blocked (178.207.98.183)\";s:17:\"seconds_remaining\";i:2862;s:16:\"blocked_attempts\";s:4:\"8646\";s:6:\"expire\";i:1484629862;}", "no");
INSERT INTO wpax_options VALUES("43280", "_transient_timeout_jpp_li_14064858107d0aa2c9f24e51b3f75e69", "1484630316", "no");
INSERT INTO wpax_options VALUES("43281", "_transient_jpp_li_14064858107d0aa2c9f24e51b3f75e69", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:44:\"This IP is currently blocked (195.144.209.3)\";s:17:\"seconds_remaining\";i:2491;s:16:\"blocked_attempts\";s:4:\"8655\";s:6:\"expire\";i:1484630316;}", "no");
INSERT INTO wpax_options VALUES("43288", "_transient_timeout_jpp_li_886449b197d8a0d800c84c5b0f45fabd", "1484631411", "no");
INSERT INTO wpax_options VALUES("43289", "_transient_jpp_li_886449b197d8a0d800c84c5b0f45fabd", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:44:\"This IP is currently blocked (5.227.135.126)\";s:17:\"seconds_remaining\";i:3500;s:16:\"blocked_attempts\";s:4:\"8658\";s:6:\"expire\";i:1484631411;}", "no");
INSERT INTO wpax_options VALUES("43297", "_transient_timeout_jpp_li_3f31c979caceace45e5cc0dbfee90208", "1484631700", "no");
INSERT INTO wpax_options VALUES("43298", "_transient_jpp_li_3f31c979caceace45e5cc0dbfee90208", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:44:\"This IP is currently blocked (85.175.46.210)\";s:17:\"seconds_remaining\";i:3492;s:16:\"blocked_attempts\";s:4:\"8662\";s:6:\"expire\";i:1484631700;}", "no");
INSERT INTO wpax_options VALUES("43330", "_transient_timeout_jpp_li_ad2dcbba4726eeca6d720f1e73796816", "1484632879", "no");
INSERT INTO wpax_options VALUES("43331", "_transient_jpp_li_ad2dcbba4726eeca6d720f1e73796816", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:43:\"This IP is currently blocked (77.35.230.10)\";s:17:\"seconds_remaining\";i:3107;s:16:\"blocked_attempts\";s:4:\"8671\";s:6:\"expire\";i:1484632879;}", "no");
INSERT INTO wpax_options VALUES("43336", "_transient_timeout_jpp_li_674a45353af93b3743181b1709e4b842", "1484632137", "no");
INSERT INTO wpax_options VALUES("43337", "_transient_jpp_li_674a45353af93b3743181b1709e4b842", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:43:\"This IP is currently blocked (79.175.31.13)\";s:17:\"seconds_remaining\";i:2307;s:16:\"blocked_attempts\";s:4:\"8674\";s:6:\"expire\";i:1484632137;}", "no");
INSERT INTO wpax_options VALUES("43343", "_transient_timeout_jpp_li_85a5098310cb015c9a6be79db2bb74aa", "1484631531", "no");
INSERT INTO wpax_options VALUES("43344", "_transient_jpp_li_85a5098310cb015c9a6be79db2bb74aa", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:44:\"This IP is currently blocked (85.95.191.186)\";s:17:\"seconds_remaining\";i:1611;s:16:\"blocked_attempts\";s:4:\"8677\";s:6:\"expire\";i:1484631531;}", "no");
INSERT INTO wpax_options VALUES("43349", "_transient_timeout_jpp_li_3b8c89e880788111822b31a8588e9538", "1484631378", "no");
INSERT INTO wpax_options VALUES("43350", "_transient_jpp_li_3b8c89e880788111822b31a8588e9538", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:42:\"This IP is currently blocked (81.30.48.66)\";s:17:\"seconds_remaining\";i:1405;s:16:\"blocked_attempts\";s:4:\"8680\";s:6:\"expire\";i:1484631378;}", "no");
INSERT INTO wpax_options VALUES("43366", "_transient_timeout_jpp_li_d9dc425881d5bebf980db610b78f0182", "1484632602", "no");
INSERT INTO wpax_options VALUES("43367", "_transient_jpp_li_d9dc425881d5bebf980db610b78f0182", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:44:\"This IP is currently blocked (85.140.225.88)\";s:17:\"seconds_remaining\";i:2207;s:16:\"blocked_attempts\";s:4:\"8686\";s:6:\"expire\";i:1484632602;}", "no");
INSERT INTO wpax_options VALUES("43374", "_transient_timeout_jpp_li_29432631fb43e16e3b735b30be97ec26", "1484633781", "no");
INSERT INTO wpax_options VALUES("43375", "_transient_jpp_li_29432631fb43e16e3b735b30be97ec26", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:45:\"This IP is currently blocked (213.135.139.24)\";s:17:\"seconds_remaining\";i:3330;s:16:\"blocked_attempts\";s:4:\"8689\";s:6:\"expire\";i:1484633781;}", "no");
INSERT INTO wpax_options VALUES("43381", "_transient_timeout_jpp_li_86d14d320c7e65e113e4beff0090a141", "1484633237", "no");
INSERT INTO wpax_options VALUES("43382", "_transient_jpp_li_86d14d320c7e65e113e4beff0090a141", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:43:\"This IP is currently blocked (31.28.113.97)\";s:17:\"seconds_remaining\";i:2634;s:16:\"blocked_attempts\";s:4:\"8692\";s:6:\"expire\";i:1484633237;}", "no");
INSERT INTO wpax_options VALUES("43387", "_transient_timeout_jpp_li_33e1ac132b79f8f0bd99b61484b397ef", "1484634240", "no");
INSERT INTO wpax_options VALUES("43388", "_transient_jpp_li_33e1ac132b79f8f0bd99b61484b397ef", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:43:\"This IP is currently blocked (90.188.6.161)\";s:17:\"seconds_remaining\";i:3496;s:16:\"blocked_attempts\";s:4:\"8695\";s:6:\"expire\";i:1484634240;}", "no");
INSERT INTO wpax_options VALUES("43396", "_transient_timeout_jpp_li_8627078f3a955627d5ee332e211cda26", "1484633880", "no");
INSERT INTO wpax_options VALUES("43397", "_transient_jpp_li_8627078f3a955627d5ee332e211cda26", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:44:\"This IP is currently blocked (85.31.176.215)\";s:17:\"seconds_remaining\";i:2889;s:16:\"blocked_attempts\";s:4:\"8698\";s:6:\"expire\";i:1484633880;}", "no");
INSERT INTO wpax_options VALUES("43401", "_transient_timeout_jpp_li_2c9c5db2c5a9a94dc2ee000d347f72a6", "1484631426", "no");
INSERT INTO wpax_options VALUES("43402", "_transient_jpp_li_2c9c5db2c5a9a94dc2ee000d347f72a6", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:43:\"This IP is currently blocked (85.140.77.90)\";s:17:\"seconds_remaining\";i:314;s:16:\"blocked_attempts\";s:4:\"8700\";s:6:\"expire\";i:1484631426;}", "no");
INSERT INTO wpax_options VALUES("43419", "_transient_timeout_jpp_li_d6f438e6b5846306401c8542505b9f68", "1484634894", "no");
INSERT INTO wpax_options VALUES("43420", "_transient_jpp_li_d6f438e6b5846306401c8542505b9f68", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:43:\"This IP is currently blocked (95.188.55.37)\";s:17:\"seconds_remaining\";i:3044;s:16:\"blocked_attempts\";s:4:\"8706\";s:6:\"expire\";i:1484634894;}", "no");
INSERT INTO wpax_options VALUES("43431", "_transient_timeout_jpp_li_cc80d2be93bbe046dbe58bfd682d52fd", "1484635379", "no");
INSERT INTO wpax_options VALUES("43432", "_transient_jpp_li_cc80d2be93bbe046dbe58bfd682d52fd", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:44:\"This IP is currently blocked (31.173.120.54)\";s:17:\"seconds_remaining\";i:3477;s:16:\"blocked_attempts\";s:4:\"8712\";s:6:\"expire\";i:1484635379;}", "no");
INSERT INTO wpax_options VALUES("43444", "_transient_timeout_jpp_li_cc1dbfeb69f02545c6db2df9b9a51769", "1484635148", "no");
INSERT INTO wpax_options VALUES("43445", "_transient_jpp_li_cc1dbfeb69f02545c6db2df9b9a51769", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:43:\"This IP is currently blocked (37.192.164.8)\";s:17:\"seconds_remaining\";i:3015;s:16:\"blocked_attempts\";s:4:\"8718\";s:6:\"expire\";i:1484635148;}", "no");
INSERT INTO wpax_options VALUES("43451", "_transient_timeout_wflginfl_00000000000000000000ffff57750fb6", "1484646625", "no");
INSERT INTO wpax_options VALUES("43452", "_transient_wflginfl_00000000000000000000ffff57750fb6", "1", "no");
INSERT INTO wpax_options VALUES("43456", "_transient_timeout_jpp_li_67f8d6c8c8527a6098999c10cebddc33", "1484635825", "no");
INSERT INTO wpax_options VALUES("43457", "_transient_jpp_li_67f8d6c8c8527a6098999c10cebddc33", "a:5:{s:6:\"status\";s:2:\"ok\";s:3:\"msg\";s:52:\"No current blocks on this IP address (87.117.15.182)\";s:17:\"seconds_remaining\";i:3600;s:16:\"blocked_attempts\";s:4:\"8719\";s:6:\"expire\";i:1484635825;}", "no");
INSERT INTO wpax_options VALUES("43474", "_transient_timeout_jpp_li_f98c1a2af0d33a4857a5057c7d891b01", "1484636538", "no");
INSERT INTO wpax_options VALUES("43475", "_transient_jpp_li_f98c1a2af0d33a4857a5057c7d891b01", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:46:\"This IP is currently blocked (176.197.163.250)\";s:17:\"seconds_remaining\";i:3565;s:16:\"blocked_attempts\";s:4:\"8724\";s:6:\"expire\";i:1484636538;}", "no");
INSERT INTO wpax_options VALUES("43483", "_transient_timeout_jpp_li_8ac5a01d8b279f9bc11002f4109b97ff", "1484633664", "no");
INSERT INTO wpax_options VALUES("43484", "_transient_jpp_li_8ac5a01d8b279f9bc11002f4109b97ff", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:44:\"This IP is currently blocked (94.25.182.244)\";s:17:\"seconds_remaining\";i:443;s:16:\"blocked_attempts\";s:4:\"8727\";s:6:\"expire\";i:1484633664;}", "no");
INSERT INTO wpax_options VALUES("43489", "_transient_timeout_jpp_li_a7dab3088d19391e941fc156c8aa33eb", "1484636800", "no");
INSERT INTO wpax_options VALUES("43490", "_transient_jpp_li_a7dab3088d19391e941fc156c8aa33eb", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:42:\"This IP is currently blocked (37.151.98.6)\";s:17:\"seconds_remaining\";i:3518;s:16:\"blocked_attempts\";s:4:\"8730\";s:6:\"expire\";i:1484636800;}", "no");
INSERT INTO wpax_options VALUES("43497", "_transient_timeout_jpp_li_009c32347cb3f414b444f13d1808fc72", "1484634965", "no");
INSERT INTO wpax_options VALUES("43498", "_transient_jpp_li_009c32347cb3f414b444f13d1808fc72", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:46:\"This IP is currently blocked (109.203.223.102)\";s:17:\"seconds_remaining\";i:1564;s:16:\"blocked_attempts\";s:4:\"8733\";s:6:\"expire\";i:1484634965;}", "no");
INSERT INTO wpax_options VALUES("43510", "_transient_timeout_jpp_li_e937e4e4e0537c85d9d6899b07618147", "1484637258", "no");
INSERT INTO wpax_options VALUES("43511", "_transient_jpp_li_e937e4e4e0537c85d9d6899b07618147", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:44:\"This IP is currently blocked (94.136.203.53)\";s:17:\"seconds_remaining\";i:3594;s:16:\"blocked_attempts\";s:4:\"8739\";s:6:\"expire\";i:1484637258;}", "no");
INSERT INTO wpax_options VALUES("43530", "_transient_timeout_jpp_li_42652addd80fbbe0961deba0c53bb162", "1484635656", "no");
INSERT INTO wpax_options VALUES("43531", "_transient_jpp_li_42652addd80fbbe0961deba0c53bb162", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:44:\"This IP is currently blocked (94.25.181.154)\";s:17:\"seconds_remaining\";i:1543;s:16:\"blocked_attempts\";s:4:\"8745\";s:6:\"expire\";i:1484635656;}", "no");
INSERT INTO wpax_options VALUES("43547", "_transient_timeout_jpp_li_55ef547dd3ab7c0a7a7132a074673793", "1484636728", "no");
INSERT INTO wpax_options VALUES("43548", "_transient_jpp_li_55ef547dd3ab7c0a7a7132a074673793", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:44:\"This IP is currently blocked (95.32.193.100)\";s:17:\"seconds_remaining\";i:2268;s:16:\"blocked_attempts\";s:4:\"8752\";s:6:\"expire\";i:1484636728;}", "no");
INSERT INTO wpax_options VALUES("43553", "_transient_timeout_jpp_li_45ea52c81ecf06d61f947c1480079f24", "1484634980", "no");
INSERT INTO wpax_options VALUES("43554", "_transient_jpp_li_45ea52c81ecf06d61f947c1480079f24", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:43:\"This IP is currently blocked (188.16.46.81)\";s:17:\"seconds_remaining\";i:324;s:16:\"blocked_attempts\";s:4:\"8755\";s:6:\"expire\";i:1484634980;}", "no");
INSERT INTO wpax_options VALUES("43559", "_transient_timeout_jpp_li_a9b5585cf1f534a907636dd77d6b180f", "1484638093", "no");
INSERT INTO wpax_options VALUES("43560", "_transient_jpp_li_a9b5585cf1f534a907636dd77d6b180f", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:44:\"This IP is currently blocked (178.207.190.8)\";s:17:\"seconds_remaining\";i:3404;s:16:\"blocked_attempts\";s:4:\"8758\";s:6:\"expire\";i:1484638093;}", "no");
INSERT INTO wpax_options VALUES("43569", "_transient_timeout_jpp_li_aff1eed032f70ce4ed95a6e7b3ae99eb", "1484638621", "no");
INSERT INTO wpax_options VALUES("43570", "_transient_jpp_li_aff1eed032f70ce4ed95a6e7b3ae99eb", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:44:\"This IP is currently blocked (78.107.156.26)\";s:17:\"seconds_remaining\";i:3565;s:16:\"blocked_attempts\";s:4:\"8761\";s:6:\"expire\";i:1484638621;}", "no");
INSERT INTO wpax_options VALUES("43577", "_transient_timeout_jpp_li_91376e390979812f8e4c255d37b04dd9", "1484638350", "no");
INSERT INTO wpax_options VALUES("43578", "_transient_jpp_li_91376e390979812f8e4c255d37b04dd9", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:43:\"This IP is currently blocked (46.172.66.60)\";s:17:\"seconds_remaining\";i:3251;s:16:\"blocked_attempts\";s:4:\"8764\";s:6:\"expire\";i:1484638350;}", "no");
INSERT INTO wpax_options VALUES("43583", "_transient_timeout_jpp_li_09ec7d928f71a3d40e648daf539d5d1b", "1484638671", "no");
INSERT INTO wpax_options VALUES("43584", "_transient_jpp_li_09ec7d928f71a3d40e648daf539d5d1b", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:44:\"This IP is currently blocked (83.149.46.159)\";s:17:\"seconds_remaining\";i:3463;s:16:\"blocked_attempts\";s:4:\"8767\";s:6:\"expire\";i:1484638671;}", "no");
INSERT INTO wpax_options VALUES("43591", "_transient_timeout_jpp_li_a73d7a59c840350f92b1fb449f7a1a58", "1484638320", "no");
INSERT INTO wpax_options VALUES("43592", "_transient_jpp_li_a73d7a59c840350f92b1fb449f7a1a58", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:44:\"This IP is currently blocked (89.251.156.57)\";s:17:\"seconds_remaining\";i:3046;s:16:\"blocked_attempts\";s:4:\"8771\";s:6:\"expire\";i:1484638320;}", "no");
INSERT INTO wpax_options VALUES("43600", "_transient_timeout_jpp_li_ae9ffea5fe03b5dca049f9124e12f122", "1484638815", "no");
INSERT INTO wpax_options VALUES("43601", "_transient_jpp_li_ae9ffea5fe03b5dca049f9124e12f122", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:45:\"This IP is currently blocked (178.236.142.26)\";s:17:\"seconds_remaining\";i:3295;s:16:\"blocked_attempts\";s:4:\"8774\";s:6:\"expire\";i:1484638815;}", "no");
INSERT INTO wpax_options VALUES("43610", "_transient_timeout_jpp_li_4d06ba956180ea39e8a4126f0b7ca013", "1484638873", "no");
INSERT INTO wpax_options VALUES("43611", "_transient_jpp_li_4d06ba956180ea39e8a4126f0b7ca013", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:45:\"This IP is currently blocked (91.207.245.231)\";s:17:\"seconds_remaining\";i:3050;s:16:\"blocked_attempts\";s:4:\"8777\";s:6:\"expire\";i:1484638873;}", "no");
INSERT INTO wpax_options VALUES("43616", "_transient_timeout_jpp_li_3c4cb3ce9a3af9d8f76156068bceb3e1", "1484638849", "no");
INSERT INTO wpax_options VALUES("43617", "_transient_jpp_li_3c4cb3ce9a3af9d8f76156068bceb3e1", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:42:\"This IP is currently blocked (85.94.0.108)\";s:17:\"seconds_remaining\";i:2949;s:16:\"blocked_attempts\";s:4:\"8780\";s:6:\"expire\";i:1484638849;}", "no");
INSERT INTO wpax_options VALUES("43623", "_transient_timeout_jpp_li_b9fc6915348b56e08425b9a4b87a6497", "1484638558", "no");
INSERT INTO wpax_options VALUES("43624", "_transient_jpp_li_b9fc6915348b56e08425b9a4b87a6497", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:44:\"This IP is currently blocked (109.68.185.74)\";s:17:\"seconds_remaining\";i:2651;s:16:\"blocked_attempts\";s:4:\"8783\";s:6:\"expire\";i:1484638558;}", "no");
INSERT INTO wpax_options VALUES("43629", "_transient_timeout_jpp_li_6c027eab63b1d6b7938a8fa0feaffc55", "1484639054", "no");
INSERT INTO wpax_options VALUES("43630", "_transient_jpp_li_6c027eab63b1d6b7938a8fa0feaffc55", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:45:\"This IP is currently blocked (217.12.249.234)\";s:17:\"seconds_remaining\";i:3107;s:16:\"blocked_attempts\";s:4:\"8786\";s:6:\"expire\";i:1484639054;}", "no");
INSERT INTO wpax_options VALUES("43635", "_transient_timeout_jpp_li_ba3e92130e9b1909b9005c630e627ecf", "1484638168", "no");
INSERT INTO wpax_options VALUES("43636", "_transient_jpp_li_ba3e92130e9b1909b9005c630e627ecf", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:44:\"This IP is currently blocked (95.73.121.184)\";s:17:\"seconds_remaining\";i:2135;s:16:\"blocked_attempts\";s:4:\"8789\";s:6:\"expire\";i:1484638168;}", "no");
INSERT INTO wpax_options VALUES("43651", "_transient_timeout_jpp_li_d62239baef6c734db84ee58c87a7068f", "1484639595", "no");
INSERT INTO wpax_options VALUES("43652", "_transient_jpp_li_d62239baef6c734db84ee58c87a7068f", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:45:\"This IP is currently blocked (46.172.100.125)\";s:17:\"seconds_remaining\";i:3041;s:16:\"blocked_attempts\";s:4:\"8795\";s:6:\"expire\";i:1484639595;}", "no");
INSERT INTO wpax_options VALUES("43659", "_transient_timeout_jpp_li_e595a5ef8e973c20728844e938639050", "1484638094", "no");
INSERT INTO wpax_options VALUES("43660", "_transient_jpp_li_e595a5ef8e973c20728844e938639050", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:44:\"This IP is currently blocked (213.33.234.22)\";s:17:\"seconds_remaining\";i:1534;s:16:\"blocked_attempts\";s:4:\"8798\";s:6:\"expire\";i:1484638094;}", "no");
INSERT INTO wpax_options VALUES("43665", "_transient_timeout_jpp_li_564f3abe3aba13986f8102ba5b251660", "1484640028", "no");
INSERT INTO wpax_options VALUES("43666", "_transient_jpp_li_564f3abe3aba13986f8102ba5b251660", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:45:\"This IP is currently blocked (178.252.205.27)\";s:17:\"seconds_remaining\";i:3319;s:16:\"blocked_attempts\";s:4:\"8801\";s:6:\"expire\";i:1484640028;}", "no");
INSERT INTO wpax_options VALUES("43680", "_transient_timeout_jpp_li_61fe4c1b6b6c36aeb3e0a42c7a699173", "1484639786", "no");
INSERT INTO wpax_options VALUES("43681", "_transient_jpp_li_61fe4c1b6b6c36aeb3e0a42c7a699173", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:44:\"This IP is currently blocked (94.28.179.111)\";s:17:\"seconds_remaining\";i:2890;s:16:\"blocked_attempts\";s:4:\"8807\";s:6:\"expire\";i:1484639786;}", "no");
INSERT INTO wpax_options VALUES("43689", "_transient_timeout_jpp_li_abd9a40bc94f2e2005c6cdc18e8b8ef4", "1484639139", "no");
INSERT INTO wpax_options VALUES("43690", "_transient_jpp_li_abd9a40bc94f2e2005c6cdc18e8b8ef4", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:46:\"This IP is currently blocked (188.162.185.250)\";s:17:\"seconds_remaining\";i:1799;s:16:\"blocked_attempts\";s:4:\"8810\";s:6:\"expire\";i:1484639139;}", "no");
INSERT INTO wpax_options VALUES("43715", "_transient_timeout_jpp_li_6e9fe34ee837ec5654bc7498eb9a6361", "1484640867", "no");
INSERT INTO wpax_options VALUES("43716", "_transient_jpp_li_6e9fe34ee837ec5654bc7498eb9a6361", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:45:\"This IP is currently blocked (88.147.153.100)\";s:17:\"seconds_remaining\";i:2914;s:16:\"blocked_attempts\";s:4:\"8819\";s:6:\"expire\";i:1484640867;}", "no");
INSERT INTO wpax_options VALUES("43722", "_transient_timeout_jpp_li_45844d9a183c8c0963fa7d506b763951", "1484641523", "no");
INSERT INTO wpax_options VALUES("43723", "_transient_jpp_li_45844d9a183c8c0963fa7d506b763951", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:44:\"This IP is currently blocked (109.237.157.7)\";s:17:\"seconds_remaining\";i:3455;s:16:\"blocked_attempts\";s:4:\"8822\";s:6:\"expire\";i:1484641523;}", "no");
INSERT INTO wpax_options VALUES("43728", "_transient_timeout_jpp_li_4e0208703e16ad844781ce9548182bbf", "1484639940", "no");
INSERT INTO wpax_options VALUES("43729", "_transient_jpp_li_4e0208703e16ad844781ce9548182bbf", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:43:\"This IP is currently blocked (92.47.253.71)\";s:17:\"seconds_remaining\";i:1861;s:16:\"blocked_attempts\";s:4:\"8825\";s:6:\"expire\";i:1484639940;}", "no");
INSERT INTO wpax_options VALUES("43738", "_transient_timeout_jpp_li_79ac4a85550d956dcfc65030304ad90b", "1484641965", "no");
INSERT INTO wpax_options VALUES("43739", "_transient_jpp_li_79ac4a85550d956dcfc65030304ad90b", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:44:\"This IP is currently blocked (109.172.98.83)\";s:17:\"seconds_remaining\";i:3271;s:16:\"blocked_attempts\";s:4:\"8828\";s:6:\"expire\";i:1484641965;}", "no");
INSERT INTO wpax_options VALUES("43746", "_transient_timeout_jpp_li_65ca72d0821e5b3c4b926b476c4e3724", "1484640493", "no");
INSERT INTO wpax_options VALUES("43747", "_transient_jpp_li_65ca72d0821e5b3c4b926b476c4e3724", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:43:\"This IP is currently blocked (81.27.56.100)\";s:17:\"seconds_remaining\";i:1763;s:16:\"blocked_attempts\";s:4:\"8831\";s:6:\"expire\";i:1484640493;}", "no");
INSERT INTO wpax_options VALUES("43767", "_transient_timeout_jpp_li_2ef6de476ffbe719dddb79399a87831b", "1484642336", "no");
INSERT INTO wpax_options VALUES("43768", "_transient_jpp_li_2ef6de476ffbe719dddb79399a87831b", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:43:\"This IP is currently blocked (77.72.121.70)\";s:17:\"seconds_remaining\";i:3168;s:16:\"blocked_attempts\";s:4:\"8840\";s:6:\"expire\";i:1484642336;}", "no");
INSERT INTO wpax_options VALUES("43774", "_transient_timeout_jpp_li_5aef63c839bb1c88f7eda4f179eb8d7a", "1484640818", "no");
INSERT INTO wpax_options VALUES("43775", "_transient_jpp_li_5aef63c839bb1c88f7eda4f179eb8d7a", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:46:\"This IP is currently blocked (178.218.107.113)\";s:17:\"seconds_remaining\";i:1515;s:16:\"blocked_attempts\";s:4:\"8843\";s:6:\"expire\";i:1484640818;}", "no");
INSERT INTO wpax_options VALUES("43783", "_transient_timeout_jpp_li_62d0baf02dccf962026f6f6203e76ba1", "1484639903", "no");
INSERT INTO wpax_options VALUES("43784", "_transient_jpp_li_62d0baf02dccf962026f6f6203e76ba1", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:43:\"This IP is currently blocked (93.170.5.202)\";s:17:\"seconds_remaining\";i:388;s:16:\"blocked_attempts\";s:4:\"8846\";s:6:\"expire\";i:1484639903;}", "no");
INSERT INTO wpax_options VALUES("43789", "_transient_timeout_jpp_li_3c761b79b338a1203f4e307c0e29a1e7", "1484642455", "no");
INSERT INTO wpax_options VALUES("43790", "_transient_jpp_li_3c761b79b338a1203f4e307c0e29a1e7", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:45:\"This IP is currently blocked (92.252.159.147)\";s:17:\"seconds_remaining\";i:2841;s:16:\"blocked_attempts\";s:4:\"8849\";s:6:\"expire\";i:1484642455;}", "no");
INSERT INTO wpax_options VALUES("43795", "_transient_timeout_jpp_li_882030380814b5a59fdb990e7f85b29c", "1484640921", "no");
INSERT INTO wpax_options VALUES("43796", "_transient_jpp_li_882030380814b5a59fdb990e7f85b29c", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:43:\"This IP is currently blocked (89.109.21.35)\";s:17:\"seconds_remaining\";i:1290;s:16:\"blocked_attempts\";s:4:\"8852\";s:6:\"expire\";i:1484640921;}", "no");
INSERT INTO wpax_options VALUES("43804", "_transient_timeout_jpp_li_961bb8d479be34bdb1f47ec897f09ef9", "1484640197", "no");
INSERT INTO wpax_options VALUES("43805", "_transient_jpp_li_961bb8d479be34bdb1f47ec897f09ef9", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:43:\"This IP is currently blocked (93.189.221.9)\";s:17:\"seconds_remaining\";i:314;s:16:\"blocked_attempts\";s:4:\"8855\";s:6:\"expire\";i:1484640197;}", "no");
INSERT INTO wpax_options VALUES("43819", "_transient_timeout_jpp_li_5904187f186bcd3e88c3a0bfeb73d144", "1484643406", "no");
INSERT INTO wpax_options VALUES("43820", "_transient_jpp_li_5904187f186bcd3e88c3a0bfeb73d144", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:44:\"This IP is currently blocked (94.41.221.250)\";s:17:\"seconds_remaining\";i:3065;s:16:\"blocked_attempts\";s:4:\"8861\";s:6:\"expire\";i:1484643406;}", "no");
INSERT INTO wpax_options VALUES("43825", "_transient_timeout_jpp_li_72db6e878828991e5705cb4112d95583", "1484643590", "no");
INSERT INTO wpax_options VALUES("43826", "_transient_jpp_li_72db6e878828991e5705cb4112d95583", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:45:\"This IP is currently blocked (136.169.218.33)\";s:17:\"seconds_remaining\";i:3240;s:16:\"blocked_attempts\";s:4:\"8864\";s:6:\"expire\";i:1484643590;}", "no");
INSERT INTO wpax_options VALUES("43831", "_transient_timeout_jpp_li_3c72422f244062c94e6ed21c55638456", "1484642572", "no");
INSERT INTO wpax_options VALUES("43832", "_transient_jpp_li_3c72422f244062c94e6ed21c55638456", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:44:\"This IP is currently blocked (95.170.153.90)\";s:17:\"seconds_remaining\";i:2197;s:16:\"blocked_attempts\";s:4:\"8867\";s:6:\"expire\";i:1484642572;}", "no");
INSERT INTO wpax_options VALUES("43850", "_transient_timeout_jpp_li_9c10e9fc103302e77b2314a4ae75e328", "1484641882", "no");
INSERT INTO wpax_options VALUES("43851", "_transient_jpp_li_9c10e9fc103302e77b2314a4ae75e328", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:44:\"This IP is currently blocked (89.31.189.120)\";s:17:\"seconds_remaining\";i:866;s:16:\"blocked_attempts\";s:4:\"8873\";s:6:\"expire\";i:1484641882;}", "no");
INSERT INTO wpax_options VALUES("43858", "_transient_timeout_jpp_li_016f1cf2992093248d22f6fb780c32f3", "1484643628", "no");
INSERT INTO wpax_options VALUES("43859", "_transient_jpp_li_016f1cf2992093248d22f6fb780c32f3", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:44:\"This IP is currently blocked (178.163.38.32)\";s:17:\"seconds_remaining\";i:2383;s:16:\"blocked_attempts\";s:4:\"8876\";s:6:\"expire\";i:1484643628;}", "no");
INSERT INTO wpax_options VALUES("43867", "_transient_timeout_jpp_li_c0e7e7d6388ec313db2efc2db935c26c", "1484644009", "no");
INSERT INTO wpax_options VALUES("43868", "_transient_jpp_li_c0e7e7d6388ec313db2efc2db935c26c", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:46:\"This IP is currently blocked (188.162.229.146)\";s:17:\"seconds_remaining\";i:2578;s:16:\"blocked_attempts\";s:4:\"8879\";s:6:\"expire\";i:1484644009;}", "no");
INSERT INTO wpax_options VALUES("43873", "_transient_timeout_jpp_li_85414de5d4b897091f0c6b3e9d0df3a0", "1484644159", "no");
INSERT INTO wpax_options VALUES("43874", "_transient_jpp_li_85414de5d4b897091f0c6b3e9d0df3a0", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:43:\"This IP is currently blocked (103.58.6.102)\";s:17:\"seconds_remaining\";i:2659;s:16:\"blocked_attempts\";s:4:\"8882\";s:6:\"expire\";i:1484644159;}", "no");
INSERT INTO wpax_options VALUES("43888", "_transient_timeout_jpp_li_94ef773179743760715a78ad77fe78a3", "1484644213", "no");
INSERT INTO wpax_options VALUES("43889", "_transient_jpp_li_94ef773179743760715a78ad77fe78a3", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:43:\"This IP is currently blocked (79.173.67.74)\";s:17:\"seconds_remaining\";i:2311;s:16:\"blocked_attempts\";s:4:\"8888\";s:6:\"expire\";i:1484644213;}", "no");
INSERT INTO wpax_options VALUES("43900", "_transient_timeout_jpp_li_5f8f97999e6e85f6ff2eb94789a0bacb", "1484645426", "no");
INSERT INTO wpax_options VALUES("43901", "_transient_jpp_li_5f8f97999e6e85f6ff2eb94789a0bacb", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:43:\"This IP is currently blocked (188.162.65.4)\";s:17:\"seconds_remaining\";i:3213;s:16:\"blocked_attempts\";s:4:\"8892\";s:6:\"expire\";i:1484645426;}", "no");
INSERT INTO wpax_options VALUES("43922", "_transient_timeout_jpp_li_d9860fcfd55eb06e266ec3fefef416ef", "1484645054", "no");
INSERT INTO wpax_options VALUES("43923", "_transient_jpp_li_d9860fcfd55eb06e266ec3fefef416ef", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:44:\"This IP is currently blocked (87.245.189.10)\";s:17:\"seconds_remaining\";i:2202;s:16:\"blocked_attempts\";s:4:\"8901\";s:6:\"expire\";i:1484645054;}", "no");
INSERT INTO wpax_options VALUES("43938", "_transient_timeout_jpp_li_a20b155a9455a3529dd68c247d9302e5", "1484646131", "no");
INSERT INTO wpax_options VALUES("43939", "_transient_jpp_li_a20b155a9455a3529dd68c247d9302e5", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:43:\"This IP is currently blocked (46.61.66.111)\";s:17:\"seconds_remaining\";i:2893;s:16:\"blocked_attempts\";s:4:\"8907\";s:6:\"expire\";i:1484646131;}", "no");
INSERT INTO wpax_options VALUES("43944", "_transient_timeout_jpp_li_b1a03e6fb487ca28b67a579ebc81e64f", "1484645625", "no");
INSERT INTO wpax_options VALUES("43945", "_transient_jpp_li_b1a03e6fb487ca28b67a579ebc81e64f", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:43:\"This IP is currently blocked (5.141.98.246)\";s:17:\"seconds_remaining\";i:2304;s:16:\"blocked_attempts\";s:4:\"8910\";s:6:\"expire\";i:1484645625;}", "no");
INSERT INTO wpax_options VALUES("43952", "_transient_timeout_jpp_li_77bfe8587b4dfb48dc341d09997c1777", "1484643748", "no");
INSERT INTO wpax_options VALUES("43953", "_transient_jpp_li_77bfe8587b4dfb48dc341d09997c1777", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:45:\"This IP is currently blocked (91.144.167.250)\";s:17:\"seconds_remaining\";i:366;s:16:\"blocked_attempts\";s:4:\"8913\";s:6:\"expire\";i:1484643748;}", "no");
INSERT INTO wpax_options VALUES("43959", "_transient_timeout_jpp_li_571f70d04e7265a14e0401ea6ce17817", "1484644880", "no");
INSERT INTO wpax_options VALUES("43960", "_transient_jpp_li_571f70d04e7265a14e0401ea6ce17817", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:45:\"This IP is currently blocked (78.132.140.235)\";s:17:\"seconds_remaining\";i:1337;s:16:\"blocked_attempts\";s:4:\"8916\";s:6:\"expire\";i:1484644880;}", "no");
INSERT INTO wpax_options VALUES("43968", "_transient_timeout_jpp_li_21ddd310af9813be11a819c760a8df52", "1484646175", "no");
INSERT INTO wpax_options VALUES("43969", "_transient_jpp_li_21ddd310af9813be11a819c760a8df52", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:44:\"This IP is currently blocked (91.143.147.41)\";s:17:\"seconds_remaining\";i:2295;s:16:\"blocked_attempts\";s:4:\"8919\";s:6:\"expire\";i:1484646175;}", "no");
INSERT INTO wpax_options VALUES("43979", "_transient_timeout_jpp_li_2947222f3b97b1f51c1af2b17ee21c89", "1484647507", "no");
INSERT INTO wpax_options VALUES("43980", "_transient_jpp_li_2947222f3b97b1f51c1af2b17ee21c89", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:45:\"This IP is currently blocked (85.192.180.206)\";s:17:\"seconds_remaining\";i:3350;s:16:\"blocked_attempts\";s:4:\"8922\";s:6:\"expire\";i:1484647507;}", "no");
INSERT INTO wpax_options VALUES("43985", "_transient_timeout_jpp_li_23761a3d3b3f762dbbd0a278f752c55a", "1484647656", "no");
INSERT INTO wpax_options VALUES("43986", "_transient_jpp_li_23761a3d3b3f762dbbd0a278f752c55a", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:45:\"This IP is currently blocked (177.207.68.218)\";s:17:\"seconds_remaining\";i:3451;s:16:\"blocked_attempts\";s:4:\"8925\";s:6:\"expire\";i:1484647656;}", "no");
INSERT INTO wpax_options VALUES("43992", "_transient_timeout_jpp_li_cb3cacbd4789d44ead97f6a1dc7707a2", "1484646980", "no");
INSERT INTO wpax_options VALUES("43993", "_transient_jpp_li_cb3cacbd4789d44ead97f6a1dc7707a2", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:45:\"This IP is currently blocked (31.135.121.167)\";s:17:\"seconds_remaining\";i:2594;s:16:\"blocked_attempts\";s:4:\"8928\";s:6:\"expire\";i:1484646980;}", "no");
INSERT INTO wpax_options VALUES("44007", "_transient_timeout_jpp_li_88bc3dfa4e86e45fd327259c1e39e48d", "1484647827", "no");
INSERT INTO wpax_options VALUES("44008", "_transient_jpp_li_88bc3dfa4e86e45fd327259c1e39e48d", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:44:\"This IP is currently blocked (85.173.121.49)\";s:17:\"seconds_remaining\";i:3193;s:16:\"blocked_attempts\";s:4:\"8934\";s:6:\"expire\";i:1484647827;}", "no");
INSERT INTO wpax_options VALUES("44009", "_transient_timeout_jpp_li_bab0026e9ad9aeb7cb3f68d33c000a78", "1484645400", "no");
INSERT INTO wpax_options VALUES("44010", "_transient_jpp_li_bab0026e9ad9aeb7cb3f68d33c000a78", "a:5:{s:6:\"status\";s:12:\"blocked-hard\";s:3:\"msg\";s:42:\"This IP is currently blocked (94.25.74.99)\";s:17:\"seconds_remaining\";i:703;s:16:\"blocked_attempts\";s:4:\"8935\";s:6:\"expire\";i:1484645400;}", "no");
INSERT INTO wpax_options VALUES("44017", "_transient_timeout_jpp_li_090709aa2063593e7d4b5d82cb089553", "1484647284", "no");
INSERT INTO wpax_options VALUES("44018", "_transient_jpp_li_090709aa2063593e7d4b5d82cb089553", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:43:\"This IP is currently blocked (94.64.124.54)\";s:17:\"seconds_remaining\";i:2566;s:16:\"blocked_attempts\";s:4:\"8938\";s:6:\"expire\";i:1484647284;}", "no");
INSERT INTO wpax_options VALUES("44023", "_transient_timeout_jpp_li_1d10168a368f56687d413969147da1bb", "1484648364", "no");
INSERT INTO wpax_options VALUES("44024", "_transient_jpp_li_1d10168a368f56687d413969147da1bb", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:43:\"This IP is currently blocked (78.36.223.12)\";s:17:\"seconds_remaining\";i:3505;s:16:\"blocked_attempts\";s:4:\"8941\";s:6:\"expire\";i:1484648364;}", "no");
INSERT INTO wpax_options VALUES("44031", "_transient_timeout_jpp_li_4fbad83cff370952fdd7e279b2662342", "1484646133", "no");
INSERT INTO wpax_options VALUES("44032", "_transient_jpp_li_4fbad83cff370952fdd7e279b2662342", "a:5:{s:6:\"status\";s:12:\"blocked-hard\";s:3:\"msg\";s:43:\"This IP is currently blocked (5.164.31.105)\";s:17:\"seconds_remaining\";i:826;s:16:\"blocked_attempts\";s:4:\"8942\";s:6:\"expire\";i:1484646133;}", "no");
INSERT INTO wpax_options VALUES("44047", "_transient_timeout_jpp_li_e0b34064b79693b3c13e2e212e041290", "1484646237", "no");
INSERT INTO wpax_options VALUES("44048", "_transient_jpp_li_e0b34064b79693b3c13e2e212e041290", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:44:\"This IP is currently blocked (178.69.30.219)\";s:17:\"seconds_remaining\";i:365;s:16:\"blocked_attempts\";s:4:\"8948\";s:6:\"expire\";i:1484646237;}", "no");
INSERT INTO wpax_options VALUES("44056", "_transient_timeout_jpp_li_f6e00381a7dad6c14ddc08d844f7da1a", "1484649067", "no");
INSERT INTO wpax_options VALUES("44057", "_transient_jpp_li_f6e00381a7dad6c14ddc08d844f7da1a", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:42:\"This IP is currently blocked (80.95.38.36)\";s:17:\"seconds_remaining\";i:2956;s:16:\"blocked_attempts\";s:4:\"8951\";s:6:\"expire\";i:1484649067;}", "no");
INSERT INTO wpax_options VALUES("44062", "_transient_timeout_jpp_li_0935f7f14d3d76b3a0a15907b783db86", "1484648601", "no");
INSERT INTO wpax_options VALUES("44063", "_transient_jpp_li_0935f7f14d3d76b3a0a15907b783db86", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:44:\"This IP is currently blocked (80.242.73.213)\";s:17:\"seconds_remaining\";i:2426;s:16:\"blocked_attempts\";s:4:\"8954\";s:6:\"expire\";i:1484648601;}", "no");
INSERT INTO wpax_options VALUES("44071", "_transient_timeout_jpp_li_b390ec4ec11992f4738c063b6c6540c4", "1484649920", "no");
INSERT INTO wpax_options VALUES("44072", "_transient_jpp_li_b390ec4ec11992f4738c063b6c6540c4", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:45:\"This IP is currently blocked (217.66.158.140)\";s:17:\"seconds_remaining\";i:3333;s:16:\"blocked_attempts\";s:4:\"8957\";s:6:\"expire\";i:1484649920;}", "no");
INSERT INTO wpax_options VALUES("44077", "_transient_timeout_jpp_li_851cf222b387954479feddc7642a81b9", "1484649119", "no");
INSERT INTO wpax_options VALUES("44078", "_transient_jpp_li_851cf222b387954479feddc7642a81b9", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:44:\"This IP is currently blocked (217.23.186.77)\";s:17:\"seconds_remaining\";i:2508;s:16:\"blocked_attempts\";s:4:\"8960\";s:6:\"expire\";i:1484649119;}", "no");
INSERT INTO wpax_options VALUES("44089", "_transient_timeout_jpp_li_65753f8d8552e54d72b6f1d80d2763fc", "1484649734", "no");
INSERT INTO wpax_options VALUES("44090", "_transient_jpp_li_65753f8d8552e54d72b6f1d80d2763fc", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:45:\"This IP is currently blocked (88.147.242.125)\";s:17:\"seconds_remaining\";i:2564;s:16:\"blocked_attempts\";s:4:\"8963\";s:6:\"expire\";i:1484649734;}", "no");
INSERT INTO wpax_options VALUES("44095", "_transient_timeout_jpp_li_279aea27a896e903dfca87df6e04e999", "1484650375", "no");
INSERT INTO wpax_options VALUES("44096", "_transient_jpp_li_279aea27a896e903dfca87df6e04e999", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:45:\"This IP is currently blocked (109.252.93.122)\";s:17:\"seconds_remaining\";i:3126;s:16:\"blocked_attempts\";s:4:\"8966\";s:6:\"expire\";i:1484650375;}", "no");
INSERT INTO wpax_options VALUES("44102", "_transient_timeout_jpp_li_f11777fcdc12b03021eed150cf2284e9", "1484649454", "no");
INSERT INTO wpax_options VALUES("44103", "_transient_jpp_li_f11777fcdc12b03021eed150cf2284e9", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:44:\"This IP is currently blocked (194.15.117.19)\";s:17:\"seconds_remaining\";i:2115;s:16:\"blocked_attempts\";s:4:\"8969\";s:6:\"expire\";i:1484649454;}", "no");
INSERT INTO wpax_options VALUES("44108", "_transient_timeout_jpp_li_2dc775bcb87cd05078cadd676705e9ff", "1484650750", "no");
INSERT INTO wpax_options VALUES("44109", "_transient_jpp_li_2dc775bcb87cd05078cadd676705e9ff", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:42:\"This IP is currently blocked (95.78.16.97)\";s:17:\"seconds_remaining\";i:3392;s:16:\"blocked_attempts\";s:4:\"8972\";s:6:\"expire\";i:1484650750;}", "no");
INSERT INTO wpax_options VALUES("44116", "_transient_timeout_jpp_li_6ff2aa4a70751e83a1bf94bf3e7d844d", "1484650996", "no");
INSERT INTO wpax_options VALUES("44117", "_transient_jpp_li_6ff2aa4a70751e83a1bf94bf3e7d844d", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:44:\"This IP is currently blocked (90.154.72.133)\";s:17:\"seconds_remaining\";i:3419;s:16:\"blocked_attempts\";s:4:\"8975\";s:6:\"expire\";i:1484650996;}", "no");
INSERT INTO wpax_options VALUES("44129", "_transient_timeout_jpp_li_47e9f2af0d551c07c356c4fc52032781", "1484648717", "no");
INSERT INTO wpax_options VALUES("44130", "_transient_jpp_li_47e9f2af0d551c07c356c4fc52032781", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:46:\"This IP is currently blocked (109.167.204.124)\";s:17:\"seconds_remaining\";i:887;s:16:\"blocked_attempts\";s:4:\"8981\";s:6:\"expire\";i:1484648717;}", "no");
INSERT INTO wpax_options VALUES("44138", "_transient_timeout_jpp_li_a08aa3540983ccb8b85b4e37061ea1eb", "1484651018", "no");
INSERT INTO wpax_options VALUES("44139", "_transient_jpp_li_a08aa3540983ccb8b85b4e37061ea1eb", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:42:\"This IP is currently blocked (5.166.85.63)\";s:17:\"seconds_remaining\";i:3048;s:16:\"blocked_attempts\";s:4:\"8984\";s:6:\"expire\";i:1484651018;}", "no");
INSERT INTO wpax_options VALUES("44144", "_transient_timeout_jpp_li_96e32a6ab1e0fefb66abe21c61555826", "1484650846", "no");
INSERT INTO wpax_options VALUES("44145", "_transient_jpp_li_96e32a6ab1e0fefb66abe21c61555826", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:42:\"This IP is currently blocked (31.6.121.80)\";s:17:\"seconds_remaining\";i:2734;s:16:\"blocked_attempts\";s:4:\"8987\";s:6:\"expire\";i:1484650846;}", "no");
INSERT INTO wpax_options VALUES("44150", "_transient_timeout_jpp_li_22e4df2def327fc36c0128fcf7f19278", "1484651064", "no");
INSERT INTO wpax_options VALUES("44151", "_transient_jpp_li_22e4df2def327fc36c0128fcf7f19278", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:44:\"This IP is currently blocked (87.255.31.249)\";s:17:\"seconds_remaining\";i:2921;s:16:\"blocked_attempts\";s:4:\"8990\";s:6:\"expire\";i:1484651064;}", "no");
INSERT INTO wpax_options VALUES("44158", "_transient_timeout_jpp_li_13d123d627f404486742c938c12674af", "1484651662", "no");
INSERT INTO wpax_options VALUES("44160", "_transient_jpp_li_13d123d627f404486742c938c12674af", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:45:\"This IP is currently blocked (178.68.120.190)\";s:17:\"seconds_remaining\";i:3441;s:16:\"blocked_attempts\";s:4:\"8993\";s:6:\"expire\";i:1484651662;}", "no");
INSERT INTO wpax_options VALUES("44163", "_transient_timeout_jpp_li_2230da72004c7c36099953e920c4389e", "1484650951", "no");
INSERT INTO wpax_options VALUES("44164", "_transient_jpp_li_2230da72004c7c36099953e920c4389e", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:44:\"This IP is currently blocked (176.62.69.118)\";s:17:\"seconds_remaining\";i:2723;s:16:\"blocked_attempts\";s:4:\"8995\";s:6:\"expire\";i:1484650951;}", "no");
INSERT INTO wpax_options VALUES("44171", "_transient_timeout_jpp_li_aac93f21f3c560adea735f2a56a8bfb2", "1484649274", "no");
INSERT INTO wpax_options VALUES("44172", "_transient_jpp_li_aac93f21f3c560adea735f2a56a8bfb2", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:44:\"This IP is currently blocked (46.43.213.162)\";s:17:\"seconds_remaining\";i:989;s:16:\"blocked_attempts\";s:4:\"8998\";s:6:\"expire\";i:1484649274;}", "no");
INSERT INTO wpax_options VALUES("44180", "_transient_timeout_jpp_li_3766b1e1ce3d350a099cf26381ac1066", "1484651204", "no");
INSERT INTO wpax_options VALUES("44181", "_transient_jpp_li_3766b1e1ce3d350a099cf26381ac1066", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:44:\"This IP is currently blocked (78.153.31.141)\";s:17:\"seconds_remaining\";i:2695;s:16:\"blocked_attempts\";s:4:\"9001\";s:6:\"expire\";i:1484651204;}", "no");
INSERT INTO wpax_options VALUES("44195", "_transient_timeout_jpp_li_a2e696a350086b29b42d46031a4a1586", "1484649070", "no");
INSERT INTO wpax_options VALUES("44196", "_transient_jpp_li_a2e696a350086b29b42d46031a4a1586", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:45:\"This IP is currently blocked (85.141.166.239)\";s:17:\"seconds_remaining\";i:261;s:16:\"blocked_attempts\";s:4:\"9007\";s:6:\"expire\";i:1484649070;}", "no");
INSERT INTO wpax_options VALUES("44203", "_transient_timeout_jpp_li_ec4a83df80223f662ba4685cc17788e8", "1484651476", "no");
INSERT INTO wpax_options VALUES("44204", "_transient_jpp_li_ec4a83df80223f662ba4685cc17788e8", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:43:\"This IP is currently blocked (81.163.98.51)\";s:17:\"seconds_remaining\";i:2585;s:16:\"blocked_attempts\";s:4:\"9010\";s:6:\"expire\";i:1484651476;}", "no");
INSERT INTO wpax_options VALUES("44209", "_transient_timeout_jpp_li_dc242dbd97df374a0b122ff995a4cb33", "1484652422", "no");
INSERT INTO wpax_options VALUES("44210", "_transient_jpp_li_dc242dbd97df374a0b122ff995a4cb33", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:44:\"This IP is currently blocked (95.52.223.194)\";s:17:\"seconds_remaining\";i:3505;s:16:\"blocked_attempts\";s:4:\"9013\";s:6:\"expire\";i:1484652422;}", "no");
INSERT INTO wpax_options VALUES("44216", "_transient_timeout_jpp_li_21257352541c71886d5d23ab90cb2ab2", "1484649195", "no");
INSERT INTO wpax_options VALUES("44217", "_transient_jpp_li_21257352541c71886d5d23ab90cb2ab2", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:43:\"This IP is currently blocked (94.19.145.11)\";s:17:\"seconds_remaining\";i:45;s:16:\"blocked_attempts\";s:4:\"9016\";s:6:\"expire\";i:1484649195;}", "no");
INSERT INTO wpax_options VALUES("44222", "_transient_timeout_jpp_li_bc03dd986b7e9f25e0f4a5c18f7f1c35", "1484652110", "no");
INSERT INTO wpax_options VALUES("44223", "_transient_jpp_li_bc03dd986b7e9f25e0f4a5c18f7f1c35", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:44:\"This IP is currently blocked (78.25.122.151)\";s:17:\"seconds_remaining\";i:2848;s:16:\"blocked_attempts\";s:4:\"9018\";s:6:\"expire\";i:1484652110;}", "no");
INSERT INTO wpax_options VALUES("44228", "_transient_timeout_jpp_li_cc2f10c37926df3bc2a277fdacc2a83e", "1484651648", "no");
INSERT INTO wpax_options VALUES("44229", "_transient_jpp_li_cc2f10c37926df3bc2a277fdacc2a83e", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:45:\"This IP is currently blocked (62.117.117.202)\";s:17:\"seconds_remaining\";i:2280;s:16:\"blocked_attempts\";s:4:\"9021\";s:6:\"expire\";i:1484651648;}", "no");
INSERT INTO wpax_options VALUES("44249", "_transient_timeout_jpp_li_5afd55c1cab75cfbc151b09e527a5549", "1484653366", "no");
INSERT INTO wpax_options VALUES("44250", "_transient_jpp_li_5afd55c1cab75cfbc151b09e527a5549", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:45:\"This IP is currently blocked (188.254.126.46)\";s:17:\"seconds_remaining\";i:3295;s:16:\"blocked_attempts\";s:4:\"9028\";s:6:\"expire\";i:1484653366;}", "no");
INSERT INTO wpax_options VALUES("44265", "_transient_timeout_jpp_li_faeb0ae90aec4e57c4096cdd095d9cc8", "1484651930", "no");
INSERT INTO wpax_options VALUES("44266", "_transient_jpp_li_faeb0ae90aec4e57c4096cdd095d9cc8", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:41:\"This IP is currently blocked (85.174.9.7)\";s:17:\"seconds_remaining\";i:1524;s:16:\"blocked_attempts\";s:4:\"9034\";s:6:\"expire\";i:1484651930;}", "no");
INSERT INTO wpax_options VALUES("44271", "_transient_timeout_jpp_li_ecc87ea81608e31e9b901c281cde3689", "1484653845", "no");
INSERT INTO wpax_options VALUES("44272", "_transient_jpp_li_ecc87ea81608e31e9b901c281cde3689", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:45:\"This IP is currently blocked (185.124.189.26)\";s:17:\"seconds_remaining\";i:3377;s:16:\"blocked_attempts\";s:4:\"9037\";s:6:\"expire\";i:1484653845;}", "no");
INSERT INTO wpax_options VALUES("44277", "_transient_timeout_jpp_li_b5fba31625100553a739e7083481da05", "1484652577", "no");
INSERT INTO wpax_options VALUES("44278", "_transient_jpp_li_b5fba31625100553a739e7083481da05", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:44:\"This IP is currently blocked (88.200.214.22)\";s:17:\"seconds_remaining\";i:1978;s:16:\"blocked_attempts\";s:4:\"9040\";s:6:\"expire\";i:1484652577;}", "no");
INSERT INTO wpax_options VALUES("44284", "_transient_timeout_jpp_li_05623ee6d49934105291b73de7317eae", "1484650708", "no");
INSERT INTO wpax_options VALUES("44285", "_transient_jpp_li_05623ee6d49934105291b73de7317eae", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:43:\"This IP is currently blocked (62.133.173.2)\";s:17:\"seconds_remaining\";i:10;s:16:\"blocked_attempts\";s:4:\"9043\";s:6:\"expire\";i:1484650708;}", "no");
INSERT INTO wpax_options VALUES("44292", "_transient_timeout_jpp_li_1ebe554a1efc58f804f5699fb057dec8", "1484651190", "no");
INSERT INTO wpax_options VALUES("44293", "_transient_jpp_li_1ebe554a1efc58f804f5699fb057dec8", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:44:\"This IP is currently blocked (46.39.230.169)\";s:17:\"seconds_remaining\";i:470;s:16:\"blocked_attempts\";s:4:\"9046\";s:6:\"expire\";i:1484651190;}", "no");
INSERT INTO wpax_options VALUES("44298", "_transient_timeout_jpp_li_7ca078add5e622530b9712f2f413276a", "1484654256", "no");
INSERT INTO wpax_options VALUES("44299", "_transient_jpp_li_7ca078add5e622530b9712f2f413276a", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:45:\"This IP is currently blocked (109.201.200.28)\";s:17:\"seconds_remaining\";i:3398;s:16:\"blocked_attempts\";s:4:\"9049\";s:6:\"expire\";i:1484654256;}", "no");
INSERT INTO wpax_options VALUES("44305", "_transient_timeout_jpp_li_a634e1d688a35520455e7506123c22d6", "1484653290", "no");
INSERT INTO wpax_options VALUES("44306", "_transient_jpp_li_a634e1d688a35520455e7506123c22d6", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:44:\"This IP is currently blocked (188.170.194.2)\";s:17:\"seconds_remaining\";i:2342;s:16:\"blocked_attempts\";s:4:\"9052\";s:6:\"expire\";i:1484653290;}", "no");
INSERT INTO wpax_options VALUES("44311", "_transient_timeout_jpp_li_4b3b304bef9eed1cee13f6c8c1724a55", "1484654428", "no");
INSERT INTO wpax_options VALUES("44312", "_transient_jpp_li_4b3b304bef9eed1cee13f6c8c1724a55", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:45:\"This IP is currently blocked (212.116.124.42)\";s:17:\"seconds_remaining\";i:3453;s:16:\"blocked_attempts\";s:4:\"9055\";s:6:\"expire\";i:1484654428;}", "no");
INSERT INTO wpax_options VALUES("44331", "_transient_timeout_jpp_li_0a4f42ae27e5ac3fc59cf4ce8ed4c3fc", "1484654107", "no");
INSERT INTO wpax_options VALUES("44332", "_transient_jpp_li_0a4f42ae27e5ac3fc59cf4ce8ed4c3fc", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:44:\"This IP is currently blocked (91.224.81.110)\";s:17:\"seconds_remaining\";i:3014;s:16:\"blocked_attempts\";s:4:\"9064\";s:6:\"expire\";i:1484654107;}", "no");
INSERT INTO wpax_options VALUES("44337", "_transient_timeout_jpp_li_bb945313c98c023e3bd344fa5c877449", "1484653848", "no");
INSERT INTO wpax_options VALUES("44338", "_transient_jpp_li_bb945313c98c023e3bd344fa5c877449", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:43:\"This IP is currently blocked (87.241.206.4)\";s:17:\"seconds_remaining\";i:2696;s:16:\"blocked_attempts\";s:4:\"9067\";s:6:\"expire\";i:1484653848;}", "no");
INSERT INTO wpax_options VALUES("44344", "_transient_timeout_jpp_li_6e9f3852ff5a850e3117d69fb572d26c", "1484654659", "no");
INSERT INTO wpax_options VALUES("44345", "_transient_jpp_li_6e9f3852ff5a850e3117d69fb572d26c", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:43:\"This IP is currently blocked (176.109.0.10)\";s:17:\"seconds_remaining\";i:3366;s:16:\"blocked_attempts\";s:4:\"9070\";s:6:\"expire\";i:1484654659;}", "no");
INSERT INTO wpax_options VALUES("44352", "_transient_timeout_jpp_li_5bf21228a68143d93e619660b21d9daa", "1484654833", "no");
INSERT INTO wpax_options VALUES("44353", "_transient_jpp_li_5bf21228a68143d93e619660b21d9daa", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:44:\"This IP is currently blocked (81.19.130.136)\";s:17:\"seconds_remaining\";i:3439;s:16:\"blocked_attempts\";s:4:\"9073\";s:6:\"expire\";i:1484654833;}", "no");
INSERT INTO wpax_options VALUES("44358", "_transient_timeout_jpp_li_a2d6564c45aa2efd3bbd35cf53c83f8b", "1484653921", "no");
INSERT INTO wpax_options VALUES("44359", "_transient_jpp_li_a2d6564c45aa2efd3bbd35cf53c83f8b", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:41:\"This IP is currently blocked (5.141.8.96)\";s:17:\"seconds_remaining\";i:2507;s:16:\"blocked_attempts\";s:4:\"9076\";s:6:\"expire\";i:1484653921;}", "no");
INSERT INTO wpax_options VALUES("44364", "_transient_timeout_jpp_li_f48a81eb0bc0514b506b52ce644d8943", "1484654072", "no");
INSERT INTO wpax_options VALUES("44365", "_transient_jpp_li_f48a81eb0bc0514b506b52ce644d8943", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:44:\"This IP is currently blocked (31.180.223.77)\";s:17:\"seconds_remaining\";i:2619;s:16:\"blocked_attempts\";s:4:\"9079\";s:6:\"expire\";i:1484654072;}", "no");
INSERT INTO wpax_options VALUES("44371", "_transient_timeout_jpp_li_c373bf7028a9787880cea4ca5e484969", "1484652192", "no");
INSERT INTO wpax_options VALUES("44372", "_transient_jpp_li_c373bf7028a9787880cea4ca5e484969", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:43:\"This IP is currently blocked (95.70.71.166)\";s:17:\"seconds_remaining\";i:617;s:16:\"blocked_attempts\";s:4:\"9082\";s:6:\"expire\";i:1484652192;}", "no");
INSERT INTO wpax_options VALUES("44379", "_transient_timeout_jpp_li_96fc782572643c59ddfad20843e198c7", "1484652423", "no");
INSERT INTO wpax_options VALUES("44380", "_transient_jpp_li_96fc782572643c59ddfad20843e198c7", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:45:\"This IP is currently blocked (194.135.16.167)\";s:17:\"seconds_remaining\";i:633;s:16:\"blocked_attempts\";s:4:\"9085\";s:6:\"expire\";i:1484652423;}", "no");
INSERT INTO wpax_options VALUES("44386", "_transient_timeout_jpp_li_cb01ab8ff4b76037f846c084331232bc", "1484654771", "no");
INSERT INTO wpax_options VALUES("44387", "_transient_jpp_li_cb01ab8ff4b76037f846c084331232bc", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:44:\"This IP is currently blocked (94.29.124.196)\";s:17:\"seconds_remaining\";i:2957;s:16:\"blocked_attempts\";s:4:\"9087\";s:6:\"expire\";i:1484654771;}", "no");
INSERT INTO wpax_options VALUES("44392", "_transient_timeout_jpp_li_effa51ceed82c1ed3531aeb6e895ccf3", "1484654510", "no");
INSERT INTO wpax_options VALUES("44393", "_transient_jpp_li_effa51ceed82c1ed3531aeb6e895ccf3", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:44:\"This IP is currently blocked (92.37.171.250)\";s:17:\"seconds_remaining\";i:2669;s:16:\"blocked_attempts\";s:4:\"9090\";s:6:\"expire\";i:1484654510;}", "no");
INSERT INTO wpax_options VALUES("44403", "_transient_timeout_jpp_li_283432604f1046fa6e578c755efec596", "1484653229", "no");
INSERT INTO wpax_options VALUES("44404", "_transient_jpp_li_283432604f1046fa6e578c755efec596", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:45:\"This IP is currently blocked (42.145.226.174)\";s:17:\"seconds_remaining\";i:1070;s:16:\"blocked_attempts\";s:4:\"9093\";s:6:\"expire\";i:1484653229;}", "no");
INSERT INTO wpax_options VALUES("44409", "_transient_timeout_jpp_li_c9a0bc69bb9cc901154c817b82b06a6b", "1484652472", "no");
INSERT INTO wpax_options VALUES("44410", "_transient_jpp_li_c9a0bc69bb9cc901154c817b82b06a6b", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:44:\"This IP is currently blocked (105.98.225.48)\";s:17:\"seconds_remaining\";i:224;s:16:\"blocked_attempts\";s:4:\"9096\";s:6:\"expire\";i:1484652472;}", "no");
INSERT INTO wpax_options VALUES("44415", "_transient_timeout_jpp_li_fd69d011f25326e46d2d0de0dd29e663", "1484655437", "no");
INSERT INTO wpax_options VALUES("44416", "_transient_jpp_li_fd69d011f25326e46d2d0de0dd29e663", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:43:\"This IP is currently blocked (62.216.57.66)\";s:17:\"seconds_remaining\";i:3136;s:16:\"blocked_attempts\";s:4:\"9099\";s:6:\"expire\";i:1484655437;}", "no");
INSERT INTO wpax_options VALUES("44421", "_transient_timeout_jpp_li_41e6973fd66f5be4b718eebbfc6b49eb", "1484654432", "no");
INSERT INTO wpax_options VALUES("44422", "_transient_jpp_li_41e6973fd66f5be4b718eebbfc6b49eb", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:44:\"This IP is currently blocked (128.73.88.150)\";s:17:\"seconds_remaining\";i:2034;s:16:\"blocked_attempts\";s:4:\"9102\";s:6:\"expire\";i:1484654432;}", "no");
INSERT INTO wpax_options VALUES("44430", "_transient_timeout_jpp_li_504b3d2773790de218d2bbae1f3fc06b", "1484655253", "no");
INSERT INTO wpax_options VALUES("44431", "_transient_jpp_li_504b3d2773790de218d2bbae1f3fc06b", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:44:\"This IP is currently blocked (91.230.210.27)\";s:17:\"seconds_remaining\";i:2655;s:16:\"blocked_attempts\";s:4:\"9105\";s:6:\"expire\";i:1484655253;}", "no");
INSERT INTO wpax_options VALUES("44436", "_transient_timeout_jpp_li_813435908e76382b81c55fbd43083671", "1484655094", "no");
INSERT INTO wpax_options VALUES("44437", "_transient_jpp_li_813435908e76382b81c55fbd43083671", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:44:\"This IP is currently blocked (194.48.218.78)\";s:17:\"seconds_remaining\";i:2447;s:16:\"blocked_attempts\";s:4:\"9108\";s:6:\"expire\";i:1484655094;}", "no");
INSERT INTO wpax_options VALUES("44442", "_transient_timeout_jpp_li_ee9cf37afd5e368fa42ca10bf87d6e3e", "1484655464", "no");
INSERT INTO wpax_options VALUES("44443", "_transient_jpp_li_ee9cf37afd5e368fa42ca10bf87d6e3e", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:43:\"This IP is currently blocked (81.1.212.101)\";s:17:\"seconds_remaining\";i:2793;s:16:\"blocked_attempts\";s:4:\"9111\";s:6:\"expire\";i:1484655464;}", "no");
INSERT INTO wpax_options VALUES("44451", "_transient_timeout_jpp_li_49c8384291c45a39704f7d9602254e3d", "1484654059", "no");
INSERT INTO wpax_options VALUES("44452", "_transient_jpp_li_49c8384291c45a39704f7d9602254e3d", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:44:\"This IP is currently blocked (87.224.141.30)\";s:17:\"seconds_remaining\";i:1122;s:16:\"blocked_attempts\";s:4:\"9114\";s:6:\"expire\";i:1484654059;}", "no");
INSERT INTO wpax_options VALUES("44472", "_transient_timeout_jpp_li_af1b72682369d2867955cd46986710ff", "1484653836", "no");
INSERT INTO wpax_options VALUES("44473", "_transient_jpp_li_af1b72682369d2867955cd46986710ff", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:44:\"This IP is currently blocked (95.172.60.227)\";s:17:\"seconds_remaining\";i:638;s:16:\"blocked_attempts\";s:4:\"9122\";s:6:\"expire\";i:1484653836;}", "no");
INSERT INTO wpax_options VALUES("44478", "_transient_timeout_jpp_li_31e6f6ad201223c69243896444d730f6", "1484656487", "no");
INSERT INTO wpax_options VALUES("44479", "_transient_jpp_li_31e6f6ad201223c69243896444d730f6", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:44:\"This IP is currently blocked (62.176.21.131)\";s:17:\"seconds_remaining\";i:3262;s:16:\"blocked_attempts\";s:4:\"9125\";s:6:\"expire\";i:1484656487;}", "no");
INSERT INTO wpax_options VALUES("44484", "_transient_timeout_jpp_li_d760e1cc83727817f271ae5f74598a5d", "1484654912", "no");
INSERT INTO wpax_options VALUES("44485", "_transient_jpp_li_d760e1cc83727817f271ae5f74598a5d", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:45:\"This IP is currently blocked (94.242.128.185)\";s:17:\"seconds_remaining\";i:1619;s:16:\"blocked_attempts\";s:4:\"9128\";s:6:\"expire\";i:1484654912;}", "no");
INSERT INTO wpax_options VALUES("44491", "_transient_timeout_jpp_li_2552cc8869534ad15b4417c75fc58baf", "1484656097", "no");
INSERT INTO wpax_options VALUES("44492", "_transient_jpp_li_2552cc8869534ad15b4417c75fc58baf", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:45:\"This IP is currently blocked (212.109.30.174)\";s:17:\"seconds_remaining\";i:2713;s:16:\"blocked_attempts\";s:4:\"9131\";s:6:\"expire\";i:1484656097;}", "no");
INSERT INTO wpax_options VALUES("44499", "_transient_timeout_jpp_li_cfabf46f208de048e0eef7642784e734", "1484655949", "no");
INSERT INTO wpax_options VALUES("44500", "_transient_jpp_li_cfabf46f208de048e0eef7642784e734", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:44:\"This IP is currently blocked (83.149.19.147)\";s:17:\"seconds_remaining\";i:2449;s:16:\"blocked_attempts\";s:4:\"9134\";s:6:\"expire\";i:1484655949;}", "no");
INSERT INTO wpax_options VALUES("44506", "_transient_timeout_jpp_li_873b06e9e25b34ce34863b5172244540", "1484654428", "no");
INSERT INTO wpax_options VALUES("44507", "_transient_jpp_li_873b06e9e25b34ce34863b5172244540", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:45:\"This IP is currently blocked (46.236.129.182)\";s:17:\"seconds_remaining\";i:765;s:16:\"blocked_attempts\";s:4:\"9137\";s:6:\"expire\";i:1484654428;}", "no");
INSERT INTO wpax_options VALUES("44515", "_transient_timeout_jpp_li_1d66bfdb33230626c6802fc84c7fec21", "1484656808", "no");
INSERT INTO wpax_options VALUES("44516", "_transient_jpp_li_1d66bfdb33230626c6802fc84c7fec21", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:43:\"This IP is currently blocked (79.173.127.2)\";s:17:\"seconds_remaining\";i:2751;s:16:\"blocked_attempts\";s:4:\"9140\";s:6:\"expire\";i:1484656808;}", "no");
INSERT INTO wpax_options VALUES("44521", "_transient_timeout_jpp_li_7c224acc51bf4733006ee3a9ba40e2e7", "1484657144", "no");
INSERT INTO wpax_options VALUES("44522", "_transient_jpp_li_7c224acc51bf4733006ee3a9ba40e2e7", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:45:\"This IP is currently blocked (85.172.121.174)\";s:17:\"seconds_remaining\";i:3049;s:16:\"blocked_attempts\";s:4:\"9143\";s:6:\"expire\";i:1484657144;}", "no");
INSERT INTO wpax_options VALUES("44527", "_transient_timeout_jpp_li_1c2d19802c7b653d63527df8cf6cb738", "1484657417", "no");
INSERT INTO wpax_options VALUES("44528", "_transient_jpp_li_1c2d19802c7b653d63527df8cf6cb738", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:45:\"This IP is currently blocked (79.122.230.190)\";s:17:\"seconds_remaining\";i:3308;s:16:\"blocked_attempts\";s:4:\"9146\";s:6:\"expire\";i:1484657417;}", "no");
INSERT INTO wpax_options VALUES("44534", "_transient_timeout_jpp_li_f3b5b659a61a52f59c82defc46559460", "1484656713", "no");
INSERT INTO wpax_options VALUES("44535", "_transient_jpp_li_f3b5b659a61a52f59c82defc46559460", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:43:\"This IP is currently blocked (178.69.153.6)\";s:17:\"seconds_remaining\";i:2464;s:16:\"blocked_attempts\";s:4:\"9149\";s:6:\"expire\";i:1484656713;}", "no");
INSERT INTO wpax_options VALUES("44542", "_transient_timeout_jpp_li_d24edf350f98ae1b7fd6aed3cf1b9f6c", "1484654921", "no");
INSERT INTO wpax_options VALUES("44543", "_transient_jpp_li_d24edf350f98ae1b7fd6aed3cf1b9f6c", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:43:\"This IP is currently blocked (80.70.106.76)\";s:17:\"seconds_remaining\";i:527;s:16:\"blocked_attempts\";s:4:\"9152\";s:6:\"expire\";i:1484654921;}", "no");
INSERT INTO wpax_options VALUES("44556", "_transient_timeout_jpp_li_39fbb5cec5e8f0cb4fb32d2b4d57112f", "1484657822", "no");
INSERT INTO wpax_options VALUES("44557", "_transient_jpp_li_39fbb5cec5e8f0cb4fb32d2b4d57112f", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:42:\"This IP is currently blocked (77.40.52.35)\";s:17:\"seconds_remaining\";i:3019;s:16:\"blocked_attempts\";s:4:\"9157\";s:6:\"expire\";i:1484657822;}", "no");
INSERT INTO wpax_options VALUES("44558", "_transient_timeout_jpp_li_61fe24bc05d17497f7253a68a47e0e6d", "1484658133", "no");
INSERT INTO wpax_options VALUES("44559", "_transient_jpp_li_61fe24bc05d17497f7253a68a47e0e6d", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:43:\"This IP is currently blocked (77.244.21.46)\";s:17:\"seconds_remaining\";i:3328;s:16:\"blocked_attempts\";s:4:\"9158\";s:6:\"expire\";i:1484658133;}", "no");
INSERT INTO wpax_options VALUES("44565", "_transient_timeout_jpp_li_c24dac51b70ec239e7bb9d5bff110e2d", "1484658565", "no");
INSERT INTO wpax_options VALUES("44566", "_transient_jpp_li_c24dac51b70ec239e7bb9d5bff110e2d", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:46:\"This IP is currently blocked (136.169.133.209)\";s:17:\"seconds_remaining\";i:3588;s:16:\"blocked_attempts\";s:4:\"9161\";s:6:\"expire\";i:1484658565;}", "no");
INSERT INTO wpax_options VALUES("44571", "_transient_timeout_jpp_li_fa9f2b7108b5b5a15978c7de4573838a", "1484655814", "no");
INSERT INTO wpax_options VALUES("44572", "_transient_jpp_li_fa9f2b7108b5b5a15978c7de4573838a", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:44:\"This IP is currently blocked (188.243.89.46)\";s:17:\"seconds_remaining\";i:815;s:16:\"blocked_attempts\";s:4:\"9164\";s:6:\"expire\";i:1484655814;}", "no");
INSERT INTO wpax_options VALUES("44586", "_transient_timeout_jpp_li_a19b77f286a347c775946b14c88a5ac0", "1484657755", "no");
INSERT INTO wpax_options VALUES("44587", "_transient_jpp_li_a19b77f286a347c775946b14c88a5ac0", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:45:\"This IP is currently blocked (91.144.149.126)\";s:17:\"seconds_remaining\";i:2497;s:16:\"blocked_attempts\";s:4:\"9170\";s:6:\"expire\";i:1484657755;}", "no");
INSERT INTO wpax_options VALUES("44614", "_transient_timeout_jpp_li_35e42f1524a0f5f0d85e070a1bcccb79", "1484658182", "no");
INSERT INTO wpax_options VALUES("44615", "_transient_jpp_li_35e42f1524a0f5f0d85e070a1bcccb79", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:45:\"This IP is currently blocked (94.180.160.110)\";s:17:\"seconds_remaining\";i:2456;s:16:\"blocked_attempts\";s:4:\"9182\";s:6:\"expire\";i:1484658182;}", "no");
INSERT INTO wpax_options VALUES("44620", "_transient_timeout_jpp_li_37401c784687b9036994c10ab9471db7", "1484657855", "no");
INSERT INTO wpax_options VALUES("44621", "_transient_jpp_li_37401c784687b9036994c10ab9471db7", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:46:\"This IP is currently blocked (176.125.103.141)\";s:17:\"seconds_remaining\";i:2050;s:16:\"blocked_attempts\";s:4:\"9185\";s:6:\"expire\";i:1484657855;}", "no");
INSERT INTO wpax_options VALUES("44630", "_transient_timeout_jpp_li_062076e4611b2fc38980a7603e6d8946", "1484659391", "no");
INSERT INTO wpax_options VALUES("44631", "_transient_jpp_li_062076e4611b2fc38980a7603e6d8946", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:42:\"This IP is currently blocked (94.125.3.81)\";s:17:\"seconds_remaining\";i:3414;s:16:\"blocked_attempts\";s:4:\"9188\";s:6:\"expire\";i:1484659391;}", "no");
INSERT INTO wpax_options VALUES("44637", "_transient_timeout_jpp_li_af4934f5a2197f7f09bceacb9040f890", "1484659267", "no");
INSERT INTO wpax_options VALUES("44638", "_transient_jpp_li_af4934f5a2197f7f09bceacb9040f890", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:44:\"This IP is currently blocked (95.79.107.105)\";s:17:\"seconds_remaining\";i:3198;s:16:\"blocked_attempts\";s:4:\"9191\";s:6:\"expire\";i:1484659267;}", "no");
INSERT INTO wpax_options VALUES("44651", "_transient_timeout_jpp_li_0a274089217f3121bf29c24f784876ad", "1484658422", "no");
INSERT INTO wpax_options VALUES("44652", "_transient_jpp_li_0a274089217f3121bf29c24f784876ad", "a:5:{s:6:\"status\";s:12:\"blocked-hard\";s:3:\"msg\";s:43:\"This IP is currently blocked (176.97.36.65)\";s:17:\"seconds_remaining\";i:1718;s:16:\"blocked_attempts\";s:4:\"9195\";s:6:\"expire\";i:1484658422;}", "no");
INSERT INTO wpax_options VALUES("44657", "_transient_timeout_jpp_li_f5a0c31ab1d3fcab913fd086c58e58c0", "1484660140", "no");
INSERT INTO wpax_options VALUES("44658", "_transient_jpp_li_f5a0c31ab1d3fcab913fd086c58e58c0", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:44:\"This IP is currently blocked (83.149.46.242)\";s:17:\"seconds_remaining\";i:3418;s:16:\"blocked_attempts\";s:4:\"9198\";s:6:\"expire\";i:1484660140;}", "no");
INSERT INTO wpax_options VALUES("44669", "_site_transient_update_themes", "O:8:\"stdClass\":4:{s:12:\"last_checked\";i:1484685528;s:7:\"checked\";a:6:{s:9:\"allegiant\";s:5:\"1.0.8\";s:8:\"fruitful\";s:5:\"3.3.1\";s:5:\"illdy\";s:6:\"1.0.35\";s:13:\"twentyfifteen\";s:3:\"1.7\";s:15:\"twentyseventeen\";s:3:\"1.0\";s:13:\"twentysixteen\";s:3:\"1.3\";}s:8:\"response\";a:2:{s:5:\"illdy\";a:4:{s:5:\"theme\";s:5:\"illdy\";s:11:\"new_version\";s:8:\"1.0.35.2\";s:3:\"url\";s:35:\"https://wordpress.org/themes/illdy/\";s:7:\"package\";s:56:\"https://downloads.wordpress.org/theme/illdy.1.0.35.2.zip\";}s:15:\"twentyseventeen\";a:4:{s:5:\"theme\";s:15:\"twentyseventeen\";s:11:\"new_version\";s:3:\"1.1\";s:3:\"url\";s:45:\"https://wordpress.org/themes/twentyseventeen/\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/theme/twentyseventeen.1.1.zip\";}}s:12:\"translations\";a:0:{}}", "no");
INSERT INTO wpax_options VALUES("44679", "_transient_timeout_jpp_li_5662297551e00f5f52df79d4ab5141eb", "1484660068", "no");
INSERT INTO wpax_options VALUES("44680", "_transient_jpp_li_5662297551e00f5f52df79d4ab5141eb", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:43:\"This IP is currently blocked (176.59.3.206)\";s:17:\"seconds_remaining\";i:3196;s:16:\"blocked_attempts\";s:4:\"9201\";s:6:\"expire\";i:1484660068;}", "no");
INSERT INTO wpax_options VALUES("44691", "_transient_timeout_jpp_li_c1a6a3ae354bc252d233128958dd01ac", "1484660640", "no");
INSERT INTO wpax_options VALUES("44692", "_transient_jpp_li_c1a6a3ae354bc252d233128958dd01ac", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:43:\"This IP is currently blocked (188.230.5.69)\";s:17:\"seconds_remaining\";i:3348;s:16:\"blocked_attempts\";s:4:\"9204\";s:6:\"expire\";i:1484660640;}", "no");
INSERT INTO wpax_options VALUES("44699", "_transient_timeout_jpp_li_036b761af7d306878e7ca65590d07cbd", "1484659074", "no");
INSERT INTO wpax_options VALUES("44700", "_transient_jpp_li_036b761af7d306878e7ca65590d07cbd", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:44:\"This IP is currently blocked (195.26.31.156)\";s:17:\"seconds_remaining\";i:1698;s:16:\"blocked_attempts\";s:4:\"9207\";s:6:\"expire\";i:1484659074;}", "no");
INSERT INTO wpax_options VALUES("44706", "_transient_timeout_jpp_li_62d03ac1cd2acd0dc12793b6d8ebb719", "1484659724", "no");
INSERT INTO wpax_options VALUES("44707", "_transient_jpp_li_62d03ac1cd2acd0dc12793b6d8ebb719", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:42:\"This IP is currently blocked (85.140.2.68)\";s:17:\"seconds_remaining\";i:2256;s:16:\"blocked_attempts\";s:4:\"9210\";s:6:\"expire\";i:1484659724;}", "no");
INSERT INTO wpax_options VALUES("44713", "_transient_timeout_jpp_li_e44e2ad032853cba5d3cfb714649225b", "1484659882", "no");
INSERT INTO wpax_options VALUES("44714", "_transient_jpp_li_e44e2ad032853cba5d3cfb714649225b", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:44:\"This IP is currently blocked (85.113.34.186)\";s:17:\"seconds_remaining\";i:2353;s:16:\"blocked_attempts\";s:4:\"9213\";s:6:\"expire\";i:1484659882;}", "no");
INSERT INTO wpax_options VALUES("44728", "_transient_timeout_jpp_li_7d5fc316d8236da42d57afa9474ac629", "1484658600", "no");
INSERT INTO wpax_options VALUES("44729", "_transient_jpp_li_7d5fc316d8236da42d57afa9474ac629", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:43:\"This IP is currently blocked (91.215.79.47)\";s:17:\"seconds_remaining\";i:735;s:16:\"blocked_attempts\";s:4:\"9219\";s:6:\"expire\";i:1484658600;}", "no");
INSERT INTO wpax_options VALUES("44734", "_transient_timeout_jpp_li_c87d910ae0dfd170b9be9686bf500f05", "1484660497", "no");
INSERT INTO wpax_options VALUES("44735", "_transient_jpp_li_c87d910ae0dfd170b9be9686bf500f05", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:43:\"This IP is currently blocked (83.221.10.37)\";s:17:\"seconds_remaining\";i:2600;s:16:\"blocked_attempts\";s:4:\"9222\";s:6:\"expire\";i:1484660497;}", "no");
INSERT INTO wpax_options VALUES("44740", "_transient_timeout_jpp_li_e6949878a20d04d2173b6fccf63473a7", "1484661093", "no");
INSERT INTO wpax_options VALUES("44741", "_transient_jpp_li_e6949878a20d04d2173b6fccf63473a7", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:43:\"This IP is currently blocked (79.120.80.50)\";s:17:\"seconds_remaining\";i:3176;s:16:\"blocked_attempts\";s:4:\"9225\";s:6:\"expire\";i:1484661093;}", "no");
INSERT INTO wpax_options VALUES("44746", "_transient_timeout_jpp_li_b66f6526e63ce5b4761c29eba05bb974", "1484660497", "no");
INSERT INTO wpax_options VALUES("44747", "_transient_jpp_li_b66f6526e63ce5b4761c29eba05bb974", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:44:\"This IP is currently blocked (92.39.141.218)\";s:17:\"seconds_remaining\";i:2483;s:16:\"blocked_attempts\";s:4:\"9228\";s:6:\"expire\";i:1484660497;}", "no");
INSERT INTO wpax_options VALUES("44753", "_transient_timeout_jpp_li_4a309259cbd1e608473a5d11afbeb747", "1484660916", "no");
INSERT INTO wpax_options VALUES("44754", "_transient_jpp_li_4a309259cbd1e608473a5d11afbeb747", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:45:\"This IP is currently blocked (85.174.201.103)\";s:17:\"seconds_remaining\";i:2801;s:16:\"blocked_attempts\";s:4:\"9231\";s:6:\"expire\";i:1484660916;}", "no");
INSERT INTO wpax_options VALUES("44772", "_transient_timeout_jpp_li_aaa5408de9a689e11cadf5473f280246", "1484658498", "no");
INSERT INTO wpax_options VALUES("44773", "_transient_jpp_li_aaa5408de9a689e11cadf5473f280246", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:45:\"This IP is currently blocked (91.233.173.162)\";s:17:\"seconds_remaining\";i:94;s:16:\"blocked_attempts\";s:4:\"9239\";s:6:\"expire\";i:1484658498;}", "no");
INSERT INTO wpax_options VALUES("44775", "_transient_timeout_jpp_li_27affba2c69feb9a1bfae7ba65e8f1ec", "1484661625", "no");
INSERT INTO wpax_options VALUES("44776", "_transient_jpp_li_27affba2c69feb9a1bfae7ba65e8f1ec", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:45:\"This IP is currently blocked (31.132.160.196)\";s:17:\"seconds_remaining\";i:3218;s:16:\"blocked_attempts\";s:4:\"9240\";s:6:\"expire\";i:1484661625;}", "no");
INSERT INTO wpax_options VALUES("44781", "_transient_timeout_jpp_li_f140e0716843c641ce12a0e3bd583e06", "1484660398", "no");
INSERT INTO wpax_options VALUES("44782", "_transient_jpp_li_f140e0716843c641ce12a0e3bd583e06", "a:5:{s:6:\"status\";s:12:\"blocked-hard\";s:3:\"msg\";s:44:\"This IP is currently blocked (31.173.241.18)\";s:17:\"seconds_remaining\";i:1910;s:16:\"blocked_attempts\";s:4:\"9243\";s:6:\"expire\";i:1484660398;}", "no");
INSERT INTO wpax_options VALUES("44783", "_transient_timeout_jpp_li_f5cf7b12a0a36e74a07cd820052c1db7", "1484658848", "no");
INSERT INTO wpax_options VALUES("44784", "_transient_jpp_li_f5cf7b12a0a36e74a07cd820052c1db7", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:43:\"This IP is currently blocked (62.33.49.153)\";s:17:\"seconds_remaining\";i:358;s:16:\"blocked_attempts\";s:4:\"9244\";s:6:\"expire\";i:1484658848;}", "no");
INSERT INTO wpax_options VALUES("44798", "_transient_timeout_jpp_li_561267ae12bfd5a166d069d7e766f671", "1484661593", "no");
INSERT INTO wpax_options VALUES("44799", "_transient_jpp_li_561267ae12bfd5a166d069d7e766f671", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:45:\"This IP is currently blocked (217.66.158.176)\";s:17:\"seconds_remaining\";i:2863;s:16:\"blocked_attempts\";s:4:\"9250\";s:6:\"expire\";i:1484661593;}", "no");
INSERT INTO wpax_options VALUES("44804", "_transient_timeout_jpp_li_d2c356f74164f7d93fa57f0e2b04ebae", "1484659587", "no");
INSERT INTO wpax_options VALUES("44805", "_transient_jpp_li_d2c356f74164f7d93fa57f0e2b04ebae", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:44:\"This IP is currently blocked (83.149.19.129)\";s:17:\"seconds_remaining\";i:795;s:16:\"blocked_attempts\";s:4:\"9253\";s:6:\"expire\";i:1484659587;}", "no");
INSERT INTO wpax_options VALUES("44810", "_transient_timeout_jpp_li_ef09c68a613e7744ed4b87dfdac7d7ba", "1484660500", "no");
INSERT INTO wpax_options VALUES("44811", "_transient_jpp_li_ef09c68a613e7744ed4b87dfdac7d7ba", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:44:\"This IP is currently blocked (188.65.236.89)\";s:17:\"seconds_remaining\";i:1582;s:16:\"blocked_attempts\";s:4:\"9256\";s:6:\"expire\";i:1484660500;}", "no");
INSERT INTO wpax_options VALUES("44819", "_transient_timeout_jpp_li_dba6096383f2c931e1727a6e95dcfbfe", "1484661241", "no");
INSERT INTO wpax_options VALUES("44820", "_transient_jpp_li_dba6096383f2c931e1727a6e95dcfbfe", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:43:\"This IP is currently blocked (62.231.31.86)\";s:17:\"seconds_remaining\";i:2143;s:16:\"blocked_attempts\";s:4:\"9259\";s:6:\"expire\";i:1484661241;}", "no");
INSERT INTO wpax_options VALUES("44825", "_transient_timeout_jpp_li_84b625320d07f0dba37125bc9bf8ceec", "1484659773", "no");
INSERT INTO wpax_options VALUES("44826", "_transient_jpp_li_84b625320d07f0dba37125bc9bf8ceec", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:46:\"This IP is currently blocked (217.107.106.221)\";s:17:\"seconds_remaining\";i:552;s:16:\"blocked_attempts\";s:4:\"9262\";s:6:\"expire\";i:1484659773;}", "no");
INSERT INTO wpax_options VALUES("44832", "_transient_timeout_jpp_li_c28ac44985102151b668362044f20e1e", "1484659871", "no");
INSERT INTO wpax_options VALUES("44833", "_transient_jpp_li_c28ac44985102151b668362044f20e1e", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:45:\"This IP is currently blocked (94.228.244.175)\";s:17:\"seconds_remaining\";i:544;s:16:\"blocked_attempts\";s:4:\"9265\";s:6:\"expire\";i:1484659871;}", "no");
INSERT INTO wpax_options VALUES("44838", "_transient_timeout_jpp_li_b9a4c6aee69c97d6560910a9f494005c", "1484662301", "no");
INSERT INTO wpax_options VALUES("44839", "_transient_jpp_li_b9a4c6aee69c97d6560910a9f494005c", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:43:\"This IP is currently blocked (95.78.83.158)\";s:17:\"seconds_remaining\";i:2913;s:16:\"blocked_attempts\";s:4:\"9268\";s:6:\"expire\";i:1484662301;}", "no");
INSERT INTO wpax_options VALUES("44855", "_transient_timeout_jpp_li_2e5adc6b4fae99cfce43ee6f84331ea0", "1484661895", "no");
INSERT INTO wpax_options VALUES("44856", "_transient_jpp_li_2e5adc6b4fae99cfce43ee6f84331ea0", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:45:\"This IP is currently blocked (95.191.207.175)\";s:17:\"seconds_remaining\";i:2213;s:16:\"blocked_attempts\";s:4:\"9274\";s:6:\"expire\";i:1484661895;}", "no");
INSERT INTO wpax_options VALUES("44861", "_transient_timeout_jpp_li_6df186a63435047c7bb014d793336d49", "1484662221", "no");
INSERT INTO wpax_options VALUES("44862", "_transient_jpp_li_6df186a63435047c7bb014d793336d49", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:46:\"This IP is currently blocked (193.106.163.113)\";s:17:\"seconds_remaining\";i:2525;s:16:\"blocked_attempts\";s:4:\"9277\";s:6:\"expire\";i:1484662221;}", "no");
INSERT INTO wpax_options VALUES("44878", "_transient_timeout_jpp_li_68e19de1b9a62d0ced188fa2e350489b", "1484662890", "no");
INSERT INTO wpax_options VALUES("44879", "_transient_jpp_li_68e19de1b9a62d0ced188fa2e350489b", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:45:\"This IP is currently blocked (37.235.163.129)\";s:17:\"seconds_remaining\";i:2761;s:16:\"blocked_attempts\";s:4:\"9283\";s:6:\"expire\";i:1484662890;}", "no");
INSERT INTO wpax_options VALUES("44885", "_transient_timeout_jpp_li_ba9e78aa76321ca1e7981e9e47c0ac38", "1484660409", "no");
INSERT INTO wpax_options VALUES("44886", "_transient_jpp_li_ba9e78aa76321ca1e7981e9e47c0ac38", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:43:\"This IP is currently blocked (85.95.187.35)\";s:17:\"seconds_remaining\";i:135;s:16:\"blocked_attempts\";s:4:\"9286\";s:6:\"expire\";i:1484660409;}", "no");
INSERT INTO wpax_options VALUES("44894", "_transient_timeout_jpp_li_584ca2c7338c72062eae110e54ad78e1", "1484661886", "no");
INSERT INTO wpax_options VALUES("44895", "_transient_jpp_li_584ca2c7338c72062eae110e54ad78e1", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:44:\"This IP is currently blocked (77.37.162.135)\";s:17:\"seconds_remaining\";i:1357;s:16:\"blocked_attempts\";s:4:\"9289\";s:6:\"expire\";i:1484661886;}", "no");
INSERT INTO wpax_options VALUES("44903", "_transient_timeout_jpp_li_1cec18ff2b85d567a165cb7bea2bd039", "1484663289", "no");
INSERT INTO wpax_options VALUES("44904", "_transient_jpp_li_1cec18ff2b85d567a165cb7bea2bd039", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:44:\"This IP is currently blocked (37.247.92.239)\";s:17:\"seconds_remaining\";i:2432;s:16:\"blocked_attempts\";s:4:\"9292\";s:6:\"expire\";i:1484663289;}", "no");
INSERT INTO wpax_options VALUES("44910", "_transient_timeout_jpp_li_ff7379a9001c491f43583edb66dab815", "1484661754", "no");
INSERT INTO wpax_options VALUES("44911", "_transient_jpp_li_ff7379a9001c491f43583edb66dab815", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:44:\"This IP is currently blocked (31.134.29.202)\";s:17:\"seconds_remaining\";i:733;s:16:\"blocked_attempts\";s:4:\"9295\";s:6:\"expire\";i:1484661754;}", "no");
INSERT INTO wpax_options VALUES("44916", "_transient_timeout_jpp_li_64d9cf879775ccd40c5ea1c5bfab54f4", "1484664169", "no");
INSERT INTO wpax_options VALUES("44917", "_transient_jpp_li_64d9cf879775ccd40c5ea1c5bfab54f4", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:43:\"This IP is currently blocked (185.11.49.52)\";s:17:\"seconds_remaining\";i:3080;s:16:\"blocked_attempts\";s:4:\"9298\";s:6:\"expire\";i:1484664169;}", "no");
INSERT INTO wpax_options VALUES("44925", "_transient_timeout_jetpack-testimonial-count-cache", "1484704406", "no");
INSERT INTO wpax_options VALUES("44926", "_transient_jetpack-testimonial-count-cache", "3", "no");
INSERT INTO wpax_options VALUES("44927", "_transient_timeout_jpp_li_ccfa9c697c1911e2e2e2e4213e364c4b", "1484664294", "no");
INSERT INTO wpax_options VALUES("44928", "_transient_jpp_li_ccfa9c697c1911e2e2e2e4213e364c4b", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:44:\"This IP is currently blocked (188.191.21.63)\";s:17:\"seconds_remaining\";i:3082;s:16:\"blocked_attempts\";s:4:\"9301\";s:6:\"expire\";i:1484664294;}", "no");
INSERT INTO wpax_options VALUES("44933", "_transient_timeout_jpp_li_73e44b70bd50b9cf671b33f437b35cb1", "1484663170", "no");
INSERT INTO wpax_options VALUES("44934", "_transient_jpp_li_73e44b70bd50b9cf671b33f437b35cb1", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:45:\"This IP is currently blocked (94.127.217.203)\";s:17:\"seconds_remaining\";i:1900;s:16:\"blocked_attempts\";s:4:\"9304\";s:6:\"expire\";i:1484663170;}", "no");
INSERT INTO wpax_options VALUES("44939", "_transient_timeout_jpp_li_63b2785a1f361ba97ff441e2447298ac", "1484663533", "no");
INSERT INTO wpax_options VALUES("44940", "_transient_jpp_li_63b2785a1f361ba97ff441e2447298ac", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:44:\"This IP is currently blocked (31.28.213.216)\";s:17:\"seconds_remaining\";i:2189;s:16:\"blocked_attempts\";s:4:\"9307\";s:6:\"expire\";i:1484663533;}", "no");
INSERT INTO wpax_options VALUES("44956", "_transient_timeout_jpp_li_dc3ee2299399898b61c794b7d3071f61", "1484664145", "no");
INSERT INTO wpax_options VALUES("44957", "_transient_jpp_li_dc3ee2299399898b61c794b7d3071f61", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:44:\"This IP is currently blocked (213.138.93.83)\";s:17:\"seconds_remaining\";i:2644;s:16:\"blocked_attempts\";s:4:\"9312\";s:6:\"expire\";i:1484664145;}", "no");
INSERT INTO wpax_options VALUES("44962", "_transient_timeout_jpp_li_8668b32225478484b354fe7aea99597b", "1484662014", "no");
INSERT INTO wpax_options VALUES("44963", "_transient_jpp_li_8668b32225478484b354fe7aea99597b", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:44:\"This IP is currently blocked (93.48.240.248)\";s:17:\"seconds_remaining\";i:407;s:16:\"blocked_attempts\";s:4:\"9315\";s:6:\"expire\";i:1484662014;}", "no");
INSERT INTO wpax_options VALUES("44983", "_transient_timeout_jpp_li_ef6340523272a95cbaf5cf7a94c0cebc", "1484665497", "no");
INSERT INTO wpax_options VALUES("44984", "_transient_jpp_li_ef6340523272a95cbaf5cf7a94c0cebc", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:45:\"This IP is currently blocked (195.245.214.57)\";s:17:\"seconds_remaining\";i:3157;s:16:\"blocked_attempts\";s:4:\"9321\";s:6:\"expire\";i:1484665497;}", "no");
INSERT INTO wpax_options VALUES("44991", "_transient_timeout_jpp_li_4cbbb2be4697931657c689273b6ba10b", "1484663489", "no");
INSERT INTO wpax_options VALUES("44992", "_transient_jpp_li_4cbbb2be4697931657c689273b6ba10b", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:44:\"This IP is currently blocked (5.100.112.141)\";s:17:\"seconds_remaining\";i:985;s:16:\"blocked_attempts\";s:4:\"9324\";s:6:\"expire\";i:1484663489;}", "no");
INSERT INTO wpax_options VALUES("45000", "_transient_timeout_jetpack_is_single_user", "1484705841", "no");
INSERT INTO wpax_options VALUES("45001", "_transient_jetpack_is_single_user", "2", "no");
INSERT INTO wpax_options VALUES("45002", "_transient_timeout_jpp_li_406ab04a62e5dd4aef1150d0d60def07", "1484665831", "no");
INSERT INTO wpax_options VALUES("45003", "_transient_jpp_li_406ab04a62e5dd4aef1150d0d60def07", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:44:\"This IP is currently blocked (62.94.206.158)\";s:17:\"seconds_remaining\";i:3189;s:16:\"blocked_attempts\";s:4:\"9327\";s:6:\"expire\";i:1484665831;}", "no");
INSERT INTO wpax_options VALUES("45010", "_transient_timeout_jpp_li_3e8d539699104b188659c40bc565f113", "1484663735", "no");
INSERT INTO wpax_options VALUES("45011", "_transient_jpp_li_3e8d539699104b188659c40bc565f113", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:45:\"This IP is currently blocked (188.254.43.218)\";s:17:\"seconds_remaining\";i:1060;s:16:\"blocked_attempts\";s:4:\"9330\";s:6:\"expire\";i:1484663735;}", "no");
INSERT INTO wpax_options VALUES("45027", "_transient_timeout_jpp_li_0a7215216d5f82da824108c86e17e4d3", "1484665815", "no");
INSERT INTO wpax_options VALUES("45028", "_transient_jpp_li_0a7215216d5f82da824108c86e17e4d3", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:41:\"This IP is currently blocked (37.78.2.86)\";s:17:\"seconds_remaining\";i:3085;s:16:\"blocked_attempts\";s:4:\"9336\";s:6:\"expire\";i:1484665815;}", "no");
INSERT INTO wpax_options VALUES("45036", "_transient_timeout_jpp_li_263d8d80c361fcfb3ffe31170f135c1b", "1484666242", "no");
INSERT INTO wpax_options VALUES("45037", "_transient_jpp_li_263d8d80c361fcfb3ffe31170f135c1b", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:42:\"This IP is currently blocked (37.78.38.80)\";s:17:\"seconds_remaining\";i:3179;s:16:\"blocked_attempts\";s:4:\"9339\";s:6:\"expire\";i:1484666242;}", "no");
INSERT INTO wpax_options VALUES("45042", "_transient_timeout_jpp_li_eebcb8eb79d6dac439745667ddd362f3", "1484666338", "no");
INSERT INTO wpax_options VALUES("45043", "_transient_jpp_li_eebcb8eb79d6dac439745667ddd362f3", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:43:\"This IP is currently blocked (5.142.117.87)\";s:17:\"seconds_remaining\";i:3264;s:16:\"blocked_attempts\";s:4:\"9342\";s:6:\"expire\";i:1484666338;}", "no");
INSERT INTO wpax_options VALUES("45048", "_transient_timeout_jpp_li_b46cc61ca6cbd6c7e200e394d831d062", "1484665701", "no");
INSERT INTO wpax_options VALUES("45049", "_transient_jpp_li_b46cc61ca6cbd6c7e200e394d831d062", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:44:\"This IP is currently blocked (46.39.230.216)\";s:17:\"seconds_remaining\";i:2598;s:16:\"blocked_attempts\";s:4:\"9345\";s:6:\"expire\";i:1484665701;}", "no");
INSERT INTO wpax_options VALUES("45056", "_transient_timeout_jpp_li_f644a33ac42efca41f19a42e58146fd1", "1484665449", "no");
INSERT INTO wpax_options VALUES("45057", "_transient_jpp_li_f644a33ac42efca41f19a42e58146fd1", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:43:\"This IP is currently blocked (93.80.21.210)\";s:17:\"seconds_remaining\";i:2339;s:16:\"blocked_attempts\";s:4:\"9348\";s:6:\"expire\";i:1484665449;}", "no");
INSERT INTO wpax_options VALUES("45062", "_transient_timeout_jpp_li_278463fe46fdb48e2b5a074798b28a51", "1484665688", "no");
INSERT INTO wpax_options VALUES("45063", "_transient_jpp_li_278463fe46fdb48e2b5a074798b28a51", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:44:\"This IP is currently blocked (78.156.247.38)\";s:17:\"seconds_remaining\";i:2546;s:16:\"blocked_attempts\";s:4:\"9351\";s:6:\"expire\";i:1484665688;}", "no");
INSERT INTO wpax_options VALUES("45073", "_transient_timeout_jpp_li_63a53300028ab32d5ae845008b3abf54", "1484664017", "no");
INSERT INTO wpax_options VALUES("45074", "_transient_jpp_li_63a53300028ab32d5ae845008b3abf54", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:46:\"This IP is currently blocked (178.248.150.196)\";s:17:\"seconds_remaining\";i:530;s:16:\"blocked_attempts\";s:4:\"9354\";s:6:\"expire\";i:1484664017;}", "no");
INSERT INTO wpax_options VALUES("45080", "_transient_timeout_jpp_li_a094ce25eb0a5f5e59005c63997f94e1", "1484666770", "no");
INSERT INTO wpax_options VALUES("45081", "_transient_jpp_li_a094ce25eb0a5f5e59005c63997f94e1", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:43:\"This IP is currently blocked (77.45.202.98)\";s:17:\"seconds_remaining\";i:3197;s:16:\"blocked_attempts\";s:4:\"9357\";s:6:\"expire\";i:1484666770;}", "no");
INSERT INTO wpax_options VALUES("45086", "_transient_timeout_jpp_li_7809db7820105964fe2fc2237a8dbfef", "1484666506", "no");
INSERT INTO wpax_options VALUES("45087", "_transient_jpp_li_7809db7820105964fe2fc2237a8dbfef", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:44:\"This IP is currently blocked (176.51.48.100)\";s:17:\"seconds_remaining\";i:2922;s:16:\"blocked_attempts\";s:4:\"9360\";s:6:\"expire\";i:1484666506;}", "no");
INSERT INTO wpax_options VALUES("45094", "_transient_timeout_jpp_li_abb6a63ce60466aba2b6f4a155a2ff1a", "1484666335", "no");
INSERT INTO wpax_options VALUES("45095", "_transient_jpp_li_abb6a63ce60466aba2b6f4a155a2ff1a", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:44:\"This IP is currently blocked (217.9.156.250)\";s:17:\"seconds_remaining\";i:2704;s:16:\"blocked_attempts\";s:4:\"9363\";s:6:\"expire\";i:1484666335;}", "no");
INSERT INTO wpax_options VALUES("45100", "_transient_timeout_jpp_li_3bd1745ffc217d102b1b11b2cd25d174", "1484666358", "no");
INSERT INTO wpax_options VALUES("45101", "_transient_jpp_li_3bd1745ffc217d102b1b11b2cd25d174", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:44:\"This IP is currently blocked (62.176.14.197)\";s:17:\"seconds_remaining\";i:2659;s:16:\"blocked_attempts\";s:4:\"9366\";s:6:\"expire\";i:1484666358;}", "no");
INSERT INTO wpax_options VALUES("45118", "_transient_timeout_jpp_li_4647d93078141732dd755a8f18bdbc2b", "1484667487", "no");
INSERT INTO wpax_options VALUES("45119", "_transient_jpp_li_4647d93078141732dd755a8f18bdbc2b", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:44:\"This IP is currently blocked (212.3.146.186)\";s:17:\"seconds_remaining\";i:3131;s:16:\"blocked_attempts\";s:4:\"9372\";s:6:\"expire\";i:1484667487;}", "no");
INSERT INTO wpax_options VALUES("45125", "_transient_timeout_jpp_li_8f74aa4696e30d17dd2913a816720db6", "1484666513", "no");
INSERT INTO wpax_options VALUES("45126", "_transient_jpp_li_8f74aa4696e30d17dd2913a816720db6", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:44:\"This IP is currently blocked (77.66.146.104)\";s:17:\"seconds_remaining\";i:1959;s:16:\"blocked_attempts\";s:4:\"9375\";s:6:\"expire\";i:1484666513;}", "no");
INSERT INTO wpax_options VALUES("45140", "_transient_timeout_jpp_li_a889d8006f46d2b9896e0b2692fc8aed", "1484664841", "no");
INSERT INTO wpax_options VALUES("45141", "_transient_jpp_li_a889d8006f46d2b9896e0b2692fc8aed", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:44:\"This IP is currently blocked (83.174.249.86)\";s:17:\"seconds_remaining\";i:37;s:16:\"blocked_attempts\";s:4:\"9381\";s:6:\"expire\";i:1484664841;}", "no");
INSERT INTO wpax_options VALUES("45146", "_transient_timeout_jpp_li_d68a95eee5cf7ed624bfa1f79b73a0c2", "1484667774", "no");
INSERT INTO wpax_options VALUES("45147", "_transient_jpp_li_d68a95eee5cf7ed624bfa1f79b73a0c2", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:45:\"This IP is currently blocked (195.88.112.122)\";s:17:\"seconds_remaining\";i:2961;s:16:\"blocked_attempts\";s:4:\"9384\";s:6:\"expire\";i:1484667774;}", "no");
INSERT INTO wpax_options VALUES("45152", "_transient_timeout_jpp_li_7226102de1870ecad08a5a2083454788", "1484668253", "no");
INSERT INTO wpax_options VALUES("45153", "_transient_jpp_li_7226102de1870ecad08a5a2083454788", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:45:\"This IP is currently blocked (176.32.182.230)\";s:17:\"seconds_remaining\";i:3370;s:16:\"blocked_attempts\";s:4:\"9387\";s:6:\"expire\";i:1484668253;}", "no");
INSERT INTO wpax_options VALUES("45158", "_transient_timeout_jpp_li_2bbadd52667686ad002e23ed63e51977", "1484667434", "no");
INSERT INTO wpax_options VALUES("45159", "_transient_jpp_li_2bbadd52667686ad002e23ed63e51977", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:43:\"This IP is currently blocked (46.98.125.71)\";s:17:\"seconds_remaining\";i:2484;s:16:\"blocked_attempts\";s:4:\"9390\";s:6:\"expire\";i:1484667434;}", "no");
INSERT INTO wpax_options VALUES("45164", "_transient_timeout_jpp_li_56d3ad3cb94abe6d33cec420a808f6d3", "1484665780", "no");
INSERT INTO wpax_options VALUES("45165", "_transient_jpp_li_56d3ad3cb94abe6d33cec420a808f6d3", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:46:\"This IP is currently blocked (178.207.139.153)\";s:17:\"seconds_remaining\";i:807;s:16:\"blocked_attempts\";s:4:\"9393\";s:6:\"expire\";i:1484665780;}", "no");
INSERT INTO wpax_options VALUES("45175", "_transient_timeout_jpp_li_5234e5ab80937c9da8caadfe884f3eff", "1484668608", "no");
INSERT INTO wpax_options VALUES("45176", "_transient_jpp_li_5234e5ab80937c9da8caadfe884f3eff", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:45:\"This IP is currently blocked (217.112.98.171)\";s:17:\"seconds_remaining\";i:3455;s:16:\"blocked_attempts\";s:4:\"9396\";s:6:\"expire\";i:1484668608;}", "no");
INSERT INTO wpax_options VALUES("45183", "_transient_timeout_jpp_li_eb23785831ffbf2db083c3fb3f5c29f7", "1484668249", "no");
INSERT INTO wpax_options VALUES("45184", "_transient_jpp_li_eb23785831ffbf2db083c3fb3f5c29f7", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:40:\"This IP is currently blocked (2.92.4.76)\";s:17:\"seconds_remaining\";i:3024;s:16:\"blocked_attempts\";s:4:\"9400\";s:6:\"expire\";i:1484668249;}", "no");
INSERT INTO wpax_options VALUES("45189", "_transient_timeout_jpp_li_c9e9169610884e927e513ac9b915f1fa", "1484668728", "no");
INSERT INTO wpax_options VALUES("45190", "_transient_jpp_li_c9e9169610884e927e513ac9b915f1fa", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:42:\"This IP is currently blocked (78.24.5.142)\";s:17:\"seconds_remaining\";i:3435;s:16:\"blocked_attempts\";s:4:\"9403\";s:6:\"expire\";i:1484668728;}", "no");
INSERT INTO wpax_options VALUES("45195", "_transient_timeout_jpp_li_40884e459be5c26752362b35a78436ff", "1484668052", "no");
INSERT INTO wpax_options VALUES("45196", "_transient_jpp_li_40884e459be5c26752362b35a78436ff", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:45:\"This IP is currently blocked (31.207.205.128)\";s:17:\"seconds_remaining\";i:2752;s:16:\"blocked_attempts\";s:4:\"9406\";s:6:\"expire\";i:1484668052;}", "no");
INSERT INTO wpax_options VALUES("45204", "_transient_timeout_jpp_li_91b758bd5ec5eb24a5a4691baf47a1c0", "1484668075", "no");
INSERT INTO wpax_options VALUES("45205", "_transient_jpp_li_91b758bd5ec5eb24a5a4691baf47a1c0", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:46:\"This IP is currently blocked (176.125.217.211)\";s:17:\"seconds_remaining\";i:2640;s:16:\"blocked_attempts\";s:4:\"9409\";s:6:\"expire\";i:1484668075;}", "no");
INSERT INTO wpax_options VALUES("45210", "_transient_timeout_jpp_li_0feb0680719a91478f806cdfd1bc2aee", "1484667435", "no");
INSERT INTO wpax_options VALUES("45211", "_transient_jpp_li_0feb0680719a91478f806cdfd1bc2aee", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:45:\"This IP is currently blocked (195.189.96.230)\";s:17:\"seconds_remaining\";i:1950;s:16:\"blocked_attempts\";s:4:\"9412\";s:6:\"expire\";i:1484667435;}", "no");
INSERT INTO wpax_options VALUES("45218", "_transient_timeout_jpp_li_43adbd2f805128cf2b91d3097497c7a3", "1484666268", "no");
INSERT INTO wpax_options VALUES("45219", "_transient_jpp_li_43adbd2f805128cf2b91d3097497c7a3", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:44:\"This IP is currently blocked (85.173.121.14)\";s:17:\"seconds_remaining\";i:661;s:16:\"blocked_attempts\";s:4:\"9415\";s:6:\"expire\";i:1484666268;}", "no");
INSERT INTO wpax_options VALUES("45224", "_transient_timeout_jpp_li_c39044fd7668d346b8586ea54b541ea4", "1484669009", "no");
INSERT INTO wpax_options VALUES("45225", "_transient_jpp_li_c39044fd7668d346b8586ea54b541ea4", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:43:\"This IP is currently blocked (188.187.24.9)\";s:17:\"seconds_remaining\";i:3332;s:16:\"blocked_attempts\";s:4:\"9418\";s:6:\"expire\";i:1484669009;}", "no");
INSERT INTO wpax_options VALUES("45232", "_transient_timeout_jpp_li_e18a7de84e9d657e135b541be700431b", "1484666150", "no");
INSERT INTO wpax_options VALUES("45233", "_transient_jpp_li_e18a7de84e9d657e135b541be700431b", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:45:\"This IP is currently blocked (83.139.163.160)\";s:17:\"seconds_remaining\";i:304;s:16:\"blocked_attempts\";s:4:\"9421\";s:6:\"expire\";i:1484666150;}", "no");
INSERT INTO wpax_options VALUES("45239", "_transient_timeout_jpp_li_4321cbea14c037b96168be64c0ac32c5", "1484669659", "no");
INSERT INTO wpax_options VALUES("45240", "_transient_jpp_li_4321cbea14c037b96168be64c0ac32c5", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:43:\"This IP is currently blocked (185.52.76.45)\";s:17:\"seconds_remaining\";i:3552;s:16:\"blocked_attempts\";s:4:\"9424\";s:6:\"expire\";i:1484669659;}", "no");
INSERT INTO wpax_options VALUES("45253", "_transient_timeout_jpp_li_c72c5fc6074b226359a7423f9668bba1", "1484668721", "no");
INSERT INTO wpax_options VALUES("45254", "_transient_jpp_li_c72c5fc6074b226359a7423f9668bba1", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:44:\"This IP is currently blocked (46.235.253.51)\";s:17:\"seconds_remaining\";i:2562;s:16:\"blocked_attempts\";s:4:\"9430\";s:6:\"expire\";i:1484668721;}", "no");
INSERT INTO wpax_options VALUES("45263", "_transient_timeout_jpp_li_68dc337966369878fd7a4a65c635a061", "1484669716", "no");
INSERT INTO wpax_options VALUES("45264", "_transient_jpp_li_68dc337966369878fd7a4a65c635a061", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:44:\"This IP is currently blocked (213.87.129.65)\";s:17:\"seconds_remaining\";i:3181;s:16:\"blocked_attempts\";s:4:\"9433\";s:6:\"expire\";i:1484669716;}", "no");
INSERT INTO wpax_options VALUES("45269", "_transient_timeout_jpp_li_7bdeb23bc3e68a8cf238c71e61eeba8a", "1484669602", "no");
INSERT INTO wpax_options VALUES("45270", "_transient_jpp_li_7bdeb23bc3e68a8cf238c71e61eeba8a", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:44:\"This IP is currently blocked (31.148.151.32)\";s:17:\"seconds_remaining\";i:2921;s:16:\"blocked_attempts\";s:4:\"9436\";s:6:\"expire\";i:1484669602;}", "no");
INSERT INTO wpax_options VALUES("45280", "_transient_timeout_jpp_li_1b3ffa899c2833257c6b033aaea8c408", "1484669759", "no");
INSERT INTO wpax_options VALUES("45281", "_transient_jpp_li_1b3ffa899c2833257c6b033aaea8c408", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:43:\"This IP is currently blocked (31.130.91.37)\";s:17:\"seconds_remaining\";i:2917;s:16:\"blocked_attempts\";s:4:\"9439\";s:6:\"expire\";i:1484669759;}", "no");
INSERT INTO wpax_options VALUES("45286", "_transient_timeout_jpp_li_513852ee2fb24c94a1553a3a4f550704", "1484669927", "no");
INSERT INTO wpax_options VALUES("45287", "_transient_jpp_li_513852ee2fb24c94a1553a3a4f550704", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:44:\"This IP is currently blocked (195.98.69.140)\";s:17:\"seconds_remaining\";i:2942;s:16:\"blocked_attempts\";s:4:\"9442\";s:6:\"expire\";i:1484669927;}", "no");
INSERT INTO wpax_options VALUES("45304", "_transient_timeout_jpp_li_3c526b3976280dda2ec56715e575dd2b", "1484670890", "no");
INSERT INTO wpax_options VALUES("45305", "_transient_jpp_li_3c526b3976280dda2ec56715e575dd2b", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:44:\"This IP is currently blocked (185.71.82.158)\";s:17:\"seconds_remaining\";i:3280;s:16:\"blocked_attempts\";s:4:\"9448\";s:6:\"expire\";i:1484670890;}", "no");
INSERT INTO wpax_options VALUES("45322", "_transient_timeout_jpp_li_850cf3301feb2b49419f554a699d6a4b", "1484671637", "no");
INSERT INTO wpax_options VALUES("45323", "_transient_jpp_li_850cf3301feb2b49419f554a699d6a4b", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:42:\"This IP is currently blocked (5.227.15.27)\";s:17:\"seconds_remaining\";i:3464;s:16:\"blocked_attempts\";s:4:\"9454\";s:6:\"expire\";i:1484671637;}", "no");
INSERT INTO wpax_options VALUES("45325", "_transient_timeout_jpp_li_c36afa28cbf85d97c0cd486c241abfcf", "1484668756", "no");
INSERT INTO wpax_options VALUES("45326", "_transient_jpp_li_c36afa28cbf85d97c0cd486c241abfcf", "a:5:{s:6:\"status\";s:12:\"blocked-hard\";s:3:\"msg\";s:45:\"This IP is currently blocked (188.162.251.21)\";s:17:\"seconds_remaining\";i:514;s:16:\"blocked_attempts\";s:4:\"9455\";s:6:\"expire\";i:1484668756;}", "no");
INSERT INTO wpax_options VALUES("45340", "_transient_timeout_jpp_li_8e89623d5093f96c20c63bb93eb2400a", "1484671452", "no");
INSERT INTO wpax_options VALUES("45341", "_transient_jpp_li_8e89623d5093f96c20c63bb93eb2400a", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:45:\"This IP is currently blocked (78.107.234.199)\";s:17:\"seconds_remaining\";i:2887;s:16:\"blocked_attempts\";s:4:\"9461\";s:6:\"expire\";i:1484671452;}", "no");
INSERT INTO wpax_options VALUES("45347", "_transient_timeout_jpp_li_7b064b68c31dde749d41cbcb86a8c06d", "1484671966", "no");
INSERT INTO wpax_options VALUES("45348", "_transient_jpp_li_7b064b68c31dde749d41cbcb86a8c06d", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:46:\"This IP is currently blocked (176.213.186.165)\";s:17:\"seconds_remaining\";i:3280;s:16:\"blocked_attempts\";s:4:\"9464\";s:6:\"expire\";i:1484671966;}", "no");
INSERT INTO wpax_options VALUES("45353", "_transient_timeout_jpp_li_567d7a20ad4d21c07efd781b232f5533", "1484672160", "no");
INSERT INTO wpax_options VALUES("45354", "_transient_jpp_li_567d7a20ad4d21c07efd781b232f5533", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:44:\"This IP is currently blocked (93.145.147.63)\";s:17:\"seconds_remaining\";i:3454;s:16:\"blocked_attempts\";s:4:\"9467\";s:6:\"expire\";i:1484672160;}", "no");
INSERT INTO wpax_options VALUES("45359", "_transient_timeout_jpp_li_717d758aab48b7c5b631b185a80dfc6c", "1484672141", "no");
INSERT INTO wpax_options VALUES("45360", "_transient_jpp_li_717d758aab48b7c5b631b185a80dfc6c", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:45:\"This IP is currently blocked (95.104.221.111)\";s:17:\"seconds_remaining\";i:3380;s:16:\"blocked_attempts\";s:4:\"9470\";s:6:\"expire\";i:1484672141;}", "no");
INSERT INTO wpax_options VALUES("45367", "_transient_timeout_jpp_li_85c72601e4e55f7db302b5a0c958a223", "1484671917", "no");
INSERT INTO wpax_options VALUES("45368", "_transient_jpp_li_85c72601e4e55f7db302b5a0c958a223", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:43:\"This IP is currently blocked (37.76.187.90)\";s:17:\"seconds_remaining\";i:3048;s:16:\"blocked_attempts\";s:4:\"9473\";s:6:\"expire\";i:1484671917;}", "no");
INSERT INTO wpax_options VALUES("45374", "_transient_timeout_jpp_li_32eecbb00b65d6762a1f4cdbecdff5ba", "1484671177", "no");
INSERT INTO wpax_options VALUES("45375", "_transient_jpp_li_32eecbb00b65d6762a1f4cdbecdff5ba", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:45:\"This IP is currently blocked (37.212.145.213)\";s:17:\"seconds_remaining\";i:2181;s:16:\"blocked_attempts\";s:4:\"9476\";s:6:\"expire\";i:1484671177;}", "no");
INSERT INTO wpax_options VALUES("45380", "_transient_timeout_jpp_li_805124549c27a20f88dfffa2e94d2a68", "1484671182", "no");
INSERT INTO wpax_options VALUES("45381", "_transient_jpp_li_805124549c27a20f88dfffa2e94d2a68", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:44:\"This IP is currently blocked (79.105.14.168)\";s:17:\"seconds_remaining\";i:2142;s:16:\"blocked_attempts\";s:4:\"9479\";s:6:\"expire\";i:1484671182;}", "no");
INSERT INTO wpax_options VALUES("45386", "_transient_timeout_jpp_li_4d25ff354691dfd9001425b6df09eb27", "1484670403", "no");
INSERT INTO wpax_options VALUES("45387", "_transient_jpp_li_4d25ff354691dfd9001425b6df09eb27", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:45:\"This IP is currently blocked (217.23.186.125)\";s:17:\"seconds_remaining\";i:1357;s:16:\"blocked_attempts\";s:4:\"9482\";s:6:\"expire\";i:1484670403;}", "no");
INSERT INTO wpax_options VALUES("45392", "_transient_timeout_jpp_li_42d5d4280c29a4b20c0e9293c0d309cf", "1484669143", "no");
INSERT INTO wpax_options VALUES("45393", "_transient_jpp_li_42d5d4280c29a4b20c0e9293c0d309cf", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:42:\"This IP is currently blocked (2.40.85.147)\";s:17:\"seconds_remaining\";i:49;s:16:\"blocked_attempts\";s:4:\"9485\";s:6:\"expire\";i:1484669143;}", "no");
INSERT INTO wpax_options VALUES("45404", "_transient_timeout_jpp_li_2650ccd1319e54d4ad92e1b00e025695", "1484670820", "no");
INSERT INTO wpax_options VALUES("45405", "_transient_jpp_li_2650ccd1319e54d4ad92e1b00e025695", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:42:\"This IP is currently blocked (92.84.75.80)\";s:17:\"seconds_remaining\";i:1210;s:16:\"blocked_attempts\";s:4:\"9488\";s:6:\"expire\";i:1484670820;}", "no");
INSERT INTO wpax_options VALUES("45406", "_transient_timeout_jpp_li_8b44ed67147ec908d897e2777945dec8", "1484669901", "no");
INSERT INTO wpax_options VALUES("45407", "_transient_jpp_li_8b44ed67147ec908d897e2777945dec8", "a:5:{s:6:\"status\";s:12:\"blocked-hard\";s:3:\"msg\";s:43:\"This IP is currently blocked (5.164.232.42)\";s:17:\"seconds_remaining\";i:287;s:16:\"blocked_attempts\";s:4:\"9489\";s:6:\"expire\";i:1484669901;}", "no");
INSERT INTO wpax_options VALUES("45412", "_transient_timeout_jpp_li_1050f413f5a6b58b659625fd4b114fb3", "1484671163", "no");
INSERT INTO wpax_options VALUES("45413", "_transient_jpp_li_1050f413f5a6b58b659625fd4b114fb3", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:43:\"This IP is currently blocked (95.68.169.49)\";s:17:\"seconds_remaining\";i:1531;s:16:\"blocked_attempts\";s:4:\"9492\";s:6:\"expire\";i:1484671163;}", "no");
INSERT INTO wpax_options VALUES("45418", "_transient_timeout_jpp_li_ac0d876a6bbe832ab944946e04e5efce", "1484672530", "no");
INSERT INTO wpax_options VALUES("45419", "_transient_jpp_li_ac0d876a6bbe832ab944946e04e5efce", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:42:\"This IP is currently blocked (186.46.43.2)\";s:17:\"seconds_remaining\";i:2841;s:16:\"blocked_attempts\";s:4:\"9495\";s:6:\"expire\";i:1484672530;}", "no");
INSERT INTO wpax_options VALUES("45424", "_transient_timeout_jpp_li_079467e2ce7dad2dabe9fb3eaddb9803", "1484672605", "no");
INSERT INTO wpax_options VALUES("45425", "_transient_jpp_li_079467e2ce7dad2dabe9fb3eaddb9803", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:44:\"This IP is currently blocked (95.29.143.106)\";s:17:\"seconds_remaining\";i:2839;s:16:\"blocked_attempts\";s:4:\"9498\";s:6:\"expire\";i:1484672605;}", "no");
INSERT INTO wpax_options VALUES("45433", "_transient_timeout_jpp_li_4e76667bb2fc5addefd17ec6b1ec2f0f", "1484673070", "no");
INSERT INTO wpax_options VALUES("45434", "_transient_jpp_li_4e76667bb2fc5addefd17ec6b1ec2f0f", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:44:\"This IP is currently blocked (94.141.62.125)\";s:17:\"seconds_remaining\";i:3118;s:16:\"blocked_attempts\";s:4:\"9501\";s:6:\"expire\";i:1484673070;}", "no");
INSERT INTO wpax_options VALUES("45452", "_transient_timeout_jpp_li_448dc1eb67f9c648e3ba26b5fd2ca7cc", "1484672254", "no");
INSERT INTO wpax_options VALUES("45453", "_transient_jpp_li_448dc1eb67f9c648e3ba26b5fd2ca7cc", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:45:\"This IP is currently blocked (194.67.136.214)\";s:17:\"seconds_remaining\";i:1954;s:16:\"blocked_attempts\";s:4:\"9509\";s:6:\"expire\";i:1484672254;}", "no");
INSERT INTO wpax_options VALUES("45454", "_transient_timeout_jpp_li_191a0eff2051bc99f841533c456f0518", "1484673872", "no");
INSERT INTO wpax_options VALUES("45455", "_transient_jpp_li_191a0eff2051bc99f841533c456f0518", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:44:\"This IP is currently blocked (31.40.128.126)\";s:17:\"seconds_remaining\";i:3570;s:16:\"blocked_attempts\";s:4:\"9510\";s:6:\"expire\";i:1484673872;}", "no");
INSERT INTO wpax_options VALUES("45465", "_transient_timeout_jpp_li_d290968523d1ae7a9a11fa7919eed164", "1484674012", "no");
INSERT INTO wpax_options VALUES("45466", "_transient_jpp_li_d290968523d1ae7a9a11fa7919eed164", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:44:\"This IP is currently blocked (77.246.225.66)\";s:17:\"seconds_remaining\";i:3410;s:16:\"blocked_attempts\";s:4:\"9513\";s:6:\"expire\";i:1484674012;}", "no");
INSERT INTO wpax_options VALUES("45478", "_transient_timeout_jpp_li_54beb25934b8bd706baba0ed06047fae", "1484672877", "no");
INSERT INTO wpax_options VALUES("45479", "_transient_jpp_li_54beb25934b8bd706baba0ed06047fae", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:43:\"This IP is currently blocked (31.23.19.134)\";s:17:\"seconds_remaining\";i:2165;s:16:\"blocked_attempts\";s:4:\"9519\";s:6:\"expire\";i:1484672877;}", "no");
INSERT INTO wpax_options VALUES("45484", "_transient_timeout_jpp_li_2f30763be00eb278f9b2aaa83d7a870c", "1484672306", "no");
INSERT INTO wpax_options VALUES("45485", "_transient_jpp_li_2f30763be00eb278f9b2aaa83d7a870c", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:45:\"This IP is currently blocked (213.24.126.246)\";s:17:\"seconds_remaining\";i:1574;s:16:\"blocked_attempts\";s:4:\"9522\";s:6:\"expire\";i:1484672306;}", "no");
INSERT INTO wpax_options VALUES("45490", "_transient_timeout_jpp_li_1d72bd2ff5c55ba0a5bbdbb3d01e921a", "1484673007", "no");
INSERT INTO wpax_options VALUES("45491", "_transient_jpp_li_1d72bd2ff5c55ba0a5bbdbb3d01e921a", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:45:\"This IP is currently blocked (109.182.249.37)\";s:17:\"seconds_remaining\";i:2116;s:16:\"blocked_attempts\";s:4:\"9525\";s:6:\"expire\";i:1484673007;}", "no");
INSERT INTO wpax_options VALUES("45498", "_transient_timeout_jpp_li_cea7ea27b4a8baeb9df431453414f85f", "1484674007", "no");
INSERT INTO wpax_options VALUES("45499", "_transient_jpp_li_cea7ea27b4a8baeb9df431453414f85f", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:43:\"This IP is currently blocked (178.169.87.6)\";s:17:\"seconds_remaining\";i:3050;s:16:\"blocked_attempts\";s:4:\"9528\";s:6:\"expire\";i:1484674007;}", "no");
INSERT INTO wpax_options VALUES("45505", "_transient_timeout_jpp_li_b8da4734785221283da9961b932e1bef", "1484673060", "no");
INSERT INTO wpax_options VALUES("45506", "_transient_jpp_li_b8da4734785221283da9961b932e1bef", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:45:\"This IP is currently blocked (89.250.169.176)\";s:17:\"seconds_remaining\";i:1840;s:16:\"blocked_attempts\";s:4:\"9531\";s:6:\"expire\";i:1484673060;}", "no");
INSERT INTO wpax_options VALUES("45514", "_transient_timeout_jpp_li_31192deb0572186ad59811813b3deb21", "1484674372", "no");
INSERT INTO wpax_options VALUES("45515", "_transient_jpp_li_31192deb0572186ad59811813b3deb21", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:43:\"This IP is currently blocked (5.141.56.165)\";s:17:\"seconds_remaining\";i:2878;s:16:\"blocked_attempts\";s:4:\"9534\";s:6:\"expire\";i:1484674372;}", "no");
INSERT INTO wpax_options VALUES("45528", "_transient_timeout_jpp_li_4f1a4de1b1b353cbf4fc3771a5efa971", "1484675294", "no");
INSERT INTO wpax_options VALUES("45529", "_transient_jpp_li_4f1a4de1b1b353cbf4fc3771a5efa971", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:45:\"This IP is currently blocked (109.161.74.173)\";s:17:\"seconds_remaining\";i:3440;s:16:\"blocked_attempts\";s:4:\"9539\";s:6:\"expire\";i:1484675294;}", "no");
INSERT INTO wpax_options VALUES("45530", "_transient_timeout_jpp_li_10486dc4504450739db13776d7e3ef82", "1484672119", "no");
INSERT INTO wpax_options VALUES("45531", "_transient_jpp_li_10486dc4504450739db13776d7e3ef82", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:45:\"This IP is currently blocked (217.23.186.100)\";s:17:\"seconds_remaining\";i:264;s:16:\"blocked_attempts\";s:4:\"9540\";s:6:\"expire\";i:1484672119;}", "no");
INSERT INTO wpax_options VALUES("45536", "_transient_timeout_jpp_li_d14ec5ea0e6f3b34a23dfd6d345b060e", "1484675299", "no");
INSERT INTO wpax_options VALUES("45537", "_transient_jpp_li_d14ec5ea0e6f3b34a23dfd6d345b060e", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:45:\"This IP is currently blocked (85.192.169.127)\";s:17:\"seconds_remaining\";i:3400;s:16:\"blocked_attempts\";s:4:\"9543\";s:6:\"expire\";i:1484675299;}", "no");
INSERT INTO wpax_options VALUES("45543", "_transient_timeout_jpp_li_cff7d61b393d12ad7656cd38afc7a487", "1484675193", "no");
INSERT INTO wpax_options VALUES("45544", "_transient_jpp_li_cff7d61b393d12ad7656cd38afc7a487", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:43:\"This IP is currently blocked (27.7.160.116)\";s:17:\"seconds_remaining\";i:3197;s:16:\"blocked_attempts\";s:4:\"9546\";s:6:\"expire\";i:1484675193;}", "no");
INSERT INTO wpax_options VALUES("45552", "_transient_timeout_jpp_li_c83a0fc66b4c6db1b167abab1fea6070", "1484675322", "no");
INSERT INTO wpax_options VALUES("45553", "_transient_jpp_li_c83a0fc66b4c6db1b167abab1fea6070", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:44:\"This IP is currently blocked (80.76.104.123)\";s:17:\"seconds_remaining\";i:2943;s:16:\"blocked_attempts\";s:4:\"9549\";s:6:\"expire\";i:1484675322;}", "no");
INSERT INTO wpax_options VALUES("45564", "_transient_timeout_jpp_li_48718a3d5d27f268467dc7e795b77357", "1484675782", "no");
INSERT INTO wpax_options VALUES("45565", "_transient_jpp_li_48718a3d5d27f268467dc7e795b77357", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:43:\"This IP is currently blocked (31.8.243.198)\";s:17:\"seconds_remaining\";i:2766;s:16:\"blocked_attempts\";s:4:\"9552\";s:6:\"expire\";i:1484675782;}", "no");
INSERT INTO wpax_options VALUES("45573", "_transient_timeout_jpp_li_f5c182f5db83ce6a06ae635203549a6d", "1484676488", "no");
INSERT INTO wpax_options VALUES("45574", "_transient_jpp_li_f5c182f5db83ce6a06ae635203549a6d", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:44:\"This IP is currently blocked (212.20.45.184)\";s:17:\"seconds_remaining\";i:3178;s:16:\"blocked_attempts\";s:4:\"9555\";s:6:\"expire\";i:1484676488;}", "no");
INSERT INTO wpax_options VALUES("45586", "_transient_timeout_jpp_li_8641b2e92122045fa4c3070d397784c3", "1484675088", "no");
INSERT INTO wpax_options VALUES("45587", "_transient_jpp_li_8641b2e92122045fa4c3070d397784c3", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:45:\"This IP is currently blocked (62.133.162.127)\";s:17:\"seconds_remaining\";i:1605;s:16:\"blocked_attempts\";s:4:\"9561\";s:6:\"expire\";i:1484675088;}", "no");
INSERT INTO wpax_options VALUES("45594", "_transient_timeout_jpp_li_dd69084d9b032b781b60ad9208e8bd79", "1484676275", "no");
INSERT INTO wpax_options VALUES("45595", "_transient_jpp_li_dd69084d9b032b781b60ad9208e8bd79", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:46:\"This IP is currently blocked (188.186.215.127)\";s:17:\"seconds_remaining\";i:2625;s:16:\"blocked_attempts\";s:4:\"9564\";s:6:\"expire\";i:1484676275;}", "no");
INSERT INTO wpax_options VALUES("45600", "_transient_timeout_jpp_li_19fae8b94a3570d20faeded40ae6f07d", "1484676900", "no");
INSERT INTO wpax_options VALUES("45601", "_transient_jpp_li_19fae8b94a3570d20faeded40ae6f07d", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:45:\"This IP is currently blocked (83.219.146.214)\";s:17:\"seconds_remaining\";i:3236;s:16:\"blocked_attempts\";s:4:\"9567\";s:6:\"expire\";i:1484676900;}", "no");
INSERT INTO wpax_options VALUES("45603", "_transient_timeout_jpp_li_83d0fe3424a88e083c6235b8dfea685f", "1484674081", "no");
INSERT INTO wpax_options VALUES("45604", "_transient_jpp_li_83d0fe3424a88e083c6235b8dfea685f", "a:5:{s:6:\"status\";s:12:\"blocked-hard\";s:3:\"msg\";s:43:\"This IP is currently blocked (85.173.83.90)\";s:17:\"seconds_remaining\";i:271;s:16:\"blocked_attempts\";s:4:\"9568\";s:6:\"expire\";i:1484674081;}", "no");
INSERT INTO wpax_options VALUES("45611", "_transient_timeout_jpp_li_46f9bc69ee2fb920469863ca4456d277", "1484676765", "no");
INSERT INTO wpax_options VALUES("45612", "_transient_jpp_li_46f9bc69ee2fb920469863ca4456d277", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:45:\"This IP is currently blocked (109.162.49.154)\";s:17:\"seconds_remaining\";i:2802;s:16:\"blocked_attempts\";s:4:\"9571\";s:6:\"expire\";i:1484676765;}", "no");
INSERT INTO wpax_options VALUES("45623", "_transient_timeout_jpp_li_3b228ddf49e593bd3a6e460e8e61fdcb", "1484677017", "no");
INSERT INTO wpax_options VALUES("45624", "_transient_jpp_li_3b228ddf49e593bd3a6e460e8e61fdcb", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:45:\"This IP is currently blocked (85.140.231.170)\";s:17:\"seconds_remaining\";i:2613;s:16:\"blocked_attempts\";s:4:\"9574\";s:6:\"expire\";i:1484677017;}", "no");
INSERT INTO wpax_options VALUES("45656", "_transient_timeout_jpp_li_06a6135cb523347c2e963d36f0cb141e", "1484678857", "no");
INSERT INTO wpax_options VALUES("45657", "_transient_jpp_li_06a6135cb523347c2e963d36f0cb141e", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:44:\"This IP is currently blocked (213.80.232.30)\";s:17:\"seconds_remaining\";i:3558;s:16:\"blocked_attempts\";s:4:\"9587\";s:6:\"expire\";i:1484678857;}", "no");
INSERT INTO wpax_options VALUES("45668", "_transient_timeout_jpp_li_2cbbd5f59eac06c607d3668fc723b110", "1484679661", "no");
INSERT INTO wpax_options VALUES("45669", "_transient_jpp_li_2cbbd5f59eac06c607d3668fc723b110", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:45:\"This IP is currently blocked (217.21.208.202)\";s:17:\"seconds_remaining\";i:3570;s:16:\"blocked_attempts\";s:4:\"9590\";s:6:\"expire\";i:1484679661;}", "no");
INSERT INTO wpax_options VALUES("45675", "_transient_timeout_jpp_li_852653843caaaf748cf8167017bf6d4d", "1484678902", "no");
INSERT INTO wpax_options VALUES("45676", "_transient_jpp_li_852653843caaaf748cf8167017bf6d4d", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:46:\"This IP is currently blocked (217.107.126.125)\";s:17:\"seconds_remaining\";i:2748;s:16:\"blocked_attempts\";s:4:\"9593\";s:6:\"expire\";i:1484678902;}", "no");
INSERT INTO wpax_options VALUES("45683", "_transient_timeout_jpp_li_83ced1385a37d851787b74505d5a221b", "1484679509", "no");
INSERT INTO wpax_options VALUES("45684", "_transient_jpp_li_83ced1385a37d851787b74505d5a221b", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:42:\"This IP is currently blocked (93.80.165.5)\";s:17:\"seconds_remaining\";i:3262;s:16:\"blocked_attempts\";s:4:\"9596\";s:6:\"expire\";i:1484679509;}", "no");
INSERT INTO wpax_options VALUES("45699", "_transient_timeout_jpp_li_5914c5adf73b10d05cbf71ea1f5aaf93", "1484677603", "no");
INSERT INTO wpax_options VALUES("45700", "_transient_jpp_li_5914c5adf73b10d05cbf71ea1f5aaf93", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:43:\"This IP is currently blocked (85.26.233.71)\";s:17:\"seconds_remaining\";i:858;s:16:\"blocked_attempts\";s:4:\"9602\";s:6:\"expire\";i:1484677603;}", "no");
INSERT INTO wpax_options VALUES("45705", "_transient_timeout_jpp_li_12998f18064fa84cc8a23cb57be173a0", "1484678868", "no");
INSERT INTO wpax_options VALUES("45706", "_transient_jpp_li_12998f18064fa84cc8a23cb57be173a0", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:44:\"This IP is currently blocked (178.218.25.47)\";s:17:\"seconds_remaining\";i:2110;s:16:\"blocked_attempts\";s:4:\"9605\";s:6:\"expire\";i:1484678868;}", "no");
INSERT INTO wpax_options VALUES("45712", "_transient_timeout_jpp_li_69d01d669162e955681a3af9a5e5b042", "1484677200", "no");
INSERT INTO wpax_options VALUES("45713", "_transient_jpp_li_69d01d669162e955681a3af9a5e5b042", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:44:\"This IP is currently blocked (85.95.186.170)\";s:17:\"seconds_remaining\";i:249;s:16:\"blocked_attempts\";s:4:\"9608\";s:6:\"expire\";i:1484677200;}", "no");
INSERT INTO wpax_options VALUES("45719", "_transient_timeout_jpp_li_cbc3f2930d533028428da6c6e529daea", "1484680079", "no");
INSERT INTO wpax_options VALUES("45720", "_transient_jpp_li_cbc3f2930d533028428da6c6e529daea", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:44:\"This IP is currently blocked (94.31.167.234)\";s:17:\"seconds_remaining\";i:3070;s:16:\"blocked_attempts\";s:4:\"9611\";s:6:\"expire\";i:1484680079;}", "no");
INSERT INTO wpax_options VALUES("45725", "_transient_timeout_jpp_li_4b1c6c5816c7b958132255290de91954", "1484680172", "no");
INSERT INTO wpax_options VALUES("45726", "_transient_jpp_li_4b1c6c5816c7b958132255290de91954", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:42:\"This IP is currently blocked (93.81.89.38)\";s:17:\"seconds_remaining\";i:3134;s:16:\"blocked_attempts\";s:4:\"9614\";s:6:\"expire\";i:1484680172;}", "no");
INSERT INTO wpax_options VALUES("45733", "_transient_timeout_jpp_li_8fdb3b4c5f65180df62a339e3f96c36f", "1484679205", "no");
INSERT INTO wpax_options VALUES("45734", "_transient_jpp_li_8fdb3b4c5f65180df62a339e3f96c36f", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:42:\"This IP is currently blocked (95.84.28.65)\";s:17:\"seconds_remaining\";i:2055;s:16:\"blocked_attempts\";s:4:\"9617\";s:6:\"expire\";i:1484679205;}", "no");
INSERT INTO wpax_options VALUES("45739", "_transient_timeout_jpp_li_198910222a5d7c873ce40b758b6efd68", "1484678902", "no");
INSERT INTO wpax_options VALUES("45740", "_transient_jpp_li_198910222a5d7c873ce40b758b6efd68", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:44:\"This IP is currently blocked (94.75.131.234)\";s:17:\"seconds_remaining\";i:1658;s:16:\"blocked_attempts\";s:4:\"9620\";s:6:\"expire\";i:1484678902;}", "no");
INSERT INTO wpax_options VALUES("45746", "_transient_timeout_jpp_li_a1870dcf0ccad4122e5e696fe5188089", "1484680578", "no");
INSERT INTO wpax_options VALUES("45747", "_transient_jpp_li_a1870dcf0ccad4122e5e696fe5188089", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:43:\"This IP is currently blocked (83.69.109.14)\";s:17:\"seconds_remaining\";i:3249;s:16:\"blocked_attempts\";s:4:\"9623\";s:6:\"expire\";i:1484680578;}", "no");
INSERT INTO wpax_options VALUES("45754", "_transient_timeout_jpp_li_4c5f409e6494a5f7d0015ca38bcc7745", "1484679622", "no");
INSERT INTO wpax_options VALUES("45755", "_transient_jpp_li_4c5f409e6494a5f7d0015ca38bcc7745", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:44:\"This IP is currently blocked (212.21.11.141)\";s:17:\"seconds_remaining\";i:2179;s:16:\"blocked_attempts\";s:4:\"9626\";s:6:\"expire\";i:1484679622;}", "no");
INSERT INTO wpax_options VALUES("45760", "_transient_timeout_jpp_li_01bb214ad5b80fd016547fca5f05d64c", "1484679711", "no");
INSERT INTO wpax_options VALUES("45761", "_transient_jpp_li_01bb214ad5b80fd016547fca5f05d64c", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:42:\"This IP is currently blocked (5.76.207.12)\";s:17:\"seconds_remaining\";i:2254;s:16:\"blocked_attempts\";s:4:\"9629\";s:6:\"expire\";i:1484679711;}", "no");
INSERT INTO wpax_options VALUES("45766", "_transient_timeout_jpp_li_b467f1f7068eda00a88c69e9d21ee236", "1484680638", "no");
INSERT INTO wpax_options VALUES("45767", "_transient_jpp_li_b467f1f7068eda00a88c69e9d21ee236", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:46:\"This IP is currently blocked (188.216.122.128)\";s:17:\"seconds_remaining\";i:3085;s:16:\"blocked_attempts\";s:4:\"9632\";s:6:\"expire\";i:1484680638;}", "no");
INSERT INTO wpax_options VALUES("45778", "_transient_timeout_jpp_li_908d7856d685f47d8a4d4f37a16efa85", "1484681093", "no");
INSERT INTO wpax_options VALUES("45779", "_transient_jpp_li_908d7856d685f47d8a4d4f37a16efa85", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:44:\"This IP is currently blocked (217.66.159.46)\";s:17:\"seconds_remaining\";i:3071;s:16:\"blocked_attempts\";s:4:\"9635\";s:6:\"expire\";i:1484681093;}", "no");
INSERT INTO wpax_options VALUES("45784", "_transient_timeout_jpp_li_df557bcf7281f9c31e0eadb5180c63a5", "1484681307", "no");
INSERT INTO wpax_options VALUES("45785", "_transient_jpp_li_df557bcf7281f9c31e0eadb5180c63a5", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:43:\"This IP is currently blocked (128.74.43.36)\";s:17:\"seconds_remaining\";i:3212;s:16:\"blocked_attempts\";s:4:\"9638\";s:6:\"expire\";i:1484681307;}", "no");
INSERT INTO wpax_options VALUES("45794", "_transient_timeout_jpp_li_e868b20d5e127b5f23562c137d1a3506", "1484682001", "no");
INSERT INTO wpax_options VALUES("45795", "_transient_jpp_li_e868b20d5e127b5f23562c137d1a3506", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:44:\"This IP is currently blocked (91.103.79.115)\";s:17:\"seconds_remaining\";i:3445;s:16:\"blocked_attempts\";s:4:\"9641\";s:6:\"expire\";i:1484682001;}", "no");
INSERT INTO wpax_options VALUES("45800", "_transient_timeout_jpp_li_12d49ae989a2946d55ab239bef6adcf4", "1484680060", "no");
INSERT INTO wpax_options VALUES("45801", "_transient_jpp_li_12d49ae989a2946d55ab239bef6adcf4", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:45:\"This IP is currently blocked (89.188.124.197)\";s:17:\"seconds_remaining\";i:1485;s:16:\"blocked_attempts\";s:4:\"9644\";s:6:\"expire\";i:1484680060;}", "no");
INSERT INTO wpax_options VALUES("45806", "_transient_timeout_jpp_li_5b414d2a1152ef69891d79d49b6ea485", "1484680235", "no");
INSERT INTO wpax_options VALUES("45807", "_transient_jpp_li_5b414d2a1152ef69891d79d49b6ea485", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:46:\"This IP is currently blocked (178.205.191.112)\";s:17:\"seconds_remaining\";i:1598;s:16:\"blocked_attempts\";s:4:\"9647\";s:6:\"expire\";i:1484680235;}", "no");
INSERT INTO wpax_options VALUES("45815", "_transient_timeout_jpp_li_8144a1c2c97eeb162fc25d3e0c574881", "1484681272", "no");
INSERT INTO wpax_options VALUES("45816", "_transient_jpp_li_8144a1c2c97eeb162fc25d3e0c574881", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:45:\"This IP is currently blocked (109.254.254.44)\";s:17:\"seconds_remaining\";i:2334;s:16:\"blocked_attempts\";s:4:\"9650\";s:6:\"expire\";i:1484681272;}", "no");
INSERT INTO wpax_options VALUES("45822", "_transient_timeout_jpp_li_6d5e730ad1dccdd07c9700cc2f9c443d", "1484682513", "no");
INSERT INTO wpax_options VALUES("45823", "_transient_jpp_li_6d5e730ad1dccdd07c9700cc2f9c443d", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:44:\"This IP is currently blocked (95.134.143.61)\";s:17:\"seconds_remaining\";i:3429;s:16:\"blocked_attempts\";s:4:\"9653\";s:6:\"expire\";i:1484682513;}", "no");
INSERT INTO wpax_options VALUES("45829", "_transient_timeout_jpp_li_f3406d3df493e4001e8c9b5fcb94c6cf", "1484681767", "no");
INSERT INTO wpax_options VALUES("45830", "_transient_jpp_li_f3406d3df493e4001e8c9b5fcb94c6cf", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:45:\"This IP is currently blocked (213.137.244.31)\";s:17:\"seconds_remaining\";i:2572;s:16:\"blocked_attempts\";s:4:\"9656\";s:6:\"expire\";i:1484681767;}", "no");
INSERT INTO wpax_options VALUES("45838", "_transient_timeout_jpp_li_c37c26d6851667e08c76861422fd4271", "1484682995", "no");
INSERT INTO wpax_options VALUES("45839", "_transient_jpp_li_c37c26d6851667e08c76861422fd4271", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:44:\"This IP is currently blocked (93.100.37.197)\";s:17:\"seconds_remaining\";i:3555;s:16:\"blocked_attempts\";s:4:\"9659\";s:6:\"expire\";i:1484682995;}", "no");
INSERT INTO wpax_options VALUES("45846", "_transient_timeout_jpp_li_1ac5d4b3be5b961caf294a1d6c569670", "1484681236", "no");
INSERT INTO wpax_options VALUES("45847", "_transient_jpp_li_1ac5d4b3be5b961caf294a1d6c569670", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:44:\"This IP is currently blocked (77.73.142.153)\";s:17:\"seconds_remaining\";i:1697;s:16:\"blocked_attempts\";s:4:\"9662\";s:6:\"expire\";i:1484681236;}", "no");
INSERT INTO wpax_options VALUES("45848", "_transient_timeout_jpp_li_876d2cf65a614c5362eecab282dda532", "1484680743", "no");
INSERT INTO wpax_options VALUES("45849", "_transient_jpp_li_876d2cf65a614c5362eecab282dda532", "a:5:{s:6:\"status\";s:12:\"blocked-hard\";s:3:\"msg\";s:46:\"This IP is currently blocked (188.162.167.207)\";s:17:\"seconds_remaining\";i:1130;s:16:\"blocked_attempts\";s:4:\"9663\";s:6:\"expire\";i:1484680743;}", "no");
INSERT INTO wpax_options VALUES("45855", "_transient_timeout_jpp_li_731ef9f87e9042952b938f9590c75195", "1484680501", "no");
INSERT INTO wpax_options VALUES("45856", "_transient_jpp_li_731ef9f87e9042952b938f9590c75195", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:44:\"This IP is currently blocked (185.138.206.5)\";s:17:\"seconds_remaining\";i:769;s:16:\"blocked_attempts\";s:4:\"9666\";s:6:\"expire\";i:1484680501;}", "no");
INSERT INTO wpax_options VALUES("45861", "_transient_timeout_jpp_li_bb1d5b15838b3c855abc3c00580bac72", "1484682789", "no");
INSERT INTO wpax_options VALUES("45862", "_transient_jpp_li_bb1d5b15838b3c855abc3c00580bac72", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:45:\"This IP is currently blocked (213.87.147.219)\";s:17:\"seconds_remaining\";i:3046;s:16:\"blocked_attempts\";s:4:\"9669\";s:6:\"expire\";i:1484682789;}", "no");
INSERT INTO wpax_options VALUES("45866", "_transient_timeout_jpp_li_2d2bd1b2c40b2f8519bc4449e98be68b", "1484682893", "no");
INSERT INTO wpax_options VALUES("45867", "_transient_jpp_li_2d2bd1b2c40b2f8519bc4449e98be68b", "a:5:{s:6:\"status\";s:12:\"blocked-hard\";s:3:\"msg\";s:46:\"This IP is currently blocked (176.114.209.226)\";s:17:\"seconds_remaining\";i:2871;s:16:\"blocked_attempts\";s:4:\"9670\";s:6:\"expire\";i:1484682893;}", "no");
INSERT INTO wpax_options VALUES("45872", "_transient_timeout_jpp_li_d869f151ad929f59013fbd13cb58df67", "1484683041", "no");
INSERT INTO wpax_options VALUES("45873", "_transient_jpp_li_d869f151ad929f59013fbd13cb58df67", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:43:\"This IP is currently blocked (109.252.91.8)\";s:17:\"seconds_remaining\";i:2974;s:16:\"blocked_attempts\";s:4:\"9673\";s:6:\"expire\";i:1484683041;}", "no");
INSERT INTO wpax_options VALUES("45878", "_transient_timeout_jpp_li_4ff158a21bf734e6776e4747e87fa170", "1484682385", "no");
INSERT INTO wpax_options VALUES("45879", "_transient_jpp_li_4ff158a21bf734e6776e4747e87fa170", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:41:\"This IP is currently blocked (46.0.84.32)\";s:17:\"seconds_remaining\";i:2289;s:16:\"blocked_attempts\";s:4:\"9676\";s:6:\"expire\";i:1484682385;}", "no");
INSERT INTO wpax_options VALUES("45880", "_transient_timeout_jpp_li_9cd3b9eebac7c07e4b6e4b272659f1ed", "1484681274", "no");
INSERT INTO wpax_options VALUES("45881", "_transient_jpp_li_9cd3b9eebac7c07e4b6e4b272659f1ed", "a:5:{s:6:\"status\";s:12:\"blocked-hard\";s:3:\"msg\";s:46:\"This IP is currently blocked (109.124.100.250)\";s:17:\"seconds_remaining\";i:1120;s:16:\"blocked_attempts\";s:4:\"9677\";s:6:\"expire\";i:1484681274;}", "no");
INSERT INTO wpax_options VALUES("45889", "_transient_timeout_jpp_li_88818efb8f3f710d2dc9d4b92e6c4c16", "1484682227", "no");
INSERT INTO wpax_options VALUES("45890", "_transient_jpp_li_88818efb8f3f710d2dc9d4b92e6c4c16", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:45:\"This IP is currently blocked (81.177.126.196)\";s:17:\"seconds_remaining\";i:1883;s:16:\"blocked_attempts\";s:4:\"9680\";s:6:\"expire\";i:1484682227;}", "no");
INSERT INTO wpax_options VALUES("45895", "_transient_timeout_jpp_li_653edc1f2bead22feb13a537584fddf6", "1484683918", "no");
INSERT INTO wpax_options VALUES("45896", "_transient_jpp_li_653edc1f2bead22feb13a537584fddf6", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:41:\"This IP is currently blocked (46.0.7.216)\";s:17:\"seconds_remaining\";i:3395;s:16:\"blocked_attempts\";s:4:\"9683\";s:6:\"expire\";i:1484683918;}", "no");
INSERT INTO wpax_options VALUES("45904", "_transient_timeout_jpp_li_ab12d333d5e83b17d02ffabe7b872f44", "1484683059", "no");
INSERT INTO wpax_options VALUES("45905", "_transient_jpp_li_ab12d333d5e83b17d02ffabe7b872f44", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:45:\"This IP is currently blocked (83.139.170.116)\";s:17:\"seconds_remaining\";i:2331;s:16:\"blocked_attempts\";s:4:\"9686\";s:6:\"expire\";i:1484683059;}", "no");
INSERT INTO wpax_options VALUES("45910", "_transient_timeout_jpp_li_07e573d4fb85d8e47586ed64c784a877", "1484684227", "no");
INSERT INTO wpax_options VALUES("45911", "_transient_jpp_li_07e573d4fb85d8e47586ed64c784a877", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:44:\"This IP is currently blocked (89.106.198.40)\";s:17:\"seconds_remaining\";i:3363;s:16:\"blocked_attempts\";s:4:\"9689\";s:6:\"expire\";i:1484684227;}", "no");
INSERT INTO wpax_options VALUES("45920", "_transient_timeout_jpp_li_419d57f518d9a0cbbd737ee3712f2ea4", "1484684940", "no");
INSERT INTO wpax_options VALUES("45921", "_transient_jpp_li_419d57f518d9a0cbbd737ee3712f2ea4", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:45:\"This IP is currently blocked (176.215.46.142)\";s:17:\"seconds_remaining\";i:3442;s:16:\"blocked_attempts\";s:4:\"9692\";s:6:\"expire\";i:1484684940;}", "no");
INSERT INTO wpax_options VALUES("45929", "_transient_timeout_jpp_li_c7c8cc42578ad385fee936acc3cc5979", "1484685187", "no");
INSERT INTO wpax_options VALUES("45930", "_transient_jpp_li_c7c8cc42578ad385fee936acc3cc5979", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:44:\"This IP is currently blocked (92.124.93.241)\";s:17:\"seconds_remaining\";i:3536;s:16:\"blocked_attempts\";s:4:\"9695\";s:6:\"expire\";i:1484685187;}", "no");
INSERT INTO wpax_options VALUES("45934", "_transient_timeout_jpp_li_c05a3d9596fddee469cd3afdaaacb37f", "1484684908", "no");
INSERT INTO wpax_options VALUES("45935", "_transient_jpp_li_c05a3d9596fddee469cd3afdaaacb37f", "a:5:{s:6:\"status\";s:12:\"blocked-hard\";s:3:\"msg\";s:46:\"This IP is currently blocked (179.184.193.101)\";s:17:\"seconds_remaining\";i:3097;s:16:\"blocked_attempts\";s:4:\"9696\";s:6:\"expire\";i:1484684908;}", "no");
INSERT INTO wpax_options VALUES("45940", "_transient_timeout_jpp_li_679eeff6df649363c69a1029cf32e8a6", "1484683549", "no");
INSERT INTO wpax_options VALUES("45941", "_transient_jpp_li_679eeff6df649363c69a1029cf32e8a6", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:45:\"This IP is currently blocked (109.87.118.240)\";s:17:\"seconds_remaining\";i:1677;s:16:\"blocked_attempts\";s:4:\"9699\";s:6:\"expire\";i:1484683549;}", "no");
INSERT INTO wpax_options VALUES("45945", "_transient_timeout_jpp_li_a7abc6c8cc240f4f5d781c56be785e54", "1484682194", "no");
INSERT INTO wpax_options VALUES("45946", "_transient_jpp_li_a7abc6c8cc240f4f5d781c56be785e54", "a:5:{s:6:\"status\";s:12:\"blocked-hard\";s:3:\"msg\";s:45:\"This IP is currently blocked (213.138.90.164)\";s:17:\"seconds_remaining\";i:28;s:16:\"blocked_attempts\";s:4:\"9700\";s:6:\"expire\";i:1484682194;}", "no");
INSERT INTO wpax_options VALUES("45953", "_transient_timeout_jpp_li_57ab905a908f1e732d57596b78c85e03", "1484683096", "no");
INSERT INTO wpax_options VALUES("45954", "_transient_jpp_li_57ab905a908f1e732d57596b78c85e03", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:46:\"This IP is currently blocked (178.216.181.182)\";s:17:\"seconds_remaining\";i:926;s:16:\"blocked_attempts\";s:4:\"9704\";s:6:\"expire\";i:1484683096;}", "no");
INSERT INTO wpax_options VALUES("45957", "_transient_timeout_jpp_li_90f6c6e66f2e5275c87f686a1f5a5aec", "1484684526", "no");
INSERT INTO wpax_options VALUES("45958", "_transient_jpp_li_90f6c6e66f2e5275c87f686a1f5a5aec", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:43:\"This IP is currently blocked (77.45.188.26)\";s:17:\"seconds_remaining\";i:2354;s:16:\"blocked_attempts\";s:4:\"9706\";s:6:\"expire\";i:1484684526;}", "no");
INSERT INTO wpax_options VALUES("45969", "_transient_timeout_jpp_li_e11c6908ba65b3d50b67c2830db11c4c", "1484685482", "no");
INSERT INTO wpax_options VALUES("45970", "_transient_jpp_li_e11c6908ba65b3d50b67c2830db11c4c", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:41:\"This IP is currently blocked (93.81.0.61)\";s:17:\"seconds_remaining\";i:2591;s:16:\"blocked_attempts\";s:4:\"9709\";s:6:\"expire\";i:1484685482;}", "no");
INSERT INTO wpax_options VALUES("45978", "_transient_timeout_jpp_li_a322fc5beeb890172e098c7cda2e1592", "1484686571", "no");
INSERT INTO wpax_options VALUES("45979", "_transient_jpp_li_a322fc5beeb890172e098c7cda2e1592", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:46:\"This IP is currently blocked (178.187.106.228)\";s:17:\"seconds_remaining\";i:3291;s:16:\"blocked_attempts\";s:4:\"9712\";s:6:\"expire\";i:1484686571;}", "no");
INSERT INTO wpax_options VALUES("45982", "_transient_timeout_jpp_li_a8a71c415cc6bba4144285d8118d8860", "1484686802", "no");
INSERT INTO wpax_options VALUES("45983", "_transient_jpp_li_a8a71c415cc6bba4144285d8118d8860", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:45:\"This IP is currently blocked (213.87.146.126)\";s:17:\"seconds_remaining\";i:3513;s:16:\"blocked_attempts\";s:4:\"9714\";s:6:\"expire\";i:1484686802;}", "no");
INSERT INTO wpax_options VALUES("45989", "_transient_timeout_jpp_li_2ac92d0b6a51a8096454a0ae38214448", "1484685785", "no");
INSERT INTO wpax_options VALUES("45990", "_transient_jpp_li_2ac92d0b6a51a8096454a0ae38214448", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:45:\"This IP is currently blocked (176.115.121.13)\";s:17:\"seconds_remaining\";i:2426;s:16:\"blocked_attempts\";s:4:\"9717\";s:6:\"expire\";i:1484685785;}", "no");
INSERT INTO wpax_options VALUES("45998", "_transient_timeout_jpp_li_0e413d12652fa5663c08fc6a76fefc3c", "1484685512", "no");
INSERT INTO wpax_options VALUES("45999", "_transient_jpp_li_0e413d12652fa5663c08fc6a76fefc3c", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:44:\"This IP is currently blocked (80.234.96.241)\";s:17:\"seconds_remaining\";i:1829;s:16:\"blocked_attempts\";s:4:\"9720\";s:6:\"expire\";i:1484685512;}", "no");
INSERT INTO wpax_options VALUES("46007", "_transient_timeout_jpp_li_2b70f9e8453a55427be4a18e58e83a75", "1484687120", "no");
INSERT INTO wpax_options VALUES("46008", "_transient_jpp_li_2b70f9e8453a55427be4a18e58e83a75", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:43:\"This IP is currently blocked (62.183.86.42)\";s:17:\"seconds_remaining\";i:3043;s:16:\"blocked_attempts\";s:4:\"9723\";s:6:\"expire\";i:1484687120;}", "no");
INSERT INTO wpax_options VALUES("46013", "_transient_timeout_jpp_li_ca058f10f5f0c9cc662c6b7a512e858a", "1484687518", "no");
INSERT INTO wpax_options VALUES("46014", "_transient_jpp_li_ca058f10f5f0c9cc662c6b7a512e858a", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:44:\"This IP is currently blocked (194.190.95.50)\";s:17:\"seconds_remaining\";i:3362;s:16:\"blocked_attempts\";s:4:\"9726\";s:6:\"expire\";i:1484687518;}", "no");
INSERT INTO wpax_options VALUES("46020", "_transient_timeout_jpp_li_497de6a78e2c2b5b1a69149e6f5260f3", "1484687544", "no");
INSERT INTO wpax_options VALUES("46021", "_transient_jpp_li_497de6a78e2c2b5b1a69149e6f5260f3", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:43:\"This IP is currently blocked (37.144.59.70)\";s:17:\"seconds_remaining\";i:3322;s:16:\"blocked_attempts\";s:4:\"9729\";s:6:\"expire\";i:1484687544;}", "no");
INSERT INTO wpax_options VALUES("46028", "_transient_timeout_jpp_li_f71f3256ee5314ba2e0b9cadee37cfbe", "1484684586", "no");
INSERT INTO wpax_options VALUES("46029", "_transient_jpp_li_f71f3256ee5314ba2e0b9cadee37cfbe", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:42:\"This IP is currently blocked (37.78.11.74)\";s:17:\"seconds_remaining\";i:220;s:16:\"blocked_attempts\";s:4:\"9732\";s:6:\"expire\";i:1484684586;}", "no");
INSERT INTO wpax_options VALUES("46035", "_transient_timeout_jpp_li_0394915ba3355625ec9bc3910b47d7e6", "1484687510", "no");
INSERT INTO wpax_options VALUES("46036", "_transient_jpp_li_0394915ba3355625ec9bc3910b47d7e6", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:43:\"This IP is currently blocked (89.22.54.185)\";s:17:\"seconds_remaining\";i:2968;s:16:\"blocked_attempts\";s:4:\"9735\";s:6:\"expire\";i:1484687510;}", "no");
INSERT INTO wpax_options VALUES("46043", "_transient_timeout_jpp_li_af4493a71a75447a26e265bd6049491c", "1484685827", "no");
INSERT INTO wpax_options VALUES("46044", "_transient_jpp_li_af4493a71a75447a26e265bd6049491c", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:44:\"This IP is currently blocked (85.238.110.71)\";s:17:\"seconds_remaining\";i:1075;s:16:\"blocked_attempts\";s:4:\"9738\";s:6:\"expire\";i:1484685827;}", "no");
INSERT INTO wpax_options VALUES("46051", "_transient_timeout_jpp_li_803d524532c22dfcd7f2b7bcf922f77a", "1484687889", "no");
INSERT INTO wpax_options VALUES("46052", "_transient_jpp_li_803d524532c22dfcd7f2b7bcf922f77a", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:45:\"This IP is currently blocked (91.123.155.169)\";s:17:\"seconds_remaining\";i:3082;s:16:\"blocked_attempts\";s:4:\"9741\";s:6:\"expire\";i:1484687889;}", "no");
INSERT INTO wpax_options VALUES("46057", "_transient_timeout_jpp_li_9ca38fbb0d53fa2fcb4cd823f6edf776", "1484688236", "no");
INSERT INTO wpax_options VALUES("46058", "_transient_jpp_li_9ca38fbb0d53fa2fcb4cd823f6edf776", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:44:\"This IP is currently blocked (213.87.146.59)\";s:17:\"seconds_remaining\";i:3303;s:16:\"blocked_attempts\";s:4:\"9744\";s:6:\"expire\";i:1484688236;}", "no");
INSERT INTO wpax_options VALUES("46066", "_transient_timeout_jpp_li_f157ba972ff4e9f9b97d2060ec09a3a3", "1484688064", "no");
INSERT INTO wpax_options VALUES("46067", "_transient_jpp_li_f157ba972ff4e9f9b97d2060ec09a3a3", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:45:\"This IP is currently blocked (177.201.52.125)\";s:17:\"seconds_remaining\";i:2930;s:16:\"blocked_attempts\";s:4:\"9747\";s:6:\"expire\";i:1484688064;}", "no");
INSERT INTO wpax_options VALUES("46072", "_transient_timeout_jpp_li_146ad6b38afb87b4bf57ea64b45eeec8", "1484686206", "no");
INSERT INTO wpax_options VALUES("46073", "_transient_jpp_li_146ad6b38afb87b4bf57ea64b45eeec8", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:41:\"This IP is currently blocked (5.8.203.80)\";s:17:\"seconds_remaining\";i:1014;s:16:\"blocked_attempts\";s:4:\"9750\";s:6:\"expire\";i:1484686206;}", "no");
INSERT INTO wpax_options VALUES("46078", "_transient_timeout_jpp_li_4a79557a35d518fb89beae518733c757", "1484688185", "no");
INSERT INTO wpax_options VALUES("46079", "_transient_jpp_li_4a79557a35d518fb89beae518733c757", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:45:\"This IP is currently blocked (37.204.120.131)\";s:17:\"seconds_remaining\";i:2816;s:16:\"blocked_attempts\";s:4:\"9753\";s:6:\"expire\";i:1484688185;}", "no");
INSERT INTO wpax_options VALUES("46080", "_transient_timeout_jetpack_sync_constants_await", "1484688969", "no");
INSERT INTO wpax_options VALUES("46081", "_transient_jetpack_sync_constants_await", "1484685369.28", "no");
INSERT INTO wpax_options VALUES("46088", "_transient_timeout_jetpack_sync_last_checked_queue_state_sync", "1484685730", "no");
INSERT INTO wpax_options VALUES("46089", "_transient_jetpack_sync_last_checked_queue_state_sync", "a:2:{i:0;i:0;i:1;i:0;}", "no");
INSERT INTO wpax_options VALUES("46091", "_transient_timeout_jetpack_idc_allowed", "1484685731", "no");
INSERT INTO wpax_options VALUES("46092", "_transient_jetpack_idc_allowed", "1", "no");
INSERT INTO wpax_options VALUES("46093", "_transient_timeout_jpp_li_2669770bfcc8d225495df4a6324f4215", "1484685493", "no");
INSERT INTO wpax_options VALUES("46094", "_transient_jpp_li_2669770bfcc8d225495df4a6324f4215", "a:5:{s:6:\"status\";s:2:\"ok\";s:3:\"msg\";s:61:\"{\"trusted_header\":\"REMOTE_ADDR\",\"segments\":1,\"reverse\":false}\";s:17:\"seconds_remaining\";i:60;s:16:\"blocked_attempts\";s:4:\"9754\";s:6:\"expire\";i:1484685493;}", "no");
INSERT INTO wpax_options VALUES("46095", "_transient_timeout_jpp_headers_updated_recently", "1484771833", "no");
INSERT INTO wpax_options VALUES("46096", "_transient_jpp_headers_updated_recently", "1", "no");
INSERT INTO wpax_options VALUES("46097", "_site_transient_timeout_theme_roots", "1484687233", "no");
INSERT INTO wpax_options VALUES("46098", "_site_transient_theme_roots", "a:6:{s:9:\"allegiant\";s:7:\"/themes\";s:8:\"fruitful\";s:7:\"/themes\";s:5:\"illdy\";s:7:\"/themes\";s:13:\"twentyfifteen\";s:7:\"/themes\";s:15:\"twentyseventeen\";s:7:\"/themes\";s:13:\"twentysixteen\";s:7:\"/themes\";}", "no");
INSERT INTO wpax_options VALUES("46101", "jetpack_nonce_1484685435_b5VV6S2ow3", "1484685436", "no");
INSERT INTO wpax_options VALUES("46102", "_transient_timeout_feed_ac0b00fe65abe10e0c5b588f3ed8c7ca", "1484728638", "no");
INSERT INTO wpax_options VALUES("46103", "_transient_feed_ac0b00fe65abe10e0c5b588f3ed8c7ca", "a:4:{s:5:\"child\";a:1:{s:0:\"\";a:1:{s:3:\"rss\";a:1:{i:0;a:6:{s:4:\"data\";s:3:\"\n\n\n\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:7:\"version\";s:3:\"2.0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:1:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:49:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n		\n		\n		\n		\n		\n		\n		\n		\n		\n	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"WordPress News\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:26:\"https://wordpress.org/news\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"WordPress News\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:13:\"lastBuildDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 14 Jan 2017 00:21:27 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"language\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"en-US\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"generator\";a:1:{i:0;a:5:{s:4:\"data\";s:40:\"https://wordpress.org/?v=4.8-alpha-39923\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"item\";a:10:{i:0;a:6:{s:4:\"data\";s:39:\"\n		\n		\n		\n		\n				\n		\n		\n\n		\n		\n				\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:48:\"WordPress 4.7.1 Security and Maintenance Release\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:84:\"https://wordpress.org/news/2017/01/wordpress-4-7-1-security-and-maintenance-release/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 11 Jan 2017 03:53:57 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:3:{i:0;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Security\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:3:\"4.7\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=4650\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:375:\"WordPress 4.7 has been downloaded over 10 million times since its release on December 6, 2016 and we are pleased to announce the immediate availability of WordPress 4.7.1. This is a security release for all previous versions and we strongly encourage you to update your sites immediately. WordPress versions 4.7 and earlier are affected by eight security issues: [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:17:\"Aaron D. Campbell\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:6520:\"<p>WordPress 4.7 has been <a href=\"https://wordpress.org/download/counter/\">downloaded over 10 million times</a> since its release on December 6, 2016 and we are pleased to announce the immediate availability of WordPress 4.7.1. This is a <strong>security release</strong> for all previous versions and we strongly encourage you to update your sites immediately.</p>\n<p>WordPress versions 4.7 and earlier are affected by eight security issues:</p>\n<ol>\n<li>Remote code execution (RCE) in PHPMailer &#8211; <em>No specific issue appears to affect WordPress</em> or any of the major plugins we investigated but, out of an abundance of caution, we updated PHPMailer in this release. This issue was fixed in PHPMailer thanks to <a href=\"https://legalhackers.com/\">Dawid Golunski</a> and <a href=\"https://twitter.com/Zenexer\">Paul Buonopane</a>.</li>\n<li>The REST API exposed user data for all users who had authored a post of a public post type. WordPress 4.7.1 limits this to only post types which have specified that they should be shown within the REST API. Reported by <a href=\"https://poststatus.com/\">Krogsgard</a> and <a href=\"https://ithemes.com/\">Chris Jean</a>.</li>\n<li>Cross-site scripting (XSS) via the plugin name or version header on <code>update-core.php</code>. Reported by <a href=\"https://dominikschilling.de/\">Dominik Schilling</a> of the WordPress Security Team.</li>\n<li>Cross-site request forgery (CSRF) bypass via uploading a Flash file. Reported by <a href=\"https://twitter.com/Abdulahhusam\">Abdullah Hussam</a>.</li>\n<li>Cross-site scripting (XSS) via theme name fallback. Reported by <a href=\"https://pentest.blog/\">Mehmet Ince</a>.</li>\n<li>Post via email checks <code>mail.example.com</code> if default settings aren&#8217;t changed. Reported by John Blackbourn of the WordPress Security Team.</li>\n<li>A cross-site request forgery (CSRF) was discovered in the accessibility mode of widget editing. Reported by <a href=\"https://dk.linkedin.com/in/ronni-skansing-36143b65\">Ronnie Skansing</a>.</li>\n<li>Weak cryptographic security for multisite activation key. Reported by <a href=\"https://itsjack.cc/\">Jack</a>.</li>\n</ol>\n<p>Thank you to the reporters for practicing <a href=\"https://make.wordpress.org/core/handbook/testing/reporting-security-vulnerabilities/\">responsible disclosure</a>.</p>\n<p>In addition to the security issues above, WordPress 4.7.1 fixes 62 bugs from 4.7. For more information, see the <a href=\"https://codex.wordpress.org/Version_4.7.1\">release notes</a> or consult the <a href=\"https://core.trac.wordpress.org/query?milestone=4.7.1\">list of changes</a>.</p>\n<p><a href=\"https://wordpress.org/download/\">Download WordPress 4.7.1</a> or venture over to Dashboard → Updates and simply click “Update Now.” Sites that support automatic background updates are already beginning to update to WordPress 4.7.1.</p>\n<p>Thanks to everyone who contributed to 4.7.1: <a href=\"https://profiles.wordpress.org/aaroncampbell/\">Aaron D. Campbell</a>, <a href=\"https://profiles.wordpress.org/jorbin/\">Aaron Jorbin</a>, <a href=\"https://profiles.wordpress.org/adamsilverstein/\">Adam Silverstein</a>, <a href=\"https://profiles.wordpress.org/afercia/\">Andrea Fercia</a>, <a href=\"https://profiles.wordpress.org/azaozz/\">Andrew Ozz</a>, <a href=\"https://profiles.wordpress.org/gitlost/\">bonger</a>, <a href=\"https://profiles.wordpress.org/boonebgorges/\">Boone Gorges</a>, <a href=\"https://profiles.wordpress.org/chandrapatel/\">Chandra Patel</a>, <a href=\"https://profiles.wordpress.org/christian1012/\">Christian Chung</a>, <a href=\"https://profiles.wordpress.org/dlh/\">David Herrera</a>, <a href=\"https://profiles.wordpress.org/dshanske/\">David Shanske</a>, <a href=\"https://profiles.wordpress.org/dd32/\">Dion Hulse</a>, <a href=\"https://profiles.wordpress.org/ocean90/\">Dominik Schilling (ocean90)</a>, <a href=\"https://profiles.wordpress.org/dreamon11/\">DreamOn11</a>, <a href=\"https://profiles.wordpress.org/chopinbach/\">Edwin Cromley</a>, <a href=\"https://profiles.wordpress.org/iseulde/\">Ella van Dorpe</a>, <a href=\"https://profiles.wordpress.org/pento/\">Gary Pendergast</a>, <a href=\"https://profiles.wordpress.org/hristo-sg/\">Hristo Pandjarov</a>, <a href=\"https://profiles.wordpress.org/jnylen0/\">James Nylen</a>, <a href=\"https://profiles.wordpress.org/jblz/\">Jeff Bowen</a>, <a href=\"https://profiles.wordpress.org/jeremyfelt/\">Jeremy Felt</a>, <a href=\"https://profiles.wordpress.org/jpry/\">Jeremy Pry</a>, <a href=\"https://profiles.wordpress.org/joehoyle/\">Joe Hoyle</a>, <a href=\"https://profiles.wordpress.org/joemcgill/\">Joe McGill</a>, <a href=\"https://profiles.wordpress.org/johnbillion/\">John Blackbourn</a>, <a href=\"https://profiles.wordpress.org/kkoppenhaver/\">Keanan Koppenhaver</a>, <a href=\"https://profiles.wordpress.org/obenland/\">Konstantin Obenland</a>, <a href=\"https://profiles.wordpress.org/laurelfulford/\">laurelfulford</a>, <a href=\"https://profiles.wordpress.org/tyxla/\">Marin Atanasov</a>, <a href=\"https://profiles.wordpress.org/mattyrob/\">mattyrob</a>, <a href=\"https://profiles.wordpress.org/monikarao/\">monikarao</a>, <a href=\"https://profiles.wordpress.org/natereist/\">Nate Reist</a>, <a href=\"https://profiles.wordpress.org/celloexpressions/\">Nick Halsey</a>, <a href=\"https://profiles.wordpress.org/nikschavan/\">Nikhil Chavan</a>, <a href=\"https://profiles.wordpress.org/nullvariable/\">nullvariable</a>, <a href=\"https://profiles.wordpress.org/sirbrillig/\">Payton Swick</a>, <a href=\"https://profiles.wordpress.org/peterwilsoncc/\">Peter Wilson</a>, <a href=\"https://profiles.wordpress.org/presskopp/\">Presskopp</a>, <a href=\"https://profiles.wordpress.org/rachelbaker/\">Rachel Baker</a>, <a href=\"https://profiles.wordpress.org/rmccue/\">Ryan McCue</a>, <a href=\"https://profiles.wordpress.org/sanketparmar/\">Sanket Parmar</a>, <a href=\"https://profiles.wordpress.org/sebastianpisula/\">Sebastian Pisula</a>, <a href=\"https://profiles.wordpress.org/sfpt/\">sfpt</a>, <a href=\"https://profiles.wordpress.org/shazahm1hotmailcom/\">shazahm1</a>, <a href=\"https://profiles.wordpress.org/sstoqnov/\">Stanimir Stoyanov</a>, <a href=\"https://profiles.wordpress.org/stevenkword/\">Steven Word</a>, <a href=\"https://profiles.wordpress.org/szaqal21/\">szaqal21</a>, <a href=\"https://profiles.wordpress.org/timph/\">timph</a>, <a href=\"https://profiles.wordpress.org/voldemortensen/\">voldemortensen</a>, <a href=\"https://profiles.wordpress.org/vortfu/\">vortfu</a>, and <a href=\"https://profiles.wordpress.org/westonruter/\">Weston Ruter</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"4650\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:1;a:6:{s:4:\"data\";s:36:\"\n		\n		\n		\n		\n				\n\n		\n		\n				\n	\n\n\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:27:\"WordPress 4.7 “Vaughan”\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:43:\"https://wordpress.org/news/2016/12/vaughan/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 06 Dec 2016 19:27:41 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=4596\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:240:\"Version 4.7 of WordPress, named “Vaughan” in honor of legendary jazz vocalist Sarah \"Sassy\" Vaughan, is available for download or update in your WordPress dashboard. New features in 4.7 help you get your site set up the way you want it.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"enclosure\";a:3:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:3:\"url\";s:60:\"https://wordpress.org/news/files/2016/12/starter-content.mp4\";s:6:\"length\";s:7:\"3736020\";s:4:\"type\";s:9:\"video/mp4\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:3:\"url\";s:59:\"https://wordpress.org/news/files/2016/12/edit-shortcuts.mp4\";s:6:\"length\";s:7:\"1127483\";s:4:\"type\";s:9:\"video/mp4\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:3:\"url\";s:58:\"https://wordpress.org/news/files/2016/12/video-headers.mp4\";s:6:\"length\";s:7:\"1549803\";s:4:\"type\";s:9:\"video/mp4\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Helen Hou-Sandi\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:45492:\"<p>Version 4.7 of WordPress, named “Vaughan” in honor of legendary jazz vocalist Sarah &#8220;Sassy&#8221; Vaughan, is available for download or update in your WordPress dashboard. New features in 4.7 help you get your site set up the way you want it.</p>\n<div id=\"v-AHz0Ca46-1\" class=\"video-player\"><video id=\"v-AHz0Ca46-1-video\" width=\"632\" height=\"354\" poster=\"https://videos.files.wordpress.com/AHz0Ca46/wp4-7-vaughan-r8-mastered_scruberthumbnail_0.jpg\" controls=\"true\" preload=\"metadata\" dir=\"ltr\" lang=\"en\"><source src=\"https://videos.files.wordpress.com/AHz0Ca46/wp4-7-vaughan-r8-mastered_dvd.mp4\" type=\"video/mp4; codecs=&quot;avc1.64001E, mp4a.40.2&quot;\" /><source src=\"https://videos.files.wordpress.com/AHz0Ca46/wp4-7-vaughan-r8-mastered_fmt1.ogv\" type=\"video/ogg; codecs=&quot;theora, vorbis&quot;\" /><div><img alt=\"Introducing WordPress 4.7\" src=\"https://i1.wp.com/videos.files.wordpress.com/AHz0Ca46/wp4-7-vaughan-r8-mastered_scruberthumbnail_0.jpg?resize=632%2C354&#038;ssl=1\" data-recalc-dims=\"1\" /></div><p>Introducing WordPress 4.7</p></video></div>\n<hr />\n<h2 style=\"text-align:center\">Presenting Twenty Seventeen</h2>\n<p>A brand new default theme brings your site to life with immersive featured images and video headers.</p>\n<p><img class=\"alignnone wp-image-4618 size-large\" src=\"https://i2.wp.com/wordpress.org/news/files/2016/12/4.7-—-Twenty-Seventeen-1.jpg?resize=632%2C356&#038;ssl=1\" srcset=\"https://i2.wp.com/wordpress.org/news/files/2016/12/4.7-—-Twenty-Seventeen-1.jpg?resize=1024%2C576&amp;ssl=1 1024w, https://i2.wp.com/wordpress.org/news/files/2016/12/4.7-—-Twenty-Seventeen-1.jpg?resize=300%2C169&amp;ssl=1 300w, https://i2.wp.com/wordpress.org/news/files/2016/12/4.7-—-Twenty-Seventeen-1.jpg?resize=768%2C432&amp;ssl=1 768w, https://i2.wp.com/wordpress.org/news/files/2016/12/4.7-—-Twenty-Seventeen-1.jpg?w=1600&amp;ssl=1 1600w, https://i2.wp.com/wordpress.org/news/files/2016/12/4.7-—-Twenty-Seventeen-1.jpg?w=1264&amp;ssl=1 1264w\" sizes=\"(max-width: 632px) 100vw, 632px\" data-recalc-dims=\"1\" /></p>\n<p>Twenty Seventeen focuses on business sites and features a customizable front page with multiple sections. Personalize it with widgets, navigation, social menus, a logo, custom colors, and more. Our default theme for 2017 works great in many languages, on any device, and for a wide range of users.</p>\n<hr />\n<h2 style=\"text-align:center\">Your Site, Your Way</h2>\n<p>WordPress 4.7 adds new features to the customizer to help take you through the initial setup of a theme, with non-destructive live previews of all your changes in one uninterrupted workflow.</p>\n<h3>Theme Starter Content</h3>\n<div style=\"width: 632px;\" class=\"wp-video\"><!--[if lt IE 9]><script>document.createElement(\'video\');</script><![endif]-->\n<video class=\"wp-video-shortcode\" id=\"video-4596-1\" width=\"632\" height=\"346\" loop=\"1\" autoplay=\"1\" preload=\"metadata\" controls=\"controls\"><source type=\"video/mp4\" src=\"https://wordpress.org/news/files/2016/12/starter-content.mp4?_=1\" /><a href=\"https://wordpress.org/news/files/2016/12/starter-content.mp4\">https://wordpress.org/news/files/2016/12/starter-content.mp4</a></video></div>\n<p>To help give you a solid base to build from, individual themes can provide starter content that appears when you go to customize your brand new site. This can range from placing a business information widget in the best location to providing a sample menu with social icon links to a static front page complete with beautiful images. Don’t worry &#8211; nothing new will appear on the live site until you’re ready to save and publish your initial theme setup.</p>\n<div style=\"float: left;width: 48%;margin: 0\">\n<h3>Edit Shortcuts</h3>\n<div style=\"width: 300px;\" class=\"wp-video\"><video class=\"wp-video-shortcode\" id=\"video-4596-2\" width=\"300\" height=\"173\" poster=\"https://wordpress.org/news/files/2016/12/4.7-—-Edit-Shortcuts.jpg\" loop=\"1\" autoplay=\"1\" preload=\"metadata\" controls=\"controls\"><source type=\"video/mp4\" src=\"https://wordpress.org/news/files/2016/12/edit-shortcuts.mp4?_=2\" /><a href=\"https://wordpress.org/news/files/2016/12/edit-shortcuts.mp4\">https://wordpress.org/news/files/2016/12/edit-shortcuts.mp4</a></video></div>\n<p>Visible icons appear to show you which parts of your site can be customized while live previewing. Click on a shortcut and get straight to editing. Paired with starter content, getting started with customizing your site is faster than ever.</p>\n</div>\n<div style=\"float: right;width: 48%;margin: 0\">\n<h3>Video Headers</h3>\n<div style=\"width: 300px;\" class=\"wp-video\"><video class=\"wp-video-shortcode\" id=\"video-4596-3\" width=\"300\" height=\"173\" poster=\"https://wordpress.org/news/files/2016/12/4.7-—-Header-Video.jpg\" loop=\"1\" autoplay=\"1\" preload=\"metadata\" controls=\"controls\"><source type=\"video/mp4\" src=\"https://wordpress.org/news/files/2016/12/video-headers.mp4?_=3\" /><a href=\"https://wordpress.org/news/files/2016/12/video-headers.mp4\">https://wordpress.org/news/files/2016/12/video-headers.mp4</a></video></div>\n<p>Sometimes a big atmospheric video as a moving header image is just what you need to showcase your wares; go ahead and try it out with Twenty Seventeen. Need some video inspiration? Try searching for sites with video headers available for download and use.</p>\n</div>\n<div style=\"clear: both\"></div>\n<div style=\"float: left;width: 48%;margin: 0\">\n<h3>Smoother Menu Building</h3>\n<p><img class=\"wp-image-4606 size-medium alignright\" src=\"https://i1.wp.com/wordpress.org/news/files/2016/12/4.7-—-Nav.jpg?resize=300%2C158&#038;ssl=1\" srcset=\"https://i1.wp.com/wordpress.org/news/files/2016/12/4.7-—-Nav.jpg?resize=300%2C158&amp;ssl=1 300w, https://i1.wp.com/wordpress.org/news/files/2016/12/4.7-—-Nav.jpg?w=760&amp;ssl=1 760w\" sizes=\"(max-width: 300px) 100vw, 300px\" data-recalc-dims=\"1\" /></p>\n<p>Many menus for sites contain links to the pages of your site, but what happens when you don’t have any pages yet? Now you can add new pages while building menus instead of leaving the customizer and abandoning your changes. Once you’ve published your customizations, you’ll have new pages ready for you to fill with content.</p>\n</div>\n<div style=\"float: right;width: 48%;margin: 0\">\n<h3>Custom CSS</h3>\n<p><img class=\"wp-image-4607 size-medium alignright\" src=\"https://i1.wp.com/wordpress.org/news/files/2016/12/4.7-—-CSS.jpg?resize=300%2C158&#038;ssl=1\" srcset=\"https://i1.wp.com/wordpress.org/news/files/2016/12/4.7-—-CSS.jpg?resize=300%2C158&amp;ssl=1 300w, https://i1.wp.com/wordpress.org/news/files/2016/12/4.7-—-CSS.jpg?w=760&amp;ssl=1 760w\" sizes=\"(max-width: 300px) 100vw, 300px\" data-recalc-dims=\"1\" /></p>\n<p>Sometimes you just need a few visual tweaks to make your site perfect. WordPress 4.7 allows you to add custom CSS and instantly see how your changes affect your site. The live preview allows you to work quickly without page refreshes slowing you down.</p>\n</div>\n<div style=\"clear: both\"></div>\n<hr />\n<div style=\"float: left;width: 48%;margin: 0\">\n<h3>PDF Thumbnail Previews</h3>\n<p><img class=\"wp-image-4609 size-medium alignright\" src=\"https://i1.wp.com/wordpress.org/news/files/2016/12/4.7-—-PDF.jpg?resize=300%2C158&#038;ssl=1\" srcset=\"https://i1.wp.com/wordpress.org/news/files/2016/12/4.7-—-PDF.jpg?resize=300%2C158&amp;ssl=1 300w, https://i1.wp.com/wordpress.org/news/files/2016/12/4.7-—-PDF.jpg?w=760&amp;ssl=1 760w\" sizes=\"(max-width: 300px) 100vw, 300px\" data-recalc-dims=\"1\" /></p>\n<p>Managing your document collection is easier with WordPress 4.7. Uploading PDFs will generate thumbnail images so you can more easily distinguish between all your documents.</p>\n</div>\n<div style=\"float: right;width: 48%;margin: 0\">\n<h3>Dashboard in your language</h3>\n<p><img class=\"wp-image-4608 size-medium alignright\" src=\"https://i2.wp.com/wordpress.org/news/files/2016/12/4.7-—-Language.jpg?resize=300%2C158&#038;ssl=1\" srcset=\"https://i2.wp.com/wordpress.org/news/files/2016/12/4.7-—-Language.jpg?resize=300%2C158&amp;ssl=1 300w, https://i2.wp.com/wordpress.org/news/files/2016/12/4.7-—-Language.jpg?w=760&amp;ssl=1 760w\" sizes=\"(max-width: 300px) 100vw, 300px\" data-recalc-dims=\"1\" /></p>\n<p>Just because your site is in one language doesn’t mean that everybody helping manage it prefers that language for their admin. Add more languages to your site and a user language option will show up in your user’s profiles.</p>\n</div>\n<div style=\"clear: both\"></div>\n<hr />\n<h2 style=\"text-align:center\">Introducing REST API Content Endpoints</h2>\n<p>WordPress 4.7 comes with REST API endpoints for posts, comments, terms, users, meta, and settings.</p>\n<p><img class=\"size-large wp-image-4600 alignnone\" src=\"https://i2.wp.com/wordpress.org/news/files/2016/12/4.7-—-API.jpg?resize=632%2C205&#038;ssl=1\" alt=\"\" srcset=\"https://i2.wp.com/wordpress.org/news/files/2016/12/4.7-—-API.jpg?resize=1024%2C332&amp;ssl=1 1024w, https://i2.wp.com/wordpress.org/news/files/2016/12/4.7-—-API.jpg?resize=300%2C97&amp;ssl=1 300w, https://i2.wp.com/wordpress.org/news/files/2016/12/4.7-—-API.jpg?resize=768%2C249&amp;ssl=1 768w, https://i2.wp.com/wordpress.org/news/files/2016/12/4.7-—-API.jpg?w=1264&amp;ssl=1 1264w, https://i2.wp.com/wordpress.org/news/files/2016/12/4.7-—-API.jpg?w=1896&amp;ssl=1 1896w\" sizes=\"(max-width: 632px) 100vw, 632px\" data-recalc-dims=\"1\" /></p>\n<p>Content endpoints provide machine-readable external access to your WordPress site with a clear, standards-driven interface, paving the way for new and innovative methods of interacting with sites through plugins, themes, apps, and beyond. Ready to get started with development? <a href=\"https://developer.wordpress.org/rest-api/reference/\">Check out the REST API reference.</a></p>\n<hr />\n<h2 style=\"text-align:center\">Even More Developer Happiness <img src=\"https://s.w.org/images/core/emoji/2.2.1/72x72/1f60a.png\" alt=\"😊\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /></h2>\n<h3><a href=\"https://make.wordpress.org/core/2016/11/03/post-type-templates-in-4-7/\">Post Type Templates</a></h3>\n<p>By opening up the page template functionality to all post types, theme developers have even more flexibility with the WordPress template hierarchy.</p>\n<h3>More Theme API Goodies</h3>\n<p>WordPress 4.7 includes <a href=\"https://make.wordpress.org/core/2016/09/09/new-functions-hooks-and-behaviour-for-theme-developers-in-wordpress-4-7/\">new functions, hooks, and behavior</a> for theme developers.</p>\n<h3><a href=\"https://make.wordpress.org/core/2016/10/04/custom-bulk-actions/\">Custom Bulk Actions</a></h3>\n<p>List tables, now with more than bulk edit and delete.</p>\n<h3><a href=\"https://make.wordpress.org/core/2016/09/08/wp_hook-next-generation-actions-and-filters/\"><code>WP_Hook</code></a></h3>\n<p>The code that lies beneath actions and filters has been overhauled and modernized, fixing bugs along the way.</p>\n<h3>Settings Registration API</h3>\n<p>register_setting() <a href=\"https://make.wordpress.org/core/2016/10/26/registering-your-settings-in-wordpress-4-7/\">has been enhanced</a> to include type, description, and REST API visibility.</p>\n<h3><a href=\"https://make.wordpress.org/core/2016/10/12/customize-changesets-technical-design-decisions/\">Customize Changesets</a></h3>\n<p>Customize changesets make changes in the customizer persistent, like autosave drafts. They also make exciting new features like starter content possible.</p>\n<hr />\n<h2 style=\"text-align:center\">The Squad</h2>\n<p>This release was led by <a href=\"https://helen.blog\">Helen Hou-Sandí</a>, backed up by <a href=\"https://profiles.wordpress.org/jbpaul17\">Jeff Paul</a> and <a href=\"http://aaron.jorb.in/\">Aaron Jorbin</a> as Release Deputies, and with the help of these fine individuals. There are 482 contributors with props in this release—the most ever—with 205 of them contributing for the first time. Pull up some sassy Sarah Vaughan on your music service of choice, and check out some of their profiles:</p>\n<a href=\"https://profiles.wordpress.org/aaroncampbell\">Aaron D. Campbell</a>, <a href=\"https://profiles.wordpress.org/abrightclearweb\">abrightclearweb</a>, <a href=\"https://profiles.wordpress.org/ibachal\">Achal Jain</a>, <a href=\"https://profiles.wordpress.org/achbed\">achbed</a>, <a href=\"https://profiles.wordpress.org/acmethemes\">Acme Themes</a>, <a href=\"https://profiles.wordpress.org/adamsilverstein\">Adam Silverstein</a>, <a href=\"https://profiles.wordpress.org/adammacias\">adammacias</a>, <a href=\"https://profiles.wordpress.org/mrahmadawais\">Ahmad Awais</a>, <a href=\"https://profiles.wordpress.org/ahmadawais\">ahmadawais</a>, <a href=\"https://profiles.wordpress.org/airesvsg\">airesvsg</a>, <a href=\"https://profiles.wordpress.org/ajoah\">ajoah</a>, <a href=\"https://profiles.wordpress.org/akibjorklund\">Aki Bj&#246;rklund</a>, <a href=\"https://profiles.wordpress.org/akshayvinchurkar\">AkshayVinchurkar</a>, <a href=\"https://profiles.wordpress.org/xknown\">Alex Concha</a>, <a href=\"https://profiles.wordpress.org/xavortm\">Alex Dimitrov</a>, <a href=\"https://profiles.wordpress.org/ironpaperweight\">Alex Hon</a>, <a href=\"https://profiles.wordpress.org/alex27\">alex27</a>, <a href=\"https://profiles.wordpress.org/allancole\">allancole</a>, <a href=\"https://profiles.wordpress.org/arush\">Amanda Rush</a>, <a href=\"https://profiles.wordpress.org/afercia\">Andrea Fercia</a>, <a href=\"https://profiles.wordpress.org/andrewp-2\">Andreas Panag</a>, <a href=\"https://profiles.wordpress.org/nacin\">Andrew Nacin</a>, <a href=\"https://profiles.wordpress.org/azaozz\">Andrew Ozz</a>, <a href=\"https://profiles.wordpress.org/rarst\">Andrey \"Rarst\" Savchenko</a>, <a href=\"https://profiles.wordpress.org/andizer\">Andy Meerwaldt</a>, <a href=\"https://profiles.wordpress.org/kelderic\">Andy Mercer</a>, <a href=\"https://profiles.wordpress.org/andy\">Andy Skelton</a>, <a href=\"https://profiles.wordpress.org/aniketpant\">Aniket Pant</a>, <a href=\"https://profiles.wordpress.org/anilbasnet\">Anil Basnet</a>, <a href=\"https://profiles.wordpress.org/ankit-k-gupta\">Ankit K Gupta</a>, <a href=\"https://profiles.wordpress.org/ahortin\">Anthony Hortin</a>, <a href=\"https://profiles.wordpress.org/antisilent\">antisilent</a>, <a href=\"https://profiles.wordpress.org/atimmer\">Anton Timmermans</a>, <a href=\"https://profiles.wordpress.org/zuige\">Antti Kuosmanen</a>, <a href=\"https://profiles.wordpress.org/apokalyptik\">apokalyptik</a>, <a href=\"https://profiles.wordpress.org/artoliukkonen\">artoliukkonen</a>, <a href=\"https://profiles.wordpress.org/ideag\">Arunas Liuiza</a>, <a href=\"https://profiles.wordpress.org/attitude\">attitude</a>, <a href=\"https://profiles.wordpress.org/backermann\">backermann</a>, <a href=\"https://profiles.wordpress.org/b-07\">Bappi</a>, <a href=\"https://profiles.wordpress.org/bcole808\">Ben Cole</a>, <a href=\"https://profiles.wordpress.org/kau-boy\">Bernhard Kau</a>, <a href=\"https://profiles.wordpress.org/binarymoon\">BinaryMoon</a>, <a href=\"https://profiles.wordpress.org/birgire\">Birgir Erlendsson (birgire)</a>, <a href=\"https://profiles.wordpress.org/bjornw\">BjornW</a>, <a href=\"https://profiles.wordpress.org/bobbingwide\">bobbingwide</a>, <a href=\"https://profiles.wordpress.org/boblinthorst\">boblinthorst</a>, <a href=\"https://profiles.wordpress.org/boboudreau\">boboudreau</a>, <a href=\"https://profiles.wordpress.org/gitlost\">bonger</a>, <a href=\"https://profiles.wordpress.org/boonebgorges\">Boone B. Gorges</a>, <a href=\"https://profiles.wordpress.org/bradyvercher\">Brady Vercher</a>, <a href=\"https://profiles.wordpress.org/brainstormforce\">Brainstorm Force</a>, <a href=\"https://profiles.wordpress.org/kraftbj\">Brandon Kraft</a>, <a href=\"https://profiles.wordpress.org/brianhogg\">Brian Hogg</a>, <a href=\"https://profiles.wordpress.org/krogsgard\">Brian Krogsgard</a>, <a href=\"https://profiles.wordpress.org/bronsonquick\">Bronson Quick</a>, <a href=\"https://profiles.wordpress.org/sixhours\">Caroline Moore</a>, <a href=\"https://profiles.wordpress.org/caseypatrickdriscoll\">Casey Driscoll</a>, <a href=\"https://profiles.wordpress.org/caspie\">Caspie</a>, <a href=\"https://profiles.wordpress.org/chandrapatel\">Chandra Patel</a>, <a href=\"https://profiles.wordpress.org/chaos-engine\">Chaos Engine</a>, <a href=\"https://profiles.wordpress.org/cheeserolls\">cheeserolls</a>, <a href=\"https://profiles.wordpress.org/chesio\">chesio</a>, <a href=\"https://profiles.wordpress.org/ketuchetan\">chetansatasiya</a>, <a href=\"https://profiles.wordpress.org/choongsavvii\">choong</a>, <a href=\"https://profiles.wordpress.org/chouby\">Chouby</a>, <a href=\"https://profiles.wordpress.org/chredd\">chredd</a>, <a href=\"https://profiles.wordpress.org/chrisjean\">Chris Jean</a>, <a href=\"https://profiles.wordpress.org/cmmarslender\">Chris Marslender</a>, <a href=\"https://profiles.wordpress.org/chris_d2d\">Chris Smith</a>, <a href=\"https://profiles.wordpress.org/chrisvanpatten\">Chris Van Patten</a>, <a href=\"https://profiles.wordpress.org/chriswiegman\">Chris Wiegman</a>, <a href=\"https://profiles.wordpress.org/chriscct7\">chriscct7</a>, <a href=\"https://profiles.wordpress.org/chriseverson\">chriseverson</a>, <a href=\"https://profiles.wordpress.org/christian1012\">Christian Chung</a>, <a href=\"https://profiles.wordpress.org/cwpnolen\">Christian Nolen</a>, <a href=\"https://profiles.wordpress.org/needle\">Christian Wach</a>, <a href=\"https://profiles.wordpress.org/christophherr\">Christoph Herr</a>, <a href=\"https://profiles.wordpress.org/clarionwpdeveloper\">Clarion Technologies</a>, <a href=\"https://profiles.wordpress.org/claudiosanches\">Claudio Sanches</a>, <a href=\"https://profiles.wordpress.org/claudiosmweb\">Claudio Sanches</a>, <a href=\"https://profiles.wordpress.org/claudiolabarbera\">ClaudioLaBarbera</a>, <a href=\"https://profiles.wordpress.org/codemovementpk\">codemovement.pk</a>, <a href=\"https://profiles.wordpress.org/coderkevin\">coderkevin</a>, <a href=\"https://profiles.wordpress.org/codfish\">codfish</a>, <a href=\"https://profiles.wordpress.org/coreymcollins\">coreymcollins</a>, <a href=\"https://profiles.wordpress.org/curdin\">Curdin Krummenacher</a>, <a href=\"https://profiles.wordpress.org/cgrymala\">Curtiss Grymala</a>, <a href=\"https://profiles.wordpress.org/cdog\">Cătălin Dogaru</a>, <a href=\"https://profiles.wordpress.org/danhgilmore\">danhgilmore</a>, <a href=\"https://profiles.wordpress.org/danielbachhuber\">Daniel Bachhuber </a>, <a href=\"https://profiles.wordpress.org/danielkanchev\">Daniel Kanchev</a>, <a href=\"https://profiles.wordpress.org/danielpietrasik\">Daniel Pietrasik</a>, <a href=\"https://profiles.wordpress.org/mte90\">Daniele Scasciafratte</a>, <a href=\"https://profiles.wordpress.org/dllh\">Daryl L. L. Houston (dllh)</a>, <a href=\"https://profiles.wordpress.org/davepullig\">Dave Pullig</a>, <a href=\"https://profiles.wordpress.org/goto10\">Dave Romsey (goto10)</a>, <a href=\"https://profiles.wordpress.org/davidakennedy\">David A. Kennedy</a>, <a href=\"https://profiles.wordpress.org/turtlepod\">David Chandra Purnama</a>, <a href=\"https://profiles.wordpress.org/dlh\">David Herrera</a>, <a href=\"https://profiles.wordpress.org/dglingren\">David Lingren</a>, <a href=\"https://profiles.wordpress.org/davidmosterd\">David Mosterd</a>, <a href=\"https://profiles.wordpress.org/dshanske\">David Shanske</a>, <a href=\"https://profiles.wordpress.org/davidbhayes\">davidbhayes</a>, <a href=\"https://profiles.wordpress.org/folletto\">Davide \'Folletto\' Casali</a>, <a href=\"https://profiles.wordpress.org/deeptiboddapati\">deeptiboddapati</a>, <a href=\"https://profiles.wordpress.org/delphinus\">delphinus</a>, <a href=\"https://profiles.wordpress.org/deltafactory\">deltafactory</a>, <a href=\"https://profiles.wordpress.org/denis-de-bernardy\">Denis de Bernardy</a>, <a href=\"https://profiles.wordpress.org/valendesigns\">Derek Herman</a>, <a href=\"https://profiles.wordpress.org/pcfreak30\">Derrick Hammer</a>, <a href=\"https://profiles.wordpress.org/derrickkoo\">Derrick Koo</a>, <a href=\"https://profiles.wordpress.org/dimchik\">dimchik</a>, <a href=\"https://profiles.wordpress.org/dineshc\">Dinesh Chouhan</a>, <a href=\"https://profiles.wordpress.org/dd32\">Dion Hulse</a>, <a href=\"https://profiles.wordpress.org/dipeshkakadiya\">dipeshkakadiya</a>, <a href=\"https://profiles.wordpress.org/dmsnell\">dmsnell</a>, <a href=\"https://profiles.wordpress.org/ocean90\">Dominik Schilling</a>, <a href=\"https://profiles.wordpress.org/dotancohen\">Dotan Cohen</a>, <a href=\"https://profiles.wordpress.org/dougwollison\">Doug Wollison</a>, <a href=\"https://profiles.wordpress.org/doughamlin\">doughamlin</a>, <a href=\"https://profiles.wordpress.org/dreamon11\">DreamOn11</a>, <a href=\"https://profiles.wordpress.org/drewapicture\">Drew Jaynes</a>, <a href=\"https://profiles.wordpress.org/duncanjbrown\">duncanjbrown</a>, <a href=\"https://profiles.wordpress.org/dungengronovius\">dungengronovius</a>, <a href=\"https://profiles.wordpress.org/dylanauty\">DylanAuty</a>, <a href=\"https://profiles.wordpress.org/hurtige\">Eddie Hurtig</a>, <a href=\"https://profiles.wordpress.org/oso96_2000\">Eduardo Reveles</a>, <a href=\"https://profiles.wordpress.org/chopinbach\">Edwin Cromley</a>, <a href=\"https://profiles.wordpress.org/electricfeet\">ElectricFeet</a>, <a href=\"https://profiles.wordpress.org/eliorivero\">Elio Rivero</a>, <a href=\"https://profiles.wordpress.org/iseulde\">Ella Iseulde Van Dorpe</a>, <a href=\"https://profiles.wordpress.org/elyobo\">elyobo</a>, <a href=\"https://profiles.wordpress.org/enodekciw\">enodekciw</a>, <a href=\"https://profiles.wordpress.org/enshrined\">enshrined</a>, <a href=\"https://profiles.wordpress.org/ericlewis\">Eric Andrew Lewis</a>, <a href=\"https://profiles.wordpress.org/pushred\">Eric Lanehart</a>, <a href=\"https://profiles.wordpress.org/eherman24\">Evan Herman</a>, <a href=\"https://profiles.wordpress.org/flixos90\">Felix Arntz</a>, <a href=\"https://profiles.wordpress.org/fencer04\">Fencer04</a>, <a href=\"https://profiles.wordpress.org/florianbrinkmann\">Florian Brinkmann</a>, <a href=\"https://profiles.wordpress.org/mista-flo\">Florian TIAR</a>, <a href=\"https://profiles.wordpress.org/foliovision\">FolioVision</a>, <a href=\"https://profiles.wordpress.org/fomenkoandrey\">fomenkoandrey</a>, <a href=\"https://profiles.wordpress.org/frank-klein\">Frank Klein</a>, <a href=\"https://profiles.wordpress.org/fjarrett\">Frankie Jarrett</a>, <a href=\"https://profiles.wordpress.org/frankiet\">frankiet</a>, <a href=\"https://profiles.wordpress.org/akeif\">Fred</a>, <a href=\"https://profiles.wordpress.org/frozzare\">Fredrik Forsmo</a>, <a href=\"https://profiles.wordpress.org/fuscata\">fuscata</a>, <a href=\"https://profiles.wordpress.org/gma992\">Gabriel Maldonado</a>, <a href=\"https://profiles.wordpress.org/garyj\">Gary Jones</a>, <a href=\"https://profiles.wordpress.org/pento\">Gary Pendergast</a>, <a href=\"https://profiles.wordpress.org/geekysoft\">Geeky Software</a>, <a href=\"https://profiles.wordpress.org/georgestephanis\">George Stephanis</a>, <a href=\"https://profiles.wordpress.org/goranseric\">Goran &#352;erić</a>, <a href=\"https://profiles.wordpress.org/grahamarmfield\">Graham Armfield</a>, <a href=\"https://profiles.wordpress.org/grantderepas\">Grant Derepas</a>, <a href=\"https://profiles.wordpress.org/tivnet\">Gregory Karpinsky (@tivnet)</a>, <a href=\"https://profiles.wordpress.org/hardeepasrani\">Hardeep Asrani</a>, <a href=\"https://profiles.wordpress.org/henrywright\">Henry Wright</a>, <a href=\"https://profiles.wordpress.org/hiddenpearls\">hiddenpearls</a>, <a href=\"https://profiles.wordpress.org/hnle\">Hinaloe</a>, <a href=\"https://profiles.wordpress.org/hristo-sg\">Hristo Pandjarov</a>, <a href=\"https://profiles.wordpress.org/hugobaeta\">Hugo Baeta</a>, <a href=\"https://profiles.wordpress.org/polevaultweb\">Iain Poulson</a>, <a href=\"https://profiles.wordpress.org/iamjolly\">iamjolly</a>, <a href=\"https://profiles.wordpress.org/iandunn\">Ian Dunn</a>, <a href=\"https://profiles.wordpress.org/ianedington\">Ian Edington</a>, <a href=\"https://profiles.wordpress.org/idealien\">idealien</a>, <a href=\"https://profiles.wordpress.org/igmoweb\">Ignacio Cruz Moreno</a>, <a href=\"https://profiles.wordpress.org/imath\">imath</a>, <a href=\"https://profiles.wordpress.org/imnok\">Imnok</a>, <a href=\"https://profiles.wordpress.org/implenton\">implenton</a>, <a href=\"https://profiles.wordpress.org/ionutst\">Ionut Stanciu</a>, <a href=\"https://profiles.wordpress.org/ipstenu\">Ipstenu (Mika Epstein)</a>, <a href=\"https://profiles.wordpress.org/krstarica\">Ivan</a>, <a href=\"https://profiles.wordpress.org/ivdimova\">ivdimova</a>, <a href=\"https://profiles.wordpress.org/jdgrimes\">J.D. Grimes</a>, <a href=\"https://profiles.wordpress.org/jakept\">Jacob Peattie</a>, <a href=\"https://profiles.wordpress.org/whyisjake\">Jake Spurlock</a>, <a href=\"https://profiles.wordpress.org/jnylen0\">James Nylen</a>, <a href=\"https://profiles.wordpress.org/jamesacero\">jamesacero</a>, <a href=\"https://profiles.wordpress.org/japh\">Japh</a>, <a href=\"https://profiles.wordpress.org/jaredcobb\">Jared Cobb</a>, <a href=\"https://profiles.wordpress.org/jayarjo\">jayarjo</a>, <a href=\"https://profiles.wordpress.org/jdolan\">jdolan</a>, <a href=\"https://profiles.wordpress.org/jdoubleu\">jdoubleu</a>, <a href=\"https://profiles.wordpress.org/jblz\">Jeff Bowen</a>, <a href=\"https://profiles.wordpress.org/cheffheid\">Jeffrey de Wit</a>, <a href=\"https://profiles.wordpress.org/jeremyfelt\">Jeremy Felt</a>, <a href=\"https://profiles.wordpress.org/jpry\">Jeremy Pry</a>, <a href=\"https://profiles.wordpress.org/jimt\">jimt</a>, <a href=\"https://profiles.wordpress.org/jipmoors\">Jip Moors</a>, <a href=\"https://profiles.wordpress.org/jmusal\">jmusal</a>, <a href=\"https://profiles.wordpress.org/joedolson\">Joe Dolson</a>, <a href=\"https://profiles.wordpress.org/joehoyle\">Joe Hoyle</a>, <a href=\"https://profiles.wordpress.org/joemcgill\">Joe McGill</a>, <a href=\"https://profiles.wordpress.org/joelcj91\">Joel James</a>, <a href=\"https://profiles.wordpress.org/johanmynhardt\">johanmynhardt</a>, <a href=\"https://profiles.wordpress.org/johnbillion\">John Blackbourn</a>, <a href=\"https://profiles.wordpress.org/zyphonic\">John Dittmar</a>, <a href=\"https://profiles.wordpress.org/johnjamesjacoby\">John James Jacoby</a>, <a href=\"https://profiles.wordpress.org/johnpbloch\">John P. Bloch</a>, <a href=\"https://profiles.wordpress.org/johnregan3\">John Regan</a>, <a href=\"https://profiles.wordpress.org/johnpgreen\">johnpgreen</a>, <a href=\"https://profiles.wordpress.org/kenshino\">Jon (Kenshino)</a>, <a href=\"https://profiles.wordpress.org/jonathanbardo\">Jonathan Bardo</a>, <a href=\"https://profiles.wordpress.org/jbrinley\">Jonathan Brinley</a>, <a href=\"https://profiles.wordpress.org/daggerhart\">Jonathan Daggerhart</a>, <a href=\"https://profiles.wordpress.org/desrosj\">Jonathan Desrosiers</a>, <a href=\"https://profiles.wordpress.org/spacedmonkey\">Jonny Harris</a>, <a href=\"https://profiles.wordpress.org/jonnyauk\">jonnyauk</a>, <a href=\"https://profiles.wordpress.org/jordesign\">jordesign</a>, <a href=\"https://profiles.wordpress.org/jorritschippers\">JorritSchippers</a>, <a href=\"https://profiles.wordpress.org/joefusco\">Joseph Fusco</a>, <a href=\"https://profiles.wordpress.org/jjeaton\">Josh Eaton</a>, <a href=\"https://profiles.wordpress.org/shelob9\">Josh Pollock</a>, <a href=\"https://profiles.wordpress.org/joshcummingsdesign\">joshcummingsdesign</a>, <a href=\"https://profiles.wordpress.org/joshkadis\">joshkadis</a>, <a href=\"https://profiles.wordpress.org/joyously\">Joy</a>, <a href=\"https://profiles.wordpress.org/jrf\">jrf</a>, <a href=\"https://profiles.wordpress.org/jrgould\">JRGould</a>, <a href=\"https://profiles.wordpress.org/juanfra\">Juanfra Aldasoro</a>, <a href=\"https://profiles.wordpress.org/juhise\">Juhi Saxena</a>, <a href=\"https://profiles.wordpress.org/nukaga\">Junko Nukaga</a>, <a href=\"https://profiles.wordpress.org/justinbusa\">Justin Busa</a>, <a href=\"https://profiles.wordpress.org/justinsainton\">Justin Sainton</a>, <a href=\"https://profiles.wordpress.org/jshreve\">Justin Shreve</a>, <a href=\"https://profiles.wordpress.org/jtsternberg\">Justin Sternberg</a>, <a href=\"https://profiles.wordpress.org/kadamwhite\">K.Adam White</a>, <a href=\"https://profiles.wordpress.org/kacperszurek\">kacperszurek</a>, <a href=\"https://profiles.wordpress.org/trepmal\">Kailey (trepmal)</a>, <a href=\"https://profiles.wordpress.org/kalenjohnson\">KalenJohnson</a>, <a href=\"https://profiles.wordpress.org/codebykat\">Kat Hagan</a>, <a href=\"https://profiles.wordpress.org/kkoppenhaver\">Keanan Koppenhaver</a>, <a href=\"https://profiles.wordpress.org/keesiemeijer\">keesiemeijer</a>, <a href=\"https://profiles.wordpress.org/kellbot\">kellbot</a>, <a href=\"https://profiles.wordpress.org/ryelle\">Kelly Dwan</a>, <a href=\"https://profiles.wordpress.org/wraithkenny\">Ken Newman</a>, <a href=\"https://profiles.wordpress.org/khag7\">Kevin Hagerty</a>, <a href=\"https://profiles.wordpress.org/kwight\">Kirk Wight</a>, <a href=\"https://profiles.wordpress.org/kitchin\">kitchin</a>, <a href=\"https://profiles.wordpress.org/ixkaito\">Kite</a>, <a href=\"https://profiles.wordpress.org/kjbenk\">kjbenk</a>, <a href=\"https://profiles.wordpress.org/knutsp\">Knut Sparhell</a>, <a href=\"https://profiles.wordpress.org/koenschipper\">koenschipper</a>, <a href=\"https://profiles.wordpress.org/kokarn\">kokarn</a>, <a href=\"https://profiles.wordpress.org/kovshenin\">Konstantin Kovshenin</a>, <a href=\"https://profiles.wordpress.org/obenland\">Konstantin Obenland</a>, <a href=\"https://profiles.wordpress.org/kouratoras\">Konstantinos Kouratoras</a>, <a href=\"https://profiles.wordpress.org/kuchenundkakao\">kuchenundkakao</a>, <a href=\"https://profiles.wordpress.org/kuldipem\">kuldipem</a>, <a href=\"https://profiles.wordpress.org/laurelfulford\">Laurel Fulford</a>, <a href=\"https://profiles.wordpress.org/leewillis77\">Lee Willis</a>, <a href=\"https://profiles.wordpress.org/leobaiano\">Leo Baiano</a>, <a href=\"https://profiles.wordpress.org/littlebigthing\">LittleBigThings (Csaba)</a>, <a href=\"https://profiles.wordpress.org/lucasstark\">Lucas Stark</a>, <a href=\"https://profiles.wordpress.org/lukecavanagh\">Luke Cavanagh</a>, <a href=\"https://profiles.wordpress.org/lgedeon\">Luke Gedeon</a>, <a href=\"https://profiles.wordpress.org/lukepettway\">lukepettway</a>, <a href=\"https://profiles.wordpress.org/lyubomir_popov\">lyubomir_popov</a>, <a href=\"https://profiles.wordpress.org/mageshp\">mageshp</a>, <a href=\"https://profiles.wordpress.org/mahesh901122\">Mahesh Waghmare</a>, <a href=\"https://profiles.wordpress.org/mangeshp\">Mangesh Parte</a>, <a href=\"https://profiles.wordpress.org/manishsongirkar36\">Manish Songirkar</a>, <a href=\"https://profiles.wordpress.org/mantismamita\">mantismamita</a>, <a href=\"https://profiles.wordpress.org/mbootsman\">Marcel Bootsman</a>, <a href=\"https://profiles.wordpress.org/tyxla\">Marin Atanasov</a>, <a href=\"https://profiles.wordpress.org/mariovalney\">Mario Valney</a>, <a href=\"https://profiles.wordpress.org/clorith\">Marius L. J.</a>, <a href=\"https://profiles.wordpress.org/markjaquith\">Mark Jaquith</a>, <a href=\"https://profiles.wordpress.org/mrwweb\">Mark Root-Wiley</a>, <a href=\"https://profiles.wordpress.org/mapk\">Mark Uraine</a>, <a href=\"https://profiles.wordpress.org/markoheijnen\">Marko Heijnen</a>, <a href=\"https://profiles.wordpress.org/markshep\">markshep</a>, <a href=\"https://profiles.wordpress.org/matrixik\">matrixik</a>, <a href=\"https://profiles.wordpress.org/mjbanks\">Matt Banks</a>, <a href=\"https://profiles.wordpress.org/jaworskimatt\">Matt Jaworski</a>, <a href=\"https://profiles.wordpress.org/mattking5000\">Matt King</a>, <a href=\"https://profiles.wordpress.org/matt\">Matt Mullenweg</a>, <a href=\"https://profiles.wordpress.org/veraxus\">Matt van Andel</a>, <a href=\"https://profiles.wordpress.org/mattwiebe\">Matt Wiebe</a>, <a href=\"https://profiles.wordpress.org/mattheu\">Matthew Haines-Young</a>, <a href=\"https://profiles.wordpress.org/mattyrob\">mattyrob</a>, <a href=\"https://profiles.wordpress.org/maxcutler\">Max Cutler</a>, <a href=\"https://profiles.wordpress.org/maximeculea\">Maxime Culea</a>, <a href=\"https://profiles.wordpress.org/mayukojpn\">Mayo Moriyama</a>, <a href=\"https://profiles.wordpress.org/mbelchev\">mbelchev</a>, <a href=\"https://profiles.wordpress.org/mckernanin\">mckernanin</a>, <a href=\"https://profiles.wordpress.org/melchoyce\">Mel Choyce</a>, <a href=\"https://profiles.wordpress.org/mhowell\">mhowell</a>, <a href=\"https://profiles.wordpress.org/michael-arestad\">Michael Arestad</a>, <a href=\"https://profiles.wordpress.org/michaelarestad\">Michael Arestad</a>, <a href=\"https://profiles.wordpress.org/michalzuber\">michalzuber</a>, <a href=\"https://profiles.wordpress.org/mauteri\">Mike Auteri</a>, <a href=\"https://profiles.wordpress.org/mihai2u\">Mike Crantea</a>, <a href=\"https://profiles.wordpress.org/mdgl\">Mike Glendinning</a>, <a href=\"https://profiles.wordpress.org/mikehansenme\">Mike Hansen</a>, <a href=\"https://profiles.wordpress.org/mikelittle\">Mike Little</a>, <a href=\"https://profiles.wordpress.org/mikeschroder\">Mike Schroder</a>, <a href=\"https://profiles.wordpress.org/mikeviele\">Mike Viele</a>, <a href=\"https://profiles.wordpress.org/dimadin\">Milan Dinić</a>, <a href=\"https://profiles.wordpress.org/modemlooper\">modemlooper</a>, <a href=\"https://profiles.wordpress.org/batmoo\">Mohammad Jangda</a>, <a href=\"https://profiles.wordpress.org/deremohan\">Mohan Dere</a>, <a href=\"https://profiles.wordpress.org/monikarao\">monikarao</a>, <a href=\"https://profiles.wordpress.org/morettigeorgiev\">morettigeorgiev</a>, <a href=\"https://profiles.wordpress.org/morganestes\">Morgan Estes</a>, <a href=\"https://profiles.wordpress.org/mor10\">Morten Rand-Hendriksen</a>, <a href=\"https://profiles.wordpress.org/mt8biz\">moto hachi ( mt8.biz )</a>, <a href=\"https://profiles.wordpress.org/mrbobbybryant\">mrbobbybryant</a>, <a href=\"https://profiles.wordpress.org/nnaimov\">Naim Naimov</a>, <a href=\"https://profiles.wordpress.org/natereist\">Nate Reist</a>, <a href=\"https://profiles.wordpress.org/natewr\">NateWr</a>, <a href=\"https://profiles.wordpress.org/nathanrice\">nathanrice</a>, <a href=\"https://profiles.wordpress.org/nazgul\">Nazgul</a>, <a href=\"https://profiles.wordpress.org/greatislander\">Ned Zimmerman</a>, <a href=\"https://profiles.wordpress.org/celloexpressions\">Nick Halsey </a>, <a href=\"https://profiles.wordpress.org/nikeo\">Nicolas GUILLAUME</a>, <a href=\"https://profiles.wordpress.org/nikschavan\">Nikhil Chavan</a>, <a href=\"https://profiles.wordpress.org/nikv\">Nikhil Vimal</a>, <a href=\"https://profiles.wordpress.org/nbachiyski\">Nikolay Bachiyski</a>, <a href=\"https://profiles.wordpress.org/rabmalin\">Nilambar Sharma</a>, <a href=\"https://profiles.wordpress.org/noplanman\">noplanman</a>, <a href=\"https://profiles.wordpress.org/nullvariable\">nullvariable</a>, <a href=\"https://profiles.wordpress.org/odie2\">odie2</a>, <a href=\"https://profiles.wordpress.org/odysseygate\">odyssey</a>, <a href=\"https://profiles.wordpress.org/hideokamoto\">Okamoto Hidetaka</a>, <a href=\"https://profiles.wordpress.org/orvils\">orvils</a>, <a href=\"https://profiles.wordpress.org/oskosk\">oskosk</a>, <a href=\"https://profiles.wordpress.org/ottok\">Otto Kek&#228;l&#228;inen</a>, <a href=\"https://profiles.wordpress.org/ovann86\">ovann86</a>, <a href=\"https://profiles.wordpress.org/swissspidy\">Pascal Birchler</a>, <a href=\"https://profiles.wordpress.org/patilvikasj\">patilvikasj</a>, <a href=\"https://profiles.wordpress.org/pbearne\">Paul Bearne</a>, <a href=\"https://profiles.wordpress.org/paulwilde\">Paul Wilde</a>, <a href=\"https://profiles.wordpress.org/sirbrillig\">Payton Swick</a>, <a href=\"https://profiles.wordpress.org/pdufour\">pdufour</a>, <a href=\"https://profiles.wordpress.org/piewp\">Perdaan</a>, <a href=\"https://profiles.wordpress.org/peterwilsoncc\">Peter Wilson</a>, <a href=\"https://profiles.wordpress.org/phh\">phh</a>, <a href=\"https://profiles.wordpress.org/php\">php</a>, <a href=\"https://profiles.wordpress.org/delawski\">Piotr Delawski</a>, <a href=\"https://profiles.wordpress.org/pippinsplugins\">pippinsplugins</a>, <a href=\"https://profiles.wordpress.org/pjgalbraith\">pjgalbraith</a>, <a href=\"https://profiles.wordpress.org/pkevan\">pkevan</a>, <a href=\"https://profiles.wordpress.org/pratikchaskar\">Pratik</a>, <a href=\"https://profiles.wordpress.org/pressionate\">Pressionate</a>, <a href=\"https://profiles.wordpress.org/presskopp\">Presskopp</a>, <a href=\"https://profiles.wordpress.org/procodewp\">procodewp</a>, <a href=\"https://profiles.wordpress.org/quasel\">quasel</a>, <a href=\"https://profiles.wordpress.org/rachelbaker\">Rachel Baker</a>, <a href=\"https://profiles.wordpress.org/rahulsprajapati\">Rahul Prajapati</a>, <a href=\"https://profiles.wordpress.org/superpoincare\">Ramanan</a>, <a href=\"https://profiles.wordpress.org/ramiy\">Rami Yushuvaev</a>, <a href=\"https://profiles.wordpress.org/ramiabraham\">ramiabraham</a>, <a href=\"https://profiles.wordpress.org/ranh\">ranh</a>, <a href=\"https://profiles.wordpress.org/redsand\">Red Sand Media Group</a>, <a href=\"https://profiles.wordpress.org/youknowriad\">Riad Benguella</a>, <a href=\"https://profiles.wordpress.org/rianrietveld\">Rian Rietveld</a>, <a href=\"https://profiles.wordpress.org/iamfriendly\">Richard Tape</a>, <a href=\"https://profiles.wordpress.org/rpayne7264\">Robert D Payne</a>, <a href=\"https://profiles.wordpress.org/rnoakes3rd\">Robert Noakes</a>, <a href=\"https://profiles.wordpress.org/d4z_c0nf\">Rocco Aliberti</a>, <a href=\"https://profiles.wordpress.org/rodrigosprimo\">Rodrigo Primo</a>, <a href=\"https://profiles.wordpress.org/rommelxcastro\">Rommel Castro</a>, <a href=\"https://profiles.wordpress.org/fronaldaraujo\">Ronald Ara&#250;jo</a>, <a href=\"https://profiles.wordpress.org/magicroundabout\">Ross Wintle</a>, <a href=\"https://profiles.wordpress.org/guavaworks\">Roy Sivan</a>, <a href=\"https://profiles.wordpress.org/ryankienstra\">Ryan Kienstra</a>, <a href=\"https://profiles.wordpress.org/rmccue\">Ryan McCue</a>, <a href=\"https://profiles.wordpress.org/ryanplas\">Ryan Plas</a>, <a href=\"https://profiles.wordpress.org/welcher\">Ryan Welcher</a>, <a href=\"https://profiles.wordpress.org/salcode\">Sal Ferrarello</a>, <a href=\"https://profiles.wordpress.org/samikeijonen\">Sami Keijonen</a>, <a href=\"https://profiles.wordpress.org/solarissmoke\">Samir Shah</a>, <a href=\"https://profiles.wordpress.org/samuelsidler\">Samuel Sidler</a>, <a href=\"https://profiles.wordpress.org/sandesh055\">Sandesh</a>, <a href=\"https://profiles.wordpress.org/smyoon315\">Sang-Min Yoon</a>, <a href=\"https://profiles.wordpress.org/sanketparmar\">Sanket Parmar</a>, <a href=\"https://profiles.wordpress.org/pollyplummer\">Sarah Gooding</a>, <a href=\"https://profiles.wordpress.org/sayedwp\">Sayed Taqui</a>, <a href=\"https://profiles.wordpress.org/schlessera\">schlessera</a>, <a href=\"https://profiles.wordpress.org/schrapel\">schrapel</a>, <a href=\"https://profiles.wordpress.org/coffee2code\">Scott Reilly</a>, <a href=\"https://profiles.wordpress.org/wonderboymusic\">Scott Taylor</a>, <a href=\"https://profiles.wordpress.org/scrappyhuborg\">scrappy@hub.org</a>, <a href=\"https://profiles.wordpress.org/scribu\">scribu</a>, <a href=\"https://profiles.wordpress.org/seancjones\">seancjones</a>, <a href=\"https://profiles.wordpress.org/sebastianpisula\">Sebastian Pisula</a>, <a href=\"https://profiles.wordpress.org/sergeybiryukov\">Sergey Biryukov</a>, <a href=\"https://profiles.wordpress.org/sgr33n\">Sergio De Falco</a>, <a href=\"https://profiles.wordpress.org/sfpt\">sfpt</a>, <a href=\"https://profiles.wordpress.org/shayanys\">shayanys</a>, <a href=\"https://profiles.wordpress.org/shazahm1hotmailcom\">shazahm1</a>, <a href=\"https://profiles.wordpress.org/shprink\">shprink</a>, <a href=\"https://profiles.wordpress.org/simonlampen\">simonlampen</a>, <a href=\"https://profiles.wordpress.org/skippy\">skippy</a>, <a href=\"https://profiles.wordpress.org/smerriman\">smerriman</a>, <a href=\"https://profiles.wordpress.org/snacking\">snacking</a>, <a href=\"https://profiles.wordpress.org/soean\">Soeren Wrede</a>, <a href=\"https://profiles.wordpress.org/solal\">solal</a>, <a href=\"https://profiles.wordpress.org/sstoqnov\">Stanimir Stoyanov</a>, <a href=\"https://profiles.wordpress.org/metodiew\">Stanko Metodiev</a>, <a href=\"https://profiles.wordpress.org/sharkomatic\">Steph</a>, <a href=\"https://profiles.wordpress.org/sswells\">Steph Wells</a>, <a href=\"https://profiles.wordpress.org/sillybean\">Stephanie Leary</a>, <a href=\"https://profiles.wordpress.org/netweb\">Stephen Edgar</a>, <a href=\"https://profiles.wordpress.org/stephenharris\">Stephen Harris</a>, <a href=\"https://profiles.wordpress.org/stevenkword\">Steven Word</a>, <a href=\"https://profiles.wordpress.org/stevenlinx\">stevenlinx</a>, <a href=\"https://profiles.wordpress.org/stubgo\">stubgo</a>, <a href=\"https://profiles.wordpress.org/sudar\">Sudar Muthu</a>, <a href=\"https://profiles.wordpress.org/patilswapnilv\">Swapnil V. Patil</a>, <a href=\"https://profiles.wordpress.org/swapnild\">swapnild</a>, <a href=\"https://profiles.wordpress.org/szaqal21\">szaqal21</a>, <a href=\"https://profiles.wordpress.org/takahashi_fumiki\">Takahashi Fumiki</a>, <a href=\"https://profiles.wordpress.org/miyauchi\">Takayuki Miyauchi</a>, <a href=\"https://profiles.wordpress.org/karmatosed\">Tammie Lister</a>, <a href=\"https://profiles.wordpress.org/tapsboy\">tapsboy</a>, <a href=\"https://profiles.wordpress.org/tlovett1\">Taylor Lovett</a>, <a href=\"https://profiles.wordpress.org/team\">team</a>, <a href=\"https://profiles.wordpress.org/tg29359\">tg29359</a>, <a href=\"https://profiles.wordpress.org/tharsheblows\">tharsheblows</a>, <a href=\"https://profiles.wordpress.org/the\">the</a>, <a href=\"https://profiles.wordpress.org/themeshaper\">themeshaper</a>, <a href=\"https://profiles.wordpress.org/thenbrent\">thenbrent</a>, <a href=\"https://profiles.wordpress.org/thomaswm\">thomaswm</a>, <a href=\"https://profiles.wordpress.org/tfrommen\">Thorsten Frommen</a>, <a href=\"https://profiles.wordpress.org/tierra\">tierra</a>, <a href=\"https://profiles.wordpress.org/tnash\">Tim Nash</a>, <a href=\"https://profiles.wordpress.org/timmydcrawford\">Timmy Crawford</a>, <a href=\"https://profiles.wordpress.org/timothyblynjacobs\">Timothy Jacobs</a>, <a href=\"https://profiles.wordpress.org/timph\">timph</a>, <a href=\"https://profiles.wordpress.org/tkama\">Tkama</a>, <a href=\"https://profiles.wordpress.org/tnegri\">tnegri</a>, <a href=\"https://profiles.wordpress.org/tomauger\">Tom Auger</a>, <a href=\"https://profiles.wordpress.org/tjnowell\">Tom J Nowell</a>, <a href=\"https://profiles.wordpress.org/tomdxw\">tomdxw</a>, <a href=\"https://profiles.wordpress.org/toro_unit\">Toro_Unit (Hiroshi Urabe)</a>, <a href=\"https://profiles.wordpress.org/zodiac1978\">Torsten Landsiedel</a>, <a href=\"https://profiles.wordpress.org/transl8or\">transl8or</a>, <a href=\"https://profiles.wordpress.org/traversal\">traversal</a>, <a href=\"https://profiles.wordpress.org/wpsmith\">Travis Smith</a>, <a href=\"https://profiles.wordpress.org/nmt90\">Triet Minh</a>, <a href=\"https://profiles.wordpress.org/trishasalas\">Trisha Salas</a>, <a href=\"https://profiles.wordpress.org/tristangemus\">tristangemus</a>, <a href=\"https://profiles.wordpress.org/truongwp\">Truong Giang</a>, <a href=\"https://profiles.wordpress.org/tsl143\">tsl143</a>, <a href=\"https://profiles.wordpress.org/tywayne\">Ty Carlson</a>, <a href=\"https://profiles.wordpress.org/grapplerulrich\">Ulrich</a>, <a href=\"https://profiles.wordpress.org/utkarshpatel\">Utkarsh</a>, <a href=\"https://profiles.wordpress.org/valeriutihai\">Valeriu Tihai</a>, <a href=\"https://profiles.wordpress.org/vishalkakadiya\">Vishal Kakadiya</a>, <a href=\"https://profiles.wordpress.org/voldemortensen\">voldemortensen</a>, <a href=\"https://profiles.wordpress.org/vortfu\">vortfu</a>, <a href=\"https://profiles.wordpress.org/vrundakansara-1\">Vrunda Kansara</a>, <a href=\"https://profiles.wordpress.org/webbgaraget\">webbgaraget</a>, <a href=\"https://profiles.wordpress.org/webmandesign\">WebMan Design &#124; Oliver Juhas</a>, <a href=\"https://profiles.wordpress.org/websupporter\">websupporter</a>, <a href=\"https://profiles.wordpress.org/westonruter\">Weston Ruter</a>, <a href=\"https://profiles.wordpress.org/earnjam\">William Earnhardt</a>, <a href=\"https://profiles.wordpress.org/williampatton\">williampatton</a>, <a href=\"https://profiles.wordpress.org/wolly\">Wolly aka Paolo Valenti</a>, <a href=\"https://profiles.wordpress.org/yale01\">yale01</a>, <a href=\"https://profiles.wordpress.org/yoavf\">Yoav Farhi</a>, <a href=\"https://profiles.wordpress.org/yogasukma\">Yoga Sukma</a>, <a href=\"https://profiles.wordpress.org/oxymoron\">Zach Wills</a>, <a href=\"https://profiles.wordpress.org/tollmanz\">Zack Tollman</a>, <a href=\"https://profiles.wordpress.org/vanillalounge\">Ze Fontainhas</a>, <a href=\"https://profiles.wordpress.org/zhildzik\">zhildzik</a>, and <a href=\"https://profiles.wordpress.org/zsusag\">zsusag</a>.\n<p>&nbsp;<br />\nSpecial thanks go to <a href=\"https://ramiabraham.com/\">Rami Abraham</a> for producing the release video and the many fine haiku we saw in the <a href=\"https://wordpress.org/news/2016/10/wordpress-4-7-beta-1/\">beta</a> and <a href=\"https://wordpress.org/news/2016/11/wordpress-4-7-release-candidate/\">RC</a> announcement posts.</p>\n<p>Finally, thanks to all the community translators who worked on WordPress 4.7. Their efforts bring WordPress 4.7 fully translated to 52 languages at release time with more on the way. Additionally, the WordPress 4.7 release video has been captioned into 44 languages.</p>\n<p>If you want to follow along or help out, check out <a href=\"https://make.wordpress.org/\">Make WordPress</a> and our <a href=\"https://make.wordpress.org/core/\">core development blog</a>. Thanks for choosing WordPress &#8211; we hope you enjoy!</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"4596\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:2;a:6:{s:4:\"data\";s:33:\"\n		\n		\n		\n		\n				\n\n		\n		\n				\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:17:\"Moving Toward SSL\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"https://wordpress.org/news/2016/12/moving-toward-ssl/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 01 Dec 2016 17:20:29 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=4588\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:327:\"We’re at a turning point: 2017 is going to be the year that we’re going to see features in WordPress which require hosts to have HTTPS available. Just as JavaScript is a near necessity for smoother user experiences and more modern PHP versions are critical for performance, SSL just makes sense as the next hurdle [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Matt Mullenweg\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:1627:\"<p>We’re at a turning point: 2017 is going to be the year that we’re going to see features in WordPress which require hosts to have HTTPS available. Just as JavaScript is a near necessity for smoother user experiences and more modern PHP versions are critical for performance, SSL just makes sense as the next hurdle our users are going to face.</p>\n<p>SSL basically means the link between your browser and the server is encrypted. SSL used to be difficult to implement, and often expensive or slow. Modern browsers, and the incredible success of projects like <a href=\"https://letsencrypt.org/\">Let&#8217;s Encrypt</a> have made getting a certificate to secure your site fast, free, and something we think every host should support by default, especially in a post-Snowden era. Google also weighs <a href=\"https://security.googleblog.com/2014/08/https-as-ranking-signal_6.html\">SSL as a search engine ranking factor</a> and will begin <a href=\"http://motherboard.vice.com/read/google-will-soon-shame-all-websites-that-are-unencrypted-chrome-https\">flagging unencrypted sites in Chrome</a>.</p>\n<p>First, early in 2017, we will only promote hosting partners that provide a SSL certificate by default in their accounts. Later we will begin to assess which features, such as API authentication, would benefit the most from SSL and make them only enabled when SSL is there.</p>\n<p>Separately, I also think the performance improvements in PHP7 are particularly impressive, and major kudos to everyone who worked on that. We will consider whether hosts use PHP7 by default for new accounts next year as well.</p>\n<p>&nbsp;</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"4588\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:3;a:6:{s:4:\"data\";s:33:\"\n		\n		\n		\n		\n				\n\n		\n		\n				\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"WordPress 4.7 Release Candidate\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:67:\"https://wordpress.org/news/2016/11/wordpress-4-7-release-candidate/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 24 Nov 2016 04:26:23 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=4579\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:328:\"The release candidate for WordPress 4.7 is now available. RC means we think we’re done, but with millions of users and thousands of plugins and themes, it’s possible we’ve missed something. We hope to ship WordPress 4.7 on Tuesday, December 6, but we need your help to get there. If you haven’t tested 4.7 yet, [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Helen Hou-Sandi\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:4331:\"<p>The release candidate for WordPress 4.7 is now available.</p>\n<p>RC means we think we’re done, but with millions of users and thousands of plugins and themes, it’s possible we’ve missed something. We hope to ship WordPress 4.7 on <strong>Tuesday, December 6</strong>, but we need <em>your</em> help to get there. If you haven’t tested 4.7 yet, now is the time! To test WordPress 4.7, you can use the <a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\">WordPress Beta Tester</a> plugin or you can <a href=\"https://wordpress.org/wordpress-4.7-RC1.zip\">download the release candidate here</a> (zip).</p>\n<p>WordPress 4.7 is a jam-packed release, with a number of features focused on getting a theme set up for the first time. Highlights include a <a href=\"http://2017.wordpress.net/\">new default theme</a>, video headers, custom CSS, customizer edit shortcuts, PDF thumbnail previews, user admin languages, REST API content endpoints, post type templates, and more.</p>\n<p>We’ve made <a href=\"https://core.trac.wordpress.org/log/trunk/src?action=stop_on_copy&amp;mode=stop_on_copy&amp;rev=39353&amp;stop_rev=39263&amp;limit=200&amp;verbose=on&amp;sfp_email=&amp;sfph_mail=\">quite a few refinements</a> since releasing Beta 4 a week ago, including usability and accessibility enhancements for video headers, media and page template support in starter content, and polishing of how custom CSS can be migrated to and extended by plugins and themes. The REST API endpoints saw a number of bugfixes and notably now have anonymous comment off by default.</p>\n<p>Not sure where to start with testing? Try setting up a fresh site on a new installation with Twenty Seventeen (hint: head into customizing your site before touching any pages or widgets) and taking notes on what you enjoyed and what got you stuck. For more details about what&#8217;s new in version 4.7, check out the <a href=\"https://wordpress.org/news/2016/10/wordpress-4-7-beta-1/\">Beta 1</a>, <a href=\"https://wordpress.org/news/2016/11/wordpress-4-7-beta-2/\">Beta 2</a>, <a href=\"https://wordpress.org/news/2016/11/wordpress-4-7-beta-3/\">Beta 3</a>, and <a href=\"https://wordpress.org/news/2016/11/wordpress-4-7-beta-4/\">Beta 4</a> blog posts.</p>\n<p><strong>Think you’ve found a bug?</strong> Please post to the <a href=\"https://wordpress.org/support/forum/alphabeta/\">Alpha/Beta support forum</a>. If any known issues come up, you’ll be able to <a href=\"https://core.trac.wordpress.org/report/5\">find them here</a>.</p>\n<p><strong>Developers</strong>, please test your plugins and themes against WordPress 4.7 and update your plugin’s <em>Tested up to</em> version in the readme to 4.7. If you find compatibility problems please be sure to post to the support forums so we can figure those out before the final release – we work hard to avoid breaking things. An in-depth field guide to developer-focused changes is coming soon on the <a href=\"https://make.wordpress.org/core/\">core development blog</a>.</p>\n<p>Do you speak a language other than English? <a href=\"https://translate.wordpress.org/projects/wp/dev\">Help us translate WordPress into more than 100 languages!</a> And if you haven&#8217;t yet done so, now is a great time to <a href=\"https://wordpressdotorg.polldaddy.com/s/wordpress-2016-survey\">take the Annual WordPress Survey</a> and send it on to your friends.</p>\n<p>Happy testing! And now for another <a href=\"https://profiles.wordpress.org/ramiabraham\">Rami Abraham</a> haiku break.</p>\n<p><em>Select your language</em><br />\n<em>Then let your users choose theirs</em><br />\n<em><code>get_user_locale()</code></em></p>\n<p><em>Theme authors rejoice</em><br />\n<em>Any option may employ</em><br />\n<em>Selective refresh</em></p>\n<p><em>Custom header video</em><br />\n<em>Make sure to <code>add_theme_support</code></em><br />\n<em>Bling above the fold</em></p>\n<p><em>A new template dawns</em><br />\n<em>A hierarchy member</em><br />\n<em>Post-type templates live</em></p>\n<p><em>PDF updates</em><br />\n<em>Pack a parade of polish</em><br />\n<em>Prettier previews</em></p>\n<p><em>Template Post Type: New</em><br />\n<em>Template Post Type: And Useful</em><br />\n<em>Template Post Type: Thing</em></p>\n<p><em>Let lists live lively</em><br />\n<em>Laud <code>wp_list_sort()</code></em><br />\n<em>Less laconic lists</em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"4579\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:4;a:6:{s:4:\"data\";s:33:\"\n		\n		\n		\n		\n				\n\n		\n		\n				\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:20:\"WordPress 4.7 Beta 4\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://wordpress.org/news/2016/11/wordpress-4-7-beta-4/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 16 Nov 2016 01:51:52 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=4576\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:329:\"WordPress 4.7 Beta 4 is now available! This software is still in development, so we don’t recommend you run it on a production site. Consider setting up a test site just to play with the new version. To test WordPress 4.7, try the WordPress Beta Tester plugin (you’ll want “bleeding edge nightlies”). Or you can [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Helen Hou-Sandi\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:2019:\"<p>WordPress 4.7 Beta 4 is now available!</p>\n<p><strong>This software is still in development,</strong> so we don’t recommend you run it on a production site. Consider setting up a test site just to play with the new version. To test WordPress 4.7, try the <a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\">WordPress Beta Tester</a> plugin (you’ll want “bleeding edge nightlies”). Or you can <a href=\"https://wordpress.org/wordpress-4.7-beta4.zip\">download the beta here</a> (zip).</p>\n<p>For more information on what’s new in 4.7, check out the <a href=\"https://wordpress.org/news/2016/10/wordpress-4-7-beta-1/\">Beta 1,</a> <a href=\"https://wordpress.org/news/2016/11/wordpress-4-7-beta-2/\">Beta 2</a>, and <a href=\"https://wordpress.org/news/2016/11/wordpress-4-7-beta-3/\">Beta 3</a> blog posts, along with <a href=\"https://make.wordpress.org/core/tag/4-7+dev-notes/\">in-depth developer guides on make/core</a>. We’ve made <a href=\"https://core.trac.wordpress.org/log/trunk/src?action=stop_on_copy&amp;mode=stop_on_copy&amp;rev=39262&amp;stop_rev=39201&amp;limit=200&amp;verbose=on&amp;sfp_email=&amp;sfph_mail=\">about 60 changes</a> in the last few days for beta 4, including tweaks to Twenty Seventeen, custom CSS, and the REST API content endpoints.</p>\n<p>Do you speak a language other than English? <a href=\"https://translate.wordpress.org/projects/wp/dev\">Help us translate WordPress into more than 100 languages!</a></p>\n<p><strong>If you think you’ve found a bug</strong>, you can post to the <a href=\"https://wordpress.org/support/forum/alphabeta\">Alpha/Beta area</a> in the support forums. We’d love to hear from you! If you’re comfortable writing a reproducible bug report, <a href=\"https://make.wordpress.org/core/reports/\">file one on WordPress Trac</a>, where you can also find <a href=\"https://core.trac.wordpress.org/tickets/major\">a list of known bugs</a>.</p>\n<p><em>We are almost there<br />\nPlease test your plugins and themes<br />\nRC coming soon<br />\n</em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"4576\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:5;a:6:{s:4:\"data\";s:33:\"\n		\n		\n		\n		\n				\n\n		\n		\n				\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"WordCamp US 2017-2018 in Nashville\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:70:\"https://wordpress.org/news/2016/11/wordcamp-us-2017-2018-in-nashville/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 15 Nov 2016 23:24:17 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"WordCamp\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=4571\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:330:\"The title says it all. We had some great applications for cities to host WordCamp US after we finish up in Philadelphia this year, and the city chosen for 2017-2018 is Nashville, Tennessee. Based on the other great applications we got I&#8217;m also excited about the pipeline of communities that could host it in future [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Matt Mullenweg\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:1022:\"<p><img class=\"aligncenter\" src=\"https://i0.wp.com/wpdotorg.files.wordpress.com/2008/07/27492741871_c6fcebcad3_k-e1479248587522.jpg?resize=632%2C253&#038;ssl=1\" data-recalc-dims=\"1\" /></p>\n<p>The title says it all. We had some great applications for cities to host <a href=\"http://us.wordcamp.org/\">WordCamp US</a> after we finish up in Philadelphia this year, and the city chosen for 2017-2018 is <strong>Nashville, Tennessee</strong>.</p>\n<p>Based on the other great applications we got I&#8217;m also excited about the pipeline of communities that could host it in future years as WordCamp US travels across the United States and gives us an opportunity to learn and love a new city, as we have with Philadelphia.</p>\n<p>By the way, if you haven&#8217;t yet, now is a great time to <a href=\"https://wordpressdotorg.polldaddy.com/s/wordpress-2016-survey\">take the Annual WordPress Survey</a> and ask your friends to as well.</p>\n<p><a href=\"https://www.flickr.com/photos/143951935@N07/27492741871\">Photo Credit</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"4571\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:6;a:6:{s:4:\"data\";s:39:\"\n		\n		\n		\n		\n				\n		\n		\n\n		\n		\n				\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:20:\"WordPress 4.7 Beta 3\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://wordpress.org/news/2016/11/wordpress-4-7-beta-3/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 11 Nov 2016 03:30:52 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:3:{i:0;a:5:{s:4:\"data\";s:11:\"Development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:3:\"4.7\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=4566\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:329:\"WordPress 4.7 Beta 3 is now available! This software is still in development, so we don’t recommend you run it on a production site. Consider setting up a test site just to play with the new version. To test WordPress 4.7, try the WordPress Beta Tester plugin (you’ll want “bleeding edge nightlies”). Or you can [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Helen Hou-Sandi\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:3120:\"<p>WordPress 4.7 Beta 3 is now available!</p>\n<p><strong>This software is still in development,</strong> so we don’t recommend you run it on a production site. Consider setting up a test site just to play with the new version. To test WordPress 4.7, try the <a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\">WordPress Beta Tester</a> plugin (you’ll want “bleeding edge nightlies”). Or you can <a href=\"https://wordpress.org/wordpress-4.7-beta3.zip\">download the beta here</a> (zip).</p>\n<p>For more information on what’s new in 4.7, check out the <a href=\"https://wordpress.org/news/2016/10/wordpress-4-7-beta-1/\">Beta 1</a> and <a href=\"https://wordpress.org/news/2016/11/wordpress-4-7-beta-2/\">Beta 2</a> blog posts, along with <a href=\"https://make.wordpress.org/core/tag/4-7+dev-notes/\">in-depth field guides on make/core</a>. Some of the changes in Beta 3 include:</p>\n<ul>\n<li><strong>REST API:</strong> The <code>unfiltered_html</code> capability is now respected and <code>rest_base</code> has been added to response objects of <code>wp/v2/taxonomies</code> and <code>wp/v2/types</code>, while <code>get_allowed_query_vars()</code> and the <code>rest_get_post</code> filter have been removed.</li>\n<li><strong>Roles/Capabilities:</strong> Added meta-caps for comment, term, and user meta, which are currently only used in the REST API.</li>\n<li><strong>I18N:</strong> Added the ability to change user&#8217;s locale back to site&#8217;s locale. (<a href=\"https://core.trac.wordpress.org/ticket/38632\">#38632</a>)</li>\n<li><strong>Custom CSS:</strong> Renamed the <code>unfiltered_css</code> meta capability to <code>edit_css</code> and added revisions support to the <code>custom_css</code> post type.</li>\n<li><strong>Edit shortcuts:</strong> Theme authors should take a look at <a href=\"https://make.wordpress.org/core/2016/11/10/visible-edit-shortcuts-in-the-customizer-preview/\">the developer guide to the customizer preview&#8217;s visible edit shortcuts</a> and update their themes to take advantage of them if not already implementing selective refresh.</li>\n<li><strong>Various bug fixes:</strong> We’ve made <a href=\"https://core.trac.wordpress.org/log/trunk/src?action=stop_on_copy&amp;mode=stop_on_copy&amp;rev=39200&amp;stop_rev=39143&amp;limit=200&amp;verbose=on&amp;sfp_email=&amp;sfph_mail=\">over 50 changes</a> in the last week.</li>\n</ul>\n<p>Do you speak a language other than English? <a href=\"https://translate.wordpress.org/projects/wp/dev\">Help us translate WordPress into more than 100 languages!</a></p>\n<p><strong>If you think you’ve found a bug</strong>, you can post to the <a href=\"https://wordpress.org/support/forum/alphabeta\">Alpha/Beta area</a> in the support forums. We’d love to hear from you! If you’re comfortable writing a reproducible bug report, <a href=\"https://make.wordpress.org/core/reports/\">file one on WordPress Trac</a>, where you can also find <a href=\"https://core.trac.wordpress.org/tickets/major\">a list of known bugs</a>.</p>\n<p><em>Building the future</em><br />\n<em>A global community</em><br />\n<em>Stronger together</em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"4566\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:7;a:6:{s:4:\"data\";s:39:\"\n		\n		\n		\n		\n				\n		\n		\n\n		\n		\n				\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:20:\"WordPress 4.7 Beta 2\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://wordpress.org/news/2016/11/wordpress-4-7-beta-2/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 04 Nov 2016 17:39:07 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:3:{i:0;a:5:{s:4:\"data\";s:11:\"Development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:3:\"4.7\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=4552\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:329:\"WordPress 4.7 Beta 2 is now available! This software is still in development, so we don’t recommend you run it on a production site. Consider setting up a test site just to play with the new version. To test WordPress 4.7, try the WordPress Beta Tester plugin (you’ll want “bleeding edge nightlies”). Or you can [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Helen Hou-Sandi\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:4240:\"<p>WordPress 4.7 Beta 2 is now available!</p>\n<p><strong>This software is still in development,</strong> so we don’t recommend you run it on a production site. Consider setting up a test site just to play with the new version. To test WordPress 4.7, try the <a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\">WordPress Beta Tester</a> plugin (you’ll want “bleeding edge nightlies”). Or you can <a href=\"https://wordpress.org/wordpress-4.7-beta2.zip\">download the beta here</a> (zip).</p>\n<p>Notable changes since WordPress 4.7 Beta 1:</p>\n<ul>\n<li><strong>Twenty Seventeen:</strong> The theme wasn&#8217;t being installed on upgrades &#8211; sorry about that! Now you should see it if you&#8217;re upgrading an existing site. There are also plenty of fixes, especially for the header and small screen views.</li>\n<li><strong>Edit shortcuts:</strong> These are always visible while editing (hide them on bigger screens by collapsing the controls) and should now work properly in Firefox. (<a href=\"https://core.trac.wordpress.org/ticket/27403\">#27403</a> and <a href=\"https://core.trac.wordpress.org/ticket/38532\">#38532</a>)</li>\n<li><strong>REST API endpoints:</strong> There have been a number of changes over the past week; your attention is requested on the following:\n<ul>\n<li>The <code>DELETE</code> response format has changed and may need to be accounted for. (<a href=\"https://core.trac.wordpress.org/ticket/38494\">#38494</a>)</li>\n<li>Enabled querying by multiple post statuses. (<a href=\"https://core.trac.wordpress.org/ticket/38420\">#38420</a>)</li>\n<li>Return an error when JSON decoding fails. (<a href=\"https://core.trac.wordpress.org/ticket/38547\">#38547</a>)</li>\n</ul>\n</li>\n<li><strong>More developer notes</strong>\n<ul>\n<li><a href=\"https://make.wordpress.org/core/2016/10/28/fine-grained-capabilities-for-taxonomy-terms-in-4-7/\">Fine grained capabilities for taxonomy terms</a></li>\n<li><a href=\"https://make.wordpress.org/core/2016/10/29/wp_taxonomy-in-4-7/\"><code>WP_Taxonomy</code></a></li>\n<li><a href=\"https://make.wordpress.org/core/2016/11/02/wp_list_sort-and-wp_list_util-in-4-7/\"><code>wp_list_sort()</code> and <code>WP_List_Util</code></a></li>\n<li><a href=\"https://make.wordpress.org/core/2016/11/03/post-type-templates-in-4-7/\">Post type templates</a></li>\n<li><a href=\"https://make.wordpress.org/core/2016/11/03/new-post-type-labels-in-4-7/\">New post type labels</a></li>\n<li><a href=\"https://make.wordpress.org/core/2016/11/03/attributes-for-resource-hints-in-4-7/\">Attributes for resource hints</a></li>\n</ul>\n</li>\n<li><strong>Various bug fixes:</strong> We’ve made <a href=\"https://core.trac.wordpress.org/log/trunk/src?action=stop_on_copy&amp;mode=stop_on_copy&amp;rev=39142&amp;stop_rev=38995&amp;limit=200&amp;verbose=on&amp;sfp_email=&amp;sfph_mail=\">almost 150 changes</a> in the last week.</li>\n</ul>\n<p>For more of what’s new in version 4.7, <a href=\"https://wordpress.org/news/2016/10/wordpress-4-7-beta-1/\">check out the Beta 1 blog post</a>.</p>\n<p>If you want a more in-depth view of what major changes have made it into 4.7, <a href=\"https://make.wordpress.org/core/tag/4-7/\">check out posts tagged with 4.7 on the main development blog</a>, or look at a <a href=\"https://core.trac.wordpress.org/query?status=closed&amp;resolution=fixed&amp;milestone=4.7&amp;group=component&amp;order=priority\">list of everything</a> that’s changed. There will be more developer notes to come, so keep an eye out for those as well.</p>\n<p>Do you speak a language other than English? <a href=\"https://translate.wordpress.org/projects/wp/dev\">Help us translate WordPress into more than 100 languages!</a></p>\n<p><strong>If you think you’ve found a bug</strong>, you can post to the <a href=\"https://wordpress.org/support/forum/alphabeta\">Alpha/Beta area</a> in the support forums. We’d love to hear from you! If you’re comfortable writing a reproducible bug report, <a href=\"https://make.wordpress.org/core/reports/\">file one on WordPress Trac</a>, where you can also find <a href=\"https://core.trac.wordpress.org/tickets/major\">a list of known bugs</a>.</p>\n<p>Happy testing!</p>\n<p><em>Ya es la hora</em><br />\n<em> Time for another beta</em><br />\n请您帮下忙!</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"4552\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:8;a:6:{s:4:\"data\";s:39:\"\n		\n		\n		\n		\n				\n		\n		\n\n		\n		\n				\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:20:\"WordPress 4.7 Beta 1\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://wordpress.org/news/2016/10/wordpress-4-7-beta-1/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 28 Oct 2016 04:30:27 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:3:{i:0;a:5:{s:4:\"data\";s:11:\"Development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:3:\"4.7\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=4535\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:329:\"WordPress 4.7 Beta 1 is now available! This software is still in development, so we don’t recommend you run it on a production site. Consider setting up a test site just to play with the new version. To test WordPress 4.7, try the WordPress Beta Tester plugin (you’ll want “bleeding edge nightlies”). Or you can [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Helen Hou-Sandi\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:6895:\"<p>WordPress 4.7 Beta 1 is now available!</p>\n<p><strong>This software is still in development,</strong> so we don’t recommend you run it on a production site. Consider setting up a test site just to play with the new version. To test WordPress 4.7, try the <a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\">WordPress Beta Tester</a> plugin (you’ll want “bleeding edge nightlies”). Or you can <a href=\"https://wordpress.org/wordpress-4.7-beta1.zip\">download the beta here</a> (zip).</p>\n<p>WordPress 4.7 is slated for release on <a href=\"https://make.wordpress.org/core/4-7/\">December 6</a>, but we need your help to get there. We&#8217;ve been working on a lot of things, many of them to make getting your site set up the way you want it much easier. Here are some of the bigger items to test and help us find as many bugs as possible in the coming weeks:</p>\n<ul>\n<li><a href=\"http://2017.wordpress.net/\"><strong>Twenty Seventeen</strong></a> &#8211; A brand new default theme brings your site to life with immersive featured images, video headers, and subtle animations. With a focus on business sites, it features multiple sections on the front page as well as widgets, navigation and social menus, a logo, and more. Personalize its asymmetrical grid with a custom color scheme and showcase your multimedia content with post formats. Our default theme for 2017 works great in many languages, for any abilities, and on any device.</li>\n<li><strong>Video Headers</strong> &#8211; Sometimes a big atmospheric video as a moving header image is just what you need to showcase your wares; go ahead and try it out with Twenty Seventeen. Need some video inspiration? Try searching for sites with video headers available for download and use.</li>\n<li><strong>Set up your site in one flow</strong> &#8211; From finding and installing themes right inside the customizer, to automatically staged theme-specific starter content, to clickable shortcuts that jump directly to editing an item from the preview pane, to adding pages while you&#8217;re building a nav menu or setting a static front page: getting a new site spun up and ready to share with a friend or a coworker is faster and easier than it&#8217;s ever been. Note: starter content appears when live previewing brand new sites and is currently only available in Twenty Seventeen. We&#8217;ll be expanding this to other bundled themes very soon, and perhaps to sites with existing content in future releases of WordPress.</li>\n<li><strong>Custom CSS with live previews</strong> &#8211; Ever needed to hide or tweak the look of something in your theme or from a plugin? Now you can do it with CSS and live preview the results while customizing your site. CSS can be a powerful tool; you may find that you won&#8217;t need the theme editor or child themes anymore.</li>\n<li><strong>User admin languages</strong> &#8211; Just because your site is in one language doesn&#8217;t mean that everybody helping manage it prefers that language for their admin. To try this out, you&#8217;ll need to have more than one language installed, which will make a user language option available in your profile.</li>\n<li><strong>PDF thumbnail previews</strong> &#8211; Uploading PDFs will now generate thumbnail images so you can more easily distinguish between all your documents.</li>\n</ul>\n<p>As always, there have been exciting changes for developers to explore as well, such as:</p>\n<ul>\n<li><strong>REST API content endpoints</strong> &#8211; If you only test one thing as a developer, please test these. This phase is particularly helpful for people building plugins, themes, and in-admin interfaces. Can you build the things you need? Are these ready for release, and is the world ready for them? (<a href=\"https://core.trac.wordpress.org/ticket/38373\">#38373</a>)</li>\n<li><strong><code>WP_Hook</code></strong> &#8211; The code that lies beneath actions and filters has been overhauled. You likely aren&#8217;t affected, but if you&#8217;ve done things to the <code>$wp_filter</code> global or experienced funky recursion bugs in the past, <a href=\"https://make.wordpress.org/core/2016/09/08/wp_hook-next-generation-actions-and-filters/\">please take a moment to read the dev note</a> and test your code.</li>\n<li><a href=\"https://make.wordpress.org/core/2016/10/04/custom-bulk-actions/\"><strong>Custom bulk actions</strong></a> &#8211; List tables, now with more than bulk edit and delete.</li>\n<li>Expanded <a href=\"https://make.wordpress.org/core/2016/10/26/registering-your-settings-in-wordpress-4-7/\"><strong>Settings Registration API</strong></a> via <code>register_setting()</code>.</li>\n<li>For theme developers: <strong>Post type templates</strong> (<a href=\"https://core.trac.wordpress.org/ticket/18375\">#18375</a>)</li>\n<li><strong><a href=\"https://make.wordpress.org/core/2016/09/09/new-functions-hooks-and-behaviour-for-theme-developers-in-wordpress-4-7/\">More goodies for theme developers!</a></strong></li>\n<li><strong>Locale switching</strong> (<a href=\"https://core.trac.wordpress.org/ticket/26511\">#26511</a>)</li>\n<li><a href=\"https://make.wordpress.org/core/2016/10/11/comment-allowed-checks-in-wordpress-4-7/\"><strong>Comment allowed checks</strong></a> have the potential for a back-compat break.</li>\n</ul>\n<p>If you want a more in-depth view of what major changes have made it into 4.7, <a href=\"https://make.wordpress.org/core/tag/4-7/\">check out posts tagged with 4.7 on the main development blog</a>, or look at a <a href=\"https://core.trac.wordpress.org/query?status=closed&amp;resolution=fixed&amp;milestone=4.7&amp;group=component&amp;order=priority\">list of everything</a> that’s changed. There will be more developer notes to come, so keep an eye out for those as well.</p>\n<p><strong>If you think you’ve found a bug</strong>, you can post to the <a href=\"https://wordpress.org/support/forum/alphabeta\">Alpha/Beta area</a> in the support forums. We’d love to hear from you! If you’re comfortable writing a reproducible bug report, <a href=\"https://make.wordpress.org/core/reports/\">file one on WordPress Trac</a>, where you can also find <a href=\"https://core.trac.wordpress.org/tickets/major\">a list of known bugs</a>.</p>\n<p>Happy testing, and please enjoy this extended haiku break, courtesy of <a href=\"https://profiles.wordpress.org/ramiabraham\">Rami Abraham</a><em>.</em></p>\n<p><em>Exquisite endpoints</em><br />\n<em>Extol epic exabytes</em><br />\n<em>Enabling earthlings</em></p>\n<p><em>Careful interfaces</em><br />\n<em>Considerately conjured</em><br />\n<em>Customizer chic</em></p>\n<p><em>Ring in the new year</em><br />\n<em>With elegance and balance</em><br />\n<em>Twenty Seventeen</em></p>\n<p><em>Hooks hook healthily</em><br />\n<em>17817</em><br />\n<em>Sane iterations</em></p>\n<p><em>Admin in your tongue<br />\nOne site, many languages<br />\nWe all speak WordPress</em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"4535\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:9;a:6:{s:4:\"data\";s:45:\"\n		\n		\n		\n		\n				\n		\n		\n		\n		\n\n		\n		\n				\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:50:\"Join Us Again for Global WordPress Translation Day\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:86:\"https://wordpress.org/news/2016/10/join-us-again-for-global-wordpress-translation-day/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 14 Oct 2016 13:33:57 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:5:{i:0;a:5:{s:4:\"data\";s:9:\"Community\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:19:\"contributor weekend\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:32:\"global wordpress translation day\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:9:\"polyglots\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:4;a:5:{s:4:\"data\";s:12:\"translations\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=4516\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:373:\"The WordPress Polyglots team is organizing the second Global WordPress Translation Day on November 12th. Everyone is invited to join – from anywhere in the world! Translating is one of the easiest ways to get involved with WordPress and contribute to the project. Global WordPress Translation Day is your chance to learn more about translating WordPress, meet [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Petya Raykovska\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:4273:\"<p>The WordPress Polyglots team is organizing the second <a href=\"https://wptranslationday.org/\">Global WordPress Translation Day</a> on November 12th. Everyone is invited to join – from anywhere in the world!</p>\n<p>Translating is one of the easiest ways to get involved with WordPress and contribute to the project. Global WordPress Translation Day is your chance to learn more about translating WordPress, meet people from all over the world, and <a href=\"https://make.wordpress.org/polyglots/teams\">translate WordPress into one of more than 160 languages</a>.</p>\n<h3>Join us on November 12th from anywhere in the world</h3>\n<p>The translation day starts on Saturday, November 12th, 2016, at 0:00 UTC and ends 24 hours later. <a href=\"http://arewemeetingyet.com/UTC/2016-11-12/00:00/Global%20WordPress%20Translation%20Day%202\">See what time that is for you!</a> You can join right from the start, or any time it&#8217;s convenient for you throughout the day.</p>\n<h3>What are we doing?</h3>\n<p>Local contributor days are happening all over the world, and are a great way to get involved. <a href=\"https://www.google.com/maps/d/viewer?mid=12Gni4JMfShyWHPqGNwh5-PMneMM&amp;usp=sharing\">Check out this map</a> to see if there&#8217;s already a local event happening near you. Can&#8217;t find one? <a href=\"https://make.wordpress.org/polyglots/2016/09/22/global-wordpress-translation-day-2-on-november-12th-2016/\">Organize a local event!</a></p>\n<p>At the same time, <a href=\"https://www.crowdcast.io/e/gwtd2/register\">join the community for 24 hours of live-streamed, remote sessions</a> in numerous languages. Sessions will cover localization, internationalization, and contributing in your language.</p>\n<h3>Who&#8217;s it for?</h3>\n<p>Whether you&#8217;re new to translating and want to learn how to translate, or an experienced translation editor building a strong team, the translation day is for <i>you</i>. Developers will also enjoy topics from experienced contributors, whether you&#8217;re learning about internationalization and or want to find more translators for your themes and plugins. There&#8217;s a session for everyone!</p>\n<h3>Get Involved</h3>\n<p>Joining is easy! On November 12th, in your own timezone, <a href=\"https://translate.wordpress.org\">translate WordPress</a> or your favorite plugins and themes into your language, while watching live sessions over the course of the day.</p>\n<p>Want to get more involved? <a href=\"https://make.wordpress.org/polyglots/2016/09/22/global-wordpress-translation-day-2-on-november-12th-2016/\">Sign up to organize a local event</a> and invite your local community to translate together on November 12th. Events can be formal or completely informal – grab your laptop and a couple of friends, and head to a local coffee shop to translate for an hour or two.</p>\n<h3>Can you get involved if you only speak English?</h3>\n<p>Absolutely! Even if you only speak English, there are great sessions about internationalization that can benefit every developer. There&#8217;s also lots of English variants that need your help! For example, English is spoken and written differently in Australia, Canada, New Zealand, South Africa, and the United Kingdom. You can learn about these differences and why these variants are important during the sessions.</p>\n<p>And if you’re feeling fun, try translating WordPress into emoji! Yep, we have a translation of WordPress in emoji! <img src=\"https://s.w.org/images/core/emoji/2.2.1/72x72/1f30e.png\" alt=\"🌎\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /><img src=\"https://s.w.org/images/core/emoji/2.2.1/72x72/1f30d.png\" alt=\"🌍\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /><img src=\"https://s.w.org/images/core/emoji/2.2.1/72x72/1f30f.png\" alt=\"🌏\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /></p>\n<h3>Questions?</h3>\n<p>If you have any questions, the polyglots team and the event organizers hang out in <a href=\"http://wordpress.slack.com/messages/polyglots/\">#polyglots in Slack</a> and are happy to help! (Get an invite to Slack at <a href=\"https://chat.wordpress.org\">chat.wordpress.org</a>.)</p>\n<p>Sign up to take part in the event on the <a href=\"https://wptranslationday.org/\">official website</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"4516\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:4:\"href\";s:32:\"https://wordpress.org/news/feed/\";s:3:\"rel\";s:4:\"self\";s:4:\"type\";s:19:\"application/rss+xml\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:44:\"http://purl.org/rss/1.0/modules/syndication/\";a:2:{s:12:\"updatePeriod\";a:1:{i:0;a:5:{s:4:\"data\";s:6:\"hourly\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:15:\"updateFrequency\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"1\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:4:\"site\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"14607090\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}}}}s:4:\"type\";i:128;s:7:\"headers\";O:42:\"Requests_Utility_CaseInsensitiveDictionary\":1:{s:7:\"\0*\0data\";a:9:{s:6:\"server\";s:5:\"nginx\";s:4:\"date\";s:29:\"Tue, 17 Jan 2017 20:37:18 GMT\";s:12:\"content-type\";s:34:\"application/rss+xml; charset=UTF-8\";s:25:\"strict-transport-security\";s:11:\"max-age=360\";s:6:\"x-olaf\";s:3:\"⛄\";s:13:\"last-modified\";s:29:\"Sat, 14 Jan 2017 00:21:27 GMT\";s:4:\"link\";s:63:\"<https://wordpress.org/news/wp-json/>; rel=\"https://api.w.org/\"\";s:15:\"x-frame-options\";s:10:\"SAMEORIGIN\";s:4:\"x-nc\";s:11:\"HIT lax 249\";}}s:5:\"build\";s:14:\"20130911090210\";}", "no");
INSERT INTO wpax_options VALUES("46104", "_transient_timeout_feed_mod_ac0b00fe65abe10e0c5b588f3ed8c7ca", "1484728638", "no");
INSERT INTO wpax_options VALUES("46105", "_transient_feed_mod_ac0b00fe65abe10e0c5b588f3ed8c7ca", "1484685438", "no");
INSERT INTO wpax_options VALUES("46106", "_transient_timeout_feed_d117b5738fbd35bd8c0391cda1f2b5d9", "1484728638", "no");
INSERT INTO wpax_options VALUES("46107", "_transient_feed_d117b5738fbd35bd8c0391cda1f2b5d9", "a:4:{s:5:\"child\";a:1:{s:0:\"\";a:1:{s:3:\"rss\";a:1:{i:0;a:6:{s:4:\"data\";s:3:\"\n\n\n\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:7:\"version\";s:3:\"2.0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:1:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:61:\"\n	\n	\n	\n	\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"WordPress Planet\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://planet.wordpress.org/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"language\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"en\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:47:\"WordPress Planet - http://planet.wordpress.org/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"item\";a:50:{i:0;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:95:\"WPTavern: Postmatic Basic Rebrands as Replyable, Moves Two-Way Email Commenting to SaaS Product\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=65245\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:105:\"https://wptavern.com/postmatic-basic-rebrands-as-replyable-moves-two-way-email-commenting-to-saas-product\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:6089:\"<p><a href=\"https://i0.wp.com/wptavern.com/wp-content/uploads/2017/01/replyable.png?ssl=1\"><img src=\"https://i0.wp.com/wptavern.com/wp-content/uploads/2017/01/replyable.png?resize=1025%2C346&ssl=1\" alt=\"\" class=\"aligncenter size-full wp-image-65250\" /></a></p>\n<p>Postmatic is rebranding its WordPress.org <a href=\"https://wordpress.org/plugins/postmatic/\" target=\"_blank\">Postmatic Basic</a> plugin as Replyable and pushing the two-way email commenting feature into <a href=\"https://replyable.com/\" target=\"_blank\">a new SaaS product</a>. After discovering that many users simply want email commenting, without additional post delivery and newsletter features, Postmatic launched <a href=\"https://replyable.com/\" target=\"_blank\">Replyable</a> to offer this starting at $3/month.</p>\n<p>&#8220;Replyable was born out of user feedback,&#8221; founder Jason Lemieux said. &#8220;Postmatic does more than most sites need and the price is squarely mid-market. From the beginning we’ve heard from users that they already use another newsletter service and just want Postmatic to handle comment subscriptions &#8211; but that alone isn’t worth $20 to too many people. With Replyable we can offer it for $3.&#8221;</p>\n<p>Lemieux and his team have now transitioned Postmatic to be purely a Saas product without a presence in the WordPress.org directory.</p>\n<p>&#8220;Postmatic will continue to grow as a complete engagement system and, if anything, become even more complex and go further up market,&#8221; Lemieux said. &#8220;Sites which use Postmatic tend to dive in deeply. It is meant to function as a package. Grow a list, deliver to it, get them talking about your ideas, monetize the results.&#8221;</p>\n<p>The <a href=\"https://wordpress.org/plugins/postmatic/\" target=\"_blank\">Replyable plugin on WordPress.org</a> now simply covers comment subscriptions with all other features available in the commercial products.</p>\n<p>Ripping an existing feature out of a free plugin and making it paid is fairly unusual and can have a negative impact on how users perceive the plugin. However, Postmatic has a plan to allow legacy users to continue using the features they had before by switching to <a href=\"http://docs.replyable.com/article/284-switching-from-postmatic-basic-to-replyable\" target=\"_blank\">Postmatic Labs</a>. It&#8217;s an inconvenient change but is required for those who don&#8217;t want to upgrade to a commercial plan.</p>\n<p>Although WordPress.org says Postmatic has approximately 1,000 active installs, Lemieux estimates there are 8,000 users including those using the commercial plugin or the Labs plugin. He would not share any specific revenue figures but said he learned some important pricing lessons in leading the bootstrapped startup for the past two years.</p>\n<p>&#8220;We aren’t a runaway WordPress success story but we’re alive and loving our jobs,&#8221; Lemieux said. &#8220;About six months ago it became apparent that we needed to get out of the mid market. We had a huge group of people saying, &#8216;I just want email commenting and will totally pay you 5 bucks a month for it,&#8217; and another group saying, &#8216;We pay $6,000 a month sending Mailchimp RSS campaigns but yours are better for only $1500. Why so cheap?&#8217; That’s been a frustrating reality and a big lesson in knowing your audience and pricing appropriately.&#8221;</p>\n<h3>Next on Postmatic&#8217;s Roadmap: Epoch 2</h3>\n<p>In July 2015, <a href=\"https://wptavern.com/postmatic-brings-100-realtime-commenting-to-wordpress-with-epoch-plugin\" target=\"_blank\">Postmatic introduced Epoch</a> as a Disqus alternative, offering 100% realtime commenting for WordPress. The plugin submits comments via AJAX so that they appear instantly without refreshing the page. Lemieux and the team have been working on the second version for nearly a year.</p>\n<p>&#8220;Epoch 2 is a huge step forward,&#8221; Lemieux said. &#8220;We built it on top of the REST API and Angular. It’s fast and incredibly light. Commenting isn’t sexy &#8211; I don’t think it will ever be, but comments are great for SEO, community, and for building brands and authority. Comments aren’t going away. In fact, they are vitally important to keeping the web as a place for discourse, conversation, and the sharing of ideas. We need to continue to make them a better experience. Epoch isn’t groundbreaking in its functionality but it does the job of making sure sites of any size can still run native WordPress comments.&#8221;</p>\n<p>Postmatic continues to innovate with native comments, an aspect of WordPress that doesn&#8217;t have as many commercial players as something like forms or e-commerce. Lemieux attributes this underserved area to the poor reputation of previous non-native solutions.</p>\n<p>&#8220;I think it is because of the rise and fall of third party commenting system,&#8221; Lemieux said. &#8220;Early in WordPress history services like Disqus and Livefyre grabbed huge parts of the comment traffic on WordPress sites by offering more features, better speed, and improved moderation tools (with the hidden cost of selling your users down the river). It was certainly a siren song. But most all of them stagnated, violated user trust, or just plain didn’t work well. And commenting got a bad name. Naturally came the trend in disabling comments and, well, now here we are and people are trying to have conversations 140 characters at a time.&#8221;</p>\n<p>Lemieux said the innovation he sees happening outside WordPress makes him believe that comments can overcome their past reputation.</p>\n<p>&#8220;Things are getting better &#8211; and hopefully more folks will begin to innovate,&#8221; Lemieux said. &#8220;Lucky for us other blogging and publishing platforms are innovating and coming up with interesting ideas all the time. Some of them, like <a href=\"https://wordpress.org/plugins/inline-comments/\" target=\"_blank\">inline commenting</a> from Medium, do make their way back over to WordPress. That makes me optimistic.&#8221;</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 16 Jan 2017 15:49:25 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:1;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:84:\"WPTavern: Aaron D. Campbell Replaces Nikolay Bachiyski as WordPress’ Security Czar\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=65102\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:91:\"https://wptavern.com/aaron-d-campbell-replaces-nikolay-bachiyski-as-wordpress-security-czar\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2541:\"<p><a href=\"https://aarondcampbell.com/\">Aaron D. Campbell</a>, WordPress Core Contributor at GoDaddy, is replacing <a href=\"https://profiles.wordpress.org/nbachiyski\">Nikolay Bachiyski</a> as WordPress&#8217; Security Czar or WordPress Core Security Team Lead. The role was <a href=\"https://wptavern.com/short-interview-with-nikolay-bachiyski-wordpress-security-czar\">created in 2015</a> to provide more structure and focus around incident responses.</p>\n<p>According to Campbell, &#8220;The responsibilities of the position include, organizing the security team and making sure all security concerns and reports get triaged and ultimately fixed, coordinating the security side of releases, and being a point of contact for any security related things that need one.&#8221;</p>\n<p>Matt Mullenweg, co-creator of the WordPress project, <a href=\"https://make.wordpress.org/core/2017/01/09/aaron-campbell-leading-security/\">thanked Bachiyski</a> for being the first to accept the role and putting the foundation in place for future team leads, &#8220;This is also a good time to thank the dozens of volunteers who participate in the security group, and the researchers and reporters who bring issues to our attention,&#8221; he said.</p>\n<p>Campbell says he plans to finish what Nikolay started by getting WordPress.org onto HackerOne, &#8220;Nikolay did a lot of work around expanding our team as well as getting the foundation laid for moving over to <a href=\"https://hackerone.com/\">HackerOne</a>,&#8221; he said.</p>\n<p>&#8220;We aren&#8217;t quite ready to make the move completely, but I hope to phase out the security@ E-Mail address in favor of HackerOne in the near future.&#8221;</p>\n<p>In late 2016, GoDaddy <a href=\"https://aarondcampbell.com/2016/09/joining-godaddy-as-a-full-time-wordpress-core-contributor/\">hired Campbell</a> to contribute to WordPress core full-time. The company continues to back his involvement in WordPress, &#8220;The role is completely voluntary,&#8221; Campbell said. &#8220;GoDaddy has truly been extremely hands off while funding me to do all this, and I&#8217;m grateful to have that continue.&#8221;</p>\n<p>If you think you&#8217;ve discovered a security vulnerability with the self-hosted version of WordPress, you&#8217;re encouraged to <a href=\"https://make.wordpress.org/core/handbook/testing/reporting-security-vulnerabilities/\">responsibly disclose</a> it to the security team by emailing security @ wordpress.org and include as much detail as possible.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 14 Jan 2017 23:53:31 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:2;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:90:\"WPTavern: Automattic Releases Free Plugin for Exporting Photos from Lightroom to WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=65177\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:101:\"https://wptavern.com/automattic-releases-free-plugin-for-exporting-photos-from-lightroom-to-wordpress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2650:\"<p>Yesterday Automattic <a href=\"https://en.blog.wordpress.com/2017/01/12/wordpress-com-lightroom/\" target=\"_blank\">released</a> a new free plugin the makes it easy for Lightroom users to export their photos to WordPress. <a href=\"http://www.adobe.com/products/photoshop-lightroom.html\" target=\"_blank\">Lightroom</a> is an Adobe product for managing and editing photos, and the plugin works with the software on MacOS and Windows. It is compatible with both WordPress.com and Jetpack-powered sites.</p>\n<p>The <a href=\"https://apps.wordpress.com/lightroom/\" target=\"_blank\">Lightroom plugin</a> requires a WordPress.com account to install. Users can then select photos in Lightroom and export them to a WordPress site with all the standard settings available, such as image resizing, watermarking, output sharpening, and more. The plugin automatically exports titles and captions. A large number of photos can take awhile to export, but once the upload is finished users can find their images in the WordPress media library.</p>\n<p><a href=\"https://i2.wp.com/wptavern.com/wp-content/uploads/2017/01/wp-lightroom.png?ssl=1\"><img src=\"https://i2.wp.com/wptavern.com/wp-content/uploads/2017/01/wp-lightroom.png?resize=1025%2C573&ssl=1\" alt=\"\" class=\"aligncenter size-full wp-image-65227\" /></a></p>\n<p>When asked for tips on suggested upload size and compression, Automattic representative John Godley said, &#8220;WordPress.com can handle pretty much anything you throw at it! I personally go for a high quality and large size so it looks good on a HiDPI screen, and then let WordPress resize as necessary to fit the viewers device.&#8221;</p>\n<p>It&#8217;s not yet clear how the release of Automattic&#8217;s free plugin will affect the commercial products that exist for a similar purpose. <a href=\"https://flothemes.com/flo-plugins/\" target=\"_blank\">FloLight</a>, <a href=\"https://meowapps.com/wplr-sync/buy/\" target=\"_blank\">WPLR Sync</a>, and other solutions will need to offer more features with a quicker setup if they want to compete with the new free Lightroom plugin.</p>\n<p>Those who want to use the plugin must already have a Lightroom license (standalone or subscription). Although this is a relatively small subset of overall WordPress users, it saves a great deal of time for photobloggers and those who process a large number of photos with Lightroom before posting online. For most, this <a href=\"https://apps.wordpress.com/lightroom/\" target=\"_blank\">plugin</a> simplifies what was previously a tedious, multi-step process of manually uploading the photos after working with them in Lightroom.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 14 Jan 2017 00:13:42 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:3;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:79:\"WPTavern: Wes Bos Launches JavaScript30, a Free 30-Day Vanilla JS Coding Course\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=65209\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:89:\"https://wptavern.com/wes-bos-launches-javascript30-a-free-30-day-vanilla-js-coding-course\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2923:\"<p><a href=\"https://i1.wp.com/wptavern.com/wp-content/uploads/2017/01/javascript30.png?ssl=1\"><img src=\"https://i1.wp.com/wptavern.com/wp-content/uploads/2017/01/javascript30.png?resize=1025%2C429&ssl=1\" alt=\"\" class=\"aligncenter size-full wp-image-65211\" /></a></p>\n<p>For those who failed to &#8220;learn JavaScript deeply&#8221; last year, 2017 offers a clean slate for restarting your JavaScript learning goals. <a href=\"http://wesbos.com/\" target=\"_blank\">Wes Bos</a>, a developer and educator known for his high quality video tutorials, recently launched a free 30-day vanilla JS coding challenge course that provides structure for developing a new habit of daily learning.</p>\n<p><a href=\"https://javascript30.com/\" target=\"_blank\">JavaScript30</a> walks users through building 30 things in 30 days with no frameworks, no compilers, no libraries, and no boilerplate. The course is suitable for beginner to intermediate developers and designers who want to get a solid grasp of JavaScript fundamentals. It purposely steers clear of abstractions like frameworks to help students gain a better understanding of browser APIs while working in the DOM without a library.</p>\n<p>Bos designed the course to help students gain competence through building things, the advice he gives to anyone wanting to improve their JavaScript skills.</p>\n<p>&#8220;So, you&#8217;ve done a few courses and read a few books but still don&#8217;t feel great about your relationship with JavaScript,&#8221; Bos said. &#8220;How do you get better? Build things. Lots of things. Build 1,000 things. Keep it up and don&#8217;t stop.&#8221; The course is packed full of quick, interesting, and practical projects.</p>\n<p><a href=\"https://i0.wp.com/wptavern.com/wp-content/uploads/2017/01/javascript30-lessons.png?ssl=1\"><img src=\"https://i0.wp.com/wptavern.com/wp-content/uploads/2017/01/javascript30-lessons.png?resize=1025%2C507&ssl=1\" alt=\"\" class=\"aligncenter size-full wp-image-65215\" /></a></p>\n<p>JavaScript30 includes access to 30 videos, 30 days of starter files, and completed HTML, CSS, and JS Solutions for each day. The videos are accessible and ESL-friendly with closed captions provided.</p>\n<p>Bos said he spent more than 300 hours creating the videos as a thank-you to those who have supported his paid courses.</p>\n<p>&#8220;I see a huge need for these videos and I really think it will help many&#8230;become comfortable creating with JavaScript,&#8221; he said.</p>\n<p>Bos is also the author of the free <a href=\"https://wptavern.com/wes-bos-launches-free-react-js-redux-online-course\" target=\"_blank\">Learn Redux</a> course, which includes 2.5 hours of videos that help students get started with React.js, Redux, and React Router. Some of his other popular <a href=\"http://wesbos.com/courses/\" target=\"_blank\">courses</a> include React for Beginners, Learn Redux, and ES6 for Everyone.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 13 Jan 2017 22:05:07 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:4;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:61:\"WPTavern: WPWeekly Episode 259 – 2016 Year in Review Part 2\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:58:\"https://wptavern.com?p=65198&preview=true&preview_id=65198\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:68:\"https://wptavern.com/wpweekly-episode-259-2016-year-in-review-part-2\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1040:\"<p>In this episode, <a href=\"http://www.marcuscouch.com/\">Marcus Couch</a> and I recap the news that made headlines during the second half of 2016. I explain why there wasn&#8217;t a show last week and we close out the episode with our predictions for 2017. We&#8217;ll be back to our regular show format on Wednesday, January 18th.</p>\n<h2>WPWeekly Meta:</h2>\n<p><strong>Next Episode:</strong> Wednesday, January 18th 3:00 P.M. Eastern</p>\n<p><strong>Subscribe To WPWeekly Via Itunes: </strong><a href=\"https://itunes.apple.com/us/podcast/wordpress-weekly/id694849738\" target=\"_blank\">Click here to subscribe</a></p>\n<p><strong>Subscribe To WPWeekly Via RSS: </strong><a href=\"https://wptavern.com/feed/podcast\" target=\"_blank\">Click here to subscribe</a></p>\n<p><strong>Subscribe To WPWeekly Via Stitcher Radio: </strong><a href=\"http://www.stitcher.com/podcast/wordpress-weekly-podcast?refid=stpr\" target=\"_blank\">Click here to subscribe</a></p>\n<p><strong>Listen To Episode #259:</strong><br />\n</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 13 Jan 2017 09:37:42 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:5;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:78:\"WPTavern: 2nd Edition of Producing Open Source Software Now Available for Free\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=65181\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:89:\"https://wptavern.com/2nd-edition-of-producing-open-source-software-now-available-for-free\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3737:\"<p><a href=\"https://i0.wp.com/wptavern.com/wp-content/uploads/2017/01/producing-oss.png?ssl=1\"><img src=\"https://i0.wp.com/wptavern.com/wp-content/uploads/2017/01/producing-oss.png?resize=1025%2C550&ssl=1\" alt=\"\" class=\"aligncenter size-full wp-image-65184\" /></a></p>\n<p>The second edition of <a href=\"http://www.red-bean.com/kfogel/\" target=\"_blank\">Karl Fogel</a>&#8216;s &#8220;Producing Open Source Software: How to Run a Successful Free Software Project&#8221; is now available for download. Fogel, a partner at <a href=\"https://opentechstrategies.com/\" target=\"_blank\">Open Tech Strategies</a> and OSS contributor since 1997, was a founding developer in the Subversion project. He has worked for more than a decade as an open source specialist, helping businesses and organizations evaluate, launch, and manage open source projects.</p>\n<p><a href=\"http://producingoss.com/\" target=\"_blank\">Producing Open Source Software</a> version 2 was released for free this week under the Attribution-ShareAlike 4.0 International license. The first edition was published in 2005 but the landscape of OSS has changed drastically over the past 12 years. In 2013, Fogel <a href=\"https://www.kickstarter.com/projects/kfogel/updating-producing-open-source-software-for-2nd-ed/description\" target=\"_blank\">successfully raised $15,376</a> towards his $10,000 Kickstarter goal to fund the revision.</p>\n<p>The book includes topics like &#8216;Free&#8217; Versus &#8216;Open Source,&#8217; choosing a license, version control, social and political infrastructure, the economics of open source, culture, and communication. It was written for managers and software developers but can also be informative for newcomers to open source projects.</p>\n<p>Fogel originally planned on finishing the second edition by the end of 2013 but experienced delays due to starting his company. Some chapters also took longer to revise than he anticipated.</p>\n<p>&#8220;In retrospect, if I had understood what the pressures of a young and growing company would be, I would not have started the 2nd edition when I did,&#8221; Fogel said. &#8220;It has been a lesson.&#8221; Fortunately, for the 314 Kickstarter backers  who might have been waiting on his work for four years, progress was immediately available in the public repository for the book. Fogel didn&#8217;t keep any private version of the book elsewhere.</p>\n<p>&#8220;While there are substantial changes throughout the book, the most expanded chapter is probably Chapter 5, &#8216;Participating as a Business, Non-Profit, or Government Agency,\'&#8221; Fogel said. &#8220;That chapter&#8217;s title used to be just &#8216;Money,&#8217; so that gives you some idea of what the new material is.&#8221;</p>\n<p>He also found the third chapter on technical infrastructure to be more time consuming than the others due to all of the changes in the past decade. It took roughly four and a half months to revise it to include modern development tools.</p>\n<p>One of the central focuses of the book is the value of collaboration and the direct benefits it provides to an open source software project.</p>\n<p>&#8220;Competence at cooperation itself is one of the most highly valued skills in free software,&#8221; Fogel wrote in the preface. &#8220;Good free software is a worthy goal in itself&#8230; But beyond that I also hope to convey something of the sheer pleasure to be had from working with a motivated team of open source developers, and from interacting with users in the wonderfully direct way that open source encourages. Participating in a successful free software project is a deep pleasure, and ultimately that&#8217;s what keeps the whole system going.&#8221;</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 12 Jan 2017 23:13:23 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:6;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:62:\"Post Status: New Year’s resolutions for WordPress developers\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"https://poststatus.com/?p=32188\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:66:\"https://poststatus.com/new-years-resolutions-wordpress-developers/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:15739:\"<p><em><strong>Editor&#8217;s Note:</strong></em> This is a guest post by <a href=\"https://poststatus.com/profiles/jack-lenox/\">Jack Lenox</a>. Jack is a developer at Automattic and hails from the United Kingdom.</p>\n<p>For just over a year now, I have been working on the <a href=\"https://vip.wordpress.com/\">WordPress.com VIP</a> team at Automattic. I had been working at Automattic for the two years prior to this – and had been developing sites with PHP and WordPress for almost ten years prior to that. So you might imagine that I had a pretty good handle on developing stuff with WordPress.</p>\n<p>And you would be wrong. Getting started with the VIP team was an eye-opening and occasionally terrifying learning experience, occasionally resulting in me thinking: &#8220;please excuse me for a moment while I go and fix some horrible vulnerability in all of my WordPress sites.&#8221;</p>\n<p>Recently, I have cautiously found myself feeling slightly more comfortable with my position on the team. For some time, I have been wanting to document the most interesting and impactful things that I have learned in the past year.</p>\n<p>As some readers may know, a significant part of a developer&#8217;s job on the VIP team is reviewing code. Thus, with us being at the start a new year, I have hereby compiled some of the most interesting best practices I have discovered as a list of New Year&#8217;s Resolutions:</p>\n<h3>1. Use strict comparison operators</h3>\n<p>One of the many quirks of PHP is that it enjoys juggling. In particular, it enjoys <a href=\"http://php.net/manual/en/language.types.type-juggling.php\">juggling types</a>. This means that without explicit instruction, PHP doesn&#8217;t see a difference between a string of &#8220;string&#8221;, an integer of 0, and a boolean value of <code>true</code>.</p>\n<p>So for example this:</p>\n<pre><code>$var = 0;\nif ( $var == \'safe_string\' ) {\n    return true;\n}\n</code></pre>\n<p>Will return true. I know, what?! The easy solution here is to simply use strict comparison operators.</p>\n<p>So that&#8217;s <code>===</code> instead of <code>==</code>, and <code>!==</code> instead of <code>!=</code>. This pops up in a few other places too. By default the <a href=\"http://php.net/manual/en/function.in-array.php\"><code>in_array()</code></a> function has its strict parameter set to false.</p>\n<p>So:</p>\n<pre><code>in_array( 0, [\'safe_value\', \'another string\'] );\n</code></pre>\n<p>Will return true. To fix this, simply pass a third parameter of <code>true</code>.</p>\n<p>While we&#8217;re here, there&#8217;s one other form of comparison we should be aware of, and that&#8217;s <a href=\"http://php.net/manual/en/function.hash-equals.php\"><code>hash_equals()</code></a>. This provides a string comparison that prevents timing attacks.</p>\n<p>While a relatively uncommon form of attack on the web, it&#8217;s worth being aware of a timing attack. What is it? Well, when PHP compares two strings, it compares them one character at a time.</p>\n<p>So in the case of something like this:</p>\n<pre><code>$submitted_password = $_POST[\'password\']; // For argument\'s sake, let\'s say it\'s \"pa45word\"\n$password = \"pa55word\";\n\nif ( $submitted password === $password ) {\n    go_forth();\n}\n</code></pre>\n<p>PHP&#8217;s thought process in human terms is: Is the first character of each string p? Yes it is. Is the second character of each string a? Yes it is. And so on.</p>\n<p>It will do this until it realizes that the third characters differ and at that point it will bail. Thus, with sophisticated timing software, a password can gradually be worked out by calculating how long the process is taking. If the process takes slightly longer with one character than it does with every other character, an attacker will know that they have worked out the first character.</p>\n<p>Automated processes can keep doing this until the entire password is worked out. <code>hash_equals()</code> will compare two values, but will not bail early if it detects a difference.</p>\n<p>In conclusion, if you&#8217;re comparing sensitive values, use <code>hash_equals()</code>!</p>\n<h3>2. Use Yoda condition checks, you must</h3>\n<p>The <a href=\"https://make.wordpress.org/core/handbook/best-practices/coding-standards/php/#yoda-conditions\">WordPress PHP Coding Standards</a> suggest that you should: &#8220;always put the variable on the right side and put constants, literals or function calls on the left side.&#8221; Initially, this might just sound like a bit of pedantry, but it actually has a very practical application.</p>\n<p>Consider how catastrophic the following typo could be:</p>\n<pre><code>if ( $session_authorized = true ) {\n    unleash_the_secrets();\n}\n</code></pre>\n<p>Oh dear, instead of checking that <code>$session_authorized</code> is true, I am instead assigning the value of true to that variable.</p>\n<p>Now the secrets are being unleashed to whoever wants them. This could easily be missed when checking the code for bugs, even by a reviewer.</p>\n<p>Now imagine if the first line was expressed as:</p>\n<pre><code>if ( true = $session_authorized ) {\n</code></pre>\n<p>Well, it doesn&#8217;t. We can&#8217;t assign a variable to the static boolean value of <code>true</code>.</p>\n<p>Hopefully it won&#8217;t take us too long to work out why our code is still broken, but the secrets remain safe. So we&#8217;re good! <img src=\"https://s.w.org/images/core/emoji/2.2.1/72x72/1f600.png\" alt=\"😀\" class=\"wp-smiley\" /></p>\n<h3>3. ABE. A Always, B Be, E Escaping. Always Be Escaping. ALWAYS Be Escaping.</h3>\n<p>Not having a firm grasp of the concepts of validation, sanitization and escaping can make you a very dangerous developer indeed.</p>\n<p>To the extent that libraries like React escape all output by default and to bypass this functionality, you have to use the attribute: <code>dangerouslySetInnerHTML</code></p>\n<p>Validation is checking that what your code is being passed is even vaguely what it&#8217;s expecting. So for instance, if we&#8217;re expecting an integer, we can use something like: <code>$zipcode = intval( $_POST[\'my-zipcode\'] )</code></p>\n<p>The <code>intval()</code> function returns its input as an integer and defaults to zero if the input was a non-numeric value. So while this won&#8217;t prevent our code from being passed zipcodes that aren&#8217;t valid, it does protect our code from being passed anything that isn&#8217;t a number.</p>\n<p>Naturally, we could go a step further to see if the zipcode actually appears to be valid. For example, 1111111111111 is not a valid zip code, but <code>intval()</code> doesn&#8217;t know that.</p>\n<p>Fortunately, beyond integers, WordPress has <a href=\"https://codex.wordpress.org/Data_Validation#Input_Validation\">a bunch of handy helper functions for almost every data type</a> including my favourite: <code>is_email().</code></p>\n<p>Sanitization is cleaning input to make sure that it&#8217;s safe in the context where we want to use it. This prevents one of the most common forms of security vulnerability, an <a href=\"https://www.owasp.org/index.php/SQL_injection\">SQL injection attack</a>.</p>\n<p>We also sanitize to fix practical things, like checking for invalid UTF-8 characters. WordPress has a class of <a href=\"https://codex.wordpress.org/Data_Validation#Input_Validation\"><code>sanitize_*()</code> helper functions</a>; here&#8217;s an example of how one looks in the wild:</p>\n<pre><code>$title = sanitize_text_field( $_POST[\'title\'] );\nupdate_post_meta( $post-&gt;ID, \'title\', $title );\n</code></pre>\n<p>Therefore no matter what garbage we might have been passed in <code>$_POST[\'title\']</code>, it won&#8217;t cause any real problems.</p>\n<p>Escaping is similar to sanitization, but instead it is cleaning what we&#8217;re sending out, rather than what we&#8217;re taking in. A major reason for doing this is to prevent another of the most common forms of security vulnerability, a <a href=\"https://www.owasp.org/index.php/XSS\">Cross-site Scripting (or XSS) attack</a>.</p>\n<p>We want to clean our output to ensure we aren&#8217;t accidentally echoing out something very dangerous that we didn&#8217;t realize we were inadvertently storing in our database (or perhaps fetched from an API).</p>\n<p>WordPress has <a href=\"https://codex.wordpress.org/Data_Validation#Output_Sanitization\">a bunch of very useful helper functions here</a>. Some common examples of these in the wild are:</p>\n<pre><code>&lt;h4&gt;&lt;?php echo esc_html( $title ); ?&gt;&lt;/h4&gt;\n</code></pre>\n<pre><code>&lt;img alt=\"\" src=\"&lt;?php echo esc_url( $great_user_picture_url ); ?&gt;\" /&gt;\n</code></pre>\n<pre><code>&lt;ul class=\"&lt;?php echo esc_attr( $stored_class ); ?&gt;\"&gt;\n</code></pre>\n<p>There is also <a href=\"https://developer.wordpress.org/reference/functions/wp_kses/\"><code>wp_kses()</code></a> which can be used on everything that is expected to contain HTML, and will filter out elements that are not explicitly allowed.</p>\n<p>As a general rule, the <code>the_*()</code> and <code>get_the_*()</code> theme functions are already escaped. However, the <code>get_bloginfo()</code> function, for example, is not escaped.</p>\n<p>For further information here, I highly recommend checking out the VIP team&#8217;s documentation on <a href=\"https://vip.wordpress.com/documentation/vip/best-practices/security/validating-sanitizing-escaping/\">Validating, Sanitizing, and Escaping</a>.</p>\n<h3>4. Stop trusting everything</h3>\n<p>Don&#8217;t trust user input. Don&#8217;t trust what&#8217;s in your database. Don&#8217;t trust any variables.</p>\n<p>Treat every variable with contempt.</p>\n<p>This way, even if, for example, someone sneaks some dodgy XSS code into your database, it&#8217;ll still get escaped on output and your site will be better protected.</p>\n<h3>5. Avoid inserting HTML directly into the document (when using JavaScript)</h3>\n<p>Doing something like this is dangerous because the data that we&#8217;re using could include many more DOM elements that dramatically alter the anticipated behavior of this code, and make it vulnerable to XSS attacks:</p>\n<pre><code>jQuery.ajax({\n    url: \'http://any-site.com/endpoint.json\'\n}).done( function( data ) {\n    var link = \'&lt;a href=\"\' + data.url + \'\"&gt;\' + data.title + \'&lt;/a&gt;\';\n\njQuery( \'#my-div\' ).html( link );\n});\n</code></pre>\n<p>Instead, we should programmatically create DOM nodes and append them to the DOM. So the above instead becomes this:</p>\n<pre><code>jQuery.ajax({\n    url: \'http://any-site.com/endpoint.json\'\n}).done( function( data ) {\n    var a = jQuery( \'&lt;a /&gt;\' );\n    a.attr( \'href\', data.url );\n    a.text( data.title );\n\njQuery( \'#my-div\' ).append( a );\n});\n</code></pre>\n<p>This is how a library like React does things behind the scenes. You can read more about this in <a href=\"https://vip.wordpress.com/2015/03/25/preventing-xss-in-javascript/\">a wonderful post about preventing XSS attacks in JavaScript</a> by my colleague, Nick Daugherty.</p>\n<h3>6. Review code</h3>\n<p>Have you ever reviewed a plugin before using it? I know, who&#8217;s got time for that right? I&#8217;ll tell you who: you.</p>\n<p>I have come to realize that reviewing code is possibly one of the best exercises for improving as a developer. Even if you&#8217;re quite new to programming or development, and you still feel pretty green, you really should give it a go.</p>\n<p>A great way to start is to review the next plugin you decide to use on your website. Before activating it, pop it open in your text editor of choice, and just spend some time scanning through it to understand what it does.</p>\n<p>A method I like to use here is to interpret each line of the code in simple English. You can even say it loud if you like – assuming you&#8217;re not sitting in a café or co-working space where people might become worried about you.</p>\n<p>You might be surprised at how often you find bugs and quirks in the code, or that the code isn&#8217;t conforming to the best practices outlined above. And if you discover issues, why not create a patch? Or if the plugin is on GitHub, create a pull request.</p>\n<p>You can also review your own code. A great method for doing this is to never deploy code straight into production. Instead, leave it on the day you finish it, and review it line by line in the morning. This method is easiest to adopt if you&#8217;re using something like GitHub where you can create a pull request with the changes, then review the pull request yourself the next day before merging it.</p>\n<p>In this vein, I highly recommend watching my colleague, Ryan Markel&#8217;s, <a href=\"http://wordpress.tv/2016/12/10/ryan-markel-code-review-keeping-things-secure-clean-and-performant/\">fantastic talk on this topic from WordCamp US 2016</a>.</p>\n<h3>7. Upgrade your tools (or at least use PHP_CodeSniffer)</h3>\n<p>There are lots of tools that help make web development easier, but if you&#8217;re doing a lot of WordPress development, the most valuable is probably <a href=\"https://github.com/squizlabs/PHP_CodeSniffer\">PHP<em>CodeSniffer</em></a>. It reads your code and automatically reviews it for bugs and coding standards inconsistencies while you type.</p>\n<p>It&#8217;s kind of like a spell checker, but for code. No matter how good your English is, you still use spell check right? So why wouldn&#8217;t you spell check your code?</p>\n<p>Here&#8217;s a bonus for you: the WordPress VIP Coding Standards are available by default with the <a href=\"https://github.com/WordPress-Coding-Standards/WordPress-Coding-Standards\">WordPress Coding Standards for PHPCodeSniffer</a>. So with that, it&#8217;ll check if you&#8217;re following most of the above resolutions.</p>\n<p>As you might imagine, using PHP_CodeSniffer also really helps highlight potential problems when you&#8217;re reviewing plugins and other people&#8217;s code.</p>\n<h3>8. Be curious</h3>\n<p>Far too often, I&#8217;m guilty of searching to try to find out what a particular WordPress function does, or scanning Stack Overflow to see if someone&#8217;s having the same problem as me.</p>\n<p>I have historically had a bad habit of seeing much of what WordPress does as magic, and avoiding getting too deep in the inner workings. But actually, it can be very beneficial to find out answers for yourself, instead of trying to find others who have already done the work.</p>\n<p>In essence, WordPress is quite simple. The code largely consists of functions taking arguments, and doing things with those arguments, and passing the results onto other functions taking arguments, and so on.</p>\n<p>It doesn&#8217;t take much to start unpicking something, and working out exactly what&#8217;s happening behind the scenes. So next time you&#8217;re struggling with a function, try going straight to looking at what the function actually does.</p>\n<p>Personally I find the <a href=\"https://github.com/wordpress/wordpress\">WordPress GitHub repo</a> that mirrors the core SVN repo to be a very useful way of doing this.</p>\n<p>The WordPress strapline is that &#8220;code is poetry&#8221;, and for its flaws I find that on the most part, the WordPress codebase is very readable, if nothing else! <img src=\"https://s.w.org/images/core/emoji/2.2.1/72x72/1f609.png\" alt=\"😉\" class=\"wp-smiley\" /></p>\n<p>I&#8217;ll conclude by taking this opportunity to wish you a very happy and prosperous new year!</p>\n<p><strong><em>Note</em>:</strong> Some of the above has been gleefully plagiarized from <a href=\"https://vip.wordpress.com/documentation/vip/code-review-what-we-look-for/\">WordPress.com VIP&#8217;s Code Review documentation</a>. It&#8217;s an Aladdin&#8217;s cave of useful advice, and I highly recommend working your way through it as and when you can.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 12 Jan 2017 21:26:05 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Jack Lenox\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:7;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:113:\"WPTavern: Tom McFarlin to Launch Marketplace for Blogging Plugins, Finds New Maintainer for WordPress.org Plugins\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=64899\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:123:\"https://wptavern.com/tom-mcfarlin-to-launch-marketplace-for-blogging-plugins-finds-new-maintainer-for-wordpress-org-plugins\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:5189:\"<p>Daily blogger and plugin author Tom McFarlin has found a new maintainer for five of his WordPress.org plugins. Within two days of <a href=\"https://tommcfarlin.com/wordpress-plugin-adoption/\" target=\"_blank\">putting the plugins up for adoption</a>, McFarlin <a href=\"https://tommcfarlin.com/wordpress-plugins-adopted/\" target=\"_blank\">announced</a> that <a href=\"https://twitter.com/philip_arthur\" target=\"_blank\">Philip Arthur Moore</a> will be taking over Category Sticky Post, Comment Tweets, Single Post Message, Tag Sticky Post, and Tipsy Social Icons. Moore, who is currently working as CTO at <a href=\"https://professionalthemes.nyc/\" target=\"_blank\">Professional Themes</a>, has inherited roughly 10,000 users overnight in the transfer of maintainership.</p>\n<p>WordPress.org plugin adoption stories are few and far between. The most common scenario for an orphaned plugin is to languish in the directory until it disappears from search results (with the exception of exact matches) after two years of no updates. In McFarlin&#8217;s case, he was looking to tie up some loose ends before shifting Pressware&#8217;s focus to launching Blogging Plugins, a marketplace for extensions that streamline WordPress for regular bloggers.</p>\n<p>&#8220;Last year, I had a few false starts when trying to launch what was originally called Pressware Plugins,&#8221; McFarlin said. &#8220;Fast-forward a few months and we’re going to focus on something called Blogging Plugins. We already have two free plugins available, though there’s an entire set of plugins, marketplace, and more coming.&#8221;</p>\n<p>Moore&#8217;s adoption of the plugins, which includes the first plugin McFarlin ever wrote, allows Pressware to move forward with its <a href=\"https://tommcfarlin.com/2017-plans/\" target=\"_blank\">2017 objectives</a>. McFarlin said he selected Moore based on the quality of his open source projects and reputation in the WordPress community.</p>\n<p>&#8220;For those of you who aren’t familiar with Philip’s side projects, you may be familiar with <a href=\"https://wordpress.org/plugins/subtitles/\" target=\"_blank\">Subtitles</a>,&#8221; McFarlin said. &#8220;It’s a plugin that falls right in line with my personal ethos of how things should work with WordPress: You activate it, it’s ready to go, and it feels native within the application.&#8221;</p>\n<blockquote class=\"twitter-tweet\">\n<p lang=\"en\" dir=\"ltr\">Why would I adopt <a href=\"https://twitter.com/tommcfarlin\">@tommcfarlin</a>\'s work? Because I owe him. He\'s ethical, an amazing man, and a stellar coder: <a href=\"https://t.co/WM66Xu1vm1\">https://t.co/WM66Xu1vm1</a></p>\n<p>&mdash; Philip Arthur Moore (@philip_arthur) <a href=\"https://twitter.com/philip_arthur/status/817399604698173440\">January 6, 2017</a></p></blockquote>\n<p></p>\n<p>The <a href=\"https://wordpress.org/plugins/tags/adopt-me\" target=\"_blank\">adopt-me</a> tag is used on WordPress.org to indicate plugins where the author is looking for a new maintainer. With just two pages of listings, it&#8217;s not yet widely used. Most developers find it easier to fork an open source plugin and WordPress.org has recently made it easier than ever for authors to <a href=\"https://make.wordpress.org/plugins/2016/12/22/want-to-close-your-plugins-email/\" target=\"_blank\">close a plugin</a> by simply emailing the plugin team.</p>\n<p>However, not all orphaned plugins are ready for end of life measures. Circumstances change in plugin authors&#8217; lives, but the strength of the user base is one of the primary indicators of a project that could thrive in new hands. The built-in user base is also one of the main advantages of adopting a plugin as opposed to forking it.</p>\n<p>Developer and ZDNet columnist David Gewirtz discovered the full weight of adopting a plugin&#8217;s users when he <a href=\"http://www.zdnet.com/article/a-year-later-what-happens-when-you-adopt-an-open-source-project/\" target=\"_blank\">took on 10 plugins</a> from the adopt-me section of the directory. Gewirtz, who inherited approximately 50,000 users, said the experience helped him reconnect with real users.</p>\n<p>&#8220;The value I&#8217;ve gained as a columnist, advisor, and educator that has come from interacting with users from so many nations with so many different skill sets and missions has been off the charts,&#8221; Gewirtz said. &#8220;I thought I&#8217;d keep my programming chops up, and I&#8217;ve certainly done that. But I never expected I&#8217;d gain a much broader perspective that I&#8217;d be able to apply to all of the areas of my professional life and meet so many cool people.&#8221;</p>\n<p>Adoption is arguably the healthiest outcome for any orphaned project &#8211; not just for the sake of reducing plugin abandonment but also for continuing support for users. Many of them blindly depend on plugins with no understanding of how they work.</p>\n<p>Once a plugin is downloaded and installed on users&#8217; sites, it gains a life of its own. Adoption strengthens a project&#8217;s history by proving it can weather storms that might otherwise cause the plugin to become obsolete and wipe out the user base.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 12 Jan 2017 07:59:54 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:8;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Matt: Thirty-Three\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:22:\"https://ma.tt/?p=47034\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://ma.tt/2017/01/thirty-three/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4279:\"<p>I&#8217;m taking it easy this week, nothing too crazy &#8212; just sharing good meals and wine with friends. Which is probably a good example of my goals for the year: putting family and loved ones first, slowing down (<a href=\"https://ma.tt/2014/10/run-better/\">to go further</a>), and deliciousness. (<a href=\"https://www.singlethreadfarms.com/\">Single Thread Farms</a> blew me away.)</p>\n<p>2016 was a year of incredible contrasts: it was the saddest and most challenged I&#8217;ve ever been with the <a href=\"https://ma.tt/2016/04/in-memoriam-chuck-mullenweg/\">passing of my father</a>, and while that overshadowed everything there were also bright moments of coming closer to family, deepening friendships, and growing professionally with incredible progress from both WordPress and Automattic. That momentum on the professional side is carrying through and right now I&#8217;m the most optimistic I can recall, and thrilled to wake up and get to work every day with the people I do.</p>\n<p>I talked about trying to spend longer stretches of time in fewer places, and that definitely happened. I flew 162k fewer miles than <a href=\"https://ma.tt/2016/01/thirty-two/\">the year before</a>, and visited 35 fewer cities. My blogging decreased a lot too &#8212; from 252 posts in 2015 to 76 posts in 2016, but the posts I did write were at least 50% longer. I made it to 9 more of the Top 50 restaurants and stand currently at 50% of <a href=\"http://www.theworlds50best.com/list/1-50-winners\">the list</a>. I finished <a href=\"https://www.pinterest.com/saxmatt/books-in-2016/\">22 books</a>, including a lot more fiction including my first few graphic novels like Ex Machina, Y: The Last Man, and Watchmen. I watched 35 movies, 9 of which were from the Marvel universe on a single flight from Cape Town to Dubai.</p>\n<p><a href=\"https://ma.tt/2016/01/thirty-two/\">Last year</a> I said, &#8220;it’s exciting to make the most of the opportunity that the volatility, love, loss, glory, failure, inspirations, and setbacks that 2016 will bring.&#8221; I didn&#8217;t know how right I would be, and wish I hadn&#8217;t been.</p>\n<p>This year doesn&#8217;t start with new plans, but rather three intentions continued from a few months ago. I <a href=\"https://ma.tt/2017/01/rebirth-and-yellow-arrows/\">revealed one yesterday</a>, and promised I would expand today on the others, so here they are:</p>\n<ol>\n<li><strong>Symmetry</strong> &#8212; Balance in all things, including my body which is stronger on my right side and much tighter on my left side. We also need symmetry in WordPress between the .org and .com products which differ too much.</li>\n<li><strong>Stillness</strong> &#8212; In echoes <a href=\"https://www.amazon.com/Art-Stillness-Adventures-Going-Nowhere-ebook/dp/B00JSRQSJS\">of Pico Iyer</a>, so much of my life in my 20s was about movement, and &#8220;going places to be moved.&#8221; In my 30s I&#8217;m looking inward. As Saint Augustine said in Book X, chapter 8 of <em>Confessions</em>: &#8220;Men go forth to wonder at the heights of mountains, the huge waves of the sea, the broad flow of the rivers, the vast compass of the ocean, the courses of the stars, and they pass by themselves without wondering.&#8221;</li>\n<li><strong>Yellow Arrows</strong> &#8212; The idea that there are clear indications of where to go next at every fork in the road, and if not you should paint them. I wrote more <a href=\"https://ma.tt/2017/01/rebirth-and-yellow-arrows/\">on this  yesterday</a>.</li>\n</ol>\n<p>Previously: <a href=\"https://ma.tt/2003/01/bday/\">19</a>, <a href=\"https://ma.tt/2004/01/so-im-20/\">20</a>, <a href=\"https://ma.tt/2005/01/hot-barely-legal-matt/\">21</a>, <a href=\"https://ma.tt/2006/01/matt-22/\">22</a>, <a href=\"https://ma.tt/2007/01/twenty-three/\">23</a>, <a href=\"https://ma.tt/2008/01/twenty-four/\">24</a>, <a href=\"https://ma.tt/2009/01/twenty-five/\">25</a>, <a href=\"https://ma.tt/2010/01/twenty-six/\">26</a>, <a href=\"https://ma.tt/2011/01/twenty-seven/\">27</a>, <a href=\"https://ma.tt/2012/01/twenty-eight/\">28</a>, <a href=\"https://ma.tt/2013/01/twenty-nine/\">29</a>, <a href=\"https://ma.tt/2014/01/matt-3-0/\">30</a>, <a href=\"https://ma.tt/2015/01/thirty-one/\">31</a>, and <a href=\"https://ma.tt/2016/01/thirty-two/\">32</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 12 Jan 2017 07:59:25 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:9;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"WPTavern: WordPress 4.7.1 Fixes Eight Security Issues\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=65100\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:64:\"https://wptavern.com/wordpress-4-7-1-fixes-eight-security-issues\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2146:\"<p>WordPress 4.7.1 <a href=\"https://wordpress.org/news/2017/01/wordpress-4-7-1-security-and-maintenance-release/\">is available</a> for download and fixes eight security issues that affect WordPress 4.7 and below. The PHPMailer library was updated to patch a remote code execution (RCE) vulnerability. WordFence <a href=\"https://www.wordfence.com/blog/2016/12/phpmailer-vulnerability/\">reported the vulnerability</a> last month as critical and that it affects WordPress core.</p>\n<p>However, in the announcement post for 4.7.1, Aaron Campbell, WordPress&#8217; <a href=\"https://make.wordpress.org/core/2017/01/09/aaron-campbell-leading-security/\">new Security Czar</a> says that, &#8220;No specific issue appears to affect WordPress or any of the major plugins we investigated but, out of an abundance of caution, we updated PHPMailer in this release.&#8221; <a href=\"https://legalhackers.com/\">Dawid Golunski</a> and <a href=\"https://twitter.com/Zenexer\">Paul Buonopane</a> are credited with <a href=\"https://make.wordpress.org/core/handbook/testing/reporting-security-vulnerabilities/\">responsibly disclosing</a> the vulnerability.</p>\n<p>WordPress 4.7.1 also fixes an issue where the REST API exposed user data for all users who authored a post of a public post type. This release limits this ability to only post types which have specified that they should be shown within the API. <a href=\"https://poststatus.com/\">Brian Krogsgard</a> and <a href=\"https://ithemes.com/\">Chris Jean</a> are credited with <a href=\"https://make.wordpress.org/core/handbook/testing/reporting-security-vulnerabilities/\">responsibly disclosing</a> the vulnerability.</p>\n<p>In addition to patching eight security issues, this release fixes 62 bugs. To see a full list of changes, visit the <a href=\"https://codex.wordpress.org/Version_4.7.1\">release notes</a> page or you can <a href=\"https://core.trac.wordpress.org/query?milestone=4.7.1\">view them on Trac</a>. Sites should update automatically but if you&#8217;d like to update sooner, visit your site&#8217;s Dashboard, select Updates, and click the Update Now button.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 11 Jan 2017 23:19:36 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:10;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:96:\"WPTavern: Facebook Launches Journalism Project, Plans to Expand Monetization of Instant Articles\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=65121\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:106:\"https://wptavern.com/facebook-launches-journalism-project-plans-to-expand-monetization-of-instant-articles\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3590:\"<p>After taking heat for the proliferation of &#8220;fake news&#8221; and misinformation on its platform during the US presidential election, Facebook is aiming to strengthen its ties with the news industry.</p>\n<p>&#8220;We care a great deal about making sure that a healthy news ecosystem and journalism can thrive,&#8221; Facebook director of product Fidji Simo said in the <a href=\"https://media.fb.com/2017/01/11/facebook-journalism-project/\" target=\"_blank\">announcement</a> today.</p>\n<p>The new <a href=\"https://www.facebook.com/facebookmedia/get-started/facebook-journalism-project\" target=\"_blank\">Facebook Journalism Project</a> will focus on creating news products with feedback from publishers, providing training and tools for journalists, and promoting news literacy for the public.</p>\n<p>In 2015 Facebook launched Instant Articles to deliver publishers&#8217; content instantly in exchange for advertising revenue. The platform will be expanding the feature to combine multiple Instant Articles in one post, starting January 12, 2017.</p>\n<a href=\"https://i0.wp.com/wptavern.com/wp-content/uploads/2017/01/facebook-multiple-instant-articles.png?ssl=1\"><img src=\"https://i0.wp.com/wptavern.com/wp-content/uploads/2017/01/facebook-multiple-instant-articles.png?resize=1025%2C527&ssl=1\" alt=\"\" class=\"size-full wp-image-65131\" /></a>image credit: <a href=\"https://media.fb.com/2017/01/11/multiple-instant-articles/\">Facebook</a>\n<p>&#8220;We’ve heard from editors that they want to be able to present packages of stories to their most engaged readers on Facebook,&#8221; Simo said. &#8220;We’re starting to work with several partners on how best to do this. We’re going to start testing this using Instant Articles, so that readers can start to see <a href=\"https://media.fb.com/2017/01/11/multiple-instant-articles/\" target=\"_blank\">multiple stories</a> at a time from their favorite news organizations.&#8221; Facebook is currently testing this feature with BILD, BuzzFeed, El Pais, Fox News, Hindustan Times, The Sun, The Washington Post, and other publishers.</p>\n<p>In April 2016, Automattic partnered with Facebook and VIP-Featured-Partner agency Dekode to develop <a href=\"https://wordpress.org/plugins/fb-instant-articles/\" target=\"_blank\">Instant Articles for WP</a>, a plugin that outputs a compliant feed of posts wrapped in the required markup for Facebook. The plugin passed 10K active installs at the end of 2016, but its star rating continues to plummet due to numerous errors with updates and a lack of support. Only 1 of 42 support threads has been marked resolved in the last two months. Publishers who depend on the plugin may need to have a developer on staff to handle issues with the plugin or select another solution.</p>\n<p>Facebook is also planning to collaborate with publishers on subscription business models for their content. Participation in this feature will require the publisher to make its content available through Instant Articles.</p>\n<p>&#8220;Many of our partners have placed a renewed emphasis on growing their subscription funnel, and we’ve already begun exploring ways we can support these efforts,&#8221; Simo said. &#8220;This month our engineering team in collaboration with the engineering team of the German news organization BILD will launch a test to explore offering free trials to engaged readers, right from within Instant Articles.&#8221; Simo also said they are working on other monetization options for publishing partners, including advertising breaks in regular videos.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 11 Jan 2017 21:49:05 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:11;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"HeroPress: Blogging, Solopreneurship, &amp; Terrorism\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://heropress.com/?post_type=heropress-essays&p=1563\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:64:\"https://heropress.com/essays/blogging-solopreneurship-terrorism/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:13067:\"<img width=\"960\" height=\"480\" src=\"http://20094-presscdn.pagely.netdna-cdn.com/wp-content/uploads/2017/01/011117-1024x512.jpg\" class=\"attachment-large size-large wp-post-image\" alt=\"Pull Quote: We will survive this, and this too will pass. You have my word.\" /><p>This story involves me as a blogger, the Prime Minister, me again as a web developer, an Islamic cult attempting a coup d&#8217;état, and me again as a solopreneur. Oh, and WordPress. And ISIS.</p>\n<h2>WordPress: My First Encounter</h2>\n<p>In the beginning of 2006, everyone in Turkey was talking about blogs. It was the hot new thing on the web. Forums were &#8220;out&#8221; and blogs were &#8220;in&#8221;. Anyways, I was getting ready for the ÖSS and studying to get into a university but I was psyched enough to register a blog on WordPress.com, on January 2006. (I moved the blog into a free hosting space the next month, and opened up <a href=\"http://beyn.org\">beyn.org</a> in July 2006.) I was in Kocaeli, the city right next to İstanbul.</p>\n<p>After the registration, I realized that I had nothing to write about. So I wrote about the day I had. The next day, I did the same thing. And the next day. And the next seven and a half years. Of course, I skipped four or five days. But that kind of dedication earned me a reputation and an award for &#8220;Best Personal Blogger of 2008&#8221;.</p>\n<p>But I didn&#8217;t just write about my days. After getting accepted into Ankara University in September 2006, I began to read and think about politics, as nearly all young Turks do in university. Eventually, I started writing about politics as well. Because you know what they say: If you want to learn something, write about it.</p>\n<p>Oh, I learned it pretty well, and I learned it the (somewhat) hard way.</p>\n<h2>Facing Jail Time with a Blog Post</h2>\n<p>2010 was probably my darkest year in my entire life. (2016 is the next candidate.) I was 22 years old, blogging daily, learning about web design and WordPress (more on that later), and keeping up with what&#8217;s going on with the country. Things were crazy back then: A very big prosecution was going on called the Ergenekon Case about military people allegedly planning a coup (Hint: This is not the coup I mentioned in the intro! These guys were all acquitted later.) and a big campaign for a constitutional referandum was more than enough to keep the whole country busy.</p>\n<p>In December 2010, Recep Tayyip Erdoğan, the Prime Minister of the time (and the President since 2014) sued me for one of my blog posts. It was about one of the slogans he used in his referandum rallies (&#8220;The terrorists and the opposition parties are soul mates!&#8221;) and me using the same sentence against him. Like, <em>the exact same sentence</em>. He didn&#8217;t like the way that the slogan was used against him, so he reported me and the state brought charges against me. I was 22 and I was being sued by the most powerful man in the country, because I used his words against him.</p>\n<p>When the Prime Minister sues you, you go to jail. There were little to no instances of winning a case against the government, especially when they were the one suing you. Thankfully, I was one of the few instances: I won the case in my third trial, February 14, 2012. (&#8220;Lovely&#8221; day, isn&#8217;t it?)</p>\n<p>There were one downside though: With the fear of the government suing me, I stopped writing about politics in 2011 and 2012, and even a few months after I won. And to this day, even though that fear is long gone, and even though I&#8217;m writing about politics again on Beyn, I still can&#8217;t write regularly like I did back then.</p>\n<p>Anyways. Moving on with the &#8220;web development&#8221; phase of my life.</p>\n<h2>Learning to Develop WordPress, and Teaching It at the Same Time</h2>\n<p>When I started Beyn, I immediately loved WordPress. I had some experience on HTML and CSS on Dreamweaver (never was a FrontPage guy), and I happily retired DW because I won&#8217;t be able to work on it while I was learning WordPress.</p>\n<p>I don&#8217;t remember trying to learn something with such passion. I loved the idea of plugins and themes extending the core. Beyn became my playground for new tricks, my laboratory for new experiments about WordPress. I installed plugins, edited themes, learned what&#8217;s right and what&#8217;s wrong with what I did&#8230; I probably crashed the website more than a hundred times!</p>\n<p>By 2012, I&#8217;d already started making websites for other people and getting paid. I had developed a few plugins, made a couple of themes from scratch. While still learning what awesome things I&#8217;m able to do with WordPress, I applied for a small writing gig at Wptuts+, which was later renamed <a href=\"https://tutsplus.com/authors/baris-unver\">Tuts+ Code</a>. Because you know what they say: If you want to learn something, write about it.</p>\n<p>That &#8220;small writing gig&#8221; was in fact my biggest source of education. I wasn&#8217;t a WordPress expert, but that gig was the ultimate reason to learn more and more about WordPress. I remember constantly feeling that &#8220;I&#8217;ve finished telling about everything I know about WordPress, so now I have to learn more!&#8221; and doing research on things to write about.</p>\n<p>I was aware that I don&#8217;t have any chance to write a sloppy tutorial, so I nagged my editors (first Japh Thomson, then Tom McFarlin) about my writing style, my choice of topics and of course, my English. They said my English was very good, and my topics are relevant and suitable for publishing on Tuts+. In almost exactly four years (from April 2012 to March 2016), I wrote 134 posts and I&#8217;m very proud of (almost) all my work there.</p>\n<p>While it was sad to leave Tuts+, I had a project in my mind that I put off so long: <a href=\"https://optimocha.com/\">Optimocha</a>.</p>\n<h2>WordPress Speed Optimization with Terrorists, Bombs and Death</h2>\n<p>That title came out grimmer than I expected. Heh. <em>Anyways.</em></p>\n<p>2015 was the year when I first thought about a speed optimization service for WordPress-based websites. Then I thought that I would better use my energy on the upcoming general elections in June. I worked for an NGO called &#8220;Vote and Beyond&#8221; to <a href=\"https://en.wikipedia.org/wiki/Vote_and_Beyond\">ensure transparency in observering of ballot count in the elections</a>.</p>\n<p>2015 was also the year with a whole lot of terrorist attacks. PKK, a terrorist organization <em>pretending</em> to defend Kurds&#8217; rights (while giving a bad name for all Kurds countrywide) and ISIS (you know them) were the most active terrorist organizations in 2015. They killed more than 250 people and injured more than 1000 in a series of shootings and bombings throughout the year.</p>\n<p>Worst year ever, right? <em>Not even close.</em> Let me quickly summarize the hell we&#8217;ve been through:</p>\n<ol>\n<li>ISIS killed 116 people in 5 different attacks.</li>\n<li>PKK killed 176 people in 15 different attacks.</li>\n<li>TAK, PKK&#8217;s even uglier cousin, killed 43 people in 4 different attacks.</li>\n<li>FETO killed 248 people across the country in their coup d&#8217;état attempt on July 15.</li>\n</ol>\n<p>583 people killed in terrorist attacks in 2016. <em>So, just a few more than all those lovely celebrities.</em></p>\n<p>What&#8217;s that FETO sticking out among the others, attempting a coup? That&#8217;s <strong>FE</strong>thullahist <strong>T</strong>errorist <strong>O</strong>rganization: The organization of Fethullah Gülen, an Islamic cult leader comfortably residing in Pennsylvania, plotting to take over the government for (I kid you not) over 40 years. Even I had made peace with the President because of the much needed &#8220;purges&#8221; to scrape his crypto-disciples in the government organizations. FETO is one of the enemies that can let you make peace with the ones against your values.</p>\n<p>(By the way: While celebrating that we got rid off that horror show of 2016, ISIS killed 39 more people with an AK-47 in a New Year party on January 1, in the middle of the night.)</p>\n<p>Still waiting for the part where I founded Optimocha, right? Sorry it took a bit long.</p>\n<p>April 2016 was the month I registered my company by paying for the usual fees to register a sole proprietorship, accountant fees, rent for an office (because by law, you can&#8217;t register a company without an office), some paperwork. All my funds vanished, leaving me with nothing to spend on marketing.</p>\n<p>PayPal halted operations in Turkey on June, because of conflicts with the government. 2CheckOut followed. I was going to use 2CO, so I was left with no payment gateway provider. Along with the terrorist attacks, I decided to spend Ramadan (the holy month for Muslims, passed on June 2016) sleeping, lying and moping around with depression.</p>\n<p>At the beginning of July, I was ready to work again, amped up for success! Except the coup attempt happened. Bombs and sonic booms in my city. Back to depression.</p>\n<p>By October, I was almost ready to go live with <a href=\"https://optimocha.com/\">the website</a>. I didn&#8217;t. I forced myself to finish it in November, before Black Friday. <em>I did!</em> People responded to my emails, said they&#8217;ll publish my deal on their blogs. People who saw the deal also responded and purchased my services. Yay.</p>\n<h2>Conclusion</h2>\n<p>Blogging is hard. Blogging with the most powerful man in your country trying to lock you up is the hardest.</p>\n<p>Solopreneurship is hard. Solopreneurship with several, highly active terrorist organizations killing people next to you is the hardest.</p>\n<p>Yet, <em>and I&#8217;m sure this is going to sound cheesy</em>, I have hope. This is the price we have to pay in order to get rid of the scum in the world. Turkey isn&#8217;t the worst country in the world suffering from terror&#8211;we&#8217;re just a country stuck between Europe, Russia, the Middle East and Africa. (Talk about a rock and a hard place&#8230;) We will survive this, and this too will pass.</p>\n<p>Turkey may be viewed as &#8220;yet another Middle Eastern country&#8221;, but it was founded almost a hundred years ago with the heritage of the Ottoman Empire, but also with a Western, secular mindset. <em>Even today</em>, you can&#8217;t find a sensible person talking trash about Mustafa Kemal Atatürk, who declined the Ottoman monarchy to set the foundation of a democratic republic in a time of dictatorships across Europe and Asia. Emphasis on the words &#8220;even today&#8221;, because the principles of his <em>vision</em> of the Republic of Turkey is in danger, a very large portion of the country has the confidence and equipment to defend those principles.</p>\n<p>Again: We will survive this, and this too will pass. You have my word.</p>\n<div class=\"rtsocial-container rtsocial-container-align-right rtsocial-horizontal\"><div class=\"rtsocial-twitter-horizontal\"><div class=\"rtsocial-twitter-horizontal-button\"><a title=\"Tweet: Blogging, Solopreneurship, & Terrorism\" class=\"rtsocial-twitter-button\" href=\"https://twitter.com/share?text=Blogging%2C%20Solopreneurship%2C%20%26%20Terrorism&via=heropress&url=https%3A%2F%2Fheropress.com%2Fessays%2Fblogging-solopreneurship-terrorism%2F\" rel=\"nofollow\" target=\"_blank\"></a></div></div><div class=\"rtsocial-fb-horizontal fb-light\"><div class=\"rtsocial-fb-horizontal-button\"><a title=\"Like: Blogging, Solopreneurship, & Terrorism\" class=\"rtsocial-fb-button rtsocial-fb-like-light\" href=\"https://www.facebook.com/sharer.php?u=https%3A%2F%2Fheropress.com%2Fessays%2Fblogging-solopreneurship-terrorism%2F\" rel=\"nofollow\" target=\"_blank\"></a></div></div><div class=\"rtsocial-linkedin-horizontal\"><div class=\"rtsocial-linkedin-horizontal-button\"><a class=\"rtsocial-linkedin-button\" href=\"https://www.linkedin.com/shareArticle?mini=true&url=https%3A%2F%2Fheropress.com%2Fessays%2Fblogging-solopreneurship-terrorism%2F&title=Blogging%2C+Solopreneurship%2C+%26%23038%3B+Terrorism\" rel=\"nofollow\" target=\"_blank\" title=\"Share: Blogging, Solopreneurship, & Terrorism\"></a></div></div><div class=\"rtsocial-pinterest-horizontal\"><div class=\"rtsocial-pinterest-horizontal-button\"><a class=\"rtsocial-pinterest-button\" href=\"https://pinterest.com/pin/create/button/?url=https://heropress.com/essays/blogging-solopreneurship-terrorism/&media=https://heropress.com/wp-content/uploads/2017/01/011117-150x150.jpg&description=Blogging, Solopreneurship, & Terrorism\" rel=\"nofollow\" target=\"_blank\" title=\"Pin: Blogging, Solopreneurship, & Terrorism\"></a></div></div><a rel=\"nofollow\" class=\"perma-link\" href=\"https://heropress.com/essays/blogging-solopreneurship-terrorism/\" title=\"Blogging, Solopreneurship, & Terrorism\"></a></div><p>The post <a rel=\"nofollow\" href=\"https://heropress.com/essays/blogging-solopreneurship-terrorism/\">Blogging, Solopreneurship, &#038; Terrorism</a> appeared first on <a rel=\"nofollow\" href=\"https://heropress.com\">HeroPress</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 11 Jan 2017 12:00:39 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Barış Ünver\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:12;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:58:\"Dev Blog: WordPress 4.7.1 Security and Maintenance Release\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=4650\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:84:\"https://wordpress.org/news/2017/01/wordpress-4-7-1-security-and-maintenance-release/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:6519:\"<p>WordPress 4.7 has been <a href=\"https://wordpress.org/download/counter/\">downloaded over 10 million times</a> since its release on December 6, 2016 and we are pleased to announce the immediate availability of WordPress 4.7.1. This is a <strong>security release</strong> for all previous versions and we strongly encourage you to update your sites immediately.</p>\n<p>WordPress versions 4.7 and earlier are affected by eight security issues:</p>\n<ol>\n<li>Remote code execution (RCE) in PHPMailer &#8211; <em>No specific issue appears to affect WordPress</em> or any of the major plugins we investigated but, out of an abundance of caution, we updated PHPMailer in this release. This issue was fixed in PHPMailer thanks to <a href=\"https://legalhackers.com/\">Dawid Golunski</a> and <a href=\"https://twitter.com/Zenexer\">Paul Buonopane</a>.</li>\n<li>The REST API exposed user data for all users who had authored a post of a public post type. WordPress 4.7.1 limits this to only post types which have specified that they should be shown within the REST API. Reported by <a href=\"https://poststatus.com/\">Krogsgard</a> and <a href=\"https://ithemes.com/\">Chris Jean</a>.</li>\n<li>Cross-site scripting (XSS) via the plugin name or version header on <code>update-core.php</code>. Reported by <a href=\"https://dominikschilling.de/\">Dominik Schilling</a> of the WordPress Security Team.</li>\n<li>Cross-site request forgery (CSRF) bypass via uploading a Flash file. Reported by <a href=\"https://twitter.com/Abdulahhusam\">Abdullah Hussam</a>.</li>\n<li>Cross-site scripting (XSS) via theme name fallback. Reported by <a href=\"https://pentest.blog/\">Mehmet Ince</a>.</li>\n<li>Post via email checks <code>mail.example.com</code> if default settings aren&#8217;t changed. Reported by John Blackbourn of the WordPress Security Team.</li>\n<li>A cross-site request forgery (CSRF) was discovered in the accessibility mode of widget editing. Reported by <a href=\"https://dk.linkedin.com/in/ronni-skansing-36143b65\">Ronnie Skansing</a>.</li>\n<li>Weak cryptographic security for multisite activation key. Reported by <a href=\"https://itsjack.cc/\">Jack</a>.</li>\n</ol>\n<p>Thank you to the reporters for practicing <a href=\"https://make.wordpress.org/core/handbook/testing/reporting-security-vulnerabilities/\">responsible disclosure</a>.</p>\n<p>In addition to the security issues above, WordPress 4.7.1 fixes 62 bugs from 4.7. For more information, see the <a href=\"https://codex.wordpress.org/Version_4.7.1\">release notes</a> or consult the <a href=\"https://core.trac.wordpress.org/query?milestone=4.7.1\">list of changes</a>.</p>\n<p><a href=\"https://wordpress.org/download/\">Download WordPress 4.7.1</a> or venture over to Dashboard → Updates and simply click “Update Now.” Sites that support automatic background updates are already beginning to update to WordPress 4.7.1.</p>\n<p>Thanks to everyone who contributed to 4.7.1: <a href=\"https://profiles.wordpress.org/aaroncampbell/\">Aaron D. Campbell</a>, <a href=\"https://profiles.wordpress.org/jorbin/\">Aaron Jorbin</a>, <a href=\"https://profiles.wordpress.org/adamsilverstein/\">Adam Silverstein</a>, <a href=\"https://profiles.wordpress.org/afercia/\">Andrea Fercia</a>, <a href=\"https://profiles.wordpress.org/azaozz/\">Andrew Ozz</a>, <a href=\"https://profiles.wordpress.org/gitlost/\">bonger</a>, <a href=\"https://profiles.wordpress.org/boonebgorges/\">Boone Gorges</a>, <a href=\"https://profiles.wordpress.org/chandrapatel/\">Chandra Patel</a>, <a href=\"https://profiles.wordpress.org/christian1012/\">Christian Chung</a>, <a href=\"https://profiles.wordpress.org/dlh/\">David Herrera</a>, <a href=\"https://profiles.wordpress.org/dshanske/\">David Shanske</a>, <a href=\"https://profiles.wordpress.org/dd32/\">Dion Hulse</a>, <a href=\"https://profiles.wordpress.org/ocean90/\">Dominik Schilling (ocean90)</a>, <a href=\"https://profiles.wordpress.org/dreamon11/\">DreamOn11</a>, <a href=\"https://profiles.wordpress.org/chopinbach/\">Edwin Cromley</a>, <a href=\"https://profiles.wordpress.org/iseulde/\">Ella van Dorpe</a>, <a href=\"https://profiles.wordpress.org/pento/\">Gary Pendergast</a>, <a href=\"https://profiles.wordpress.org/hristo-sg/\">Hristo Pandjarov</a>, <a href=\"https://profiles.wordpress.org/jnylen0/\">James Nylen</a>, <a href=\"https://profiles.wordpress.org/jblz/\">Jeff Bowen</a>, <a href=\"https://profiles.wordpress.org/jeremyfelt/\">Jeremy Felt</a>, <a href=\"https://profiles.wordpress.org/jpry/\">Jeremy Pry</a>, <a href=\"https://profiles.wordpress.org/joehoyle/\">Joe Hoyle</a>, <a href=\"https://profiles.wordpress.org/joemcgill/\">Joe McGill</a>, <a href=\"https://profiles.wordpress.org/johnbillion/\">John Blackbourn</a>, <a href=\"https://profiles.wordpress.org/kkoppenhaver/\">Keanan Koppenhaver</a>, <a href=\"https://profiles.wordpress.org/obenland/\">Konstantin Obenland</a>, <a href=\"https://profiles.wordpress.org/laurelfulford/\">laurelfulford</a>, <a href=\"https://profiles.wordpress.org/tyxla/\">Marin Atanasov</a>, <a href=\"https://profiles.wordpress.org/mattyrob/\">mattyrob</a>, <a href=\"https://profiles.wordpress.org/monikarao/\">monikarao</a>, <a href=\"https://profiles.wordpress.org/natereist/\">Nate Reist</a>, <a href=\"https://profiles.wordpress.org/celloexpressions/\">Nick Halsey</a>, <a href=\"https://profiles.wordpress.org/nikschavan/\">Nikhil Chavan</a>, <a href=\"https://profiles.wordpress.org/nullvariable/\">nullvariable</a>, <a href=\"https://profiles.wordpress.org/sirbrillig/\">Payton Swick</a>, <a href=\"https://profiles.wordpress.org/peterwilsoncc/\">Peter Wilson</a>, <a href=\"https://profiles.wordpress.org/presskopp/\">Presskopp</a>, <a href=\"https://profiles.wordpress.org/rachelbaker/\">Rachel Baker</a>, <a href=\"https://profiles.wordpress.org/rmccue/\">Ryan McCue</a>, <a href=\"https://profiles.wordpress.org/sanketparmar/\">Sanket Parmar</a>, <a href=\"https://profiles.wordpress.org/sebastianpisula/\">Sebastian Pisula</a>, <a href=\"https://profiles.wordpress.org/sfpt/\">sfpt</a>, <a href=\"https://profiles.wordpress.org/shazahm1hotmailcom/\">shazahm1</a>, <a href=\"https://profiles.wordpress.org/sstoqnov/\">Stanimir Stoyanov</a>, <a href=\"https://profiles.wordpress.org/stevenkword/\">Steven Word</a>, <a href=\"https://profiles.wordpress.org/szaqal21/\">szaqal21</a>, <a href=\"https://profiles.wordpress.org/timph/\">timph</a>, <a href=\"https://profiles.wordpress.org/voldemortensen/\">voldemortensen</a>, <a href=\"https://profiles.wordpress.org/vortfu/\">vortfu</a>, and <a href=\"https://profiles.wordpress.org/westonruter/\">Weston Ruter</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 11 Jan 2017 03:53:57 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:17:\"Aaron D. Campbell\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:13;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Matt: Rebirth and Yellow Arrows\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:22:\"https://ma.tt/?p=47020\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:48:\"https://ma.tt/2017/01/rebirth-and-yellow-arrows/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2464:\"<p>My friend <a href=\"https://www.amazon.com/Rebirth-Fable-Forgiveness-Following-Heart/dp/0316312282/\">Kamal Ravikant has a new book out, Rebirth, which I highly recommend</a>. I had the good fortune to read it a few months ago and the story of the Camino de Santiago touched and inspired me.</p>\n<p>Because of the impact of the book, I ended up adopting a few New Year&#8217;s intentions long before January 1st &#8212; things to ruminate on and keep in mind as the year wound down. The outlook of the world seemed uncertain, and I&#8217;m learning to navigate the world without my father.</p>\n<p><img /></p>\n<h3>Yellow Arrows</h3>\n<p>The Camino de Santiago is a pilgrimage path in Spain that people have walked since the 9th century AD. The 500 mile path winds through mountains, fields, and sometimes cities, and many pilgrims take a month or more on it. In some ways it is similar to <a href=\"http://walkkumano.com/\">the Kumano Kodo walk I did with Dan and Craig last year</a>.</p>\n<p>There are places where the path isn&#8217;t exactly clear, either because the trail isn&#8217;t strong, there&#8217;s been growth, or you might be in a crowded urban area like a city. Over the years pilgrims and people who live on the trail have marked it with yellow arrows pointing the way. If someone gets lost or confused, it&#8217;s an opportunity for an additional sign to bring them back on track.</p>\n<p>When you know the path, is it clear where someone else walking it should go next? It&#8217;s an interesting concept that applies across life. In your relationships, does your friend, loved one, or partner know what to expect, and where you&#8217;re headed together? Even in WordPress I feel like there are too many places where we bring someone to a fork in the road and there is no clear indication which way they should take.</p>\n<p>Give some thought to the yellow arrows in your life, and I&#8217;ll write more about the other two things I&#8217;ve been thinking about tomorrow. Also don&#8217;t forget <a href=\"https://www.amazon.com/Rebirth-Fable-Forgiveness-Following-Heart/dp/0316312282/\">to pick up a copy of Kamal&#8217;s book</a>. I loved it and I think it will be one I&#8217;m recommending to many friends.</p>\n<p><a href=\"https://www.amazon.com/Rebirth-Fable-Forgiveness-Following-Heart/dp/0316312282/\"><img /></a></p>\n<p>(Image from <a href=\"http://caminotravelcenter.com/who-was-elias-valina-follow-the-yellow-arrow/\">Camino Travel Center</a>.)</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 11 Jan 2017 03:48:45 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:14;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:85:\"WPTavern: Year in WP Creates a Personalized Review of WordPress Contributions in 2016\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=64884\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:96:\"https://wptavern.com/year-in-wp-creates-a-personalized-review-of-wordpress-contributions-in-2016\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:5116:\"<p><a href=\"https://yearinwp.com/\">Year In WP </a>is a new site by <span class=\"DMUpdateName-name DMConversation-name u-textTruncate\"><a href=\"http://jespervanengelen.com/\">Jesper van Engelen</a> that creates a personalized review of a user&#8217;s contributions to WordPress in 2016. Entering the WordPress.org username of a plugin or theme author or a WordPress core contributor into the field generates a list of statistics that includes:</span></p>\n<ul>\n<li>Profile information</li>\n<li>Number of times their plugins and themes were downloaded</li>\n<li>Most downloaded plugins and themes</li>\n<li>Average number of downloads per week</li>\n<li>Plugin and theme review rating average</li>\n<li>Percentage of five-star ratings</li>\n<li>A selection of five-star reviews</li>\n<li>Number of commits, changes, and comments to WordPress core</li>\n<li>Number of WordPress releases contributed to</li>\n</ul>\n<p>Engelen got the idea to create the site in 2014 after Spotify launched its &#8216;<a href=\"https://news.spotify.com/us/2014/12/03/2014-a-year-in-music/\">Year in Music</a>&#8216; that highlighted trends based on what 50 million users listened too.</p>\n<p>&#8220;I’d been active in the WordPress plugin market for about four years at that point, and I figured it would be really cool to get some year-over-year insight into your WordPress plugins,&#8221; Engelen said.</p>\n<p>&#8220;Having become a partner at Admin Columns (a freemium WordPress plugin) in 2014, I found out that I really liked analyzing statistics of downloads, sales and other data, and that, properly grouped and reported, they could have a pretty big influence on decision-making from a business perspective.&#8221;</p>\n<p>Engelen started the site by experimenting with fetching data from WordPress.org through its API that would show the change in the number of downloads to a user&#8217;s plugins.</p>\n<p>&#8220;That is basically what lead to the &#8216;Your most popular plugins&#8217; overview page,&#8221; Engelen said. &#8220;Spending some free hours each week on working on the project, more and more ideas of data to include popped up.&#8221;</p>\n<p><img class=\"alignnone size-full wp-image-65089\" src=\"https://i0.wp.com/wptavern.com/wp-content/uploads/2017/01/MostPopularPluginsandThemesPage.png?resize=1025%2C368&ssl=1\" alt=\"MostPopularPluginsandThemesPage\" /></p>\n<p>The site displays a lot of data, but it doesn&#8217;t include everything. Engelen would like to eventually display sections for contributions to WordPress translations, plugins, themes, core, design, etc.</p>\n<h2>The Technical Details</h2>\n<p>The data displayed on Year in WordPress is gathered using the <a href=\"https://codex.wordpress.org/WordPress.org_API\">WordPress.org API</a>, subversion, and web scraping. Engelen would have used the WordPress REST API but it was not available at the time, &#8220;Fetching the reviews and support topics yielded quite a bit of annoyance, as they’re done by scraping,&#8221; he said.</p>\n<p>He uses a Python framework to fetch relevant data in parallel. The data is stored in an SQL database, which is accessed by a front-end tool. The front-end of the site features a design that was reused from <a href=\"https://www.admincolumns.com/\">AdminColumns.com</a>.</p>\n<p>&#8220;jQuery, combined with Chart.js and Fullpage.js power the interactive portion of Year in WordPress. I’ve also written some simple sentiment analysis code for filtering out the most popular reviews to show for each plugin/theme developer,&#8221; Engelen said.</p>\n<h2>Fun Facts about Year in WordPress</h2>\n<p>Engelen provided the Tavern with these fun facts related to Year in WordPress:</p>\n<ul>\n<li>There’s a Year in Review for about 100,000 users on WordPress.org — or all users who have contributed to a plugin or theme, created a review or a support ticket, or contributed to WordPress core.</li>\n<li>The full database takes about 500MB of space.</li>\n<li>There were 364,763,308 plugin/theme downloads in 2015, and 434,865,745 in 2016. That’s 19.2% growth!</li>\n<li>2016 was the first year where the number of new core Trac tickets shrunk (4,044 in 2014; 4,392 in 2015; 4,028 in 2016)</li>\n<li>73% of all plugins received zero reviews in 2016</li>\n</ul>\n<h2>Year in WordPress 2017 Is Not Guaranteed</h2>\n<p>Engelen is not making any promises for continued development in 2017 as it&#8217;s contingent on his free time. However, the main thing he would like to change is to include a wider spectrum of data.</p>\n<p>&#8220;When I pitched the idea of Year in WordPress to a core committer and showed the beta version, he said &#8216;there&#8217;s so much more than core itself&#8217; and that stuck with me,&#8221; he said.</p>\n<p>&#8220;The perfect &#8216;Year in WordPress&#8217; would feature cool statistics about all types of contributions people make to WordPress — whether it’s creating plugins and themes, writing code for core, translating or testing. Furthermore, I’m really looking forward to making use of all of the REST API’s that I can use this time around.&#8221;</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 10 Jan 2017 22:11:43 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:15;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:52:\"WPTavern: Say What Plugin Passes 10K Active Installs\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=64778\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:63:\"https://wptavern.com/say-what-plugin-passes-10k-active-installs\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:5384:\"<p>WordPress core doesn&#8217;t make it easy to edit text strings, but a little plugin called <a href=\"https://wordpress.org/plugins/say-what/\" target=\"_blank\">Say What?</a> has been quietly gaining a solid user base by providing this functionality. It allows users to edit text strings without editing WordPress core or plugin code. Lee Willis released Say What in 2013, but the plugin had a significant jump in users in 2016, doubling the number of active installs from 5,000 to 10,000 sites.</p>\n<p>Willis, who is the author of <a href=\"https://profiles.wordpress.org/leewillis77/#content-plugins\" target=\"_blank\">22 plugins</a> hosted on WordPress.org and many more commercial extensions, created Say What while working as a Drupal developer.</p>\n<p>&#8220;One of our must-install Drupal modules was called String Overrides, which inspired Say What?&#8221; he said. &#8220;At the agency I was working at we used it regularly on virtually every site build to override plugin, theme, and core strings in a &#8216;non-hacky&#8217; way. Given that, I knew that the problem was there to be solved on WordPress, and that something that worked well would be useful to people.&#8221;</p>\n<p>Say What adds a new screen for editing text under Tools > Text changes for configuring string replacements. Users enter the current string, text domain, and replacement text.</p>\n<p><a href=\"https://i2.wp.com/wptavern.com/wp-content/uploads/2016/12/say-what-text-edits.png?ssl=1\"><img src=\"https://i2.wp.com/wptavern.com/wp-content/uploads/2016/12/say-what-text-edits.png?resize=1025%2C530&ssl=1\" alt=\"\" class=\"aligncenter size-full wp-image-64987\" /></a></p>\n<p>This plugin is a good option for those who are not comfortable sifting through PHP files and adding a filter to change the text. If you just have a handful of strings to replace, it&#8217;s more convenient than using a translation tool like POEDIT to edit the language files. All of the text changes are listed together in the Say What admin panel, so they can be easily changed at any time without editing any files.</p>\n<p>Willis said users don&#8217;t often experience conflicts with themes and plugins, as there is so little frontend functionality included in the plugin.</p>\n<p>&#8220;The main areas of support tend to be around locating particular strings, or issues where broken custom code is breaking the filters that Say What uses,&#8221; Willis said. After speaking with friends at a WordCamp in March 2015, he decided to create a commercial version to address this issue and a number of other feature requests.</p>\n<p>&#8220;The free version was out for about two years before I launched the <a href=\"https://plugins.leewillis.co.uk/downloads/say-what-pro/\" target=\"_blank\">Pro version</a>,&#8221; Willis said. &#8220;The only issue people tended to have with the free version was around finding the information they needed for the &#8216;original string,&#8217; so I decided to build out the String Discovery feature as the first feature of the Pro version. This lets users search for the string using autocomplete functionality, making it much easier to set up replacements without delving through theme or plugin code.&#8221;</p>\n<p>Say What increased in popularity in 2016 and has maintained a 4.6-star rating on WordPress.org. It is becoming more frequently recommended by support teams of other plugins when customers ask about how to change text strings.</p>\n<p>&#8220;It&#8217;s great to know that it&#8217;s being used to help people build more future-proof sites without resorting to hacking plugin or core code just to change strings,&#8221; Willis said. &#8220;Even for people familiar with plugin and theme code, the String Discovery feature makes it a lot easier and quicker to set up replacements. It&#8217;s had a few new features over the last year, including support for multi-line, and single/plural style replacements.&#8221;</p>\n<p>Willis said his Pro version proved to be fairly popular during 2016 and became one of his highest selling plugins. He recently added support for multilingual sites, the most often requested feature, allowing users to set up different replacements for different languages.</p>\n<p>Willis does not have an extensive roadmap for the plugin, as he prefers to keep it uncomplicated and free of clutter. &#8220;I&#8217;m a big believer in plugins that do one thing, and do it well,&#8221; he said.</p>\n<p>Say What is another successful instance of a developer solving one of his own problems and striking upon a successful commercial product. Willis said he didn&#8217;t fully anticipate how popular the plugin would become.</p>\n<p>&#8220;As with most of my plugins it was also built to solve a problem that I personally was having at the time,&#8221; he said. &#8220;That said, I&#8217;m always (pleasantly) surprised when something does get popular.&#8221;</p>\n<p>After testing <a href=\"https://wordpress.org/plugins/say-what/\" target=\"_blank\">Say What</a> I found that Willis&#8217; implementation is the simplest way for non-technical users to make a few simple string changes without the risk of breaking their websites. He is also very responsive on the support forums. The success of the Pro version is a good indication that Willis will be able to continue support and maintenance on the free plugin for the foreseeable future.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 10 Jan 2017 21:26:31 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:16;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:67:\"WPTavern: How Laravel Forge Can Help You Run WordPress in the Cloud\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=64940\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:78:\"https://wptavern.com/how-laravel-forge-can-help-you-run-wordpress-in-the-cloud\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:7837:\"<p><a href=\"https://i0.wp.com/wptavern.com/wp-content/uploads/2015/05/petersuhm.jpeg?ssl=1\"><img src=\"https://i0.wp.com/wptavern.com/wp-content/uploads/2015/05/petersuhm.jpeg?resize=150%2C150&ssl=1\" alt=\"petersuhm\" class=\"alignright size-thumbnail wp-image-43613\" /></a>This opinion piece was contributed by guest author <a href=\"https://twitter.com/petersuhm\" target=\"_blank\">Peter Suhm</a>. Peter is a web developer from the Land of the Danes. He is the creator of <a href=\"https://wppusher.com/\" target=\"_blank\">WP Pusher</a> and a huge travel addict, bringing his work along with him as he goes.<br />\n&nbsp;</p>\n<hr />\n<p><a href=\"http://forge.laravel.com/\" target=\"_blank\">Laravel Forge</a> is a server and application provisioning tool that was originally built to serve the Laravel PHP crowd. Recently, it has been made available to WordPress developers too, with the introduction of 1-click installs of WordPress on Digital Ocean, Linode and AWS cloud servers. In this post, I&#8217;ll give you a brief introduction to Laravel Forge and show you how you can use it to manage all of your WordPress installations in the cloud.</p>\n<h3>Laravel Forge is good news for WordPress developers</h3>\n<p>Because so many WordPress developers are used to managed hosting, the thought of running their own servers seem quite intimidating. That&#8217;s a shame with so many great cloud server companies offering virtual servers for very low costs. Unless your traffic is very heavy, a small ($5 to $10 per month) server can run quite a few WordPress websites. Laravel Forge takes care of provisioning your servers and can even setup your database and install WordPress for you. This makes cloud hosting much more available to WordPress developers at a low cost (Laravel Forge is $15 per month for unlimited servers), compared to many of the existing options.</p>\n<p>Here are a few reasons why I think Laravel Forge is great for WordPress hosting:</p>\n<ul>\n<li>Your servers are configured in a secure way by default, with SSH authentication, firewalls, automatic security updates and free SSL certificates from Let&#8217;s Encrypt</li>\n<li>Your servers are going to be really fast with PHP 7</li>\n<li>You can run a lot of WordPress installs on 1 single server *</li>\n<li>You can scale your servers if you need more horse power *</li>\n</ul>\n<p><em>* Goes for the cloud in general</em></p>\n<h3>Creating a new server</h3>\n<p>Here is how the &#8220;Create Server&#8221; screen looks in Forge:</p>\n<p><a href=\"https://i2.wp.com/wptavern.com/wp-content/uploads/2017/01/create-server-e1483980109591.png?ssl=1\"><img src=\"https://i2.wp.com/wptavern.com/wp-content/uploads/2017/01/create-server-e1483980109591.png?resize=1025%2C416&ssl=1\" alt=\"\" class=\"aligncenter size-full wp-image-64946\" /></a></p>\n<p>If you use Digital Ocean, Forge can also create your servers. If you use another provider like Linode or AWS, Forge can only do the provisioning part.</p>\n<p>For Digital Ocean servers, here are the options you can configure:</p>\n<ul>\n<li>Which credentials to use, if you are managing multiple Digital Ocean accounts</li>\n<li>The server name</li>\n<li>The server size</li>\n<li>The server region</li>\n<li>The PHP version</li>\n<li>The default database name</li>\n</ul>\n<p>You can then choose to:</p>\n<ul>\n<li>Configure the server as a load balancer (if you have really heavy traffic and is running WordPress across multiple servers)</li>\n<li>Install <a href=\"https://mariadb.org/\" target=\"_blank\">MariaDB</a> instead of MySQL, which is a drop-in, faster replacement</li>\n<li>Enable weekly backups on Digital Ocean</li>\n</ul>\n<p>When Laravel Forge is done with the provisioning, your server is ready to go.</p>\n<h3>Setting up a database</h3>\n<p><a href=\"https://i0.wp.com/wptavern.com/wp-content/uploads/2017/01/set-up-database-e1483980726266.png?ssl=1\"><img src=\"https://i0.wp.com/wptavern.com/wp-content/uploads/2017/01/set-up-database-e1483980726266.png?resize=1025%2C484&ssl=1\" alt=\"\" class=\"aligncenter size-full wp-image-64949\" /></a></p>\n<p>Once your server has been created, setting up a database for your WordPress installation is very easy. You can create the user at the same time you&#8217;re creating the database, or you can create the user afterwards.</p>\n<h3>Installing WordPress</h3>\n<p>Before you install WordPress, you need to create a new &#8220;site&#8221; on your server. You can just stick with the defaults:</p>\n<p><a href=\"https://i1.wp.com/wptavern.com/wp-content/uploads/2017/01/new-site-e1483981223250.png?ssl=1\"><img src=\"https://i1.wp.com/wptavern.com/wp-content/uploads/2017/01/new-site-e1483981223250.png?resize=1025%2C453&ssl=1\" alt=\"\" class=\"aligncenter size-full wp-image-64951\" /></a></p>\n<p>For the &#8220;Root Domain&#8221;, you need to add the domain name of the site you are setting up. Remember that you need to add a DNS record for your domain that points to the IP address of your newly created server. If you are just testing, you can always add a record in your computer&#8217;s <code>hosts</code> file with a test domain that points to your server. Something like this:</p>\n<p><code># /etc/hosts</code></p>\n<p><code># Replace xx.xx.xx.xx with your server\'s IP address<br />\nxx.xx.xx.xx wordpress-forge.test</code></p>\n<p>Once you click the &#8220;Add Site&#8221; button, you will see a spinning wheel while Forge is setting up your site&#8217;s nginx configuration.</p>\n<p>When the installation is done, you need to click the &#8220;Manage&#8221; icon next to your site in order to install WordPress. The first screen you will be presented with gives you the option to install an &#8220;App&#8221; on your site. Click the &#8220;WordPress&#8221; button, select your database and user from the previous step and relax while Laravel Forge completes the installation. Fun fact: Laravel Forge is actually using WP-CLI to install WordPress on your server.</p>\n<p>When the installation has completed, visit your site in a browser and you&#8217;ll be met with something familiar:</p>\n<p><a href=\"https://i1.wp.com/wptavern.com/wp-content/uploads/2017/01/wp-install-e1483984375432.png?ssl=1\"><img src=\"https://i1.wp.com/wptavern.com/wp-content/uploads/2017/01/wp-install-e1483984375432.png?resize=1025%2C625&ssl=1\" alt=\"\" class=\"aligncenter size-full wp-image-64962\" /></a></p>\n<h3>Setting up a free SSL certificate</h3>\n<p>Finally, you should set up SSL for your WordPress site. It&#8217;s more secure and Google likes it!</p>\n<p><a href=\"https://i0.wp.com/wptavern.com/wp-content/uploads/2017/01/ssl-setup.png?ssl=1\"><img src=\"https://i0.wp.com/wptavern.com/wp-content/uploads/2017/01/ssl-setup.png?resize=1025%2C288&ssl=1\" alt=\"\" class=\"aligncenter size-full wp-image-64963\" /></a></p>\n<p>Head over on the &#8220;SSL&#8221; tab and click the &#8220;LetsEncrypt (Beta)&#8221; button. Click the &#8220;Obtain Certificate&#8221; button and wait while Forge creates and installs the certificate. Once the certificate is installed, click the &#8220;Activate&#8221; icon and voila! Your site is now all set up and secured with SSL.</p>\n<p>That&#8217;s how easy it is to setup WordPress on a cloud server with Laravel Forge. I hope to see a lot of more products and tools like this that can help us building better, faster, and more secure WordPress websites. In fact, Laravel Forge was the original inspiration for my own product <a href=\"https://wppusher.com/\" target=\"_blank\">WP Pusher</a>. I wanted to create a similar experience, but for WordPress plugins and themes instead.</p>\n<h3>Note on backups and security</h3>\n<p><em>Please note that even though Laravel Forge makes for a great starting point, ultimately you are the one in charge of the security of your servers. You should always try to educate yourself about security and have a backup strategy for your data.</em></p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 09 Jan 2017 18:44:42 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:17;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:45:\"Post Status: Contributing to Twenty Seventeen\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"https://poststatus.com/?p=31886\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:62:\"https://poststatus.com/contributing-to-twenty-seventeen-theme/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:11882:\"<p><em><strong>Editor&#8217;s Note</strong>: This is a guest post by <a href=\"https://poststatus.com/profiles/sami-keijonen/\">Sami Keijonen</a>. Sami is a developer, the owner of the <a href=\"https://foxland.fi/\">Foxland theme and plugin shop</a>, and hails from Finland.</em></p>\n<p>Every year since 2010, WordPress has shipped with a new default theme, breaking the cycle of Kubrick being the primary default theme for years before that.</p>\n<p>In 2010, the default theme was called Twenty Ten. In 2011, the default theme was called Twenty Eleven. You get the idea.</p>\n<p>While every default theme has been unique in its own way, <a href=\"https://wordpress.org/themes/twentyseventeen/\">Twenty Seventeen</a> was particularly compelling in a way we haven’t seen in a default theme since Twenty Fourteen.</p>\n<p><a href=\"https://wordpress.org/themes/twentyfourteen/\">Twenty Fourteen</a> was the first theme that really made people think WordPress could be used for more than “just a blog” on a mass scale. It is a magazine theme.</p>\n<p>Twenty Seventeen &#8212; <a href=\"https://poststatus.com/wordpress-4-7-released/\">released with WordPress 4.7</a> &#8212; is the first theme that really made people think WordPress could be used for more than “just publishing content” on a mass scale. It is a business theme.</p>\n<p><img /></p>\n<p>Prior to WordPress 4.7, I contributed by helping out in the support forums and building <a href=\"https://foxland.fi/downloads/category/themes/\">accessible themes</a>. But I had never contributed to core before.</p>\n<p>When I saw the <a href=\"https://make.wordpress.org/core/2016/09/09/say-hello-to-twenty-seventeen-%25F0%259F%2591%258B%25F0%259F%258F%25BD/\">previews</a>, I knew I wanted to contribute, and began to follow development on GitHub to see if there was anything that I could lend my talents to and eventually make my first core contributions.</p>\n<p>When I saw Morten Rand-Hendriksen <a href=\"https://github.com/WordPress/twentyseventeen/issues/60\">open an issue</a> about replacing icon fonts with SVG icons, I knew I had found the perfect “in” to start contributing to core.</p>\n<h3>Contributing SVG icons system to Twenty Seventeen</h3>\n<p><img /></p>\n<p>I had already <a href=\"https://foxland.fi/switch-away-icon-fonts-svg/\">switched from icon fonts to SVG icons</a> in my public themes, so this was something I immediately felt confident in contributing to core.</p>\n<p>Development started in <a href=\"https://github.com/WordPress/twentyseventeen/\">GitHub</a>, where fellow contributors would create issues and submit pull requests.</p>\n<p>Then, everything moved to <a href=\"https://core.trac.wordpress.org/browser/trunk\">WordPress SVN</a>, where new patches were submitted.</p>\n<p>I’ll summarize what I learned in the process.</p>\n<h3>What I learned about contributing</h3>\n<p>I regret not keeping a diary. Not necessarily to keep track of what I contributed, since that’s all documented in the open.</p>\n<p>But rather things like my emotional state. My feelings ranged from despair to overwhelming joy throughout my contribution experience.</p>\n<p>I learned new things about code and collaborating with others in GitHub and SVN. Again, something not necessarily documented in patches and the like.</p>\n<h4>Git workflow</h4>\n<p>I’m not good with Git, and still don’t fully understand how rebasing works. I messed up my commits a couple of times. Not a big deal, but I got different error messages no matter which workflow I tried. I realized that I need to know more about Git, and be more patient.</p>\n<p>Eventually I understood enough to get my contributions through the door, but I’m still confused about <a href=\"https://github.com/edx/edx-platform/wiki/How-to-Rebase-a-Pull-Request\">how to rebase a pull request</a>.</p>\n<h4>Follow the development through to the end, and beyond</h4>\n<p>I started out by replacing only the social link icon fonts to SVG icons. Soon, I realized that a step-by-step process was not going to work because of new related commits coming in all the time that potentially conflicted with my code.</p>\n<p>It was better to replace all icon fonts, not just the social ones, with SVGs, and then work from there. I was also keeping track of style changes in RTL languages and IE8.</p>\n<p>At this point, the work was just getting started.</p>\n<p>Once you start contributing, you shouldn&#8217;t just disappear with no explanation. If you’re running low on time or have other obligations, it’s totally understandable, but be sure to politely inform others you can’t continue anymore, so they can pick up where you left off.</p>\n<p>As the <a href=\"https://geto2.com/\">o2</a> slogan states: &#8220;Communication is oxygen.&#8221;</p>\n<h4>Coding standards and automated tests</h4>\n<p>After several commits and iterations, <a>my first pull request was accepted</a>.</p>\n<p>As you can see in my first commits, I didn’t pass the WordPress coding standards. I needed to be more precise and follow the coding standards to the tee. With enough practice, I’m sure it’s possible to write standards-compliant code “naturally” but I was looking for a way to automate the code checks.</p>\n<p>I tried to get Atom to evaluate my code on the fly, but I just couldn’t get it to work. Like my Git experience, I got different error messages no matter what I tried.</p>\n<p>Eventually, I was able to use <a href=\"https://github.com/WordPress-Coding-Standards/WordPress-Coding-Standards\">PHPCS</a> via the command line, and fixed any issues discovered manually. But it would’ve been nice to have those checks automated.</p>\n<h4>Working with batches in SVN</h4>\n<p>Once the development moved to SVN, I began to get a little worried. As I described earlier, not too long ago, I was struggling just to use Git. However, thanks to the following tutorials I quickly got up to speed.</p>\n<ul>\n<li><a href=\"https://make.wordpress.org/core/handbook/tutorials/installing-wordpress-locally/from-svn/\">Installing via SVN</a></li>\n<li><a href=\"https://make.wordpress.org/core/handbook/tutorials/installing-a-vcs/%23installing-tortoisesvn\">Installing TortoiseSVN</a> (I use Windows)</li>\n<li><a href=\"https://make.wordpress.org/core/handbook/tutorials/trac/submitting-a-patch/\">Submitting a Patch</a></li>\n<li><a href=\"https://make.wordpress.org/core/handbook/tutorials/working-with-patches/%23creating-a-patch-with-tortoisesvn\">Creating a Patch with TortoiseSVN</a></li>\n</ul>\n<p>Turns out, it wasn’t much to be worried about. Although I didn’t quite understand the concept of branches and tags in my local environments, and jumping between them like I know how to do with Git.</p>\n<p>Anyway, I eventually got <a href=\"https://core.trac.wordpress.org/changeset/39072\">my first props</a> with the help of others.</p>\n<h3>Technical overview of the SVG icons system</h3>\n<p>I adapted this contribution from the code and concepts first presented by others.</p>\n<ol>\n<li><a href=\"https://webdevstudios.com/\">WebDevStudios</a> has their own starter theme called <a href=\"https://github.com/WebDevStudios/wd_s\">wd_s</a>. I really like how they set up SVG icons and we fine-tuned them in Twenty Seventeen. Perhaps they will integrate those improvements back into their own project. Again, open source rocks.</li>\n<li><a href=\"http://themehybrid.com/\">Justin Tadlock</a> invented the <a href=\"http://justintadlock.com/archives/2013/08/14/social-nav-menus-part-2\">social links menu</a> concept. I just took that concept and applied it to SVG icons rather than icon fonts.</li>\n</ol>\n<p>All the main SVG-related functions can be found in the <a href=\"https://core.trac.wordpress.org/browser/trunk/src/wp-content/themes/twentyseventeen/inc/icon-functions.php\">inc/icon-functions.php file</a>. It’s well-documented in the code, but here’s a summary:</p>\n<ul>\n<li>Include the SVG sprite file via the <code>wp_footer</code> hook.</li>\n<li><code>twentyseventeen_get_svg()</code> function returns the SVG icon markup. In most cases, the SVG icon is injected in template files or via hooks and filters. In some cases, the SVG icon is injected via JavaScript.</li>\n<li>Default markup looks like this: <code>&lt;svg class=\"icon icon-name\" aria-hidden=\"true\" role=\"img\"&gt; &lt;use href=\"#icon-name\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" xlink:href=\"#icon-name\"&gt;&lt;/use&gt; &lt;/svg&gt;</code>.</li>\n<li>Note that we could use the absolute path to the SVG file in the <code>href</code> attribute of the use element. In that case:\n<ul>\n<li>there is no need to inject icons via the <code>wp_footer</code> hook.</li>\n<li>The <a href=\"https://github.com/Keyamoon/svgxuse\">svgxuse</a> JS polyfill must be used, because Internet Explorer doesn’t support external files referenced in the <code>&lt;use&gt;</code> element.</li>\n<li>This method helps caching the SVG sprite file.</li>\n</ul>\n</li>\n<li>By default, all icons are decorative, but I insisted we show how to use non-decorative icons in an accessible way. Check the examples in the aforementioned <code>twentyseventeen_get_svg()</code> function.</li>\n<li>We replace the default icon for supported social media links by using the <code>walker_nav_menu_start_el</code> filter.</li>\n</ul>\n<h3>Open source rocks</h3>\n<p>WordPress default themes are one of the best themes out there and they set an example how to use new WordPress features. The reason for this is simple.</p>\n<ul>\n<li>Default themes gets lots of love and attention.</li>\n<li>Many talented people contribute to default themes. <a href=\"https://davidakennedy.com/2016/12/07/dear-twenty-seventeen-contributors/\">Twenty Seventeen had over 100 contributors</a> and we thank you all!</li>\n<li>Default themes are tested before release in many platforms and browsers. And default themes are used on so many sites that any remaining bugs will be found after the release.</li>\n</ul>\n<p>Building default themes really is a community driven project. I&#8217;d like to say extra thanks for couple of people.</p>\n<h4>Special thank you</h4>\n<p>Any web project needs good leadership, design, and code. Those were all covered in Twenty Seventeen.</p>\n<ul>\n<li><a href=\"https://twitter.com/DavidAKennedy\">David A. Kennedy</a> was leading the project and kept everything rolling. He had a really friendly touch and he was open to ideas. At the same time he wasn&#8217;t afraid to make decisions; for example, a flexbox layout was rejected for this theme.</li>\n<li><a href=\"https://twitter.com/melchoyce\">Mel Choyce</a> created the modern, business looking design. She wrote a great article <a href=\"https://choycedesign.com/2016/12/07/behind-the-scenes-of-twenty-seventeen/\">with her behind the scenes take</a>.</li>\n<li><a href=\"https://twitter.com/laurelfulford\">Laurel Fulford</a> was the primary coding lead. She seem to have a solution for every new feature and brought Mel&#8217;s design to life with detailed code.</li>\n</ul>\n<p>Last but not least, remember <a href=\"http://mor10.com/\">Morten Rand-Hendriksen</a>, the one that opened the SVG icon issue that caught my eye?</p>\n<p>He was pretty happy with the end result.</p>\n<blockquote class=\"twitter-tweet\">\n<p lang=\"en\" dir=\"ltr\"><a href=\"https://twitter.com/brad_frost\">@brad_frost</a> the SVG icon system solution by <a href=\"https://twitter.com/samikeijonen\">@samikeijonen</a> embedded in the new Twenty Seventeen theme in <a href=\"https://twitter.com/hashtag/WordPress?src=hash\">#WordPress</a> is pure genius</p>\n<p>&mdash; MortenRandHendriksen (@mor10) <a href=\"https://twitter.com/mor10/status/805808154520883200\">December 5, 2016</a></p></blockquote>\n<p></p>\n<p>Who knows if I would’ve contributed if it wasn’t for him posting that. Remember, reporting issues and bugs is contributing too, and can inspire first-time contributors like me to stop sitting on the sidelines and finally get started with core contributions.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 07 Jan 2017 22:42:26 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sami Keijonen\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:18;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:71:\"WPTavern: Let’s Encrypt Passes 20 Million Active Certificates in 2016\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=64815\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:79:\"https://wptavern.com/lets-encrypt-passes-20-million-active-certificates-in-2016\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:5050:\"<p>Let&#8217;s Encrypt has just closed out its first full year as a certificate authority with more than <a href=\"https://letsencrypt.org/2017/01/06/le-2016-in-review.html\" target=\"_blank\">20 million active certificates</a>. The free and open certificate authority focuses on lowering the complexity of setting up TLS encryption by making the process more automated. It came <a href=\"https://wptavern.com/lets-encrypt-is-now-out-of-beta\" target=\"_blank\">out of beta</a> in April 2016 and the number of certificates issued per day has grown steadily since then.</p>\n<p>&#8220;At the start of 2016, Let’s Encrypt certificates had been available to the public for less than a month and we were supporting approximately 240,000 active (unexpired) certificates,&#8221; said Josh Aas, Executive Director of the non-profit Internet Security Research Group (ISRG). &#8220;Now we’re frequently issuing that many new certificates in a single day while supporting more than 20,000,000 active certificates in total. We’ve issued more than a million certificates in a single day a few times recently.&#8221;</p>\n<p><a href=\"https://i2.wp.com/wptavern.com/wp-content/uploads/2017/01/lets-encrypt-2016.png?ssl=1\"><img src=\"https://i2.wp.com/wptavern.com/wp-content/uploads/2017/01/lets-encrypt-2016.png?resize=1025%2C503&ssl=1\" alt=\"\" class=\"aligncenter size-full wp-image-64920\" /></a></p>\n<p>Let&#8217;s Encrypt operates as a 501(c)(3) nonprofit and has received more than three dozen corporate <a href=\"https://letsencrypt.org/sponsors/\" target=\"_blank\">sponsorships</a> and grants, but funds for the coming year have fallen short. In November, Let&#8217;s Encrypt launched a <a href=\"https://www.generosity.com/community-fundraising/make-a-more-secure-web-with-let-s-encrypt\" target=\"_blank\">crowdfunding campaign</a> to cover the cost of one month of operating expenses. So far, the campaign has raised more than $100K towards its $200K fundraising goal.</p>\n<h3>Let&#8217;s Encrypt is Growing Fastest with Smaller, Previously-Unencrypted Sites</h3>\n<p>Let&#8217;s Encrypt is used with some larger organizations, such as WordPress.com, OVH, Shopify, Akamai, and Dreamhost, but the vast majority of users are smaller entities that were not previously encrypted. According to the Electronic Frontier Foundation (EFF), a founding sponsor of the certificate authority, most of Let&#8217;s Encrypt&#8217;s growth has not come from taking customers away from competitors:</p>\n<blockquote><p>\nOne of the ways Let&#8217;s Encrypt has been helping to secure the web is by making it easy and affordable for sites that have never had certs before to turn on secure HTTPS connections, and for software systems to start enabling HTTPS automatically and by default. Our free certificates may be more likely to be left unused than expensive certificates, and less expert webmasters may accidentally duplicate certificates—but that’s part of making HTTPS integration available to more webmasters across a range of resource and skill levels. Statistics suggest that most of our growth has come not at the expense of other CAs, but from giving previously unencrypted sites their first-ever certificates.</p></blockquote>\n<p>EFF analyzed various sources of usage statistics and estimates that <a href=\"https://www.eff.org/deeplinks/2016/10/lets-encrypt-largest-certificate-authority-web\" target=\"_blank\">Let&#8217;s Encrypt is now the largest certificate authority on the web</a>. Its rapid adoption has spurred impressive progress towards getting the entire web encrypted. Let&#8217;s Encrypt tracks progress by measuring the percentage of page loads using HTTPS, as seen by browsers.</p>\n<p>&#8220;According to Firefox Telemetry, the Web has gone from approximately 39% of page loads using HTTPS each day to just about 49% during the past year,&#8221; Aas said in Let&#8217;s Encrypt&#8217;s <a href=\"https://letsencrypt.org/2017/01/06/le-2016-in-review.html\" target=\"_blank\">2016 in Review</a> report. &#8220;We’re incredibly close to a Web that is more encrypted than not.&#8221;</p>\n<p>The proliferation of Let&#8217;s Encrypt <a href=\"https://letsencrypt.org/docs/client-options/\" target=\"_blank\">client options</a> in 2016 puts the certificate authority in an even better position to continue driving web encryption in 2017. Aas attributes last year&#8217;s progress to many organizations advocating for HTTPS and working to get their sites encrypted. His team has grown from four full-time employees to nine, and he anticipates that 2017 will be a year of even greater growth.</p>\n<p>&#8220;Much of the infrastructure and many of the plans necessary for a 100% encrypted Web came into being or solidified in 2016,&#8221; Aas said. &#8220;More and more hosting providers and CDNs are supporting HTTPS with one click or by default, often without additional fees. It has never been easier for people and organizations running their own sites to find the tools, services, and information they need to move to HTTPS.&#8221;</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 07 Jan 2017 21:42:52 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:19;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"WPTavern: How Do You Educate People New to WordPress?\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=64890\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:63:\"https://wptavern.com/how-do-you-educate-people-new-to-wordpress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:5213:\"<p>When a friend of mine asked for suggestions on what he should use to create a new site, I suggested WordPress. It is well supported, has an amazing community, and a ton of free themes and plugins to choose from. After getting WordPress installed on a new webhosting account, I left him be to see what issues he would run into and how he would configure the site.</p>\n<p>After noticing the site was loading slowly three weeks later, I obtained admin access to try to determine what the problem was. The first thing I did was check which plugins he installed. One of the plugins added the ability to embed YouTube videos on the site using shortcodes. My friend was unaware that WordPress has <a href=\"https://codex.wordpress.org/Embeds\">oEmbed support</a> which allows users to easily embed videos by pasting the URL into the editor.</p>\n<p>He also installed a couple of other plugins that mimicked core functionality. He was unaware that WordPress does most of the things he wants without the need for plugins.</p>\n<h2>Page Builder Shenanigans</h2>\n<p>After activating a theme that was compatible with the <a href=\"https://wordpress.org/plugins/sportspress/\">SportsPress</a> plugin, he installed the <a href=\"http://www.getmotopress.com/plugins/content-editor/\">MotoPress Content Editor</a>. MotoPress Content Editor is a front-end page builder that enables users to visually construct pages. The front page of the site was a long vertical column filled with information that mimicked blog posts.</p>\n<p>Because he didn&#8217;t understand how WordPress works, he forgot to configure the site to display the latest posts instead of using a front page. What he ended up doing is recreating the blog post layout on the static front page using the MotoPress Content Editor. He also added a lot of page builder elements such as YouTube videos to the page which was a contributing factor to the site&#8217;s poor loading times.</p>\n<p>Page builders are a tool that can make building sites and pages more convenient, but in the wrong hands, they can help users <a href=\"https://wptavern.com/wordpress-visual-page-and-website-builders-make-it-easy-to-create-ugly-sites\">ruin their sites</a>. I replaced the video elements with a text widget that displays the latest video from a YouTube channel. Since he was mimicking the blog post layout on a static page, I configured the site to display the latest blog posts first.</p>\n<p>Once I fixed these issues, I removed the page builder and explained to my friend why it was unnecessary. He was recreating WordPress functionality and doing unnecessary work without realizing it.</p>\n<p>This experience makes me wonder how many other newer WordPress users end up in a similar situation. They don&#8217;t know what WordPress is capable of out-of-the-box and they end up installing a myriad of plugins with descriptions that sound similar to the features they want. I spent about a week undoing all of the work my friend did in three. Had I not stepped in, the site would likely not scale and its performance would decrease further.</p>\n<h2>Getting New Users Started on the Right Track</h2>\n<p>In early 2015, a community initiative dubbed <a href=\"https://make.wordpress.org/core/2015/02/05/4-2-community-initiative-nux-working-group/\">NUX Working Group</a> was created to brainstorm ideas on how to improve the new user experiences throughout the WordPress admin. While the group initially had a head of steam, it lost a lot of momentum last year. I&#8217;d like to see it re-emerge and work in concert with the <a href=\"https://wptavern.com/matt-mullenweg-announces-tech-and-design-leads-for-new-focus-based-development-cycle\">focus-based approach</a> to developing WordPress this year.</p>\n<p>How can WordPress explain to new users what its capable of without drowning them in technical information? Is it feasible to create something that caters to the majority without explaining every feature in detail? <a href=\"https://codex.wordpress.org/Version_3.3\">Admin Pointers</a> were introduced in WordPress 3.3 and while they&#8217;re typically used to introduce new features in a release, they don&#8217;t act as a guided tour to what WordPress can do.</p>\n<p>Education is likely a key component to improving the new user experience. WordPress.com has a <a href=\"https://learn.wordpress.com/get-started/\">12-step beginner&#8217;s guide</a> that walks people through the process of configuring and customizing their sites. For self-hosted WordPress users, there&#8217;s a <a href=\"https://codex.wordpress.org/New_To_WordPress_-_Where_to_Start\">New to WordPress &#8211; Where to Start guide</a> that covers what WordPress is, choosing a host, and considerations to keep in mind. However, much of the information is technical in nature.</p>\n<p>If you&#8217;re a consultant or coach who works with people new to WordPress, how do you handle the educational part of your projects? What are the most common roadblocks that they encounter? Do you have a custom-made getting started guide or do you forward them to a site with video tutorials like <a href=\"https://wordpress.tv/\">WordPress.TV</a> or <a href=\"https://www.wp101.com/\">WP101</a>?</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 06 Jan 2017 19:19:33 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:20;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:47:\"WPTavern: Incubator WordCamp Denpasar a Success\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=64903\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:58:\"https://wptavern.com/incubator-wordcamp-denpasar-a-success\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4625:\"<p><a href=\"https://i0.wp.com/wptavern.com/wp-content/uploads/2017/01/taylor-lovett.jpg?ssl=1\"><img src=\"https://i0.wp.com/wptavern.com/wp-content/uploads/2017/01/taylor-lovett.jpg?resize=150%2C150&ssl=1\" alt=\"\" class=\"alignright size-thumbnail wp-image-64907\" /></a>This post was contributed by guest author Taylor Lovett. Lovett is based in the Washington DC area, is the Director of Web Engineering at <a href=\"https://10up.com\" target=\"_blank\">10up</a>, creator of ElasticPress, and general open source enthusiast.<br />\n&nbsp;</p>\n<hr />\n<p>In February 2016, the <a href=\"http://wordpressfoundation.org/\" target=\"_blank\">WordPress Foundation</a> announced the <a href=\"https://wordpress.org/news/2016/02/experiment-wordcamp-incubator/\" target=\"_blank\">WordCamp incubator program</a>, focused on spreading WordPress and open source values to remote areas of the world through extra hands-on support to first time WordCamps. WordCamp Denpasar, which took place in Bali’s capital city, is the first of three camps to be supported as a part of the program — other WordCamps include Harare and Medellín. As Director of Web Engineering at <a href=\"https://10up.com\" target=\"_blank\">10up</a>, I was sent to attend and speak at the inaugural event. Our company values open source projects and the WordPress community, so we’re proud to support emerging communities by attending events like this.</p>\n<p>The incubator program supports WordCamps by providing them with an experienced organizer. In Denpasar’s case, Rocio Valdivia, a Community Wrangler for Automattic, was the WordCamp Incubator sponsored organizer. According to Ivan Kristianto, the lead organizer for WordCamp Denpasar, “Rocio was a hands-on consultant provided by the WordPress Foundation to help incubate the camp. She helped [us] in budgeting, managing the organizers, submission timelines, and more”.</p>\n<p>WordCamp Denpasar attracted 180 attendees, twice the initial goal. Many attendees came from other parts of Indonesia to attend the Camp, which bubbled with an aura of excitement as Indonesia has not had a WordCamp in over three years. The venue, the <a href=\"http://www.sofitel.com/gb/hotel-5551-the-royal-beach-seminyak-bali-mgallery-collection/index.shtml\" target=\"_blank\">Royal Beach Seminyak Hotel</a>, was of ample size and served the crowd well. There was a single session track, mixed with user, business, and developer topics. Lunch included a nice buffet featuring local Balinese cuisine. Overall, the WordCamp attendance, venue, and amenities were quite impressive.</p>\n<p>The speaker lineup was diverse, with speakers from Indonesia, Australia, Europe, Japan, and the United States. Attendees were extremely enthusiastic throughout the sessions and actively engaged in questions. I was last to speak, presenting on <a href=\"https://10up.com/blog/2016/twenty-sixteen-react-nodeifywp/\" target=\"_blank\">NodeifyWP and Twenty Sixteen React</a>. WordCamp Denpasar was the debut presentation of our new isomorphic JavaScript framework. The crowd was extremely excited to hear my presentation and attendees were grateful 10up choose Bali as a first occasion to show the framework. After my talk, I received more questions than could fit in the allotted time slot.</p>\n<p>In the weeks after the Camp, I talked with Rocio about the overall success of the event and Incubator program as a whole. Rocio believed the WordCamp went extremely well. She cited some key events that followed the inaugural camp:</p>\n<ol>\n<li>The local Indonesian meetup group has grown to more than 50 new members across different groups.</li>\n<li>The existing WP Meetup Bekasi group in Indonesia has applied to join the Meetup chapter program.</li>\n<li>The non-active WP Meetup of Jakarta has now two members interested in re-activating the group and have applied to join the chapter program. They are also interested in organizing WordCamp Jakarta 2017.</li>\n<li>The WordPress Foundation has received an application for organizing WordCamp Ubud in 2017 (one hour from Denpasar) which is in pre-planning now.</li>\n<li>A WP Indonesia Slack channel is being created to connect the whole community in the country.</li>\n</ol>\n<p>Clearly, WordCamp Denpasar has had a positive effect on the Indonesian WordPress community. As more areas of the world getting involved contributing to and using WordPress, the project’s internationalization and diversity improves. If Denpasar is any indication, expanding the incubator program to more areas of the world will have long-lasting benefits within the entire WordPress community.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 06 Jan 2017 18:59:26 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:21;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:94:\"WPTavern: Matt Mullenweg Announces Tech and Design Leads for New Focus-Based Development Cycle\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=64862\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:105:\"https://wptavern.com/matt-mullenweg-announces-tech-and-design-leads-for-new-focus-based-development-cycle\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:7237:\"<a href=\"https://i2.wp.com/wptavern.com/wp-content/uploads/2017/01/sharpened-pencil.jpg?ssl=1\"><img src=\"https://i2.wp.com/wptavern.com/wp-content/uploads/2017/01/sharpened-pencil.jpg?resize=960%2C542&ssl=1\" alt=\"\" class=\"size-full wp-image-64886\" /></a>photo credit: <a href=\"https://stocksnap.io/photo/JLXDNN5BNE\">Angelina Litvin</a>\n<p>WordPress core development is kicking off in 2017 with the new focus-based development process that Matt Mullenweg announced during the <a href=\"https://wptavern.com/state-of-the-word-2016-mullenweg-pushes-calypso-as-future-of-wordpress-interface-proposes-major-changes-to-release-cycle\" target=\"_blank\">2016 State of the Word</a>. The new approach to releases shifts WordPress from the familiar time-based release cycle to one that is more project-based. The idea is that design and user testing will lead the way and upcoming releases will ship when significant user-facing improvements are ready.</p>\n<p>Mullenweg, who will serve as the overall product lead for 2017, <a href=\"https://make.wordpress.org/core/2017/01/04/focus-tech-and-design-leads/\" target=\"_blank\">announced</a> tech and design leads for each of the three focus areas: the REST API, the editor, and the customizer.</p>\n<p>&#8220;For the REST API we’re going to work on getting first party wp-admin usage of the new endpoints, and hopefully replace all of the core places where we still use admin-ajax,&#8221; Mullenweg said. The REST API team nominated Ryan McCue and K.Adam White to take the lead on the objectives Mullenweg outlined, as well as infrastructure and endpoint performance, security, and improvements to authentication options and documentation.</p>\n<p>&#8220;The editor will endeavor to create a new page and post building experience that makes writing rich posts effortless, and has &#8216;blocks&#8217; to make it easy what today might take shortcodes, custom HTML, or &#8216;mystery meat&#8217; embed discovery,&#8221; Mullenweg said. Automattic employees Matias Ventura and Joen Asmussen will be taking point on the editor.</p>\n<p>The <a href=\"https://wordpress.org/plugins/shortcode-ui/\" target=\"_blank\">Shortcake UI</a> feature plugin is one attempt at giving the existing shortcodes feature a more user-friendly interface, but contributors are also exploring other ideas for simplifying the experience of adding rich content to posts. Ella Van Dorpe recently posted an idea for <a href=\"https://make.wordpress.org/core/2016/12/24/idea-uniform-resource-identifiers-as-an-alternative-to-shortcodes/\" target=\"_blank\">using uniform resource identifiers as an alternative to shortcodes</a> in certain use cases. This would work similar to <a href=\"https://codex.wordpress.org/Embeds\" target=\"_blank\">WordPress&#8217; implementation of oEmbed</a> where data is stored elsewhere and embedded in a post using a URL.</p>\n<p>Mullenweg&#8217;s proposed direction for the customizer team is to &#8220;help out the editor at first, then shift to bring those fundamental building blocks into something that could allow customization &#8216;outside of the box&#8217; of post_content, including sidebars and possibly even an entire theme.&#8221; Weston Ruter and Mel Choyce will be taking the lead on the customizer focus.</p>\n<p>Ruter and contributors have been working on a project called <a href=\"https://github.com/xwp/wp-js-widgets\" target=\"_blank\">JS Widgets</a> that uses the Customize API to power the next generation of JavaScript-widgets in core. It opens the door for managing widgets via the REST API and ties in nicely with all three focus areas.</p>\n<p>A preliminary discussion on upcoming Customizer priorities cropped up in the comments. Nick Halsey, co-maintainer of the customize component, <a href=\"https://make.wordpress.org/core/2017/01/04/focus-tech-and-design-leads/#comment-31891\" target=\"_blank\">responded</a> to the proposal of having the customizer help out the editor at first. He believes the best approach is to create the new editor within the Customize API, giving it live previews from the start.</p>\n<p>&#8220;Improving the editor within an &#8216;admin&#8217; interface that lacks live preview doesn’t address the fundamental problems with the current content editing experience and creates something that still has to be entirely rebuilt and reimagined within a live preview context eventually,&#8221; Halsey said. &#8220;If the editor is built on the Customize API first, rather than rethinking the editor and then bringing it into the live preview API, the customize and editor contributors would be able to join forces to focus on improving the content editing experience much more effectively.&#8221;</p>\n<p>It will be interesting to see what direction Mullenweg and the leads decide to take in the foundational task of architecting the new editing experience. Mullenweg made it clear in the State of the Word address that he would like to see Calypso or a similar interface replace wp-admin in the future. However, Calypso was not built using the Customize API, WordPress&#8217; own single page application admin interface that plugins and themes already widely support.</p>\n<p>After WordCamp US, I asked Mullenweg about his intentions for Calypso in relationship to WordPress core. He said the application was &#8220;designed to be in core someday,&#8221; which is one reason they selected the same license and made it open source.</p>\n<p>&#8220;My real hope is that it is something that is ready for core someday &#8211; both Calypso the interface and the concept.&#8221; Mullenweg said. &#8220;That&#8217;s why I said Calypso or something like it. There&#8217;s obviously a lot of WordPress.com stuff in Calypso that will never be in core. If we think of a wp-admin replacement, it would be replacing wp-admin with the parts that Calypso does that are the same thing, kind of more of the my sites section of it. But I do believe the future of a great wp-admin experience is JavaScript &#8211; probably React, talking to APIs, super fast, and maybe even working offline.&#8221;</p>\n<p>Automattic is actively recruiting popular plugin authors to make their plugins Calypso-aware. Demonstrating the application&#8217;s interoperability with the WordPress plugin ecosystem is a must before Calypso can be considered a promising replacement for the WordPress admin. In the meantime, the foundation for a new page and post building experience is being laid with consideration for how the customizer can improve the editor.</p>\n<p>Mullenweg responded to comments on the post indicating that feature plugins or other improvements to WordPress outside of the three focus areas would need to continue on as plugins for the time being. However, performance improvements may be included in minor releases.</p>\n<p>&#8220;What goes in a minor release will broaden a bit, which I know is something we have to approach carefully, but performance is very important and improvements will be something I will consider for being in a minor release,&#8221; Mullenweg said. Contributors are currently working on <a href=\"https://make.wordpress.org/core/tag/4-7-1/\" target=\"_blank\">WordPress 4.7.1</a>, which is planned for release on Tuesday, January 10.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 06 Jan 2017 00:00:07 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:22;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:116:\"WPTavern: Micro.blog Surpasses Kickstarter Funding Goal, Set to Launch New Social Network for Independent Microblogs\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=64805\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:126:\"https://wptavern.com/micro-blog-surpasses-kickstarter-funding-goal-set-to-launch-new-social-network-for-independent-microblogs\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:6754:\"<p>Developer <a href=\"http://www.manton.org/\" target=\"_blank\">Manton Reece</a> is on a mission to take back short form content for the open web by providing better tools for independent microblogging. Most short form content today is posted through centralized social networking sites like Facebook, Twitter, and Instagram, where posts are mixed with promoted content and users have no control of their timelines. There&#8217;s no guarantee that these social networks will be around forever, as many before them have disappeared, eclipsed by new ways to connect online.</p>\n<p>Reece set out to create <a href=\"http://micro.blog/\" target=\"_blank\">Micro.blog</a>, a timeline and publishing platform for the open web, as an alternative social network that encourages more independent writing. He <a href=\"https://www.kickstarter.com/projects/manton/indie-microblogging-owning-your-short-form-writing\" target=\"_blank\">launched a Kickstarter campaign</a> to fund the platform along with his work on a book called Indie Microblogging. The project&#8217;s $10K goal was fully funded on the first day and has passed $22,000 on the second day of the campaign.</p>\n<p>Micro.blog has a timeline experience similar to Twitter with replies and favorites, but the main difference is that it is based on RSS, pulling posts from independent sites. Those who don&#8217;t have their own websites will be able to opt for a hosted microblog and map a custom domain. Users with hosted microblogs can post via a web interface that includes a Markdown editor or use the service&#8217;s iPhone app.</p>\n<p><a href=\"https://i0.wp.com/wptavern.com/wp-content/uploads/2017/01/micro-blog-1.png?ssl=1\"><img src=\"https://i0.wp.com/wptavern.com/wp-content/uploads/2017/01/micro-blog-1.png?resize=1025%2C590&ssl=1\" alt=\"\" class=\"aligncenter size-full wp-image-64853\" /></a></p>\n<h3>Micro.blog Will Integrate with WordPress</h3>\n<p>Reece, who self-hosts <a href=\"http://manton.org/\" target=\"_blank\">his own blog</a> on WordPress, will be launching Micro.blog with full integration for WordPress users, making it easy to cross post between the two platforms. I asked him about the workflow for publishing from WordPress and he said his Indie Microblogging book will contain a section specifically on WordPress.</p>\n<p>&#8220;After you&#8217;ve told Micro.blog about your WordPress RSS feed, you can continue to post to your blog as you normally would, although I&#8217;ll have some tips for taking the best advantage of it,&#8221; Reece said. &#8220;There&#8217;s also a native iPhone app for Micro.blog that supports direct posting to WordPress. I&#8217;ve found that it really improves the user experience to have a single app with a timeline experience, replies, favorites, as well as easy posting directly to your own site. But there&#8217;s no requirement to use any specific app.&#8221;</p>\n<p>Reece said he plans to implement a very strict, reverse-chronological timeline for content that users are following. He also does not plan to introduce any algorithms or advertising. Basic accounts will be free and the plan is to sustain the platform with revenue from a paid plan that includes extra features like microblog hosting.</p>\n<p>&#8220;One thing that is very important to me is not letting someone you don&#8217;t follow interrupt your timeline with harassment or other replies that aren&#8217;t appropriate,&#8221; Reece said. &#8220;I&#8217;m working on some features around this that I hope will help avoid similar issues that Twitter has faced in its community, for example. So if there are any custom algorithms or curation it will be around trying to deal with abuse before it happens.&#8221;</p>\n<p>The Micro.blog platform is currently built using Ruby, Sinatra, Ember.js, MySQL, and Redis. Reece said he is in the process of rewriting some of the app with a more traditional Ruby on Rails setup.</p>\n<p>&#8220;Ember didn&#8217;t end up being a great fit for the design,&#8221; Reece said. &#8220;There is also a portion of the microblog publishing engine built on Jekyll, so that themes and data files can be more portable.&#8221;</p>\n<p>Micro.blog isn&#8217;t entirely distributed where users host their own &#8220;pods&#8221; like Diaspora, but Reece said he is open to making it more decentralized in the future.</p>\n<p>&#8220;It&#8217;s a good goal to eventually move to something even more distributed, but it introduces a lot of complexity, which has prevented most of those kind of solutions from taking off,&#8221; Reece said. &#8220;I hope that Micro.blog is a step in the right direction, encouraging people to write more on their own site even for short microblog posts, instead of just Twitter and Facebook, with more open formats and APIs. It&#8217;s more achievable if we can build off of tools like WordPress instead of starting over.&#8221;</p>\n<p>Reece said he thinks WordPress.com (Automattic) is one of only a couple web publishing companies he believes could last 100 years. &#8220;Only 2 companies keep coming to mind: WordPress.com and GitHub,&#8221; he said in a <a href=\"http://mirror.manton.org/2015/09/complete-mirror-of-this-blog.html\" target=\"_blank\">post about mirroring his blog to GitHub</a>. &#8220;I believe both will last for decades, maybe even 100 years, and both embrace the open web in a way that most other centralized web sites do not.&#8221;</p>\n<p>During his 14 years of blogging and 10 years of using Twitter, Reece became an advocate for the open web. He said he used to be excited about Twitter and built apps for the platform but grew disillusioned at their approach to locking down the API.</p>\n<p>&#8220;We&#8217;ve been so focused on writing on Twitter and Facebook that we&#8217;ve gotten away from more independent publishing that makes blogs and the open web great,&#8221; Reece said. &#8220;I think microblogging has a place on the open web, and that posting to a blog and reading posts from friends can have just as great a user experience as using a traditional social network. I&#8217;ve already heard from many people who have been inspired recently to blog again, which is really the main goal of Micro.blog.&#8221;</p>\n<p>The <a href=\"https://www.kickstarter.com/projects/manton/indie-microblogging-owning-your-short-form-writing/community\" target=\"_blank\">Micro.blog Kickstarter campaign</a> will end in 27 days. Reece said he was surprised the project was funded so quickly. He plans to work hard over the next month to roll out Micro.blog to everyone.</p>\n<p>&#8220;I can&#8217;t wait to see how users use the service, how the book can help WordPress users expand their existing blogs, and what developers want to build on the APIs going forward,&#8221; Reece said.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 04 Jan 2017 23:14:03 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:23;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:26:\"HeroPress: We Are The Same\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://heropress.com/?post_type=heropress-essays&p=1556\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:45:\"https://heropress.com/essays/we-are-the-same/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:9064:\"<img width=\"960\" height=\"480\" src=\"http://20094-presscdn.pagely.netdna-cdn.com/wp-content/uploads/2017/01/010417-1024x512.jpg\" class=\"attachment-large size-large wp-post-image\" alt=\"Pull Quote: To every woman... we are the same. I am you and you are me.\" /><p><em>Topher asked me to write an article for HeroPress as we sat together in an alcove in the Philly Convention Center. I was in a vulnerable space. My lightning talk at WordCamp US had concluded, and I was settling into the experience of being at another WordCamp. I thought about the life experiences that brought me to my second presentation a year later, and I started to cry. Below is why.</em></p>\n<p>One of my earliest memories is attending my mother&#8217;s graduate school graduation ceremony. It was a huge achievement. I wore a pink frilly dress with afro puffs to her graduation ceremony. I am sure I was gripping someone&#8217;s leg and hiding behind them. Behind my mother, my aunt or maybe my father. I was painfully awkward and shy. Which didn&#8217;t make any sense because my family was constantly telling me, &#8216;Be quiet&#8217;. That could have been their anthem for me. Children were meant to be seen, not heard.</p>\n<blockquote><p>I think of that young Sierra Leonean American girl I was, I think back to that day, and wonder what became of her.</p></blockquote>\n<p>She grew taller, much taller, transitioned from pink dresses to a pink bedroom, and, some say, is poised. But she is still painfully awkward. You wouldn&#8217;t know it, but you can catch her at times sitting quietly at an event achingly wishing she were alone and didn’t have to perform.</p>\n<p>I project confidence because I was drafted into an oratory competition in middle school. Something about my voice caught the attention of my middle school teacher Mrs. McNeil. She entered me into one. I don&#8217;t recall what I read or the outcome. I only remember my mom driving me to my competition and her, my sister and I pulling up to a very crowded parking lot. Everything gets fuzzy after we arrived.</p>\n<p>In high school, I didn&#8217;t need to be drafted into public speaking. I had strong ideals and opinions, and when it came to debate competitions I didn&#8217;t need to fit in and be cool. All I had to do was win. I debated as a Junior Statesmen, entered the Essex County Mock Trial competition, and the High School Moot Court Tournament at Princeton University. During 10th or 11th grade I got commendations for my role as a mother whose son died due to someone&#8217;s negligence at school. I argued with the other team’s attorneys. I was distraught. I channeled my inner mother. The judge gave our Mock Trial team extra points because I made the case believable. In 11th grade my partner and I came second place in the Moot Court competition at Princeton.</p>\n<p>I live in Maplewood, New Jersey. It is a town that actively engages its children. Our administration and teachers educate us to be competitive academically and in our extracurricular activities, and to actively seek out opportunities for service.</p>\n<blockquote><p>Teachers tell us we can be great &#8211; and expectations are that we will be great.</p></blockquote>\n<p>It is ingrained in us that to whom much is given much is expected. I do the best I can to embody what is expected of me.</p>\n<p>Truthfully, as an African girl, it was wonderful to be educated like this. At home my parents, aunts and uncles expect nothing less. Outside of home and my classes and clubs, I received mixed messages about who I was and what I could achieve. I was one of a handful of Africans in a diverse community. I didn&#8217;t look African or sound African I was told growing up. And I was surprised as a child of how differently I was treated by many of the same color other than my best friend and her family in elementary school. It was fascinating. On one occasion at school I achingly experienced different treatment. A college counselor lost interest in helping me with financial aid when it came up in conversation that I was African. After that conversation she was too busy to meet with me. I went to the head of guidance instead who was fabulous.</p>\n<blockquote><p>Occasions like this make me acutely proud of where my family comes from and the sacrifices my parents made 30 plus years ago when they immigrated here.</p></blockquote>\n<p>I see in them that resilience is a must and that success is accessible through motivation, hard work, focus, education and self-improvement.</p>\n<p>As a child, I hurt at the barriers some put up when I told them I am African. And I still do. At times, we are misunderstood and misrepresented. And it doesn&#8217;t make me any less proud of my Sierra Leonean heritage.</p>\n<p>Three weeks ago, I had dinner with someone I met years ago. I mentioned something related to my heritage. She stopped for a second. She said she was surprised to hear I am African. Her enthusiasm towards me immediately drained. I wasn&#8217;t shocked. I pushed away the feeling of disappointment I feel in these occasions. I acknowledged the difference internally and it didn&#8217;t stop me from enjoying her company. It&#8217;s a situation I&#8217;ve found myself in many, many times.</p>\n<p>I was told I could be great as a child growing up in Maplewood. I let this propel me forward through each obstacle in my way, and I let this make me stand tall as I take on each daunting task before me. I took this with me to every college class and graduate class I have taken even when overpowered by feelings of inadequacy. I have been to events at places where very few people will ever have the chance to go. There are organizations I have worked for that have a competitive selection process. There are certificates I have earned that make me wonder how I gathered the strength to make it through. And there are presentations like the ones I gave at WordCamp US in 2015 and 2016 where I fought through feelings of inadequacy to stand on stage and speak before hundreds of people in the tech industry.</p>\n<blockquote><p>At these times, I think of the little Sierra Leonean American girl in the pink frilly dress with afro puffs, and wonder how she could achieve each one of these accomplishments.</p></blockquote>\n<p>I wonder how she became so warmly embraced by the WordPress community, invited to plan WordCamp NYC at the United Nations in 2016, and invited to be a co-organizer of Meetups in NYC. It reflects how inclusive our community is.</p>\n<p>I think of my gender, my color, and my heritage.</p>\n<p>To every woman &#8211; we are the same. And, even if we glance at each other and look away, I am you and you are me. We can’t let anyone convince us otherwise.</p>\n<blockquote><p>I think of the African girl on the continent who doesn’t have the choices and resources I have. I cry for her, and I cry for me.</p></blockquote>\n<p>I cry because I may never meet her, never look deeply into her eyes, never tell her that she will be great, give her the resources she needs to fully realize her dreams and give her the space to be embraced by the WordPress community. Make no mistake in this digital age that this little girl is aware of what she doesn’t have, and that she needs us to propel her forward.</p>\n<div class=\"rtsocial-container rtsocial-container-align-right rtsocial-horizontal\"><div class=\"rtsocial-twitter-horizontal\"><div class=\"rtsocial-twitter-horizontal-button\"><a title=\"Tweet: We Are The Same\" class=\"rtsocial-twitter-button\" href=\"https://twitter.com/share?text=We%20Are%20The%20Same&via=heropress&url=https%3A%2F%2Fheropress.com%2Fessays%2Fwe-are-the-same%2F\" rel=\"nofollow\" target=\"_blank\"></a></div></div><div class=\"rtsocial-fb-horizontal fb-light\"><div class=\"rtsocial-fb-horizontal-button\"><a title=\"Like: We Are The Same\" class=\"rtsocial-fb-button rtsocial-fb-like-light\" href=\"https://www.facebook.com/sharer.php?u=https%3A%2F%2Fheropress.com%2Fessays%2Fwe-are-the-same%2F\" rel=\"nofollow\" target=\"_blank\"></a></div></div><div class=\"rtsocial-linkedin-horizontal\"><div class=\"rtsocial-linkedin-horizontal-button\"><a class=\"rtsocial-linkedin-button\" href=\"https://www.linkedin.com/shareArticle?mini=true&url=https%3A%2F%2Fheropress.com%2Fessays%2Fwe-are-the-same%2F&title=We+Are+The+Same\" rel=\"nofollow\" target=\"_blank\" title=\"Share: We Are The Same\"></a></div></div><div class=\"rtsocial-pinterest-horizontal\"><div class=\"rtsocial-pinterest-horizontal-button\"><a class=\"rtsocial-pinterest-button\" href=\"https://pinterest.com/pin/create/button/?url=https://heropress.com/essays/we-are-the-same/&media=https://heropress.com/wp-content/uploads/2017/01/010417-150x150.jpg&description=We Are The Same\" rel=\"nofollow\" target=\"_blank\" title=\"Pin: We Are The Same\"></a></div></div><a rel=\"nofollow\" class=\"perma-link\" href=\"https://heropress.com/essays/we-are-the-same/\" title=\"We Are The Same\"></a></div><p>The post <a rel=\"nofollow\" href=\"https://heropress.com/essays/we-are-the-same/\">We Are The Same</a> appeared first on <a rel=\"nofollow\" href=\"https://heropress.com\">HeroPress</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 04 Jan 2017 12:00:25 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Winstina Hughes\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:24;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:68:\"WPTavern: W3Techs Ranks WordPress as the Fastest Growing CMS of 2016\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=64826\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:79:\"https://wptavern.com/w3techs-ranks-wordpress-as-the-fastest-growing-cms-of-2016\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3019:\"<a href=\"https://i2.wp.com/wptavern.com/wp-content/uploads/2016/05/blogging.jpg?ssl=1\"><img src=\"https://i2.wp.com/wptavern.com/wp-content/uploads/2016/05/blogging.jpg?resize=960%2C521&ssl=1\" alt=\"\" class=\"size-full wp-image-54799\" /></a>photo credit: <a href=\"https://stocksnap.io/photo/3ZHG0XOIT6\">Luis Llerena</a>\n<p>W3Techs published its <a href=\"https://w3techs.com/blog/entry/web_technologies_of_the_year_2016\" target=\"_blank\">Web Technologies of 2016</a> report today, compiling technologies that saw the largest increase in usage last year. The survey pulls data from the top 10 million sites (according to Alexa rankings) and compares the number of sites for each technology by measuring the difference from January 1, 2016 to January 1, 2017.</p>\n<p>W3Techs ranks WordPress as the fastest growing content management system with 58.5% market share. Shopify and Squarespace demonstrated the second and third largest increases in usage. Squarespace is a newcomer to the top three. In <a href=\"https://w3techs.com/blog/entry/web_technologies_of_the_year_2015\" target=\"_blank\">2015</a> the second and third place winners were Drupal and Shopify. WordPress has dominated the top spot every year since 2010.</p>\n<p>CMS usage on the whole saw a 3.3% increase. Of the top 15 CMS&#8217;s only six demonstrated growth, including the aforementioned top three, as well as Joomla, Drupal, and Bitrix, which showed nominal 0.1% increases in market share by the end of 2016. Blogger is on the decline, and the remaining CMS&#8217;s showed no increase or decrease.</p>\n<p><a href=\"https://i1.wp.com/wptavern.com/wp-content/uploads/2017/01/cms-usage-2016.png?ssl=1\"><img src=\"https://i1.wp.com/wptavern.com/wp-content/uploads/2017/01/cms-usage-2016.png?resize=1025%2C444&ssl=1\" alt=\"\" class=\"aligncenter size-full wp-image-64832\" /></a></p>\n<p>PHP regained its top ranking among server-side programming languages as the fastest growing in 2016, a title which it temporarily lost to Java in 2015. W3Techs estimates PHP to be used by 82.4% of all websites for which it can detect a server-side programming language.</p>\n<p>Another interesting result of the survey is that &#8220;WordPress Jetpack,&#8221; the stats module in Jetpack, ranks third among the fastest growing traffic analysis tools, trailing Google Analytics and Yandex.Metrika. Jetpack Stats has been on a slow upward trend, rising from 1.6% in 2011 to 4.5% in 2017. The top fastest growing players in this category have repeated several years in a row.</p>\n<p>It&#8217;s important to note that many Jetpack stats users also use Google Analytics, but these numbers also give a rough idea of Jetpack usage increase, since it is one of the most popular modules in the plugin. According to W3Techs, <a href=\"https://w3techs.com/technologies/details/ta-wordpressstats/all/all\" target=\"_blank\">Jetpack Stats</a> is used by 6.9% of sites for which it can detect a traffic analysis tool, which it estimates as 4.5% of all websites.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 03 Jan 2017 23:03:25 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:25;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:52:\"WPTavern: WP-CLI Gets Official WordPress.org Support\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=64789\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:63:\"https://wptavern.com/wp-cli-gets-official-wordpress-org-support\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:5086:\"<p>The WP-CLI open source project will be coming under the WordPress.org umbrella in 2017. After recent talks with Daniel Bachhuber, WP-CLI&#8217;s official maintainer, Matt Mullenweg <a href=\"https://make.wordpress.org/core/2016/12/28/supporting-the-future-of-wp-cli/\" target=\"_blank\">announced WordPress&#8217; support for the project</a>, calling it &#8220;one of the highest impact developments for WP in many years.&#8221; The wp-cli.org website will soon be migrated to WordPress.org and a <a href=\"https://make.wordpress.org/cli/\" target=\"_blank\">CLI Make site</a> with its own P2 is now available to contributors.</p>\n<p>&#8220;As we head into 2017, I wanted to make sure that its future is certain for everyone who builds on it, and that the major contributors to the project, chiefly Daniel Bachhuber, are able to work on it even more in the coming year,&#8221; Mullenweg said. Now that the project is part of WordPress.org, Mullenweg said he will be leading a coalition of companies to &#8220;solidify their financial support&#8221; of <a href=\"http://wp-cli.org/blog/the-big-question.html\" target=\"_blank\">the existing fundraising effort</a> that Bachhuber launched in mid-December 2016.</p>\n<p>The logistics of the new funding model haven&#8217;t yet been completely ironed out, but Bachhuber says <a href=\"https://runcommand.io/\" target=\"_blank\">runcommand</a> will not be shutting down.</p>\n<p>&#8220;Runcommand&#8217;s sole focus will be to hire people to work on WP-CLI,&#8221; he said. &#8220;This hybrid approach better ensures WP-CLI&#8217;s long-term future (e.g. the project is under the wing of the WordPress project), while also being a creative way for paying for dedicated resources to it.&#8221;</p>\n<p>Bachhuber explored different funding models for WP CLI throughout 2016 without much success. When discussions about making it an official WordPress core project first began, he was leaning towards keeping WP-CLI operating as an independent project. The new hybrid approach gives companies the opportunity to financially support an official WordPress project via runcommand, where Bachhuber hopes to hire additional maintainers on a part-time basis.</p>\n<p>&#8220;I&#8217;ve thought a lot about funding open source over the last year,&#8221; Bachhuber said. &#8220;In the context of WP-CLI, I came to the conclusion that I didn&#8217;t have confidence in WP-CLI being a completely independent project + financially sustainable business.&#8221;</p>\n<p>Bachhuber said he feels &#8220;reasonably confident&#8221; about the future of the project after recent developments and hopes to have funding for a few part-time maintainers.</p>\n<p>&#8220;I think part-time is key because each of us needs to be working / solving problems in the real-world, and then taking those solutions back to the project,&#8221; Bachhuber said. Although many open source projects operate without paying people for contributions, he believes there is an important distinction between maintainers and contributors.</p>\n<p>&#8220;Contributors act in a voluntary manner (e.g. contributing code when they have a couple hours free),&#8221; Bachhuber said. &#8220;Maintainers take responsibility for the project, showing up every day, and doing most of the unglamorous work. I think maintainership is an important aspect of a healthy open source project. Everyone has an example of an open source project they use that&#8217;s no longer maintained and how painful it is to be dependent on it.&#8221;</p>\n<p>Responses to the news of WP-CLI gaining official WordPress.org support were overwhelmingly positive, as the tool is critical to the WordPress developer community. The decision to have WP-CLI operate under WordPress.org&#8217;s umbrella makes it better positioned to drive the financial support needed to sustain the ongoing burden of maintainership.</p>\n<p>Bachhuber said the current fundraising effort, which is <a href=\"https://wptavern.com/wp-cli-project-launches-patron-support-model-to-fund-ongoing-development\" target=\"_blank\">based on a patron support model</a>, is approximately 1/5 of the way to his funding goal. He is still waiting to hear from a number of large players but the funding drive will remain open indefinitely for now. Bachhuber said they will re-evaluate once they reach the goal.</p>\n<p>&#8220;I consider this the best possible outcome of my efforts trying to identify sustainability for the project over the last year,&#8221; Bachhuber said in the <a href=\"https://make.wordpress.org/cli/2017/01/03/lets-do-this/\" target=\"_blank\">first post</a> on the Make WordPress CLI site. &#8220;The decision to make WP-CLI an official WordPress project also means there’s a clear path forward for me to invest more of my own time into the <a href=\"http://wp-cli.org/docs/roadmap/\" target=\"_blank\">WP-CLI roadmap</a>. Concurrent with the transition process over the next couple of months, I want to move forward the conversation of how we realize a future where WP-CLI is the fastest way to do anything with WordPress.&#8221;</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 03 Jan 2017 06:50:32 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:26;a:6:{s:4:\"data\";s:11:\"\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"HeroPress: Help a HeroPress friend\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://heropress.com/?p=1553\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:44:\"https://heropress.com/help-heropress-friend/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2334:\"<p>Hey folks, HeroPress contributor Michael Beil is fighting for his life right now. Michael&#8217;s a personal friend, and a tremendous person. There&#8217;s an <a href=\"https://www.plumfund.com/financial-hardship/michael-john-beil\">online donation form</a> to help with medical bills and life in general. If you can, please help out.</p>\n<p><a href=\"https://heropress.com/essays/life-without-limits/\">You can read Michael&#8217;s HeroPress essay here</a>.</p>\n<div class=\"rtsocial-container rtsocial-container-align-right rtsocial-horizontal\"><div class=\"rtsocial-twitter-horizontal\"><div class=\"rtsocial-twitter-horizontal-button\"><a title=\"Tweet: Help a HeroPress friend\" class=\"rtsocial-twitter-button\" href=\"https://twitter.com/share?text=Help%20a%20HeroPress%20friend&via=heropress&url=https%3A%2F%2Fheropress.com%2Fhelp-heropress-friend%2F\" rel=\"nofollow\" target=\"_blank\"></a></div></div><div class=\"rtsocial-fb-horizontal fb-light\"><div class=\"rtsocial-fb-horizontal-button\"><a title=\"Like: Help a HeroPress friend\" class=\"rtsocial-fb-button rtsocial-fb-like-light\" href=\"https://www.facebook.com/sharer.php?u=https%3A%2F%2Fheropress.com%2Fhelp-heropress-friend%2F\" rel=\"nofollow\" target=\"_blank\"></a></div></div><div class=\"rtsocial-linkedin-horizontal\"><div class=\"rtsocial-linkedin-horizontal-button\"><a class=\"rtsocial-linkedin-button\" href=\"https://www.linkedin.com/shareArticle?mini=true&url=https%3A%2F%2Fheropress.com%2Fhelp-heropress-friend%2F&title=Help+a+HeroPress+friend\" rel=\"nofollow\" target=\"_blank\" title=\"Share: Help a HeroPress friend\"></a></div></div><div class=\"rtsocial-pinterest-horizontal\"><div class=\"rtsocial-pinterest-horizontal-button\"><a class=\"rtsocial-pinterest-button\" href=\"https://pinterest.com/pin/create/button/?url=https://heropress.com/help-heropress-friend/&media=http://heropress.com/wp-content/plugins/rtsocial/images/default-pinterest.png&description=Help a HeroPress friend\" rel=\"nofollow\" target=\"_blank\" title=\"Pin: Help a HeroPress friend\"></a></div></div><a rel=\"nofollow\" class=\"perma-link\" href=\"https://heropress.com/help-heropress-friend/\" title=\"Help a HeroPress friend\"></a></div><p>The post <a rel=\"nofollow\" href=\"https://heropress.com/help-heropress-friend/\">Help a HeroPress friend</a> appeared first on <a rel=\"nofollow\" href=\"https://heropress.com\">HeroPress</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 31 Dec 2016 01:20:14 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:27;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:61:\"WPTavern: WPWeekly Episode 258 – 2016 Year in Review Part 1\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:58:\"https://wptavern.com?p=64794&preview=true&preview_id=64794\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:68:\"https://wptavern.com/wpweekly-episode-258-2016-year-in-review-part-1\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1078:\"<p>In this episode of WordPress Weekly, <a href=\"http://marcuscouch.com/\">Marcus Couch</a> and I recap the news and headlines of the first half of 2016. Part two will be recorded on January 4th, 2017, where we&#8217;ll look back at the headlines during the second half of 2016, give our predictions for 2017, and share what we&#8217;re looking forward to in the new year.</p>\n<h2>WPWeekly Meta:</h2>\n<p><strong>Next Episode:</strong> Wednesday, January 4th 3:00 P.M. Eastern</p>\n<p><strong>Subscribe To WPWeekly Via Itunes: </strong><a href=\"https://itunes.apple.com/us/podcast/wordpress-weekly/id694849738\" target=\"_blank\">Click here to subscribe</a></p>\n<p><strong>Subscribe To WPWeekly Via RSS: </strong><a href=\"https://wptavern.com/feed/podcast\" target=\"_blank\">Click here to subscribe</a></p>\n<p><strong>Subscribe To WPWeekly Via Stitcher Radio: </strong><a href=\"http://www.stitcher.com/podcast/wordpress-weekly-podcast?refid=stpr\" target=\"_blank\">Click here to subscribe</a></p>\n<p><strong>Listen To Episode #258:</strong><br />\n</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 29 Dec 2016 21:45:58 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:28;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:79:\"Post Status: What we want from WordPress in 2017, live from Post Status Publish\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"https://poststatus.com/?p=31717\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:57:\"https://poststatus.com/post-status-draft-live-at-publish/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1751:\"<p>After Post Status Publish&#8217;s main talks concluded, Joe Hoyle and I recorded the podcast during the reception. It was a laid back format where we discuss the future of WordPress, including our own wishlist features, and then we spent the majority of the hour taking questions from the audience.</p>\n<p>We recorded this prior to the announcement of the <a href=\"https://poststatus.com/matt-mullenweg-state-word-2016/\">new development schedule</a> and changes to major releases, but most of our conversation remains relevant, as many of our wishlist items are within the three release focus areas that have been chosen.</p>\n<p>You can listen to just the audio, also on our podcast, which you can find <a href=\"https://itunes.apple.com/us/podcast/post-status-draft-wordpress/id976403008\">on iTunes</a>, <a href=\"https://play.google.com/music/m/Ih5egfxskgcec4qadr3f4zfpzzm?t=Post_Status__Draft_WordPress_Podcast\">Google Play</a>, <a href=\"http://www.stitcher.com/podcast/krogsgard/post-status-draft-wordpress-podcast\">Stitcher</a>, and <a href=\"http://simplecast.fm/podcasts/1061/rss\">via RSS</a> for your favorite podcatcher.</p>\n<!--[if lt IE 9]><script>document.createElement(\'audio\');</script><![endif]-->\n<a href=\"https://audio.simplecast.com/56018.mp3\">https://audio.simplecast.com/56018.mp3</a>\n<p><a href=\"https://audio.simplecast.com/56018.mp3\">Direct Download</a></p>\n<p>Or just watch the <a href=\"https://youtu.be/Xoteb83jmD8\">video on YouTube</a>, or below for the full experience. And don&#8217;t forget to subscribe to <a href=\"https://www.youtube.com/c/PostStatus\">my new channel on YouTube</a>.</p>\n<p></p>\n<p>The rest of the videos from <a href=\"https://poststatus.com/publish\">Publish</a> are available to Post Status members.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 29 Dec 2016 15:21:13 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Brian Krogsgard\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:29;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"HeroPress: Over The Atlantic\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://heropress.com/?post_type=heropress-essays&p=1545\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:47:\"https://heropress.com/essays/over-the-atlantic/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:6054:\"<img width=\"960\" height=\"480\" src=\"http://20094-presscdn.pagely.netdna-cdn.com/wp-content/uploads/2016/12/122816-1024x512.jpg\" class=\"attachment-large size-large wp-post-image\" alt=\"Pull Quote: I\'ve come to realise the WordPress community doesn\'t tolerate bad actors.\" /><p>I’m on a plane. They’ve just served lunch and I realise I’m stuck. There isn’t enough room to slip out for a bathroom break without tipping my meal and the trolley blocks the aisle.</p>\n<p>I cough and notice I’m tense, what’s going on? I enjoy flying, why should today be any different? Is it that I might be sick? Maybe it’s shovelling clothes off of the dining table into an open suitcase and rushing for a taxi at 6am? Or responding to a client at 11pm then playing Rimworld till 2am knowing I’d be up at 5? Maybe it’s Mr Robot? Anyone who’s seen that show knows it isn’t exactly happy.</p>\n<p>I open my watch up and try the new breathe app. I’ve installed watch apps before but never found much use from them, but this came with the update from Apple this morning so I’ll give it a go. It holds me steady but I’m still tense.</p>\n<p>I put on some music and try to eat some food. Maybe that’s the problem? I get anxious sometimes about food, it can get me in trouble. During speaker submissions for WordCamp Europe Sophia I wrote a mini rant about sandwiches and labeling. Siobhan thought it was funny, but I should know better. It was that year I saw a talk on depression.</p>\n<p>I’ve seen several people speak about it, but right now I’m anxious, and I’m typing. After WCEU 2016 I promised Topher I’d write an article for him, and I’ve been occupied. The last month or so, I’ve been working and not taking care of myself. I’m not sure if I&#8217;m actually sick or if this is burn out. I’ve noticed aches in my hands, it worries me.</p>\n<p>I think about what writing this will do. My WP Tavern article ranks higher than me on Facebook search.</p>\n<blockquote><p>There’s nothing like an article on anxiety popping up when a date searches your name. I don’t want to be known as the mental health guy.</p></blockquote>\n<p>But a promise is a promise. When I last did this people were supportive. They said nice things, they talked about their own feelings and gave talks. Nobody sent their pity.</p>\n<p>The food tray’s gone now, I’m not sure how I feel but I know there’s 2 Automatticians in front of me and 2 to the side. We land in Vancouver in 6 hours for the grand meet up, and I know I’ll get a big hug from several people. They’re genuine nice people, and I’ve come to realise the WordPress community doesn’t tolerate bad actors. We share what we think is important, what people need to hear.</p>\n<p>I’ve got one more episode of Mr Robot, I’ll think about those I see at WordCamps and close this app. It isn’t long before I can talk in person.</p>\n<hr />\n<p>I’m home! Despite a total lack of scrambled eggs on toast in not one, not two, but three major international airports, I’ve finally returned home. My friends dragged me jet lagged to a play entitled “The pacifists answer to the war on cancer” where a jolly sequinned cancer cell sings a song moments after a woman screams in agony. I got to sing happy birthday to my family with a room of Automatticians, climb a mountain, it was fun!</p>\n<p>I think about what I’ve written, and wish I’d been more positive.</p>\n<blockquote><p>Life can be scary but I’m surrounded by people who want to help.</p></blockquote>\n<p>Sometimes that’s family, or friends, but user groups and events help too. These people have the same problems and worries I do, and deal with them in many ways.</p>\n<p>Importantly, they’re willing to talk about their problems in front of hundreds of people, and share their solutions. I feel it’s something that isn’t mentioned often enough. Burnout and stress is rampant in our industry, and I’m glad people are stepping up to the challenge.</p>\n<p>I’m a lead organiser for a WordCamp Manchester now. That means I can’t speak at my own conference, but I’m hoping to get a good talk or two. Maybe things aren’t so terrible? Maybe next time I’ll get a window seat.</p>\n<div class=\"rtsocial-container rtsocial-container-align-right rtsocial-horizontal\"><div class=\"rtsocial-twitter-horizontal\"><div class=\"rtsocial-twitter-horizontal-button\"><a title=\"Tweet: Over The Atlantic\" class=\"rtsocial-twitter-button\" href=\"https://twitter.com/share?text=Over%20The%20Atlantic&via=heropress&url=https%3A%2F%2Fheropress.com%2Fessays%2Fover-the-atlantic%2F\" rel=\"nofollow\" target=\"_blank\"></a></div></div><div class=\"rtsocial-fb-horizontal fb-light\"><div class=\"rtsocial-fb-horizontal-button\"><a title=\"Like: Over The Atlantic\" class=\"rtsocial-fb-button rtsocial-fb-like-light\" href=\"https://www.facebook.com/sharer.php?u=https%3A%2F%2Fheropress.com%2Fessays%2Fover-the-atlantic%2F\" rel=\"nofollow\" target=\"_blank\"></a></div></div><div class=\"rtsocial-linkedin-horizontal\"><div class=\"rtsocial-linkedin-horizontal-button\"><a class=\"rtsocial-linkedin-button\" href=\"https://www.linkedin.com/shareArticle?mini=true&url=https%3A%2F%2Fheropress.com%2Fessays%2Fover-the-atlantic%2F&title=Over+The+Atlantic\" rel=\"nofollow\" target=\"_blank\" title=\"Share: Over The Atlantic\"></a></div></div><div class=\"rtsocial-pinterest-horizontal\"><div class=\"rtsocial-pinterest-horizontal-button\"><a class=\"rtsocial-pinterest-button\" href=\"https://pinterest.com/pin/create/button/?url=https://heropress.com/essays/over-the-atlantic/&media=https://heropress.com/wp-content/uploads/2016/12/122816-150x150.jpg&description=Over The Atlantic\" rel=\"nofollow\" target=\"_blank\" title=\"Pin: Over The Atlantic\"></a></div></div><a rel=\"nofollow\" class=\"perma-link\" href=\"https://heropress.com/essays/over-the-atlantic/\" title=\"Over The Atlantic\"></a></div><p>The post <a rel=\"nofollow\" href=\"https://heropress.com/essays/over-the-atlantic/\">Over The Atlantic</a> appeared first on <a rel=\"nofollow\" href=\"https://heropress.com\">HeroPress</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 28 Dec 2016 12:00:55 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Tom Nowell\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:30;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:38:\"Matt: Christmas Music: Leslie Odom Jr.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:22:\"https://ma.tt/?p=47002\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"https://ma.tt/2016/12/christmas-music-leslie-odom-jr/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:629:\"<p>I love Christmas music, and <a href=\"https://ma.tt/2013/12/christmas-jazz-music/\">most years</a> I like to recommend a Christmas music album that is a bit more jazz or has something interesting about it. This year I want to point you to Leslie Odom Jr., aka Aaron Burr in the hit musical Hamilton, who is a gifted vocalist. <cite>Hat tip: Rose Kuo.</cite> Check out &#8220;My Favorite Things.&#8221; Embedded on Spotify below, also on <a href=\"https://itunes.apple.com/us/album/simply-christmas/id1170245823\">iTunes</a> and <a href=\"https://www.amazon.com/Simply-Christmas-Leslie-Odom-Jr/dp/B01L22Y87K\">Amazon</a>.</p>\n<p></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 24 Dec 2016 18:18:35 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:31;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:98:\"WPTavern: BuddyPress 2.7.4 Patches Security Vulnerability That Could Allow Arbitrary File Deletion\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:58:\"https://wptavern.com?p=64736&preview=true&preview_id=64736\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:109:\"https://wptavern.com/buddypress-2-7-4-patches-security-vulnerability-that-could-allow-arbitrary-file-deletion\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1223:\"<p>The BuddyPress development team has <a href=\"https://buddypress.org/2016/12/buddypress-2-7-4-security-release/\">released BuddyPress 2.7.4</a> to address a security vulnerability that affects all versions back to 2.0.</p>\n<p>According to John James Jacoby, lead developer of BuddyPress, &#8220;This version patches a vulnerability to the BuddyPress core attachments API that could allow arbitrary file deletion on certain installation configurations.&#8221;</p>\n<p>The vulnerability was responsibly disclosed by Sam Pizzey through the <a href=\"https://hackerone.com/automattic\">HackerOne bounty program</a>. Although Automattic primarily uses the service for its own products, they accept reports for open source projects such as WordPress and BuddyPress.</p>\n<p>Boone Gorges and Paul Gibbs collaborated on a fix for all affected versions of BuddyPress while Stephen Edgar and Dion helped package the release. Those who use BuddyPress are highly encouraged to update as soon as possible to protect against this vulnerability. If you encounter any issues or need help, please create a post on the project&#8217;s<a href=\"https://buddypress.org/support/\"> support forums.</a></p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 23 Dec 2016 19:59:16 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:32;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:49:\"BuddyPress: BuddyPress 2.7.4 – Security Release\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://buddypress.org/?p=262326\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:65:\"https://buddypress.org/2016/12/buddypress-2-7-4-security-release/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1235:\"<p>BuddyPress 2.7.4 is now available, and is a security release &amp; recommended upgrade for all BuddyPress installations. We&#8217;ve also ported the code changes in 2.7.4 to all branches back 2.0, and are pushing updates out for all installations where we are able to do so.</p>\n<p>These releases include a fix to the BuddyPress core attachments API that could allow arbitrary file deletion on certain installation configurations.</p>\n<p>This bug was responsibly disclosed to the WordPress security team (and the BuddyPress team) through the WordPress HackerOne Bounty Program by Sam Pizzey (mopman).</p>\n<p>Both Boone &amp; Paul worked together to fix this for all versions of BuddyPress that are currently in active use, and Stephen &amp; Dion helped package and push these releases out.</p>\n<p>Please update to these latest versions of BuddyPress today in your WordPress Dashboard, or by <a href=\"https://wordpress.org/plugins/buddypress/\">downloading from the wordpress.org plugin repository</a>.</p>\n<p>Questions or comments? Check out the <a href=\"https://codex.buddypress.org/releases/version-2-7-4/\">2.7.4 changelog</a>, or stop by our <a href=\"https://buddypress.org/support/\">support forums</a> or  Trac.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 23 Dec 2016 02:25:06 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:17:\"John James Jacoby\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:33;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:50:\"WPTavern: WordPress.org Launches Homepage Redesign\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=64708\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:61:\"https://wptavern.com/wordpress-org-launches-homepage-redesign\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2790:\"<p><a href=\"https://wordpress.org/\" target=\"_blank\">WordPress.org</a> made its new <a href=\"https://wptavern.com/the-wordpress-org-homepage-is-getting-a-redesign\" target=\"_blank\">homepage redesign</a> live today. The meta team worked quickly to put the new design in place in time for the holidays.</p>\n<p>&#8220;While this is only the first iteration, the plan is to continue design and development to create something truly amazing,&#8221; Mark Uraine said in the <a href=\"https://make.wordpress.org/meta/2016/12/22/new-homepage-is-launched/\" target=\"_blank\">announcement</a>. &#8220;This is the first step toward that goal.&#8221;</p>\n<p><a href=\"https://i2.wp.com/wptavern.com/wp-content/uploads/2016/12/wordpress-homepage-new-design-e1482443742169.png?ssl=1\"><img src=\"https://i2.wp.com/wptavern.com/wp-content/uploads/2016/12/wordpress-homepage-new-design-e1482443742169.png?resize=1025%2C854&ssl=1\" alt=\"\" class=\"aligncenter size-full wp-image-64722\" /></a></p>\n<p>The header and footer have been kept from the previous design. According to meta team member Samuel Wood, matching them to the new design is beyond the scope of this first iteration.</p>\n<p>&#8220;The header and footer are global pieces,&#8221; Wood said. &#8220;Redesigning them, in any way, will have to be part of a much larger effort in redesigning, well, everything. The entire site would need adjustments to adjust them.&#8221;</p>\n<p>Uraine <a href=\"https://make.wordpress.org/meta/2016/12/12/new-homepage-redesign/#comment-8739\" target=\"_blank\">said</a> in a previous post that there are iterations underway for a new, more minimal header that better aligns with the new homepage style.</p>\n<p>Feedback on the <a href=\"https://make.wordpress.org/meta/2016/12/12/new-homepage-redesign/\" target=\"_blank\">initial draft</a> included notes on the copy, particularly the &#8220;Meet WordPress&#8221; headline. One person commented on it not being inclusive of people who have already met WordPress and are returning. Also, a few found the tagline to be too narrow: <em>WordPress is open source software you can use to create a beautiful website, blog, or app.</em> Some suggested the inclusion of other use cases, such as store, forum, and membership site. These ideas have not been incorporated but they were recognized by the design team in the comments on the initial draft.</p>\n<p>The homepage redesign went from sketches to prototype to live on WordPress.org in a matter of a couple weeks. Feedback has been overwhelmingly positive so far, and most see it as a huge improvement. The new design should receive a great deal more exposure now that it&#8217;s live, which will hopefully bring in more varied perspectives towards making it extraordinary in future iterations.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 22 Dec 2016 23:13:10 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:34;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"Matt: New .org Homepage\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:22:\"https://ma.tt/?p=46996\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:39:\"https://ma.tt/2016/12/new-org-homepage/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:410:\"<p>For the first time in&#8230; many years, <a href=\"https://wordpress.org/\">WordPress.org has a new home page</a>. What&#8217;s on the page today actually isn&#8217;t that important, even though it&#8217;s better in many ways, the key is that it&#8217;s changing again, the stone has <a href=\"https://make.wordpress.org/meta/2016/12/22/new-homepage-is-launched/\">been unstuck</a> and can now keep rolling.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 22 Dec 2016 22:10:03 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:35;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:79:\"WPTavern: WPWeekly Episode 257 – My Side Project, WordPress 4.7, and the News\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:58:\"https://wptavern.com?p=64711&preview=true&preview_id=64711\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:84:\"https://wptavern.com/wpweekly-episode-257-my-side-project-wordpress-4-7-and-the-news\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3589:\"<p>In this episode of WordPress Weekly, <a href=\"http://www.marcuscouch.com/\">Marcus Couch</a> and I discuss the news of the week including, WooCommerce&#8217;s 42% market share, the redesign concept of WordPress.org, and two plugin acquisitions. I also share details of a side project I&#8217;m working on that involves BuddyPress. Last but not least, we briefly discuss <a href=\"https://twitter.com/kingjeff2\">Jeff King&#8217;s</a> impact on GoDaddy as he&#8217;s leaving the company at the end of this year.</p>\n<h2>Stories Discussed:</h2>\n<p><a href=\"https://wptavern.com/wordpress-4-7-introduces-twenty-seventeen-default-theme-and-wp-rest-api-content-endpoints\">WordPress 4.7 Introduces Twenty Seventeen Default Theme and WP REST API Content Endpoints</a><br />\n<a href=\"https://wptavern.com/the-wordpress-org-homepage-is-getting-a-redesign\">The WordPress.org Homepage is Getting a Redesign</a><br />\n<a href=\"https://wptavern.com/woocommerce-powers-42-of-all-online-stores\">WooCommerce Powers 42% of All Online Stores</a><br />\n<a href=\"https://wptavern.com/podcast-motor-acquires-seriously-simple-podcasting-plugin\">Podcast Motor Acquires Seriously Simple Podcasting Plugin</a><br />\n<a href=\"https://wptavern.com/updraftplus-acquires-wp-optimize-will-be-integrated-into-updraftcentral\">UpdraftPlus Acquires WP-Optimize, Will Be Integrated Into UpdraftCentral</a><br />\n<a href=\"https://wptavern.com/wordpress-com-launches-vr-content-coming-soon-to-jetpack\">WordPress.com Launches VR Content, Coming Soon to Jetpack</a></p>\n<h2>Plugins Picked By Marcus:</h2>\n<p><a href=\"https://wordpress.org/plugins/wp-youtube-live/\">WP YouTube Live</a> displays a YouTube live video from a specified channel via shortcode. There are several shortcode options available that allow you to autoplay and change the video&#8217;s dimensions. There&#8217;s also an option to not display a video if there isn&#8217;t a live video taking place.</p>\n<p><a href=\"https://wordpress.org/plugins/woo-floating-cart-lite/\">Woo Floating Cart Lite</a> is an interactive floating cart for WooCommerce that slides into view when a user decides to buy an item. Products, quantities, and prices are updated instantly via AJAX. It&#8217;s similar to many of the professional carts you may have seen at the big retail stores where the cart is in view at all times.</p>\n<p><a href=\"https://wordpress.org/plugins/import-facebook-events/\">Import Facebook Events</a> allows you to import events from Facebook into <a href=\"https://wordpress.org/plugins/the-events-calendar/\">The Events Calendar</a> and <a href=\"https://wordpress.org/plugins/events-manager/\">Events Manager</a> plugins. If you are like me and use The Events Manager as your events plugin of choice, this plugin is a no-brainer as an extra add-on. As an add-on plugin this plugin needs The Events Calendar or Events Manager Installed and activated.</p>\n<h2>WPWeekly Meta:</h2>\n<p><strong>Next Episode:</strong> Wednesday, December 28th 3:00 P.M. Eastern</p>\n<p><strong>Subscribe To WPWeekly Via Itunes: </strong><a href=\"https://itunes.apple.com/us/podcast/wordpress-weekly/id694849738\" target=\"_blank\">Click here to subscribe</a></p>\n<p><strong>Subscribe To WPWeekly Via RSS: </strong><a href=\"https://wptavern.com/feed/podcast\" target=\"_blank\">Click here to subscribe</a></p>\n<p><strong>Subscribe To WPWeekly Via Stitcher Radio: </strong><a href=\"http://www.stitcher.com/podcast/wordpress-weekly-podcast?refid=stpr\" target=\"_blank\">Click here to subscribe</a></p>\n<p><strong>Listen To Episode #257:</strong><br />\n</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 22 Dec 2016 21:20:54 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:36;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:75:\"WPTavern: Nadia Eghbal Publishes Guide to Financial Support for Open Source\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=64676\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:86:\"https://wptavern.com/nadia-eghbal-publishes-guide-to-financial-support-for-open-source\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4614:\"<a href=\"https://i2.wp.com/wptavern.com/wp-content/uploads/2016/12/lemonade-stand.jpg?ssl=1\"><img src=\"https://i2.wp.com/wptavern.com/wp-content/uploads/2016/12/lemonade-stand.jpg?resize=1024%2C577&ssl=1\" alt=\"\" class=\"size-full wp-image-64693\" /></a>photo credit: rachaelvoorhees <a href=\"http://www.flickr.com/photos/17237319@N00/2521106411\">A Young Entrepreneur on a Hot Day at Portland State</a> &#8211; <a href=\"https://creativecommons.org/licenses/by-sa/2.0/\">(license)</a>\n<p>If you want to make a living in the world of open source software, <a href=\"http://nadiaeghbal.com/\" target=\"_blank\">Nadia Eghbal</a> has created a <a href=\"https://github.com/nayafia/lemonade-stand#consulting--services\" target=\"_blank\">guide</a> that explores various models for funding your work. Eghbal, who has written extensively on <a href=\"http://nadiaeghbal.com/oss\" target=\"_blank\">sustainability and open source</a>, recently authored <a href=\"https://wptavern.com/ford-foundation-publishes-non-technical-white-paper-on-open-source-software-and-the-challenges-of-sustaining-digital-infrastructure\" target=\"_blank\">a white paper published by the Ford Foundation</a> called “Roads and Bridges: The Unseen Labor Behind Our Digital Infrastructure.” The whitepaper was written to help consumers and companies understand the challenges of sustaining open source software.</p>\n<p>Eghbal published &#8220;A handy guide to financial support for open source&#8221; on GitHub so that others with experience can contribute to the reference. The repository is called &#8220;<a href=\"https://github.com/nayafia/lemonade-stand\" target=\"_blank\">lemonade stand</a>,&#8221; a term that references a common summertime business venture where children cut their teeth in entrepreneurship. The lemonade stand is often used as a symbol of capitalism, a new arena that many developers will need to embrace if they want to provide a sustainable future for their open source work.</p>\n<p>Eghbal&#8217;s guide currently includes 16 different categories of funding, starting with the smallest (donations, bounties, crowdfunding) to the largest (foundations, consortiums, and venture capital). The funding categories explore pros, cons, and relevent case studies where the particular model has been explored.</p>\n<p>&#8220;The purpose of this guide is to provide an exhaustive list of all the ways you can get paid, so that you can figure out what works best for you,&#8221; Eghbal said. It has already received additions from 12 contributors, including Daniel Bachhuber, who is currently <a href=\"https://wptavern.com/wp-cli-project-launches-patron-support-model-to-fund-ongoing-development\" target=\"_blank\">exploring a patron support model to fund his work on WP-CLI</a>.</p>\n<p>With a few notable exceptions like Red Hat and Linux, open source projects suffer from a severe lack of funding, a problem which Eghbal calls &#8220;<a href=\"https://medium.com/@nayafia/how-i-stumbled-upon-the-internet-s-biggest-blind-spot-b9aa23618c58#.6efp8nk2c\" target=\"_blank\">the internet&#8217;s biggest blind spot</a>.&#8221; She notes that the problem of funding digital infrastructure is relatively new but is accelerating as more people are using open source software but ignoring the developer tools everyone relies on.</p>\n<p>WP-CLI is a prime example in the WordPress community. Developers who use it are more inclined to send sporadic donations than become personally invested in maintaining the code base, which has led Bachhuber to test different funding models throughout 2016. There have been <a href=\"https://twitter.com/dd32/status/807435845724577792\" target=\"_blank\">discussions</a> about making it an official WordPress core project with the goal of widening the contributor base and ensuring its longterm future. However, Bachhuber <a href=\"https://twitter.com/danielbachhuber/status/806563582968115201\" target=\"_blank\">said</a> he &#8220;strongly believes WP-CLI should be an independent project.&#8221;</p>\n<p>Eghbal&#8217;s funding <a href=\"https://github.com/nayafia/lemonade-stand\" target=\"_blank\">guide</a> is an important document for open source software maintainers who are struggling to fund their efforts and looking for more options beyond sticking a simple download button on the project&#8217;s website. If you&#8217;re looking for more discussion on this topic, Eghbal co-produces a podcast called <a href=\"https://changelog.com/rfc/archive\" target=\"_blank\">Request for Commits</a> that explores open source&#8217;s complicated relationship with money and various sustainability models.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 22 Dec 2016 20:00:07 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:37;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:78:\"WPTavern: Wallace: A Free WordPress Theme Built on the WP REST API and Angular\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=64652\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:88:\"https://wptavern.com/wallace-a-free-wordpress-theme-built-on-the-wp-rest-api-and-angular\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4819:\"<p><a href=\"https://twitter.com/Bradley_Kirby\" target=\"_blank\">Bradley Kirby</a> released version 1.0 of his <a href=\"https://wallacetheme.com/\" target=\"_blank\">Wallace WordPress theme</a> today. The theme is built using the WP REST API and <a href=\"https://angular.io/\" target=\"_blank\">Angular 2</a>. Kirby has been working on Wallace for the past two years and has rewritten it several times in order to keep pace with changes in the REST API and Angular.</p>\n<p><a href=\"https://i0.wp.com/wptavern.com/wp-content/uploads/2016/12/wallace-theme.png?ssl=1\"><img src=\"https://i0.wp.com/wptavern.com/wp-content/uploads/2016/12/wallace-theme.png?resize=1025%2C925&ssl=1\" alt=\"\" class=\"aligncenter size-full wp-image-64661\" /></a></p>\n<p>If you view the <a href=\"https://demo.wallacetheme.com/\" target=\"_blank\">Wallace demo</a>, you&#8217;ll notice that the theme is super fast because the interface is rendered on the client side with JavaScript.</p>\n<p>&#8220;It really opens a whole new world of possibility for WordPress themes,&#8221; Kirby said. &#8220;For this release I&#8217;ve primarily focused on smooth page transitions. That&#8217;s just not possible with the traditional server-rendered themes. But I think there&#8217;s a lot of really cool customization techniques that the API allows for, too. That&#8217;s what I&#8217;m hoping to explore next.&#8221;</p>\n<p>Although React has emerged as <a href=\"https://wptavern.com/state-of-javascript-survey-results-published-react-emerges-as-clear-winner-in-front-end-frameworks\" target=\"_blank\">the most popular JavaScript framework for front-end development</a> in 2016, Kirby said he chose Angular mostly because he learned it first.</p>\n<p>&#8220;I really like the prescriptive nature of Angular,&#8221; Kirby said. &#8220;There&#8217;s a &#8216;right&#8217; way to do things that you&#8217;ll find in example projects and all the functionality comes with the framework itself. With React you have to use a collection of third-party libraries with various maintainers. With Angular, it&#8217;s all Google, and all one repository. I think React is a perfectly fine framework, and they actually share a lot of concepts.&#8221;</p>\n<p>Wallace currently only supports posts, but Kirby plans to implement more core WordPress features, including pages, comments, searching, and category filtering. He said those features shouldn&#8217;t be too difficult to implement now that the frame is there.</p>\n<p><a href=\"https://i1.wp.com/wptavern.com/wp-content/uploads/2016/12/wallace-posts.png?ssl=1\"><img src=\"https://i1.wp.com/wptavern.com/wp-content/uploads/2016/12/wallace-posts.png?resize=500%2C494&ssl=1\" alt=\"\" class=\"aligncenter size-large wp-image-64669\" /></a></p>\n<p>&#8220;From a programming perspective, this was way more difficult to create than a PHP-rendered theme, because you get so much &#8216;for free&#8217; with the PHP theming API that you don&#8217;t get when you&#8217;re just making raw requests to the REST API,&#8221; Kirby said. The primary advantage of theming with the API is more instantaneous interactions with the content, but creating API-driven themes is not yet as easy as the old way of theming.</p>\n<p>Kirby said he is actively exploring the idea of submitting Wallace to WordPress.org, but the Theme Review Team does not permit the use of Twig templates.</p>\n<p>&#8220;I&#8217;ve brought it up with the team that approves themes, and they didn&#8217;t like that I was using the Twig templating library on the PHP side,&#8221; Kirby said. &#8220;So I&#8217;d have to maintain two versions of the theme if I were to submit it to the directory.&#8221; Kirby hasn&#8217;t ruled it out yet and said he will probably revisit the idea next year.</p>\n<p>&#8220;Twig templates mirror Angular templates really nicely,&#8221; Kirby said. &#8220;It cuts down on the maintenance burden quite a bit, because I have to exactly mirror the templates on the server side and the client side. That would be more difficult if I had to construct PHP echo strings, the typical WordPress template way.&#8221;</p>\n<p>Wallace is integrated with the Customizer and will disable its JavaScript when it detects the Customizer is open, reverting back to a &#8220;normal&#8221; theme. Currently the only option users can customize is the site icon and site title. Wallace does not yet offer support for setting a static front page.</p>\n<p>The next items on Wallace&#8217;s roadmap are adding more core features into the theme. Kirby said he is also exploring the idea of creating a commercial magazine theme in the future.</p>\n<p>&#8220;I think the real killer use case for this way of developing themes is e-commerce, but I want to get a good solid magazine style premium theme done before I tackle that,&#8221; Kirby said.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 21 Dec 2016 22:43:24 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:38;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:62:\"WPTavern: How to Make BuddyPress User Registration Invite-Only\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=64644\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:73:\"https://wptavern.com/how-to-make-buddypress-user-registration-invite-only\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3486:\"<p>One of the first things I recommend users do after installing WordPress is to either close user registration or install a plugin that protects the site against spam registrations. A friend of mine recently started a new WordPress site that has BuddyPress installed.</p>\n<p>After two weeks, I chipped in to help him out and discovered more than 300 registered spam accounts. To make matters worse, these accounts were able to create new groups in BuddyPress and each one contained spam content. The first thing I did was close user registration then I began the boring process of removing the accounts.</p>\n<p>We ran into an issue where legitimate users needed to create accounts while user registration was closed. After asking <a href=\"https://twitter.com/jeffr0/status/810664097868107777\">for suggestions</a> on Twitter and performing a few Google searches, I discovered the <a href=\"https://wordpress.org/plugins/invite-anyone/\">Invite Anyone</a> plugin by <a href=\"https://profiles.wordpress.org/boonebgorges/\">Boone Gorges</a>. Invite Anyone allows registered members to invite people to register to the site via email while registration is closed.</p>\n<a href=\"https://i2.wp.com/wptavern.com/wp-content/uploads/2016/12/InviteAnyoneSettings.png?ssl=1\"><img class=\"size-full wp-image-64646\" src=\"https://i2.wp.com/wptavern.com/wp-content/uploads/2016/12/InviteAnyoneSettings.png?resize=859%2C836&ssl=1\" alt=\"Invite Anyone Settings\" /></a>Invite Anyone Settings\n<p>Using variables provided by the plugin, you can customize the email invitation subject line, the invitation message, and the text at the end of the email. I used the default values which happened to suit my needs. You can also give registered users the ability to customize the invitation subject line or message body and limit the number of emails members can send at one time. In my case, the most important setting to enable was allowing email invitations to be accepted even when site registration is disabled.</p>\n<p>There are other configuration settings as well such as controlling who can send emails and limiting group invitations. Invite Only also has <a href=\"https://www.cloudsponge.com/signup/invite-anyone/\">built-in support for CloudSponge</a>, a service where users can invite anyone from their address books without leaving your site. Stats are built-in as well but during testing I couldn&#8217;t get the Stats tab to load. The Stats tab loads the General Settings page instead.</p>\n<p>Here&#8217;s what Invite Anyone looks like from a user&#8217;s BuddyPress profile page. In addition to inviting someone to the site, users can also invite them to a BuddyPress group as well.</p>\n<a href=\"https://i2.wp.com/wptavern.com/wp-content/uploads/2016/12/InviteAnyoneFrontEnd.png?ssl=1\"><img class=\"size-full wp-image-64647\" src=\"https://i2.wp.com/wptavern.com/wp-content/uploads/2016/12/InviteAnyoneFrontEnd.png?resize=885%2C658&ssl=1\" alt=\"What Invite Anyone Looks Like on the Frontend\" /></a>What Invite Anyone Looks Like on the Frontend\n<p>I&#8217;m using this plugin on a site running WordPress 4.7 and it&#8217;s functioning as expected. So far, we&#8217;ve invited three people and all of them were able to successfully register an account despite user registration being disabled. If you use BuddyPress and need a free solution that implements a user invitation system, I recommend <a href=\"https://wordpress.org/plugins/invite-anyone/\">Invite Anyone</a>.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 21 Dec 2016 19:33:19 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:39;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:43:\"HeroPress: The WordPress Mantra Is Mine Too\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://heropress.com/?post_type=heropress-essays&p=1537\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:51:\"https://heropress.com/essays/wordpress-mantra-mine/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:8731:\"<img width=\"960\" height=\"480\" src=\"http://20094-presscdn.pagely.netdna-cdn.com/wp-content/uploads/2016/12/122116-1024x512.jpg\" class=\"attachment-large size-large wp-post-image\" alt=\"Pull Quote: The simple fact that I improve someone\'s life through my work means the world to me.\" /><h3>Transparency makes the world go round</h3>\n<p>I like being honest, so please allow me to provide a context for this story. First of all, I&#8217;m a pretty introvert kind of guy, and I often need to be thrown in the cold water to start learning how to swim. This was exactly what happened with my teammate, Oana, when she asked me if I&#8217;d be tempted to give HeroPress a go. Of course I would, and so it started the beginning of this story. The next lines are the result of a friendly dialogue between us. Enjoy the ride, dear fellows.</p>\n<p>Here&#8217;s Andrei, a passionate web dev who truly admires the WordPress world. I&#8217;m a full-time backend at Pixelgrade, a design studio where we create WordPress themes that solve real and painful digital problems. Yes, we don&#8217;t just play around with eye-candy pixels, we strive to show up with trustworthy solutions that make people&#8217;s lives easier and more pleasant.</p>\n<p>I&#8217;ve experienced an intense professional rollercoaster till I got here. I still remember the first time I met with the WordPress fascinating world. It was during my first job interview. The employer (today a good friend of mine) told me that I would need to play around with Joomla, something I loved at that time. You can laugh, it&#8217;s okay. I do the same.</p>\n<p>However, the interview was full of tricks since I needed to do something totally different: create a homepage into WordPress. This way, the team could have seen how fast I&#8217;m able to learn new stuff. Pretty good trap since everyone working in the digital playground needs to be open-minded and capable of improving their skills and knowledge.</p>\n<p>That was the very first contact with WordPress, and I was surprised to see its potential. Not only it was easy-to-learn and get along with thanks to an in-depth documentation, but it also had an active community eager to help. Fast forward and the story had a happy ending: I got the job.</p>\n<blockquote><p>Becoming better is kind of a mantra for the true WordPress people</p></blockquote>\n<p>Starting from there and since today I still appreciate WordPress from top to toe. I have a bunch of reasons why I feel this world fits my values and principles. First of all, I enjoy all the PHP talking around WordPress. I find it interesting and challenging at the same time, and every time I have the chance to get involved, I accept it without hesitations. Another great aspect is directly related to my day-to-day job at Pixelgrade. The backend universe where I can improve an amount of cool things keeps my motivation up and kicking. On top of that, I resonate with JavaScript in various ways, backend and frontend too, and from time-to-time I write down my thoughts on my personal blog. I&#8217;m always happy to share ideas and provide feedback that helps. In the end, this is all about when you think of WordPress as an ecosystem, right?</p>\n<p>Talking about this core mission, I must confess that WordPress can be felt like a lifestyle into a room with glass walls. Everyone sees what you do, how you do it, and why you keep doing it. Nobody can take your work for granted, but can easily be inspired by it and even improving it. Becoming better is kind of a mantra for the true WordPress people, and that&#8217;s why they jump in and start spreading solutions about how things can achieve a superior level. With other words, it&#8217;s like sailing with a bunch of amazing people eager to enjoy the same outstanding experience.</p>\n<p>On the other hand, there are some coders that still think that WordPress is not that sexy and challenging in the end. They&#8217;re definitely not in the same boat, but I think it&#8217;s fair from our side to help them change their mind. And not because we chose to work in this playground, mostly because this platform changed a lot in the last years.</p>\n<blockquote><p>The simple fact that I improve someone&#8217;s life through my work means the world to me.</p></blockquote>\n<p>Here are my thoughts for all those programming lovers that would like to try WordPress, but need an extra boost.</p>\n<h3>A wide range of features</h3>\n<p>Articles, menus, widgets, users, live previews, e-commerce, e-learning, listings and so on. You can administrate them, make them better, simply play around as you wish. It might sound naive, but in reality these different areas are constantly bringing all kind of challenges on the table.</p>\n<h3>Legacy code</h3>\n<p>WordPress still strives to support the PHP 5.2.4 version, which was dropped five years ago but 7.5% from today&#8217;s websites still use it. But hey, WordPress is all about keeping users on board, happy and loyal, not skipping the battle. In the end, it does say something about the whole philosophy of the people behind the scenes.</p>\n<h3>Colleges got it wrong</h3>\n<p>There was a time where people studying Object Oriented Programming didn&#8217;t take WordPress seriously since it&#8217;s based on functional programming and that handy and approachable isn&#8217;t something that helps you progress. Well, things changed, people changed, now functional programming is turning back as the coolest thing to do nowadays, and WordPress is trying to get the best from both paradigms.</p>\n<h3>WordPress makes me proud</h3>\n<p>I mean it. It&#8217;s not just shiny words thrown into the digital garden. I&#8217;m a proud WordPress backend dev who deeply feels that impact matters, and building things for an open-source community matters even more. I&#8217;m also happy with the diverse work I do at Pixelgrade: one day can be Customify or the WP Body Class plugin, the next one can be improving Listable, a WordPress theme used by thousands of users spread all over the world. In between could be the passionate discussions regarding the core of WordPress, some advice tailored on other authors or the amazing WordCamp Europe. Whatever it is, I am grateful that I found my place where creativity, freedom, and braveness are in the first place.</p>\n<p>Call it as you wish, but the simple fact that I improve someone&#8217;s life through my work means the world to me. It gives me a sense of fulfillment, the necessary energy to keep improving, and the never-ending joy that I did something useful. And hey, there&#8217;s just another beginning since Pixelgrade has reshaped its digital presence through an outstanding website and more consistent brand story. So bring it on, fellows!</p>\n<div class=\"rtsocial-container rtsocial-container-align-right rtsocial-horizontal\"><div class=\"rtsocial-twitter-horizontal\"><div class=\"rtsocial-twitter-horizontal-button\"><a title=\"Tweet: The WordPress Mantra Is Mine Too\" class=\"rtsocial-twitter-button\" href=\"https://twitter.com/share?text=The%20WordPress%20Mantra%20Is%20Mine%20Too&via=heropress&url=https%3A%2F%2Fheropress.com%2Fessays%2Fwordpress-mantra-mine%2F\" rel=\"nofollow\" target=\"_blank\"></a></div></div><div class=\"rtsocial-fb-horizontal fb-light\"><div class=\"rtsocial-fb-horizontal-button\"><a title=\"Like: The WordPress Mantra Is Mine Too\" class=\"rtsocial-fb-button rtsocial-fb-like-light\" href=\"https://www.facebook.com/sharer.php?u=https%3A%2F%2Fheropress.com%2Fessays%2Fwordpress-mantra-mine%2F\" rel=\"nofollow\" target=\"_blank\"></a></div></div><div class=\"rtsocial-linkedin-horizontal\"><div class=\"rtsocial-linkedin-horizontal-button\"><a class=\"rtsocial-linkedin-button\" href=\"https://www.linkedin.com/shareArticle?mini=true&url=https%3A%2F%2Fheropress.com%2Fessays%2Fwordpress-mantra-mine%2F&title=The+WordPress+Mantra+Is+Mine+Too\" rel=\"nofollow\" target=\"_blank\" title=\"Share: The WordPress Mantra Is Mine Too\"></a></div></div><div class=\"rtsocial-pinterest-horizontal\"><div class=\"rtsocial-pinterest-horizontal-button\"><a class=\"rtsocial-pinterest-button\" href=\"https://pinterest.com/pin/create/button/?url=https://heropress.com/essays/wordpress-mantra-mine/&media=https://heropress.com/wp-content/uploads/2016/12/122116-150x150.jpg&description=The WordPress Mantra Is Mine Too\" rel=\"nofollow\" target=\"_blank\" title=\"Pin: The WordPress Mantra Is Mine Too\"></a></div></div><a rel=\"nofollow\" class=\"perma-link\" href=\"https://heropress.com/essays/wordpress-mantra-mine/\" title=\"The WordPress Mantra Is Mine Too\"></a></div><p>The post <a rel=\"nofollow\" href=\"https://heropress.com/essays/wordpress-mantra-mine/\">The WordPress Mantra Is Mine Too</a> appeared first on <a rel=\"nofollow\" href=\"https://heropress.com\">HeroPress</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 21 Dec 2016 12:00:43 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Andrei Lupu\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:40;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:58:\"WPTavern: The WordPress.org Homepage is Getting a Redesign\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=64587\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:69:\"https://wptavern.com/the-wordpress-org-homepage-is-getting-a-redesign\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3549:\"<p>A WordPress.org homepage redesign is now in the works with a strong focus on marketing to new users. As the face of the open source project, the site is long overdue for some design attention. Mark Uraine, a designer at Automattic, <a href=\"https://make.wordpress.org/meta/2016/12/12/new-homepage-redesign/\" target=\"_blank\">posted</a> on the Make/Meta blog about how quickly the project is coming together:</p>\n<p>&#8220;During the Contributor Day at WordCamp US, the Marketing Team sat down with a project in mind — the homepage of wordpress.org,&#8221; Uraine said. &#8220;Since the new design style is making an appearance in various places across the site, there was a desire to reboot the homepage as well.&#8221;</p>\n<p><a href=\"https://i2.wp.com/wptavern.com/wp-content/uploads/2016/12/wordpress-homepage.png?ssl=1\"><img src=\"https://i2.wp.com/wptavern.com/wp-content/uploads/2016/12/wordpress-homepage.png?resize=203%2C500&ssl=1\" alt=\"\" class=\"alignleft size-large wp-image-64631\" /></a>Uraine posted the group&#8217;s original sketches as well as a screenshot of the initial draft on desktop and mobile. The screenshot doesn&#8217;t include the site&#8217;s header and footer, which will be added when the design is implemented. The team has also created a <a href=\"http://codepen.io/mapk/full/MbGpvR/\" target=\"_blank\">Codepen Prototype</a>, which demonstrates the fixed background featuring high profile WordPress sites that visitors see as they scroll.</p>\n<p>&#8220;Keep in mind that this is only version 1.0 and we’re planning on launching and iterating quickly,&#8221; Uraine said when asking for feedback from the community. &#8220;Otto has offered his help to get this implemented. After a few technical revisions, I’ll be passing it over to him for implementation and providing support where I can.&#8221;</p>\n<p>The redesign focuses on social proof (market share and showcase examples) as well as WordPress&#8217; features and extensibility:</p>\n<p><em>&#8220;Extend WordPress with over 45,000 plugins to help your website meet your needs. Add an online store, galleries, mailing lists, forums, analytics, and much more.&#8221;</em></p>\n<p>Since Uraine posted the design draft, commenters have been weighing in with revisions to the site copy, which hasn&#8217;t yet been finalized. A few contributors have also suggested including A/B testing, although no specific metrics have been determined. The redesign is moving fast, so make sure to jump in on the <a href=\"https://make.wordpress.org/meta/2016/12/12/new-homepage-redesign/\" target=\"_blank\">Make/Meta post</a> if you have feedback on the draft.</p>\n<p>WordPress is getting more strategic about its marketing in 2017. Matt Mullenweg announced during the <a href=\"https://wptavern.com/state-of-the-word-2016-mullenweg-pushes-calypso-as-future-of-wordpress-interface-proposes-major-changes-to-release-cycle\" target=\"_blank\">2016 State of the Word</a> that he is bringing a new product-based leadership to core development and is assembling a <a href=\"https://wptavern.com/matt-mullenweg-proposes-wordpress-growth-council\" target=\"_blank\">Growth Council</a> to coordinate strategy with organizations invested in WordPress&#8217; growth.</p>\n<p>&#8220;I think in the past WordPress got by on a lot of marketing happenstance,&#8221; Mullenweg said. &#8220;We can become a lot more sophisticated with our messaging and presentation on WordPress.org to bring people in and tell the story about what makes WordPress different.&#8221;</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 20 Dec 2016 20:45:03 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:41;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:69:\"WPTavern: How to Change the Default Members Landing Tab in BuddyPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=64592\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:80:\"https://wptavern.com/how-to-change-the-default-members-landing-tab-in-buddypress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2880:\"<p>For the past two weeks, I&#8217;ve been helping a friend build his site. The site uses WordPress and BuddyPress and is the first opportunity I&#8217;ve had to use BuddyPress for a project. The site is dedicated to a Hockey League league that&#8217;s specific to a video game. The league has a number of players and teams.</p>\n<p>By default, when a visitor browses a BuddyPress member&#8217;s profile, the activity tab is displayed. Since a player&#8217;s team is displayed on a user&#8217;s profile, I wanted the profile tab to be the first thing users see. According to the <a href=\"https://codex.buddypress.org/getting-started/guides/change-members-profile-landing-tab/\">BuddyPress Codex</a>, it&#8217;s possible to change the default landing tab by adding a line of code to either a bp-custom.php file or to wp-config.php. The code is as follows:</p>\n<p><code>/**<br />\n* Change BuddyPress default Members landing tab.<br />\n*/<br />\ndefine(\'BP_DEFAULT_COMPONENT\', \'profile\' );</code></p>\n<p>As I didn&#8217;t want to create and upload another php file, I inserted the code into wp-config.php. At the time of writing this article, the help document on the BuddyPress Codex did not specify where in the wp-config file the code should be placed. After adding the code to the bottom of the wp-config file, I noticed it didn&#8217;t work.</p>\n<p>The trick is to add it to a place that runs before BuddyPress is fully loaded. I moved the code so that is was after the define(&#8216;DB_COLLATE&#8217;, &#8221;); line in wp-config. This allowed the code to run without any issues.</p>\n<a href=\"https://i1.wp.com/wptavern.com/wp-content/uploads/2016/12/BPAddedCodetoWPConfig.png?ssl=1\"><img class=\"size-full wp-image-64616\" src=\"https://i1.wp.com/wptavern.com/wp-content/uploads/2016/12/BPAddedCodetoWPConfig.png?resize=645%2C203&ssl=1\" alt=\"Code Added to the Proper Place in the wpconfig File\" /></a>Code Added to the Proper Place in the wp-config File\n<p>With the code in place, whenever someone clicks on a player&#8217;s name that&#8217;s mentioned in a post, the first thing they see is their profile and the team they&#8217;re assigned too.</p>\n<a href=\"https://i1.wp.com/wptavern.com/wp-content/uploads/2016/12/ProfilePageLoadsFirst.png?ssl=1\"><img class=\"size-full wp-image-64617\" src=\"https://i1.wp.com/wptavern.com/wp-content/uploads/2016/12/ProfilePageLoadsFirst.png?resize=645%2C370&ssl=1\" alt=\"Profile Page Loads First in BuddyPress\" /></a>Profile Page Loads First in BuddyPress\n<p>This is a small change in how BuddyPress works but for an implementor like me, it was a bit of a hassle. The largest obstacle in achieving what I wanted were the directions that don&#8217;t specify where in the config file the code should be placed. I&#8217;ve since edited the Codex article to prevent others from experiencing the same trouble.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 20 Dec 2016 03:30:32 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:42;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:90:\"WPTavern: WPWeekly Episode 256 – Interview With Tony Perez, CEO and Co-Founder of Sucuri\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:58:\"https://wptavern.com?p=64479&preview=true&preview_id=64479\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:96:\"https://wptavern.com/wpweekly-episode-256-interview-with-tony-perez-ceo-and-co-founder-of-sucuri\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2577:\"<p>In this episode of WordPress Weekly, <a href=\"http://marcuscouch.com/\">Marcus Couch</a> and I are joined by <a href=\"https://perezbox.com/\">Tony Perez</a>, co-founder and CEO of <a href=\"https://sucuri.net/\">Sucuri</a>. It&#8217;s easy to tell from this episode that Perez is extremely passionate about web security.</p>\n<p>We discussed a wide range of topics related to security including, trends involving WordPress, <a href=\"https://blog.sucuri.net/2016/10/security-confusion-fud-factor.html\">the FUD factor</a>, messaging surrounding HTTPS, and what <a href=\"https://blog.sucuri.net/2016/10/accounting-for-defense-in-depth-in-website-security.html\">Defense in Depth</a> really means. We also discussed the three basic elements of security, <a href=\"https://perezbox.com/2015/10/website-security-is-not-an-absolute/\">people, process, and technology</a>.</p>\n<p>Perez spoke relatively quickly and at times, the conversation was technical. I recommend listening to the show at least twice in order to digest everything.</p>\n<h2>Plugins Picked By Marcus:</h2>\n<p><a href=\"https://wordpress.org/plugins/product-review/\">Product Review</a> comes with common features that you may need for a review focused site. This includes editor reviews, user reviews, segmented rating, pros and cons, affiliate button and a lot more.</p>\n<p><a href=\"https://wordpress.org/plugins/messenger-bot-for-woocommerce/\">Messengerbot for WooCommerce</a> provides the ability to send your customers messages via Facebook Messenger. It supports Order Receipts, Order status changes, and Customer Order notes.</p>\n<p><a href=\"https://wordpress.org/plugins/email-tracker/\">Email Tracker</a> is a plugin that notifies you if the emails sent by WordPress using the wp_mail function have been read or not. It displays statistics like how many times an email has been read with the date and time.</p>\n<h2>WPWeekly Meta:</h2>\n<p><strong>Next Episode:</strong> Wednesday, December 21st 9:30 P.M. Eastern</p>\n<p><strong>Subscribe To WPWeekly Via Itunes: </strong><a href=\"https://itunes.apple.com/us/podcast/wordpress-weekly/id694849738\" target=\"_blank\">Click here to subscribe</a></p>\n<p><strong>Subscribe To WPWeekly Via RSS: </strong><a href=\"https://wptavern.com/feed/podcast\" target=\"_blank\">Click here to subscribe</a></p>\n<p><strong>Subscribe To WPWeekly Via Stitcher Radio: </strong><a href=\"http://www.stitcher.com/podcast/wordpress-weekly-podcast?refid=stpr\" target=\"_blank\">Click here to subscribe</a></p>\n<p><strong>Listen To Episode #256:</strong><br />\n</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 20 Dec 2016 01:33:43 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:43;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:68:\"WPTavern: WordCamp Bangkok 2017 Adds English Track, Debuts New Wapuu\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=64566\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:78:\"https://wptavern.com/wordcamp-bangkok-2017-adds-english-track-debuts-new-wapuu\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1978:\"<p>Tickets for WordCamp Bangkok 2017 <a href=\"https://2017.bangkok.wordcamp.org/tickets-are-ready/\" target=\"_blank\">went on sale</a> over the weekend and there are 235 remaining. The event will be held on February 18, 2017, at CP Tower on Silom Road. This is the third WordCamp to take place in the Bangkok area but organizers are including an English Track for the first time at this year&#8217;s event. The Thai and English tracks will run side-by-side and will include WordPress topics for users of all levels.</p>\n<p><a href=\"https://i0.wp.com/wptavern.com/wp-content/uploads/2016/12/wordcamp-bangkok-wapuu-e1482185243432.jpg?ssl=1\"><img src=\"https://i2.wp.com/wptavern.com/wp-content/uploads/2016/12/wordcamp-bangkok-wapuu-e1482185243432-300x274.jpg?resize=300%2C274&ssl=1\" alt=\"\" class=\"alignright size-medium wp-image-64601\" /></a>Yesterday organizers <a href=\"https://2017.bangkok.wordcamp.org/wapuu-thailand/\" target=\"_blank\">unveiled the new Thailand Wapuu</a>, featuring traditional Thai garb and a banana stalk. Bananas leaves and stems, in addition to the fruit itself, make up an important part of Thai life with both ceremonial and practical uses.</p>\n<p>The calls for <a href=\"https://2017.bangkok.wordcamp.org/call-for-speakers/\" target=\"_blank\">speakers</a> and <a href=\"https://2017.bangkok.wordcamp.org/call-for-sponsors/\" target=\"_blank\">sponsors</a> are open and higher level sponsorships are already sold out. Speaker applications will be accepted through January 5, 2017.</p>\n<p>Previous WordCamps in the region were held in 2008 and 2009. During the past eight years the Thai WordPress community has grown and the <a href=\"https://www.facebook.com/groups/wpalliance/\" target=\"_blank\">Thai WordPress Alliance group</a> on Facebook now has more than 9,800 members. WordCamp Bangkok 2017 has a maximum capacity of 300 attendees. If you plan to go, make sure to purchase your ticket early before the event sells out.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 20 Dec 2016 00:43:52 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:44;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"WPTavern: WooCommerce Powers 42% of All Online Stores\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=64550\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:63:\"https://wptavern.com/woocommerce-powers-42-of-all-online-stores\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:5576:\"<p>Last week Automattic<a href=\"https://automattic.com/year-in-review-2016/\" target=\"_blank\"> published</a> its annual &#8220;Year in Review&#8221; stats, including WooCommerce stats for the first time since the company <a href=\"https://wptavern.com/automattic-acquires-woocommerce\" target=\"_blank\">acquired Woo</a> in 2015. As of December, there are 1,594,894 active stores using WooCommerce and roughly 1/3 of those (530,000) are new in 2016.</p>\n<p>One of the most exciting areas of growth is WooCommerce&#8217;s global market share. Although both the Year in Review post and the <a href=\"https://woocommerce.com/\" target=\"_blank\">WooCommerce website</a> have the software at 39%, <a href=\"http://trends.builtwith.com/shop\" target=\"_blank\">Builtwith stats</a> show WooCommerce powers 42% of all online stores. This is a huge leap from 30% a year and a half ago, when it was acquired.</p>\n<p><a href=\"https://i0.wp.com/wptavern.com/wp-content/uploads/2016/12/woocommerce-market-share.png?ssl=1\"><img src=\"https://i0.wp.com/wptavern.com/wp-content/uploads/2016/12/woocommerce-market-share.png?resize=1025%2C613&ssl=1\" alt=\"\" class=\"aligncenter size-full wp-image-64553\" /></a></p>\n<p>WooCommerce market share is even higher in emerging markets like <a href=\"https://trends.builtwith.com/shop/country/India\" target=\"_blank\">India</a> (55% among stores using the .IN extension) and <a href=\"https://trends.builtwith.com/shop/country/Mexico\" target=\"_blank\">Mexico</a> (56% among stores using the .MX extension).</p>\n<h3>WooCommerce in 2017: Evolving Storefront for Independent Stores</h3>\n<p>In May 2016, <a href=\"https://wptavern.com/automattic-introduces-woocommerce-connect-hosted-components-for-e-commerce\" target=\"_blank\">WooCommerce introduced WC Connect</a>, its new Automattic-hosted SaaS architecture built on the WP REST API that makes it easier for users to add and configure store features. Real-time USPS shipping rates for US-based stores is the first of many planned hosted components. <a href=\"https://wptavern.com/woocommerce-2-6-introduces-shipping-zones-and-a-new-design-for-account-pages\" target=\"_blank\">Version 2.6</a> introduced the new Shipping Zones feature and an updated design for account pages. In 2016, WooCommerce also <a href=\"https://wptavern.com/woocommerce-releases-square-integration-to-sync-online-and-offline-purchases-and-inventory\" target=\"_blank\">released its Square integration</a> to sync online and offline purchases and inventory.</p>\n<p>The plan for 2017, according to the Year in Review summary, is to continue making setup and scaling easier. At WordCamp US I asked Matt Mullenweg, CEO of Automattic, what he looks for in a buying experience and how he hopes to bring that to WooCommerce.</p>\n<p>&#8220;When I buy from an independent store online, I&#8217;m looking for it to be as friction-free as possible,&#8221; Mullenweg said. &#8220;I don&#8217;t want a lot of steps. I don&#8217;t want it to force me to register if I don&#8217;t want to. I don&#8217;t want the form to error out in weird ways &#8211; anything that breaks my trust. When I visit a website to buy something, how a site looks can increase or decrease my trust.&#8221;</p>\n<p>WooCommerce&#8217;s official <a href=\"https://woocommerce.com/storefront/\" target=\"_blank\">Storefront theme</a>, which is active on more than 80,000 stores, plays an important part in shaping the buying experience for millions of customers. Mullenweg said Storefront has a lot of potential for improvement.</p>\n<p>&#8220;With the Storefront theme there&#8217;s actually a lot we can do there to make it look like a really cool store out of the box, much like the default themes in WordPress,&#8221; Mullenweg said. &#8220;Part of the reason we change them every year is what was cool in 2012 is not cool in 2017. Fashions change, trends change. I think Woo should evolve Storefront in the same way. There&#8217;s kind of a look for independent stores right now. They&#8217;ve got a certain vibe. Let&#8217;s make it easy to do that vibe, so that you don&#8217;t have to be on Etsy or Amazon or one of the e-commerce monoliths to keep people coming to you and supporting your product.&#8221;</p>\n<p>Mullenweg said there are features in the power packs and add-ons that could be good candidates for building into Storefront. The theme <a href=\"https://wptavern.com/woothemes-launches-storefront-a-free-wordpress-theme-with-woocommerce-integration\" target=\"_blank\">launched in 2014</a> and since that time has made mostly gradual improvements. The last major design improvements were released last May in <a href=\"https://github.com/woocommerce/storefront/blob/master/changelog.md#20160506---200\" target=\"_blank\">version 2.0</a>, but many store owners opt for a child theme if they want more extensive design changes to Storefront.</p>\n<p>If WooCommerce market share continues to grow at the same rate, it could easily pass 50% of all online stores in 2017. With <a href=\"https://woocommerce.com/meetups/\" target=\"_blank\">53 meetups</a> scattered across the globe &#8211; from Tokyo to Mumbai to Vancouver, the plugin is embracing the community factor that has made WordPress a success.</p>\n<p>&#8220;I think both Jetpack and WooCommerce individually could each be bigger than WordPress.com,&#8221; Mullenweg said. &#8220;They&#8217;re both smaller than WordPress.com right now but I think each on their own could be several times larger. There are multi-billion dollar opportunities in both, so that&#8217;s what we&#8217;re working on.&#8221;</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 19 Dec 2016 19:26:08 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:45;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:67:\"WPTavern: Podcast Motor Acquires Seriously Simple Podcasting Plugin\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=64535\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:78:\"https://wptavern.com/podcast-motor-acquires-seriously-simple-podcasting-plugin\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2420:\"<p><a href=\"http://seriouslysimplepodcasting.com/\">Seriously Simple Podcasting</a>, created by <a href=\"https://hughlashbrooke.com/\">Hugh Lashbrooke</a> in 2012, has been acquired by <a href=\"http://www.podcastmotor.com/\">Podcast Motor</a>. The <a href=\"https://wordpress.org/plugins/seriously-simple-podcasting/\">plugin</a> is actively installed on nearly 20K sites and out of 104 reviews, has an average rating of 4.9 stars.</p>\n<p>Lashbrooke no longer has the time to dedicate to the project, &#8220;I am in fact selling the plugin (along with all of its add-ons) as I just no longer have the time or bandwidth available to support it in the way that I know it deserves,&#8221; Lashbrooke said. Lashbrooke created the plugin to <a href=\"https://hughlashbrooke.com/2015/11/25/democratising-podcasting/\">democratize podcasting</a> and says it was never meant to be a full-time project.</p>\n<a href=\"https://i0.wp.com/wptavern.com/wp-content/uploads/2016/12/SSPSettingsPage.png?ssl=1\"><img class=\"size-full wp-image-64542\" src=\"https://i0.wp.com/wptavern.com/wp-content/uploads/2016/12/SSPSettingsPage.png?resize=1025%2C541&ssl=1\" alt=\"Seriously Simply Podcasting Settings Page\" /></a>Seriously Simply Podcasting Settings Page\n<p>Podcast Motor provides editing and production services to podcasters. Craig Hewitt, founder of Podcast Motor, acquired the plugin because of its established brand, ease of use, and it allows his company to serve a wider audience.</p>\n<p>Seriously Simple Podcasting will remain a free plugin and Hewitt will continue to support it through WordPress.org. He also plans to add free features to increase the plugin&#8217;s value, &#8220;This will include things like bulk importing of episodes/feeds from other providers, RSS feed validation, and some enhanced front end styling of the on-page podcast display,&#8221; he said.</p>\n<p>Hewitt is ready to breath new life into the project and is seeking feedback from users on what features they&#8217;d like to see added, &#8220;Our long-term goal is to enhance the functionality of the product so that it meets more needs of more podcasters down the road,&#8221; he said.</p>\n<p>Instead of abandoning the plugin or putting it up for adoption, Lashbrooke has found it a new home with a developer eager to improve on his work. If you use Seriously Simple Podcasting, what features do you want to see added?</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 16 Dec 2016 23:07:51 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:46;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:82:\"WPTavern: WP-CLI Project Launches Patron Support Model to Fund Ongoing Development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=64512\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:93:\"https://wptavern.com/wp-cli-project-launches-patron-support-model-to-fund-ongoing-development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:5912:\"<p><a href=\"https://i1.wp.com/wptavern.com/wp-content/uploads/2016/05/wp-cli.png?ssl=1\"><img src=\"https://i1.wp.com/wptavern.com/wp-content/uploads/2016/05/wp-cli.png?resize=1025%2C411&ssl=1\" alt=\"\" class=\"aligncenter size-full wp-image-55961\" /></a></p>\n<p>WP-CLI contributors have been <a href=\"https://wptavern.com/wp-cli-contributors-work-towards-a-more-sustainable-future-for-the-project\" target=\"_blank\">working towards a more sustainable future for the project</a> throughout 2016. Daniel Bachhuber, the project&#8217;s official maintainer, has launched an experiment to fund ongoing maintenance and new development, asking potential patrons, &#8220;<a href=\"http://wp-cli.org/blog/the-big-question.html\" target=\"_blank\">How much is WP-CLI worth to you?</a>&#8221; Options for contributions range from $100/yr &#8211; $7500/yr.</p>\n<p>This particular funding experiment is not asking for one-time contributions but rather follows a subscriber model where patrons will be billed annually. Bachhuber said he has a number in mind in order to consider the funding a success but he is not going to share it.</p>\n<p>&#8220;I want to see if this is a viable approach for funding a for-profit business,&#8221; Bacchuber said. He plans to fully refund subscribers if the campaign doesn&#8217;t reach its goal.</p>\n<p>Last year Bachhuber <a href=\"https://wptavern.com/a-more-restful-wp-cli-kickstarter-campaign-is-now-187-funded\" target=\"_blank\">raised $32,822</a> in a highly successful Kickstarter campaign from 107 backers, which funded development during the first part of 2016. After the campaign he started a business called <a href=\"https://runcommand.io/\" target=\"_blank\">runcommand</a> that offered enterprise support and custom development for hosts and agencies. This was an attempt to help subsidize his time spent on WP-CLI, but it didn&#8217;t work out the way he planned:</p>\n<blockquote><p>The business is doing alright, not great but not horrible. What I’ve come to realize, though, is that my time is zero-sum. I’m incentivized to spend time on runcommand, when I’d rather spend it on WP-CLI.</p>\n<p>Ultimately, the challenge I’m running into is opportunity cost. I’d love to be able to invest more into WP-CLI, but doing so comes at the cost of other business pursuits. Because WP-CLI is such a large project, the several hours I volunteer each week are basically enough to fight entropy — not make headway on larger initiatives.</p></blockquote>\n<p>Bachhuber said he hopes this patron-esque model will scale so he can hire a few people to work on WP-CLI, helping reduce his bus factor and creating a stronger contributor base.</p>\n<p>&#8220;The project itself is at a point where it needs dedicated attention from maintainers, not occasional changes from contributors,&#8221; Bachhuber said in response to commenters on the post.</p>\n<p>&#8220;I will, however, echo other comments here in regards to the wish for a public roadmap, more transparency, marketing efforts, and more in regards to the business being built upon WP-CLI,&#8221; subscriber Pippin Williamson said. &#8220;I have chosen to make my subscription payment as a donation to the project, not as a purchase/ of the product / service because, at this time at least, there&#8217;s not really anything I get out of it beyond continued development of the project.&#8221;</p>\n<p>Williamson said the new <a href=\"https://runcommand.io/wp/doctor/\" target=\"_blank\">wp doctor</a> and <a href=\"https://runcommand.io/wp/profile/\" target=\"_blank\">wp profile</a> commands would not be of much use to him or his team. He also suggested that Bachhuber sell a professional subscription that offers a library of additional commands for popular plugins, such as WooCommerce, Easy Digital Downloads, WP Migrate DB Pro, and Gravity Forms.</p>\n<p>&#8220;What I&#8217;ve come to appreciate is that WP-CLI will be far more successful in the long-term by building all of these in the open, instead of a more traditional model of making some selection of them paid-access,&#8221; Bachhuber said.</p>\n<p>Subscriptions will help fund the ongoing maintenance of WP-CLI, the creation of new commands, and improvements to the website and package index.</p>\n<p>For a project that is geared almost exclusively towards developers, there&#8217;s a surprisingly low number of contributors to its development. The brunt of it falls to Bachhuber as the official maintainer. His campaign puts the impetus on subscribers to help improve the tools they use every day through monetary contribution.</p>\n<p>Hopefully, funding the organization will also precipitate a culture shift resulting in more developers who are motivated to get their hands dirty and become personally invested in the code base. Funding one person&#8217;s time is not the most effective way to keep a project afloat and may not do much to reduce the bus factor on the project unless Bachhuber can hire or inspire more maintainers.</p>\n<blockquote class=\"twitter-tweet\">\n<p lang=\"en\" dir=\"ltr\">This year, I\'ve spent 308 hours on <a href=\"https://twitter.com/wpcli\">@wpcli</a> (140 paid, 168 volunteer). Next year could be double or could be zero <a href=\"https://t.co/nujVBQZ3Bs\">https://t.co/nujVBQZ3Bs</a></p>\n<p>&mdash; Daniel Bachhuber (@danielbachhuber) <a href=\"https://twitter.com/danielbachhuber/status/809056634337042432\">December 14, 2016</a></p></blockquote>\n<p></p>\n<p>By choosing to wrestle with the challenges of funding open source software in a transparent way, Bachhuber is paving the way for other project maintainers to learn from his experiments and pursue similarly unorthodox funding options. So far WP-CLI has received 17 subscribers. If it reaches 50, Bachhuber plans to create a members-only forum. The <a href=\"http://wp-cli.org/blog/the-big-question.html\" target=\"_blank\">funding experiment</a> closes on December 28th.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 15 Dec 2016 23:05:53 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:47;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:17:\"Matt: A Poetition\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:22:\"https://ma.tt/?p=46988\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://ma.tt/2016/12/a-poetition/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:239:\"<p>Joseph O&#8217;Neill has <a href=\"http://www.newyorker.com/magazine/2016/12/12/pardon-edward-snowden\">an amazing and funny poetry-related short story Pardon Edward Snowden in the New Yorker which pokes fun at itself quite a bit</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 15 Dec 2016 20:11:10 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:48;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:67:\"WPTavern: WordPress.com Launches VR Content, Coming Soon to Jetpack\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=64486\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:77:\"https://wptavern.com/wordpress-com-launches-vr-content-coming-soon-to-jetpack\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4476:\"<a href=\"https://i1.wp.com/wptavern.com/wp-content/uploads/2016/12/VR.jpg?ssl=1\"><img src=\"https://i1.wp.com/wptavern.com/wp-content/uploads/2016/12/VR.jpg?resize=960%2C589&ssl=1\" alt=\"\" class=\"size-full wp-image-64492\" /></a>photo credit: <a href=\"https://stocksnap.io/photo/OQLN09UT3X\">Sebastian Voortman</a>\n<p>WordPress.com <a href=\"http://en.blog.wordpress.com/2016/12/15/introducing-vr-and-360-content-for-all-wordpress-com-sites\" target=\"_blank\">announced</a> today that users can now upload and publish VR content on their sites, including 360° photos and 360° videos. Regular photos and panoramas are also now viewable in VR. The VR gear tested so far includes Cardboard, Gear, Daydream, Rift, and Vive.</p>\n<p>Uploading VR content works just like adding normal pictures and videos. Users can then add 360° photos and videos to posts using a &#8220;vr&#8221; shortcode. The Harvard Gazette&#8217;s <a href=\"http://news.harvard.edu/gazette/story/2016/10/confronting-the-refugee-crisis/\" target=\"_blank\">Confronting the Refugee Crisis</a> story is one live example of the new VR content in action:</p>\n<p><a href=\"https://i0.wp.com/wptavern.com/wp-content/uploads/2016/12/vr-example.gif?ssl=1\"><img src=\"https://i0.wp.com/wptavern.com/wp-content/uploads/2016/12/vr-example.gif?resize=523%2C526&ssl=1\" alt=\"\" class=\"aligncenter size-full wp-image-64503\" /></a></p>\n<p>&#8220;Our goal is to make publishing VR content as simple as publishing text or photos to the web,&#8221; Automattic team lead Toni Schneider said. Schneider, who is <a href=\"https://toni.org/2016/06/06/comparing-the-vive-to-the-rift/\" target=\"_blank\">a big VR fan himself</a>, led the team to bring VR capabilities to WordPress.com. He <a href=\"https://toni.org/2014/10/29/my-vr-memory/\" target=\"_blank\">worked in a VR startup</a> in the 90&#8217;s after college and has been a VR fan ever since.</p>\n<p>&#8220;With the re-emergence of VR, it struck me that WordPress can play a role in making VR content easy to create and access for everyone, just like we did for text and photos,&#8221; Schneider said. His team at Automattic uses VR for collaboration and Schneider said &#8220;hearing [teammates&#8217;] voices in their proper spatial locations makes for a more natural and seamless collaboration experience&#8221; that feels less forced than a screenshare or video chat.</p>\n<p>Immersive storytelling driven by VR technology is also finding its way into the publishing industry. As part of his article in <a href=\"http://www.niemanlab.org/collection/predictions-2017/\" target=\"_blank\">NiemanLab&#8217;s Predictions for Journalism 2017</a> series, Mario García, a media consultant and adjunct professor at Columbia University Graduate School of Journalism, predicts that &#8220;storytelling using VR will be easier to achieve, and more members of the audience will be prepared to welcome it.”</p>\n<p>García cites the The New York Times and its <a href=\"https://www.nytimes.com/video/the-daily-360\" target=\"_blank\">Daily 360</a> section as one of the first publications to experiment with the medium. WordPress.com uses a similar UI, as you can see on the Harvard Gazette example, with an overlay that indicates VR content.</p>\n<p>&#8220;One form of storytelling that will gain momentum: virtual reality,&#8221; García said. &#8220;It’s no coincidence: Editors and publishers are looking for ways to tell stories on mobile devices, and the future of virtual reality is also on mobile. For many newsrooms, VR is going to be the one big area for experimentation in 2017.&#8221;</p>\n<p>WordPress.com is ready to ride this trend, making immersive storytelling available to all users &#8211; from large publications to small blogs. A few plugins, such as <a href=\"https://wordpress.org/plugins/vr-views/\" target=\"_blank\">VR Views</a> and <a href=\"https://wordpress.org/plugins/wp-vr-view/\" target=\"_blank\">WP-VR-view</a>, are already available for self-hosted sites, and WordPress.com plans to make its VR capabilities more widely available to the WordPress world soon.</p>\n<p>&#8220;It will be in Jetpack soon, as soon as the next Jetpack release comes out,&#8221; Schneider said. &#8220;The technology is built to work on all WordPress sites and even beyond that, on any web site. We consider this first release just a start. As soon as we see how people use it, we will start adding more features and supporting more types of VR experiences.&#8221;</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 15 Dec 2016 17:39:31 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:49;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:20:\"Matt: Another Dongle\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:22:\"https://ma.tt/?p=46982\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:37:\"https://ma.tt/2016/12/another-dongle/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:508:\"<p>One of my favorite new .blogs is The Dongle blog, at dongle.blog. I think it&#8217;s mostly meant to be funny, but I really agree with this post pointing out you <a href=\"http://dongle.blog/an-opportunity-for-a-new-dongle/\">really need something that lets you plug in your lightning headphones to your laptop</a>. I&#8217;ve been trying out <a href=\"https://www.amazon.com/Audeze-Closed-Back-Headphones-Integrated-Lightning/dp/B01FE8VM8Q/\">the Audeze EL-8</a> and they only have a lightning connector.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 14 Dec 2016 20:06:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}}}}}}}}s:4:\"type\";i:128;s:7:\"headers\";O:42:\"Requests_Utility_CaseInsensitiveDictionary\":1:{s:7:\"\0*\0data\";a:8:{s:6:\"server\";s:5:\"nginx\";s:4:\"date\";s:29:\"Tue, 17 Jan 2017 20:37:18 GMT\";s:12:\"content-type\";s:8:\"text/xml\";s:4:\"vary\";s:15:\"Accept-Encoding\";s:13:\"last-modified\";s:29:\"Tue, 17 Jan 2017 20:15:16 GMT\";s:15:\"x-frame-options\";s:10:\"SAMEORIGIN\";s:4:\"x-nc\";s:11:\"HIT lax 249\";s:16:\"content-encoding\";s:4:\"gzip\";}}s:5:\"build\";s:14:\"20130911090210\";}", "no");
INSERT INTO wpax_options VALUES("46108", "_transient_timeout_feed_mod_d117b5738fbd35bd8c0391cda1f2b5d9", "1484728638", "no");
INSERT INTO wpax_options VALUES("46109", "_transient_feed_mod_d117b5738fbd35bd8c0391cda1f2b5d9", "1484685438", "no");
INSERT INTO wpax_options VALUES("46110", "_transient_timeout_feed_b9388c83948825c1edaef0d856b7b109", "1484728639", "no");
INSERT INTO wpax_options VALUES("46111", "_transient_feed_b9388c83948825c1edaef0d856b7b109", "a:4:{s:5:\"child\";a:1:{s:0:\"\";a:1:{s:3:\"rss\";a:1:{i:0;a:6:{s:4:\"data\";s:3:\"\n	\n\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:7:\"version\";s:3:\"2.0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:1:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:117:\"\n		\n		\n		\n		\n		\n		\n				\n\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n\n	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"WordPress Plugins » View: Popular\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:45:\"https://wordpress.org/plugins/browse/popular/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"WordPress Plugins » View: Popular\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"language\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"en-US\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 17 Jan 2017 20:28:07 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"generator\";a:1:{i:0;a:5:{s:4:\"data\";s:25:\"http://bbpress.org/?v=1.1\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"item\";a:30:{i:0;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"TinyMCE Advanced\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:57:\"https://wordpress.org/plugins/tinymce-advanced/#post-2082\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 27 Jun 2007 15:00:26 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"2082@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:58:\"Extends and enhances TinyMCE, the WordPress Visual Editor.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Andrew Ozz\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:1;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Hello Dolly\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:52:\"https://wordpress.org/plugins/hello-dolly/#post-5790\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 29 May 2008 22:11:34 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"5790@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:150:\"This is not just a plugin, it symbolizes the hope and enthusiasm of an entire generation summed up in two words sung most famously by Louis Armstrong.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Matt Mullenweg\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:2;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:24:\"Jetpack by WordPress.com\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:49:\"https://wordpress.org/plugins/jetpack/#post-23862\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 20 Jan 2011 02:21:38 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"23862@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:107:\"Increase your traffic, view your stats, speed up your site, and protect yourself from hackers with Jetpack.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Automattic\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:3;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Wordfence Security\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:51:\"https://wordpress.org/plugins/wordfence/#post-29832\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sun, 04 Sep 2011 03:13:51 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"29832@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:149:\"Secure your website with the most comprehensive WordPress security plugin. Firewall, malware scan, blocking, live traffic, login security &#38; more.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Wordfence\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:4;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"WooCommerce\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"https://wordpress.org/plugins/woocommerce/#post-29860\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 05 Sep 2011 08:13:36 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"29860@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:97:\"WooCommerce is a powerful, extendable eCommerce plugin that helps you sell anything. Beautifully.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"WooThemes\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:5;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"Clef Two-Factor Authentication\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:48:\"https://wordpress.org/plugins/wpclef/#post-47509\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 27 Dec 2012 01:25:57 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"47509@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:139:\"Modern two-factor that people love to use: strong authentication without passwords or tokens; single sign on/off; magical login experience.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Dave Ross\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:6;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"WP Super Cache\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:55:\"https://wordpress.org/plugins/wp-super-cache/#post-2572\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 05 Nov 2007 11:40:04 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"2572@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:73:\"A very fast caching engine for WordPress that produces static html files.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"Donncha O Caoimh\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:7;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:26:\"Page Builder by SiteOrigin\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:59:\"https://wordpress.org/plugins/siteorigin-panels/#post-51888\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 11 Apr 2013 10:36:42 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"51888@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:111:\"Build responsive page layouts using the widgets you know and love using this simple drag and drop page builder.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Greg Priday\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:8;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:21:\"Really Simple CAPTCHA\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:62:\"https://wordpress.org/plugins/really-simple-captcha/#post-9542\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 09 Mar 2009 02:17:35 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"9542@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:138:\"Really Simple CAPTCHA is a CAPTCHA module intended to be called from other plugins. It is originally created for my Contact Form 7 plugin.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"Takayuki Miyoshi\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:9;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:21:\"Regenerate Thumbnails\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:62:\"https://wordpress.org/plugins/regenerate-thumbnails/#post-6743\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 23 Aug 2008 14:38:58 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"6743@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:76:\"Allows you to regenerate your thumbnails after changing the thumbnail sizes.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:25:\"Alex Mills (Viper007Bond)\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:10;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Duplicate Post\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:55:\"https://wordpress.org/plugins/duplicate-post/#post-2646\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 05 Dec 2007 17:40:03 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"2646@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:22:\"Clone posts and pages.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Lopo\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:11;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Yoast SEO\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:54:\"https://wordpress.org/plugins/wordpress-seo/#post-8321\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 01 Jan 2009 20:34:44 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"8321@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:118:\"Improve your WordPress SEO: Write better content and have a fully optimized WordPress site using the Yoast SEO plugin.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Joost de Valk\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:12;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"Akismet\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:46:\"https://wordpress.org/plugins/akismet/#post-15\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 09 Mar 2007 22:11:30 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"15@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:98:\"Akismet checks your comments against the Akismet Web service to see if they look like spam or not.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Matt Mullenweg\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:13;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"UpdraftPlus WordPress Backup Plugin\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"https://wordpress.org/plugins/updraftplus/#post-38058\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 21 May 2012 15:14:11 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"38058@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:148:\"Backup and restoration made easy. Complete backups; manual or scheduled (backup to S3, Dropbox, Google Drive, Rackspace, FTP, SFTP, email + others).\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"David Anderson\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:14;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"WP-PageNavi\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:51:\"https://wordpress.org/plugins/wp-pagenavi/#post-363\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 09 Mar 2007 23:17:57 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"363@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:49:\"Adds a more advanced paging navigation interface.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Lester Chan\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:15;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:19:\"Google XML Sitemaps\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:64:\"https://wordpress.org/plugins/google-sitemap-generator/#post-132\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 09 Mar 2007 22:31:32 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"132@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:105:\"This plugin will generate a special XML sitemap which will help search engines to better index your blog.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Arne Brachhold\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:16;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:22:\"Advanced Custom Fields\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:64:\"https://wordpress.org/plugins/advanced-custom-fields/#post-25254\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 17 Mar 2011 04:07:30 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"25254@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:68:\"Customise WordPress with powerful, professional and intuitive fields\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"elliotcondon\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:17;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"WordPress Importer\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:60:\"https://wordpress.org/plugins/wordpress-importer/#post-18101\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 20 May 2010 17:42:45 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"18101@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:101:\"Import posts, pages, comments, custom fields, categories, tags and more from a WordPress export file.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Brian Colinger\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:18;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"Google Analytics by MonsterInsights\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:71:\"https://wordpress.org/plugins/google-analytics-for-wordpress/#post-2316\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 14 Sep 2007 12:15:27 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"2316@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:113:\"Connect Google Analytics with WordPress by adding your Google Analytics tracking code. Get the stats that matter.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Syed Balkhi\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:19;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:42:\"NextGEN Gallery - WordPress Gallery Plugin\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://wordpress.org/plugins/nextgen-gallery/#post-1169\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 23 Apr 2007 20:08:06 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"1169@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:121:\"The most popular WordPress gallery plugin and one of the most popular plugins of all time with over 16 million downloads.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Alex Rabe\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:20;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"W3 Total Cache\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://wordpress.org/plugins/w3-total-cache/#post-12073\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 29 Jul 2009 18:46:31 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"12073@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:144:\"Search Engine (SEO) &#38; Performance Optimization (WPO) via caching. Integrated caching: CDN, Minify, Page, Object, Fragment, Database support.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"Frederick Townes\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:21;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:19:\"All in One SEO Pack\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:59:\"https://wordpress.org/plugins/all-in-one-seo-pack/#post-753\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 30 Mar 2007 20:08:18 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"753@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:150:\"One of the most downloaded WordPress plugins (over 30 million downloads since 2007). Use All in One SEO Pack to optimize your site for Search Engines.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"uberdose\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:22;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Contact Form 7\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:55:\"https://wordpress.org/plugins/contact-form-7/#post-2141\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 02 Aug 2007 12:45:03 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"2141@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:54:\"Just another contact form plugin. Simple but flexible.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"Takayuki Miyoshi\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:23;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"Google Analytics Dashboard for WP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:75:\"https://wordpress.org/plugins/google-analytics-dashboard-for-wp/#post-50539\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sun, 10 Mar 2013 17:07:11 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"50539@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:127:\"Displays Google Analytics reports in your WordPress Dashboard. Inserts the latest Google Analytics tracking code in your pages.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Alin Marcu\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:24;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"Disable Comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:58:\"https://wordpress.org/plugins/disable-comments/#post-26907\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 27 May 2011 04:42:58 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"26907@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:150:\"Allows administrators to globally disable comments on their site. Comments can be disabled according to post type. Multisite friendly. Provides tool t\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Samir Shah\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:25;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Duplicator\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:52:\"https://wordpress.org/plugins/duplicator/#post-26607\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 16 May 2011 12:15:41 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"26607@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:88:\"Duplicate, clone, backup, move and transfer an entire site from one location to another.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Cory Lamle\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:26;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"WP Multibyte Patch\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:60:\"https://wordpress.org/plugins/wp-multibyte-patch/#post-28395\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 14 Jul 2011 12:22:53 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"28395@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:71:\"Multibyte functionality enhancement for the WordPress Japanese package.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"plugin-master\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:27;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:27:\"Black Studio TinyMCE Widget\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:69:\"https://wordpress.org/plugins/black-studio-tinymce-widget/#post-31973\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 10 Nov 2011 15:06:14 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"31973@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:39:\"The visual editor widget for Wordpress.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"Marco Chiesi\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:28;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:46:\"iThemes Security (formerly Better WP Security)\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:60:\"https://wordpress.org/plugins/better-wp-security/#post-21738\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 22 Oct 2010 22:06:05 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"21738@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:146:\"Take the guesswork out of WordPress security. iThemes Security offers 30+ ways to lock down WordPress in an easy-to-use WordPress security plugin.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"iThemes\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:29;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:25:\"SiteOrigin Widgets Bundle\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:59:\"https://wordpress.org/plugins/so-widgets-bundle/#post-67824\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 24 May 2014 14:27:05 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"67824@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:128:\"A collection of all widgets, neatly bundled into a single plugin. It&#039;s also a framework to code your own widgets on top of.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Greg Priday\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:4:\"href\";s:46:\"https://wordpress.org/plugins/rss/view/popular\";s:3:\"rel\";s:4:\"self\";s:4:\"type\";s:19:\"application/rss+xml\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}}}}s:4:\"type\";i:128;s:7:\"headers\";O:42:\"Requests_Utility_CaseInsensitiveDictionary\":1:{s:7:\"\0*\0data\";a:9:{s:6:\"server\";s:5:\"nginx\";s:4:\"date\";s:29:\"Tue, 17 Jan 2017 20:37:18 GMT\";s:12:\"content-type\";s:23:\"text/xml; charset=UTF-8\";s:4:\"vary\";s:15:\"Accept-Encoding\";s:25:\"strict-transport-security\";s:11:\"max-age=360\";s:13:\"last-modified\";s:29:\"Wed, 27 Jun 2007 15:00:26 GMT\";s:15:\"x-frame-options\";s:10:\"SAMEORIGIN\";s:4:\"x-nc\";s:11:\"HIT lax 249\";s:16:\"content-encoding\";s:4:\"gzip\";}}s:5:\"build\";s:14:\"20130911090210\";}", "no");
INSERT INTO wpax_options VALUES("46112", "_transient_timeout_feed_mod_b9388c83948825c1edaef0d856b7b109", "1484728639", "no");
INSERT INTO wpax_options VALUES("46113", "_transient_feed_mod_b9388c83948825c1edaef0d856b7b109", "1484685439", "no");
INSERT INTO wpax_options VALUES("46114", "_transient_timeout_plugin_slugs", "1484771889", "no");
INSERT INTO wpax_options VALUES("46115", "_transient_plugin_slugs", "a:10:{i:0;s:45:\"custom-login-page-wp/custom-login-page-wp.php\";i:1;s:35:\"easy-accordion-free/plugin-main.php\";i:2;s:35:\"illdy-companion/illdy-companion.php\";i:3;s:35:\"insert-headers-and-footers/ihaf.php\";i:4;s:19:\"jetpack/jetpack.php\";i:5;s:23:\"loginizer/loginizer.php\";i:6;s:39:\"powr-form-builder/powr-form-builder.php\";i:7;s:57:\"ultimate-form-builder-lite/ultimate-form-builder-lite.php\";i:8;s:23:\"wordfence/wordfence.php\";i:9;s:34:\"wp-clone-by-wp-academy/wpclone.php\";}", "no");
INSERT INTO wpax_options VALUES("46116", "_transient_timeout_dash_88ae138922fe95674369b1cb3d215a2b", "1484728639", "no");
INSERT INTO wpax_options VALUES("46117", "_transient_dash_88ae138922fe95674369b1cb3d215a2b", "<div class=\"rss-widget\"><ul><li><a class=\'rsswidget\' href=\'https://wordpress.org/news/2017/01/wordpress-4-7-1-security-and-maintenance-release/\'>WordPress 4.7.1 Security and Maintenance Release</a> <span class=\"rss-date\">January 11, 2017</span><div class=\"rssSummary\">WordPress 4.7 has been downloaded over 10 million times since its release on December 6, 2016 and we are pleased to announce the immediate availability of WordPress 4.7.1. This is a security release for all previous versions and we strongly encourage you to update your sites immediately. WordPress versions 4.7 and earlier are affected by eight security issues: [&hellip;]</div></li></ul></div><div class=\"rss-widget\"><ul><li><a class=\'rsswidget\' href=\'https://wptavern.com/postmatic-basic-rebrands-as-replyable-moves-two-way-email-commenting-to-saas-product\'>WPTavern: Postmatic Basic Rebrands as Replyable, Moves Two-Way Email Commenting to SaaS Product</a></li><li><a class=\'rsswidget\' href=\'https://wptavern.com/aaron-d-campbell-replaces-nikolay-bachiyski-as-wordpress-security-czar\'>WPTavern: Aaron D. Campbell Replaces Nikolay Bachiyski as WordPress’ Security Czar</a></li><li><a class=\'rsswidget\' href=\'https://wptavern.com/automattic-releases-free-plugin-for-exporting-photos-from-lightroom-to-wordpress\'>WPTavern: Automattic Releases Free Plugin for Exporting Photos from Lightroom to WordPress</a></li></ul></div><div class=\"rss-widget\"><ul><li class=\"dashboard-news-plugin\"><span>Popular Plugin:</span> SiteOrigin Widgets Bundle&nbsp;<a href=\"plugin-install.php?tab=plugin-information&amp;plugin=so-widgets-bundle&amp;_wpnonce=9efd1e39c6&amp;TB_iframe=true&amp;width=600&amp;height=800\" class=\"thickbox open-plugin-details-modal\" aria-label=\"Install SiteOrigin Widgets Bundle\">(Install)</a></li></ul></div>", "no");
INSERT INTO wpax_options VALUES("46118", "jetpack_nonce_1484685439_FiQ6BW3sbg", "1484685440", "no");
INSERT INTO wpax_options VALUES("46122", "_site_transient_timeout_poptags_40cd750bba9870f18aada2478b24840a", "1484696246", "no");
INSERT INTO wpax_options VALUES("46123", "_site_transient_poptags_40cd750bba9870f18aada2478b24840a", "a:100:{s:6:\"widget\";a:3:{s:4:\"name\";s:6:\"widget\";s:4:\"slug\";s:6:\"widget\";s:5:\"count\";s:4:\"6143\";}s:6:\"plugin\";a:3:{s:4:\"name\";s:6:\"plugin\";s:4:\"slug\";s:6:\"plugin\";s:5:\"count\";s:4:\"3767\";}s:4:\"post\";a:3:{s:4:\"name\";s:4:\"Post\";s:4:\"slug\";s:4:\"post\";s:5:\"count\";s:4:\"3761\";}s:5:\"admin\";a:3:{s:4:\"name\";s:5:\"admin\";s:4:\"slug\";s:5:\"admin\";s:5:\"count\";s:4:\"3288\";}s:5:\"posts\";a:3:{s:4:\"name\";s:5:\"posts\";s:4:\"slug\";s:5:\"posts\";s:5:\"count\";s:4:\"2870\";}s:9:\"shortcode\";a:3:{s:4:\"name\";s:9:\"shortcode\";s:4:\"slug\";s:9:\"shortcode\";s:5:\"count\";s:4:\"2575\";}s:7:\"sidebar\";a:3:{s:4:\"name\";s:7:\"sidebar\";s:4:\"slug\";s:7:\"sidebar\";s:5:\"count\";s:4:\"2241\";}s:6:\"google\";a:3:{s:4:\"name\";s:6:\"google\";s:4:\"slug\";s:6:\"google\";s:5:\"count\";s:4:\"2162\";}s:11:\"woocommerce\";a:3:{s:4:\"name\";s:11:\"woocommerce\";s:4:\"slug\";s:11:\"woocommerce\";s:5:\"count\";s:4:\"2152\";}s:4:\"page\";a:3:{s:4:\"name\";s:4:\"page\";s:4:\"slug\";s:4:\"page\";s:5:\"count\";s:4:\"2125\";}s:7:\"twitter\";a:3:{s:4:\"name\";s:7:\"twitter\";s:4:\"slug\";s:7:\"twitter\";s:5:\"count\";s:4:\"2099\";}s:6:\"images\";a:3:{s:4:\"name\";s:6:\"images\";s:4:\"slug\";s:6:\"images\";s:5:\"count\";s:4:\"2056\";}s:8:\"comments\";a:3:{s:4:\"name\";s:8:\"comments\";s:4:\"slug\";s:8:\"comments\";s:5:\"count\";s:4:\"1991\";}s:5:\"image\";a:3:{s:4:\"name\";s:5:\"image\";s:4:\"slug\";s:5:\"image\";s:5:\"count\";s:4:\"1954\";}s:8:\"facebook\";a:3:{s:4:\"name\";s:8:\"Facebook\";s:4:\"slug\";s:8:\"facebook\";s:5:\"count\";s:4:\"1784\";}s:3:\"seo\";a:3:{s:4:\"name\";s:3:\"seo\";s:4:\"slug\";s:3:\"seo\";s:5:\"count\";s:4:\"1678\";}s:9:\"wordpress\";a:3:{s:4:\"name\";s:9:\"wordpress\";s:4:\"slug\";s:9:\"wordpress\";s:5:\"count\";s:4:\"1657\";}s:6:\"social\";a:3:{s:4:\"name\";s:6:\"social\";s:4:\"slug\";s:6:\"social\";s:5:\"count\";s:4:\"1479\";}s:7:\"gallery\";a:3:{s:4:\"name\";s:7:\"gallery\";s:4:\"slug\";s:7:\"gallery\";s:5:\"count\";s:4:\"1398\";}s:5:\"email\";a:3:{s:4:\"name\";s:5:\"email\";s:4:\"slug\";s:5:\"email\";s:5:\"count\";s:4:\"1305\";}s:5:\"links\";a:3:{s:4:\"name\";s:5:\"links\";s:4:\"slug\";s:5:\"links\";s:5:\"count\";s:4:\"1301\";}s:7:\"widgets\";a:3:{s:4:\"name\";s:7:\"widgets\";s:4:\"slug\";s:7:\"widgets\";s:5:\"count\";s:4:\"1164\";}s:5:\"pages\";a:3:{s:4:\"name\";s:5:\"pages\";s:4:\"slug\";s:5:\"pages\";s:5:\"count\";s:4:\"1140\";}s:9:\"ecommerce\";a:3:{s:4:\"name\";s:9:\"ecommerce\";s:4:\"slug\";s:9:\"ecommerce\";s:5:\"count\";s:4:\"1081\";}s:5:\"media\";a:3:{s:4:\"name\";s:5:\"media\";s:4:\"slug\";s:5:\"media\";s:5:\"count\";s:4:\"1034\";}s:6:\"jquery\";a:3:{s:4:\"name\";s:6:\"jquery\";s:4:\"slug\";s:6:\"jquery\";s:5:\"count\";s:4:\"1031\";}s:5:\"video\";a:3:{s:4:\"name\";s:5:\"video\";s:4:\"slug\";s:5:\"video\";s:5:\"count\";s:3:\"986\";}s:7:\"content\";a:3:{s:4:\"name\";s:7:\"content\";s:4:\"slug\";s:7:\"content\";s:5:\"count\";s:3:\"979\";}s:5:\"login\";a:3:{s:4:\"name\";s:5:\"login\";s:4:\"slug\";s:5:\"login\";s:5:\"count\";s:3:\"978\";}s:10:\"responsive\";a:3:{s:4:\"name\";s:10:\"responsive\";s:4:\"slug\";s:10:\"responsive\";s:5:\"count\";s:3:\"948\";}s:4:\"ajax\";a:3:{s:4:\"name\";s:4:\"AJAX\";s:4:\"slug\";s:4:\"ajax\";s:5:\"count\";s:3:\"937\";}s:3:\"rss\";a:3:{s:4:\"name\";s:3:\"rss\";s:4:\"slug\";s:3:\"rss\";s:5:\"count\";s:3:\"918\";}s:8:\"security\";a:3:{s:4:\"name\";s:8:\"security\";s:4:\"slug\";s:8:\"security\";s:5:\"count\";s:3:\"870\";}s:10:\"javascript\";a:3:{s:4:\"name\";s:10:\"javascript\";s:4:\"slug\";s:10:\"javascript\";s:5:\"count\";s:3:\"867\";}s:10:\"e-commerce\";a:3:{s:4:\"name\";s:10:\"e-commerce\";s:4:\"slug\";s:10:\"e-commerce\";s:5:\"count\";s:3:\"864\";}s:10:\"buddypress\";a:3:{s:4:\"name\";s:10:\"buddypress\";s:4:\"slug\";s:10:\"buddypress\";s:5:\"count\";s:3:\"833\";}s:5:\"share\";a:3:{s:4:\"name\";s:5:\"Share\";s:4:\"slug\";s:5:\"share\";s:5:\"count\";s:3:\"798\";}s:7:\"youtube\";a:3:{s:4:\"name\";s:7:\"youtube\";s:4:\"slug\";s:7:\"youtube\";s:5:\"count\";s:3:\"791\";}s:5:\"photo\";a:3:{s:4:\"name\";s:5:\"photo\";s:4:\"slug\";s:5:\"photo\";s:5:\"count\";s:3:\"790\";}s:4:\"spam\";a:3:{s:4:\"name\";s:4:\"spam\";s:4:\"slug\";s:4:\"spam\";s:5:\"count\";s:3:\"773\";}s:4:\"link\";a:3:{s:4:\"name\";s:4:\"link\";s:4:\"slug\";s:4:\"link\";s:5:\"count\";s:3:\"766\";}s:6:\"slider\";a:3:{s:4:\"name\";s:6:\"slider\";s:4:\"slug\";s:6:\"slider\";s:5:\"count\";s:3:\"759\";}s:9:\"analytics\";a:3:{s:4:\"name\";s:9:\"analytics\";s:4:\"slug\";s:9:\"analytics\";s:5:\"count\";s:3:\"757\";}s:4:\"feed\";a:3:{s:4:\"name\";s:4:\"feed\";s:4:\"slug\";s:4:\"feed\";s:5:\"count\";s:3:\"754\";}s:3:\"css\";a:3:{s:4:\"name\";s:3:\"CSS\";s:4:\"slug\";s:3:\"css\";s:5:\"count\";s:3:\"750\";}s:4:\"form\";a:3:{s:4:\"name\";s:4:\"form\";s:4:\"slug\";s:4:\"form\";s:5:\"count\";s:3:\"747\";}s:8:\"category\";a:3:{s:4:\"name\";s:8:\"category\";s:4:\"slug\";s:8:\"category\";s:5:\"count\";s:3:\"738\";}s:6:\"search\";a:3:{s:4:\"name\";s:6:\"search\";s:4:\"slug\";s:6:\"search\";s:5:\"count\";s:3:\"736\";}s:5:\"embed\";a:3:{s:4:\"name\";s:5:\"embed\";s:4:\"slug\";s:5:\"embed\";s:5:\"count\";s:3:\"733\";}s:6:\"custom\";a:3:{s:4:\"name\";s:6:\"custom\";s:4:\"slug\";s:6:\"custom\";s:5:\"count\";s:3:\"724\";}s:6:\"photos\";a:3:{s:4:\"name\";s:6:\"photos\";s:4:\"slug\";s:6:\"photos\";s:5:\"count\";s:3:\"712\";}s:4:\"menu\";a:3:{s:4:\"name\";s:4:\"menu\";s:4:\"slug\";s:4:\"menu\";s:5:\"count\";s:3:\"660\";}s:9:\"slideshow\";a:3:{s:4:\"name\";s:9:\"slideshow\";s:4:\"slug\";s:9:\"slideshow\";s:5:\"count\";s:3:\"657\";}s:6:\"button\";a:3:{s:4:\"name\";s:6:\"button\";s:4:\"slug\";s:6:\"button\";s:5:\"count\";s:3:\"652\";}s:5:\"stats\";a:3:{s:4:\"name\";s:5:\"stats\";s:4:\"slug\";s:5:\"stats\";s:5:\"count\";s:3:\"642\";}s:5:\"theme\";a:3:{s:4:\"name\";s:5:\"theme\";s:4:\"slug\";s:5:\"theme\";s:5:\"count\";s:3:\"640\";}s:9:\"dashboard\";a:3:{s:4:\"name\";s:9:\"dashboard\";s:4:\"slug\";s:9:\"dashboard\";s:5:\"count\";s:3:\"629\";}s:6:\"mobile\";a:3:{s:4:\"name\";s:6:\"mobile\";s:4:\"slug\";s:6:\"mobile\";s:5:\"count\";s:3:\"624\";}s:7:\"comment\";a:3:{s:4:\"name\";s:7:\"comment\";s:4:\"slug\";s:7:\"comment\";s:5:\"count\";s:3:\"620\";}s:4:\"tags\";a:3:{s:4:\"name\";s:4:\"tags\";s:4:\"slug\";s:4:\"tags\";s:5:\"count\";s:3:\"617\";}s:10:\"categories\";a:3:{s:4:\"name\";s:10:\"categories\";s:4:\"slug\";s:10:\"categories\";s:5:\"count\";s:3:\"603\";}s:10:\"statistics\";a:3:{s:4:\"name\";s:10:\"statistics\";s:4:\"slug\";s:10:\"statistics\";s:5:\"count\";s:3:\"596\";}s:6:\"editor\";a:3:{s:4:\"name\";s:6:\"editor\";s:4:\"slug\";s:6:\"editor\";s:5:\"count\";s:3:\"592\";}s:4:\"user\";a:3:{s:4:\"name\";s:4:\"user\";s:4:\"slug\";s:4:\"user\";s:5:\"count\";s:3:\"592\";}s:3:\"ads\";a:3:{s:4:\"name\";s:3:\"ads\";s:4:\"slug\";s:3:\"ads\";s:5:\"count\";s:3:\"589\";}s:12:\"social-media\";a:3:{s:4:\"name\";s:12:\"social media\";s:4:\"slug\";s:12:\"social-media\";s:5:\"count\";s:3:\"579\";}s:5:\"users\";a:3:{s:4:\"name\";s:5:\"users\";s:4:\"slug\";s:5:\"users\";s:5:\"count\";s:3:\"562\";}s:4:\"list\";a:3:{s:4:\"name\";s:4:\"list\";s:4:\"slug\";s:4:\"list\";s:5:\"count\";s:3:\"562\";}s:12:\"contact-form\";a:3:{s:4:\"name\";s:12:\"contact form\";s:4:\"slug\";s:12:\"contact-form\";s:5:\"count\";s:3:\"557\";}s:9:\"affiliate\";a:3:{s:4:\"name\";s:9:\"affiliate\";s:4:\"slug\";s:9:\"affiliate\";s:5:\"count\";s:3:\"550\";}s:6:\"simple\";a:3:{s:4:\"name\";s:6:\"simple\";s:4:\"slug\";s:6:\"simple\";s:5:\"count\";s:3:\"547\";}s:7:\"plugins\";a:3:{s:4:\"name\";s:7:\"plugins\";s:4:\"slug\";s:7:\"plugins\";s:5:\"count\";s:3:\"543\";}s:9:\"multisite\";a:3:{s:4:\"name\";s:9:\"multisite\";s:4:\"slug\";s:9:\"multisite\";s:5:\"count\";s:3:\"536\";}s:4:\"shop\";a:3:{s:4:\"name\";s:4:\"shop\";s:4:\"slug\";s:4:\"shop\";s:5:\"count\";s:3:\"527\";}s:7:\"picture\";a:3:{s:4:\"name\";s:7:\"picture\";s:4:\"slug\";s:7:\"picture\";s:5:\"count\";s:3:\"524\";}s:9:\"marketing\";a:3:{s:4:\"name\";s:9:\"marketing\";s:4:\"slug\";s:9:\"marketing\";s:5:\"count\";s:3:\"519\";}s:3:\"api\";a:3:{s:4:\"name\";s:3:\"api\";s:4:\"slug\";s:3:\"api\";s:5:\"count\";s:3:\"515\";}s:7:\"contact\";a:3:{s:4:\"name\";s:7:\"contact\";s:4:\"slug\";s:7:\"contact\";s:5:\"count\";s:3:\"510\";}s:3:\"url\";a:3:{s:4:\"name\";s:3:\"url\";s:4:\"slug\";s:3:\"url\";s:5:\"count\";s:3:\"491\";}s:10:\"newsletter\";a:3:{s:4:\"name\";s:10:\"newsletter\";s:4:\"slug\";s:10:\"newsletter\";s:5:\"count\";s:3:\"472\";}s:10:\"navigation\";a:3:{s:4:\"name\";s:10:\"navigation\";s:4:\"slug\";s:10:\"navigation\";s:5:\"count\";s:3:\"470\";}s:8:\"pictures\";a:3:{s:4:\"name\";s:8:\"pictures\";s:4:\"slug\";s:8:\"pictures\";s:5:\"count\";s:3:\"468\";}s:6:\"events\";a:3:{s:4:\"name\";s:6:\"events\";s:4:\"slug\";s:6:\"events\";s:5:\"count\";s:3:\"468\";}s:4:\"html\";a:3:{s:4:\"name\";s:4:\"html\";s:4:\"slug\";s:4:\"html\";s:5:\"count\";s:3:\"467\";}s:8:\"tracking\";a:3:{s:4:\"name\";s:8:\"tracking\";s:4:\"slug\";s:8:\"tracking\";s:5:\"count\";s:3:\"455\";}s:10:\"shortcodes\";a:3:{s:4:\"name\";s:10:\"shortcodes\";s:4:\"slug\";s:10:\"shortcodes\";s:5:\"count\";s:3:\"454\";}s:4:\"meta\";a:3:{s:4:\"name\";s:4:\"meta\";s:4:\"slug\";s:4:\"meta\";s:5:\"count\";s:3:\"445\";}s:8:\"calendar\";a:3:{s:4:\"name\";s:8:\"calendar\";s:4:\"slug\";s:8:\"calendar\";s:5:\"count\";s:3:\"444\";}s:11:\"advertising\";a:3:{s:4:\"name\";s:11:\"advertising\";s:4:\"slug\";s:11:\"advertising\";s:5:\"count\";s:3:\"438\";}s:3:\"tag\";a:3:{s:4:\"name\";s:3:\"tag\";s:4:\"slug\";s:3:\"tag\";s:5:\"count\";s:3:\"436\";}s:8:\"lightbox\";a:3:{s:4:\"name\";s:8:\"lightbox\";s:4:\"slug\";s:8:\"lightbox\";s:5:\"count\";s:3:\"432\";}s:9:\"thumbnail\";a:3:{s:4:\"name\";s:9:\"thumbnail\";s:4:\"slug\";s:9:\"thumbnail\";s:5:\"count\";s:3:\"429\";}s:12:\"notification\";a:3:{s:4:\"name\";s:12:\"notification\";s:4:\"slug\";s:12:\"notification\";s:5:\"count\";s:3:\"429\";}s:6:\"upload\";a:3:{s:4:\"name\";s:6:\"upload\";s:4:\"slug\";s:6:\"upload\";s:5:\"count\";s:3:\"427\";}s:7:\"sharing\";a:3:{s:4:\"name\";s:7:\"sharing\";s:4:\"slug\";s:7:\"sharing\";s:5:\"count\";s:3:\"425\";}s:6:\"paypal\";a:3:{s:4:\"name\";s:6:\"paypal\";s:4:\"slug\";s:6:\"paypal\";s:5:\"count\";s:3:\"425\";}s:4:\"news\";a:3:{s:4:\"name\";s:4:\"News\";s:4:\"slug\";s:4:\"news\";s:5:\"count\";s:3:\"422\";}s:8:\"linkedin\";a:3:{s:4:\"name\";s:8:\"linkedin\";s:4:\"slug\";s:8:\"linkedin\";s:5:\"count\";s:3:\"421\";}s:16:\"custom-post-type\";a:3:{s:4:\"name\";s:16:\"custom post type\";s:4:\"slug\";s:16:\"custom-post-type\";s:5:\"count\";s:3:\"420\";}s:5:\"flash\";a:3:{s:4:\"name\";s:5:\"flash\";s:4:\"slug\";s:5:\"flash\";s:5:\"count\";s:3:\"420\";}}", "no");
INSERT INTO wpax_options VALUES("46144", "_transient_timeout_jpp_li_4dc5b13fad991b88536280d415fa8250", "1484688925", "no");
INSERT INTO wpax_options VALUES("46145", "_transient_jpp_li_4dc5b13fad991b88536280d415fa8250", "a:5:{s:6:\"status\";s:7:\"blocked\";s:3:\"msg\";s:44:\"This IP is currently blocked (77.51.172.169)\";s:17:\"seconds_remaining\";i:3436;s:16:\"blocked_attempts\";s:4:\"9756\";s:6:\"expire\";i:1484688925;}", "no");
INSERT INTO wpax_options VALUES("46179", "_site_transient_update_plugins", "O:8:\"stdClass\":4:{s:12:\"last_checked\";i:1484685527;s:8:\"response\";a:0:{}s:12:\"translations\";a:0:{}s:9:\"no_update\";a:10:{s:45:\"custom-login-page-wp/custom-login-page-wp.php\";O:8:\"stdClass\":6:{s:2:\"id\";s:5:\"74176\";s:4:\"slug\";s:20:\"custom-login-page-wp\";s:6:\"plugin\";s:45:\"custom-login-page-wp/custom-login-page-wp.php\";s:11:\"new_version\";s:5:\"1.0.3\";s:3:\"url\";s:51:\"https://wordpress.org/plugins/custom-login-page-wp/\";s:7:\"package\";s:69:\"https://downloads.wordpress.org/plugin/custom-login-page-wp.1.0.3.zip\";}s:35:\"easy-accordion-free/plugin-main.php\";O:8:\"stdClass\":6:{s:2:\"id\";s:5:\"52507\";s:4:\"slug\";s:19:\"easy-accordion-free\";s:6:\"plugin\";s:35:\"easy-accordion-free/plugin-main.php\";s:11:\"new_version\";s:3:\"1.2\";s:3:\"url\";s:50:\"https://wordpress.org/plugins/easy-accordion-free/\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/plugin/easy-accordion-free.zip\";}s:35:\"illdy-companion/illdy-companion.php\";O:8:\"stdClass\":6:{s:2:\"id\";s:5:\"75502\";s:4:\"slug\";s:15:\"illdy-companion\";s:6:\"plugin\";s:35:\"illdy-companion/illdy-companion.php\";s:11:\"new_version\";s:5:\"1.0.4\";s:3:\"url\";s:46:\"https://wordpress.org/plugins/illdy-companion/\";s:7:\"package\";s:58:\"https://downloads.wordpress.org/plugin/illdy-companion.zip\";}s:35:\"insert-headers-and-footers/ihaf.php\";O:8:\"stdClass\":6:{s:2:\"id\";s:5:\"33017\";s:4:\"slug\";s:26:\"insert-headers-and-footers\";s:6:\"plugin\";s:35:\"insert-headers-and-footers/ihaf.php\";s:11:\"new_version\";s:5:\"1.3.3\";s:3:\"url\";s:57:\"https://wordpress.org/plugins/insert-headers-and-footers/\";s:7:\"package\";s:69:\"https://downloads.wordpress.org/plugin/insert-headers-and-footers.zip\";}s:19:\"jetpack/jetpack.php\";O:8:\"stdClass\":6:{s:2:\"id\";s:5:\"20101\";s:4:\"slug\";s:7:\"jetpack\";s:6:\"plugin\";s:19:\"jetpack/jetpack.php\";s:11:\"new_version\";s:3:\"4.5\";s:3:\"url\";s:38:\"https://wordpress.org/plugins/jetpack/\";s:7:\"package\";s:54:\"https://downloads.wordpress.org/plugin/jetpack.4.5.zip\";}s:23:\"loginizer/loginizer.php\";O:8:\"stdClass\":6:{s:2:\"id\";s:5:\"68468\";s:4:\"slug\";s:9:\"loginizer\";s:6:\"plugin\";s:23:\"loginizer/loginizer.php\";s:11:\"new_version\";s:5:\"1.3.2\";s:3:\"url\";s:40:\"https://wordpress.org/plugins/loginizer/\";s:7:\"package\";s:58:\"https://downloads.wordpress.org/plugin/loginizer.1.3.2.zip\";}s:39:\"powr-form-builder/powr-form-builder.php\";O:8:\"stdClass\":7:{s:2:\"id\";s:5:\"47061\";s:4:\"slug\";s:17:\"powr-form-builder\";s:6:\"plugin\";s:39:\"powr-form-builder/powr-form-builder.php\";s:11:\"new_version\";s:5:\"1.6.2\";s:3:\"url\";s:48:\"https://wordpress.org/plugins/powr-form-builder/\";s:7:\"package\";s:60:\"https://downloads.wordpress.org/plugin/powr-form-builder.zip\";s:14:\"upgrade_notice\";s:56:\"Bug Fixes (resolved some PHP notices seen by some users)\";}s:57:\"ultimate-form-builder-lite/ultimate-form-builder-lite.php\";O:8:\"stdClass\":6:{s:2:\"id\";s:5:\"64085\";s:4:\"slug\";s:26:\"ultimate-form-builder-lite\";s:6:\"plugin\";s:57:\"ultimate-form-builder-lite/ultimate-form-builder-lite.php\";s:11:\"new_version\";s:5:\"1.3.1\";s:3:\"url\";s:57:\"https://wordpress.org/plugins/ultimate-form-builder-lite/\";s:7:\"package\";s:75:\"https://downloads.wordpress.org/plugin/ultimate-form-builder-lite.1.3.1.zip\";}s:23:\"wordfence/wordfence.php\";O:8:\"stdClass\":6:{s:2:\"id\";s:5:\"25305\";s:4:\"slug\";s:9:\"wordfence\";s:6:\"plugin\";s:23:\"wordfence/wordfence.php\";s:11:\"new_version\";s:6:\"6.2.10\";s:3:\"url\";s:40:\"https://wordpress.org/plugins/wordfence/\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/plugin/wordfence.6.2.10.zip\";}s:34:\"wp-clone-by-wp-academy/wpclone.php\";O:8:\"stdClass\":6:{s:2:\"id\";s:5:\"37091\";s:4:\"slug\";s:22:\"wp-clone-by-wp-academy\";s:6:\"plugin\";s:34:\"wp-clone-by-wp-academy/wpclone.php\";s:11:\"new_version\";s:5:\"2.2.3\";s:3:\"url\";s:53:\"https://wordpress.org/plugins/wp-clone-by-wp-academy/\";s:7:\"package\";s:71:\"https://downloads.wordpress.org/plugin/wp-clone-by-wp-academy.2.2.3.zip\";}}}", "no");
INSERT INTO wpax_options VALUES("46184", "_transient_timeout_jetpack_sync_callables_await", "1484685588", "no");
INSERT INTO wpax_options VALUES("46185", "_transient_jetpack_sync_callables_await", "1484685528.54", "no");
INSERT INTO wpax_options VALUES("46188", "widget_authors", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO wpax_options VALUES("46189", "widget_milestone_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO wpax_options VALUES("46190", "widget_upcoming_events_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO wpax_options VALUES("46192", "jetpack_sync_settings_cron_sync_time_limit", "30", "yes");
INSERT INTO wpax_options VALUES("46193", "_transient_timeout_feed_a41fbee65e190c85018f9081fcc3dfc4", "1484728738", "no");
INSERT INTO wpax_options VALUES("46194", "_transient_feed_a41fbee65e190c85018f9081fcc3dfc4", "a:4:{s:5:\"child\";a:1:{s:0:\"\";a:1:{s:3:\"rss\";a:1:{i:0;a:6:{s:4:\"data\";s:3:\"\n\n\n\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:7:\"version\";s:3:\"2.0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:1:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:22:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:3:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:19:\"News – WP Academy\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://members.wpacademy.com\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"WordPress Training\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:13:\"lastBuildDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 10 Jan 2017 14:17:41 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"language\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"en-US\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"item\";a:1:{i:0;a:6:{s:4:\"data\";s:33:\"\n		\n		\n		\n		\n				\n\n		\n		\n				\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:3:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:57:\"Learn the Getting Things Done (GTD®) Productivity System\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:91:\"http://members.wpacademy.com/2016/05/learn-the-getting-things-done-gtd-productivity-system/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 06 May 2016 10:56:27 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"News\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:37:\"http://members.wpacademy.com/?p=20246\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:617:\"<p>I am thrilled to present my latest course, Get It Done with IQTell: Best App for GTD® and Inbox Zero, for free &#8212; but only during the launch period.  Sign-up now before this course become paid!  And please leave a positive review if you like it. David Allen&#8217;s Getting Things Done(®) or GTD® system is [&#8230;]</p>\n<p>The post <a rel=\"nofollow\" href=\"http://members.wpacademy.com/2016/05/learn-the-getting-things-done-gtd-productivity-system/\">Learn the Getting Things Done (GTD®) Productivity System</a> appeared first on <a rel=\"nofollow\" href=\"http://members.wpacademy.com\">WP Academy</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"marc\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:3880:\"<p>I am thrilled to present my latest course, <strong><a href=\"https://www.udemy.com/gettingthingsdone/\">Get It Done with IQTell: Best App for GTD® and Inbox Zero</a></strong>, for free &#8212; but only during the launch period.  Sign-up now before this course become paid!  And please leave a positive review if you like it.</p>\n<p><a href=\"https://www.udemy.com/gettingthingsdone/\"><img class=\"aligncenter size-full wp-image-20247\" src=\"http://members.wpacademy.com/wp-content/uploads/2016/05/get-it-done-with-iqtell-video.jpg\" alt=\"get-it-done-with-iqtell-video\" width=\"400\" height=\"253\" srcset=\"http://members.wpacademy.com/wp-content/uploads/2016/05/get-it-done-with-iqtell-video.jpg 400w, http://members.wpacademy.com/wp-content/uploads/2016/05/get-it-done-with-iqtell-video-300x190.jpg 300w\" sizes=\"(max-width: 400px) 100vw, 400px\" /></a></p>\n<p>David Allen&#8217;s <strong class=\"redactor-inline-converted\">Getting Things Done(®)</strong> or <strong class=\"redactor-inline-converted\">GTD® </strong>system is a world-famous productivity system. <strong class=\"redactor-inline-converted\"><a href=\"http://iqtell.com/?eu=o5z7e\"> IQTell®</a>  </strong>is one of the leading software implementations of the GTD model. Learn both in under an hour in this fast-paced training sequence, which is guaranteed to give you concepts and tools that will change your life, or money-back!</p>\n<p>Being productive requires a <em class=\"redactor-inline-converted\">mindset, a system, and a tool.</em>  GTD provides the <em class=\"redactor-inline-converted\">mindset </em>and the <em class=\"redactor-inline-converted\">system</em>, and is a powerful model for managing tasks, goals and ideas &#8212; all the things that your life is made of, and upon which your success depends. <a href=\"http://iqtell.com/?eu=o5z7e\">IQTell</a> provides the <em class=\"redactor-inline-converted\">tool</em>.  IQTell is a great implementation of the GTD model and is a very useful management tool for any system.</p>\n<p><strong class=\"redactor-inline-converted\">Here is what you will learn: </strong></p>\n<ul>\n<li>A conceptual and practical understanding of the GTD® system</li>\n<li>We will put the IQTell software in context, comparing it with other applications designed for GTD, CRM (Customer Relationship Management) and Project Management&#8230;</li>\n<li>And then guide you step-by-step through the IQTell software into a complete GTD implementation for your business or personal life&#8230;</li>\n<li>Which will more than likely change the way you organize and run your business and your life, because you will learn both a method and a tool in which all the data you need is in a single place and organized how you want it</li>\n<li>Anybody can benefit from this information: students, entrepreneurs, contractors, clergy, moms</li>\n<li>The only requirement for getting something out of this course is that you have work to do and that you want to better manage, prioritize, or reflect on your current tasks and life goals!</li>\n</ul>\n<p><strong class=\"redactor-inline-converted\">GTD is the world&#8217;s most famous productivity system&#8230;</strong></p>\n<p>But it&#8217;s also famously complex and difficult to understand and implement.  But not any more! With the quick and yet comprehensive GTD summaries provided in this course, and the help of the <a href=\"http://iqtell.com/?eu=o5z7e\">IQTell</a> software, you will be well on your way to what we call &#8220;Productivity Holy Grail&#8221;</p>\n<p><a href=\"https://www.udemy.com/gettingthingsdone/\">Get the course for free during the launch period!</a></p>\n<p>The post <a rel=\"nofollow\" href=\"http://members.wpacademy.com/2016/05/learn-the-getting-things-done-gtd-productivity-system/\">Learn the Getting Things Done (GTD®) Productivity System</a> appeared first on <a rel=\"nofollow\" href=\"http://members.wpacademy.com\">WP Academy</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:4:\"href\";s:48:\"http://members.wpacademy.com/category/news/feed/\";s:3:\"rel\";s:4:\"self\";s:4:\"type\";s:19:\"application/rss+xml\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:44:\"http://purl.org/rss/1.0/modules/syndication/\";a:2:{s:12:\"updatePeriod\";a:1:{i:0;a:5:{s:4:\"data\";s:6:\"hourly\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:15:\"updateFrequency\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"1\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}}}}s:4:\"type\";i:128;s:7:\"headers\";O:42:\"Requests_Utility_CaseInsensitiveDictionary\":1:{s:7:\"\0*\0data\";a:9:{s:13:\"last-modified\";s:29:\"Tue, 10 Jan 2017 14:17:41 GMT\";s:4:\"etag\";s:34:\"\"c5a9805171e95573366c2431fe0a2817\"\";s:12:\"x-robots-tag\";s:15:\"noindex, follow\";s:4:\"link\";s:65:\"<http://members.wpacademy.com/wp-json/>; rel=\"https://api.w.org/\"\";s:12:\"content-type\";s:34:\"application/rss+xml; charset=UTF-8\";s:14:\"content-length\";s:4:\"5821\";s:4:\"date\";s:29:\"Tue, 17 Jan 2017 20:38:58 GMT\";s:13:\"accept-ranges\";s:5:\"bytes\";s:6:\"server\";s:9:\"LiteSpeed\";}}s:5:\"build\";s:14:\"20130911090210\";}", "no");
INSERT INTO wpax_options VALUES("46195", "_transient_timeout_feed_mod_a41fbee65e190c85018f9081fcc3dfc4", "1484728738", "no");
INSERT INTO wpax_options VALUES("46196", "_transient_feed_mod_a41fbee65e190c85018f9081fcc3dfc4", "1484685538", "no");
INSERT INTO wpax_options VALUES("46197", "wpclone_directory_scan", "a:4:{s:6:\"dbsize\";s:7:\"6.27 MB\";s:4:\"size\";s:8:\"50.42 MB\";s:5:\"files\";i:3651;s:4:\"time\";i:1484685542;}", "yes");

DROP TABLE IF EXISTS wpax_postmeta;

CREATE TABLE `wpax_postmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=752 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO wpax_postmeta VALUES("1", "2", "_wp_page_template", "default");
INSERT INTO wpax_postmeta VALUES("46", "24", "_wp_attached_file", "2016/12/new-york-city-guide.jpg");
INSERT INTO wpax_postmeta VALUES("47", "24", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:2560;s:6:\"height\";i:1280;s:4:\"file\";s:31:\"2016/12/new-york-city-guide.jpg\";s:5:\"sizes\";a:7:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:31:\"new-york-city-guide-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:31:\"new-york-city-guide-300x150.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:31:\"new-york-city-guide-768x384.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:384;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:32:\"new-york-city-guide-1024x512.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:512;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:31:\"new-york-city-guide-604x270.jpg\";s:5:\"width\";i:604;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"slider-thumb\";a:4:{s:4:\"file\";s:31:\"new-york-city-guide-608x300.jpg\";s:5:\"width\";i:608;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"main-slider\";a:4:{s:4:\"file\";s:32:\"new-york-city-guide-1920x900.jpg\";s:5:\"width\";i:1920;s:6:\"height\";i:900;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO wpax_postmeta VALUES("48", "25", "_wp_attached_file", "2016/12/cropped-new-york-city-guide.jpg");
INSERT INTO wpax_postmeta VALUES("49", "25", "_wp_attachment_context", "fruitful-theme-options[header-img]");
INSERT INTO wpax_postmeta VALUES("50", "25", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:198;s:6:\"height\";i:80;s:4:\"file\";s:39:\"2016/12/cropped-new-york-city-guide.jpg\";s:5:\"sizes\";a:1:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:38:\"cropped-new-york-city-guide-150x80.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO wpax_postmeta VALUES("66", "35", "_edit_last", "1");
INSERT INTO wpax_postmeta VALUES("67", "35", "_edit_lock", "1482518925:1");
INSERT INTO wpax_postmeta VALUES("68", "35", "_wp_page_template", "default");
INSERT INTO wpax_postmeta VALUES("217", "70", "_edit_lock", "1481870807:1");
INSERT INTO wpax_postmeta VALUES("218", "70", "_edit_last", "1");
INSERT INTO wpax_postmeta VALUES("219", "70", "cuar_owner_queryable", "|usr_2|");
INSERT INTO wpax_postmeta VALUES("220", "70", "cuar_owner_displayname", "a:1:{s:3:\"usr\";s:11:\"Test Client\";}");
INSERT INTO wpax_postmeta VALUES("221", "70", "cuar_owner_sortable_displayname", "User - Test Client");
INSERT INTO wpax_postmeta VALUES("222", "70", "cuar_private_file_file", "a:0:{}");
INSERT INTO wpax_postmeta VALUES("223", "71", "cuar_user_id", "0");
INSERT INTO wpax_postmeta VALUES("224", "71", "cuar_ip", "100.38.10.251");
INSERT INTO wpax_postmeta VALUES("225", "71", "cuar_related_object_type", "WP_User");
INSERT INTO wpax_postmeta VALUES("226", "72", "cuar_user_id", "2");
INSERT INTO wpax_postmeta VALUES("227", "72", "cuar_ip", "100.38.10.251");
INSERT INTO wpax_postmeta VALUES("228", "72", "cuar_related_object_type", "cuar_private_file");
INSERT INTO wpax_postmeta VALUES("231", "74", "_wp_attached_file", "2016/12/GramGro01.jpg");
INSERT INTO wpax_postmeta VALUES("232", "74", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:4000;s:6:\"height\";i:2333;s:4:\"file\";s:21:\"2016/12/GramGro01.jpg\";s:5:\"sizes\";a:12:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:21:\"GramGro01-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:21:\"GramGro01-300x175.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:175;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:21:\"GramGro01-768x448.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:448;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:22:\"GramGro01-1024x597.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:597;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"wpca-thumb\";a:4:{s:4:\"file\";s:21:\"GramGro01-220x150.jpg\";s:5:\"width\";i:220;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"illdy-blog-list\";a:4:{s:4:\"file\";s:21:\"GramGro01-750x500.jpg\";s:5:\"width\";i:750;s:6:\"height\";i:500;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:25:\"illdy-widget-recent-posts\";a:4:{s:4:\"file\";s:19:\"GramGro01-70x70.jpg\";s:5:\"width\";i:70;s:6:\"height\";i:70;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:32:\"illdy-blog-post-related-articles\";a:4:{s:4:\"file\";s:21:\"GramGro01-240x206.jpg\";s:5:\"width\";i:240;s:6:\"height\";i:206;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:28:\"illdy-front-page-latest-news\";a:4:{s:4:\"file\";s:21:\"GramGro01-360x213.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:213;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:29:\"illdy-front-page-testimonials\";a:4:{s:4:\"file\";s:21:\"GramGro01-127x127.jpg\";s:5:\"width\";i:127;s:6:\"height\";i:127;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:25:\"illdy-front-page-projects\";a:4:{s:4:\"file\";s:21:\"GramGro01-476x476.jpg\";s:5:\"width\";i:476;s:6:\"height\";i:476;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:23:\"illdy-front-page-person\";a:4:{s:4:\"file\";s:21:\"GramGro01-125x125.jpg\";s:5:\"width\";i:125;s:6:\"height\";i:125;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO wpax_postmeta VALUES("235", "76", "_wp_attached_file", "2016/12/GramGro01.png");
INSERT INTO wpax_postmeta VALUES("236", "76", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:4000;s:6:\"height\";i:2333;s:4:\"file\";s:21:\"2016/12/GramGro01.png\";s:5:\"sizes\";a:12:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:21:\"GramGro01-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"medium\";a:4:{s:4:\"file\";s:21:\"GramGro01-300x175.png\";s:5:\"width\";i:300;s:6:\"height\";i:175;s:9:\"mime-type\";s:9:\"image/png\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:21:\"GramGro01-768x448.png\";s:5:\"width\";i:768;s:6:\"height\";i:448;s:9:\"mime-type\";s:9:\"image/png\";}s:5:\"large\";a:4:{s:4:\"file\";s:22:\"GramGro01-1024x597.png\";s:5:\"width\";i:1024;s:6:\"height\";i:597;s:9:\"mime-type\";s:9:\"image/png\";}s:10:\"wpca-thumb\";a:4:{s:4:\"file\";s:21:\"GramGro01-220x150.png\";s:5:\"width\";i:220;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}s:15:\"illdy-blog-list\";a:4:{s:4:\"file\";s:21:\"GramGro01-750x500.png\";s:5:\"width\";i:750;s:6:\"height\";i:500;s:9:\"mime-type\";s:9:\"image/png\";}s:25:\"illdy-widget-recent-posts\";a:4:{s:4:\"file\";s:19:\"GramGro01-70x70.png\";s:5:\"width\";i:70;s:6:\"height\";i:70;s:9:\"mime-type\";s:9:\"image/png\";}s:32:\"illdy-blog-post-related-articles\";a:4:{s:4:\"file\";s:21:\"GramGro01-240x206.png\";s:5:\"width\";i:240;s:6:\"height\";i:206;s:9:\"mime-type\";s:9:\"image/png\";}s:28:\"illdy-front-page-latest-news\";a:4:{s:4:\"file\";s:21:\"GramGro01-360x213.png\";s:5:\"width\";i:360;s:6:\"height\";i:213;s:9:\"mime-type\";s:9:\"image/png\";}s:29:\"illdy-front-page-testimonials\";a:4:{s:4:\"file\";s:21:\"GramGro01-127x127.png\";s:5:\"width\";i:127;s:6:\"height\";i:127;s:9:\"mime-type\";s:9:\"image/png\";}s:25:\"illdy-front-page-projects\";a:4:{s:4:\"file\";s:21:\"GramGro01-476x476.png\";s:5:\"width\";i:476;s:6:\"height\";i:476;s:9:\"mime-type\";s:9:\"image/png\";}s:23:\"illdy-front-page-person\";a:4:{s:4:\"file\";s:21:\"GramGro01-125x125.png\";s:5:\"width\";i:125;s:6:\"height\";i:125;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO wpax_postmeta VALUES("237", "2", "_edit_lock", "1482446316:1");
INSERT INTO wpax_postmeta VALUES("248", "84", "_wp_attached_file", "2016/12/cropped-GramGro01.png");
INSERT INTO wpax_postmeta VALUES("249", "84", "_wp_attachment_context", "custom-logo");
INSERT INTO wpax_postmeta VALUES("250", "84", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:965;s:6:\"height\";i:980;s:4:\"file\";s:29:\"2016/12/cropped-GramGro01.png\";s:5:\"sizes\";a:11:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:29:\"cropped-GramGro01-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"medium\";a:4:{s:4:\"file\";s:29:\"cropped-GramGro01-295x300.png\";s:5:\"width\";i:295;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:29:\"cropped-GramGro01-768x780.png\";s:5:\"width\";i:768;s:6:\"height\";i:780;s:9:\"mime-type\";s:9:\"image/png\";}s:10:\"wpca-thumb\";a:4:{s:4:\"file\";s:29:\"cropped-GramGro01-220x150.png\";s:5:\"width\";i:220;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}s:15:\"illdy-blog-list\";a:4:{s:4:\"file\";s:29:\"cropped-GramGro01-750x500.png\";s:5:\"width\";i:750;s:6:\"height\";i:500;s:9:\"mime-type\";s:9:\"image/png\";}s:25:\"illdy-widget-recent-posts\";a:4:{s:4:\"file\";s:27:\"cropped-GramGro01-70x70.png\";s:5:\"width\";i:70;s:6:\"height\";i:70;s:9:\"mime-type\";s:9:\"image/png\";}s:32:\"illdy-blog-post-related-articles\";a:4:{s:4:\"file\";s:29:\"cropped-GramGro01-240x206.png\";s:5:\"width\";i:240;s:6:\"height\";i:206;s:9:\"mime-type\";s:9:\"image/png\";}s:28:\"illdy-front-page-latest-news\";a:4:{s:4:\"file\";s:29:\"cropped-GramGro01-360x213.png\";s:5:\"width\";i:360;s:6:\"height\";i:213;s:9:\"mime-type\";s:9:\"image/png\";}s:29:\"illdy-front-page-testimonials\";a:4:{s:4:\"file\";s:29:\"cropped-GramGro01-127x127.png\";s:5:\"width\";i:127;s:6:\"height\";i:127;s:9:\"mime-type\";s:9:\"image/png\";}s:25:\"illdy-front-page-projects\";a:4:{s:4:\"file\";s:29:\"cropped-GramGro01-476x476.png\";s:5:\"width\";i:476;s:6:\"height\";i:476;s:9:\"mime-type\";s:9:\"image/png\";}s:23:\"illdy-front-page-person\";a:4:{s:4:\"file\";s:29:\"cropped-GramGro01-125x125.png\";s:5:\"width\";i:125;s:6:\"height\";i:125;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO wpax_postmeta VALUES("251", "85", "_wp_attached_file", "2016/12/cropped-GramGro01.jpg");
INSERT INTO wpax_postmeta VALUES("252", "85", "_wp_attachment_context", "custom-logo");
INSERT INTO wpax_postmeta VALUES("253", "85", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:2095;s:6:\"height\";i:1369;s:4:\"file\";s:29:\"2016/12/cropped-GramGro01.jpg\";s:5:\"sizes\";a:12:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:29:\"cropped-GramGro01-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:29:\"cropped-GramGro01-300x196.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:196;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:29:\"cropped-GramGro01-768x502.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:502;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:30:\"cropped-GramGro01-1024x669.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:669;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"wpca-thumb\";a:4:{s:4:\"file\";s:29:\"cropped-GramGro01-220x150.jpg\";s:5:\"width\";i:220;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"illdy-blog-list\";a:4:{s:4:\"file\";s:29:\"cropped-GramGro01-750x500.jpg\";s:5:\"width\";i:750;s:6:\"height\";i:500;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:25:\"illdy-widget-recent-posts\";a:4:{s:4:\"file\";s:27:\"cropped-GramGro01-70x70.jpg\";s:5:\"width\";i:70;s:6:\"height\";i:70;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:32:\"illdy-blog-post-related-articles\";a:4:{s:4:\"file\";s:29:\"cropped-GramGro01-240x206.jpg\";s:5:\"width\";i:240;s:6:\"height\";i:206;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:28:\"illdy-front-page-latest-news\";a:4:{s:4:\"file\";s:29:\"cropped-GramGro01-360x213.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:213;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:29:\"illdy-front-page-testimonials\";a:4:{s:4:\"file\";s:29:\"cropped-GramGro01-127x127.jpg\";s:5:\"width\";i:127;s:6:\"height\";i:127;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:25:\"illdy-front-page-projects\";a:4:{s:4:\"file\";s:29:\"cropped-GramGro01-476x476.jpg\";s:5:\"width\";i:476;s:6:\"height\";i:476;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:23:\"illdy-front-page-person\";a:4:{s:4:\"file\";s:29:\"cropped-GramGro01-125x125.jpg\";s:5:\"width\";i:125;s:6:\"height\";i:125;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO wpax_postmeta VALUES("254", "86", "_wp_attached_file", "2016/12/cropped-GramGro01-1.png");
INSERT INTO wpax_postmeta VALUES("255", "86", "_wp_attachment_context", "custom-logo");
INSERT INTO wpax_postmeta VALUES("256", "86", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1990;s:6:\"height\";i:1362;s:4:\"file\";s:31:\"2016/12/cropped-GramGro01-1.png\";s:5:\"sizes\";a:12:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:31:\"cropped-GramGro01-1-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"medium\";a:4:{s:4:\"file\";s:31:\"cropped-GramGro01-1-300x205.png\";s:5:\"width\";i:300;s:6:\"height\";i:205;s:9:\"mime-type\";s:9:\"image/png\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:31:\"cropped-GramGro01-1-768x526.png\";s:5:\"width\";i:768;s:6:\"height\";i:526;s:9:\"mime-type\";s:9:\"image/png\";}s:5:\"large\";a:4:{s:4:\"file\";s:32:\"cropped-GramGro01-1-1024x701.png\";s:5:\"width\";i:1024;s:6:\"height\";i:701;s:9:\"mime-type\";s:9:\"image/png\";}s:10:\"wpca-thumb\";a:4:{s:4:\"file\";s:31:\"cropped-GramGro01-1-220x150.png\";s:5:\"width\";i:220;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}s:15:\"illdy-blog-list\";a:4:{s:4:\"file\";s:31:\"cropped-GramGro01-1-750x500.png\";s:5:\"width\";i:750;s:6:\"height\";i:500;s:9:\"mime-type\";s:9:\"image/png\";}s:25:\"illdy-widget-recent-posts\";a:4:{s:4:\"file\";s:29:\"cropped-GramGro01-1-70x70.png\";s:5:\"width\";i:70;s:6:\"height\";i:70;s:9:\"mime-type\";s:9:\"image/png\";}s:32:\"illdy-blog-post-related-articles\";a:4:{s:4:\"file\";s:31:\"cropped-GramGro01-1-240x206.png\";s:5:\"width\";i:240;s:6:\"height\";i:206;s:9:\"mime-type\";s:9:\"image/png\";}s:28:\"illdy-front-page-latest-news\";a:4:{s:4:\"file\";s:31:\"cropped-GramGro01-1-360x213.png\";s:5:\"width\";i:360;s:6:\"height\";i:213;s:9:\"mime-type\";s:9:\"image/png\";}s:29:\"illdy-front-page-testimonials\";a:4:{s:4:\"file\";s:31:\"cropped-GramGro01-1-127x127.png\";s:5:\"width\";i:127;s:6:\"height\";i:127;s:9:\"mime-type\";s:9:\"image/png\";}s:25:\"illdy-front-page-projects\";a:4:{s:4:\"file\";s:31:\"cropped-GramGro01-1-476x476.png\";s:5:\"width\";i:476;s:6:\"height\";i:476;s:9:\"mime-type\";s:9:\"image/png\";}s:23:\"illdy-front-page-person\";a:4:{s:4:\"file\";s:31:\"cropped-GramGro01-1-125x125.png\";s:5:\"width\";i:125;s:6:\"height\";i:125;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO wpax_postmeta VALUES("257", "87", "_wp_attached_file", "2016/12/cropped-GramGro01-2.png");
INSERT INTO wpax_postmeta VALUES("258", "87", "_wp_attachment_context", "site-icon");
INSERT INTO wpax_postmeta VALUES("259", "87", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:512;s:6:\"height\";i:512;s:4:\"file\";s:31:\"2016/12/cropped-GramGro01-2.png\";s:5:\"sizes\";a:14:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:31:\"cropped-GramGro01-2-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"medium\";a:4:{s:4:\"file\";s:31:\"cropped-GramGro01-2-300x300.png\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";}s:10:\"wpca-thumb\";a:4:{s:4:\"file\";s:31:\"cropped-GramGro01-2-220x150.png\";s:5:\"width\";i:220;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}s:15:\"illdy-blog-list\";a:4:{s:4:\"file\";s:31:\"cropped-GramGro01-2-512x500.png\";s:5:\"width\";i:512;s:6:\"height\";i:500;s:9:\"mime-type\";s:9:\"image/png\";}s:25:\"illdy-widget-recent-posts\";a:4:{s:4:\"file\";s:29:\"cropped-GramGro01-2-70x70.png\";s:5:\"width\";i:70;s:6:\"height\";i:70;s:9:\"mime-type\";s:9:\"image/png\";}s:32:\"illdy-blog-post-related-articles\";a:4:{s:4:\"file\";s:31:\"cropped-GramGro01-2-240x206.png\";s:5:\"width\";i:240;s:6:\"height\";i:206;s:9:\"mime-type\";s:9:\"image/png\";}s:28:\"illdy-front-page-latest-news\";a:4:{s:4:\"file\";s:31:\"cropped-GramGro01-2-360x213.png\";s:5:\"width\";i:360;s:6:\"height\";i:213;s:9:\"mime-type\";s:9:\"image/png\";}s:29:\"illdy-front-page-testimonials\";a:4:{s:4:\"file\";s:31:\"cropped-GramGro01-2-127x127.png\";s:5:\"width\";i:127;s:6:\"height\";i:127;s:9:\"mime-type\";s:9:\"image/png\";}s:25:\"illdy-front-page-projects\";a:4:{s:4:\"file\";s:31:\"cropped-GramGro01-2-476x476.png\";s:5:\"width\";i:476;s:6:\"height\";i:476;s:9:\"mime-type\";s:9:\"image/png\";}s:23:\"illdy-front-page-person\";a:4:{s:4:\"file\";s:31:\"cropped-GramGro01-2-125x125.png\";s:5:\"width\";i:125;s:6:\"height\";i:125;s:9:\"mime-type\";s:9:\"image/png\";}s:13:\"site_icon-270\";a:4:{s:4:\"file\";s:31:\"cropped-GramGro01-2-270x270.png\";s:5:\"width\";i:270;s:6:\"height\";i:270;s:9:\"mime-type\";s:9:\"image/png\";}s:13:\"site_icon-192\";a:4:{s:4:\"file\";s:31:\"cropped-GramGro01-2-192x192.png\";s:5:\"width\";i:192;s:6:\"height\";i:192;s:9:\"mime-type\";s:9:\"image/png\";}s:13:\"site_icon-180\";a:4:{s:4:\"file\";s:31:\"cropped-GramGro01-2-180x180.png\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:9:\"image/png\";}s:12:\"site_icon-32\";a:4:{s:4:\"file\";s:29:\"cropped-GramGro01-2-32x32.png\";s:5:\"width\";i:32;s:6:\"height\";i:32;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO wpax_postmeta VALUES("260", "88", "_wp_attached_file", "2016/12/GramGro01redo.png");
INSERT INTO wpax_postmeta VALUES("261", "88", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:425;s:6:\"height\";i:248;s:4:\"file\";s:25:\"2016/12/GramGro01redo.png\";s:5:\"sizes\";a:8:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:25:\"GramGro01redo-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"medium\";a:4:{s:4:\"file\";s:25:\"GramGro01redo-300x175.png\";s:5:\"width\";i:300;s:6:\"height\";i:175;s:9:\"mime-type\";s:9:\"image/png\";}s:10:\"wpca-thumb\";a:4:{s:4:\"file\";s:25:\"GramGro01redo-220x150.png\";s:5:\"width\";i:220;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}s:25:\"illdy-widget-recent-posts\";a:4:{s:4:\"file\";s:23:\"GramGro01redo-70x70.png\";s:5:\"width\";i:70;s:6:\"height\";i:70;s:9:\"mime-type\";s:9:\"image/png\";}s:32:\"illdy-blog-post-related-articles\";a:4:{s:4:\"file\";s:25:\"GramGro01redo-240x206.png\";s:5:\"width\";i:240;s:6:\"height\";i:206;s:9:\"mime-type\";s:9:\"image/png\";}s:28:\"illdy-front-page-latest-news\";a:4:{s:4:\"file\";s:25:\"GramGro01redo-360x213.png\";s:5:\"width\";i:360;s:6:\"height\";i:213;s:9:\"mime-type\";s:9:\"image/png\";}s:29:\"illdy-front-page-testimonials\";a:4:{s:4:\"file\";s:25:\"GramGro01redo-127x127.png\";s:5:\"width\";i:127;s:6:\"height\";i:127;s:9:\"mime-type\";s:9:\"image/png\";}s:23:\"illdy-front-page-person\";a:4:{s:4:\"file\";s:25:\"GramGro01redo-125x125.png\";s:5:\"width\";i:125;s:6:\"height\";i:125;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO wpax_postmeta VALUES("262", "89", "_wp_attached_file", "2016/12/cropped-GramGro01redo.png");
INSERT INTO wpax_postmeta VALUES("263", "89", "_wp_attachment_context", "custom-logo");
INSERT INTO wpax_postmeta VALUES("264", "89", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:225;s:6:\"height\";i:157;s:4:\"file\";s:33:\"2016/12/cropped-GramGro01redo.png\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:33:\"cropped-GramGro01redo-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}s:10:\"wpca-thumb\";a:4:{s:4:\"file\";s:33:\"cropped-GramGro01redo-220x150.png\";s:5:\"width\";i:220;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}s:25:\"illdy-widget-recent-posts\";a:4:{s:4:\"file\";s:31:\"cropped-GramGro01redo-70x70.png\";s:5:\"width\";i:70;s:6:\"height\";i:70;s:9:\"mime-type\";s:9:\"image/png\";}s:29:\"illdy-front-page-testimonials\";a:4:{s:4:\"file\";s:33:\"cropped-GramGro01redo-127x127.png\";s:5:\"width\";i:127;s:6:\"height\";i:127;s:9:\"mime-type\";s:9:\"image/png\";}s:23:\"illdy-front-page-person\";a:4:{s:4:\"file\";s:33:\"cropped-GramGro01redo-125x125.png\";s:5:\"width\";i:125;s:6:\"height\";i:125;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO wpax_postmeta VALUES("267", "90", "_wp_attached_file", "2016/12/city-wallpaper-2.jpg");
INSERT INTO wpax_postmeta VALUES("268", "90", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1920;s:6:\"height\";i:1080;s:4:\"file\";s:28:\"2016/12/city-wallpaper-2.jpg\";s:5:\"sizes\";a:12:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:28:\"city-wallpaper-2-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:28:\"city-wallpaper-2-300x169.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:169;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:28:\"city-wallpaper-2-768x432.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:432;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:29:\"city-wallpaper-2-1024x576.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:576;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"wpca-thumb\";a:4:{s:4:\"file\";s:28:\"city-wallpaper-2-220x150.jpg\";s:5:\"width\";i:220;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"illdy-blog-list\";a:4:{s:4:\"file\";s:28:\"city-wallpaper-2-750x500.jpg\";s:5:\"width\";i:750;s:6:\"height\";i:500;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:25:\"illdy-widget-recent-posts\";a:4:{s:4:\"file\";s:26:\"city-wallpaper-2-70x70.jpg\";s:5:\"width\";i:70;s:6:\"height\";i:70;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:32:\"illdy-blog-post-related-articles\";a:4:{s:4:\"file\";s:28:\"city-wallpaper-2-240x206.jpg\";s:5:\"width\";i:240;s:6:\"height\";i:206;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:28:\"illdy-front-page-latest-news\";a:4:{s:4:\"file\";s:28:\"city-wallpaper-2-360x213.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:213;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:29:\"illdy-front-page-testimonials\";a:4:{s:4:\"file\";s:28:\"city-wallpaper-2-127x127.jpg\";s:5:\"width\";i:127;s:6:\"height\";i:127;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:25:\"illdy-front-page-projects\";a:4:{s:4:\"file\";s:28:\"city-wallpaper-2-476x476.jpg\";s:5:\"width\";i:476;s:6:\"height\";i:476;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:23:\"illdy-front-page-person\";a:4:{s:4:\"file\";s:28:\"city-wallpaper-2-125x125.jpg\";s:5:\"width\";i:125;s:6:\"height\";i:125;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO wpax_postmeta VALUES("269", "92", "_wp_attached_file", "2016/12/city-background-3.jpg");
INSERT INTO wpax_postmeta VALUES("270", "92", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1920;s:6:\"height\";i:1200;s:4:\"file\";s:29:\"2016/12/city-background-3.jpg\";s:5:\"sizes\";a:12:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:29:\"city-background-3-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:29:\"city-background-3-300x188.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:188;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:29:\"city-background-3-768x480.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:480;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:30:\"city-background-3-1024x640.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:640;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"wpca-thumb\";a:4:{s:4:\"file\";s:29:\"city-background-3-220x150.jpg\";s:5:\"width\";i:220;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"illdy-blog-list\";a:4:{s:4:\"file\";s:29:\"city-background-3-750x500.jpg\";s:5:\"width\";i:750;s:6:\"height\";i:500;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:25:\"illdy-widget-recent-posts\";a:4:{s:4:\"file\";s:27:\"city-background-3-70x70.jpg\";s:5:\"width\";i:70;s:6:\"height\";i:70;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:32:\"illdy-blog-post-related-articles\";a:4:{s:4:\"file\";s:29:\"city-background-3-240x206.jpg\";s:5:\"width\";i:240;s:6:\"height\";i:206;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:28:\"illdy-front-page-latest-news\";a:4:{s:4:\"file\";s:29:\"city-background-3-360x213.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:213;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:29:\"illdy-front-page-testimonials\";a:4:{s:4:\"file\";s:29:\"city-background-3-127x127.jpg\";s:5:\"width\";i:127;s:6:\"height\";i:127;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:25:\"illdy-front-page-projects\";a:4:{s:4:\"file\";s:29:\"city-background-3-476x476.jpg\";s:5:\"width\";i:476;s:6:\"height\";i:476;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:23:\"illdy-front-page-person\";a:4:{s:4:\"file\";s:29:\"city-background-3-125x125.jpg\";s:5:\"width\";i:125;s:6:\"height\";i:125;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO wpax_postmeta VALUES("271", "93", "_wp_attached_file", "2016/12/36912781-business-wallpaper.jpg");
INSERT INTO wpax_postmeta VALUES("272", "93", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1920;s:6:\"height\";i:1080;s:4:\"file\";s:39:\"2016/12/36912781-business-wallpaper.jpg\";s:5:\"sizes\";a:12:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:39:\"36912781-business-wallpaper-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:39:\"36912781-business-wallpaper-300x169.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:169;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:39:\"36912781-business-wallpaper-768x432.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:432;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:40:\"36912781-business-wallpaper-1024x576.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:576;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"wpca-thumb\";a:4:{s:4:\"file\";s:39:\"36912781-business-wallpaper-220x150.jpg\";s:5:\"width\";i:220;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"illdy-blog-list\";a:4:{s:4:\"file\";s:39:\"36912781-business-wallpaper-750x500.jpg\";s:5:\"width\";i:750;s:6:\"height\";i:500;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:25:\"illdy-widget-recent-posts\";a:4:{s:4:\"file\";s:37:\"36912781-business-wallpaper-70x70.jpg\";s:5:\"width\";i:70;s:6:\"height\";i:70;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:32:\"illdy-blog-post-related-articles\";a:4:{s:4:\"file\";s:39:\"36912781-business-wallpaper-240x206.jpg\";s:5:\"width\";i:240;s:6:\"height\";i:206;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:28:\"illdy-front-page-latest-news\";a:4:{s:4:\"file\";s:39:\"36912781-business-wallpaper-360x213.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:213;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:29:\"illdy-front-page-testimonials\";a:4:{s:4:\"file\";s:39:\"36912781-business-wallpaper-127x127.jpg\";s:5:\"width\";i:127;s:6:\"height\";i:127;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:25:\"illdy-front-page-projects\";a:4:{s:4:\"file\";s:39:\"36912781-business-wallpaper-476x476.jpg\";s:5:\"width\";i:476;s:6:\"height\";i:476;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:23:\"illdy-front-page-person\";a:4:{s:4:\"file\";s:39:\"36912781-business-wallpaper-125x125.jpg\";s:5:\"width\";i:125;s:6:\"height\";i:125;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO wpax_postmeta VALUES("273", "94", "_menu_item_type", "custom");
INSERT INTO wpax_postmeta VALUES("274", "94", "_menu_item_menu_item_parent", "0");
INSERT INTO wpax_postmeta VALUES("275", "94", "_menu_item_object_id", "94");
INSERT INTO wpax_postmeta VALUES("276", "94", "_menu_item_object", "custom");
INSERT INTO wpax_postmeta VALUES("277", "94", "_menu_item_target", "");
INSERT INTO wpax_postmeta VALUES("278", "94", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO wpax_postmeta VALUES("279", "94", "_menu_item_xfn", "");
INSERT INTO wpax_postmeta VALUES("280", "94", "_menu_item_url", "http://gramgro.com");
INSERT INTO wpax_postmeta VALUES("312", "109", "_menu_item_type", "post_type");
INSERT INTO wpax_postmeta VALUES("313", "109", "_menu_item_menu_item_parent", "0");
INSERT INTO wpax_postmeta VALUES("314", "109", "_menu_item_object_id", "102");
INSERT INTO wpax_postmeta VALUES("315", "109", "_menu_item_object", "page");
INSERT INTO wpax_postmeta VALUES("316", "109", "_menu_item_target", "");
INSERT INTO wpax_postmeta VALUES("317", "109", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO wpax_postmeta VALUES("318", "109", "_menu_item_xfn", "");
INSERT INTO wpax_postmeta VALUES("319", "109", "_menu_item_url", "");
INSERT INTO wpax_postmeta VALUES("320", "110", "_menu_item_type", "post_type");
INSERT INTO wpax_postmeta VALUES("321", "110", "_menu_item_menu_item_parent", "0");
INSERT INTO wpax_postmeta VALUES("322", "110", "_menu_item_object_id", "103");
INSERT INTO wpax_postmeta VALUES("323", "110", "_menu_item_object", "page");
INSERT INTO wpax_postmeta VALUES("324", "110", "_menu_item_target", "_blank");
INSERT INTO wpax_postmeta VALUES("325", "110", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO wpax_postmeta VALUES("326", "110", "_menu_item_xfn", "");
INSERT INTO wpax_postmeta VALUES("327", "110", "_menu_item_url", "");
INSERT INTO wpax_postmeta VALUES("336", "114", "_wp_attached_file", "2016/12/GramGro01-1.png");
INSERT INTO wpax_postmeta VALUES("337", "114", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:105;s:6:\"height\";i:61;s:4:\"file\";s:23:\"2016/12/GramGro01-1.png\";s:5:\"sizes\";a:1:{s:25:\"illdy-widget-recent-posts\";a:4:{s:4:\"file\";s:21:\"GramGro01-1-70x61.png\";s:5:\"width\";i:70;s:6:\"height\";i:61;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO wpax_postmeta VALUES("338", "115", "_wp_attached_file", "2016/12/cropped-GramGro01-1-1.png");
INSERT INTO wpax_postmeta VALUES("339", "115", "_wp_attachment_context", "custom-logo");
INSERT INTO wpax_postmeta VALUES("340", "115", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:61;s:6:\"height\";i:39;s:4:\"file\";s:33:\"2016/12/cropped-GramGro01-1-1.png\";s:5:\"sizes\";a:0:{}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO wpax_postmeta VALUES("343", "117", "_wp_attached_file", "2016/12/cropped-cropped-GramGro01redo.png");
INSERT INTO wpax_postmeta VALUES("344", "117", "_wp_attachment_context", "custom-logo");
INSERT INTO wpax_postmeta VALUES("345", "117", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:210;s:6:\"height\";i:157;s:4:\"file\";s:41:\"2016/12/cropped-cropped-GramGro01redo.png\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:41:\"cropped-cropped-GramGro01redo-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}s:10:\"wpca-thumb\";a:4:{s:4:\"file\";s:41:\"cropped-cropped-GramGro01redo-210x150.png\";s:5:\"width\";i:210;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}s:25:\"illdy-widget-recent-posts\";a:4:{s:4:\"file\";s:39:\"cropped-cropped-GramGro01redo-70x70.png\";s:5:\"width\";i:70;s:6:\"height\";i:70;s:9:\"mime-type\";s:9:\"image/png\";}s:29:\"illdy-front-page-testimonials\";a:4:{s:4:\"file\";s:41:\"cropped-cropped-GramGro01redo-127x127.png\";s:5:\"width\";i:127;s:6:\"height\";i:127;s:9:\"mime-type\";s:9:\"image/png\";}s:23:\"illdy-front-page-person\";a:4:{s:4:\"file\";s:41:\"cropped-cropped-GramGro01redo-125x125.png\";s:5:\"width\";i:125;s:6:\"height\";i:125;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO wpax_postmeta VALUES("348", "119", "_wp_attached_file", "2016/12/36912781-business-wallpaper-1.jpg");
INSERT INTO wpax_postmeta VALUES("349", "119", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1080;s:6:\"height\";i:608;s:4:\"file\";s:41:\"2016/12/36912781-business-wallpaper-1.jpg\";s:5:\"sizes\";a:12:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:41:\"36912781-business-wallpaper-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:41:\"36912781-business-wallpaper-1-300x169.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:169;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:41:\"36912781-business-wallpaper-1-768x432.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:432;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:42:\"36912781-business-wallpaper-1-1024x576.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:576;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"wpca-thumb\";a:4:{s:4:\"file\";s:41:\"36912781-business-wallpaper-1-220x150.jpg\";s:5:\"width\";i:220;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"illdy-blog-list\";a:4:{s:4:\"file\";s:41:\"36912781-business-wallpaper-1-750x500.jpg\";s:5:\"width\";i:750;s:6:\"height\";i:500;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:25:\"illdy-widget-recent-posts\";a:4:{s:4:\"file\";s:39:\"36912781-business-wallpaper-1-70x70.jpg\";s:5:\"width\";i:70;s:6:\"height\";i:70;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:32:\"illdy-blog-post-related-articles\";a:4:{s:4:\"file\";s:41:\"36912781-business-wallpaper-1-240x206.jpg\";s:5:\"width\";i:240;s:6:\"height\";i:206;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:28:\"illdy-front-page-latest-news\";a:4:{s:4:\"file\";s:41:\"36912781-business-wallpaper-1-360x213.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:213;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:29:\"illdy-front-page-testimonials\";a:4:{s:4:\"file\";s:41:\"36912781-business-wallpaper-1-127x127.jpg\";s:5:\"width\";i:127;s:6:\"height\";i:127;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:25:\"illdy-front-page-projects\";a:4:{s:4:\"file\";s:41:\"36912781-business-wallpaper-1-476x476.jpg\";s:5:\"width\";i:476;s:6:\"height\";i:476;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:23:\"illdy-front-page-person\";a:4:{s:4:\"file\";s:41:\"36912781-business-wallpaper-1-125x125.jpg\";s:5:\"width\";i:125;s:6:\"height\";i:125;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO wpax_postmeta VALUES("352", "102", "_edit_lock", "1482514327:1");
INSERT INTO wpax_postmeta VALUES("353", "43", "_edit_lock", "1481878167:1");
INSERT INTO wpax_postmeta VALUES("354", "121", "cuar_user_id", "0");
INSERT INTO wpax_postmeta VALUES("355", "121", "cuar_ip", "100.38.10.251");
INSERT INTO wpax_postmeta VALUES("356", "121", "cuar_related_object_type", "WP_User");
INSERT INTO wpax_postmeta VALUES("357", "50", "_edit_lock", "1481878239:1");
INSERT INTO wpax_postmeta VALUES("358", "122", "cuar_user_id", "0");
INSERT INTO wpax_postmeta VALUES("359", "122", "cuar_ip", "100.38.10.251");
INSERT INTO wpax_postmeta VALUES("360", "122", "cuar_related_object_type", "WP_User");
INSERT INTO wpax_postmeta VALUES("361", "2", "_edit_last", "1");
INSERT INTO wpax_postmeta VALUES("362", "125", "cuar_user_id", "0");
INSERT INTO wpax_postmeta VALUES("363", "125", "cuar_ip", "100.38.10.251");
INSERT INTO wpax_postmeta VALUES("364", "125", "cuar_related_object_type", "WP_User");
INSERT INTO wpax_postmeta VALUES("367", "127", "cuar_user_id", "0");
INSERT INTO wpax_postmeta VALUES("368", "127", "cuar_ip", "100.38.10.251");
INSERT INTO wpax_postmeta VALUES("369", "127", "cuar_related_object_type", "WP_User");
INSERT INTO wpax_postmeta VALUES("372", "48", "_edit_lock", "1481929736:1");
INSERT INTO wpax_postmeta VALUES("373", "48", "_edit_last", "1");
INSERT INTO wpax_postmeta VALUES("374", "48", "_wp_page_template", "default");
INSERT INTO wpax_postmeta VALUES("375", "130", "cuar_user_id", "0");
INSERT INTO wpax_postmeta VALUES("376", "130", "cuar_ip", "100.38.10.251");
INSERT INTO wpax_postmeta VALUES("377", "130", "cuar_related_object_type", "WP_User");
INSERT INTO wpax_postmeta VALUES("378", "131", "_wp_trash_meta_status", "publish");
INSERT INTO wpax_postmeta VALUES("379", "131", "_wp_trash_meta_time", "1482349315");
INSERT INTO wpax_postmeta VALUES("380", "132", "_wp_trash_meta_status", "publish");
INSERT INTO wpax_postmeta VALUES("381", "132", "_wp_trash_meta_time", "1482349544");
INSERT INTO wpax_postmeta VALUES("382", "137", "_menu_item_type", "post_type");
INSERT INTO wpax_postmeta VALUES("383", "137", "_menu_item_menu_item_parent", "0");
INSERT INTO wpax_postmeta VALUES("384", "137", "_menu_item_object_id", "43");
INSERT INTO wpax_postmeta VALUES("385", "137", "_menu_item_object", "page");
INSERT INTO wpax_postmeta VALUES("386", "137", "_menu_item_target", "");
INSERT INTO wpax_postmeta VALUES("387", "137", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO wpax_postmeta VALUES("388", "137", "_menu_item_xfn", "");
INSERT INTO wpax_postmeta VALUES("389", "137", "_menu_item_url", "");
INSERT INTO wpax_postmeta VALUES("390", "138", "_menu_item_type", "post_type");
INSERT INTO wpax_postmeta VALUES("391", "138", "_menu_item_menu_item_parent", "0");
INSERT INTO wpax_postmeta VALUES("392", "138", "_menu_item_object_id", "133");
INSERT INTO wpax_postmeta VALUES("393", "138", "_menu_item_object", "page");
INSERT INTO wpax_postmeta VALUES("394", "138", "_menu_item_target", "");
INSERT INTO wpax_postmeta VALUES("395", "138", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO wpax_postmeta VALUES("396", "138", "_menu_item_xfn", "");
INSERT INTO wpax_postmeta VALUES("397", "138", "_menu_item_url", "");
INSERT INTO wpax_postmeta VALUES("398", "139", "_menu_item_type", "post_type");
INSERT INTO wpax_postmeta VALUES("399", "139", "_menu_item_menu_item_parent", "138");
INSERT INTO wpax_postmeta VALUES("400", "139", "_menu_item_object_id", "134");
INSERT INTO wpax_postmeta VALUES("401", "139", "_menu_item_object", "page");
INSERT INTO wpax_postmeta VALUES("402", "139", "_menu_item_target", "");
INSERT INTO wpax_postmeta VALUES("403", "139", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO wpax_postmeta VALUES("404", "139", "_menu_item_xfn", "");
INSERT INTO wpax_postmeta VALUES("405", "139", "_menu_item_url", "");
INSERT INTO wpax_postmeta VALUES("406", "140", "_menu_item_type", "post_type");
INSERT INTO wpax_postmeta VALUES("407", "140", "_menu_item_menu_item_parent", "0");
INSERT INTO wpax_postmeta VALUES("408", "140", "_menu_item_object_id", "135");
INSERT INTO wpax_postmeta VALUES("409", "140", "_menu_item_object", "page");
INSERT INTO wpax_postmeta VALUES("410", "140", "_menu_item_target", "");
INSERT INTO wpax_postmeta VALUES("411", "140", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO wpax_postmeta VALUES("412", "140", "_menu_item_xfn", "");
INSERT INTO wpax_postmeta VALUES("413", "140", "_menu_item_url", "");
INSERT INTO wpax_postmeta VALUES("414", "141", "_menu_item_type", "post_type");
INSERT INTO wpax_postmeta VALUES("415", "141", "_menu_item_menu_item_parent", "140");
INSERT INTO wpax_postmeta VALUES("416", "141", "_menu_item_object_id", "136");
INSERT INTO wpax_postmeta VALUES("417", "141", "_menu_item_object", "page");
INSERT INTO wpax_postmeta VALUES("418", "141", "_menu_item_target", "");
INSERT INTO wpax_postmeta VALUES("419", "141", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO wpax_postmeta VALUES("420", "141", "_menu_item_xfn", "");
INSERT INTO wpax_postmeta VALUES("421", "141", "_menu_item_url", "");
INSERT INTO wpax_postmeta VALUES("422", "142", "_menu_item_type", "post_type");
INSERT INTO wpax_postmeta VALUES("423", "142", "_menu_item_menu_item_parent", "0");
INSERT INTO wpax_postmeta VALUES("424", "142", "_menu_item_object_id", "48");
INSERT INTO wpax_postmeta VALUES("425", "142", "_menu_item_object", "page");
INSERT INTO wpax_postmeta VALUES("426", "142", "_menu_item_target", "");
INSERT INTO wpax_postmeta VALUES("427", "142", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO wpax_postmeta VALUES("428", "142", "_menu_item_xfn", "");
INSERT INTO wpax_postmeta VALUES("429", "142", "_menu_item_url", "");
INSERT INTO wpax_postmeta VALUES("430", "143", "_menu_item_type", "post_type");
INSERT INTO wpax_postmeta VALUES("431", "143", "_menu_item_menu_item_parent", "142");
INSERT INTO wpax_postmeta VALUES("432", "143", "_menu_item_object_id", "49");
INSERT INTO wpax_postmeta VALUES("433", "143", "_menu_item_object", "page");
INSERT INTO wpax_postmeta VALUES("434", "143", "_menu_item_target", "");
INSERT INTO wpax_postmeta VALUES("435", "143", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO wpax_postmeta VALUES("436", "143", "_menu_item_xfn", "");
INSERT INTO wpax_postmeta VALUES("437", "143", "_menu_item_url", "");
INSERT INTO wpax_postmeta VALUES("438", "144", "_menu_item_type", "post_type");
INSERT INTO wpax_postmeta VALUES("439", "144", "_menu_item_menu_item_parent", "142");
INSERT INTO wpax_postmeta VALUES("440", "144", "_menu_item_object_id", "50");
INSERT INTO wpax_postmeta VALUES("441", "144", "_menu_item_object", "page");
INSERT INTO wpax_postmeta VALUES("442", "144", "_menu_item_target", "");
INSERT INTO wpax_postmeta VALUES("443", "144", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO wpax_postmeta VALUES("444", "144", "_menu_item_xfn", "");
INSERT INTO wpax_postmeta VALUES("445", "144", "_menu_item_url", "");
INSERT INTO wpax_postmeta VALUES("446", "145", "_menu_item_type", "post_type");
INSERT INTO wpax_postmeta VALUES("447", "145", "_menu_item_menu_item_parent", "142");
INSERT INTO wpax_postmeta VALUES("448", "145", "_menu_item_object_id", "51");
INSERT INTO wpax_postmeta VALUES("449", "145", "_menu_item_object", "page");
INSERT INTO wpax_postmeta VALUES("450", "145", "_menu_item_target", "");
INSERT INTO wpax_postmeta VALUES("451", "145", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO wpax_postmeta VALUES("452", "145", "_menu_item_xfn", "");
INSERT INTO wpax_postmeta VALUES("453", "145", "_menu_item_url", "");
INSERT INTO wpax_postmeta VALUES("454", "148", "_wp_trash_meta_status", "publish");
INSERT INTO wpax_postmeta VALUES("455", "148", "_wp_trash_meta_time", "1482360884");
INSERT INTO wpax_postmeta VALUES("456", "149", "_wp_trash_meta_status", "publish");
INSERT INTO wpax_postmeta VALUES("457", "149", "_wp_trash_meta_time", "1482360935");
INSERT INTO wpax_postmeta VALUES("458", "150", "_wp_trash_meta_status", "publish");
INSERT INTO wpax_postmeta VALUES("459", "150", "_wp_trash_meta_time", "1482360953");
INSERT INTO wpax_postmeta VALUES("460", "151", "_wp_trash_meta_status", "publish");
INSERT INTO wpax_postmeta VALUES("461", "151", "_wp_trash_meta_time", "1482360963");
INSERT INTO wpax_postmeta VALUES("462", "152", "_wp_trash_meta_status", "publish");
INSERT INTO wpax_postmeta VALUES("463", "152", "_wp_trash_meta_time", "1482361401");
INSERT INTO wpax_postmeta VALUES("464", "155", "_wp_trash_meta_status", "publish");
INSERT INTO wpax_postmeta VALUES("465", "155", "_wp_trash_meta_time", "1482361634");
INSERT INTO wpax_postmeta VALUES("466", "146", "_edit_lock", "1482457714:1");
INSERT INTO wpax_postmeta VALUES("467", "157", "_wp_trash_meta_status", "publish");
INSERT INTO wpax_postmeta VALUES("468", "157", "_wp_trash_meta_time", "1482361876");
INSERT INTO wpax_postmeta VALUES("469", "158", "_wp_trash_meta_status", "publish");
INSERT INTO wpax_postmeta VALUES("470", "158", "_wp_trash_meta_time", "1482362486");
INSERT INTO wpax_postmeta VALUES("471", "159", "_wp_trash_meta_status", "publish");
INSERT INTO wpax_postmeta VALUES("472", "159", "_wp_trash_meta_time", "1482362575");
INSERT INTO wpax_postmeta VALUES("473", "160", "_wp_trash_meta_status", "publish");
INSERT INTO wpax_postmeta VALUES("474", "160", "_wp_trash_meta_time", "1482362605");
INSERT INTO wpax_postmeta VALUES("475", "161", "_wp_trash_meta_status", "publish");
INSERT INTO wpax_postmeta VALUES("476", "161", "_wp_trash_meta_time", "1482363063");
INSERT INTO wpax_postmeta VALUES("477", "162", "_wp_trash_meta_status", "publish");
INSERT INTO wpax_postmeta VALUES("478", "162", "_wp_trash_meta_time", "1482363651");
INSERT INTO wpax_postmeta VALUES("479", "162", "_publicize_pending", "1");
INSERT INTO wpax_postmeta VALUES("480", "163", "_wp_trash_meta_status", "publish");
INSERT INTO wpax_postmeta VALUES("481", "163", "_wp_trash_meta_time", "1482363682");
INSERT INTO wpax_postmeta VALUES("482", "163", "_publicize_pending", "1");
INSERT INTO wpax_postmeta VALUES("483", "164", "_wp_trash_meta_status", "publish");
INSERT INTO wpax_postmeta VALUES("484", "164", "_wp_trash_meta_time", "1482364247");
INSERT INTO wpax_postmeta VALUES("485", "164", "_publicize_pending", "1");
INSERT INTO wpax_postmeta VALUES("486", "165", "_edit_last", "1");
INSERT INTO wpax_postmeta VALUES("487", "165", "_publicize_pending", "1");
INSERT INTO wpax_postmeta VALUES("488", "165", "_edit_lock", "1482365649:1");
INSERT INTO wpax_postmeta VALUES("489", "165", "_jetpack_dont_email_post_to_subs", "1");
INSERT INTO wpax_postmeta VALUES("490", "165", "_jetpack_related_posts_cache", "a:1:{s:32:\"94b38128ef4b90ea083408b81430c138\";a:2:{s:7:\"expires\";i:1482364380;s:7:\"payload\";a:0:{}}}");
INSERT INTO wpax_postmeta VALUES("491", "168", "_wp_trash_meta_status", "publish");
INSERT INTO wpax_postmeta VALUES("492", "168", "_wp_trash_meta_time", "1482364513");
INSERT INTO wpax_postmeta VALUES("493", "168", "_publicize_pending", "1");
INSERT INTO wpax_postmeta VALUES("494", "169", "_wp_trash_meta_status", "publish");
INSERT INTO wpax_postmeta VALUES("495", "169", "_wp_trash_meta_time", "1482364667");
INSERT INTO wpax_postmeta VALUES("496", "169", "_publicize_pending", "1");
INSERT INTO wpax_postmeta VALUES("497", "170", "_wp_trash_meta_status", "publish");
INSERT INTO wpax_postmeta VALUES("498", "170", "_wp_trash_meta_time", "1482364769");
INSERT INTO wpax_postmeta VALUES("499", "170", "_publicize_pending", "1");
INSERT INTO wpax_postmeta VALUES("500", "171", "_wp_trash_meta_status", "publish");
INSERT INTO wpax_postmeta VALUES("501", "171", "_wp_trash_meta_time", "1482364882");
INSERT INTO wpax_postmeta VALUES("502", "171", "_publicize_pending", "1");
INSERT INTO wpax_postmeta VALUES("503", "172", "_wp_trash_meta_status", "publish");
INSERT INTO wpax_postmeta VALUES("504", "172", "_wp_trash_meta_time", "1482364921");
INSERT INTO wpax_postmeta VALUES("505", "172", "_publicize_pending", "1");
INSERT INTO wpax_postmeta VALUES("506", "173", "_wp_trash_meta_status", "publish");
INSERT INTO wpax_postmeta VALUES("507", "173", "_wp_trash_meta_time", "1482364993");
INSERT INTO wpax_postmeta VALUES("508", "173", "_publicize_pending", "1");
INSERT INTO wpax_postmeta VALUES("509", "174", "_wp_trash_meta_status", "publish");
INSERT INTO wpax_postmeta VALUES("510", "174", "_wp_trash_meta_time", "1482365387");
INSERT INTO wpax_postmeta VALUES("511", "174", "_publicize_pending", "1");
INSERT INTO wpax_postmeta VALUES("512", "175", "_wp_trash_meta_status", "publish");
INSERT INTO wpax_postmeta VALUES("513", "175", "_wp_trash_meta_time", "1482365413");
INSERT INTO wpax_postmeta VALUES("514", "175", "_publicize_pending", "1");
INSERT INTO wpax_postmeta VALUES("515", "176", "_wp_trash_meta_status", "publish");
INSERT INTO wpax_postmeta VALUES("516", "176", "_wp_trash_meta_time", "1482365545");
INSERT INTO wpax_postmeta VALUES("517", "176", "_publicize_pending", "1");
INSERT INTO wpax_postmeta VALUES("518", "177", "_wp_trash_meta_status", "publish");
INSERT INTO wpax_postmeta VALUES("519", "177", "_wp_trash_meta_time", "1482365630");
INSERT INTO wpax_postmeta VALUES("520", "177", "_publicize_pending", "1");
INSERT INTO wpax_postmeta VALUES("521", "180", "_edit_lock", "1482365744:1");
INSERT INTO wpax_postmeta VALUES("522", "180", "_edit_last", "1");
INSERT INTO wpax_postmeta VALUES("523", "180", "_publicize_pending", "1");
INSERT INTO wpax_postmeta VALUES("524", "183", "_edit_lock", "1482368644:1");
INSERT INTO wpax_postmeta VALUES("525", "183", "_edit_last", "1");
INSERT INTO wpax_postmeta VALUES("526", "183", "_publicize_pending", "1");
INSERT INTO wpax_postmeta VALUES("527", "182", "_wp_trash_meta_status", "publish");
INSERT INTO wpax_postmeta VALUES("528", "182", "_wp_trash_meta_time", "1482366983");
INSERT INTO wpax_postmeta VALUES("529", "182", "_publicize_pending", "1");
INSERT INTO wpax_postmeta VALUES("530", "185", "_wp_trash_meta_status", "publish");
INSERT INTO wpax_postmeta VALUES("531", "185", "_wp_trash_meta_time", "1482418190");
INSERT INTO wpax_postmeta VALUES("532", "185", "_publicize_pending", "1");
INSERT INTO wpax_postmeta VALUES("533", "186", "_wp_trash_meta_status", "publish");
INSERT INTO wpax_postmeta VALUES("534", "186", "_wp_trash_meta_time", "1482427194");
INSERT INTO wpax_postmeta VALUES("535", "186", "_publicize_pending", "1");
INSERT INTO wpax_postmeta VALUES("536", "187", "_wp_trash_meta_status", "publish");
INSERT INTO wpax_postmeta VALUES("537", "187", "_wp_trash_meta_time", "1482427613");
INSERT INTO wpax_postmeta VALUES("538", "187", "_publicize_pending", "1");
INSERT INTO wpax_postmeta VALUES("539", "188", "_wp_trash_meta_status", "publish");
INSERT INTO wpax_postmeta VALUES("540", "188", "_wp_trash_meta_time", "1482427632");
INSERT INTO wpax_postmeta VALUES("541", "188", "_publicize_pending", "1");
INSERT INTO wpax_postmeta VALUES("542", "189", "_wp_trash_meta_status", "publish");
INSERT INTO wpax_postmeta VALUES("543", "189", "_wp_trash_meta_time", "1482427852");
INSERT INTO wpax_postmeta VALUES("544", "189", "_publicize_pending", "1");
INSERT INTO wpax_postmeta VALUES("545", "190", "_wp_trash_meta_status", "publish");
INSERT INTO wpax_postmeta VALUES("546", "190", "_wp_trash_meta_time", "1482427916");
INSERT INTO wpax_postmeta VALUES("547", "190", "_publicize_pending", "1");
INSERT INTO wpax_postmeta VALUES("548", "191", "_wp_trash_meta_status", "publish");
INSERT INTO wpax_postmeta VALUES("549", "191", "_wp_trash_meta_time", "1482427941");
INSERT INTO wpax_postmeta VALUES("550", "191", "_publicize_pending", "1");
INSERT INTO wpax_postmeta VALUES("551", "102", "_edit_last", "1");
INSERT INTO wpax_postmeta VALUES("553", "102", "_wp_page_template", "default");
INSERT INTO wpax_postmeta VALUES("554", "102", "_jetpack_dont_email_post_to_subs", "1");
INSERT INTO wpax_postmeta VALUES("555", "193", "_wp_attached_file", "2016/12/cropped-new-york-city-guide-1.jpg");
INSERT INTO wpax_postmeta VALUES("556", "193", "_wp_attachment_context", "custom-header");
INSERT INTO wpax_postmeta VALUES("557", "193", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1920;s:6:\"height\";i:436;s:4:\"file\";s:41:\"2016/12/cropped-new-york-city-guide-1.jpg\";s:5:\"sizes\";a:12:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:41:\"cropped-new-york-city-guide-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:40:\"cropped-new-york-city-guide-1-300x68.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:68;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:41:\"cropped-new-york-city-guide-1-768x174.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:174;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:42:\"cropped-new-york-city-guide-1-1024x233.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:233;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"wpca-thumb\";a:4:{s:4:\"file\";s:41:\"cropped-new-york-city-guide-1-220x150.jpg\";s:5:\"width\";i:220;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"illdy-blog-list\";a:4:{s:4:\"file\";s:41:\"cropped-new-york-city-guide-1-750x436.jpg\";s:5:\"width\";i:750;s:6:\"height\";i:436;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:25:\"illdy-widget-recent-posts\";a:4:{s:4:\"file\";s:39:\"cropped-new-york-city-guide-1-70x70.jpg\";s:5:\"width\";i:70;s:6:\"height\";i:70;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:32:\"illdy-blog-post-related-articles\";a:4:{s:4:\"file\";s:41:\"cropped-new-york-city-guide-1-240x206.jpg\";s:5:\"width\";i:240;s:6:\"height\";i:206;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:28:\"illdy-front-page-latest-news\";a:4:{s:4:\"file\";s:41:\"cropped-new-york-city-guide-1-360x213.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:213;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:29:\"illdy-front-page-testimonials\";a:4:{s:4:\"file\";s:41:\"cropped-new-york-city-guide-1-127x127.jpg\";s:5:\"width\";i:127;s:6:\"height\";i:127;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:25:\"illdy-front-page-projects\";a:4:{s:4:\"file\";s:41:\"cropped-new-york-city-guide-1-476x436.jpg\";s:5:\"width\";i:476;s:6:\"height\";i:436;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:23:\"illdy-front-page-person\";a:4:{s:4:\"file\";s:41:\"cropped-new-york-city-guide-1-125x125.jpg\";s:5:\"width\";i:125;s:6:\"height\";i:125;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO wpax_postmeta VALUES("560", "194", "_wp_attached_file", "2016/12/cropped-new-york-city-guide-2.jpg");
INSERT INTO wpax_postmeta VALUES("561", "194", "_wp_attachment_context", "custom-header");
INSERT INTO wpax_postmeta VALUES("562", "194", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1920;s:6:\"height\";i:533;s:4:\"file\";s:41:\"2016/12/cropped-new-york-city-guide-2.jpg\";s:5:\"sizes\";a:12:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:41:\"cropped-new-york-city-guide-2-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:40:\"cropped-new-york-city-guide-2-300x83.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:83;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:41:\"cropped-new-york-city-guide-2-768x213.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:213;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:42:\"cropped-new-york-city-guide-2-1024x284.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:284;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"wpca-thumb\";a:4:{s:4:\"file\";s:41:\"cropped-new-york-city-guide-2-220x150.jpg\";s:5:\"width\";i:220;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"illdy-blog-list\";a:4:{s:4:\"file\";s:41:\"cropped-new-york-city-guide-2-750x500.jpg\";s:5:\"width\";i:750;s:6:\"height\";i:500;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:25:\"illdy-widget-recent-posts\";a:4:{s:4:\"file\";s:39:\"cropped-new-york-city-guide-2-70x70.jpg\";s:5:\"width\";i:70;s:6:\"height\";i:70;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:32:\"illdy-blog-post-related-articles\";a:4:{s:4:\"file\";s:41:\"cropped-new-york-city-guide-2-240x206.jpg\";s:5:\"width\";i:240;s:6:\"height\";i:206;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:28:\"illdy-front-page-latest-news\";a:4:{s:4:\"file\";s:41:\"cropped-new-york-city-guide-2-360x213.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:213;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:29:\"illdy-front-page-testimonials\";a:4:{s:4:\"file\";s:41:\"cropped-new-york-city-guide-2-127x127.jpg\";s:5:\"width\";i:127;s:6:\"height\";i:127;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:25:\"illdy-front-page-projects\";a:4:{s:4:\"file\";s:41:\"cropped-new-york-city-guide-2-476x476.jpg\";s:5:\"width\";i:476;s:6:\"height\";i:476;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:23:\"illdy-front-page-person\";a:4:{s:4:\"file\";s:41:\"cropped-new-york-city-guide-2-125x125.jpg\";s:5:\"width\";i:125;s:6:\"height\";i:125;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO wpax_postmeta VALUES("565", "192", "_wp_trash_meta_status", "publish");
INSERT INTO wpax_postmeta VALUES("566", "192", "_wp_trash_meta_time", "1482428314");
INSERT INTO wpax_postmeta VALUES("567", "192", "_publicize_pending", "1");
INSERT INTO wpax_postmeta VALUES("568", "153", "_jetpack_dont_email_post_to_subs", "1");
INSERT INTO wpax_postmeta VALUES("569", "195", "_wp_trash_meta_status", "publish");
INSERT INTO wpax_postmeta VALUES("570", "195", "_wp_trash_meta_time", "1482428622");
INSERT INTO wpax_postmeta VALUES("571", "195", "_publicize_pending", "1");
INSERT INTO wpax_postmeta VALUES("572", "197", "_wp_trash_meta_status", "publish");
INSERT INTO wpax_postmeta VALUES("573", "197", "_wp_trash_meta_time", "1482428681");
INSERT INTO wpax_postmeta VALUES("574", "197", "_publicize_pending", "1");
INSERT INTO wpax_postmeta VALUES("575", "199", "_wp_trash_meta_status", "publish");
INSERT INTO wpax_postmeta VALUES("576", "199", "_wp_trash_meta_time", "1482428744");
INSERT INTO wpax_postmeta VALUES("577", "199", "_publicize_pending", "1");
INSERT INTO wpax_postmeta VALUES("578", "201", "_wp_trash_meta_status", "publish");
INSERT INTO wpax_postmeta VALUES("579", "201", "_wp_trash_meta_time", "1482428795");
INSERT INTO wpax_postmeta VALUES("580", "201", "_publicize_pending", "1");
INSERT INTO wpax_postmeta VALUES("581", "203", "_wp_trash_meta_status", "publish");
INSERT INTO wpax_postmeta VALUES("582", "203", "_wp_trash_meta_time", "1482428807");
INSERT INTO wpax_postmeta VALUES("583", "203", "_publicize_pending", "1");
INSERT INTO wpax_postmeta VALUES("584", "205", "_wp_trash_meta_status", "publish");
INSERT INTO wpax_postmeta VALUES("585", "205", "_wp_trash_meta_time", "1482428898");
INSERT INTO wpax_postmeta VALUES("586", "205", "_publicize_pending", "1");
INSERT INTO wpax_postmeta VALUES("587", "207", "_wp_trash_meta_status", "publish");
INSERT INTO wpax_postmeta VALUES("588", "207", "_wp_trash_meta_time", "1482428907");
INSERT INTO wpax_postmeta VALUES("589", "207", "_publicize_pending", "1");
INSERT INTO wpax_postmeta VALUES("590", "213", "_wp_trash_meta_status", "publish");
INSERT INTO wpax_postmeta VALUES("591", "213", "_wp_trash_meta_time", "1482429328");
INSERT INTO wpax_postmeta VALUES("592", "213", "_publicize_pending", "1");
INSERT INTO wpax_postmeta VALUES("593", "215", "_wp_trash_meta_status", "publish");
INSERT INTO wpax_postmeta VALUES("594", "215", "_wp_trash_meta_time", "1482429370");
INSERT INTO wpax_postmeta VALUES("595", "215", "_publicize_pending", "1");
INSERT INTO wpax_postmeta VALUES("596", "217", "_wp_trash_meta_status", "publish");
INSERT INTO wpax_postmeta VALUES("597", "217", "_wp_trash_meta_time", "1482429420");
INSERT INTO wpax_postmeta VALUES("598", "217", "_publicize_pending", "1");
INSERT INTO wpax_postmeta VALUES("599", "220", "_wp_trash_meta_status", "publish");
INSERT INTO wpax_postmeta VALUES("600", "220", "_wp_trash_meta_time", "1482429473");
INSERT INTO wpax_postmeta VALUES("601", "220", "_publicize_pending", "1");
INSERT INTO wpax_postmeta VALUES("602", "221", "_wp_trash_meta_status", "publish");
INSERT INTO wpax_postmeta VALUES("603", "221", "_wp_trash_meta_time", "1482429497");
INSERT INTO wpax_postmeta VALUES("604", "221", "_publicize_pending", "1");
INSERT INTO wpax_postmeta VALUES("605", "223", "_wp_attached_file", "2016/12/cropped-city-background-3.jpg");
INSERT INTO wpax_postmeta VALUES("606", "223", "_wp_attachment_context", "custom-header");
INSERT INTO wpax_postmeta VALUES("607", "223", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1920;s:6:\"height\";i:387;s:4:\"file\";s:37:\"2016/12/cropped-city-background-3.jpg\";s:5:\"sizes\";a:12:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:37:\"cropped-city-background-3-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:36:\"cropped-city-background-3-300x60.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:60;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:37:\"cropped-city-background-3-768x155.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:155;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:38:\"cropped-city-background-3-1024x206.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:206;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"wpca-thumb\";a:4:{s:4:\"file\";s:37:\"cropped-city-background-3-220x150.jpg\";s:5:\"width\";i:220;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"illdy-blog-list\";a:4:{s:4:\"file\";s:37:\"cropped-city-background-3-750x387.jpg\";s:5:\"width\";i:750;s:6:\"height\";i:387;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:25:\"illdy-widget-recent-posts\";a:4:{s:4:\"file\";s:35:\"cropped-city-background-3-70x70.jpg\";s:5:\"width\";i:70;s:6:\"height\";i:70;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:32:\"illdy-blog-post-related-articles\";a:4:{s:4:\"file\";s:37:\"cropped-city-background-3-240x206.jpg\";s:5:\"width\";i:240;s:6:\"height\";i:206;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:28:\"illdy-front-page-latest-news\";a:4:{s:4:\"file\";s:37:\"cropped-city-background-3-360x213.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:213;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:29:\"illdy-front-page-testimonials\";a:4:{s:4:\"file\";s:37:\"cropped-city-background-3-127x127.jpg\";s:5:\"width\";i:127;s:6:\"height\";i:127;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:25:\"illdy-front-page-projects\";a:4:{s:4:\"file\";s:37:\"cropped-city-background-3-476x387.jpg\";s:5:\"width\";i:476;s:6:\"height\";i:387;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:23:\"illdy-front-page-person\";a:4:{s:4:\"file\";s:37:\"cropped-city-background-3-125x125.jpg\";s:5:\"width\";i:125;s:6:\"height\";i:125;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO wpax_postmeta VALUES("608", "223", "_wp_attachment_custom_header_last_used_illdy", "1482430208");
INSERT INTO wpax_postmeta VALUES("609", "223", "_wp_attachment_is_custom_header", "illdy");
INSERT INTO wpax_postmeta VALUES("610", "228", "_edit_last", "1");
INSERT INTO wpax_postmeta VALUES("611", "228", "_wp_page_template", "default");
INSERT INTO wpax_postmeta VALUES("612", "228", "_publicize_pending", "1");
INSERT INTO wpax_postmeta VALUES("613", "228", "_edit_lock", "1482514948:1");
INSERT INTO wpax_postmeta VALUES("614", "222", "_wp_trash_meta_status", "publish");
INSERT INTO wpax_postmeta VALUES("615", "222", "_wp_trash_meta_time", "1482430208");
INSERT INTO wpax_postmeta VALUES("616", "222", "_publicize_pending", "1");
INSERT INTO wpax_postmeta VALUES("617", "230", "ufaq_order", "1000");
INSERT INTO wpax_postmeta VALUES("618", "230", "_edit_lock", "1482433233:1");
INSERT INTO wpax_postmeta VALUES("619", "230", "_edit_last", "1");
INSERT INTO wpax_postmeta VALUES("620", "230", "_publicize_pending", "1");
INSERT INTO wpax_postmeta VALUES("621", "230", "EWD_UFAQ_Post_Author", "Emma - GramGro");
INSERT INTO wpax_postmeta VALUES("622", "228", "_jetpack_dont_email_post_to_subs", "1");
INSERT INTO wpax_postmeta VALUES("623", "230", "ufaq_view_count", "2");
INSERT INTO wpax_postmeta VALUES("624", "234", "_edit_lock", "1482435552:1");
INSERT INTO wpax_postmeta VALUES("625", "234", "_edit_last", "1");
INSERT INTO wpax_postmeta VALUES("626", "234", "_publicize_pending", "1");
INSERT INTO wpax_postmeta VALUES("627", "234", "wpsm_faq_data", "s:586:\"a:2:{i:0;a:4:{s:9:\"faq_title\";s:0:\"\";s:14:\"faq_title_icon\";s:16:\"fa-chevron-right\";s:18:\"enable_single_icon\";s:3:\"yes\";s:8:\"faq_desc\";s:312:\"GramGro is a software tool designed to help you automate tasks on Instagram that will increase engagement with a targeted group of users who in return will engage back with you by following your page and liking your content. The users are real and active, and do not disappear after time like \"ghost\" followers. \";}i:1;a:4:{s:9:\"faq_title\";s:0:\"\";s:14:\"faq_title_icon\";s:9:\"fa-laptop\";s:18:\"enable_single_icon\";s:3:\"yes\";s:8:\"faq_desc\";s:0:\"\";}}\";");
INSERT INTO wpax_postmeta VALUES("628", "234", "wpsm_faq_count", "2");
INSERT INTO wpax_postmeta VALUES("629", "234", "Wpsm_Faq_Shortcode_Settings", "s:650:\"a:20:{s:13:\"acc_sec_title\";s:3:\"yes\";s:10:\"op_cl_icon\";s:1:\"3\";s:14:\"acc_title_icon\";s:3:\"yes\";s:10:\"acc_radius\";s:3:\"yes\";s:10:\"acc_margin\";s:3:\"yes\";s:15:\"acc_op_cl_align\";N;s:13:\"enable_toggle\";s:3:\"yes\";s:16:\"enable_ac_border\";s:3:\"yes\";s:16:\"acc_title_bg_clr\";s:7:\"#ffffff\";s:18:\"acc_title_icon_clr\";s:7:\"#000000\";s:23:\"acc_open_cl_icon_bg_clr\";s:7:\"#dd3333\";s:23:\"acc_open_cl_icon_ft_clr\";s:7:\"#ffffff\";s:15:\"acc_desc_bg_clr\";s:7:\"#ffffff\";s:17:\"acc_desc_font_clr\";s:7:\"#000000\";s:10:\"title_size\";s:2:\"18\";s:8:\"des_size\";s:2:\"16\";s:11:\"font_family\";s:9:\"Open Sans\";s:10:\"custom_css\";s:0:\"\";s:13:\"expand_option\";s:1:\"3\";s:9:\"ac_styles\";s:1:\"2\";}\";");
INSERT INTO wpax_postmeta VALUES("630", "237", "_edit_lock", "1482435900:1");
INSERT INTO wpax_postmeta VALUES("631", "237", "_edit_last", "1");
INSERT INTO wpax_postmeta VALUES("632", "237", "_publicize_pending", "1");
INSERT INTO wpax_postmeta VALUES("633", "237", "wpsm_faq_data", "s:4485:\"a:8:{i:0;a:4:{s:9:\"faq_title\";s:22:\"How does GramGro work?\";s:14:\"faq_title_icon\";s:9:\"fa-laptop\";s:18:\"enable_single_icon\";s:3:\"yes\";s:8:\"faq_desc\";s:312:\"GramGro is a software tool designed to help you automate tasks on Instagram that will increase engagement with a targeted group of users who in return will engage back with you by following your page and liking your content. The users are real and active, and do not disappear after time like \"ghost\" followers. \";}i:1;a:4:{s:9:\"faq_title\";s:39:\"Why do you need to my account password?\";s:14:\"faq_title_icon\";s:14:\"fa-angle-right\";s:18:\"enable_single_icon\";s:3:\"yes\";s:8:\"faq_desc\";s:396:\"Our software requires logging into your account in order to execute the tasks you set on your behalf. Your account details are entered into a secure and encrypted platform that directly logs your account into our tool. Once your account is connected, your password will be removed from our data servers and will not be needed again unless your account is unconnected or you change your password. \";}i:2;a:4:{s:9:\"faq_title\";s:27:\"What is account checkpoint?\";s:14:\"faq_title_icon\";s:14:\"fa-angle-right\";s:18:\"enable_single_icon\";s:3:\"yes\";s:8:\"faq_desc\";s:363:\"When our tool accesses your Instagram account, Instagram requires that you verify your account was logged in an in approved location. As a result, you should expect to receive a checkpoint email from Instagram once we initially log your account into our tool. This checkpoint may come in the form of a six digit code or instant verification in your Instagram app.\";}i:3;a:4:{s:9:\"faq_title\";s:67:\"I purchased a plan but have not seen any results? What is going on?\";s:14:\"faq_title_icon\";s:14:\"fa-angle-right\";s:18:\"enable_single_icon\";s:3:\"yes\";s:8:\"faq_desc\";s:504:\"Thank you for purchasing a plan. If you are a first time purchaser, it takes some time to fully connect your account and set your targeting settings before we can begin automating your tasks. Rest assured, your purchased time does NOT start until your tasks begin. Please make sure you set your targeting settings, connected your account, and verified by checkpoint if necessary. GramGro will email you with any issues, including missing/incorrect account info, or a request for checkpoint verification. \";}i:4;a:4:{s:9:\"faq_title\";s:36:\"How should I set targeting settings?\";s:14:\"faq_title_icon\";s:14:\"fa-angle-right\";s:18:\"enable_single_icon\";s:3:\"yes\";s:8:\"faq_desc\";s:1075:\"Deciding who to target can be challenging but we are here to help. Depending on the type of page you have, you can target by scraping from hashtags, users, or location. Here are examples of how each setting can be used. \r\nHashtags: A makeup artist uses GramGro to gain a reputation among other makeup artists and fans of makeup. She wants to get as many followers as possible and doesn’t care where they are from. She targets using top makeup related hashtags that makeup artists and fans use in their photos. \r\nUsers: An online t-shirt company owner wants to attract customers on Instagram. He just received a lot of NBA related inventory that he wants to sell to interested fans. He scrapes from top NBA players’ Instagram accounts in order to gain potential customers attention. \r\nLocation: A bar owner outside of a local sports venue wants fans who attend the venue to know about his pregame and postgame specials. He targets users who tag the stadium in their pictures in order to let them know he is by the stadium and has good deals they would be interested in. \r\n\";}i:5;a:4:{s:9:\"faq_title\";s:36:\"Can I connect more than one account?\";s:14:\"faq_title_icon\";s:14:\"fa-angle-right\";s:18:\"enable_single_icon\";s:3:\"yes\";s:8:\"faq_desc\";s:120:\"Yes! You can connect up to as many accounts as you would like. If you are interested in a bundle deal, please email us. \";}i:6;a:4:{s:9:\"faq_title\";s:35:\"Can I change my targeting settings?\";s:14:\"faq_title_icon\";s:14:\"fa-angle-right\";s:18:\"enable_single_icon\";s:3:\"yes\";s:8:\"faq_desc\";s:263:\"Changing your targeting settings can help you achieve better results. Before changing your settings email us with your objective and who you are trying to target so we can better understand your goals and offer insights and advice into the best targeting options.\";}i:7;a:4:{s:9:\"faq_title\";s:43:\"My plan is expiring soon, how can I extend?\";s:14:\"faq_title_icon\";s:14:\"fa-angle-right\";s:18:\"enable_single_icon\";s:3:\"yes\";s:8:\"faq_desc\";s:43:\"Extend by purchasing additional time here. \";}}\";");
INSERT INTO wpax_postmeta VALUES("634", "237", "wpsm_faq_count", "8");
INSERT INTO wpax_postmeta VALUES("635", "237", "Wpsm_Faq_Shortcode_Settings", "s:649:\"a:20:{s:13:\"acc_sec_title\";s:3:\"yes\";s:10:\"op_cl_icon\";s:1:\"1\";s:14:\"acc_title_icon\";s:2:\"no\";s:10:\"acc_radius\";s:3:\"yes\";s:10:\"acc_margin\";s:3:\"yes\";s:15:\"acc_op_cl_align\";N;s:13:\"enable_toggle\";s:3:\"yes\";s:16:\"enable_ac_border\";s:3:\"yes\";s:16:\"acc_title_bg_clr\";s:7:\"#ffffff\";s:18:\"acc_title_icon_clr\";s:7:\"#000000\";s:23:\"acc_open_cl_icon_bg_clr\";s:7:\"#dd3333\";s:23:\"acc_open_cl_icon_ft_clr\";s:7:\"#ffffff\";s:15:\"acc_desc_bg_clr\";s:7:\"#ffffff\";s:17:\"acc_desc_font_clr\";s:7:\"#000000\";s:10:\"title_size\";s:2:\"21\";s:8:\"des_size\";s:2:\"16\";s:11:\"font_family\";s:9:\"Helvetica\";s:10:\"custom_css\";s:0:\"\";s:13:\"expand_option\";s:1:\"2\";s:9:\"ac_styles\";s:1:\"2\";}\";");
INSERT INTO wpax_postmeta VALUES("636", "237", "_jetpack_dont_email_post_to_subs", "1");
INSERT INTO wpax_postmeta VALUES("637", "234", "_jetpack_dont_email_post_to_subs", "1");
INSERT INTO wpax_postmeta VALUES("639", "109", "_jetpack_dont_email_post_to_subs", "1");
INSERT INTO wpax_postmeta VALUES("640", "110", "_jetpack_dont_email_post_to_subs", "1");
INSERT INTO wpax_postmeta VALUES("641", "241", "_publicize_pending", "1");
INSERT INTO wpax_postmeta VALUES("642", "241", "_menu_item_type", "post_type");
INSERT INTO wpax_postmeta VALUES("643", "241", "_menu_item_menu_item_parent", "0");
INSERT INTO wpax_postmeta VALUES("644", "241", "_menu_item_object_id", "228");
INSERT INTO wpax_postmeta VALUES("645", "241", "_menu_item_object", "page");
INSERT INTO wpax_postmeta VALUES("646", "241", "_menu_item_target", "");
INSERT INTO wpax_postmeta VALUES("647", "241", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO wpax_postmeta VALUES("648", "241", "_menu_item_xfn", "");
INSERT INTO wpax_postmeta VALUES("649", "241", "_menu_item_url", "");
INSERT INTO wpax_postmeta VALUES("650", "240", "_wp_trash_meta_status", "publish");
INSERT INTO wpax_postmeta VALUES("651", "240", "_wp_trash_meta_time", "1482435840");
INSERT INTO wpax_postmeta VALUES("652", "240", "_publicize_pending", "1");
INSERT INTO wpax_postmeta VALUES("653", "241", "_jetpack_dont_email_post_to_subs", "1");
INSERT INTO wpax_postmeta VALUES("654", "242", "_wp_trash_meta_status", "publish");
INSERT INTO wpax_postmeta VALUES("655", "242", "_wp_trash_meta_time", "1482435863");
INSERT INTO wpax_postmeta VALUES("656", "242", "_publicize_pending", "1");
INSERT INTO wpax_postmeta VALUES("659", "244", "_edit_lock", "1482436358:1");
INSERT INTO wpax_postmeta VALUES("660", "244", "_edit_last", "1");
INSERT INTO wpax_postmeta VALUES("661", "244", "_publicize_pending", "1");
INSERT INTO wpax_postmeta VALUES("662", "244", "_wp_trash_meta_status", "publish");
INSERT INTO wpax_postmeta VALUES("663", "244", "_wp_trash_meta_time", "1482437283");
INSERT INTO wpax_postmeta VALUES("664", "244", "_wp_desired_post_slug", "how-does-gramgro-work");
INSERT INTO wpax_postmeta VALUES("665", "42", "_wp_trash_meta_status", "publish");
INSERT INTO wpax_postmeta VALUES("666", "42", "_wp_trash_meta_time", "1482446433");
INSERT INTO wpax_postmeta VALUES("667", "42", "_wp_desired_post_slug", "customer-area");
INSERT INTO wpax_postmeta VALUES("668", "43", "_wp_trash_meta_status", "publish");
INSERT INTO wpax_postmeta VALUES("669", "43", "_wp_trash_meta_time", "1482446434");
INSERT INTO wpax_postmeta VALUES("670", "43", "_wp_desired_post_slug", "dashboard");
INSERT INTO wpax_postmeta VALUES("671", "44", "_wp_trash_meta_status", "publish");
INSERT INTO wpax_postmeta VALUES("672", "44", "_wp_trash_meta_time", "1482446434");
INSERT INTO wpax_postmeta VALUES("673", "44", "_wp_desired_post_slug", "files");
INSERT INTO wpax_postmeta VALUES("674", "45", "_wp_trash_meta_status", "publish");
INSERT INTO wpax_postmeta VALUES("675", "45", "_wp_trash_meta_time", "1482446434");
INSERT INTO wpax_postmeta VALUES("676", "45", "_wp_desired_post_slug", "my-files");
INSERT INTO wpax_postmeta VALUES("677", "133", "_wp_trash_meta_status", "publish");
INSERT INTO wpax_postmeta VALUES("678", "133", "_wp_trash_meta_time", "1482446434");
INSERT INTO wpax_postmeta VALUES("679", "133", "_wp_desired_post_slug", "files-2");
INSERT INTO wpax_postmeta VALUES("680", "134", "_wp_trash_meta_status", "publish");
INSERT INTO wpax_postmeta VALUES("681", "134", "_wp_trash_meta_time", "1482446434");
INSERT INTO wpax_postmeta VALUES("682", "134", "_wp_desired_post_slug", "my-files");
INSERT INTO wpax_postmeta VALUES("683", "46", "_wp_trash_meta_status", "publish");
INSERT INTO wpax_postmeta VALUES("684", "46", "_wp_trash_meta_time", "1482446434");
INSERT INTO wpax_postmeta VALUES("685", "46", "_wp_desired_post_slug", "pages");
INSERT INTO wpax_postmeta VALUES("686", "47", "_wp_trash_meta_status", "publish");
INSERT INTO wpax_postmeta VALUES("687", "47", "_wp_trash_meta_time", "1482446434");
INSERT INTO wpax_postmeta VALUES("688", "47", "_wp_desired_post_slug", "my-pages");
INSERT INTO wpax_postmeta VALUES("689", "135", "_wp_trash_meta_status", "publish");
INSERT INTO wpax_postmeta VALUES("690", "135", "_wp_trash_meta_time", "1482446434");
INSERT INTO wpax_postmeta VALUES("691", "135", "_wp_desired_post_slug", "pages-2");
INSERT INTO wpax_postmeta VALUES("692", "136", "_wp_trash_meta_status", "publish");
INSERT INTO wpax_postmeta VALUES("693", "136", "_wp_trash_meta_time", "1482446434");
INSERT INTO wpax_postmeta VALUES("694", "136", "_wp_desired_post_slug", "my-pages");
INSERT INTO wpax_postmeta VALUES("695", "48", "_wp_trash_meta_status", "publish");
INSERT INTO wpax_postmeta VALUES("696", "48", "_wp_trash_meta_time", "1482446434");
INSERT INTO wpax_postmeta VALUES("697", "48", "_wp_desired_post_slug", "my-account");
INSERT INTO wpax_postmeta VALUES("698", "49", "_wp_trash_meta_status", "publish");
INSERT INTO wpax_postmeta VALUES("699", "49", "_wp_trash_meta_time", "1482446434");
INSERT INTO wpax_postmeta VALUES("700", "49", "_wp_desired_post_slug", "account-details");
INSERT INTO wpax_postmeta VALUES("701", "101", "_wp_trash_meta_status", "publish");
INSERT INTO wpax_postmeta VALUES("702", "101", "_wp_trash_meta_time", "1482446449");
INSERT INTO wpax_postmeta VALUES("703", "101", "_wp_desired_post_slug", "get-started");
INSERT INTO wpax_postmeta VALUES("704", "50", "_wp_trash_meta_status", "publish");
INSERT INTO wpax_postmeta VALUES("705", "50", "_wp_trash_meta_time", "1482446449");
INSERT INTO wpax_postmeta VALUES("706", "50", "_wp_desired_post_slug", "edit-account");
INSERT INTO wpax_postmeta VALUES("707", "51", "_wp_trash_meta_status", "publish");
INSERT INTO wpax_postmeta VALUES("708", "51", "_wp_trash_meta_time", "1482446449");
INSERT INTO wpax_postmeta VALUES("709", "51", "_wp_desired_post_slug", "logout");
INSERT INTO wpax_postmeta VALUES("710", "2", "_wp_trash_meta_status", "publish");
INSERT INTO wpax_postmeta VALUES("711", "2", "_wp_trash_meta_time", "1482446463");
INSERT INTO wpax_postmeta VALUES("712", "2", "_wp_desired_post_slug", "sample-page");
INSERT INTO wpax_postmeta VALUES("713", "147", "_wp_trash_meta_status", "publish");
INSERT INTO wpax_postmeta VALUES("714", "147", "_wp_trash_meta_time", "1482446473");
INSERT INTO wpax_postmeta VALUES("715", "147", "_wp_desired_post_slug", "blog");
INSERT INTO wpax_postmeta VALUES("716", "274", "_wp_trash_meta_status", "publish");
INSERT INTO wpax_postmeta VALUES("717", "274", "_wp_trash_meta_time", "1482446847");
INSERT INTO wpax_postmeta VALUES("718", "274", "_publicize_pending", "1");
INSERT INTO wpax_postmeta VALUES("721", "35", "_jetpack_dont_email_post_to_subs", "1");
INSERT INTO wpax_postmeta VALUES("722", "279", "_edit_lock", "1482518740:1");
INSERT INTO wpax_postmeta VALUES("723", "279", "_edit_last", "1");
INSERT INTO wpax_postmeta VALUES("724", "279", "_wp_page_template", "default");
INSERT INTO wpax_postmeta VALUES("725", "279", "_publicize_pending", "1");
INSERT INTO wpax_postmeta VALUES("726", "282", "_publicize_pending", "1");
INSERT INTO wpax_postmeta VALUES("727", "282", "_menu_item_type", "post_type");
INSERT INTO wpax_postmeta VALUES("728", "282", "_menu_item_menu_item_parent", "0");
INSERT INTO wpax_postmeta VALUES("729", "282", "_menu_item_object_id", "35");
INSERT INTO wpax_postmeta VALUES("730", "282", "_menu_item_object", "page");
INSERT INTO wpax_postmeta VALUES("731", "282", "_menu_item_target", "");
INSERT INTO wpax_postmeta VALUES("732", "282", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO wpax_postmeta VALUES("733", "282", "_menu_item_xfn", "");
INSERT INTO wpax_postmeta VALUES("734", "282", "_menu_item_url", "");
INSERT INTO wpax_postmeta VALUES("735", "281", "_wp_trash_meta_status", "publish");
INSERT INTO wpax_postmeta VALUES("736", "281", "_wp_trash_meta_time", "1482457950");
INSERT INTO wpax_postmeta VALUES("737", "281", "_publicize_pending", "1");
INSERT INTO wpax_postmeta VALUES("738", "283", "_wp_attached_file", "2016/12/pushgram.jpg");
INSERT INTO wpax_postmeta VALUES("739", "283", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:2480;s:6:\"height\";i:3508;s:4:\"file\";s:20:\"2016/12/pushgram.jpg\";s:5:\"sizes\";a:11:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:20:\"pushgram-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"pushgram-212x300.jpg\";s:5:\"width\";i:212;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:21:\"pushgram-768x1086.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:1086;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:21:\"pushgram-724x1024.jpg\";s:5:\"width\";i:724;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"illdy-blog-list\";a:4:{s:4:\"file\";s:20:\"pushgram-750x500.jpg\";s:5:\"width\";i:750;s:6:\"height\";i:500;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:25:\"illdy-widget-recent-posts\";a:4:{s:4:\"file\";s:18:\"pushgram-70x70.jpg\";s:5:\"width\";i:70;s:6:\"height\";i:70;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:32:\"illdy-blog-post-related-articles\";a:4:{s:4:\"file\";s:20:\"pushgram-240x206.jpg\";s:5:\"width\";i:240;s:6:\"height\";i:206;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:28:\"illdy-front-page-latest-news\";a:4:{s:4:\"file\";s:20:\"pushgram-360x213.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:213;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:29:\"illdy-front-page-testimonials\";a:4:{s:4:\"file\";s:20:\"pushgram-127x127.jpg\";s:5:\"width\";i:127;s:6:\"height\";i:127;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:25:\"illdy-front-page-projects\";a:4:{s:4:\"file\";s:20:\"pushgram-476x476.jpg\";s:5:\"width\";i:476;s:6:\"height\";i:476;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:23:\"illdy-front-page-person\";a:4:{s:4:\"file\";s:20:\"pushgram-125x125.jpg\";s:5:\"width\";i:125;s:6:\"height\";i:125;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO wpax_postmeta VALUES("740", "285", "_wp_trash_meta_status", "publish");
INSERT INTO wpax_postmeta VALUES("741", "285", "_wp_trash_meta_time", "1482514830");
INSERT INTO wpax_postmeta VALUES("742", "285", "_publicize_pending", "1");
INSERT INTO wpax_postmeta VALUES("743", "279", "_g_feedback_shortcode", "[contact-field label=\'Instagram Username\' type=\'text\'/][contact-field label=\'Instagram Password\' type=\'text\'/][contact-field label=\'Confirm Instagram Password\' type=\'text\'/][contact-field label=\'Email \' type=\'text\'/]");
INSERT INTO wpax_postmeta VALUES("744", "279", "_g_feedback_shortcode_atts", "a:6:{s:2:\"to\";s:20:\"gramgropro@gmail.com\";s:7:\"subject\";s:30:\"[GramGro] Connect Your Account\";s:12:\"show_subject\";s:2:\"no\";s:6:\"widget\";i:0;s:2:\"id\";i:279;s:18:\"submit_button_text\";s:13:\"Submit &#187;\";}");
INSERT INTO wpax_postmeta VALUES("745", "279", "_jetpack_dont_email_post_to_subs", "1");
INSERT INTO wpax_postmeta VALUES("746", "289", "_publicize_pending", "1");
INSERT INTO wpax_postmeta VALUES("747", "289", "_feedback_extra_fields", "a:4:{s:20:\"5_Instagram Username\";s:8:\"hussbazz\";s:20:\"6_Instagram Password\";s:10:\"miggsmaggs\";s:28:\"7_Confirm Instagram Password\";s:10:\"miggsmaggs\";s:8:\"8_Email \";s:18:\"hbazzi13@gmail.com\";}");
INSERT INTO wpax_postmeta VALUES("748", "289", "_feedback_email", "a:2:{s:2:\"to\";a:1:{i:0;s:20:\"gramgropro@gmail.com\";}s:7:\"message\";s:378:\"<b>Instagram Username:</b> hussbazz<br /><br />\n<b>Instagram Password:</b> miggsmaggs<br /><br />\n<b>Confirm Instagram Password:</b> miggsmaggs<br /><br />\n<b>Email :</b> hbazzi13@gmail.com<br /><br />\n\n<hr />\nTime: December 23, 2016 at 6:08 pm<br />\nIP Address: 100.38.10.251<br />\nContact Form URL: http://gramgro.com/connect/<br />\nSent by an unverified visitor to your site.\";}");
INSERT INTO wpax_postmeta VALUES("749", "290", "_publicize_pending", "1");
INSERT INTO wpax_postmeta VALUES("750", "290", "_feedback_extra_fields", "a:4:{s:20:\"5_Instagram Username\";s:8:\"hussbazz\";s:20:\"6_Instagram Password\";s:10:\"miggsmaggs\";s:28:\"7_Confirm Instagram Password\";s:10:\"miggsmaggs\";s:8:\"8_Email \";s:18:\"hbazzi13@gmail.com\";}");
INSERT INTO wpax_postmeta VALUES("751", "290", "_feedback_email", "a:2:{s:2:\"to\";a:1:{i:0;s:20:\"gramgropro@gmail.com\";}s:7:\"message\";s:378:\"<b>Instagram Username:</b> hussbazz<br /><br />\n<b>Instagram Password:</b> miggsmaggs<br /><br />\n<b>Confirm Instagram Password:</b> miggsmaggs<br /><br />\n<b>Email :</b> hbazzi13@gmail.com<br /><br />\n\n<hr />\nTime: December 23, 2016 at 6:08 pm<br />\nIP Address: 100.38.10.251<br />\nContact Form URL: http://gramgro.com/connect/<br />\nSent by an unverified visitor to your site.\";}");

DROP TABLE IF EXISTS wpax_posts;

CREATE TABLE `wpax_posts` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint(20) unsigned NOT NULL DEFAULT '0',
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_title` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_excerpt` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_status` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'open',
  `post_password` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `post_name` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `to_ping` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `pinged` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `guid` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `menu_order` int(11) NOT NULL DEFAULT '0',
  `post_type` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_count` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`(191)),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`)
) ENGINE=InnoDB AUTO_INCREMENT=297 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO wpax_posts VALUES("1", "1", "2016-12-15 00:39:41", "2016-12-15 00:39:41", "Welcome to WordPress. This is your first post. Edit or delete it, then start writing!", "Hello world!", "", "publish", "open", "open", "", "hello-world", "", "", "2016-12-15 00:39:41", "2016-12-15 00:39:41", "", "0", "http://gramgro.com/?p=1", "0", "post", "", "1");
INSERT INTO wpax_posts VALUES("2", "1", "2016-12-15 00:39:41", "2016-12-15 00:39:41", "<iframe width=\"560\" height=\"315\" src=\"https://www.youtube.com/embed/-TDAfnU_2bY\" frameborder=\"0\" allowfullscreen></iframe>", "", "", "trash", "closed", "open", "", "sample-page__trashed", "", "", "2016-12-22 22:41:03", "2016-12-22 22:41:03", "", "0", "http://gramgro.com/?page_id=2", "0", "page", "", "0");
INSERT INTO wpax_posts VALUES("24", "1", "2016-12-16 04:09:39", "2016-12-16 04:09:39", "", "new-york-city-guide", "", "inherit", "open", "closed", "", "new-york-city-guide", "", "", "2016-12-16 04:09:39", "2016-12-16 04:09:39", "", "0", "http://gramgro.com/wp-content/uploads/2016/12/new-york-city-guide.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO wpax_posts VALUES("25", "1", "2016-12-16 04:09:59", "2016-12-16 04:09:59", "http://gramgro.com/wp-content/uploads/2016/12/cropped-new-york-city-guide.jpg", "cropped-new-york-city-guide.jpg", "", "inherit", "open", "closed", "", "cropped-new-york-city-guide-jpg", "", "", "2016-12-16 04:09:59", "2016-12-16 04:09:59", "", "0", "http://gramgro.com/wp-content/uploads/2016/12/cropped-new-york-city-guide.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO wpax_posts VALUES("35", "1", "2016-12-16 06:01:51", "2016-12-16 06:01:51", "[powr-order-form id=f392308a_1482453150]", "Get Started with GramGro", "", "publish", "closed", "closed", "", "try", "", "", "2016-12-23 18:50:17", "2016-12-23 18:50:17", "", "0", "http://gramgro.com/?page_id=35", "0", "page", "", "0");
INSERT INTO wpax_posts VALUES("36", "1", "2016-12-16 06:01:51", "2016-12-16 06:01:51", "Hello!", "Get Started with GramGro", "", "inherit", "closed", "closed", "", "35-revision-v1", "", "", "2016-12-16 06:01:51", "2016-12-16 06:01:51", "", "35", "http://gramgro.com/2016/12/16/35-revision-v1/", "0", "revision", "", "0");
INSERT INTO wpax_posts VALUES("38", "1", "2016-12-16 06:18:54", "2016-12-16 06:18:54", "", "Get Started with GramGro", "", "inherit", "closed", "closed", "", "35-autosave-v1", "", "", "2016-12-16 06:18:54", "2016-12-16 06:18:54", "", "35", "http://gramgro.com/2016/12/16/35-autosave-v1/", "0", "revision", "", "0");
INSERT INTO wpax_posts VALUES("39", "1", "2016-12-16 06:20:23", "2016-12-16 06:20:23", "<html>\r\n<head>\r\n <meta name=\"viewport\" content=\"width=1000, initial-scale=1.0, maximum-scale=1.0\">\r\n<link href=\"style.css\" type=\"text/css\" rel=\"stylesheet\">\r\n</head>\r\n<body>\r\n<!-- multistep form -->\r\n<form id=\"msform\" onsubmit=\"return false\">\r\n	<!-- progressbar -->\r\n\r\n	<!-- fieldsets 1 -->\r\n	\r\n	<fieldset>\r\n	<p>\r\n		<h2 class=\"fs-title\">I use Instagram primarily to...</h2>\r\n		<input type=\"button\" name=\"next\" class=\"next action-button\" value=\"Build a Reputation\" onclick=\"build_reputation()\" /> <br>\r\n		<input type=\"button\" name=\"next\" class=\"next action-button\" value=\"Sell Product/Services\" onclick=\"sell_product()\"/> <br>\r\n		<input type=\"button\" name=\"next\" class=\"next action-button\" value=\"Raise Awareness for a Cause Event\" onclick=\"raise_awareness()\"/>\r\n	</p>\r\n	</fieldset>\r\n	\r\n	\r\n	\r\n	\r\n	\r\n	\r\n</form>\r\n\r\n\r\n<!-- jQuery -->\r\n\r\n<script src=\"http://thecodeplayer.com/uploads/js/jquery-1.9.1.min.js\" type=\"text/javascript\"></script>\r\n<!-- jQuery easing plugin -->\r\n<script src=\"http://thecodeplayer.com/uploads/js/jquery.easing.min.js\" type=\"text/javascript\"></script>\r\n<script src=\"main.js\" type=\"text/javascript\"></script>\r\n\r\n<script>\r\n/*MAIN*/\r\nfunction build_reputation(){\r\nvar newFieldSet = document.createElement(\"fieldset\");\r\nnewFieldSet.className = \"build_reputation\";\r\nnewFieldSet.innerHTML = \'<p>\'+\r\n		\'<h2 class=\"fs-title\">I want to build a reputation…</h2>\'+\r\n		\'<input type=\"button\" name=\"next\" class=\"next action-button\" value=\"In a specific location \" onclick=\"specific_location();\"/>\'+\r\n		\'<input type=\"button\" name=\"next\" class=\"next action-button\" value=\"With those interested in the content I share\" onclick=\"interest_content();\"/>\'+\r\n		\'<input type=\"button\" name=\"previous\" class=\"previous action-button\" value=\"Previous\" id=\"build_reputation\" style=\"background-color:#c0d6c9\"/>\'+\r\n		\'</p>\';\r\n		\r\ndocument.getElementById(\"msform\").appendChild(newFieldSet);\r\n}\r\n\r\nfunction sell_product(){\r\nvar newFieldSet = document.createElement(\"fieldset\");\r\nnewFieldSet.className = \"sell_product\";\r\nnewFieldSet.innerHTML = \'<p>\'+\r\n		\'<h2 class=\"fs-title\">Sell Product/Services</h2>\'+\r\n		\'<input type=\"button\" name=\"next\" class=\"next action-button\" value=\"In a specific location \" onclick=\"specific_location();\"/>\'+\r\n		\'<input type=\"button\" name=\"next\" class=\"next action-button\" value=\"To anyone I can deliver to\" onclick=\"product_sell();\"/>\'+\r\n		\'<input type=\"button\" name=\"previous\" class=\"previous action-button\" value=\"Previous\" id=\"sell_product\" style=\"background-color:#c0d6c9\"/>\'+\r\n		\'</p>\';\r\n		\r\ndocument.getElementById(\"msform\").appendChild(newFieldSet);\r\n}\r\n\r\nfunction raise_awareness(){\r\nvar newFieldSet = document.createElement(\"fieldset\");\r\nnewFieldSet.className = \"raise_awareness\";\r\nnewFieldSet.innerHTML = \'<p>\'+\r\n		\'<h2 class=\"fs-title\">Raise Awareness for A Cause</h2>\'+\r\n		\'<input type=\"button\" name=\"next\" class=\"next action-button\" value=\"Happening in a specific location\" onclick=\"specific_location();\"/>\'+\r\n		\'<input type=\"button\" name=\"next\" class=\"next action-button\" value=\"That is global\" onclick=\"that_global();\"/>\'+\r\n		\'<input type=\"button\" name=\"previous\" class=\"previous action-button\" value=\"Previous\" id=\"raise_awareness\" style=\"background-color:#c0d6c9\"/>\'+\r\n		\'</p>\';\r\n		\r\ndocument.getElementById(\"msform\").appendChild(newFieldSet);\r\n}\r\n\r\n/*PART 1*/\r\nfunction specific_location(){\r\nvar newFieldSet = document.createElement(\"fieldset\");\r\nnewFieldSet.className = \"specific_location\";\r\nnewFieldSet.innerHTML = \'<p><h2 class=\"fs-title\">What is the location you want to build a reputation in?  </h2>\'+\r\n		\'<h3 class=\"fs-subtitle\">Enter the city, state, or country</h3>\'+\r\n		\'<input type=\"button\" name=\"previous\" id=\"specific_location\" class=\"previous action-button\" value=\"Previous\" style=\"background-color:#c0d6c9\"/>	\'+\r\n		\'<input type=\"text\" id=\"country_text\" onkeydown=\"javascript: if (event.keyCode==13) {$(\\\'#specific_location_next\\\').click();}\">\'+\r\n		\'<input type=\"button\" id=\"specific_location_next\" name=\"next\" class=\"next action-button\" value=\"Next\" onclick=\"listCity();\"/></p>\';\r\n		\r\ndocument.getElementById(\"msform\").appendChild(newFieldSet);\r\n};\r\n\r\nfunction listCity(){\r\nvar newFieldSet = document.createElement(\"fieldset\");\r\nnewFieldSet.className = \"listCity\";\r\nnewFieldSet.innerHTML = \'<h2 class=\"fs-title\">In a specific location </h2>\'+\r\n		\'<h3 class=\"fs-subtitle\">City List</h3>\'+\r\n		\'<p class=\"city\"></p>\'+\r\n		\'<input type=\"button\" name=\"previous\" id=\"listCity\" class=\"previous action-button\" value=\"Previous\" style=\"background-color:#c0d6c9\"/>\'+\r\n		\'<input type=\"submit\" name=\"submit\" class=\"submit action-button\" value=\"Submit\" />\';\r\ndocument.getElementById(\"msform\").appendChild(newFieldSet);\r\ncityList(document.getElementById(\'country_text\').value);\r\n};\r\n\r\nfunction interest_content(){\r\nvar newFieldSet = document.createElement(\"fieldset\");\r\nnewFieldSet.className = \"interest_content\";\r\nnewFieldSet.innerHTML = \'<p><h2 class=\"fs-title\">What Industry are you in? Be specific?  </h2>\'+\r\n		\'<h3 class=\"fs-subtitle\">Ex: Real Estate, Make Up, Fitness, Model, Fashion</h3>\'+\r\n		\'<input type=\"button\" name=\"previous\" id=\"interest_content\" class=\"previous action-button\" value=\"Previous\" style=\"background-color:#c0d6c9\"/>	\'+\r\n		\'<input type=\"text\" id=\"industry\" onkeydown=\"javascript: if (event.keyCode==13) {$(\\\'#interest_content_next\\\').click();}\">\'+\r\n		\'<input type=\"button\" id=\"interest_content_next\" name=\"next\" class=\"next action-button\" value=\"Next\" onclick=\"hash_list();\"/></p>\';\r\n		\r\ndocument.getElementById(\"msform\").appendChild(newFieldSet);\r\n};\r\n\r\nfunction hash_list(){\r\nvar newFieldSet = document.createElement(\"fieldset\");\r\nnewFieldSet.className = \"hash_list\";\r\nnewFieldSet.innerHTML = \'<h2 class=\"fs-title\">Hashtag List</h2>\'+\r\n		\'<input type=\"button\" name=\"previous\" id=\"hash_list\" class=\"previous action-button\" value=\"Previous\" style=\"background-color:#c0d6c9\"/>\'+\r\n		\'<input type=\"hidden\" id=\"hash_list_selected_value\">\'+\r\n		\'<input type=\"button\"  name=\"next\" class=\"next action-button\" value=\"Next\" onclick=\"show_users($(\\\'#hash_list_selected_value\\\').val());\"/>\';\r\ndocument.getElementById(\"msform\").appendChild(newFieldSet);\r\nhashList(document.getElementById(\'industry\').value);\r\n};\r\n\r\nfunction show_users(s1){\r\nvar newFieldSet = document.createElement(\"fieldset\");\r\nnewFieldSet.className = \"show_users\";\r\nnewFieldSet.innerHTML = \'<h2 class=\"fs-title\">Select Users</h2>\'+\r\n		\'<p class=\"users\"></p>\'+\r\n		\'<input type=\"button\" name=\"previous\" id=\"show_users\" class=\"previous action-button\" value=\"Previous\" style=\"background-color:#c0d6c9\"/>\'+\r\n		\'<input type=\"submit\" name=\"submit\" class=\"submit action-button\" value=\"Submit\" />\';\r\ndocument.getElementById(\"msform\").appendChild(newFieldSet);\r\nusers(s1);\r\n};\r\n/**PART 2**/\r\nfunction product_sell(){\r\nvar newFieldSet = document.createElement(\"fieldset\");\r\nnewFieldSet.className = \"product_sell\";\r\nnewFieldSet.innerHTML = \'<p><h2 class=\"fs-title\">What is the product or service you would like to sell? </h2>\'+\r\n		\'<h3 class=\"fs-subtitle\">Example: Products= purses, jewelry; Services = makeup, barber, fitness training, real estate</h3>\'+\r\n		\'<input type=\"button\" name=\"previous\" id=\"product_sell\" class=\"previous action-button\" value=\"Previous\" style=\"background-color:#c0d6c9\"/>	\'+\r\n		\'<input type=\"text\" id=\"industry\" onkeydown=\"javascript: if (event.keyCode==13) {$(\\\'#product_sell_next\\\').click();}\">\'+\r\n		\'<input type=\"button\" id=\"product_sell_next\" name=\"next\" class=\"next action-button\" value=\"Next\" onclick=\"hash_list();\"/></p>\';\r\n		\r\ndocument.getElementById(\"msform\").appendChild(newFieldSet);\r\n};\r\n/**PART 3**/\r\nfunction that_global(){\r\nvar newFieldSet = document.createElement(\"fieldset\");\r\nnewFieldSet.className = \"that_global\";\r\nnewFieldSet.innerHTML = \'<p><h2 class=\"fs-title\">What is your cause or event about? Be Specific.</h2>\'+\r\n		\'<h3 class=\"fs-subtitle\">Examples: political party, fashion show, etc.)</h3>\'+\r\n		\'<input type=\"button\" name=\"previous\" id=\"that_global\" class=\"previous action-button\" value=\"Previous\" style=\"background-color:#c0d6c9\"/>	\'+\r\n		\'<input type=\"text\" id=\"industry\" onkeydown=\"javascript: if (event.keyCode==13) {$(\\\'#that_global_next\\\').click();}\">\'+\r\n		\'<input type=\"button\" name=\"next\"  id=\"that_global_next\" class=\"next action-button\" value=\"Next\" onclick=\"hash_list();\"/></p>\';\r\n		\r\ndocument.getElementById(\"msform\").appendChild(newFieldSet);\r\n};\r\n</script>\r\n<script type=\"text/javascript\" src=\"app.js\"></script>\r\n<script>\r\n\r\n$(document).on(\'click\', \'.submit\', function(){  \r\n  //$(\'button\').not(this).removeClass();\r\n  $(this).addClass(\'active\');\r\n  \r\n  });\r\n</script>\r\n</body>\r\n</html>", "Get Started with GramGro", "", "inherit", "closed", "closed", "", "35-revision-v1", "", "", "2016-12-16 06:20:23", "2016-12-16 06:20:23", "", "35", "http://gramgro.com/2016/12/16/35-revision-v1/", "0", "revision", "", "0");
INSERT INTO wpax_posts VALUES("40", "1", "2016-12-16 06:21:27", "2016-12-16 06:21:27", "", "Get Started with GramGro", "", "inherit", "closed", "closed", "", "35-revision-v1", "", "", "2016-12-16 06:21:27", "2016-12-16 06:21:27", "", "35", "http://gramgro.com/2016/12/16/35-revision-v1/", "0", "revision", "", "0");
INSERT INTO wpax_posts VALUES("42", "1", "2016-12-16 06:23:24", "2016-12-16 06:23:24", "[customer-area /]", "Customer Area", "", "trash", "closed", "closed", "", "customer-area__trashed", "", "", "2016-12-22 22:40:33", "2016-12-22 22:40:33", "", "0", "http://gramgro.com/customer-area/", "1", "page", "", "0");
INSERT INTO wpax_posts VALUES("43", "1", "2016-12-16 06:23:24", "2016-12-16 06:23:24", "[customer-area-dashboard /]", "Dashboard", "", "trash", "closed", "closed", "", "dashboard__trashed", "", "", "2016-12-22 22:40:34", "2016-12-22 22:40:34", "", "42", "http://gramgro.com/customer-area/dashboard/", "5", "page", "", "0");
INSERT INTO wpax_posts VALUES("44", "1", "2016-12-16 06:23:24", "2016-12-16 06:23:24", "[customer-area-private-files-home /]", "Files", "", "trash", "closed", "closed", "", "files__trashed", "", "", "2016-12-22 22:40:34", "2016-12-22 22:40:34", "", "42", "http://gramgro.com/customer-area/files/", "500", "page", "", "0");
INSERT INTO wpax_posts VALUES("45", "1", "2016-12-16 06:23:24", "2016-12-16 06:23:24", "[customer-area-private-files /]", "My files", "", "trash", "closed", "closed", "", "my-files__trashed", "", "", "2016-12-22 22:40:34", "2016-12-22 22:40:34", "", "44", "http://gramgro.com/customer-area/files/my-files/", "510", "page", "", "0");
INSERT INTO wpax_posts VALUES("46", "1", "2016-12-16 06:23:24", "2016-12-16 06:23:24", "[customer-area-private-pages-home /]", "Pages", "", "trash", "closed", "closed", "", "pages__trashed", "", "", "2016-12-22 22:40:34", "2016-12-22 22:40:34", "", "42", "http://gramgro.com/customer-area/pages/", "600", "page", "", "0");
INSERT INTO wpax_posts VALUES("47", "1", "2016-12-16 06:23:24", "2016-12-16 06:23:24", "[customer-area-private-pages /]", "My pages", "", "trash", "closed", "closed", "", "my-pages__trashed", "", "", "2016-12-22 22:40:34", "2016-12-22 22:40:34", "", "46", "http://gramgro.com/customer-area/pages/my-pages/", "610", "page", "", "0");
INSERT INTO wpax_posts VALUES("48", "1", "2016-12-16 06:23:24", "2016-12-16 06:23:24", "[customer-account-home /]\r\nTest", "My account", "", "trash", "closed", "closed", "", "my-account__trashed", "", "", "2016-12-22 22:40:34", "2016-12-22 22:40:34", "", "42", "http://gramgro.com/customer-area/my-account/", "800", "page", "", "0");
INSERT INTO wpax_posts VALUES("49", "1", "2016-12-16 06:23:24", "2016-12-16 06:23:24", "[customer-area-account /]", "Account details", "", "trash", "closed", "closed", "", "account-details__trashed", "", "", "2016-12-22 22:40:34", "2016-12-22 22:40:34", "", "48", "http://gramgro.com/customer-area/my-account/account-details/", "810", "page", "", "0");
INSERT INTO wpax_posts VALUES("50", "1", "2016-12-16 06:23:24", "2016-12-16 06:23:24", "[customer-area-account-edit /]", "Edit account", "", "trash", "closed", "closed", "", "edit-account__trashed", "", "", "2016-12-22 22:40:49", "2016-12-22 22:40:49", "", "48", "http://gramgro.com/customer-area/my-account/edit-account/", "820", "page", "", "0");
INSERT INTO wpax_posts VALUES("51", "1", "2016-12-16 06:23:24", "2016-12-16 06:23:24", "[customer-area-logout /]", "Logout", "", "trash", "closed", "closed", "", "logout__trashed", "", "", "2016-12-22 22:40:49", "2016-12-22 22:40:49", "", "48", "http://gramgro.com/customer-area/my-account/logout/", "850", "page", "", "0");
INSERT INTO wpax_posts VALUES("70", "1", "2016-12-16 06:35:42", "2016-12-16 06:35:42", "Hello", "My very first private file", "", "publish", "open", "closed", "", "my-very-first-private-file", "", "", "2016-12-16 06:35:42", "2016-12-16 06:35:42", "", "0", "http://gramgro.com/?post_type=cuar_private_file&#038;p=70", "0", "cuar_private_file", "", "0");
INSERT INTO wpax_posts VALUES("71", "0", "2016-12-16 06:38:14", "2016-12-16 06:38:14", "", "", "", "publish", "closed", "closed", "", "71", "", "", "2016-12-16 06:38:14", "2016-12-16 06:38:14", "", "2", "http://gramgro.com/?post_type=cuar_log_event&p=71", "0", "cuar_log_event", "", "0");
INSERT INTO wpax_posts VALUES("72", "2", "2016-12-16 06:38:50", "2016-12-16 06:38:50", "", "", "", "publish", "closed", "closed", "", "72", "", "", "2016-12-16 06:38:50", "2016-12-16 06:38:50", "", "70", "http://gramgro.com/?post_type=cuar_log_event&p=72", "0", "cuar_log_event", "", "0");
INSERT INTO wpax_posts VALUES("74", "1", "2016-12-16 07:05:08", "2016-12-16 07:05:08", "", "GramGro01", "", "inherit", "open", "closed", "", "gramgro01", "", "", "2016-12-16 07:05:08", "2016-12-16 07:05:08", "", "0", "http://gramgro.com/wp-content/uploads/2016/12/GramGro01.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO wpax_posts VALUES("76", "1", "2016-12-16 07:19:39", "2016-12-16 07:19:39", "", "GramGro01", "", "inherit", "open", "closed", "", "gramgro01-2", "", "", "2016-12-16 07:19:39", "2016-12-16 07:19:39", "", "0", "http://gramgro.com/wp-content/uploads/2016/12/GramGro01.png", "0", "attachment", "image/png", "0");
INSERT INTO wpax_posts VALUES("80", "1", "2016-12-16 07:39:33", "2016-12-16 07:39:33", "This is an example page. It\'s different from a blog post because it will stay in one place and will show up in your site navigation (in most themes). Most people start with an About page that introduces them to potential site visitors. It might say something like this:\n<blockquote>Hi there! I\'m a bike messenger by day, aspiring actor by night, and this is my website. I live in Los Angeles, have a great dog named Jack, and I like piña coladas. (And gettin\' caught in the rain.)</blockquote>\n...or something like this:\n<blockquote>The XYZ Doohickey Company was founded in 1971, and has been providing quality doohickeys to the public ever since. Located in Gotham City, XYZ employs over 2,000 people and does all kinds of awesome things for the Gotham community.</blockquote>\nAs a new WordPress user, you should go to <a href=\"http://gramgro.com/wp-admin/\">your dashboard</a> to delete this page and create new pages for your content. Have fun!", "Sample Page", "", "inherit", "closed", "closed", "", "2-autosave-v1", "", "", "2016-12-16 07:39:33", "2016-12-16 07:39:33", "", "2", "http://gramgro.com/2-autosave-v1/", "0", "revision", "", "0");
INSERT INTO wpax_posts VALUES("84", "1", "2016-12-16 07:50:29", "2016-12-16 07:50:29", "http://gramgro.com/wp-content/uploads/2016/12/cropped-GramGro01.png", "cropped-GramGro01.png", "", "inherit", "open", "closed", "", "cropped-gramgro01-png", "", "", "2016-12-16 07:50:29", "2016-12-16 07:50:29", "", "0", "http://gramgro.com/wp-content/uploads/2016/12/cropped-GramGro01.png", "0", "attachment", "image/png", "0");
INSERT INTO wpax_posts VALUES("85", "1", "2016-12-16 07:50:57", "2016-12-16 07:50:57", "http://gramgro.com/wp-content/uploads/2016/12/cropped-GramGro01.jpg", "cropped-GramGro01.jpg", "", "inherit", "open", "closed", "", "cropped-gramgro01-jpg", "", "", "2016-12-16 07:50:57", "2016-12-16 07:50:57", "", "0", "http://gramgro.com/wp-content/uploads/2016/12/cropped-GramGro01.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO wpax_posts VALUES("86", "1", "2016-12-16 07:51:29", "2016-12-16 07:51:29", "http://gramgro.com/wp-content/uploads/2016/12/cropped-GramGro01-1.png", "cropped-GramGro01-1.png", "", "inherit", "open", "closed", "", "cropped-gramgro01-1-png", "", "", "2016-12-16 07:51:29", "2016-12-16 07:51:29", "", "0", "http://gramgro.com/wp-content/uploads/2016/12/cropped-GramGro01-1.png", "0", "attachment", "image/png", "0");
INSERT INTO wpax_posts VALUES("87", "1", "2016-12-16 07:52:20", "2016-12-16 07:52:20", "http://gramgro.com/wp-content/uploads/2016/12/cropped-GramGro01-2.png", "cropped-GramGro01-2.png", "", "inherit", "open", "closed", "", "cropped-gramgro01-2-png", "", "", "2016-12-16 07:52:20", "2016-12-16 07:52:20", "", "0", "http://gramgro.com/wp-content/uploads/2016/12/cropped-GramGro01-2.png", "0", "attachment", "image/png", "0");
INSERT INTO wpax_posts VALUES("88", "1", "2016-12-16 07:54:20", "2016-12-16 07:54:20", "", "GramGro01redo", "", "inherit", "open", "closed", "", "gramgro01redo", "", "", "2016-12-16 07:54:20", "2016-12-16 07:54:20", "", "0", "http://gramgro.com/wp-content/uploads/2016/12/GramGro01redo.png", "0", "attachment", "image/png", "0");
INSERT INTO wpax_posts VALUES("89", "1", "2016-12-16 07:54:36", "2016-12-16 07:54:36", "http://gramgro.com/wp-content/uploads/2016/12/cropped-GramGro01redo.png", "cropped-GramGro01redo.png", "", "inherit", "open", "closed", "", "cropped-gramgro01redo-png", "", "", "2016-12-16 07:54:36", "2016-12-16 07:54:36", "", "0", "http://gramgro.com/wp-content/uploads/2016/12/cropped-GramGro01redo.png", "0", "attachment", "image/png", "0");
INSERT INTO wpax_posts VALUES("90", "1", "2016-12-16 08:02:26", "2016-12-16 08:02:26", "", "city-wallpaper-2", "", "inherit", "open", "closed", "", "city-wallpaper-2", "", "", "2016-12-16 08:02:26", "2016-12-16 08:02:26", "", "0", "http://gramgro.com/wp-content/uploads/2016/12/city-wallpaper-2.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO wpax_posts VALUES("92", "1", "2016-12-16 08:03:30", "2016-12-16 08:03:30", "", "city-background-3", "", "inherit", "open", "closed", "", "city-background-3", "", "", "2016-12-16 08:03:30", "2016-12-16 08:03:30", "", "0", "http://gramgro.com/wp-content/uploads/2016/12/city-background-3.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO wpax_posts VALUES("93", "1", "2016-12-16 08:10:22", "2016-12-16 08:10:22", "", "36912781-business-wallpaper", "", "inherit", "open", "closed", "", "36912781-business-wallpaper", "", "", "2016-12-16 08:10:22", "2016-12-16 08:10:22", "", "0", "http://gramgro.com/wp-content/uploads/2016/12/36912781-business-wallpaper.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO wpax_posts VALUES("94", "1", "2016-12-16 08:14:27", "2016-12-16 08:14:27", "", "Home", "", "publish", "closed", "closed", "", "home", "", "", "2016-12-16 08:14:27", "2016-12-16 08:14:27", "", "0", "http://gramgro.com/home/", "1", "nav_menu_item", "", "0");
INSERT INTO wpax_posts VALUES("101", "1", "2016-12-16 08:37:50", "2016-12-16 08:37:50", "", "Get Started", "", "trash", "closed", "closed", "", "get-started__trashed", "", "", "2016-12-22 22:40:49", "2016-12-22 22:40:49", "", "0", "http://gramgro.com/?page_id=101", "0", "page", "", "0");
INSERT INTO wpax_posts VALUES("102", "1", "2016-12-16 08:37:50", "2016-12-16 08:37:50", "<center><iframe src=\"https://www.youtube.com/embed/-TDAfnU_2bY?rel=0&amp;autoplay=1\" width=\"640\" height=\"360\" frameborder=\"0\" allowfullscreen=\"allowfullscreen\"></iframe></center><center>Still have questions? Visit our <a href=\"http://gramgro.com/faqs-frequently-asked-questions/\">FAQ </a>page!</center><center><a href=\"http://gramgro.com/try/\"><img class=\"alignnone  wp-image-283\" src=\"http://gramgro.com/wp-content/uploads/2016/12/pushgram.jpg\" alt=\"\" width=\"1015\" height=\"1436\" /></a></center>", "How GramGro Works", "", "publish", "closed", "closed", "", "learn-more", "", "", "2016-12-23 17:33:37", "2016-12-23 17:33:37", "", "0", "http://gramgro.com/?page_id=102", "0", "page", "", "0");
INSERT INTO wpax_posts VALUES("103", "1", "2016-12-16 08:37:50", "2016-12-16 08:37:50", "", "Contact Us", "", "publish", "closed", "closed", "", "contact-us", "", "", "2016-12-16 08:37:50", "2016-12-16 08:37:50", "", "0", "http://gramgro.com/?page_id=103", "0", "page", "", "0");
INSERT INTO wpax_posts VALUES("105", "1", "2016-12-16 08:37:50", "2016-12-16 08:37:50", "", "Get Started", "", "inherit", "closed", "closed", "", "101-revision-v1", "", "", "2016-12-16 08:37:50", "2016-12-16 08:37:50", "", "101", "http://gramgro.com/101-revision-v1/", "0", "revision", "", "0");
INSERT INTO wpax_posts VALUES("106", "1", "2016-12-16 08:37:50", "2016-12-16 08:37:50", "", "Learn More", "", "inherit", "closed", "closed", "", "102-revision-v1", "", "", "2016-12-16 08:37:50", "2016-12-16 08:37:50", "", "102", "http://gramgro.com/102-revision-v1/", "0", "revision", "", "0");
INSERT INTO wpax_posts VALUES("107", "1", "2016-12-16 08:37:50", "2016-12-16 08:37:50", "", "Contact Us", "", "inherit", "closed", "closed", "", "103-revision-v1", "", "", "2016-12-16 08:37:50", "2016-12-16 08:37:50", "", "103", "http://gramgro.com/103-revision-v1/", "0", "revision", "", "0");
INSERT INTO wpax_posts VALUES("109", "1", "2016-12-16 08:37:50", "2016-12-16 08:37:50", " ", "", "", "publish", "closed", "closed", "", "109", "", "", "2016-12-23 01:52:30", "2016-12-23 01:52:30", "", "0", "http://gramgro.com/109/", "3", "nav_menu_item", "", "0");
INSERT INTO wpax_posts VALUES("110", "1", "2016-12-16 08:37:50", "2016-12-16 08:37:50", " ", "", "mailto:gramgropro@gmail.com", "publish", "closed", "closed", "", "110", "", "", "2016-12-23 01:52:30", "2016-12-23 01:52:30", "", "0", "http://gramgro.com/110/", "5", "nav_menu_item", "", "0");
INSERT INTO wpax_posts VALUES("114", "1", "2016-12-16 08:42:20", "2016-12-16 08:42:20", "", "GramGro01", "", "inherit", "open", "closed", "", "gramgro01-3", "", "", "2016-12-16 08:42:20", "2016-12-16 08:42:20", "", "0", "http://gramgro.com/wp-content/uploads/2016/12/GramGro01-1.png", "0", "attachment", "image/png", "0");
INSERT INTO wpax_posts VALUES("115", "1", "2016-12-16 08:42:32", "2016-12-16 08:42:32", "http://gramgro.com/wp-content/uploads/2016/12/cropped-GramGro01-1-1.png", "cropped-GramGro01-1-1.png", "", "inherit", "open", "closed", "", "cropped-gramgro01-1-1-png", "", "", "2016-12-16 08:42:32", "2016-12-16 08:42:32", "", "0", "http://gramgro.com/wp-content/uploads/2016/12/cropped-GramGro01-1-1.png", "0", "attachment", "image/png", "0");
INSERT INTO wpax_posts VALUES("117", "1", "2016-12-16 08:44:14", "2016-12-16 08:44:14", "http://gramgro.com/wp-content/uploads/2016/12/cropped-cropped-GramGro01redo.png", "cropped-cropped-GramGro01redo.png", "", "inherit", "open", "closed", "", "cropped-cropped-gramgro01redo-png", "", "", "2016-12-16 08:44:14", "2016-12-16 08:44:14", "", "0", "http://gramgro.com/wp-content/uploads/2016/12/cropped-cropped-GramGro01redo.png", "0", "attachment", "image/png", "0");
INSERT INTO wpax_posts VALUES("119", "1", "2016-12-16 08:46:57", "2016-12-16 08:46:57", "", "36912781-business-wallpaper", "", "inherit", "open", "closed", "", "36912781-business-wallpaper-2", "", "", "2016-12-16 08:46:57", "2016-12-16 08:46:57", "", "0", "http://gramgro.com/wp-content/uploads/2016/12/36912781-business-wallpaper-1.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO wpax_posts VALUES("121", "0", "2016-12-16 08:52:27", "2016-12-16 08:52:27", "", "", "", "publish", "closed", "closed", "", "121", "", "", "2016-12-16 08:52:27", "2016-12-16 08:52:27", "", "2", "http://gramgro.com/?post_type=cuar_log_event&p=121", "0", "cuar_log_event", "", "0");
INSERT INTO wpax_posts VALUES("122", "0", "2016-12-16 08:54:23", "2016-12-16 08:54:23", "", "", "", "publish", "closed", "closed", "", "122", "", "", "2016-12-16 08:54:23", "2016-12-16 08:54:23", "", "2", "http://gramgro.com/?post_type=cuar_log_event&p=122", "0", "cuar_log_event", "", "0");
INSERT INTO wpax_posts VALUES("124", "1", "2016-12-16 09:03:43", "2016-12-16 09:03:43", "<iframe width=\"560\" height=\"315\" src=\"https://www.youtube.com/embed/-TDAfnU_2bY\" frameborder=\"0\" allowfullscreen></iframe>", "", "", "inherit", "closed", "closed", "", "2-revision-v1", "", "", "2016-12-16 09:03:43", "2016-12-16 09:03:43", "", "2", "http://gramgro.com/2-revision-v1/", "0", "revision", "", "0");
INSERT INTO wpax_posts VALUES("125", "0", "2016-12-16 19:13:05", "2016-12-16 19:13:05", "", "", "", "publish", "closed", "closed", "", "125", "", "", "2016-12-16 19:13:05", "2016-12-16 19:13:05", "", "1", "http://gramgro.com/?post_type=cuar_log_event&p=125", "0", "cuar_log_event", "", "0");
INSERT INTO wpax_posts VALUES("127", "0", "2016-12-16 21:32:18", "2016-12-16 21:32:18", "", "", "", "publish", "closed", "closed", "", "127", "", "", "2016-12-16 21:32:18", "2016-12-16 21:32:18", "", "1", "http://gramgro.com/?post_type=cuar_log_event&p=127", "0", "cuar_log_event", "", "0");
INSERT INTO wpax_posts VALUES("129", "1", "2016-12-16 23:11:13", "2016-12-16 23:11:13", "[customer-account-home /]\r\nTest", "My account", "", "inherit", "closed", "closed", "", "48-revision-v1", "", "", "2016-12-16 23:11:13", "2016-12-16 23:11:13", "", "48", "http://gramgro.com/48-revision-v1/", "0", "revision", "", "0");
INSERT INTO wpax_posts VALUES("130", "0", "2016-12-21 19:29:54", "2016-12-21 19:29:54", "", "", "", "publish", "closed", "closed", "", "130", "", "", "2016-12-21 19:29:54", "2016-12-21 19:29:54", "", "1", "http://gramgro.com/?post_type=cuar_log_event&p=130", "0", "cuar_log_event", "", "0");
INSERT INTO wpax_posts VALUES("131", "1", "2016-12-21 19:41:55", "2016-12-21 19:41:55", "{\n    \"old_sidebars_widgets_data\": {\n        \"value\": {\n            \"wp_inactive_widgets\": [\n                \"text-2\",\n                \"text-3\",\n                \"text-4\",\n                \"text-5\"\n            ],\n            \"sidebar-1\": [\n                \"search-2\",\n                \"recent-posts-2\",\n                \"recent-comments-2\",\n                \"archives-2\",\n                \"categories-2\",\n                \"meta-2\"\n            ],\n            \"sidebar-2\": [],\n            \"sidebar-3\": [],\n            \"sidebar-4\": null\n        },\n        \"type\": \"global_variable\",\n        \"user_id\": 1\n    }\n}", "", "", "trash", "closed", "closed", "", "e1e7fe38-8357-4d59-9fb4-b64316a22d0d", "", "", "2016-12-21 19:41:55", "2016-12-21 19:41:55", "", "0", "http://gramgro.com/?p=131", "0", "customize_changeset", "", "0");
INSERT INTO wpax_posts VALUES("132", "1", "2016-12-21 19:45:44", "2016-12-21 19:45:44", "{\n    \"old_sidebars_widgets_data\": {\n        \"value\": {\n            \"wp_inactive_widgets\": [\n                \"text-2\",\n                \"text-3\",\n                \"text-4\",\n                \"text-5\"\n            ],\n            \"sidebar-1\": [\n                \"search-2\",\n                \"recent-posts-2\",\n                \"recent-comments-2\",\n                \"archives-2\",\n                \"categories-2\",\n                \"meta-2\"\n            ],\n            \"sidebar-2\": [],\n            \"sidebar-3\": [],\n            \"sidebar-4\": null\n        },\n        \"type\": \"global_variable\",\n        \"user_id\": 1\n    }\n}", "", "", "trash", "closed", "closed", "", "5cae2666-b4f0-4e0c-a70a-36d371fa4049", "", "", "2016-12-21 19:45:44", "2016-12-21 19:45:44", "", "0", "http://gramgro.com/5cae2666-b4f0-4e0c-a70a-36d371fa4049/", "0", "customize_changeset", "", "0");
INSERT INTO wpax_posts VALUES("133", "1", "2016-12-21 22:25:40", "2016-12-21 22:25:40", "[customer-area-private-files-home /]", "Files", "", "trash", "closed", "closed", "", "files-2__trashed", "", "", "2016-12-22 22:40:34", "2016-12-22 22:40:34", "", "42", "http://gramgro.com/customer-area/files-2/", "500", "page", "", "0");
INSERT INTO wpax_posts VALUES("134", "1", "2016-12-21 22:25:40", "2016-12-21 22:25:40", "[customer-area-private-files /]", "My files", "", "trash", "closed", "closed", "", "my-files__trashed", "", "", "2016-12-22 22:40:34", "2016-12-22 22:40:34", "", "133", "http://gramgro.com/customer-area/files-2/my-files/", "510", "page", "", "0");
INSERT INTO wpax_posts VALUES("135", "1", "2016-12-21 22:25:40", "2016-12-21 22:25:40", "[customer-area-private-pages-home /]", "Pages", "", "trash", "closed", "closed", "", "pages-2__trashed", "", "", "2016-12-22 22:40:34", "2016-12-22 22:40:34", "", "42", "http://gramgro.com/customer-area/pages-2/", "600", "page", "", "0");
INSERT INTO wpax_posts VALUES("136", "1", "2016-12-21 22:25:40", "2016-12-21 22:25:40", "[customer-area-private-pages /]", "My pages", "", "trash", "closed", "closed", "", "my-pages__trashed", "", "", "2016-12-22 22:40:34", "2016-12-22 22:40:34", "", "135", "http://gramgro.com/customer-area/pages-2/my-pages/", "610", "page", "", "0");
INSERT INTO wpax_posts VALUES("137", "1", "2016-12-21 22:25:48", "2016-12-21 22:25:48", " ", "", "", "publish", "closed", "closed", "", "137", "", "", "2016-12-21 22:25:48", "2016-12-21 22:25:48", "", "42", "http://gramgro.com/137/", "0", "nav_menu_item", "", "0");
INSERT INTO wpax_posts VALUES("138", "1", "2016-12-21 22:25:48", "2016-12-21 22:25:48", " ", "", "", "publish", "closed", "closed", "", "138", "", "", "2016-12-21 22:25:48", "2016-12-21 22:25:48", "", "42", "http://gramgro.com/138/", "2", "nav_menu_item", "", "0");
INSERT INTO wpax_posts VALUES("139", "1", "2016-12-21 22:25:48", "2016-12-21 22:25:48", " ", "", "", "publish", "closed", "closed", "", "139", "", "", "2016-12-21 22:25:48", "2016-12-21 22:25:48", "", "133", "http://gramgro.com/139/", "3", "nav_menu_item", "", "0");
INSERT INTO wpax_posts VALUES("140", "1", "2016-12-21 22:25:48", "2016-12-21 22:25:48", " ", "", "", "publish", "closed", "closed", "", "140", "", "", "2016-12-21 22:25:48", "2016-12-21 22:25:48", "", "42", "http://gramgro.com/140/", "4", "nav_menu_item", "", "0");
INSERT INTO wpax_posts VALUES("141", "1", "2016-12-21 22:25:48", "2016-12-21 22:25:48", " ", "", "", "publish", "closed", "closed", "", "141", "", "", "2016-12-21 22:25:48", "2016-12-21 22:25:48", "", "135", "http://gramgro.com/141/", "5", "nav_menu_item", "", "0");
INSERT INTO wpax_posts VALUES("142", "1", "2016-12-21 22:25:48", "2016-12-21 22:25:48", " ", "", "", "publish", "closed", "closed", "", "142", "", "", "2016-12-21 22:25:48", "2016-12-21 22:25:48", "", "42", "http://gramgro.com/142/", "6", "nav_menu_item", "", "0");
INSERT INTO wpax_posts VALUES("143", "1", "2016-12-21 22:25:48", "2016-12-21 22:25:48", " ", "", "", "publish", "closed", "closed", "", "143", "", "", "2016-12-21 22:25:48", "2016-12-21 22:25:48", "", "48", "http://gramgro.com/143/", "7", "nav_menu_item", "", "0");
INSERT INTO wpax_posts VALUES("144", "1", "2016-12-21 22:25:49", "2016-12-21 22:25:49", " ", "", "", "publish", "closed", "closed", "", "144", "", "", "2016-12-21 22:25:49", "2016-12-21 22:25:49", "", "48", "http://gramgro.com/144/", "8", "nav_menu_item", "", "0");
INSERT INTO wpax_posts VALUES("145", "1", "2016-12-21 22:25:49", "2016-12-21 22:25:49", " ", "", "", "publish", "closed", "closed", "", "145", "", "", "2016-12-21 22:25:49", "2016-12-21 22:25:49", "", "48", "http://gramgro.com/145/", "9", "nav_menu_item", "", "0");
INSERT INTO wpax_posts VALUES("146", "1", "2016-12-21 22:40:43", "2016-12-21 22:40:43", "", "Front Page", "", "publish", "closed", "closed", "", "front-page", "", "", "2016-12-21 22:40:43", "2016-12-21 22:40:43", "", "0", "http://gramgro.com/front-page/", "0", "page", "", "0");
INSERT INTO wpax_posts VALUES("147", "1", "2016-12-21 22:40:43", "2016-12-21 22:40:43", "", "Blog", "", "trash", "closed", "closed", "", "blog__trashed", "", "", "2016-12-22 22:41:13", "2016-12-22 22:41:13", "", "0", "http://gramgro.com/blog/", "0", "page", "", "0");
INSERT INTO wpax_posts VALUES("148", "1", "2016-12-21 22:54:44", "2016-12-21 22:54:44", "{\n    \"illdy::illdy_jumbotron_general_entry\": {\n        \"value\": \"\",\n        \"type\": \"theme_mod\",\n        \"user_id\": 1\n    },\n    \"illdy::illdy_jumbotron_general_second_row_from_title\": {\n        \"value\": \"\",\n        \"type\": \"theme_mod\",\n        \"user_id\": 1\n    },\n    \"illdy::illdy_jumbotron_general_third_row_from_title\": {\n        \"value\": \"\",\n        \"type\": \"theme_mod\",\n        \"user_id\": 1\n    }\n}", "", "", "trash", "closed", "closed", "", "617a8f25-ac08-41d8-b2b0-65e3c0076ebe", "", "", "2016-12-21 22:54:44", "2016-12-21 22:54:44", "", "0", "http://gramgro.com/?p=148", "0", "customize_changeset", "", "0");
INSERT INTO wpax_posts VALUES("149", "1", "2016-12-21 22:55:35", "2016-12-21 22:55:35", "{\n    \"illdy::illdy_jumbotron_enable_featured_image\": {\n        \"value\": false,\n        \"type\": \"theme_mod\",\n        \"user_id\": 1\n    },\n    \"illdy::illdy_jumbotron_enable_parallax_effect\": {\n        \"value\": false,\n        \"type\": \"theme_mod\",\n        \"user_id\": 1\n    }\n}", "", "", "trash", "closed", "closed", "", "4d72d2d9-8e66-4a75-904e-98779c5491bf", "", "", "2016-12-21 22:55:35", "2016-12-21 22:55:35", "", "0", "http://gramgro.com/4d72d2d9-8e66-4a75-904e-98779c5491bf/", "0", "customize_changeset", "", "0");
INSERT INTO wpax_posts VALUES("150", "1", "2016-12-21 22:55:53", "2016-12-21 22:55:53", "{\n    \"illdy::illdy_jumbotron_general_entry\": {\n        \"value\": \"dfgdhhhfh\",\n        \"type\": \"theme_mod\",\n        \"user_id\": 1\n    },\n    \"illdy::illdy_jumbotron_general_second_row_from_title\": {\n        \"value\": \"\",\n        \"type\": \"theme_mod\",\n        \"user_id\": 1\n    }\n}", "", "", "trash", "closed", "closed", "", "55d3c0f6-79ea-474b-8f31-d9d52bb06512", "", "", "2016-12-21 22:55:53", "2016-12-21 22:55:53", "", "0", "http://gramgro.com/55d3c0f6-79ea-474b-8f31-d9d52bb06512/", "0", "customize_changeset", "", "0");
INSERT INTO wpax_posts VALUES("151", "1", "2016-12-21 22:56:03", "2016-12-21 22:56:03", "{\n    \"illdy::illdy_jumbotron_general_entry\": {\n        \"value\": \"\",\n        \"type\": \"theme_mod\",\n        \"user_id\": 1\n    },\n    \"illdy::illdy_jumbotron_enable_parallax_effect\": {\n        \"value\": true,\n        \"type\": \"theme_mod\",\n        \"user_id\": 1\n    }\n}", "", "", "trash", "closed", "closed", "", "b501ace9-b2b6-4e66-8d32-20721b281d22", "", "", "2016-12-21 22:56:03", "2016-12-21 22:56:03", "", "0", "http://gramgro.com/b501ace9-b2b6-4e66-8d32-20721b281d22/", "0", "customize_changeset", "", "0");
INSERT INTO wpax_posts VALUES("152", "1", "2016-12-21 23:03:21", "2016-12-21 23:03:21", "{\n    \"custom_css[illdy]\": {\n        \"value\": \"/*\\nYou can add your own CSS here.\\n\\nClick the help icon above to learn more.\\n*/\\n\\n\\n#header .bottom-header {\\n    padding-top: 40px;\\n    padding-bottom: 80px;\\n}\\n\",\n        \"type\": \"custom_css\",\n        \"user_id\": 1\n    }\n}", "", "", "trash", "closed", "closed", "", "1f4876cc-ebb9-4329-9e66-d4631ad779ed", "", "", "2016-12-21 23:03:21", "2016-12-21 23:03:21", "", "0", "http://gramgro.com/1f4876cc-ebb9-4329-9e66-d4631ad779ed/", "0", "customize_changeset", "", "0");
INSERT INTO wpax_posts VALUES("153", "1", "2016-12-21 23:03:21", "2016-12-21 23:03:21", "/*\nYou can add your own CSS here.\n\nClick the help icon above to learn more.\n*/\n\n\n#header .bottom-header {\n    padding-top: 10px;\n    padding-bottom: 40px;\n}\n\n#header .bottom-header h2 {\n	line-height: 1;\n}\n#header {\nwidth: 100%;\n-webkit-background-size: cover;\n-moz-background-size: cover;\n-o-background-size: cover;\nbackground-size: cover;\n}\n#header .top-header {\nwidth: 100%;\npadding-top: .05px;\n}\n#header .top-header .header-logo {\ndisplay: block;\nfont-size: 38px;\ncolor: #ffffff;\n-webkit-transition: all 0.3s;\n-moz-transition: all 0.3s;\n-o-transition: all 0.3s;\ntransition: all 0.3s;\nfloat: left;\n}\n#header .top-header .header-logo:hover {\ncolor: #f1d204;\ntext-decoration: none;\n}\n#header .top-header .header-navigation {\nfloat: right;\n}\n#header .top-header .header-navigation ul {\nwidth: 100%;\nmargin: 35px 0 0 0;\npadding: 0;\nlist-style-type: none;\n}\n#header .top-header .header-navigation ul li {\nmargin-left: 40px;\nline-height: 1.375;\nfont-weight: 700;\nfont-size: 16px;\ncolor: #ffffff;\ntext-transform: uppercase;\nposition: relative;\nfloat: left;\n}\n#header .top-header .header-navigation ul li:first-child {\nmargin-left: 0;\n}\n#header .top-header .header-navigation ul li.menu-item-has-children a {\npadding-right: 16px;\nposition: relative;\n}\n#header .top-header .header-navigation ul li.menu-item-has-children a:after {\ncontent: “\\f0d7”;\nfont-family: “FontAwesome”;\nfont-size: 5px;\nposition: absolute;\ntop: 0;\nright: 0;\n}\n#header .top-header .header-navigation ul li.menu-item-has-children .sub-menu {\nwidth: 250px;\nmargin: 0;\npadding: 10px 0 0 0;\nposition: absolute;\nleft: 0;\ndisplay: none;\n}\n#header .top-header .header-navigation ul li.menu-item-has-children .sub-menu li {\nwidth: 100%;\nmargin: 0;\npadding: 0;\n}\n#header .top-header .header-navigation ul li.menu-item-has-children .sub-menu li:first-child a {\npadding-top: 10px;\n}\n#header .top-header .header-navigation ul li.menu-item-has-children .sub-menu li:last-child a {\npadding-bottom: 10px;\n}\n#header .top-header .header-navigation ul li.menu-item-has-children .sub-menu li a {\nwidth: 100%;\nbackground-color: #ffffff;\nmargin: 0;\npadding: 5px 10px;\nline-height: 1.6;\nfont-weight: 600;\nfont-size: 16px;\ncolor: #333333;\ntext-transform: none;\ndisplay: block;\n}\n#header .top-header .header-navigation ul li.menu-item-has-children .sub-menu li a:hover {\ncolor: #f1d204;\n}\n#header .top-header .header-navigation ul li.menu-item-has-children .sub-menu li a:after {\ndisplay: none;\n}\n#header .top-header .header-navigation ul li a {\ncolor: #ffffff;\n-webkit-transition: all 0.3s;\n-moz-transition: all 0.3s;\n-o-transition: all 0.3s;\ntransition: all 0.3s;\n}\n#header .top-header .header-navigation ul li a:hover {\ncolor: #ffde00;\ntext-decoration: none;\n}\n#header .bottom-header {\nwidth: 100%;\npadding-top: 40px;\npadding-bottom: 40px;\ntext-align: center;\n}\n#header .bottom-header.blog {\npadding: 10px 0;\n}\n#header .bottom-header.blog p {\nmargin-bottom: 0;\n}\n#header .bottom-header h2 {\nmargin: 0 0 50px 0;\nline-height: 0.74;\nfont-weight: 900;\nfont-size: 40px;\ncolor: #ffffff;\ntext-transform: uppercase;\n}\n#header .bottom-header span.span-dot {\ncolor: #ffde00;\n}\n#header .bottom-header p {\nline-height: 1.6;\nmargin-bottom: 60px;\nfont-size: 15px;\ncolor: #ffffff;\n}\n#header .bottom-header .header-button-one {\nwidth: auto;\nheight: 63px;\nline-height: 57px;\nbackground: rgba(255, 255, 255, 0.2);\nmargin: 0 15px;\npadding: 0 70px;\ndisplay: inline-block;\nborder: 3px solid #ffffff;\nborder-radius: 3px;\nfont-weight: 700;\nfont-size: 18px;\ncolor: #ffffff;\ntext-transform: uppercase;\n-webkit-transition: all 0.3s;\n-moz-transition: all 0.3s;\n-o-transition: all 0.3s;\ntransition: all 0.3s;\n}\n#header .bottom-header .header-button-one:hover {\nbackground: rgba(255, 255, 255, 0.1);\ntext-decoration: none;\n}\n#header .bottom-header .header-button-two {\nwidth: auto;\nheight: 63px;\nline-height: 63px;\nbackground: #f1d204;\nmargin: 0 15px;\npadding: 0 70px;\ndisplay: inline-block;\nborder-radius: 3px;\nfont-weight: 700;\nfont-size: 18px;\ncolor: #ffffff;\ntext-transform: uppercase;\n-webkit-transition: all 0.3s;\n-moz-transition: all 0.3s;\n-o-transition: all 0.3s;\ntransition: all 0.3s;\n}\n#header .bottom-header .header-button-two:hover {\nbackground: rgba(241, 210, 4, 0.9);\ntext-decoration: none;\n}", "illdy", "", "publish", "closed", "closed", "", "illdy", "", "", "2016-12-22 17:57:00", "2016-12-22 17:57:00", "", "0", "http://gramgro.com/illdy/", "0", "custom_css", "", "0");
INSERT INTO wpax_posts VALUES("154", "1", "2016-12-21 23:03:21", "2016-12-21 23:03:21", "/*\nYou can add your own CSS here.\n\nClick the help icon above to learn more.\n*/\n\n\n#header .bottom-header {\n    padding-top: 40px;\n    padding-bottom: 80px;\n}\n", "illdy", "", "inherit", "closed", "closed", "", "153-revision-v1", "", "", "2016-12-21 23:03:21", "2016-12-21 23:03:21", "", "153", "http://gramgro.com/153-revision-v1/", "0", "revision", "", "0");
INSERT INTO wpax_posts VALUES("155", "1", "2016-12-21 23:07:13", "2016-12-21 23:07:13", "{\n    \"custom_css[illdy]\": {\n        \"value\": \"/*\\nYou can add your own CSS here.\\n\\nClick the help icon above to learn more.\\n*/\\n\\n\\n#header .bottom-header {\\n    padding-top: 10px;\\n    padding-bottom: 40px;\\n}\\n\",\n        \"type\": \"custom_css\",\n        \"user_id\": 1\n    },\n    \"illdy::illdy_about_general_show\": {\n        \"value\": false,\n        \"type\": \"theme_mod\",\n        \"user_id\": 1\n    },\n    \"illdy::illdy_services_general_show\": {\n        \"value\": true,\n        \"type\": \"theme_mod\",\n        \"user_id\": 1\n    },\n    \"illdy::illdy_services_general_entry\": {\n        \"value\": \"GramGro is a tool we created to help you better reach thousands of Instagram users daily without doing a thing. You set the targeting settings and sit back. \",\n        \"type\": \"theme_mod\",\n        \"user_id\": 1\n    },\n    \"illdy::illdy_services_general_title\": {\n        \"value\": \"What we do\",\n        \"type\": \"theme_mod\",\n        \"user_id\": 1\n    }\n}", "", "", "trash", "closed", "closed", "", "6f7e061f-c1a9-4b8e-b91b-f4dc3427a296", "", "", "2016-12-21 23:07:13", "2016-12-21 23:07:13", "", "0", "http://gramgro.com/?p=155", "0", "customize_changeset", "", "0");
INSERT INTO wpax_posts VALUES("156", "1", "2016-12-21 23:07:13", "2016-12-21 23:07:13", "/*\nYou can add your own CSS here.\n\nClick the help icon above to learn more.\n*/\n\n\n#header .bottom-header {\n    padding-top: 10px;\n    padding-bottom: 40px;\n}\n", "illdy", "", "inherit", "closed", "closed", "", "153-revision-v1", "", "", "2016-12-21 23:07:13", "2016-12-21 23:07:13", "", "153", "http://gramgro.com/153-revision-v1/", "0", "revision", "", "0");
INSERT INTO wpax_posts VALUES("157", "1", "2016-12-21 23:11:16", "2016-12-21 23:11:16", "{\n    \"widget_illdy_service[2]\": {\n        \"value\": {\n            \"encoded_serialized_instance\": \"YTo0OntzOjU6InRpdGxlIjtzOjg6IkxvY2F0aW9uIjtzOjQ6Imljb24iO3M6MTM6ImZhLW1hcC1tYXJrZXIiO3M6NToiZW50cnkiO3M6MjEzOiJHcmFtR3JvIGNhbiBoZWxwIHlvdSB0YXJnZXQgYnkgbG9jYXRpb24sIHdoZXRoZXIgaXRzIGFuIGVudGlyZSBjaXR5IG9yIGEgcG9wdWxhciBsb2NhdGlvbiBvZiB5b3VyIHRhcmdldGVkIGNvbW11bml0eSwgR3JhbUdybyBjYW4gIGZpbmQgdXNlcnMgd2hvIGhhdmUgdGFnZ2VkIHRob3NlIGxvY2F0aW9ucyBhbmQgaW50ZXJhY3Qgd2l0aCB0aGVtIG9uIHlvdXIgYmVoYWxmLiAiO3M6NToiY29sb3IiO3M6NzoiIzVmYjRkMyI7fQ==\",\n            \"title\": \"Location\",\n            \"is_widget_customizer_js_value\": true,\n            \"instance_hash_key\": \"abb5528fa3f4c3b68ae459089c4f7434\"\n        },\n        \"type\": \"option\",\n        \"user_id\": 1\n    }\n}", "", "", "trash", "closed", "closed", "", "bfe72e2d-d681-4b7f-ac9a-2625f9f487bd", "", "", "2016-12-21 23:11:16", "2016-12-21 23:11:16", "", "0", "http://gramgro.com/?p=157", "0", "customize_changeset", "", "0");
INSERT INTO wpax_posts VALUES("158", "1", "2016-12-21 23:21:26", "2016-12-21 23:21:26", "{\n    \"widget_illdy_service[3]\": {\n        \"value\": {\n            \"encoded_serialized_instance\": \"YTo0OntzOjU6InRpdGxlIjtzOjU6IlVzZXJzIjtzOjQ6Imljb24iO3M6MTI6ImZhLXVzZXItcGx1cyI7czo1OiJlbnRyeSI7czoxOTE6IkludGVyYWN0IHdpdGggdXNlcnMgd2hvIGFscmVhZHkgZm9sbG93IGEgc3BlY2lmaWMgdXNlci4gU2NyYXBlIGZyb20geW91ciBjb21wZXRpdG9ycyBvciBmcm9tIHRoZSB0b3AgaW5kdXN0cnkgcHJvZmlsZXMgdG8gdGFyZ2V0IHRob3NlIHdobyBhcmUgYWxyZWFkeSBpbnRlcmVzdGVkIGluIGNvbnRlbnQgc2ltaWxhciB0byB5b3Vycy4gIjtzOjU6ImNvbG9yIjtzOjc6IiM4YTNhYjkiO30=\",\n            \"title\": \"Users\",\n            \"is_widget_customizer_js_value\": true,\n            \"instance_hash_key\": \"00e67ca4d054ccb9cc3d78a5e5faeaea\"\n        },\n        \"type\": \"option\",\n        \"user_id\": 1\n    },\n    \"widget_illdy_service[4]\": {\n        \"value\": {\n            \"encoded_serialized_instance\": \"YTo0OntzOjU6InRpdGxlIjtzOjg6Ikhhc2h0YWdzIjtzOjQ6Imljb24iO3M6MTI6ImZhLWluc3RhZ3JhbSI7czo1OiJlbnRyeSI7czoxODU6IkNvbnNlY3RldHVyIGFkaXBpc2NpbmcgZWxpdC4gUHJhZXNlbnQgbW9sZXN0aWUgdXJuYSBoZW5kcmVyaXQgZXJhdCB0aW5jaWR1bnQgdGVtcHVzLiBBbGlxdWFtIGEgbGVvIHJpc3VzLiBGdXNjZSBhIG1ldHVzIG5vbiBhdWd1ZSBkYXBpYnVzIHBvcnR0aXRvciBhdCBpbiBtYXVyaXMuIFBlbGxlbnRlc3F1ZSBjb21tb2RvLi4uIjtzOjU6ImNvbG9yIjtzOjc6IiNmYmFkNTAiO30=\",\n            \"title\": \"Hashtags\",\n            \"is_widget_customizer_js_value\": true,\n            \"instance_hash_key\": \"cbb2656515d4993e12b7bb9250ec3cee\"\n        },\n        \"type\": \"option\",\n        \"user_id\": 1\n    },\n    \"widget_illdy_service[2]\": {\n        \"value\": {\n            \"encoded_serialized_instance\": \"YTo0OntzOjU6InRpdGxlIjtzOjg6IkxvY2F0aW9uIjtzOjQ6Imljb24iO3M6MTM6ImZhLW1hcC1tYXJrZXIiO3M6NToiZW50cnkiO3M6MjEzOiJHcmFtR3JvIGNhbiBoZWxwIHlvdSB0YXJnZXQgYnkgbG9jYXRpb24sIHdoZXRoZXIgaXRzIGFuIGVudGlyZSBjaXR5IG9yIGEgcG9wdWxhciBsb2NhdGlvbiBvZiB5b3VyIHRhcmdldGVkIGNvbW11bml0eSwgR3JhbUdybyBjYW4gIGZpbmQgdXNlcnMgd2hvIGhhdmUgdGFnZ2VkIHRob3NlIGxvY2F0aW9ucyBhbmQgaW50ZXJhY3Qgd2l0aCB0aGVtIG9uIHlvdXIgYmVoYWxmLiAiO3M6NToiY29sb3IiO3M6NzoiIzRjNjhkNyI7fQ==\",\n            \"title\": \"Location\",\n            \"is_widget_customizer_js_value\": true,\n            \"instance_hash_key\": \"12750050cc81a17e6d2ac4cf058f8386\"\n        },\n        \"type\": \"option\",\n        \"user_id\": 1\n    }\n}", "", "", "trash", "closed", "closed", "", "9757e2dc-a09e-43bd-90e4-c25454c8a2bb", "", "", "2016-12-21 23:21:26", "2016-12-21 23:21:26", "", "0", "http://gramgro.com/?p=158", "0", "customize_changeset", "", "0");
INSERT INTO wpax_posts VALUES("159", "1", "2016-12-21 23:22:54", "2016-12-21 23:22:54", "{\n    \"widget_text[5]\": {\n        \"value\": {\n            \"encoded_serialized_instance\": \"YTozOntzOjU6InRpdGxlIjtzOjEzOiJBYm91dCBHcmFtZ3JvIjtzOjQ6InRleHQiO3M6MTA0OiJHcmFtR3JvIGhlbHBzIEluc3RhZ3JhbSB1c2VycyByZWFjaCB0aG91c2FuZHMgb2Ygb3RoZXIgdXNlcnMgZGFpbHkgYnkgYXV0b21hdGljYWxseSBlbmdhZ2luZyB3aXRoIHRoZW0uICI7czo2OiJmaWx0ZXIiO2I6MDt9\",\n            \"title\": \"About Gramgro\",\n            \"is_widget_customizer_js_value\": true,\n            \"instance_hash_key\": \"c9c557e70ee0ab51555d92c1f0adf6fd\"\n        },\n        \"type\": \"option\",\n        \"user_id\": 1\n    }\n}", "", "", "trash", "closed", "closed", "", "889da295-9d72-4799-a5c7-f21c535990c5", "", "", "2016-12-21 23:22:54", "2016-12-21 23:22:54", "", "0", "http://gramgro.com/?p=159", "0", "customize_changeset", "", "0");
INSERT INTO wpax_posts VALUES("160", "1", "2016-12-21 23:23:25", "2016-12-21 23:23:25", "{\n    \"illdy::illdy_about_general_show\": {\n        \"value\": true,\n        \"type\": \"theme_mod\",\n        \"user_id\": 1\n    }\n}", "", "", "trash", "closed", "closed", "", "8bc31ee4-95f2-4116-aad4-ba81d0f8b11d", "", "", "2016-12-21 23:23:25", "2016-12-21 23:23:25", "", "0", "http://gramgro.com/8bc31ee4-95f2-4116-aad4-ba81d0f8b11d/", "0", "customize_changeset", "", "0");
INSERT INTO wpax_posts VALUES("161", "1", "2016-12-21 23:31:03", "2016-12-21 23:31:03", "{\n    \"illdy::illdy_latest_news_general_show\": {\n        \"value\": false,\n        \"type\": \"theme_mod\",\n        \"user_id\": 1\n    },\n    \"illdy::illdy_counter_background_image\": {\n        \"value\": \"http://gramgro.com/wp-content/uploads/2016/12/new-york-city-guide.jpg\",\n        \"type\": \"theme_mod\",\n        \"user_id\": 1\n    },\n    \"widget_illdy_counter[4]\": {\n        \"value\": {\n            \"encoded_serialized_instance\": \"YTo1OntzOjU6InRpdGxlIjtzOjc6IkNsaWVudHMiO3M6OToiZGF0YV9mcm9tIjtpOjE7czo3OiJkYXRhX3RvIjtpOjQ4NjtzOjEwOiJkYXRhX3NwZWVkIjtpOjIwMDA7czoyMToiZGF0YV9yZWZyZXNoX2ludGVydmFsIjtpOjEwMDt9\",\n            \"title\": \"Clients\",\n            \"is_widget_customizer_js_value\": true,\n            \"instance_hash_key\": \"3dcea9c9d3782ab5fe6a703024efa371\"\n        },\n        \"type\": \"option\",\n        \"user_id\": 1\n    },\n    \"widget_illdy_counter[3]\": {\n        \"value\": {\n            \"encoded_serialized_instance\": \"YTo1OntzOjU6InRpdGxlIjtzOjMxOiJGb2xsb3dlcnMgZ2FpbmVkIGJ5IG91ciBjbGllbnRzIjtzOjk6ImRhdGFfZnJvbSI7aTo1MjExO3M6NzoiZGF0YV90byI7aToyNjEwNDcwOTtzOjEwOiJkYXRhX3NwZWVkIjtpOjIwMDA7czoyMToiZGF0YV9yZWZyZXNoX2ludGVydmFsIjtpOjEwMDt9\",\n            \"title\": \"Followers gained by our clients\",\n            \"is_widget_customizer_js_value\": true,\n            \"instance_hash_key\": \"c2af19b5a7e48bcf2762e797d657a7c8\"\n        },\n        \"type\": \"option\",\n        \"user_id\": 1\n    },\n    \"widget_illdy_counter[2]\": {\n        \"value\": {\n            \"encoded_serialized_instance\": \"YTo1OntzOjU6InRpdGxlIjtzOjIyOiJbSWxsZHldIC0gUmVjZW50IFBvc3RzIjtzOjk6ImRhdGFfZnJvbSI7aToxO3M6NzoiZGF0YV90byI7aToyNjA7czoxMDoiZGF0YV9zcGVlZCI7aToyMDAwO3M6MjE6ImRhdGFfcmVmcmVzaF9pbnRlcnZhbCI7aToxMDA7fQ==\",\n            \"title\": \"[Illdy] - Recent Posts\",\n            \"is_widget_customizer_js_value\": true,\n            \"instance_hash_key\": \"955067585cb95c888bc6e6adcf18aa74\"\n        },\n        \"type\": \"option\",\n        \"user_id\": 1\n    },\n    \"sidebars_widgets[wp_inactive_widgets]\": {\n        \"value\": [\n            \"text-2\",\n            \"text-3\",\n            \"text-4\",\n            \"text-5\",\n            \"illdy_counter-2\"\n        ],\n        \"type\": \"option\",\n        \"user_id\": 1\n    },\n    \"sidebars_widgets[front-page-counter-sidebar]\": {\n        \"value\": [\n            \"illdy_counter-4\",\n            \"illdy_counter-3\"\n        ],\n        \"type\": \"option\",\n        \"user_id\": 1\n    },\n    \"illdy::illdy_team_general_show\": {\n        \"value\": false,\n        \"type\": \"theme_mod\",\n        \"user_id\": 1\n    },\n    \"widget_illdy_skill[2]\": {\n        \"value\": {\n            \"encoded_serialized_instance\": \"YTo0OntzOjU6InRpdGxlIjtzOjEwOiJUeXBvZ3JhcGh5IjtzOjEwOiJwZXJjZW50YWdlIjtpOjEwMDtzOjQ6Imljb24iO3M6NzoiZmEtZm9udCI7czo1OiJjb2xvciI7czo3OiIjZjE4YjZkIjt9\",\n            \"title\": \"Typography\",\n            \"is_widget_customizer_js_value\": true,\n            \"instance_hash_key\": \"5119dba98dce1beee07c724c302c6baa\"\n        },\n        \"type\": \"option\",\n        \"user_id\": 1\n    }\n}", "", "", "trash", "closed", "closed", "", "7a8c9f7d-e6e4-4f1a-946e-4e34e8febaad", "", "", "2016-12-21 23:31:03", "2016-12-21 23:31:03", "", "0", "http://gramgro.com/?p=161", "0", "customize_changeset", "", "0");
INSERT INTO wpax_posts VALUES("162", "1", "2016-12-21 23:40:51", "2016-12-21 23:40:51", "{\n    \"illdy::illdy_jumbotron_general_first_row_from_title\": {\n        \"value\": \"reach thousands a day on instagram\",\n        \"type\": \"theme_mod\",\n        \"user_id\": 1\n    },\n    \"illdy::illdy_jumbotron_general_second_row_from_title\": {\n        \"value\": \"gain real followers\",\n        \"type\": \"theme_mod\",\n        \"user_id\": 1\n    },\n    \"illdy::illdy_jumbotron_general_third_row_from_title\": {\n        \"value\": \"grow your brand\",\n        \"type\": \"theme_mod\",\n        \"user_id\": 1\n    }\n}", "", "", "trash", "closed", "closed", "", "47bf65e6-08e2-4dee-bf4e-e696267f3abb", "", "", "2016-12-21 23:40:51", "2016-12-21 23:40:51", "", "0", "http://gramgro.com/?p=162", "0", "customize_changeset", "", "0");
INSERT INTO wpax_posts VALUES("163", "1", "2016-12-21 23:41:22", "2016-12-21 23:41:22", "{\n    \"illdy::illdy_jumbotron_general_third_row_from_title\": {\n        \"value\": \"grow your brand.\",\n        \"type\": \"theme_mod\",\n        \"user_id\": 1\n    }\n}", "", "", "trash", "closed", "closed", "", "800bd6e3-db9d-481f-aac7-c7ae1d631cd3", "", "", "2016-12-21 23:41:22", "2016-12-21 23:41:22", "", "0", "http://gramgro.com/800bd6e3-db9d-481f-aac7-c7ae1d631cd3/", "0", "customize_changeset", "", "0");
INSERT INTO wpax_posts VALUES("164", "1", "2016-12-21 23:50:47", "2016-12-21 23:50:47", "{\n    \"illdy::illdy_services_general_entry\": {\n        \"value\": \"GramGro is a tool we created to help you better reach thousands of Instagram users daily without doing a thing. You set the targeting settings and sit back. \",\n        \"type\": \"theme_mod\",\n        \"user_id\": 1\n    },\n    \"illdy::illdy_about_general_show\": {\n        \"value\": false,\n        \"type\": \"theme_mod\",\n        \"user_id\": 1\n    },\n    \"illdy::illdy_services_general_title\": {\n        \"value\": \"How GramGro works\",\n        \"type\": \"theme_mod\",\n        \"user_id\": 1\n    }\n}", "", "", "trash", "closed", "closed", "", "216cc19d-07c6-4686-96d1-fbd5862b83b3", "", "", "2016-12-21 23:50:47", "2016-12-21 23:50:47", "", "0", "http://gramgro.com/?p=164", "0", "customize_changeset", "", "0");
INSERT INTO wpax_posts VALUES("165", "1", "2016-12-21 23:51:43", "2016-12-21 23:51:43", "As a barber, I rely on my Instagram not only to build a reputation among other barbers, but also to attract potential customers from my local region. I was able to follow and like content from many major barber related Instagram accounts, and also from people from my town. As a result, I gained tons of new followers and inquires about my shop.", "Alex - Barber", "", "publish", "closed", "closed", "", "alex-barber", "", "", "2016-12-22 00:16:04", "2016-12-22 00:16:04", "", "0", "http://gramgro.com/?post_type=jetpack-testimonial&#038;p=165", "0", "jetpack-testimonial", "", "0");
INSERT INTO wpax_posts VALUES("166", "1", "2016-12-21 23:51:43", "2016-12-21 23:51:43", "", "Alex - Barber", "", "inherit", "closed", "closed", "", "165-revision-v1", "", "", "2016-12-21 23:51:43", "2016-12-21 23:51:43", "", "165", "http://gramgro.com/165-revision-v1/", "0", "revision", "", "0");
INSERT INTO wpax_posts VALUES("167", "1", "2016-12-21 23:51:54", "2016-12-21 23:51:54", "hi", "Alex - Barber", "", "inherit", "closed", "closed", "", "165-revision-v1", "", "", "2016-12-21 23:51:54", "2016-12-21 23:51:54", "", "165", "http://gramgro.com/165-revision-v1/", "0", "revision", "", "0");
INSERT INTO wpax_posts VALUES("168", "1", "2016-12-21 23:55:13", "2016-12-21 23:55:13", "{\n    \"illdy::illdy_testimonials_general_title\": {\n        \"value\": \"Hear from our clients\",\n        \"type\": \"theme_mod\",\n        \"user_id\": 1\n    },\n    \"illdy::illdy_testimonials_general_background_image\": {\n        \"value\": \"http://gramgro.com/wp-content/uploads/2016/12/city-wallpaper-2.jpg\",\n        \"type\": \"theme_mod\",\n        \"user_id\": 1\n    },\n    \"illdy::illdy_testimonials_number_of_posts\": {\n        \"value\": \"3\",\n        \"type\": \"theme_mod\",\n        \"user_id\": 1\n    }\n}", "", "", "trash", "closed", "closed", "", "ff58ce97-5fdc-4159-8565-6d164c0a6d39", "", "", "2016-12-21 23:55:13", "2016-12-21 23:55:13", "", "0", "http://gramgro.com/?p=168", "0", "customize_changeset", "", "0");
INSERT INTO wpax_posts VALUES("169", "1", "2016-12-21 23:57:47", "2016-12-21 23:57:47", "{\n    \"illdy::illdy_general_sections_order_third_section\": {\n        \"value\": \"7\",\n        \"type\": \"theme_mod\",\n        \"user_id\": 1\n    },\n    \"illdy::illdy_general_sections_order_fifth_section\": {\n        \"value\": \"3\",\n        \"type\": \"theme_mod\",\n        \"user_id\": 1\n    },\n    \"illdy::illdy_general_sections_order_seventh_section\": {\n        \"value\": \"4\",\n        \"type\": \"theme_mod\",\n        \"user_id\": 1\n    }\n}", "", "", "trash", "closed", "closed", "", "ce5ed6ce-c34b-4080-a0a8-2b1b1b72a7f6", "", "", "2016-12-21 23:57:47", "2016-12-21 23:57:47", "", "0", "http://gramgro.com/?p=169", "0", "customize_changeset", "", "0");
INSERT INTO wpax_posts VALUES("170", "1", "2016-12-21 23:59:29", "2016-12-21 23:59:29", "{\n    \"illdy::illdy_about_general_show\": {\n        \"value\": true,\n        \"type\": \"theme_mod\",\n        \"user_id\": 1\n    },\n    \"illdy::illdy_about_general_entry\": {\n        \"value\": \"<iframe width=\\\"560\\\" height=\\\"315\\\" src=\\\"https://www.youtube.com/embed/-TDAfnU_2bY\\\" frameborder=\\\"0\\\" allowfullscreen></iframe>\",\n        \"type\": \"theme_mod\",\n        \"user_id\": 1\n    }\n}", "", "", "trash", "closed", "closed", "", "59677923-bc04-40d7-9ec0-371f26d21059", "", "", "2016-12-21 23:59:29", "2016-12-21 23:59:29", "", "0", "http://gramgro.com/?p=170", "0", "customize_changeset", "", "0");
INSERT INTO wpax_posts VALUES("171", "1", "2016-12-22 00:01:22", "2016-12-22 00:01:22", "{\n    \"sidebars_widgets[front-page-about-sidebar]\": {\n        \"value\": [\n            \"illdy_service-6\"\n        ],\n        \"type\": \"option\",\n        \"user_id\": 1\n    },\n    \"illdy::illdy_about_general_entry\": {\n        \"value\": \"<iframe width=\\\"560\\\" height=\\\"315\\\" src=\\\"https://www.youtube.com/embed/-TDAfnU_2bY\\\" frameborder=\\\"0\\\" allowfullscreen></iframe>\",\n        \"type\": \"theme_mod\",\n        \"user_id\": 1\n    },\n    \"widget_illdy_service[6]\": {\n        \"value\": [],\n        \"type\": \"option\",\n        \"user_id\": 1\n    }\n}", "", "", "trash", "closed", "closed", "", "57883555-8a47-4f1c-80e0-c1ac02fdd540", "", "", "2016-12-22 00:01:22", "2016-12-22 00:01:22", "", "0", "http://gramgro.com/?p=171", "0", "customize_changeset", "", "0");
INSERT INTO wpax_posts VALUES("172", "1", "2016-12-22 00:02:01", "2016-12-22 00:02:01", "{\n    \"illdy::illdy_about_general_entry\": {\n        \"value\": \"<iframe width=\\\"560\\\" height=\\\"315\\\" src=\\\"https://www.youtube.com/embed/-TDAfnU_2bY\\\" frameborder=\\\"0\\\" allowfullscreen></iframe>\",\n        \"type\": \"theme_mod\",\n        \"user_id\": 1\n    }\n}", "", "", "trash", "closed", "closed", "", "cf0bf2db-cc3a-48f0-b0fc-4f74084391c3", "", "", "2016-12-22 00:02:01", "2016-12-22 00:02:01", "", "0", "http://gramgro.com/cf0bf2db-cc3a-48f0-b0fc-4f74084391c3/", "0", "customize_changeset", "", "0");
INSERT INTO wpax_posts VALUES("173", "1", "2016-12-22 00:03:13", "2016-12-22 00:03:13", "{\n    \"illdy::illdy_about_general_entry\": {\n        \"value\": \"<iframe width=\\\"560\\\" height=\\\"315\\\" src=\\\"https://www.youtube.com/embed/-TDAfnU_2bY\\\" frameborder=\\\"0\\\" allowfullscreen></iframe>\",\n        \"type\": \"theme_mod\",\n        \"user_id\": 1\n    }\n}", "", "", "trash", "closed", "closed", "", "cfdd0b0b-2e27-46d1-a579-ec1cdb34e153", "", "", "2016-12-22 00:03:13", "2016-12-22 00:03:13", "", "0", "http://gramgro.com/cfdd0b0b-2e27-46d1-a579-ec1cdb34e153/", "0", "customize_changeset", "", "0");
INSERT INTO wpax_posts VALUES("174", "1", "2016-12-22 00:09:47", "2016-12-22 00:09:47", "{\n    \"illdy::illdy_general_sections_order_second_section\": {\n        \"value\": \"6\",\n        \"type\": \"theme_mod\",\n        \"user_id\": 1\n    },\n    \"illdy::illdy_general_sections_order_eighth_section\": {\n        \"value\": \"8\",\n        \"type\": \"theme_mod\",\n        \"user_id\": 1\n    },\n    \"illdy::illdy_general_sections_order_first_section\": {\n        \"value\": \"4\",\n        \"type\": \"theme_mod\",\n        \"user_id\": 1\n    },\n    \"illdy::illdy_general_sections_order_third_section\": {\n        \"value\": \"2\",\n        \"type\": \"theme_mod\",\n        \"user_id\": 1\n    },\n    \"illdy::illdy_general_sections_order_fourth_section\": {\n        \"value\": \"2\",\n        \"type\": \"theme_mod\",\n        \"user_id\": 1\n    },\n    \"illdy::illdy_general_sections_order_sixth_section\": {\n        \"value\": \"2\",\n        \"type\": \"theme_mod\",\n        \"user_id\": 1\n    },\n    \"illdy::illdy_testimonials_general_background_image\": {\n        \"value\": \"http://gramgro.com/wp-content/uploads/2016/12/new-york-city-guide.jpg\",\n        \"type\": \"theme_mod\",\n        \"user_id\": 1\n    },\n    \"illdy::illdy_counter_background_image\": {\n        \"value\": \"http://gramgro.com/wp-content/uploads/2016/12/new-york-city-guide.jpg\",\n        \"type\": \"theme_mod\",\n        \"user_id\": 1\n    },\n    \"illdy::illdy_general_sections_order_seventh_section\": {\n        \"value\": \"2\",\n        \"type\": \"theme_mod\",\n        \"user_id\": 1\n    }\n}", "", "", "trash", "closed", "closed", "", "d9927eea-0b22-4acf-b90f-e65dd029964d", "", "", "2016-12-22 00:09:47", "2016-12-22 00:09:47", "", "0", "http://gramgro.com/?p=174", "0", "customize_changeset", "", "0");
INSERT INTO wpax_posts VALUES("175", "1", "2016-12-22 00:10:13", "2016-12-22 00:10:13", "{\n    \"illdy::illdy_jumbotron_general_third_row_from_title\": {\n        \"value\": \"\",\n        \"type\": \"theme_mod\",\n        \"user_id\": 1\n    }\n}", "", "", "trash", "closed", "closed", "", "993fa700-5d91-4154-86ff-3ec73f661fe3", "", "", "2016-12-22 00:10:13", "2016-12-22 00:10:13", "", "0", "http://gramgro.com/993fa700-5d91-4154-86ff-3ec73f661fe3/", "0", "customize_changeset", "", "0");
INSERT INTO wpax_posts VALUES("176", "1", "2016-12-22 00:12:25", "2016-12-22 00:12:25", "{\n    \"illdy::illdy_general_sections_order_third_section\": {\n        \"value\": \"3\",\n        \"type\": \"theme_mod\",\n        \"user_id\": 1\n    },\n    \"illdy::illdy_general_sections_order_fourth_section\": {\n        \"value\": \"8\",\n        \"type\": \"theme_mod\",\n        \"user_id\": 1\n    },\n    \"illdy::illdy_general_sections_order_fifth_section\": {\n        \"value\": \"8\",\n        \"type\": \"theme_mod\",\n        \"user_id\": 1\n    },\n    \"illdy::illdy_general_sections_order_eighth_section\": {\n        \"value\": \"7\",\n        \"type\": \"theme_mod\",\n        \"user_id\": 1\n    }\n}", "", "", "trash", "closed", "closed", "", "eceb226d-e305-494a-8be9-42e4ae733ffa", "", "", "2016-12-22 00:12:25", "2016-12-22 00:12:25", "", "0", "http://gramgro.com/?p=176", "0", "customize_changeset", "", "0");
INSERT INTO wpax_posts VALUES("177", "1", "2016-12-22 00:13:50", "2016-12-22 00:13:50", "{\n    \"illdy::illdy_general_sections_order_fourth_section\": {\n        \"value\": \"7\",\n        \"type\": \"theme_mod\",\n        \"user_id\": 1\n    },\n    \"illdy::illdy_testimonials_general_background_image\": {\n        \"value\": \"http://gramgro.com/wp-content/uploads/2016/12/city-wallpaper-2.jpg\",\n        \"type\": \"theme_mod\",\n        \"user_id\": 1\n    }\n}", "", "", "trash", "closed", "closed", "", "a899328e-52f3-430f-ac13-81cbfe1a11a3", "", "", "2016-12-22 00:13:50", "2016-12-22 00:13:50", "", "0", "http://gramgro.com/?p=177", "0", "customize_changeset", "", "0");
INSERT INTO wpax_posts VALUES("178", "1", "2016-12-22 00:15:28", "2016-12-22 00:15:28", "As a barber, I rely on my Instagram not only to build a reputation among other barbers, but also to attract potential customers from my local region. I was able to follow and like content from many major barber related", "Alex - Barber", "", "inherit", "closed", "closed", "", "165-autosave-v1", "", "", "2016-12-22 00:15:28", "2016-12-22 00:15:28", "", "165", "http://gramgro.com/165-autosave-v1/", "0", "revision", "", "0");
INSERT INTO wpax_posts VALUES("179", "1", "2016-12-22 00:16:04", "2016-12-22 00:16:04", "As a barber, I rely on my Instagram not only to build a reputation among other barbers, but also to attract potential customers from my local region. I was able to follow and like content from many major barber related Instagram accounts, and also from people from my town. As a result, I gained tons of new followers and inquires about my shop.", "Alex - Barber", "", "inherit", "closed", "closed", "", "165-revision-v1", "", "", "2016-12-22 00:16:04", "2016-12-22 00:16:04", "", "165", "http://gramgro.com/165-revision-v1/", "0", "revision", "", "0");
INSERT INTO wpax_posts VALUES("180", "1", "2016-12-22 00:17:43", "2016-12-22 00:17:43", "GramGro helped me use location, user, and hashtag targeting to gain followers interested in makeup tutorials. As a result, I was able to use Instagram to sell some products as well as gain new clients who saw the work I did and wanted my services.", "Katie- Makeup Artist", "", "publish", "closed", "closed", "", "katie-makeup-artist", "", "", "2016-12-22 00:17:43", "2016-12-22 00:17:43", "", "0", "http://gramgro.com/?post_type=jetpack-testimonial&#038;p=180", "0", "jetpack-testimonial", "", "0");
INSERT INTO wpax_posts VALUES("181", "1", "2016-12-22 00:17:43", "2016-12-22 00:17:43", "GramGro helped me use location, user, and hashtag targeting to gain followers interested in makeup tutorials. As a result, I was able to use Instagram to sell some products as well as gain new clients who saw the work I did and wanted my services.", "Katie- Makeup Artist", "", "inherit", "closed", "closed", "", "180-revision-v1", "", "", "2016-12-22 00:17:43", "2016-12-22 00:17:43", "", "180", "http://gramgro.com/180-revision-v1/", "0", "revision", "", "0");
INSERT INTO wpax_posts VALUES("182", "1", "2016-12-22 00:36:23", "2016-12-22 00:36:23", "{\n    \"illdy::illdy_testimonials_number_of_posts\": {\n        \"value\": \"6\",\n        \"type\": \"theme_mod\",\n        \"user_id\": 1\n    },\n    \"sidebars_widgets[front-page-services-sidebar]\": {\n        \"value\": [\n            \"illdy_service-8\",\n            \"illdy_service-9\",\n            \"illdy_service-10\",\n            \"illdy_service-2\",\n            \"illdy_service-3\",\n            \"illdy_service-4\"\n        ],\n        \"type\": \"option\",\n        \"user_id\": 1\n    },\n    \"widget_illdy_person[7]\": {\n        \"value\": [],\n        \"type\": \"option\",\n        \"user_id\": 1\n    },\n    \"widget_illdy_service[8]\": {\n        \"value\": {\n            \"encoded_serialized_instance\": \"YTo0OntzOjU6InRpdGxlIjtzOjY6IkZvbGxvdyI7czo0OiJpY29uIjtzOjEyOiJmYS11c2VyLXBsdXMiO3M6NToiZW50cnkiO3M6MTQyOiJGb2xsb3cgdXNlcnMgYmFzZWQgb24gdGhlIHRhcmdldGluZyBzZXR0aW5ncy4gWW91IHdpbGwgaGF2ZSB0aGUgb3B0aW9uIHRvIHVuZm9sbG93IHRoZW0sIG9yIGp1c3QgdW5mb2xsb3cgdGhlIG9uZXMgd2hvIGRvbid0IGZvbGxvdyB5b3UgYmFjay4gIjtzOjU6ImNvbG9yIjtzOjc6IiNmY2NjNjMiO30=\",\n            \"title\": \"Follow\",\n            \"is_widget_customizer_js_value\": true,\n            \"instance_hash_key\": \"1158e692f6e09f60f0afce7198313193\"\n        },\n        \"type\": \"option\",\n        \"user_id\": 1\n    },\n    \"widget_illdy_service[3]\": {\n        \"value\": {\n            \"encoded_serialized_instance\": \"YTo0OntzOjU6InRpdGxlIjtzOjU6IlVzZXJzIjtzOjQ6Imljb24iO3M6NzoiZmEtdXNlciI7czo1OiJlbnRyeSI7czoxOTE6IkludGVyYWN0IHdpdGggdXNlcnMgd2hvIGFscmVhZHkgZm9sbG93IGEgc3BlY2lmaWMgdXNlci4gU2NyYXBlIGZyb20geW91ciBjb21wZXRpdG9ycyBvciBmcm9tIHRoZSB0b3AgaW5kdXN0cnkgcHJvZmlsZXMgdG8gdGFyZ2V0IHRob3NlIHdobyBhcmUgYWxyZWFkeSBpbnRlcmVzdGVkIGluIGNvbnRlbnQgc2ltaWxhciB0byB5b3Vycy4gIjtzOjU6ImNvbG9yIjtzOjc6IiM4YTNhYjkiO30=\",\n            \"title\": \"Users\",\n            \"is_widget_customizer_js_value\": true,\n            \"instance_hash_key\": \"7131e871fe2dd9fe81b59e7171758c1d\"\n        },\n        \"type\": \"option\",\n        \"user_id\": 1\n    },\n    \"widget_illdy_service[9]\": {\n        \"value\": {\n            \"encoded_serialized_instance\": \"YTo0OntzOjU6InRpdGxlIjtzOjQ6Ikxpa2UiO3M6NDoiaWNvbiI7czo4OiJmYS1oZWFydCI7czo1OiJlbnRyeSI7czoxMDg6Ikxpa2UgaW1hZ2VzIG9mIHVzZXJzIGJhc2VkIG9uIHRhcmdldGluZyBzZXR0aW5ncyBiZWxvdywgaW5jbHVkaW5nIHRob3NlIHdobyB1c2UgaGFzaHRhZ3Mgb3IgdGFnIGEgbG9jYXRpb24uICI7czo1OiJjb2xvciI7czo3OiIjZTk1OTUwIjt9\",\n            \"title\": \"Like\",\n            \"is_widget_customizer_js_value\": true,\n            \"instance_hash_key\": \"eb1274b629a8c4ebb8004a00dec6f184\"\n        },\n        \"type\": \"option\",\n        \"user_id\": 1\n    },\n    \"widget_illdy_service[10]\": {\n        \"value\": {\n            \"encoded_serialized_instance\": \"YTo0OntzOjU6InRpdGxlIjtzOjc6IkNvbW1lbnQiO3M6NDoiaWNvbiI7czoxNjoiZmEtcGVuY2lsLXNxdWFyZSI7czo1OiJlbnRyeSI7czoxMTc6IkNvbW1lbnQgb24gcGljdHVyZXMgb2YgdXNlcnMgYmFzZWQgb24gdGFyZ2V0aW5nIHNldHRpbmdzLCBjb21tZW50cyBjYW4gYmUgc2hvcnQgYW5kIHN3ZWV0LCBvciBhcyBsb25nIGFzIHlvdSdkIGxpa2UuICI7czo1OiJjb2xvciI7czo3OiIjYmMyYThkIjt9\",\n            \"title\": \"Comment\",\n            \"is_widget_customizer_js_value\": true,\n            \"instance_hash_key\": \"23a129f3ac942e4ff5c2374f6e088773\"\n        },\n        \"type\": \"option\",\n        \"user_id\": 1\n    },\n    \"widget_illdy_service[4]\": {\n        \"value\": {\n            \"encoded_serialized_instance\": \"YTo0OntzOjU6InRpdGxlIjtzOjg6Ikhhc2h0YWdzIjtzOjQ6Imljb24iO3M6MTI6ImZhLWluc3RhZ3JhbSI7czo1OiJlbnRyeSI7czoxODU6IkNvbnNlY3RldHVyIGFkaXBpc2NpbmcgZWxpdC4gUHJhZXNlbnQgbW9sZXN0aWUgdXJuYSBoZW5kcmVyaXQgZXJhdCB0aW5jaWR1bnQgdGVtcHVzLiBBbGlxdWFtIGEgbGVvIHJpc3VzLiBGdXNjZSBhIG1ldHVzIG5vbiBhdWd1ZSBkYXBpYnVzIHBvcnR0aXRvciBhdCBpbiBtYXVyaXMuIFBlbGxlbnRlc3F1ZSBjb21tb2RvLi4uIjtzOjU6ImNvbG9yIjtzOjc6IiNmYmFkNTAiO30=\",\n            \"title\": \"Hashtags\",\n            \"is_widget_customizer_js_value\": true,\n            \"instance_hash_key\": \"cbb2656515d4993e12b7bb9250ec3cee\"\n        },\n        \"type\": \"option\",\n        \"user_id\": 1\n    },\n    \"illdy::illdy_services_general_entry\": {\n        \"value\": \"<iframe width=\\\"560\\\" height=\\\"315\\\" src=\\\"https://www.youtube.com/embed/-TDAfnU_2bY\\\" frameborder=\\\"0\\\" allowfullscreen></iframe>\",\n        \"type\": \"theme_mod\",\n        \"user_id\": 1\n    }\n}", "", "", "trash", "closed", "closed", "", "0fe86cce-eae2-4b1d-8a01-a15eba507793", "", "", "2016-12-22 00:36:23", "2016-12-22 00:36:23", "", "0", "http://gramgro.com/?p=182", "0", "customize_changeset", "", "0");
INSERT INTO wpax_posts VALUES("183", "1", "2016-12-22 00:19:59", "2016-12-22 00:19:59", "I used GramGro to target customers who tagged pictures from other local burger joints in the area. As a result, I was able to gain more followers, and since I advertise my daily specials and unique burger options on Instagram, some customers showed up as a result of using GramGro.", "Nick - Burger Restaurant Owner", "", "publish", "closed", "closed", "", "nick-burger-restaurant-owner", "", "", "2016-12-22 00:19:59", "2016-12-22 00:19:59", "", "0", "http://gramgro.com/?post_type=jetpack-testimonial&#038;p=183", "0", "jetpack-testimonial", "", "0");
INSERT INTO wpax_posts VALUES("184", "1", "2016-12-22 00:19:59", "2016-12-22 00:19:59", "I used GramGro to target customers who tagged pictures from other local burger joints in the area. As a result, I was able to gain more followers, and since I advertise my daily specials and unique burger options on Instagram, some customers showed up as a result of using GramGro.", "Nick - Burger Restaurant Owner", "", "inherit", "closed", "closed", "", "183-revision-v1", "", "", "2016-12-22 00:19:59", "2016-12-22 00:19:59", "", "183", "http://gramgro.com/183-revision-v1/", "0", "revision", "", "0");
INSERT INTO wpax_posts VALUES("185", "1", "2016-12-22 14:49:50", "2016-12-22 14:49:50", "{\n    \"widget_illdy_service[9]\": {\n        \"value\": {\n            \"encoded_serialized_instance\": \"YTo0OntzOjU6InRpdGxlIjtzOjQ6Ikxpa2UiO3M6NDoiaWNvbiI7czo4OiJmYS1oZWFydCI7czo1OiJlbnRyeSI7czoxMzQ6Ikxpa2UgaW1hZ2VzIG9mIHVzZXJzIGJhc2VkIG9uIHRhcmdldGluZyBzZXR0aW5ncyBiZWxvdywgaW5jbHVkaW5nIHRob3NlIHdobyB1c2UgaGFzaHRhZ3Mgb3IgdGFnIHRoZWlyIHBpY3R1cmVzIGluIHNwZWNpZmljIGxvY2F0aW9ucy4gIjtzOjU6ImNvbG9yIjtzOjc6IiNlOTU5NTAiO30=\",\n            \"title\": \"Like\",\n            \"is_widget_customizer_js_value\": true,\n            \"instance_hash_key\": \"bc80b53fc75da0450743596eaca98d1a\"\n        },\n        \"type\": \"option\",\n        \"user_id\": 1\n    },\n    \"widget_illdy_service[4]\": {\n        \"value\": {\n            \"encoded_serialized_instance\": \"YTo0OntzOjU6InRpdGxlIjtzOjg6Ikhhc2h0YWdzIjtzOjQ6Imljb24iO3M6MTI6ImZhLWluc3RhZ3JhbSI7czo1OiJlbnRyeSI7czoxNzc6Ikhhc2h0YWdzIGFyZSBhIGdyZWF0IHdheSB0byBmaW5kIHBlb3BsZSBpbnRlcmVzdGVkIGluIGNvbnRlbnQgeW91IHN1cmUsIGZyb20gI2ZpdG5lc3MgdG8gI21ha2V1cCwgYW5kIG11Y2ggbW9yZSBoYXNodGFncyBjYW4gaGVscCB5b3UgYXR0cmFjdCBmb2xsb3dlcnMgZnJvbSBhbGwgb3ZlciB0aGUgd29ybGQuICI7czo1OiJjb2xvciI7czo3OiIjZmJhZDUwIjt9\",\n            \"title\": \"Hashtags\",\n            \"is_widget_customizer_js_value\": true,\n            \"instance_hash_key\": \"2318a886fda37a9cf0eba88d8396750a\"\n        },\n        \"type\": \"option\",\n        \"user_id\": 1\n    },\n    \"illdy::illdy_contact_bar_facebook_url\": {\n        \"value\": \"\",\n        \"type\": \"theme_mod\",\n        \"user_id\": 1\n    },\n    \"illdy::illdy_contact_bar_twitter_url\": {\n        \"value\": \"\",\n        \"type\": \"theme_mod\",\n        \"user_id\": 1\n    },\n    \"illdy::illdy_contact_bar_linkedin_url\": {\n        \"value\": \"\",\n        \"type\": \"theme_mod\",\n        \"user_id\": 1\n    },\n    \"illdy::illdy_contact_bar_googlep_url\": {\n        \"value\": \"\",\n        \"type\": \"theme_mod\",\n        \"user_id\": 1\n    },\n    \"illdy::illdy_contact_bar_pinterest_url\": {\n        \"value\": \"\",\n        \"type\": \"theme_mod\",\n        \"user_id\": 1\n    },\n    \"illdy::illdy_contact_bar_instagram_url\": {\n        \"value\": \"\",\n        \"type\": \"theme_mod\",\n        \"user_id\": 1\n    },\n    \"illdy::illdy_contact_bar_youtube_url\": {\n        \"value\": \"\",\n        \"type\": \"theme_mod\",\n        \"user_id\": 1\n    },\n    \"illdy::illdy_contact_us_general_show\": {\n        \"value\": false,\n        \"type\": \"theme_mod\",\n        \"user_id\": 1\n    },\n    \"illdy::illdy_contact_bar_vimeo_url\": {\n        \"value\": \"\",\n        \"type\": \"theme_mod\",\n        \"user_id\": 1\n    },\n    \"illdy::illdy_email\": {\n        \"value\": \"gramgropro@gmail.com\",\n        \"type\": \"theme_mod\",\n        \"user_id\": 1\n    },\n    \"illdy::illdy_phone\": {\n        \"value\": \"\",\n        \"type\": \"theme_mod\",\n        \"user_id\": 1\n    },\n    \"illdy::illdy_address1\": {\n        \"value\": \"\",\n        \"type\": \"theme_mod\",\n        \"user_id\": 1\n    },\n    \"illdy::illdy_address2\": {\n        \"value\": \"\",\n        \"type\": \"theme_mod\",\n        \"user_id\": 1\n    }\n}", "", "", "trash", "closed", "closed", "", "c77ea096-c53d-413b-9664-b92eb3ad2018", "", "", "2016-12-22 14:49:50", "2016-12-22 14:49:50", "", "0", "http://gramgro.com/?p=185", "0", "customize_changeset", "", "0");
INSERT INTO wpax_posts VALUES("186", "1", "2016-12-22 17:19:54", "2016-12-22 17:19:54", "{\n    \"illdy::illdy_testimonials_general_title\": {\n        \"value\": \"Hear from our clients (scroll to read all)\",\n        \"type\": \"theme_mod\",\n        \"user_id\": 1\n    },\n    \"illdy::illdy_testimonials_general_background_image\": {\n        \"value\": \"http://gramgro.com/wp-content/uploads/2016/12/new-york-city-guide.jpg\",\n        \"type\": \"theme_mod\",\n        \"user_id\": 1\n    },\n    \"illdy::illdy_counter_background_type\": {\n        \"value\": \"color\",\n        \"type\": \"theme_mod\",\n        \"user_id\": 1\n    },\n    \"illdy::illdy_counter_background_color\": {\n        \"value\": \"#efefef\",\n        \"type\": \"theme_mod\",\n        \"user_id\": 1\n    }\n}", "", "", "trash", "closed", "closed", "", "a1a75091-9629-49a8-8032-205e27d9cf09", "", "", "2016-12-22 17:19:54", "2016-12-22 17:19:54", "", "0", "http://gramgro.com/?p=186", "0", "customize_changeset", "", "0");
INSERT INTO wpax_posts VALUES("187", "1", "2016-12-22 17:26:53", "2016-12-22 17:26:53", "{\n    \"illdy::illdy_about_general_entry\": {\n        \"value\": \"<iframe width=\\\"560\\\" height=\\\"315\\\" src=\\\"https://www.youtube.com/embed/-TDAfnU_2bY\\\" frameborder=\\\"0\\\" allowfullscreen></iframe>\",\n        \"type\": \"theme_mod\",\n        \"user_id\": 1\n    }\n}", "", "", "trash", "closed", "closed", "", "9c5cab4d-2f7d-4762-ac0b-e8c63d08138b", "", "", "2016-12-22 17:26:53", "2016-12-22 17:26:53", "", "0", "http://gramgro.com/?p=187", "0", "customize_changeset", "", "0");
INSERT INTO wpax_posts VALUES("188", "1", "2016-12-22 17:27:12", "2016-12-22 17:27:12", "{\n    \"illdy::illdy_about_general_entry\": {\n        \"value\": \"\",\n        \"type\": \"theme_mod\",\n        \"user_id\": 1\n    }\n}", "", "", "trash", "closed", "closed", "", "8572ad0a-70d4-4f0e-baa5-0104436bb5bc", "", "", "2016-12-22 17:27:12", "2016-12-22 17:27:12", "", "0", "http://gramgro.com/8572ad0a-70d4-4f0e-baa5-0104436bb5bc/", "0", "customize_changeset", "", "0");
INSERT INTO wpax_posts VALUES("189", "1", "2016-12-22 17:30:52", "2016-12-22 17:30:52", "{\n    \"illdy::illdy_latest_news_general_entry\": {\n        \"value\": \"<iframe width=\\\"560\\\" height=\\\"315\\\" src=\\\"https://www.youtube.com/embed/-TDAfnU_2bY\\\" frameborder=\\\"0\\\" allowfullscreen></iframe>\",\n        \"type\": \"theme_mod\",\n        \"user_id\": 1\n    },\n    \"illdy::illdy_general_sections_order_sixth_section\": {\n        \"value\": \"5\",\n        \"type\": \"theme_mod\",\n        \"user_id\": 1\n    },\n    \"illdy::illdy_latest_news_general_show\": {\n        \"value\": true,\n        \"type\": \"theme_mod\",\n        \"user_id\": 1\n    },\n    \"illdy::illdy_latest_news_general_title\": {\n        \"value\": \"\",\n        \"type\": \"theme_mod\",\n        \"user_id\": 1\n    },\n    \"illdy::illdy_latest_news_button_text\": {\n        \"value\": \"\",\n        \"type\": \"theme_mod\",\n        \"user_id\": 1\n    },\n    \"illdy::illdy_latest_news_number_of_posts\": {\n        \"value\": \"\",\n        \"type\": \"theme_mod\",\n        \"user_id\": 1\n    }\n}", "", "", "trash", "closed", "closed", "", "c29c96cb-6f90-4957-bf37-333fae24f672", "", "", "2016-12-22 17:30:52", "2016-12-22 17:30:52", "", "0", "http://gramgro.com/?p=189", "0", "customize_changeset", "", "0");
INSERT INTO wpax_posts VALUES("190", "1", "2016-12-22 17:31:56", "2016-12-22 17:31:56", "{\n    \"illdy::illdy_services_general_entry\": {\n        \"value\": \"<iframe width=\\\"560\\\" height=\\\"315\\\" src=\\\"https://www.youtube.com/embed/-TDAfnU_2bY\\\" frameborder=\\\"0\\\" allowfullscreen></iframe>\",\n        \"type\": \"theme_mod\",\n        \"user_id\": 1\n    },\n    \"illdy::illdy_general_sections_order_sixth_section\": {\n        \"value\": \"2\",\n        \"type\": \"theme_mod\",\n        \"user_id\": 1\n    },\n    \"illdy::illdy_latest_news_general_show\": {\n        \"value\": false,\n        \"type\": \"theme_mod\",\n        \"user_id\": 1\n    }\n}", "", "", "trash", "closed", "closed", "", "0e94d1f9-32c1-4dd5-ab06-a6a88e5d39af", "", "", "2016-12-22 17:31:56", "2016-12-22 17:31:56", "", "0", "http://gramgro.com/0e94d1f9-32c1-4dd5-ab06-a6a88e5d39af/", "0", "customize_changeset", "", "0");
INSERT INTO wpax_posts VALUES("191", "1", "2016-12-22 17:32:21", "2016-12-22 17:32:21", "{\n    \"illdy::illdy_services_general_entry\": {\n        \"value\": \"\",\n        \"type\": \"theme_mod\",\n        \"user_id\": 1\n    }\n}", "", "", "trash", "closed", "closed", "", "2cf38b19-6d8c-4734-949b-3c50a0d3fd2e", "", "", "2016-12-22 17:32:21", "2016-12-22 17:32:21", "", "0", "http://gramgro.com/2cf38b19-6d8c-4734-949b-3c50a0d3fd2e/", "0", "customize_changeset", "", "0");
INSERT INTO wpax_posts VALUES("192", "1", "2016-12-22 17:38:34", "2016-12-22 17:38:34", "{\n    \"illdy::header_image\": {\n        \"value\": \"http://gramgro.com/wp-content/uploads/2016/12/cropped-new-york-city-guide-2.jpg\",\n        \"type\": \"theme_mod\",\n        \"user_id\": 1\n    },\n    \"illdy::header_image_data\": {\n        \"value\": {\n            \"url\": \"http://gramgro.com/wp-content/uploads/2016/12/cropped-new-york-city-guide-2.jpg\",\n            \"thumbnail_url\": \"http://gramgro.com/wp-content/uploads/2016/12/cropped-new-york-city-guide-2.jpg\",\n            \"timestamp\": 1482428266101,\n            \"attachment_id\": 194,\n            \"width\": 1920,\n            \"height\": 533\n        },\n        \"type\": \"theme_mod\",\n        \"user_id\": 1\n    },\n    \"illdy::illdy_archive_page_background_stretch\": {\n        \"value\": \"1\",\n        \"type\": \"theme_mod\",\n        \"user_id\": 1\n    }\n}", "", "", "trash", "closed", "closed", "", "bfb3979d-409c-48e6-bbcf-86c45c4e7f8b", "", "", "2016-12-22 17:38:34", "2016-12-22 17:38:34", "", "0", "http://gramgro.com/?p=192", "0", "customize_changeset", "", "0");
INSERT INTO wpax_posts VALUES("193", "1", "2016-12-22 17:37:12", "2016-12-22 17:37:12", "", "cropped-new-york-city-guide-1.jpg", "", "inherit", "open", "closed", "", "cropped-new-york-city-guide-1-jpg", "", "", "2016-12-22 17:37:12", "2016-12-22 17:37:12", "", "0", "http://gramgro.com/wp-content/uploads/2016/12/cropped-new-york-city-guide-1.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO wpax_posts VALUES("194", "1", "2016-12-22 17:37:46", "2016-12-22 17:37:46", "", "cropped-new-york-city-guide-2.jpg", "", "inherit", "open", "closed", "", "cropped-new-york-city-guide-2-jpg", "", "", "2016-12-22 17:37:46", "2016-12-22 17:37:46", "", "0", "http://gramgro.com/wp-content/uploads/2016/12/cropped-new-york-city-guide-2.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO wpax_posts VALUES("195", "1", "2016-12-22 17:43:42", "2016-12-22 17:43:42", "{\n    \"illdy::jetpack_custom_css[content_width]\": {\n        \"value\": \"\",\n        \"type\": \"theme_mod\",\n        \"user_id\": 1\n    },\n    \"custom_css[illdy]\": {\n        \"value\": \"/*\\nYou can add your own CSS here.\\n\\nClick the help icon above to learn more.\\n*/\\n\\n\\n#header .bottom-header {\\n    padding-top: 10px;\\n    padding-bottom: 40px;\\n}\\n\\nhgroup#site-logo {\\n    margin-top: 0;\\n}\",\n        \"type\": \"custom_css\",\n        \"user_id\": 1\n    }\n}", "", "", "trash", "closed", "closed", "", "d4417dc3-3952-42e1-9fdb-40f5ebcbfb7f", "", "", "2016-12-22 17:43:42", "2016-12-22 17:43:42", "", "0", "http://gramgro.com/?p=195", "0", "customize_changeset", "", "0");
INSERT INTO wpax_posts VALUES("196", "1", "2016-12-22 17:43:42", "2016-12-22 17:43:42", "/*\nYou can add your own CSS here.\n\nClick the help icon above to learn more.\n*/\n\n\n#header .bottom-header {\n    padding-top: 10px;\n    padding-bottom: 40px;\n}\n\nhgroup#site-logo {\n    margin-top: 0;\n}", "illdy", "", "inherit", "closed", "closed", "", "153-revision-v1", "", "", "2016-12-22 17:43:42", "2016-12-22 17:43:42", "", "153", "http://gramgro.com/153-revision-v1/", "0", "revision", "", "0");
INSERT INTO wpax_posts VALUES("197", "1", "2016-12-22 17:44:41", "2016-12-22 17:44:41", "{\n    \"custom_css[illdy]\": {\n        \"value\": \"/*\\nYou can add your own CSS here.\\n\\nClick the help icon above to learn more.\\n*/\\n\\n\\n#header .bottom-header {\\n    padding-top: 10px;\\n    padding-bottom: 40px;\\n}\\n\\n#header .bottom-header h2 {\\n\\tline-height: .0005;\\n}\",\n        \"type\": \"custom_css\",\n        \"user_id\": 1\n    }\n}", "", "", "trash", "closed", "closed", "", "54529ac0-0048-427e-9ec4-5e9132df1723", "", "", "2016-12-22 17:44:41", "2016-12-22 17:44:41", "", "0", "http://gramgro.com/?p=197", "0", "customize_changeset", "", "0");
INSERT INTO wpax_posts VALUES("198", "1", "2016-12-22 17:44:41", "2016-12-22 17:44:41", "/*\nYou can add your own CSS here.\n\nClick the help icon above to learn more.\n*/\n\n\n#header .bottom-header {\n    padding-top: 10px;\n    padding-bottom: 40px;\n}\n\n#header .bottom-header h2 {\n	line-height: .0005;\n}", "illdy", "", "inherit", "closed", "closed", "", "153-revision-v1", "", "", "2016-12-22 17:44:41", "2016-12-22 17:44:41", "", "153", "http://gramgro.com/153-revision-v1/", "0", "revision", "", "0");
INSERT INTO wpax_posts VALUES("199", "1", "2016-12-22 17:45:44", "2016-12-22 17:45:44", "{\n    \"custom_css[illdy]\": {\n        \"value\": \"/*\\nYou can add your own CSS here.\\n\\nClick the help icon above to learn more.\\n*/\\n\\n\\n#header .bottom-header {\\n    padding-top: 10px;\\n    padding-bottom: 40px;\\n}\\n\\n#header .bottom-header h2 {\\n\\tline-height: .001;\\n}\",\n        \"type\": \"custom_css\",\n        \"user_id\": 1\n    }\n}", "", "", "trash", "closed", "closed", "", "ef26baae-2791-40cd-8324-c2e286d09306", "", "", "2016-12-22 17:45:44", "2016-12-22 17:45:44", "", "0", "http://gramgro.com/?p=199", "0", "customize_changeset", "", "0");
INSERT INTO wpax_posts VALUES("200", "1", "2016-12-22 17:45:44", "2016-12-22 17:45:44", "/*\nYou can add your own CSS here.\n\nClick the help icon above to learn more.\n*/\n\n\n#header .bottom-header {\n    padding-top: 10px;\n    padding-bottom: 40px;\n}\n\n#header .bottom-header h2 {\n	line-height: .001;\n}", "illdy", "", "inherit", "closed", "closed", "", "153-revision-v1", "", "", "2016-12-22 17:45:44", "2016-12-22 17:45:44", "", "153", "http://gramgro.com/153-revision-v1/", "0", "revision", "", "0");
INSERT INTO wpax_posts VALUES("201", "1", "2016-12-22 17:46:35", "2016-12-22 17:46:35", "{\n    \"custom_css[illdy]\": {\n        \"value\": \"/*\\nYou can add your own CSS here.\\n\\nClick the help icon above to learn more.\\n*/\\n\\n\\n#header .bottom-header {\\n    padding-top: 10px;\\n    padding-bottom: 40px;\\n}\\n\\n#header .bottom-header h2 {\\n\\tline-height: .1;\\n}\",\n        \"type\": \"custom_css\",\n        \"user_id\": 1\n    }\n}", "", "", "trash", "closed", "closed", "", "656c132b-8e12-43ec-8058-ffbc4f4988b4", "", "", "2016-12-22 17:46:35", "2016-12-22 17:46:35", "", "0", "http://gramgro.com/656c132b-8e12-43ec-8058-ffbc4f4988b4/", "0", "customize_changeset", "", "0");
INSERT INTO wpax_posts VALUES("202", "1", "2016-12-22 17:46:35", "2016-12-22 17:46:35", "/*\nYou can add your own CSS here.\n\nClick the help icon above to learn more.\n*/\n\n\n#header .bottom-header {\n    padding-top: 10px;\n    padding-bottom: 40px;\n}\n\n#header .bottom-header h2 {\n	line-height: .1;\n}", "illdy", "", "inherit", "closed", "closed", "", "153-revision-v1", "", "", "2016-12-22 17:46:35", "2016-12-22 17:46:35", "", "153", "http://gramgro.com/153-revision-v1/", "0", "revision", "", "0");
INSERT INTO wpax_posts VALUES("203", "1", "2016-12-22 17:46:47", "2016-12-22 17:46:47", "{\n    \"custom_css[illdy]\": {\n        \"value\": \"/*\\nYou can add your own CSS here.\\n\\nClick the help icon above to learn more.\\n*/\\n\\n\\n#header .bottom-header {\\n    padding-top: 10px;\\n    padding-bottom: 40px;\\n}\\n\\n#header .bottom-header h2 {\\n\\tline-height: 1;\\n}\",\n        \"type\": \"custom_css\",\n        \"user_id\": 1\n    }\n}", "", "", "trash", "closed", "closed", "", "86f32d10-3778-4a64-8e99-9e2af43bb5a5", "", "", "2016-12-22 17:46:47", "2016-12-22 17:46:47", "", "0", "http://gramgro.com/86f32d10-3778-4a64-8e99-9e2af43bb5a5/", "0", "customize_changeset", "", "0");
INSERT INTO wpax_posts VALUES("204", "1", "2016-12-22 17:46:47", "2016-12-22 17:46:47", "/*\nYou can add your own CSS here.\n\nClick the help icon above to learn more.\n*/\n\n\n#header .bottom-header {\n    padding-top: 10px;\n    padding-bottom: 40px;\n}\n\n#header .bottom-header h2 {\n	line-height: 1;\n}", "illdy", "", "inherit", "closed", "closed", "", "153-revision-v1", "", "", "2016-12-22 17:46:47", "2016-12-22 17:46:47", "", "153", "http://gramgro.com/153-revision-v1/", "0", "revision", "", "0");
INSERT INTO wpax_posts VALUES("205", "1", "2016-12-22 17:48:18", "2016-12-22 17:48:18", "{\n    \"custom_css[illdy]\": {\n        \"value\": \"/*\\nYou can add your own CSS here.\\n\\nClick the help icon above to learn more.\\n*/\\n\\n\\n#header .bottom-header {\\n    padding-top: 10px;\\n    padding-bottom: 40px;\\n}\\n\\n#header .bottom-header h2 {\\n\\tline-height: 1;\\n}\\n#header .bottom-header p {\\n    \\tfont-size: 7px;\\n}\",\n        \"type\": \"custom_css\",\n        \"user_id\": 1\n    }\n}", "", "", "trash", "closed", "closed", "", "92f2da00-bfbc-4b42-aafc-a14ad5c566c3", "", "", "2016-12-22 17:48:18", "2016-12-22 17:48:18", "", "0", "http://gramgro.com/?p=205", "0", "customize_changeset", "", "0");
INSERT INTO wpax_posts VALUES("206", "1", "2016-12-22 17:48:18", "2016-12-22 17:48:18", "/*\nYou can add your own CSS here.\n\nClick the help icon above to learn more.\n*/\n\n\n#header .bottom-header {\n    padding-top: 10px;\n    padding-bottom: 40px;\n}\n\n#header .bottom-header h2 {\n	line-height: 1;\n}\n#header .bottom-header p {\n    	font-size: 7px;\n}", "illdy", "", "inherit", "closed", "closed", "", "153-revision-v1", "", "", "2016-12-22 17:48:18", "2016-12-22 17:48:18", "", "153", "http://gramgro.com/153-revision-v1/", "0", "revision", "", "0");
INSERT INTO wpax_posts VALUES("207", "1", "2016-12-22 17:48:27", "2016-12-22 17:48:27", "{\n    \"custom_css[illdy]\": {\n        \"value\": \"/*\\nYou can add your own CSS here.\\n\\nClick the help icon above to learn more.\\n*/\\n\\n\\n#header .bottom-header {\\n    padding-top: 10px;\\n    padding-bottom: 40px;\\n}\\n\\n#header .bottom-header h2 {\\n\\tline-height: 1;\\n}\\n#header .bottom-header p {\\n    \\tfont-size: 17px;\\n}\",\n        \"type\": \"custom_css\",\n        \"user_id\": 1\n    }\n}", "", "", "trash", "closed", "closed", "", "07ff530c-7e80-4f09-ab1f-e144dc0e9a70", "", "", "2016-12-22 17:48:27", "2016-12-22 17:48:27", "", "0", "http://gramgro.com/07ff530c-7e80-4f09-ab1f-e144dc0e9a70/", "0", "customize_changeset", "", "0");
INSERT INTO wpax_posts VALUES("208", "1", "2016-12-22 17:48:27", "2016-12-22 17:48:27", "/*\nYou can add your own CSS here.\n\nClick the help icon above to learn more.\n*/\n\n\n#header .bottom-header {\n    padding-top: 10px;\n    padding-bottom: 40px;\n}\n\n#header .bottom-header h2 {\n	line-height: 1;\n}\n#header .bottom-header p {\n    	font-size: 17px;\n}", "illdy", "", "inherit", "closed", "closed", "", "153-revision-v1", "", "", "2016-12-22 17:48:27", "2016-12-22 17:48:27", "", "153", "http://gramgro.com/153-revision-v1/", "0", "revision", "", "0");
INSERT INTO wpax_posts VALUES("209", "1", "2016-12-23 17:32:28", "2016-12-23 17:32:28", "<center><iframe src=\"https://www.youtube.com/embed/-TDAfnU_2bY?rel=0&amp;autoplay=1\" width=\"640\" height=\"360\" frameborder=\"0\" allowfullscreen=\"allowfullscreen\"></iframe></center><center></center><center><img class=\"alignnone  wp-image-283\" src=\"http://gramgro.com/wp-content/uploads/2016/12/pushgram.jpg\" alt=\"\" width=\"1015\" height=\"1436\" /></center>", "How GramGro Works", "", "inherit", "closed", "closed", "", "102-autosave-v1", "", "", "2016-12-23 17:32:28", "2016-12-23 17:32:28", "", "102", "http://gramgro.com/102-autosave-v1/", "0", "revision", "", "0");
INSERT INTO wpax_posts VALUES("210", "1", "2016-12-22 17:49:52", "2016-12-22 17:49:52", "<iframe width=\"560\" height=\"315\" src=\"https://www.youtube.com/embed/-TDAfnU_2bY\" frameborder=\"0\" allowfullscreen></iframe>", "How GramGro Works", "", "inherit", "closed", "closed", "", "102-revision-v1", "", "", "2016-12-22 17:49:52", "2016-12-22 17:49:52", "", "102", "http://gramgro.com/102-revision-v1/", "0", "revision", "", "0");
INSERT INTO wpax_posts VALUES("211", "1", "2016-12-22 17:50:17", "2016-12-22 17:50:17", "<iframe src=\"https://www.youtube.com/embed/-TDAfnU_2bY\" width=\"560\" height=\"315\" frameborder=\"0\" allowfullscreen=\"allowfullscreen\"></iframe>", "How GramGro Works", "", "inherit", "closed", "closed", "", "102-revision-v1", "", "", "2016-12-22 17:50:17", "2016-12-22 17:50:17", "", "102", "http://gramgro.com/102-revision-v1/", "0", "revision", "", "0");
INSERT INTO wpax_posts VALUES("212", "1", "2016-12-22 17:50:40", "2016-12-22 17:50:40", "<center><iframe src=\"https://www.youtube.com/embed/-TDAfnU_2bY\" width=\"560\" height=\"315\" frameborder=\"0\" allowfullscreen=\"allowfullscreen\"></iframe></center>", "How GramGro Works", "", "inherit", "closed", "closed", "", "102-revision-v1", "", "", "2016-12-22 17:50:40", "2016-12-22 17:50:40", "", "102", "http://gramgro.com/102-revision-v1/", "0", "revision", "", "0");
INSERT INTO wpax_posts VALUES("213", "1", "2016-12-22 17:55:28", "2016-12-22 17:55:28", "{\n    \"custom_css[illdy]\": {\n        \"value\": \"/*\\nYou can add your own CSS here.\\n\\nClick the help icon above to learn more.\\n*/\\n\\n\\n#header .bottom-header {\\n    padding-top: 10px;\\n    padding-bottom: 40px;\\n}\\n\\n#header .bottom-header h2 {\\n\\tline-height: 1;\\n}\\n#header {\\nwidth: 100%;\\n-webkit-background-size: cover;\\n-moz-background-size: cover;\\n-o-background-size: cover;\\nbackground-size: cover;\\n}\\n#header .top-header {\\nwidth: 100%;\\npadding-top: .05px;\\n}\\n#header .top-header .header-logo {\\ndisplay: block;\\nfont-size: 38px;\\ncolor: #ffffff;\\n-webkit-transition: all 0.3s;\\n-moz-transition: all 0.3s;\\n-o-transition: all 0.3s;\\ntransition: all 0.3s;\\nfloat: left;\\n}\\n#header .top-header .header-logo:hover {\\ncolor: #f1d204;\\ntext-decoration: none;\\n}\\n#header .top-header .header-navigation {\\nfloat: right;\\n}\\n#header .top-header .header-navigation ul {\\nwidth: 100%;\\nmargin: 35px 0 0 0;\\npadding: 0;\\nlist-style-type: none;\\n}\\n#header .top-header .header-navigation ul li {\\nmargin-left: 40px;\\nline-height: 1.375;\\nfont-weight: 700;\\nfont-size: 16px;\\ncolor: #ffffff;\\ntext-transform: uppercase;\\nposition: relative;\\nfloat: left;\\n}\\n#header .top-header .header-navigation ul li:first-child {\\nmargin-left: 0;\\n}\\n#header .top-header .header-navigation ul li.menu-item-has-children a {\\npadding-right: 16px;\\nposition: relative;\\n}\\n#header .top-header .header-navigation ul li.menu-item-has-children a:after {\\ncontent: \\u201c\\\\f0d7\\u201d;\\nfont-family: \\u201cFontAwesome\\u201d;\\nfont-size: 5px;\\nposition: absolute;\\ntop: 0;\\nright: 0;\\n}\\n#header .top-header .header-navigation ul li.menu-item-has-children .sub-menu {\\nwidth: 250px;\\nmargin: 0;\\npadding: 10px 0 0 0;\\nposition: absolute;\\nleft: 0;\\ndisplay: none;\\n}\\n#header .top-header .header-navigation ul li.menu-item-has-children .sub-menu li {\\nwidth: 100%;\\nmargin: 0;\\npadding: 0;\\n}\\n#header .top-header .header-navigation ul li.menu-item-has-children .sub-menu li:first-child a {\\npadding-top: 10px;\\n}\\n#header .top-header .header-navigation ul li.menu-item-has-children .sub-menu li:last-child a {\\npadding-bottom: 10px;\\n}\\n#header .top-header .header-navigation ul li.menu-item-has-children .sub-menu li a {\\nwidth: 100%;\\nbackground-color: #ffffff;\\nmargin: 0;\\npadding: 5px 10px;\\nline-height: 1.6;\\nfont-weight: 600;\\nfont-size: 16px;\\ncolor: #333333;\\ntext-transform: none;\\ndisplay: block;\\n}\\n#header .top-header .header-navigation ul li.menu-item-has-children .sub-menu li a:hover {\\ncolor: #f1d204;\\n}\\n#header .top-header .header-navigation ul li.menu-item-has-children .sub-menu li a:after {\\ndisplay: none;\\n}\\n#header .top-header .header-navigation ul li a {\\ncolor: #ffffff;\\n-webkit-transition: all 0.3s;\\n-moz-transition: all 0.3s;\\n-o-transition: all 0.3s;\\ntransition: all 0.3s;\\n}\\n#header .top-header .header-navigation ul li a:hover {\\ncolor: #ffde00;\\ntext-decoration: none;\\n}\\n#header .bottom-header {\\nwidth: 100%;\\npadding-top: 40px;\\npadding-bottom: 40px;\\ntext-align: center;\\n}\\n#header .bottom-header.blog {\\npadding: 130px 0;\\n}\\n#header .bottom-header.blog p {\\nmargin-bottom: 0;\\n}\\n#header .bottom-header h2 {\\nmargin: 0 0 50px 0;\\nline-height: 0.74;\\nfont-weight: 900;\\nfont-size: 81px;\\ncolor: #ffffff;\\ntext-transform: uppercase;\\n}\\n#header .bottom-header span.span-dot {\\ncolor: #ffde00;\\n}\\n#header .bottom-header p {\\nline-height: 1.6;\\nmargin-bottom: 60px;\\nfont-size: 15px;\\ncolor: #ffffff;\\n}\\n#header .bottom-header .header-button-one {\\nwidth: auto;\\nheight: 63px;\\nline-height: 57px;\\nbackground: rgba(255, 255, 255, 0.2);\\nmargin: 0 15px;\\npadding: 0 70px;\\ndisplay: inline-block;\\nborder: 3px solid #ffffff;\\nborder-radius: 3px;\\nfont-weight: 700;\\nfont-size: 18px;\\ncolor: #ffffff;\\ntext-transform: uppercase;\\n-webkit-transition: all 0.3s;\\n-moz-transition: all 0.3s;\\n-o-transition: all 0.3s;\\ntransition: all 0.3s;\\n}\\n#header .bottom-header .header-button-one:hover {\\nbackground: rgba(255, 255, 255, 0.1);\\ntext-decoration: none;\\n}\\n#header .bottom-header .header-button-two {\\nwidth: auto;\\nheight: 63px;\\nline-height: 63px;\\nbackground: #f1d204;\\nmargin: 0 15px;\\npadding: 0 70px;\\ndisplay: inline-block;\\nborder-radius: 3px;\\nfont-weight: 700;\\nfont-size: 18px;\\ncolor: #ffffff;\\ntext-transform: uppercase;\\n-webkit-transition: all 0.3s;\\n-moz-transition: all 0.3s;\\n-o-transition: all 0.3s;\\ntransition: all 0.3s;\\n}\\n#header .bottom-header .header-button-two:hover {\\nbackground: rgba(241, 210, 4, 0.9);\\ntext-decoration: none;\\n}\",\n        \"type\": \"custom_css\",\n        \"user_id\": 1\n    }\n}", "", "", "trash", "closed", "closed", "", "86a76c7a-16ba-487f-8490-fe971fb41ce0", "", "", "2016-12-22 17:55:28", "2016-12-22 17:55:28", "", "0", "http://gramgro.com/?p=213", "0", "customize_changeset", "", "0");
INSERT INTO wpax_posts VALUES("214", "1", "2016-12-22 17:55:28", "2016-12-22 17:55:28", "/*\nYou can add your own CSS here.\n\nClick the help icon above to learn more.\n*/\n\n\n#header .bottom-header {\n    padding-top: 10px;\n    padding-bottom: 40px;\n}\n\n#header .bottom-header h2 {\n	line-height: 1;\n}\n#header {\nwidth: 100%;\n-webkit-background-size: cover;\n-moz-background-size: cover;\n-o-background-size: cover;\nbackground-size: cover;\n}\n#header .top-header {\nwidth: 100%;\npadding-top: .05px;\n}\n#header .top-header .header-logo {\ndisplay: block;\nfont-size: 38px;\ncolor: #ffffff;\n-webkit-transition: all 0.3s;\n-moz-transition: all 0.3s;\n-o-transition: all 0.3s;\ntransition: all 0.3s;\nfloat: left;\n}\n#header .top-header .header-logo:hover {\ncolor: #f1d204;\ntext-decoration: none;\n}\n#header .top-header .header-navigation {\nfloat: right;\n}\n#header .top-header .header-navigation ul {\nwidth: 100%;\nmargin: 35px 0 0 0;\npadding: 0;\nlist-style-type: none;\n}\n#header .top-header .header-navigation ul li {\nmargin-left: 40px;\nline-height: 1.375;\nfont-weight: 700;\nfont-size: 16px;\ncolor: #ffffff;\ntext-transform: uppercase;\nposition: relative;\nfloat: left;\n}\n#header .top-header .header-navigation ul li:first-child {\nmargin-left: 0;\n}\n#header .top-header .header-navigation ul li.menu-item-has-children a {\npadding-right: 16px;\nposition: relative;\n}\n#header .top-header .header-navigation ul li.menu-item-has-children a:after {\ncontent: “\\f0d7”;\nfont-family: “FontAwesome”;\nfont-size: 5px;\nposition: absolute;\ntop: 0;\nright: 0;\n}\n#header .top-header .header-navigation ul li.menu-item-has-children .sub-menu {\nwidth: 250px;\nmargin: 0;\npadding: 10px 0 0 0;\nposition: absolute;\nleft: 0;\ndisplay: none;\n}\n#header .top-header .header-navigation ul li.menu-item-has-children .sub-menu li {\nwidth: 100%;\nmargin: 0;\npadding: 0;\n}\n#header .top-header .header-navigation ul li.menu-item-has-children .sub-menu li:first-child a {\npadding-top: 10px;\n}\n#header .top-header .header-navigation ul li.menu-item-has-children .sub-menu li:last-child a {\npadding-bottom: 10px;\n}\n#header .top-header .header-navigation ul li.menu-item-has-children .sub-menu li a {\nwidth: 100%;\nbackground-color: #ffffff;\nmargin: 0;\npadding: 5px 10px;\nline-height: 1.6;\nfont-weight: 600;\nfont-size: 16px;\ncolor: #333333;\ntext-transform: none;\ndisplay: block;\n}\n#header .top-header .header-navigation ul li.menu-item-has-children .sub-menu li a:hover {\ncolor: #f1d204;\n}\n#header .top-header .header-navigation ul li.menu-item-has-children .sub-menu li a:after {\ndisplay: none;\n}\n#header .top-header .header-navigation ul li a {\ncolor: #ffffff;\n-webkit-transition: all 0.3s;\n-moz-transition: all 0.3s;\n-o-transition: all 0.3s;\ntransition: all 0.3s;\n}\n#header .top-header .header-navigation ul li a:hover {\ncolor: #ffde00;\ntext-decoration: none;\n}\n#header .bottom-header {\nwidth: 100%;\npadding-top: 40px;\npadding-bottom: 40px;\ntext-align: center;\n}\n#header .bottom-header.blog {\npadding: 130px 0;\n}\n#header .bottom-header.blog p {\nmargin-bottom: 0;\n}\n#header .bottom-header h2 {\nmargin: 0 0 50px 0;\nline-height: 0.74;\nfont-weight: 900;\nfont-size: 81px;\ncolor: #ffffff;\ntext-transform: uppercase;\n}\n#header .bottom-header span.span-dot {\ncolor: #ffde00;\n}\n#header .bottom-header p {\nline-height: 1.6;\nmargin-bottom: 60px;\nfont-size: 15px;\ncolor: #ffffff;\n}\n#header .bottom-header .header-button-one {\nwidth: auto;\nheight: 63px;\nline-height: 57px;\n