<?php
class TrendingCollectionDetails {
	function __construct($module = "", $id = 0, $token = "",$reffToken="",$slug='') {
		foreach ($GLOBALS as $key => $values) {
			$this->$key = $values;
		}
		$this->module = $module;
		$this->slug = $slug;
		$this->id = $id;
	}
	public function getPageContent(){
		$content = array();
		$data = $this->getTrendingCollectionList();
		if($data['status'] == true){
			$tplUrl = DIR_TMPL . $this->module . "/" . $this->module . ".tpl.php";
			$replace = array(
				'%BACK_IMAGE%'			=>$data['data']['backgroundImage'],
				'%NAME%'				=>$data['data']['name'],
				'%NO_OF_SERVICES%'		=>$data['data']['no_of_service'],
				'%SHARE_LINK%'			=>SITE_URL.'trending-details/'.$data['data']['slug'].'/',
				'%SHARE_IMAGE%'			=>$data['data']['image'],
				'%CAPTION%'				=>$data['data']['name'].' - '.SITE_NM
			);
			$content['html'] = get_view($tplUrl,$replace);
			$content['data'] = $data['data'];
		}
		else{
			$msgType = $_SESSION["msgType"] = disMessage(array('type' => 'err','var' => $data['message']));
			redirectPage(SITE_URL);
		}
		return $content;
	}

	public function getTrendingCollectionList($data=array()){
		extract($data);
		$return = array();
		$return['status'] = false;
		$return['redirectLink'] = '';
		$return['message'] = '';
		$return['data'] = array();
		$slug = (isset($slug) && $slug != '') ? $slug : $this->slug;

        $q = $this->db->pdoQuery("SELECT tc.id,tc.slug,tc.name_$this->lId as name,tc.backgroundImage,tc.image,tc.createdDate,tc.description_$this->lId as description,
        	(SELECT COUNT(inn_tc.id)
        	FROM tbl_trending_collections_services AS inn_tc
        	INNER JOIN tbl_services AS inn_s ON inn_s.id =  inn_tc.serviceId
        	INNER JOIN tbl_users AS inn_u ON inn_u.id = inn_s.userId
        	WHERE inn_tc.trendingId = tc.id AND inn_s.status = 'a' AND inn_s.isActive = 'y' AND inn_u.isActive = 'y' ) as no_of_service
        	FROM tbl_trending_collections AS tc
        	WHERE slug = ? AND tc.isActive = ? LIMIT 1 ",array($slug,'y'));

		if($q->affectedRows() > 0){
			$q_res = $q->result();
			$return['data'] = array(
				'id'				=>$q_res['id'],
				'name'				=>filtering($q_res['name']),
				'description'		=>filtering($q_res['description'],'output','text'),
				'slug'				=>filtering($q_res['slug']),
				'backgroundImage'	=>checkImage($q_res['backgroundImage'],6),
				'no_of_service'		=>$q_res['no_of_service'],
				'image'				=>checkImage($q_res['image'],5),
				'createdDate'		=>convertDate($q_res['createdDate'],true)
			);
			$return['status'] = true;
		}
		else{
			$return['message'] = COLLECTION_DETAIL_NOT_FOUND;
			$return['status'] = false;
		}
		return $return;
	}

	public function getCollectionServiceList($data=array()){
		extract($data);
		$slug = (isset($slug) && $slug != '') ? $slug : $this->slug;

		$return = array();
		$return['status'] = false;
		$return['redirectLink'] = '';
		$return['message'] = '';
		$return['data'] = array();
		$return['pagination'] = array();

		$content = array();
		$content['html'] ='';
		$content['status'] = false;
		$content['pagination'] ='';

 		$sWhere = ' WHERE tc.slug = ? AND s.status = ?  AND s.isActive = ? AND u.isActive = ?  ';
		$aWhere = array($slug,'a','y','y');

		$page =  isset($page) ? (int) $page : 1;
		$per_page_limit = $rows = (isset($per_page_limit) && $per_page_limit > 0)  ? (int) $per_page_limit : PER_PAGE_LIMIT_SEARCH_PAGE;

        $offset = ($page != 0) ? (int) ($page - 1) * $rows : 0;
		$sorting = ' ts.id DESC ';

		$totalRowCount = $this->db->pdoQuery("SELECT ts.id
                    FROM tbl_trending_collections_services AS ts
					INNER JOIN tbl_trending_collections AS tc ON tc.id = ts.trendingId
					INNER JOIN tbl_services AS s ON s.id = ts.serviceId
					INNER JOIN tbl_users AS u ON u.id = s.userId
					LEFT JOIN tbl_service_gallery AS sg ON (sg.serviceId = s.id AND sg.fileType = 'i')
					INNER JOIN tbl_service_packages AS sp ON  sp.serviceId = s.id
                    $sWhere GROUP BY ts.id  ", $aWhere);
        $totalRow =  $totalRowCount->affectedRows();


		$pager = getPagerData($totalRow, $per_page_limit, $page);
        $q = $this->db->pdoQuery("SELECT s.title,s.id,u.userName,u.slug as user_slug,s.slug as service_slug,u.profileImage,sg.fileName,MIN(sp.price) as price,s.userId,s.isFeatured,u.userLevel
			FROM tbl_trending_collections_services AS ts
			INNER JOIN tbl_trending_collections AS tc ON tc.id = ts.trendingId
			INNER JOIN tbl_services AS s ON s.id = ts.serviceId
			INNER JOIN tbl_users AS u ON u.id = s.userId
			LEFT JOIN tbl_service_gallery AS sg ON (sg.serviceId = s.id AND sg.fileType = 'i')
			INNER JOIN tbl_service_packages AS sp ON  sp.serviceId = s.id
			$sWhere GROUP BY ts.id  ORDER BY $sorting LIMIT  $offset , $rows", $aWhere);

		if($q->affectedRows() > 0){
			foreach ($q->results() as $key => $value){
				$id = $value['id'];
				$title = filtering(ucwords($value['title']));
				$service_slug = filtering($value['service_slug']);
				$user_slug = filtering($value['user_slug']);
				$userId = filtering($value['userId']);
				$userName = filtering($value['userName']);
				$profileImage = checkImage($value['profileImage'],9,$userId);
				$sImg = checkImage($value['fileName'],8,$id);
				$price = $value['price'];

				$serviceRating = $this->db->pdoQuery("SELECT AVG(r.rating) AS avgRating,COUNT(o.id) AS totalRating
					FROM tbl_orders AS o
					INNER JOIN tbl_reviews AS r ON r.orderId = o.id
					WHERE o.entityId = ? AND o.orderType = 's' AND o.status = 'c' ",array($id))->result();
				$avgRating = ($serviceRating['avgRating'] > 0 ? $serviceRating['avgRating'] : 0);
				$totalRating = ($serviceRating['totalRating'] > 0 ? $serviceRating['totalRating'] : 0);

				$totalSales = $this->db->pdoQuery("SELECT id FROM tbl_orders WHERE orderType = ? AND serviceId = ? AND
					status NOT IN (?,?) ",array('s',$value['id'],'e','ca'))->affectedRows();

				$fav_count = getTableValue('tbl_favourites','id',array('serviceId'=>$id,'userId'=>$this->sessUserId));
				$favClass = ($fav_count > 0 ? 'icon-liked' : 'icon-like');
				$user_level = ($value['userLevel'] == 'b' ? SEARCH_SERVICES_PAGE_LBL_BEGINEER : ($value['userLevel'] == 'i' ? SEARCH_SERVICES_PAGE_LBL_INTER_MIDIATE : SEARCH_SERVICES_PAGE_LBL_EXPERT));
				$user_level_class = ($value['userLevel'] == 'b' ? 'begginer-tag' : ($value['userLevel'] == 'i' ? 'intermediate-tag' : 'expert-tag'));

				$isSocialVerified =  isSocialVerified($userId);
				$isUserConsultHiveCertified =  isUserConsultHiveCertified($userId);
				if($this->sessRequestType == 'web'){
					/*multi currency change*/
		            $price = exchange($price,DEFAULT_CURRENCY_CODE,$this->cCode,$id,'s');
		            /*multi currency change*/

		            $feature_tag = ($value['isFeatured'] == 'y' ? get_view(DIR_TMPL ."/feature-tag-nct.tpl.php",array()) : '');

	            	$credentials_verfiied_tag = ($isSocialVerified == 'y' ? get_view(DIR_TMPL ."/credentials-verified-nct.tpl.php",array()) : '');
					$consultHive_certified_tag = ($isUserConsultHiveCertified == 'y' ? get_view(DIR_TMPL ."/consult-hive-certified-nct.tpl.php",array()) : '');

					$replace = array(
						'%ID%'=>$id,
						'%SERVICE_IMAGE%'		=>$sImg,
						'%STAR_RATTING%'		=>$avgRating,
						'%TOTAL_REVIEW%'		=>$totalRating,
						'%SERVICE_URL%'			=>SITE_URL.'service-details/'.$service_slug.'/',
						'%SERVICE_TITLE%'		=>$title,
						'%SELLER_IMAGE%'		=>$profileImage,
						'%SELLER_URL%'			=>SITE_URL.'profile/'.$user_slug.'/',
						'%SELLER_NAME%'			=>$userName,
						'%TOTAL_SALES%'			=>$totalSales,
						'%SERVICE_PRICE%'		=>$price,
						'%FAV_CLASS%'			=>$favClass,
						'%FEATURE_TAGS%'		=>$feature_tag,
						'%USER_LEVEL_CLASS%'	=>$user_level_class,
						'%USER_LEVEL%'			=>$user_level,
						 '%CREDENTIALS_VERIFIED%'=> $credentials_verfiied_tag,
						 '%CONSULT_HIVE_CERTIFIED%'=>$consultHive_certified_tag,
					);
					$content['html'].= get_view(DIR_TMPL . $this->module . "/service-list-nct.tpl.php",$replace);
					$content['pagination'] = pagination($pager, $page, $totalRow);
				}
				else{
					$return['pagination']['current_page'] = issetor($pager->page,0);
					$return['pagination']['total_pages'] = issetor($pager->numPages,0);
					$return['pagination']['total'] = issetor($totalRow,0);
					$return['data'][] = array(
						'id'				=>$value['id'],
						'service_image'		=>$sImg,
						'star_rating'		=>$avgRating,
						'total_review'		=>$totalRating,
						'service_url'		=>SITE_URL.'service-details/'.$service_slug.'/',
						'service_title'		=>$title,
						'seller_image'		=>$profileImage,
						'seller_url'		=>SITE_URL.'profile/'.$user_slug.'/',
						'seller_name'		=>$userName,
						'total_sales'		=>$totalSales,
						'service_price'		=>$price,
						'fav_class'			=>$favClass,
						'fav_count'			=>$fav_count
					);
				}
			}
			$return['status'] = true;
			$content['status'] = true;
		}
		else{
			$return['message'] = COLLECTION_DETAIL_NRF;
			$content['html'].=getNoRecordFoundContent(COLLECTION_DETAIL_NRF);
			$return['status'] = false;
		}
		return getreturnType($return,$content);
	}

}

?>
