<?php
class SearchServices {
	function __construct($module = "",$request=array()) {
		foreach ($GLOBALS as $key => $values) {
			$this->$key = $values;
		}
		$this->module = $module;
		$this->category = '';
		$this->subcategory = '';
		$this->min_price = '';
		$this->max_price = '';
		$this->seller_level = '';
		$this->seller_language = '';
		$this->sort_by = 'r';
		$this->keyword = '';
		$this->consult_hive_certified = '';
		$this->credential_verified = '';
		foreach ($request as $key => $values) {
			if(isset($request[$key]) && $request[$key] != ''){
				$this->$key = trim(issetor($request[$key],''));
			}
		}
	}
	public function getPageContent(){
		$content = '';
		$tplUrl = DIR_TMPL . $this->module . "/" . $this->module . ".tpl.php";
		$checked_level_begineer = (($this->seller_level != '' && in_array('b',explode(',',$this->seller_level))) ? 'checked' : '' );
		$checked_level_intermidiate = (($this->seller_level != '' && in_array('i',explode(',',$this->seller_level))) ? 'checked' : '' );
		$checked_level_expert = (($this->seller_level != '' && in_array('e',explode(',',$this->seller_level))) ? 'checked' : '' );

		$credential_verified = $this->credential_verified != '' ? 'checked' : '';
		$consult_hive_certified = $this->consult_hive_certified != '' ? 'checked' : '';
		$replace = array(
			'%CATEGORY_LIST%'				=>$this->getCategorySelection(),
			'%SUB_CATEGORY_LIST%'			=>$this->getSubCategorySelection(),
			'%LANGUAGE_LIST%'				=>$this->getLanguageSelection(),
			'%SORT_BY_LIST%'				=>$this->getSortBySelection(),
			'%KEYWORD%'						=>$this->keyword,
			'%MIN_PRICE%'					=>(($this->min_price != '' && $this->min_price >= 0) ? $this->min_price : ''),
			'%MAX_PRICE%'					=>(($this->max_price != '' && $this->max_price > 0) ? $this->max_price : ''),
			'%CHECKED_LEVEL_BEGINEER%'		=>$checked_level_begineer,
			'%CHECKED_LEVEL_INTERMIDIATE%'	=>$checked_level_intermidiate,
			'%CHECKED_LEVEL_EXPERT%'		=>$checked_level_expert,
			'%CHECKED_CREDENTIALS_VERIFIED%'		=>$credential_verified,
			'%CHECKED_CONSULT_HIVE_CERTIFIED%'		=>$consult_hive_certified,
		);
		$content = get_view($tplUrl,$replace);
		return $content;
	}

	public function getSearchServicesList($data=array()){
		extract($data);
		$return = array();
		$return['status'] = false;
		$return['redirectLink'] = '';
		$return['message'] = '';
		$return['data'] = array();
		$return['pagination'] = array();

		$content = array();
		$content['html'] ='';
		$content['status'] = false;
		$content['pagination'] ='';
		$content['title'] = SEARCH_SERVICES_PAGE_TITLE.' - ' . SITE_NM;

 		$sWhere = ' WHERE s.status = ? AND s.isActive = ? AND u.isActive = ?   ';
		$aWhere = array('a','y','y');

		$page =  isset($_REQUEST['page']) ? (int) $_REQUEST['page'] : 1;
		$per_page_limit = $rows = (isset($per_page_limit) && $per_page_limit > 0)  ? (int) $per_page_limit : PER_PAGE_LIMIT_SEARCH_PAGE;
        $offset = ($page != 0) ? (int) ($page - 1) * $rows : 0;

		$sorting = ' s.id DESC,s.title ASC  ';

		//filters
		if($this->category != ''){
			$sWhere .= ' AND c.slug = ? ';
			$aWhere[] = $this->category;
			//entry for top searched category
			$cid = getTableValue('tbl_categories','id',array('slug'=>$this->category));
			if($cid > 0)
				$this->db->insert('tbl_top_searches',array('catId'=>$cid,'createdDate'=>date('Y-m-d H:i:s')));
			//entry for top searched category
		}

		if($this->subcategory != ''){
			$subcategoryArray = explode(',',$this->subcategory);
			$sWhere .= ' AND ( ';
			foreach ($subcategoryArray as $key => $value) {
				$sWhere .= ($key > 0 ? ' OR sc.slug  = ? ' : ' sc.slug  = ?  ' );
				$aWhere[] = trim($value);
			}
			$sWhere .= ' ) ';
		}

		if($this->keyword != ''){
			$this->keyword = str_replace(array('_', '%', "'"), array('\_', '\%', "\'"), $this->keyword);

			$sWhere .= " AND ( s.title LIKE ? OR u.userName LIKE ?  ) ";
            $aWhere[] = "%$this->keyword%";
            $aWhere[] = "%$this->keyword%";
		}

		if($this->seller_level != ''){
			$levelArray = explode(',',$this->seller_level);
			$sWhere .= ' AND ( ';
			foreach ($levelArray as $key => $value){
				$sWhere .= ($key > 0 ? ' OR u.userLevel  = ? ' : ' u.userLevel  = ?  ' );
				$aWhere[] = trim($value);
			}
			$sWhere .= ' ) ';
		}

		if($this->seller_language != ''){
			$langarr = explode(",", $this->seller_language);
            $langstr = implode('","', $langarr);
			$langIdFrmDB = $this->db->pdoQuery('SELECT DISTINCT id FROM `tbl_site_languages` WHERE slug IN ("'.$langstr.'") ')->results();
			foreach ($langIdFrmDB as $key => $value) {
				$sWhere .= ' AND EXISTS ( SELECT id FROM tbl_users_languages WHERE userId = u.id AND langId = ? ) ';
				$aWhere[] = trim($value['id']);
			}

		}

		if($this->min_price != '' && $this->min_price >= 0){
			/*multi currency change*/
            $this->min_price = exchange($this->min_price,$this->cCode,DEFAULT_CURRENCY_CODE,null,'','');
            /*multi currency change*/
			$sWhere .= ' AND (SELECT MIN(price) FROM tbl_service_packages WHERE serviceId = s.id ) >=  ? ';
			$aWhere[] = $this->min_price;
		}

		if($this->max_price != '' && $this->max_price > 0){
			/*multi currency change*/
            $this->max_price = exchange($this->max_price,$this->cCode,DEFAULT_CURRENCY_CODE,null,'','');
            /*multi currency change*/
			$sWhere .= ' AND (SELECT MIN(price) FROM tbl_service_packages WHERE serviceId = s.id ) <=  ? ';
			$aWhere[] = $this->max_price;
		}
		//filters

		if($this->sort_by == 'hr'){
			$sorting = ' (SELECT AVG(r.rating)
				FROM tbl_reviews AS r
				INNER JOIN tbl_orders AS ord ON ord.id = r.orderId
				WHERE ord.entityId = s.id AND ord.orderType = "s" ) DESC , s.title ASC  ';
		}
		else if($this->sort_by == 'n'){
			$sorting = '  o.createdDate DESC,s.title ASC ';
		}
		else if($this->sort_by == 'abr'){
			$sorting = '
				( SELECT COUNT(r.id)
				FROM tbl_reviews AS r
				INNER JOIN tbl_orders AS ord ON ord.id = r.orderId
				WHERE ord.entityId = s.id AND ord.orderType = "s"  ) DESC , s.title ASC
			';
		}else if($this->sort_by == 'lth'){
			$sorting = ' (SELECT MIN(price) FROM tbl_service_packages WHERE serviceId = s.id ) ASC ';
		}else if($this->sort_by == 'htl'){
			$sorting = ' (SELECT MIN(price) FROM tbl_service_packages WHERE serviceId = s.id ) DESC ';
		}
		else{
			$sorting = ' s.isFeatured ASC ,(SELECT COUNT(id) FROM tbl_orders WHERE entityId = s.id AND orderType = "s" AND status NOT IN ("ca","e")  ) DESC,s.title ASC   ';
		}
		if(isset($this->consult_hive_certified) && $this->consult_hive_certified == 'y'){
			$sWhere .= ' AND u.isCertified = ? ';
			$aWhere[] = $this->consult_hive_certified;
		}

		if(isset($this->credential_verified) && $this->credential_verified == 'y'){
			$sWhere .= ' AND u.fbCode != "" AND  u.googleCode != "" AND  u.linkdinCode != ""   ';
		}

		$totalRowCount = $this->db->pdoQuery("SELECT s.id
            FROM tbl_services AS s
        	LEFT JOIN tbl_orders AS o ON (o.entityId = s.id AND o.orderType = 's' )
        	LEFT JOIN tbl_categories AS c ON c.id = s.categoryId
        	LEFT JOIN tbl_subcategories AS sc ON sc.id = s.subCategoryId
        	INNER JOIN tbl_users AS u ON u.id = s.userId
        	INNER JOIN tbl_service_packages AS sp ON  sp.serviceId = s.id
        	LEFT JOIN tbl_service_gallery AS sg ON (sg.serviceId = s.id AND sg.fileType = 'i')
            $sWhere GROUP BY s.id ", $aWhere);
        $totalRow =  $totalRowCount->affectedRows();

		$pager = getPagerData($totalRow, $per_page_limit, $page);
        $q = $this->db->pdoQuery("SELECT s.title,s.id,u.userName,u.slug as user_slug,s.slug as service_slug,u.profileImage,sg.fileName,MIN(sp.price) as price,s.userId,s.isFeatured,u.userLevel
        	FROM tbl_services AS s
        	LEFT JOIN tbl_orders AS o ON (o.entityId = s.id AND o.orderType = 's' )
        	LEFT JOIN tbl_categories AS c ON c.id = s.categoryId
        	LEFT JOIN tbl_subcategories AS sc ON sc.id = s.subCategoryId
        	INNER JOIN tbl_users AS u ON u.id = s.userId
        	INNER JOIN tbl_service_packages AS sp ON  sp.serviceId = s.id
        	LEFT JOIN tbl_service_gallery AS sg ON (sg.serviceId = s.id AND sg.fileType = 'i')
			$sWhere  GROUP BY s.id  ORDER BY  $sorting LIMIT  $offset , $rows", $aWhere);

		if($q->affectedRows() > 0){

			foreach ($q->results() as $key => $value){

				$id = $value['id'];
				$title = filtering(ucwords($value['title']));
				$service_slug = filtering($value['service_slug']);
				$user_slug = filtering($value['user_slug']);
				$userId = filtering($value['userId']);
				$userName = filtering($value['userName']);
				$profileImage = checkImage($value['profileImage'],9,$userId);
				$sImg = checkImage($value['fileName'],8,$id);
				$price = $value['price'];
				$user_level = ($value['userLevel'] == 'b' ? SEARCH_SERVICES_PAGE_LBL_BEGINEER : ($value['userLevel'] == 'i' ? SEARCH_SERVICES_PAGE_LBL_INTER_MIDIATE : SEARCH_SERVICES_PAGE_LBL_EXPERT));
				$user_level_class = ($value['userLevel'] == 'b' ? 'begginer-tag' : ($value['userLevel'] == 'i' ? 'intermediate-tag' : 'expert-tag'));


				$serviceRating = $this->db->pdoQuery("SELECT AVG(r.rating) AS avgRating,COUNT(o.id) AS totalRating
					FROM tbl_orders AS o
					INNER JOIN tbl_reviews AS r ON r.orderId = o.id
					WHERE o.entityId = ? AND o.orderType = 's' AND o.status = 'c'",array($id))->result();
				$avgRating = ($serviceRating['avgRating'] > 0 ? $serviceRating['avgRating'] : 0);
				$totalRating = ($serviceRating['totalRating'] > 0 ? $serviceRating['totalRating'] : 0);

				$totalSales = $this->db->pdoQuery("SELECT id FROM tbl_orders WHERE orderType = ? AND entityId = ? AND
					status NOT IN (?,?) ",array('s',$value['id'],'e','ca'))->affectedRows();

				$fav_count = getTableValue('tbl_favourites','id',array('serviceId'=>$id,'userId'=>$this->sessUserId));
				$favClass = ($fav_count > 0 ? 'icon-liked' : 'icon-like');

				$isSocialVerified =  isSocialVerified($userId);
				$isUserConsultHiveCertified =  isUserConsultHiveCertified($userId);
				if($this->sessRequestType == 'web'){

					/*multi currency change*/
	            	$price = exchange($price,DEFAULT_CURRENCY_CODE,$this->cCode,$id,'s');
	            	/*multi currency change*/


	            	$feature_tag = ($value['isFeatured'] == 'y' ? get_view(DIR_TMPL ."/feature-tag-nct.tpl.php",array()) : '');

	            	$credentials_verfiied_tag = ($isSocialVerified == 'y' ? get_view(DIR_TMPL ."/credentials-verified-nct.tpl.php",array()) : '');
					$consultHive_certified_tag = ($isUserConsultHiveCertified == 'y' ? get_view(DIR_TMPL ."/consult-hive-certified-nct.tpl.php",array()) : '');

					$replace = array(
						'%ID%'=>$id,
						'%SERVICE_IMAGE%'		=>$sImg,
						'%STAR_RATTING%'		=>$avgRating,
						'%TOTAL_REVIEW%'		=>$totalRating,
						'%SERVICE_URL%'			=>SITE_URL.'service-details/'.$service_slug.'/',
						'%SERVICE_TITLE%'		=>$title,
						'%SELLER_IMAGE%'		=>$profileImage,
						'%SELLER_URL%'			=>SITE_URL.'profile/'.$user_slug.'/',
						'%SELLER_NAME%'			=>$userName,
						'%TOTAL_SALES%'			=>$totalSales,
						'%SERVICE_PRICE%'		=>$price,
						'%FAV_CLASS%'			=>$favClass,
						'%FEATURE_TAGS%'		=>$feature_tag,
						'%USER_LEVEL_CLASS%'	=>$user_level_class,
						'%USER_LEVEL%'			=>$user_level,
						 '%CREDENTIALS_VERIFIED%'=> $credentials_verfiied_tag,
						 '%CONSULT_HIVE_CERTIFIED%'=>$consultHive_certified_tag,
					);
					$content['html'].= get_view(DIR_TMPL . $this->module . "/service-list-nct.tpl.php",$replace);
					$content['pagination'] = pagination($pager, $page, $totalRow);
				}
				else{
					$return['pagination']['current_page'] = issetor($pager->page,0);
					$return['pagination']['total_pages'] = issetor($pager->numPages,0);
					$return['pagination']['total'] = issetor($totalRow,0);
					$return['data'][] = array(
						'id'				=>$value['id'],
						'service_image'		=>$sImg,
						'star_rating'		=>$avgRating,
						'total_review'		=>$totalRating,
						'service_url'		=>SITE_URL.'service-details/'.$service_slug.'/',
						'service_title'		=>$title,
						'seller_image'		=>$profileImage,
						'seller_url'		=>SITE_URL.'profile/'.$user_slug.'/',
						'seller_name'		=>$userName,
						'total_sales'		=>$totalSales,
						'service_price'		=>$price,
						'fav_class'			=>$favClass,
						'fav_count'			=>$fav_count,
						'isFeatured'		=>$isFeatured,
						'isUserConsultHiveCertified'		=>$isUserConsultHiveCertified,
						'isSocialVerified'		=>$isSocialVerified,
					);
				}
			}
			$return['status'] = true;
			$content['status'] = true;
		}
		else{
			$return['message'] = SEARCH_SERVICES_PAGE_NRF;
			$content['html'].=getNoRecordFoundContent(SEARCH_SERVICES_PAGE_NRF);
			$return['status'] = false;
		}
		return getreturnType($return,$content);
	}

	public function getCategorySelection(){
        $return = array();
		$return['status'] = false;
		$return['redirectLink'] = '';
		$return['message'] = '';
		$return['data'] = array();

		$content = '';

		$sWhere = '  WHERE isActive = ? ';
		$aWhere = array('y');

        $c_q= $this->db->pdoQuery("SELECT id,slug,cateName_$this->lId as cateName
        		FROM tbl_categories
        		$sWhere ORDER BY cateName_$this->lId ",$aWhere);
        if($c_q->affectedRows() > 0){
            foreach ($c_q->results() as $key => $value) {

            	//selecting
            	$selected = '';
            	if($this->category != ''){
					$selected = ($this->category == $value['slug'] ? 'selected' : '');
				}
				//selecting

            	if($this->sessRequestType == 'web'){
            		$replace = array(
	                    '%OPT_VALUE%'=>$value['slug'],
	                    '%EXTRA%'=>'',
	                    '%SELECTED%'=>$selected,
	                    '%OPT_TEXT%'=>$value['cateName']
	                );
	                $content .= get_view(DIR_TMPL."/option-nct.tpl.php",$replace);
            	}
            	else{
            		$return['data'][] = array(
						'id'	=>$value['id'],
						'name'	=>$value['cateName'],
						'slug'	=>$value['slug']
					);
            	}
            }
            $return['status'] = true;
        }
        return getreturnType($return,$content);
    }

    public function getSubCategorySelection(){
        $return = array();
		$return['status'] = false;
		$return['redirectLink'] = '';
		$return['message'] = '';
		$return['data'] = array();

		$content = '';

		$sWhere = '  WHERE s.isActive = ? ';
		$aWhere = array('y');
		if($this->category != ''){
			$sWhere  .= ' AND  c.slug = ? ';
			$aWhere[] =  $this->category;
		}
		else{
			$sWhere  .= ' AND  c.id = ? ';
			$aWhere[] =  0;
		}
		$subcategoryArray= array();
		if($this->subcategory != ''){
			$subcategoryArray = explode(',',$this->subcategory);
		}
        $c_q= $this->db->pdoQuery("SELECT s.id,s.slug,s.subCategoryName_$this->lId as subCategoryName
        		FROM tbl_subcategories AS s
        		INNER JOIN tbl_categories AS c ON c.id = s.categoryId
        		$sWhere ORDER BY subCategoryName_$this->lId ASC ",$aWhere);
        if($c_q->affectedRows() > 0){
            foreach ($c_q->results() as $key => $value) {
                //selecting
				$selected = (in_array($value['slug'], $subcategoryArray)) ?   'selected' : '';
				//selecting
                if($this->sessRequestType == 'web'){
                	$replace = array(
	                    '%OPT_VALUE%'=>$value['slug'],
	                    '%EXTRA%'=>'',
	                    '%SELECTED%'=>$selected,
	                    '%OPT_TEXT%'=>$value['subCategoryName']
	                );
	                $content .= get_view(DIR_TMPL."/option-nct.tpl.php",$replace);
                }
                else{
                	$return['data'][] = array(
						'id'	=>$value['id'],
						'name'	=>$value['subCategoryName'],
						'slug'	=>$value['slug']
					);
                }
                $return['status'] = true;
            }
        }
        return getreturnType($return,$content);
    }

    public function getLanguageSelection(){
        $return = array();
		$return['status'] = false;
		$return['redirectLink'] = '';
		$return['message'] = '';
		$return['data'] = array();

		$content = '';

		$sWhere = ' WHERE l.isActive = ? ';
		$aWhere = array('y');

		$labguageArray= array();
		if($this->seller_language != ''){
			$labguageArray = explode(',',$this->seller_language);
		}
        $c_q= $this->db->pdoQuery("SELECT l.id,l.languageName,l.slug
        		FROM tbl_site_languages AS l
        		$sWhere ORDER BY l.languageName ",array('y'));
        if($c_q->affectedRows() > 0){
            foreach ($c_q->results() as $key => $value) {
            	//checked
            	$checked = (in_array($value['slug'], $labguageArray)) ?   'checked' : '';
            	//checked
            	if($this->sessRequestType == 'web'){
            		$replace = array(
	                    '%LID%'		=>$value['id'],
	                    '%SLUG%'		=>$value['slug'],
	                    '%LAN_NAME%'	=>$value['languageName'],
	                    '%CHECKED%'		=>$checked
	                );
	                $content .= get_view(DIR_TMPL.$this->module."/language-nct.tpl.php",$replace);
            	}
            	else{
            		$return['data'][] = array(
						'id'	=>$value['id'],
						'name'	=>$value['languageName']
					);
            	}
            }
            $return['status'] = true;
        }
        return getreturnType($return,$content);
    }

    public function getSortBySelection(){
		$content = '';
		$sort_by_array = array('r'=>SEARCH_SERVICES_PAGE_LBL_RECOMMENDED,'hr'=>SEARCH_SERVICES_PAGE_LBL_HIGEST_RATING,'n'=>SEARCH_SERVICES_PAGE_LBL_NEW,'abr'=>SEARCH_SERVICES_PAGE_ABG_BUYER_REVIEW,'lth'=>SEARCH_SERVICES_LOW_TO_HIGH,'htl'=>SEARCH_SERVICES_HIGH_TO_LOW);
        foreach ($sort_by_array as $key => $value){
        	//selected
        	$selected = ($key == $this->sort_by ? 'selected="selected"' : '');
        	//selected
    		$replace = array(
                '%OPT_VALUE%'=>$key,
                '%EXTRA%'=>'',
                '%SELECTED%'=>$selected,
                '%OPT_TEXT%'=>$value
            );
            $content .= get_view(DIR_TMPL."/option-nct.tpl.php",$replace);
        }
        return $content;
    }
}

?>
