<?php
class SalesHistory {
	function __construct($module = "") {
		foreach ($GLOBALS as $key => $values) {
			$this->$key = $values;
		}
	}
	public function getPageContent(){
		$content = '';
		$countData = $this->db->pdoQuery("SELECT o.id,
			(SELECT COUNT(id) FROM tbl_orders WHERE status = 'a' AND sellerId = ? ) AS totalActiveOrder,
			(SELECT COUNT(id) FROM tbl_orders WHERE status = 'c' AND sellerId = ? ) AS totalCompletedOrder,
			(SELECT COUNT(id) FROM tbl_orders WHERE status = 'ca' AND sellerId = ? ) AS totalCancelledOrder
			FROM tbl_orders AS o
			WHERE o.sellerId = ?  LIMIT 1 ",array($this->sessUserId,$this->sessUserId,$this->sessUserId,$this->sessUserId))->result();
		$tplUrl = DIR_TMPL . $this->module . "/" . $this->module . ".tpl.php";
		$replace = array(
			'%ACTIVE_ORDERS%'		=>issetor($countData['totalActiveOrder'],0),
			'%COMPLETED_ORDERS%'	=>issetor($countData['totalCompletedOrder'],0),
			'%CANCELLED_ORDERS%'	=>issetor($countData['totalCancelledOrder'],0)
		);
		$content = get_view($tplUrl,$replace);
		return $content;
	}

	public function getSalesList($data=array()){
		extract($data);

		$return = array();
		$return['status'] = false;
		$return['redirectLink'] = '';
		$return['message'] = '';
		$return['data'] = array();
		$return['sales_list'] = array();
		$return['pagination'] = array();

		$content = array();
		$content['html'] ='';
		$content['status'] = false;
		$content['pagination'] ='';

 		$sWhere = '  WHERE o.sellerId = ?    ';
		$aWhere = array($this->sessUserId);

		$page =  isset($_REQUEST['page']) ? (int) $_REQUEST['page'] : 1;
		$per_page_limit = $rows = (isset($per_page_limit) && $per_page_limit > 0)  ? (int) $per_page_limit : PER_PAGE_LIMIT;
        $offset = ($page != 0) ? (int) ($page - 1) * $rows : 0;

		$sorting = ' o.id DESC  ';


		$totalRowCount = $this->db->pdoQuery("SELECT o.id
        		FROM tbl_orders AS o
                $sWhere GROUP BY o.id  ", $aWhere);
        $totalRow =  $totalRowCount->affectedRows();

		$pager = getPagerData($totalRow, $per_page_limit, $page);
        $q = $this->db->pdoQuery("SELECT o.*
        	FROM tbl_orders AS o
			$sWhere  GROUP BY o.id  ORDER BY $sorting LIMIT  $offset , $rows", $aWhere);

		if($q->affectedRows() > 0){
			foreach ($q->results() as $key => $value){
				$createdDate = convertDate($value['createdDate']);
				/*multi currency change*/
            	$amount = exchange($value['amount'],DEFAULT_CURRENCY_CODE,$this->cCode,$value['entityId'],$value['orderType']);
            	/*multi currency change*/

				if($this->sessRequestType == 'web'){
					$replace = array(
						'%TXN_DATE%'	=>$createdDate,
						 '%TXN_ID%'		=>$value['txnId'],
						 '%TXN_AMOUNT%'	=>$amount
					);
					$content['html'].= get_view(DIR_TMPL . $this->module . "/sales-list-nct.tpl.php",$replace);
					$content['pagination'] = pagination($pager, $page, $totalRow);
				}
				else{
					$return['pagination']['current_page'] = issetor($pager->page,0);
					$return['pagination']['total_pages'] = issetor($pager->numPages,0);
					$return['pagination']['total'] = issetor($totalRow,0);
					$return['data'][] = array(
						'id'					=>$value['id'],
						'txnId'					=>$value['txnId'],
						'paymentId'				=>$value['paymentId'],
						'entityId'				=>$value['entityId'],
						'orderType'				=>$value['orderType'],
						'amount'				=>$value['amount'],
						'extraAmount'			=>$value['extraAmount'],
						'status'				=>$value['status'],
						'createdDate'			=>$createdDate
					);
				}
			}
			$return['status'] = true;
			$content['status'] = true;
		}
		else{
			$return['message'] = SALES_HISTORY_PAGE_NRF;
			$content['html'].=getNoRecordFoundContent(SALES_HISTORY_PAGE_NRF,DIR_TMPL . $this->module . "/no-record-nct.tpl.php");
			$return['status'] = false;
		}
		return getreturnType($return,$content);
	}
}

?>
