<?php
class PostRequest {
	function __construct($contentArray=array()) {
		global $objHome,$sessUserId,$sessUserName;
		foreach ($GLOBALS as $key => $values) {

			$this->$key = $values;

		}
		extract($contentArray);
		$this->module = $module;
		$this->service_slug = $service_slug;
		$this->objHome = $objHome;
		$this->sessUserId = $sessUserId;
		$this->sessUserName = $sessUserName;

		if($this->service_slug != ""){
			$getData = $this->db->pdoQuery("SELECT categoryId,subCategoryId,userId FROM tbl_services WHERE slug = ?",array($this->service_slug))->result();
			$this->catId = issetor($getData['categoryId'],0);
			$this->subCatId = issetor($getData['subCategoryId'],0);
			$this->serviceOwnerId = issetor($getData['userId'],0);
		}else{

			$this->catId = 0;
			$this->subCatId = 0;
			$this->serviceOwnerId = 0;
		}
	}
	public function getPageContent() {
		$replaceArr = array(
							'%CATEGORY_LIST%' => $this->getCategoryList($this->catId),
							'%SUB_CATEGORY_LIST%' => $this->getSubCategoryList($this->catId,$this->subCatId),
							);
		$tplUrl = DIR_TMPL . $this->module . "/" . $this->module . ".tpl.php";
		$content = get_view($tplUrl,$replaceArr);
		return $content;
	}
	/*
		this will return category options
	*/
	public function getCategoryList($catId = 0) {
		$cateHtml = "";
		$getCat =  $this->db->select("tbl_categories",array('*'),array('isActive'=>'y'));
		if($this->sessRequestType == 'web'){

			$replace = array(
							'%OPT_VALUE%'=> "",
							'%OPT_TEXT%'=> CATEGORY,
							'%EXTRA%'=>'',
							'%SELECTED%'=>'',
						);
			$cateHtml .= get_view(DIR_TMPL . "/option-nct.tpl.php",$replace);

		}
		if($getCat->affectedRows() > 0){
			$getCatResult = $getCat->results();
			foreach ($getCatResult as $key => $catData) {
				$id = $catData['id'];
				$cateName = filtering($catData['cateName_'.$this->lId]);
				$cateSlug = filtering($catData['slug']);
				if($this->sessRequestType == 'web'){
					$replace = array(
							'%OPT_VALUE%'=>$id,
							'%OPT_TEXT%'=>$cateName,
							'%EXTRA%'=>'data-id = "'.$id.'"',
							'%SELECTED%'=>($id == $catId) ? 'selected' : NULL,
						);
					$cateHtml .= get_view(DIR_TMPL . "option-nct.tpl.php",$replace);
				}
			}
		}
		return $cateHtml;
	}

	/*
		this will return sub category options
	*/
	public function getSubCategoryList($catId = 0 , $subCatId = 0) {
		$subCateHtml = "";

		$catWhr = array();
		$catWhr['categoryId'] = $catId;
		$catWhr['isActive'] = 'y';
		$getSubCat =  $this->db->select("tbl_subcategories",array('*'),$catWhr);
		if($this->sessRequestType == 'web'){
			$replace = array(
							'%OPT_VALUE%'=> "",
							'%OPT_TEXT%'=> SUB_CATEGORY,
							'%EXTRA%'=>'',
							'%SELECTED%'=>'',
						);
			$subCateHtml .= get_view(DIR_TMPL . "/option-nct.tpl.php",$replace);
		}
		if($getSubCat->affectedRows() > 0){
			$getSubCatResult = $getSubCat->results();
			foreach ($getSubCatResult as $key => $catSubData) {
				$id = $catSubData['id'];
				$subCategoryName = filtering($catSubData['subCategoryName_'.$this->lId]);
				$subCateSlug = filtering($catSubData['slug']);
				if($this->sessRequestType == 'web'){
					$replace = array(
							'%OPT_VALUE%'=>$id,
							'%OPT_TEXT%'=> wordwrap($subCategoryName,5,"<br>\n"),
							'%EXTRA%'=>'data-id = "'.$id.'"',
							'%SELECTED%'=>($id == $subCatId) ? 'selected' : NULL,
						);
					$subCateHtml .= get_view(DIR_TMPL . "option-nct.tpl.php",$replace);
				}else{
					/*app data*/
				}
			}
		}
		return $subCateHtml;
	}

	public function submitPostRequest($requestArr = array(),$file =array()){
		extract($requestArr);
		if($description != "" && $catId > 0 && $subCatId > 0 && $duration > 0 && $duration < 4 && $budget > 0 && $file['requestDoc']['name'] != ""){
			$insArr['description'] = filtering($description,'input','text');
			$insArr['catId'] = $catId;
			$insArr['userId'] = $this->sessUserId;
			$insArr['subCatId'] = $subCatId;
			$insArr['budget'] = strval($budget);
			switch ($duration) {
				case '1':
					$insArr['durationType'] = 'h';
					$insArr['duration'] = 24;
					break;

				case '2':
					$insArr['durationType'] = 'd';
					$insArr['duration'] = 3;
					break;

				case '3':
					$insArr['durationType'] = 'd';
					$insArr['duration'] = 7;
					break;
			}

			$insArr['createdDate'] = date('Y-m-d H:i:s');
			$insArr['ipAddress'] = get_ip_address();

			$lastId = $this->db->insert('tbl_request',$insArr)->getLastInsertId();

			/*multi currency change*/
            $budget_db = exchange($budget,$this->cCode,DEFAULT_CURRENCY_CODE,$lastId,'r','insert');
            $this->db->update('tbl_request',array('budget'=>strval($budget_db)),array('id'=>$lastId));
            /*multi currency change*/

            /*Multi Currency Conversation*/
            $qryCur = $this->db->pdoQuery("SELECT * FROM tbl_currency WHERE isActive = 'y' ")->results();

            $insArrCurr['cId'] = $this->cId;
            $insArrCurr['entityId'] = $lastId;
            $insArrCurr['type'] = 'r';
            foreach ($qryCur as $curVal) {
                $insArrCurr[$curVal['currencyCode']] = $curVal['rate_to_usd'];
            }
            $this->db->insert('tbl_currency_past_rates',$insArrCurr);

            /*Multi Currency Conversation*/


			//adding private users
				if($this->service_slug != '' && $this->serviceOwnerId > 0){
					if($this->serviceOwnerId != $this->sessUserId){
						$this->db->insert('tbl_request_private_users',array('requestId'=>$lastId,'userId'=>$this->serviceOwnerId,'creadtedDate'=>date('Y-m-d H:i:s')));
					}
				}
			//adding private users

			if($lastId > 0){
				$slug = makeSlugWithId($lastId);
				$this->db->update("tbl_request",array('slug'=>strtolower($slug)),array('id'=>$lastId));
			}else{
				$_SESSION["msgType"] = disMessage(array('type'=>'err','var'=>MSG_SOMETHING_WRONG));
				$returnResponse = array(
					'redirectLink' 	=> SITE_URL,
					'status'		=> false,
					'message'   	=> MSG_SOMETHING_WRONG,
					'data'  		=> array());
				return $returnResponse;
			}
			$org_filename=$file['requestDoc']['name'];
			$ext = getExt($org_filename);
			$ins['requestDoc'] = $finalName = mt_rand().mt_rand().'.'.$ext;
			$ins['originalName'] = $org_filename;
			$uploadbDir = DIR_UPD."request/".$lastId.'/';
			if (!file_exists($uploadbDir)) {
				  mkdir($uploadbDir, 0777, true);
			}

			if(!move_uploaded_file($file["requestDoc"]["tmp_name"],$uploadbDir.$finalName))
			{
    			$_SESSION["msgType"] = disMessage(array('type'=>'err','var'=>MSG_SOMETHING_WRONG));
				$returnResponse = array(
					'redirectLink' 	=> SITE_URL,
					'status'		=> false,
					'message'   	=> MSG_SOMETHING_WRONG,
					'data'  		=> array());
				return $returnResponse;
			}else{
				$this->db->update('tbl_request',$ins,array('id'=>$lastId));
			}

			$to = ADMIN_EMAIL;

			$arrayCont = array('greetings'=>"Admin",'buyer'=>$this->sessUserName);

			$array = generateEmailTemplate('request_posted',$arrayCont);
			sendEmailAddress($to,$array['subject'],$array['message']);
			$_SESSION["msgType"] = disMessage(array('type'=>'suc','var'=>MSG_REQUEST_POSTED_SUC));
				$returnResponse = array(
				'redirectLink' 	=> SITE_URL.'my-requests/',
				'status'		=> true,
				'message'   	=> MSG_REQUEST_POSTED_SUC,
				'data'  		=> array());
		}else{
			$_SESSION["msgType"] = disMessage(array('type'=>'err','var'=>MSG_FILL_ALL_VALUE));
			$returnResponse = array(
				'redirectLink' 	=> SITE_URL,
				'status'		=> false,
				'message'   	=> MSG_FILL_ALL_VALUE,
				'data'  		=> array());
			return $returnResponse;
		}
		return $returnResponse;

	}
}

?>
