<?php
class MyServices {
	function __construct($module = "") {
		foreach ($GLOBALS as $key => $values) {
			$this->$key = $values;
		}
	}
	public function getPageContent(){
		$content = '';
		$userData = $this->db->pdoQuery("SELECT u.vacationMode,u.vacationModeReason,u.acceptOffer
			FROM tbl_users AS u 
			WHERE u.id = ? LIMIT 1 ",array($this->sessUserId))->result();
		$tplUrl = DIR_TMPL . $this->module . "/" . $this->module . ".tpl.php";
		$replace = array(
			'%CHECKED_VACATION%'			=>($userData['vacationMode'] == 'y' ? 'checked' : ''),
			'%CHECKED_OFFER%'				=>($userData['acceptOffer'] == 'y' ? 'checked' : ''),
		);
		$content = get_view($tplUrl,$replace);
		return $content;
	}

	public function getContactList($data=array()){
		extract($data);

		$return = array();
		$return['status'] = false;
		$return['redirectLink'] = '';
		$return['message'] = '';
		$return['data'] = array();
		$return['pagination'] = array();
		
		$content = array();
		$content['html'] ='';
		$content['status'] = false;
		$content['pagination'] ='';
 		
 		$sWhere = '  WHERE s.isActive != ? AND s.userId = ?    ';
		$aWhere = array('n',$this->sessUserId);

		$page =  isset($_REQUEST['page']) ? (int) $_REQUEST['page'] : 1;
		$per_page_limit = $rows = (isset($per_page_limit) && $per_page_limit > 0)  ? (int) $per_page_limit : PER_PAGE_LIMIT;
        $offset = ($page != 0) ? (int) ($page - 1) * $rows : 0;
		
		$sorting = ' s.id DESC,s.title ASC  ';

		
		$totalRowCount = $this->db->pdoQuery("SELECT s.id 
        		FROM tbl_services AS s
        		LEFT JOIN tbl_service_gallery AS sg ON (sg.serviceId = s.id AND sg.fileType = 'i') 
                $sWhere GROUP BY s.id ", $aWhere);
        $totalRow =  $totalRowCount->affectedRows();

		$pager = getPagerData($totalRow, $per_page_limit, $page);
        $q = $this->db->pdoQuery("SELECT s.id,s.title,s.slug,sg.fileName,s.status,s.isActive,
        	(SELECT COUNT(id) FROM tbl_service_page_views WHERE serviceId = s.id ) as page_view,
        	(SELECT COUNT(id) FROM tbl_orders WHERE entityId = s.id AND orderType = 's' ) as order_count
    		FROM tbl_services AS s
        	LEFT JOIN tbl_service_gallery AS sg ON (sg.serviceId = s.id AND sg.fileType = 'i') 
			$sWhere  GROUP BY s.id  ORDER BY $sorting LIMIT  $offset , $rows", $aWhere);

		if($q->affectedRows() > 0){

			foreach ($q->results() as $key => $value){

				$data_array = array('userId'=>$this->sessUserId,'type'=>'canceled_order_percentage_for_service','serviceId'=>$value['id']);
				$canceled_order_percentage_for_service =  getUserStatics($data_array);

				$title = filtering(ucwords($value['title']));
				$slug = filtering($value['slug']);
				$sImg = checkImage($value['fileName'],8,$value['id']);

				$status = '';
				$is_edit = '';
				$is_delete = '';
				$edit_content = '';
				$delete_content = '';
				if($value['isActive'] == 'i'){
					$status = MY_SERVICE_PAGE_LBL_DRAFT;
					$is_edit = 'y';
					$is_delete = 'y';
				}
				else if($value['status'] == 'd'){
					$status = MY_SERVICE_PAGE_LBL_DENIED;
					$is_delete = 'y';
				}
				else if($value['status'] == 'p'){
					$status = MY_SERVICE_PAGE_LBL_PENDING;
					$is_edit = 'y';
					$is_delete = 'y';
				}
				else if($value['status'] == 'a' && $value['isActive'] == 'y'){
					$status = MY_SERVICE_PAGE_LBL_ACTIVE;
				}
				else if($value['status'] == 'a' && $value['isActive'] == 'n'){
					$status = MY_SERVICE_PAGE_LBL_DEACTIVE;
				}
				else{
					$status = MY_SERVICE_PAGE_LBL_DRAFT;
					$is_edit = 'y';
					$is_delete = 'y';
				}

				if($is_edit == 'y'){
					$edit_content = get_view(DIR_TMPL . $this->module . "/edit-service-btn-nct.tpl.php",array('%EDIT_URL%'=>SITE_URL.'edit-service/'.$value['slug'].'/'));
				}

				if($is_delete == 'y'){
					$delete_content = get_view(DIR_TMPL . $this->module . "/delete-service-btn-nct.tpl.php",array('%SLUG%'=>$value['slug']));
				}

				if($this->sessRequestType == 'web'){

					$replace = array(
						'%SERVICE_IMAGE%'		=>$sImg,
						'%SERVICE_URL%'			=>SITE_URL.'service-details/'.$slug.'/',
						'%SERVICE_TITLE%'		=>$title,
						'%PAGE_VIEWS%'			=>$value['page_view'],
						'%ORDERS%'				=>$value['order_count'],
						'%STATUS%'				=>$status,
						'%EDIT_BTN%'			=>$edit_content,
						'%DELETE_BTN%'			=>$delete_content,
						'%CANCELLED_ORDER%'		=>$canceled_order_percentage_for_service['canceled_order_percentage_for_service']
					);
					$content['html'].= get_view(DIR_TMPL . $this->module . "/service-list-nct.tpl.php",$replace);
					$content['pagination'] = pagination($pager, $page, $totalRow);
				}
				else{
					$return['pagination']['current_page'] = issetor($pager->page,0);
					$return['pagination']['total_pages'] = issetor($pager->numPages,0);
					$return['pagination']['total'] = issetor($totalRow,0);
					$return['data'][] = array(
						'id'					=>$value['id'],
						'service_image'			=>$sImg,
						'service_url'			=>SITE_URL.'service-details/'.$slug.'/',
						'service_title'			=>$title,
						'status'				=>$status,
						'page_views'			=>$value['page_view'],
						'order_count'			=>$value['order_count'],
						'cancelled_percentage'	=>$canceled_order_percentage_for_service['canceled_order_percentage_for_service']
					);
				}
			}
			$return['status'] = true;
			$content['status'] = true;
		}	
		else{
			$return['message'] = MY_SERVICE_PAGE_MDG_NRF; 
			$content['html'].=getNoRecordFoundContent(MY_SERVICE_PAGE_MDG_NRF,DIR_TMPL . $this->module . "/no-record-nct.tpl.php");
			$return['status'] = false;
		}
		return getreturnType($return,$content);
	}

	public function changeStatus($data=array()){
		extract($data);

		$return = array();
		$return['status'] = false;
		$return['redirectLink'] = '';
		$return['message'] = '';
		$return['data'] = array();

		$status = filtering(issetor($status,''),'input','string');
		$name = filtering(issetor($name,''),'input','string');
		$vacationModeReason = filtering(issetor($vacationModeReason,''),'input','text');
		if($status != ''  && $name != '' && ($name == 'vacationMode' || $name == 'acceptOffer')){
			
			$updateArray = array(
				'updatedDate'=>date('Y-m-d H:i:s')
			);
			$is_update = 'y';
			if($name == 'vacationMode')
				$updateArray['vacationMode'] = $status;

			if($vacationModeReason != '')
				$updateArray['vacationModeReason'] = $vacationModeReason;

			if($name == 'vacationMode' && $status == 'n')
				$updateArray['vacationModeReason'] = '';

			if($name == 'acceptOffer')
				$updateArray['acceptOffer'] = $status;

			if($status == 'y' && $name == 'vacationMode' && $vacationModeReason == ''){
				$is_update = 'n';
			}
			if($is_update == 'y'){
				$this->db->update('tbl_users',$updateArray,array('id'=>$this->sessUserId));
				$return['message'] = ($name == 'vacationMode' ? MY_SERVICE_PAGE_MSG_VACATION_MODE_SAVED : MY_SERVICE_PAGE_MSG_OFFER_MODE_SAVED);
	        	$return['status'] = true;
			}
			else{
				$return['message'] =  ADD_SERVICE_PAGE_MSG_PLEASE_FILL_ALL_VALUES;
			}
		}
		else{
			$return['message'] =  ADD_SERVICE_PAGE_MSG_PLEASE_FILL_ALL_VALUES;
		}
		return $return;
	}

	public function deleteService($data=array()){
		extract($data);
		
		$return = array();
		$return['status'] = false;
		$return['redirectLink'] = '';
		$return['message'] = '';
		$return['data'] = array();

		$slug = filtering(issetor($slug,''),'input','string');
		$vacationModeReason = filtering(issetor($vacationModeReason,''),'input','text');
		if($slug != ''){
			$check = $this->db->pdoQuery("SELECT id FROM tbl_services WHERE slug = ? AND userId = ? AND (status = ? OR status = ? OR isActive = ? ) LIMIT 1 ",array($slug,$this->sessUserId,'p','d','i'));
			if($check->affectedRows() > 0){
				$checkdata = $check->result();
				$this->db->delete('tbl_services',array('id'=>$checkdata['id']));
				$return['message'] =  MY_SERVICE_PAGE_MSG_SERVICE_DELETE_SUCCESS;
				$return['status'] =  true;
			}
			else{
				$return['message'] =  MY_SERVICE_PAGE_MSG_DETAIL_NOT_FOUND;
			}
		}
		else{
			$return['message'] =  MY_SERVICE_PAGE_MSG_DETAIL_NOT_FOUND;
		}
		return $return;
	}
}

?>
