<?php
class MyContacts {
	function __construct($module = "") {
		foreach ($GLOBALS as $key => $values) {
			$this->$key = $values;
		}
	}
	public function getPageContent(){
		$content = '';
		$tplUrl = DIR_TMPL . $this->module . "/" . $this->module . ".tpl.php";
		$replace = array(
			'%BUYER_LIST%'				=>$this->getBuyerSelection(),
		);
		$content = get_view($tplUrl,$replace);
		return $content;
	}

	public function getContactList($data=array()){
		extract($data);
		$buyerId = (isset($buyerId) && $buyerId > 0) ? $buyerId : '';
		$keyword = (isset($keyword) && $keyword != '') ? $keyword : '';

		$return = array();
		$return['status'] = false;
		$return['redirectLink'] = '';
		$return['message'] = '';
		$return['data'] = array();
		$return['pagination'] = array();
		
		$content = array();
		$content['html'] ='';
		$content['status'] = false;
		$content['pagination'] ='';
 		
 		$sWhere = '  WHERE ( o.userId = ? OR o.sellerId = ? ) AND  ( o.status = ? OR o.status = ? ) AND b.isActive = ?   ';
		$aWhere = array($this->sessUserId,$this->sessUserId,'c','l','y');

		$page =  isset($_REQUEST['page']) ? (int) $_REQUEST['page'] : 1;
		$per_page_limit = $rows = (isset($per_page_limit) && $per_page_limit > 0)  ? (int) $per_page_limit : PER_PAGE_LIMIT;
        $offset = ($page != 0) ? (int) ($page - 1) * $rows : 0;
		
		$sorting = ' o.id DESC,b.userName ASC  ';

		//filters
		if($buyerId != ''){
			$sWhere .= ' AND ( b.id = ? OR se.id = ? ) ';
			$aWhere[] = $buyerId;
			$aWhere[] = $buyerId;
		}

		if($keyword != ''){
			$keyword = str_replace(array('_', '%', "'"), array('\_', '\%', "\'"), $keyword);

			$sWhere .= " AND ( s.title LIKE ? OR b.userName LIKE ? OR se.userName LIKE ?  ) ";
            $aWhere[] = "%$keyword%";
            $aWhere[] = "%$keyword%";
            $aWhere[] = "%$keyword%";
		}
		
		$totalRowCount = $this->db->pdoQuery("SELECT o.id 
        		FROM tbl_orders AS o
        		INNER JOIN tbl_users AS b ON b.id = o.userId
        		INNER JOIN tbl_users AS se ON se.id = o.sellerId
        		LEFT JOIN tbl_request AS r ON (r.id = o.entityId AND o.orderType = 'r' )
				LEFT JOIN tbl_services AS s ON (s.id = o.entityId AND o.orderType = 's' )
				LEFT JOIN tbl_service_gallery AS sg ON (sg.serviceId = s.id AND sg.fileType = 'i') 
                $sWhere GROUP BY o.id ", $aWhere);
        $totalRow =  $totalRowCount->affectedRows();

		$pager = getPagerData($totalRow, $per_page_limit, $page);
        $q = $this->db->pdoQuery("SELECT o.id,o.entityId,o.userId as buyerId,(amount) as amount,b.userName,b.profileImage,s.title,s.slug as service_slug,b.slug as user_slug,sg.fileName,o.orderType,r.description,se.userName as se_userName,se.profileImage as se_profileImage,se.slug as se_slug,o.sellerId
    		FROM tbl_orders AS o
    		INNER JOIN tbl_users AS b ON b.id = o.userId
    		INNER JOIN tbl_users AS se ON se.id = o.sellerId
    		LEFT JOIN tbl_request AS r ON (r.id = o.entityId AND o.orderType = 'r' )
			LEFT JOIN tbl_services AS s ON (s.id = o.entityId AND o.orderType = 's' )
			LEFT JOIN tbl_service_gallery AS sg ON (sg.serviceId = s.id AND sg.fileType = 'i') 
			$sWhere  GROUP BY o.id  ORDER BY $sorting LIMIT  $offset , $rows", $aWhere);

		if($q->affectedRows() > 0){

			foreach ($q->results() as $key => $value){

				$title = filtering(ucwords($value['title']));
				$service_slug = filtering($value['service_slug']);
				$buyerId = filtering($value['buyerId']);
				$sImg = checkImage($value['fileName'],8,$value['entityId']);
				$amount = $value['amount'];
				$description = filtering($value['description']);
				$description = issetor($description);
				$descDetail = myTruncate($description,50);

				if($this->sessUserId == $buyerId){
					$profileImage = checkImage($value['se_profileImage'],9,$value['sellerId']);
					$user_slug = filtering($value['se_slug']);
					$userName = filtering($value['se_userName']);
				}
				else{
					$profileImage = checkImage($value['profileImage'],9,$buyerId);
					$user_slug = filtering($value['user_slug']);
					$userName = filtering($value['userName']);
				}

				if($this->sessRequestType == 'web'){

					/*multi currency change*/
	            	$amount = exchange($amount,DEFAULT_CURRENCY_CODE,$this->cCode,null,'');
	            	/*multi currency change*/
	            	
					$replace = array(
						'%SERVICE_IMAGE%'		=>($value['orderType'] == 's' ? $sImg : $profileImage),
						'%SERVICE_URL%'			=>($value['orderType'] == 's' ? SITE_URL.'service-details/'.$service_slug.'/' : 'javascript:void(0);'),
						'%SERVICE_TITLE%'		=>($value['orderType'] == 's' ? $title : $descDetail),
						'%BUYER_IMAGE%'			=>$profileImage,
						'%BUYER_URL%'			=>SITE_URL.'profile/'.$user_slug.'/',
						'%BUYER_NAME%'			=>$userName,
						'%SERVICE_PRICE%'		=>$amount
					);
					$content['html'].= get_view(DIR_TMPL . $this->module . "/contact-list-nct.tpl.php",$replace);
					$content['pagination'] = pagination($pager, $page, $totalRow);
				}
				else{
					$return['pagination']['current_page'] = issetor($pager->page,0);
					$return['pagination']['total_pages'] = issetor($pager->numPages,0);
					$return['pagination']['total'] = issetor($totalRow,0);
					$return['data'][] = array(
						'order_id'			=>$value['id'],
						'service_id'		=>$value['serviceId'],
						'buyer_id'			=>$value['buyerId'],
						'service_image'		=>$sImg,
						'service_url'		=>SITE_URL.'service-details/'.$service_slug.'/',
						'service_title'		=>$title,
						'buyer_image'		=>$profileImage,
						'buyer_url'			=>SITE_URL,
						'buyer_name'		=>$userName,
						'service_price'		=>$amount
					);
				}
			}
			$return['status'] = true;
			$content['status'] = true;
		}	
		else{
			$return['message'] = MY_CONTACTS_PAGE_NRF; 
			$content['html'].=getNoRecordFoundContent(MY_CONTACTS_PAGE_NRF,DIR_TMPL . $this->module . "/no-record-nct.tpl.php");
			$return['status'] = false;
		}
		return getreturnType($return,$content);
	}

	public function getBuyerSelection($data=array()){
		extract($data);
		$buyerId = isset($buyerId) ? $buyerId : '';
        $return = array();
		$return['status'] = false;
		$return['redirectLink'] = '';
		$return['message'] = '';
		$return['data'] = array();

		$content = '';

		$sWhere = '  WHERE ( o.userId = ? OR o.sellerId = ? ) AND  ( o.status = ? OR o.status = ? ) AND b.isActive = ? AND se.isActive = ? ';
		$aWhere = array($this->sessUserId,$this->sessUserId,'c','l','y','y');

        $c_q= $this->db->pdoQuery("SELECT b.id,b.userName as name,se.id as se_id,se.userName as se_name
        		FROM tbl_orders AS o
        		INNER JOIN tbl_users AS b ON b.id = o.userId
        		INNER JOIN tbl_users AS se ON se.id = o.sellerId
        		$sWhere GROUP BY b.id,se.id ORDER BY o.id DESC  ",$aWhere);
        if($c_q->affectedRows() > 0){
        	$items = array();
            foreach ($c_q->results() as $key => $value) {
            	//selecting 
            	$userName = ($this->sessUserId == $value['id'] ? $value['se_name'] : $value['name']);
            	$id = ($this->sessUserId == $value['id'] ? $value['se_id'] : $value['id']);       	           	
				$selected = '';
				//selecting
				if(!in_array($id,$items)){
					if($this->sessRequestType == 'web'){
	            		$replace = array(
		                    '%OPT_VALUE%'=>$id,
		                    '%EXTRA%'=>'',
		                    '%SELECTED%'=>$selected,
		                    '%OPT_TEXT%'=>$userName 
		                );
		                $content .= get_view(DIR_TMPL."/option-nct.tpl.php",$replace);
	            	}
	            	else{
	            		$return['data'][] = array(
							'id'	=>$id,
							'name'	=>$userName
						);
	            	}
				}
				$items[] = $id;
            }
            $return['status'] = true;
        }
        return getreturnType($return,$content);
    }
}

?>
