<?php
class Home {

	/*
		this will store value of constructore
	*/

	function __construct($contentArray = array()) {
		foreach ($GLOBALS as $key => $values) {
			$this->$key = $values;
		}
		extract($contentArray);
		$this->module = $module;
		$this->id = isset($id) ? $id : 0;
	}
	

	/*
		this will return body for homepage
	*/
	public function getPageContent() {
		$recommendationsSection =$html = null;

		$sliderContent = $this->getSlider();
		$popularCategoryList = $this->getPopularCategory();
		$trendingCollectionList = $this->getTrendingCollections();
		$featuredServiceList = $this->getFeaturedServices();
		$topRatedSellerList = $this->getTopRatedSeller();
		if($this->sessUserId > 0){
			$recommendationsSection = $this->getRecommendationSection();

		}

		$taskCompleted = TASK_COMPLETED;
		$activeTask = ACTIVE_TASK;
		$taskReviewd = TASK_REVIEWED;
		if(STATISTICS == 'l'){
			$taskCompleted = $this->db->pdoQuery("SELECT * FROM tbl_orders WHERE status = 'c'")->affectedRows();
			$activeTask = $this->db->pdoQuery("SELECT * FROM tbl_orders WHERE status = 'a' ")->affectedRows();
			$taskReviewd = $this->db->pdoQuery("SELECT * FROM tbl_reviews WHERE isActive = 'y' ")->affectedRows();

		}

		$replace = array(
			'%SLIDER%' =>$sliderContent,
			'%POPULAR_CATEGORY_LIST%' => $popularCategoryList,
			'%TRENDING_COLLECTION_LIST%' => $trendingCollectionList,
			'%RECOMMENDATIONS_SECTION%' => $recommendationsSection,
			'%TASK_COMPLETE%' =>$taskCompleted,
			'%ACTIVE_TASK%' =>$activeTask,
			'%TASK_REVIEWED%' =>$taskReviewd,
			'%FEATURED_SERVICE_LIST%' => $featuredServiceList,
			'%TOP_RATED_SELLER_LIST%' => $topRatedSellerList,
			'%FOOTER_LOGO%'=> $this->getFooterLogo(),
			);
		$html .= get_view(DIR_TMPL . $this->module . "/" . $this->module . ".tpl.php",$replace);
		return $html;
	}

	/*
		this will return header of page
	*/
	public function getHeaderContent($module) {

		$user_menu_list = $responsive_search_section = $search_panel = $search_button = $menu = NULL;

		if(isset($this->sessUserId) && $this->sessUserId > 0){

			$userData = $this->db->pdoQuery("SELECT userName , profileImage  FROM tbl_users WHERE id = ?",array($this->sessUserId))->result();

			$chkPhoto = checkImage($userData['profileImage'],9,$this->sessUserId);

			/*get list of user menu after login*/
			$user_menu_list = get_view(DIR_TMPL . $this->module . "/" . "user_menu_list-nct.tpl.php");

			/*unread msg*/
			$unreadMsgList = $this->unreadMsgList();
			$msgHideClass = '';
			$msgUnread = 'unread';
			if($unreadMsgList['count'] <= 0){
				$msgHideClass = 'hide';
				$msgUnread = '';
			}

			/*unread notification*/
			$unreadNotificationList = $this->unreadNotificationList();
			$notiHideClass = '';
			$notiUnread = 'unread';
			if($unreadNotificationList['count'] <= 0){
				$notiHideClass = 'hide';
				$notiUnread = '';
			}


			$replace = array('%USERNAME%'=>filtering($userData['userName']),
							 '%PROFILE_PHOTO%'=> $chkPhoto,
							 '%USER_MENU_LIST%'=>$user_menu_list,
							 '%MESSAGE_URL%' => SITE_URL,
							 '%NOTIFICATION_URL%' => SITE_URL.'notification-list/',
							 '%SELL_SERVICE_URL%' => SITE_URL.'add-new-service/	',
							 '%POST_REQUEST_URL%' => SITE_URL.'post-a-request/',
							 '%MESSAGE_TITLE%' => MESSAGE,
							 '%NOTIFICATION_TITLE%' => NOTIFICATION,
							 '%SELL_SERVICE_TITLE%' => SELL_A_SERVICE,
							 '%POST_REQUEST_TITLE%' => POST_A_REQUEST,
							 '%MSG_HIDE_CLASS%' => $msgHideClass,
							 '%MSG_UNREAD%' => $msgUnread,
							 '%UNREAD_MSG_LIST%' => $unreadMsgList['list'],
							 '%MESSAGE_URL%'=> SITE_URL.'message-room/',
							 '%NOTI_HIDE_CLASS%' => $notiHideClass,
							 '%NOTI_UNREAD%' => $notiUnread,
							 '%UNREAD_NOTI_LIST%' => $unreadNotificationList['list'],
							 '%NOTIFICATION_URL%'=> SITE_URL.'notification-list/',
							 );

			/*tpl for web*/
			$menu = get_view(DIR_TMPL . $this->module . "/" . "after-login-menu-nct.tpl.php",$replace);

			/*tpl for responsive*/
			$menu_responsive = get_view(DIR_TMPL . $this->module . "/" . "after-login-menu-responsive-nct.tpl.php",$replace);

			if($module != 'home-nct'){
				/*search tpl for repsonsive and web*/
				$search_button = get_view(DIR_TMPL . $this->module . "/" . "search-button-nct.tpl.php");
				$search_panel = get_view(DIR_TMPL . $this->module . "/" . "search-panel-nct.tpl.php");
				$responsive_search_section = get_view(DIR_TMPL . $this->module . "/" . "search-responsive-section-nct.tpl.php");
			}
		}else{
			if($module == 'login-nct' || $module == 'registration-nct'){
				if($module == 'login-nct'){
					$replace = array('%DISPLAY_VALUE%'=>LOGIN_HEADER_MENU_TITLE,'%URL%'=>SITE_URL.'sign-up','%TITLE%'=>REGISTRATION);
				}else{
					$replace = array('%DISPLAY_VALUE%'=>SIGNUP_HEADER_MENU_TITLE,'%URL%'=>SITE_URL.'login','%TITLE%'=>LOGIN);
				}
				$menu_responsive = $menu = get_view(DIR_TMPL . $this->module . "/" . "login-registration-menu-nct.tpl.php",$replace);

			}else{
				$menu_responsive = $menu = get_view(DIR_TMPL . $this->module . "/" . "before-login-menu-nct.tpl.php");
			}
		}
		$social_link = $header_class = "";

		if($module == 'home-nct'){
			$social_link =  get_view(DIR_TMPL . "social-link-nct.tpl.php");

		}
		//////
		$html = null;
		$replace = array(
			'%SITE_LOGO%'=>SITE_IMG . SITE_LOGO,
			'%MENU%'=>$menu,
			'%MENU_RESPONSIVE%' => $menu_responsive,
			'%ALT%'=>SITE_NM,
			'%INNER_HEADER%'=>$header_class,
			'%SOCIAL_LINK%' => $social_link,
			'%SEARCH_BUTTON%' => $search_button,
			'%SEARCH_PANEL%' => $search_panel,
			'%RESPONSIVE_SEARCH_SECTION%' => $responsive_search_section,
			'%FOOTER_LOGO%'=> $this->getFooterLogo()
		);
		$html .= get_view(DIR_TMPL . "header-nct.tpl.php",$replace);
		return $html;
		//////
	}

	/*
		this will return unread msg list
	*/
	public function unreadMsgList(){
		$msg_list_html =NULL;
		$qry = "SELECT m.*,s.userName,s.profileImage FROM tbl_messages AS m INNER JOIN tbl_users AS s ON s.id = m.senderId  WHERE m.readStatus = 'n' AND m.receiverId = ".$this->sessUserId." AND m.receiverDelete = 'n' AND s.isActive ='y' ORDER BY m.id DESC";

		$msg_noti_unread_count = $this->db->pdoQuery($qry)->affectedRows();
		$returnArr ['count'] = $msg_noti_unread_count;

		if($msg_noti_unread_count > 0){
			$msg_list = $this->db->pdoQuery($qry.' LIMIT 0,5')->results();
			foreach ($msg_list as $key => $msgValue) {

				$userName = filtering($msgValue['userName']);
				$senderId = filtering($msgValue['senderId']);
				$message = filtering(myTruncate($msgValue['message'],30));

				$profileImage = checkImage($msgValue['profileImage'],9,$senderId);
				if($this->sessRequestType == 'web'){

					$replace = array('%MSG_URL%'=>SITE_URL.'message-room/'/*.$senderId.'/'*/,
									 '%USER_NAME%' => $userName,
									 '%HIDE_SHOW%' => "show",
									 '%USER_IMAGE%' => $profileImage,
									 '%LAST_MSG%' => $message);
					$msg_list_html .=  get_view(DIR_TMPL . "single-header-message-nct.tpl.php",$replace);
				}else{
					/*app data*/
				}
			}
		}else{
			$replace = array('%LAST_MSG%' => NMF);
			$msg_list_html .=  get_view(DIR_TMPL . "header-no-message-nct.tpl.php",$replace);

		}
		$returnArr ['list'] = $msg_list_html;
		return $returnArr;
	}

	/*
		this will return unread notification list
	*/
	public function unreadNotificationList(){
		$noti_list_html =NULL;
		$qry = "SELECT n.*FROM tbl_site_notification AS n  WHERE n.readStatus = 'n' AND n.receiverId = ".$this->sessUserId." ORDER BY n.id DESC";

		$noti_unread_count = $this->db->pdoQuery($qry)->affectedRows();
		$returnArr ['count'] = $noti_unread_count;

		if($noti_unread_count > 0){
			$noti_list = $this->db->pdoQuery($qry.' LIMIT 0,5')->results();

			foreach ($noti_list as $key => $notiValue) {
				extract($notiValue);
				$userName = getTableValue('tbl_users','userName',array('id'=>$senderId));
				/*if(defined($notiValue['notification'])){
					$notiValue['notification'] = constant($notiValue['notification']);
				}
				$notificationMsg = str_replace("%USER%", $userName, $notiValue['notification']);*/
				$notify_data = getNotificationText($notiValue['id'],$notiValue['notification']);
				$notificationMsg = $notify_data['notification_text'];
				$notificationURL = $notify_data['notification_url'];
				$senderId = filtering($notiValue['senderId']);
				if($this->sessRequestType == 'web'){

					$replace = array('%NOTIFICATION_URL%'=>$notificationURL,
									 '%NOTIFICATION_MSG%' => myTruncate($notificationMsg,45));
					$noti_list_html .=  get_view(DIR_TMPL . "single-header-notification-nct.tpl.php",$replace);
				}else{
					/*app data*/
				}
			}
		}else{
			$noti_list_html = NMF;
		}
		$returnArr ['list'] = $noti_list_html;
		return $returnArr;
	}
	/*
		this will return footer logo
	*/
	public function getFooterLogo(){
		$html = get_view(DIR_TMPL . "footer-site-logo-nct.tpl.php");
		return $html;
	}

	/*
		this will return footer of page
	*/
	public function getFooterContent($module) {
		//////
		$nlForm = $html = null;
		if($this->sessUserId > 0){
			$nlForm = get_view(DIR_TMPL . "newsletter-form-nct.tpl.php");
		}
		$selectedCurrencyRate = getTableValue('tbl_currency','rate_to_usd',array('id'=>$_SESSION['cId']));
		$defaultCurrencyRate = getTableValue('tbl_currency','rate_to_usd',array('default_cur'=>'y'));
		$typeForLoginOrVerify = ($module == 'account_settings-nct' ? 'verify' : 'login');
		$linked_in_js = get_view(DIR_TMPL . "linked-in-social-js-nct.tpl.php",array('%TYPE_FOR_LOGIN_OR_VERIFY%'=>$typeForLoginOrVerify));
		$replace = array(
			'%FOOTER%' => $this->get_menu(),
			'%LANGUAGE_LIST%' => $this->get_lang_item(),
			'%CURRENCY_LIST%' => $this->get_currency_item(),
			'%FOOTER_LOGO%'=> $this->getFooterLogo(),
			'%FOOTER_SOCIAL_LINK%' => get_view(DIR_TMPL . "/social-link-nct.tpl.php"),
			'%LANG_ID%'=>$_SESSION['lId'],
			'%NEWSLETTER_FORM%' => $nlForm,
			'%CURRENT_MODULE%' => $module,
			'%SESS_USER_ID%'=>$this->sessUserId,
			'%LANG_ID%'=>$_SESSION['lId'],
			'%CURRENCY_ID%'=>$_SESSION['cId'],
			'%CURRENCY_CODE%'=>$this->cCode,
			'%SELECTED_CURRENCY_RATE%'=>$selectedCurrencyRate,
			'%DEFAULT_CURRENCY_RATE%'=>$defaultCurrencyRate,
			'%SOCIAL_JS%'	=>($module == 'login-nct' || $module == 'registration-nct' || $module == 'account_settings-nct' ? $linked_in_js : '')
			);
		$html .= get_view(DIR_TMPL . "footer-nct.tpl.php",$replace);
		return $html;
		//////
	}

	/*
		this will return footer content menu on every page
	*/
	public function get_menu(){
		$menu = null;
		$pages = $this->db->select("tbl_content",array('*'),array("isActive"=>'y'))->results();
		$menu_item = "";
		foreach ($pages as $page) {
			$menu .= get_view(DIR_TMPL.'footer-menu-li-nct.tpl.php',array("%LI_URL%"=> SITE_URL.'content/'.$page['pageSlug'],"%LI_VALUE%"=> $page['pageTitle_'.$this->lId]));
		}
		$menu .= get_view(DIR_TMPL.'footer-menu-li-nct.tpl.php',array("%LI_URL%"=> 'https://blog.consulthive.com/',"%LI_VALUE%"=> BLOGS));
		$menu .= get_view(DIR_TMPL.'footer-menu-li-nct.tpl.php',array("%LI_URL%"=> SITE_URL.'contact-us/',"%LI_VALUE%"=> CONTACTUS));


		return $menu;
	}

	/*
		this will return footer language drop down on every page
	*/
	public function get_lang_item(){
		$language_item ="";
		$languagelist = $this->db->select("tbl_language",array('*'),array("status"=>'a'))->results();
		$lang_item = "";

		foreach ($languagelist as $langData) {
			$id = $langData['id'];
			$languageName = filtering($langData['languageName']);

			if($this->sessRequestType == 'web'){
				$replace = array(
						'%OPT_VALUE%'=>$id,
						'%OPT_TEXT%'=>$languageName,
						'%EXTRA%'=>'',
						'%SELECTED%'=>($langData['id'] == $this->lId) ? 'selected' : NULL,
					);
				$lang_item .= get_view(DIR_TMPL . "option-nct.tpl.php",$replace);
			}else{
				/*app data*/
			}
		}
		return $lang_item;
	}

	/*
		this will return footer currency drop down on every page
	*/
	public function get_currency_item(){
		$currency_item ="";
		$currencyList = $this->db->select("tbl_currency",array('*'),array("isActive"=>'y'))->results();
		$currency_item = "";
		foreach ($currencyList as $currencyData) {
			$id = $currencyData['id'];
			$currencyCode = $currencyData['currencyCode'];
			if($this->sessRequestType == 'web'){

				$replace = array(
						'%OPT_VALUE%'=>$id,
						'%OPT_TEXT%'=>$currencyCode,
						'%EXTRA%'=>'',
						'%SELECTED%'=>($id == $this->cId) ? 'selected' : NULL,
					);
				$currency_item .= get_view(DIR_TMPL . "option-nct.tpl.php",$replace);
			}else{
				/*app data*/
			}
		}
		return $currency_item;
	}

	/*
		this will return category options
	*/
	public function getCategoryList($catId = 0) {
		$cateHtml = "";
		$getCat =  $this->db->select("tbl_categories",array('*'),array('isActive'=>'y'));
		if($this->sessRequestType == 'web'){

			$replace = array(
							'%OPT_VALUE%'=> "",
							'%OPT_TEXT%'=> CATEGORY,
							'%EXTRA%'=>'',
							'%SELECTED%'=>'',
						);
			$cateHtml .= get_view(DIR_TMPL . "/option-nct.tpl.php",$replace);

		}
		if($getCat->affectedRows() > 0){
			$getCatResult = $getCat->results();
			foreach ($getCatResult as $key => $catData) {
				$id = $catData['id'];
				$cateName = filtering($catData['cateName_'.$this->lId]);
				$cateSlug = filtering($catData['slug']);
				if($this->sessRequestType == 'web'){
					$replace = array(
							'%OPT_VALUE%'=>$cateSlug,
							'%OPT_TEXT%'=>$cateName,
							'%EXTRA%'=>'data-id = "'.$id.'"',
							'%SELECTED%'=>($id == $catId) ? 'selected' : NULL,
						);
					$cateHtml .= get_view(DIR_TMPL . "option-nct.tpl.php",$replace);
				}
			}
		}
		return $cateHtml;
	}

	/*
		this will return sub category options
	*/
	public function getSubCategoryList($catId = 0 , $subCatId = 0) {
		$subCateHtml = "";

		$catWhr = array();
		$catWhr['categoryId'] = $catId;
		$catWhr['isActive'] = 'y';
		$getSubCat =  $this->db->select("tbl_subcategories",array('*'),$catWhr);
		if($this->sessRequestType == 'web'){
			$replace = array(
							'%OPT_VALUE%'=> "",
							'%OPT_TEXT%'=> SUB_CATEGORY,
							'%EXTRA%'=>'',
							'%SELECTED%'=>'',
						);
			$subCateHtml .= get_view(DIR_TMPL . "/option-nct.tpl.php",$replace);
		}
		if($getSubCat->affectedRows() > 0){
			$getSubCatResult = $getSubCat->results();
			foreach ($getSubCatResult as $key => $catSubData) {
				$id = $catSubData['id'];
				$subCategoryName = filtering($catSubData['subCategoryName_'.$this->lId]);
				$subCateSlug = filtering($catSubData['slug']);
				if($this->sessRequestType == 'web'){
					$replace = array(
							'%OPT_VALUE%'=>$subCateSlug,
							'%OPT_TEXT%'=> wordwrap($subCategoryName,5,"<br>\n"),
							'%EXTRA%'=>'data-id = "'.$id.'"',
							'%SELECTED%'=>($id == $subCatId) ? 'selected' : NULL,
						);
					$subCateHtml .= get_view(DIR_TMPL . "option-nct.tpl.php",$replace);
				}else{
					/*app data*/
				}
			}
		}
		return $subCateHtml;
	}

	/*
		this will return slider content
	*/
	public function getSlider() {
		$sliderHtml = "";
		$bannerDetail = $this->db->pdoQuery("SELECT * FROM tbl_banner")->result();
		$bannerUrl = checkImage($bannerDetail['file'],1);
		$video_content = "";

		$title = $bannerDetail['title_'.$this->lId];

		if($this->sessRequestType == 'web'){
			if($bannerDetail['file_type'] == 'video'){
				$video_content = get_view(DIR_TMPL . "/".$this->module."/video-container-nct.tpl.php",array('%BANNER_URL%' => $bannerUrl));
			}
			$replace = array(
				'%BANNER_TITLE%' => filtering($title),
				'%BANNER_URL%' => $bannerUrl,
				'%VIDEO_CONTENT%' => $video_content,
				'%CATEGORY_LIST%' => $this->getCategoryList(),
				'%SUB_CATEGORY_LIST%' => $this->getSubCategoryList(),
				'%FOOTER_LOGO%'=> $this->getFooterLogo(),
				'%TOP_SEARCH_LIST%'=> $this->getTopSearchCategory(),
				);

			$sliderHtml = get_view(DIR_TMPL . $this->module . "/slider-nct.tpl.php",$replace);
		}else{
			/*app data*/
		}
		return $sliderHtml;
	}

	/*
		this will return top search category
	*/
	public function getTopSearchCategory(){
		$get_top_search_html = "";
		$getList = $this->db->pdoQuery("SELECT COUNT(tsc.catId) AS totCat, c.cateName_".$this->lId." AS cateName, c.slug FROM tbl_top_searches AS tsc INNER JOIN tbl_categories AS c ON c.id = tsc.catId WHERE c.isActive = 'y' GROUP BY tsc.catId ORDER BY totCat DESC LIMIT 0,6")->results();
		foreach ($getList as $key => $topValue) {
			$slug = filtering($topValue['slug']);
			$cateName = filtering(ucwords($topValue['cateName']));
			$url = SITE_URL.'search-services/?category='.$slug;
			if($this->sessRequestType == 'web'){
				$replace = array('%TOP_SEARCH_URL%'=>$url,'%TOP_SEARCH_CATEGORY%'=>$cateName);
				$get_top_search_html .= get_view(DIR_TMPL . $this->module . "/top-search-category-nct.tpl.php",$replace);
			}else{
				/*app data*/
			}

		}
		return $get_top_search_html;
	}

	/*
		this will update currency of user
	*/
	public function changeCurrency($arr =array()){
		if($this->sessUserId > 0){
			$this->db->pdoQuery("UPDATE tbl_users SET defCurrency = ? WHERE id = ?",array($arr['currency'],$this->sessUserId));
		}
		$_SESSION["cId"] = $arr["currency"];
		return true;
	}

	/*
		this will update language of user
	*/
	public function changeLanguage($arr =array()){
		if($this->sessUserId > 0){
			$this->db->pdoQuery("UPDATE tbl_users SET defLanguage = ? WHERE id = ?",array($arr['language'],$this->sessUserId));
		}
		$_SESSION["lId"] = $arr["language"];
		return true;
	}

	/*
		this will return puplar category on home page
	*/
	public function getPopularCategory(){
		$popular_category_html = NULL;

		$popCat = $this->db->select('tbl_categories',array('*'),array('isActive'=>'y','isPopular'=>'y') , '  LIMIT 0,8')->results();
		foreach ($popCat as $key => $popCatResult) {

			$cateName = filtering($popCatResult['cateName_'.$this->lId]);
			$slug = filtering($popCatResult['slug']);
			$className = filtering($popCatResult['className']);
			$id = filtering($popCatResult['id']);

			$totSubCat = $this->db->pdoQuery("SELECT id FROM tbl_subcategories WHERE isActive = ? AND categoryId = ?",array('y',$id))->affectedRows();
			if($this->sessRequestType == 'web'){

				$replace = array('%CATEGORY_URL%'=>SITE_URL.'search-services/?category='.$slug,
								 '%CATEGORY_CLASS%' => $className,
								 '%CATEGORY_NAME%' => ucwords($cateName),
								 '%SUB_CATE_COUNT%' => $totSubCat);

				$popular_category_html .= get_view(DIR_TMPL . $this->module . "/popular-category-nct.tpl.php",$replace);
			}else{
				/*app data*/
			}
		}
		return $popular_category_html;
	}

	/*
		this will return tredning collection on home page
	*/
	public function getTrendingCollections(){

		$trending_collection_html = NULL;
		$trendColl = $this->db->select('tbl_trending_collections',array('*'),array('isActive'=>'y') , '  LIMIT 0,4')->results();
		foreach ($trendColl as $key => $trendCollResult) {

			$trendName = filtering($trendCollResult['name_'.$this->lId]);
			$slug = filtering($trendCollResult['slug']);
			$trendImage = checkImage($trendCollResult['image'],5);
			$id = filtering($trendCollResult['id']);

			$totService = $this->db->pdoQuery("SELECT id FROM tbl_trending_collections_services WHERE  trendingId = ?",array($id))->affectedRows();
			if($this->sessRequestType == 'web'){

				$replace = array('%TRENDING_URL%'=>SITE_URL.'trending-details/'.$slug,
								 '%TRENDING_IMAGE%' => $trendImage,
								 '%TRENDING_NAME%' => ucwords($trendName),
								 '%TOTAL_SERVICE%' => $totService);
				$trending_collection_html .= get_view(DIR_TMPL . $this->module . "/trending-collection-nct.tpl.php",$replace);
			}else{
				/*app data*/
			}
		}
		return $trending_collection_html;
	}

	/*
		this will subscribe user for newsletter
	*/
	public function subscribeNewsletter($request = array()){
		try{
			extract($_POST);
			$email=isset($email)?$email:'';
			$date =  date('Y-m-d H:i:s');

			$ip = get_ip_address();

			if($email != ''){
				$isUser = $this->db->select("tbl_users",array("*"),array("email"=>$email));
				if($isUser->affectedRows() > 0){
					$getEmail = $isUser->result();
					$isExist = $this->db->select("tbl_subscribers",array("*"),array("userId"=>$getEmail['id']))->affectedRows();
					if($isExist <= 0)
					{
						$insertarray = array("userId"=>$getEmail['id'],"isActive"=>'y',"ipAddress"=>$ip,"subscribedOn"=>$date);
						$insert_id   = $this->db->insert('tbl_subscribers',$insertarray)->getLastInsertId();
						/*$msgType     = $_SESSION["msgType"] = disMessage(array('type'=>'suc','var'=>MSG_SUBSCRIBE_SUC));*/
						$returnResponse = array(
							'redirectLink' 	=> SITE_URL,
							'status'		=> true,
							'message'   	=> MSG_SUBSCRIBE_SUC,
							'data'  		=> array());
						return $returnResponse;
					}else{
						throw new Exception(MSG_ALREADY_SUB);
					}
				}else{
					throw new Exception(MSG_PLEASE_REGISTER_WITH_THIS_EMAIL);
				}
			}else{
				throw new Exception(MSG_FILL_ALL_VALUE);
			}
		}
		catch(Exception $e){
			$returnResponse = array(
				'redirectLink' 	=> SITE_URL,
				'status'		=> false,
				'message'   	=> $e->getMessage(),
				'data'  		=> array());
			return $returnResponse;
		}
	}

	/*
		this will return featured services on home page
	*/
	public function getFeaturedServices(){
		$featured_service_html = NULL;
		$list = $this->db->pdoQuery("SELECT s.*,u.userName,u.profileImage,u.userLevel,u.slug as user_slug FROM tbl_services AS s INNER JOIN tbl_users AS u ON u.id = s.userId   WHERE s.status = 'a' AND s.isActive = 'y' AND s.isFeatured = 'y' AND u.isActive = 'y'  LIMIT 0,10")->results();

		foreach ($list as $key => $serviceValue) {
			$sId = $serviceValue['id'];
			$title = filtering(ucwords($serviceValue['title']));
			$slug = filtering($serviceValue['slug']);
			$userId = filtering($serviceValue['userId']);
			$userName = filtering($serviceValue['userName']);
			$user_slug = filtering($serviceValue['user_slug']);
			$profileImage = checkImage($serviceValue['profileImage'],9,$userId);

			$serviceImg = $this->db->pdoQuery("SELECT fileName FROM tbl_service_gallery WHERE serviceId = ? AND fileType = ?",array($sId,'i'))->result();

			$sImg = checkImage($serviceImg['fileName'],8,$sId);

			$serviceRating = $this->db->pdoQuery("SELECT AVG(r.rating) AS avgRating,COUNT(o.id) AS totalRating FROM tbl_orders AS o INNER JOIN tbl_reviews AS r ON r.orderId = o.id WHERE o.entityId = ? AND o.orderType = 's'  AND o.status = 'c'",array($sId))->result();

			$avgRating = $serviceRating['avgRating'];
			$totalRating = $serviceRating['totalRating'];

			$servicePrice = $this->db->pdoQuery("SELECT MIN(price) AS servicePrice FROM tbl_service_packages WHERE serviceId = ?",array($sId))->result();
			$servicePrice = $servicePrice['servicePrice'];

			$favId = getTableValue('tbl_favourites','id',array('serviceId'=>$sId,'userId'=>$this->sessUserId));
			$favClass = 'icon-like';
			if($favId > 0){
				$favClass = 'icon-liked';
			}

			$user_level_class = ($serviceValue['userLevel'] == 'b' ? 'begginer-tag' : ($serviceValue['userLevel'] == 'i' ? 'intermediate-tag' : 'expert-tag'));
			$user_level = ($serviceValue['userLevel'] == 'b' ? BEGINNER : ($serviceValue['userLevel'] == 'i' ? INTERMEDIATE : EXPERT));

			$totalSales = $this->db->pdoQuery("SELECT * FROM tbl_orders WHERE status NOT IN ('e','ca') AND orderType = 's' AND entityId = ? ",array($sId))->affectedRows();

			$isSocialVerified =  isSocialVerified($userId);
			$isUserConsultHiveCertified =  isUserConsultHiveCertified($userId);

			if($this->sessRequestType == 'web'){
				/*multi currency change*/
	            $servicePrice = exchange($servicePrice,DEFAULT_CURRENCY_CODE,$this->cCode,$sId,'s');
	            /*multi currency change*/
	            $credentials_verfiied_tag = ($isSocialVerified == 'y' ? get_view(DIR_TMPL ."/credentials-verified-nct.tpl.php",array()) : '');
				$consultHive_certified_tag = ($isUserConsultHiveCertified == 'y' ? get_view(DIR_TMPL ."/consult-hive-certified-nct.tpl.php",array()) : '');

				$feature_tag = get_view(DIR_TMPL ."/feature-tag-nct.tpl.php",array());
				$replace = array('%SERVICE_IMAGE%'=>$sImg,
								 '%STAR_RATTING%'=>$avgRating,
								 '%TOTAL_REVIEW%'=>$totalRating,
								 '%SERVICE_URL%'=>SITE_URL.'service-details/'.$slug.'/',
								 '%SERVICE_TITLE%'=>$title,
								 '%SELLER_IMAGE%'=>$profileImage,
								 '%SELLER_URL%'=>SITE_URL.'profile/'.$user_slug.'/',
								 '%SELLER_NAME%'=>$userName,
								 '%TOTAL_SALES%'=>$totalSales,
								 '%SERVICE_PRICE%'=>$servicePrice,
								 '%SID%'=>$sId,
								 '%FAV_CLASS%'=> $favClass,
								 '%FEATURE_TAGS%'		=>$feature_tag,
								 '%USER_LEVEL_CLASS%'	=>$user_level_class,
								 '%USER_LEVEL%'			=>$user_level,
								 '%CREDENTIALS_VERIFIED%'=> $credentials_verfiied_tag,
								 '%CONSULT_HIVE_CERTIFIED%'=>$consultHive_certified_tag,
								);
				$featured_service_html .= get_view(DIR_TMPL . $this->module . "/featured-services-nct.tpl.php",$replace);
			}else{
				/*app data*/
			}
		}
		return $featured_service_html;
	}

	/*
		this will return top rated seller on home page
	*/
	public function getTopRatedSeller(){
		$top_rated_seller_html = NULL;
		$sellerlList = $this->db->pdoQuery("SELECT AVG(r.rating) AS avgRating,r.userTo,u.userName,u.aboutMe,u.profileImage FROM tbl_reviews AS r INNER JOIN tbl_users AS u ON u.id = r.userTo WHERE u.isActive = 'y' GROUP BY u.id ORDER BY avgRating DESC LIMIT 0,4")->results();
		foreach ($sellerlList as $key => $sellerValue) {
			$avgRating = $sellerValue['avgRating'];
			$userName = filtering($sellerValue['userName']);
			$aboutMe = filtering($sellerValue['aboutMe'],'text');
			$userId = $sellerValue['userTo'];
			$profileImage = checkImage($sellerValue['profileImage'],9,$userId);
			$serviceCount = $this->db->pdoQuery("SELECT * FROM tbl_services AS s WHERE userId = ? AND  s.status = 'a' AND s.isActive = 'y' ",array($userId))->affectedRows();
			if($this->sessRequestType == 'web'){

				$replace = array(
								 '%STAR_RATTING%'=>$avgRating,
								 '%TOTAL_SERVICES%'=>$serviceCount,
								 '%USER_IMAGE%'=>$profileImage,
								 '%USER_NAME%'=>$userName,
								 '%ABOUT_ME%'=>myTruncate($aboutMe,150),
								);
				$top_rated_seller_html .= get_view(DIR_TMPL . $this->module . "/top-rated-seller-nct.tpl.php",$replace);
			}else{
				/*app data*/
			}
		}
		return $top_rated_seller_html;
	}

	/*
		this will return featured services on home page
	*/
	public function getRecommendationSection(){
		$single_recommendation_html = $recommendation_section_html = NULL;


		$list = $this->db->pdoQuery("SELECT o.*,s.*,u.slug AS user_slug,u.userName,u.profileImage,u.userLevel
			FROM tbl_orders AS o
			INNER JOIN tbl_services AS s ON s.id = o.entityId
			INNER JOIN tbl_users AS u ON u.id = s.userId
			WHERE s.status = 'a' AND s.isActive = 'y' AND o.orderType = 's' AND u.isActive = 'y' AND o.userId = ? GROUP BY o.entityId  ORDER BY o.id DESC LIMIT 0,10",array($this->sessUserId))->results();



		foreach ($list as $key => $serviceValue) {
			$sId = $serviceValue['entityId'];
			$title = filtering(ucwords($serviceValue['title']));
			$slug = filtering($serviceValue['slug']);
			$isFeatured = filtering($serviceValue['isFeatured']);
			$userId = filtering($serviceValue['userId']);
			$userName = filtering($serviceValue['userName']);
			$profileImage = checkImage($serviceValue['profileImage'],9,$userId);
			$user_slug = filtering($serviceValue['user_slug']);

			$serviceImg = $this->db->pdoQuery("SELECT fileName FROM tbl_service_gallery WHERE serviceId = ? AND fileType = ?",array($sId,'i'))->result();

			$sImg = checkImage($serviceImg['fileName'],8,$sId);

			/*$serviceRating = $this->db->pdoQuery("SELECT AVG(rating) AS avgRating,COUNT(id) AS totalRating FROM tbl_reviews WHERE serviceId = ?",array($sId))->result();*/
			$serviceRating = $this->db->pdoQuery("SELECT AVG(r.rating) AS avgRating,COUNT(o.id) AS totalRating FROM tbl_orders AS o INNER JOIN tbl_reviews AS r ON r.orderId = o.id WHERE o.entityId = ? AND o.orderType = 's'  AND o.status = 'c'",array($sId))->result();

			$servicePrice = $this->db->pdoQuery("SELECT MIN(price) AS servicePrice FROM tbl_service_packages WHERE serviceId = ?",array($sId))->result();
			$servicePrice = $servicePrice['servicePrice'];

			$favId = getTableValue('tbl_favourites','id',array('serviceId'=>$sId,'userId'=>$this->sessUserId));
			$favClass = 'icon-like';
			if($favId > 0){
				$favClass = 'icon-liked';
			}
			$user_level = ($serviceValue['userLevel'] == 'b' ? SEARCH_SERVICES_PAGE_LBL_BEGINEER : ($serviceValue['userLevel'] == 'i' ? SEARCH_SERVICES_PAGE_LBL_INTER_MIDIATE : SEARCH_SERVICES_PAGE_LBL_EXPERT));
			$user_level_class = ($serviceValue['userLevel'] == 'b' ? 'begginer-tag' : ($serviceValue['userLevel'] == 'i' ? 'intermediate-tag' : 'expert-tag'));

			$totalSales = $this->db->pdoQuery("SELECT * FROM tbl_orders WHERE status NOT IN ('e','ca') AND orderType = 's' AND entityId = ? ",array($sId))->affectedRows();

			$isSocialVerified =  isSocialVerified($userId);
			$isUserConsultHiveCertified =  isUserConsultHiveCertified($userId);

			if($this->sessRequestType == 'web'){

				/*multi currency change*/
	            $servicePrice = exchange($servicePrice,DEFAULT_CURRENCY_CODE,$this->cCode,$sId,'s');
	            /*multi currency change*/
				$feature_tag = ($isFeatured == 'y' ? get_view(DIR_TMPL ."/feature-tag-nct.tpl.php",array()) : '');
				$credentials_verfiied_tag = ($isSocialVerified == 'y' ? get_view(DIR_TMPL ."/credentials-verified-nct.tpl.php",array()) : '');
				$consultHive_certified_tag = ($isUserConsultHiveCertified == 'y' ? get_view(DIR_TMPL ."/consult-hive-certified-nct.tpl.php",array()) : '');
				$replace = array('%SERVICE_IMAGE%'=>$sImg,
								 '%STAR_RATTING%'=>$serviceRating['avgRating'],
								 '%TOTAL_REVIEW%'=>$serviceRating['totalRating'],
								 '%SERVICE_URL%'=>SITE_URL.'service-details/'.$slug,
								 '%SERVICE_TITLE%'=>$title,
								 '%SELLER_IMAGE%'=>$profileImage,
								 '%SELLER_URL%'=>SITE_URL.'profile/'.$user_slug.'/',
								 '%SELLER_NAME%'=>$userName,
								 '%TOTAL_SALES%'=>$totalSales,
								 '%SERVICE_PRICE%'=>$servicePrice,
								 '%SID%'=>$sId,
								 '%FAV_CLASS%'=> $favClass,
								 '%FEATURE_TAGS%'		=>$feature_tag,
								 '%USER_LEVEL_CLASS%'	=>$user_level_class,
								 '%USER_LEVEL%'			=>$user_level,
								 '%CREDENTIALS_VERIFIED%'=> $credentials_verfiied_tag,
								 '%CONSULT_HIVE_CERTIFIED%'=>$consultHive_certified_tag,

								);
				$single_recommendation_html .= get_view(DIR_TMPL . $this->module . "/recommendation-single-nct.tpl.php",$replace);
			}else{

			}
		}
		$recommendationReplace = array('%RECOMMENDATIONS_SECTION%'=>$single_recommendation_html);
			$recommendation_section_html .= get_view(DIR_TMPL . $this->module . "/recommendation-section-nct.tpl.php",$recommendationReplace);

		return $recommendation_section_html;
	}

	/*
		this function manage favourite services
	*/
	public function manageFavourite($request = array()){
		extract($request);
		$userId = getTableValue('tbl_services','userId',array('id'=>$serviceId));
		if($userId == $this->sessUserId){
				$className = 'icon icon-like';
				$returnResponse = array(
						'redirectLink' 	=> CURRENT_PAGE_URL,
						'status'		=> false,
						'message'   	=> MSG_CANT_ADD_OWN_FAV,
						'data'  		=> array('className'=>$className));
				return $returnResponse;
				exit;
		}
		if($serviceId > 0 && $this->sessUserId > 0){

			$favId = getTableValue('tbl_favourites','id',array('serviceId'=>$serviceId,'userId'=>$this->sessUserId));

			if($favId > 0){

				$this->db->pdoQuery("DELETE FROM tbl_favourites WHERE id = ?",array($favId));
				$className = 'icon icon-like';
				$msg = MSG_REMOVE_FROM_FAV;
				$status = true;

			}else{

				$insArr['serviceId'] = $serviceId;
				$insArr['userId'] = $this->sessUserId;
				$insArr['ipAddress'] = get_ip_address();
				$insArr['createdDate'] = date('Y-m-d H:i:s');

				$this->db->insert('tbl_favourites',$insArr);

				$className = 'icon icon-liked';
				$msg = MSG_ADD_TO_FAV;
				$status = true;

			}
		}else{

			$className = 'icon icon-like';
			$msg = MSG_PLZ_LOGIN_FIRST;
			$status = false;

		}

		$returnResponse = array(
						'redirectLink' 	=> CURRENT_PAGE_URL,
						'status'		=> $status,
						'message'   	=> $msg,
						'data'  		=> array('className'=>$className));
		return $returnResponse;
		exit;
	}

	/*
		this function get list of buyer collection
	*/
	public function getCollectionSelections($serviceId){
		$msg = $get_collection_html= '';
		$buyerCollection= $this->db->pdoQuery("SELECT bt.id,bt.name,
        		( SELECT id FROM tbl_buyer_collections_services WHERE collectionId = bt.id AND serviceId = ? ) as count
                FROM tbl_buyer_collections AS bt
                WHERE isActive = ? AND userId = ? ",array($serviceId,'y',$this->sessUserId));
        if($buyerCollection->affectedRows() > 0){
            foreach ($buyerCollection->results() as $key => $value) {
                $selected = ($value['count'] > 0 ? 'selected' : '');
				if($this->sessRequestType == 'web'){

	                $replace = array(
	                    '%OPT_VALUE%'   =>$value['id'],
	                    '%EXTRA%'       =>'',
	                    '%SELECTED%'    =>$selected,
	                    '%OPT_TEXT%'    =>filtering($value['name'])
	                );
	                $get_collection_html .=  get_view(DIR_TMPL . "option-nct.tpl.php",$replace);
	            }else{

	            }
            }
        }
        return $get_collection_html;
	}

	/*
		this function get list of buyer collection form
	*/
	public function getBuyerCollectionList($request = array()){
		$content = $msg = $get_buyer_collection_html= '';
		extract($request);
		if($this->sessUserId > 0){
			$userId = getTableValue('tbl_services','userId',array('id'=>$serviceId));
			if($userId == $this->sessUserId){
					$returnResponse = array(
							'redirectLink' 	=> CURRENT_PAGE_URL,
							'status'		=> false,
							'message'   	=> MSG_CANT_ADD_OWN_SER,
							'data'  		=> array('content'=>$content));
					return $returnResponse;
					exit;
			}
			$countCollection= $this->db->pdoQuery("SELECT bt.id,bt.name,
	        		( SELECT id FROM tbl_buyer_collections_services WHERE collectionId = bt.id AND serviceId = ? ) as count
	                FROM tbl_buyer_collections AS bt
	                WHERE isActive = ? AND userId = ? ",array($serviceId,'y',$this->sessUserId))->affectedRows();
			if($countCollection > 0){
				if($serviceId > 0 && $this->sessUserId > 0){
					$title = getTableValue('tbl_services','title',array('id'=>$serviceId));
		            $status = true;
					if($this->sessRequestType == 'web'){
			             $replace = array(
				            '%COLLECTION_OPTION%'=>$this->getCollectionSelections($serviceId),

				            '%SERVICE_NAME%'=>filtering($title,'output'),

				            '%ID%'=>$serviceId
				        );
				        $get_buyer_collection_html = get_view(DIR_TMPL . "/add-remove-services-to-collections-nct.tpl.php",$replace);
				    }
			    }else{
			     	$status=false;
					$msg = MSG_PLZ_LOGIN_FIRST;
			    }
		        $returnResponse = array(
								'redirectLink' 	=> CURRENT_PAGE_URL,
								'status'		=> $status,
								'message'   	=> $msg,
								'data'  		=> array('content'=>$get_buyer_collection_html));
		    }else{
					$returnResponse = array(
							'redirectLink' 	=> CURRENT_PAGE_URL,
							'status'		=> false,
							'message'   	=> MSG_NO_COLLECTION,
							'data'  		=> array('content'=>$content));
					return $returnResponse;
					exit;
		    }
		}else{
			   $returnResponse = array(
								'redirectLink' 	=> CURRENT_PAGE_URL,
								'status'		=> false,
								'message'   	=> MSG_PLZ_LOGIN_FIRST,
								'data'  		=> array('content'=>$content));

		}
		return $returnResponse;
		exit;
	}

	/*
		this function buyer collection form
	*/
	public function submitBuyerCollection($request = array()){
		extract($request);
		if($serviceId > 0 && $this->sessUserId > 0){

			$collections = isset($collections) ? $collections : array();
			if(count($collections) <= 0){
				$this->db->delete('tbl_buyer_collections_services',array('serviceId'=>$serviceId));
				$status = true;
	            $msg =  MSG_SERVICE_REMOVE_FROM_COLLECTION;
			}
			else{
				$this->db->delete('tbl_buyer_collections_services',array('serviceId'=>$serviceId));
				foreach ($collections as $key => $value) {
						$date =  date('Y-m-d H:i:s');
						$this->db->insert('tbl_buyer_collections_services',array('serviceId'=>$serviceId,'collectionId'=>$value,'creadtedDate'=>$date));
				}
				$status = true;
	            $msg =  MSG_COLLECTION_UPDATED;
			}
		}else{
	     	$status=false;
			$msg = MSG_PLZ_LOGIN_FIRST;
	     }
		$returnResponse = array(
						'redirectLink' 	=> CURRENT_PAGE_URL,
						'status'		=> $status,
						'message'   	=> $msg,
						'data'  		=> array());
		return $returnResponse;
		exit;
	}

}

?>
