<?php
class AccountSettings {

	function __construct($contentArray=array()) {
		global $sessUserId,$db;
		foreach ($GLOBALS as $key => $values) {
			$this->$key = $values;

		}
		extract($contentArray);
		$this->module = $module;
		$this->sessUserId = $sessUserId;
		$this->db = $db;
	}

	public function getPageContent() {

		$tplUrl = DIR_TMPL . $this->module . "/" . $this->module . ".tpl.php";
		$socialContent = $this->getSocialContent();
		$accountContent = $this->getAccountContent();
		$securityContent = $this->getSecurityContent();
		$billingContent = $this->getBillingContent();
		$notificationContent = $this->getNotificationContent();
		$bankDetailContent = $this->getBankDetailContent();

		if($this->sessRequestType == 'web'){
			$replaceArr = array(
								"%SOCIAL_FORM%" => $socialContent,
								"%ACCOUNT_FORM%" => $accountContent,
								"%SECURITY_FORM%" => $securityContent,
								"%BILLING_FORM%" => $billingContent,
								"%NOTIFICATION_FORM%" => $notificationContent,
								"%BANK_DETAIL_FORM%" => $bankDetailContent,
								);
			$content = get_view($tplUrl,$replaceArr);
		}else{

		}
		return $content;
	}

	public function getSocialContent(){
		$social_link_html = NULL;
		$fbVerify = $fbCursorClass =  $gpVerify =  $gpCursorClass = $liVerify =  $liCursorClass = "";
		$socialtplUrl = DIR_TMPL . $this->module . "/user-social-link-nct.tpl.php";
		$user = $this->db->select("tbl_users",array('fbLink','gpLink','linkedinLink','stackLink','dribbleLink,fbCode','googleCode','linkdinCode'),array('id'=>$this->sessUserId))->result();

		$fblink = isset($user['fbLink']) ? $user['fbLink'] : "";
		$gplink = isset($user['gpLink']) ? $user['gpLink'] : "";
		$linkedinlink = isset($user['linkedinLink']) ? $user['linkedinLink'] : "";
		$stacklink = isset($user['stackLink']) ? $user['stackLink'] : "";
		$dribblelink = isset($user['dribbleLink']) ? $user['dribbleLink'] : "";
		$fbCode = isset($user['fbCode']) ? $user['fbCode'] : "";
		$googleCode = isset($user['googleCode']) ? $user['googleCode'] : "";
		$linkdinCode = isset($user['linkdinCode']) ? $user['linkdinCode'] : "";
		$fbVerifyId = 'fb_login';
		$gpVerifyId = 'google_login';
		$liVerifyId = 'li_login';
		if($fbCode != ""){
			$fbVerify = get_view(DIR_TMPL . $this->module . "/social-verified-check-nct.tpl.php");
			$fbCursorClass = 'defaultCurser';
			$fbVerifyId = '';
		}
		if($googleCode != ""){
			$gpVerify = get_view(DIR_TMPL . $this->module . "/social-verified-check-nct.tpl.php");
			$gpCursorClass = 'defaultCurser';
			$gpVerifyId = '';

		}
		if($linkdinCode != ""){
			$liVerify = get_view(DIR_TMPL . $this->module . "/social-verified-check-nct.tpl.php");
			$liCursorClass = 'defaultCurser';
			$liVerifyId = '';
		}
		if($this->sessRequestType = 'web'){
			$replaceArr = array(
								"%FB_LINK%"         => $fblink,
								"%GP_LINK%"         => $gplink,
								"%LI_LINK%"         => $linkedinlink,
								"%SO_LINK%"         => $stacklink,
								"%DL_LINK%"         => $dribblelink,
								"%FB_VERIFY%"       => $fbVerify,
								"%FB_CURSOR_CLASS%" => $fbCursorClass,
								"%FB_VERIFY_ID%" => $fbVerifyId,
								"%GP_VERIFY%"       => $gpVerify,
								"%GP_VERIFY_ID%" => $gpVerifyId,
								"%GP_CURSOR_CLASS%" => $gpCursorClass,
								"%LI_VERIFY%"       => $liVerify,
								"%LI_VERIFY_ID%" => $liVerifyId,
								"%LI_CURSOR_CLASS%" => $liCursorClass,
								);
			$social_link_html = get_view($socialtplUrl,$replaceArr);
		}else{
			$social_link_html[] = array(
										'fbLink'=>$fblink,
										'gpLink'=>$gplink,
										'linkedinlink'=>$linkedinlink,
										'stackLink'=>$stacklink,
										'dribbleLink'=>$dribblelink,
									);
		}
		return $social_link_html;
	}

	public function getAccountContent(){
		$account_html = NULL;
		$accounttplUrl = DIR_TMPL . $this->module . "/account-detail-nct.tpl.php";
		$email = getTableValue('tbl_users','email',array('id'=>$this->sessUserId));
		$reasoneList = $this->getDeactivateReasoneList();
		if($this->sessRequestType == 'web'){
			$replaceArr = array(
								"%EMAIL%" => $this->hideEmail($email),
								'%REASON_LIST%'=>$reasoneList,
								);
			$account_html = get_view($accounttplUrl,$replaceArr);
		}
		return $account_html;
	}

	public function getDeactivateReasoneList() {
		$reasonHtml = "";
		if($this->sessRequestType == 'web'){
			$replace = array(
							'%OPT_VALUE%'=> "",
							'%OPT_TEXT%'=> CHOOSE_A_REASON,
							'%EXTRA%'=>'',
							'%SELECTED%'=>'',
						);
			$reasonHtml .= get_view(DIR_TMPL . "/option-nct.tpl.php",$replace);
		}
		$getReason = $this->db->select("tbl_deactive_account_reason",array('*'),array('isActive'=>'y'));

			$getReasonResult = $getReason->results();
			foreach ($getReasonResult as $key => $reasonData) {
				if($this->sessRequestType == 'web'){
					$replace = array(
							'%OPT_VALUE%'=>$reasonData['id'],
							'%OPT_TEXT%'=> $reasonData['reason'],
							'%EXTRA%'=>NULL,
							'%SELECTED%'=> NULL,
						);
					$reasonHtml .= get_view(DIR_TMPL . "option-nct.tpl.php",$replace);
				}else{

				}
			}

		return $reasonHtml;
	}

	public function getBillingContent(){
		$billing_html = NULL;
		$billingtplUrl = DIR_TMPL . $this->module . "/billing-detail-nct.tpl.php";
		$billingQry = $this->db->select('tbl_user_billing_detail',array('*'),array('userId'=>$this->sessUserId,'isActive'=>'y'))->result();
		$countryId = $billingQry['countryId'];
		$businessName = filtering($billingQry['businessName']);
		$address1 = filtering($billingQry['address1']);
		$address2 = filtering($billingQry['address2']);
		$vatId = filtering($billingQry['vatId']);
		$requireInvoice = filtering($billingQry['requireInvoice']);
		$requireInvoice = $requireInvoice == 'y' ? "checked" : NULL;
		$countryList = $this->getCountryList($countryId);
		if($this->sessRequestType == 'web'){
			$replaceArr = array(
								'%CHECKED_REQUIRE_INVOICE%' => $requireInvoice,
								'%BUSINESS_NAME%' => $businessName,
								'%ADDRESS_1%' => $address1,
								'%ADDRESS_2%' => $address2,
								'%VAT_ID%' => $vatId,
								'%COUNTRY_LIST%'=>$countryList,
								);
			$billing_html = get_view($billingtplUrl,$replaceArr);
		}
		return $billing_html;
	}

	public function getCountryList($cId = 1){
		$countryHtml = "";
		$getCountry =  $this->db->select("tbl_country",array('*'),array('isActive'=>'y'));

		if($getCountry->affectedRows() > 0){
			$getCountryResult = $getCountry->results();
			foreach ($getCountryResult as $key => $countryData) {
				$id = $countryData['CountryId'];
				$countryName = filtering($countryData['countryName_'.$this->lId]);
				$replace = array(
						'%OPT_VALUE%'=>$id,
						'%OPT_TEXT%'=>$countryName,
						'%SELECTED%'=>($id == $cId) ? 'selected' : NULL,
					);
				$countryHtml .= get_view(DIR_TMPL . "option-nct.tpl.php",$replace);
			}
		}
		return $countryHtml;
	}

	public function getNotificationContent(){
		$notificationList = $notification_html = NULL;
		$notificationtplUrl = DIR_TMPL . $this->module . "/notification-setting-nct.tpl.php";
		$notificationQry = $this->db->select('tbl_notifications',array('*'))->results();

		foreach ($notificationQry as $key => $value) {
			$notificationTitle = filtering($value['text_'.$this->lId]);
			$notiId = filtering($value['id']);
			$isChecked = getTableValue('tbl_users_notifications','id',array('notifyId'=>$notiId,'userId'=>$this->sessUserId));
			$checked = "";

			if($isChecked <= 0){
				$checked = "checked";
			}
			if($this->sessRequestType == 'web'){
				$innerArr = array(
								'%NOTIFICATION_TITLE%' => $notificationTitle,
								'%NOTIFICATION_ID%' => $notiId,
								'%CHECKED%' => $checked,
								);
				$notificationList .= get_view(DIR_TMPL.$this->module.'/single-notification-nct.tpl.php',$innerArr);
			}
		}
		if($this->sessRequestType == 'web'){
			$replaceArr = array(
								'%NOTIFICATION_LIST%' => $notificationList,
								);
			$notification_html = get_view($notificationtplUrl,$replaceArr);
		}
		return $notification_html;
	}

	public function getSecurityContent(){
		$security_html = NULL;
		$securitytplUrl = DIR_TMPL . $this->module . "/security-content-nct.tpl.php";
		$answer = getTableValue('tbl_user_security_question_answer','answer',array('userId'=>$this->sessUserId));
		$questionList = $this->getSecurityQuestionList();
		$answer = filtering($answer);
		if($this->sessRequestType == 'web'){
			$replaceArr = array(
								"%ANSWER%" => $answer,
								'%QUESTION_LIST%'=>$questionList,
								);
			$security_html = get_view($securitytplUrl,$replaceArr);
		}
		return $security_html;
	}

	public function getSecurityQuestionList() {
		$questionHtml = "";
		if($this->sessRequestType == 'web'){
			$replace = array(
							'%OPT_VALUE%'=> "",
							'%OPT_TEXT%'=> SELECT_QUESTION,
							'%EXTRA%'=>'',
							'%SELECTED%'=>'',
						);
			$questionHtml .= get_view(DIR_TMPL . "/option-nct.tpl.php",$replace);
		}
		$questionId = getTableValue('tbl_user_security_question_answer','questionId',array('userId'=>$this->sessUserId));
		$getQuestion = $this->db->select("tbl_security_questions",array('*'),array('isActive'=>'y'));

			$getQuestionResult = $getQuestion->results();
			foreach ($getQuestionResult as $key => $questionData) {
				$id = $questionData['id'];
				$question = filtering($questionData['question_'.$this->lId]);
				if($this->sessRequestType == 'web'){
					$replace = array(
							'%OPT_VALUE%'=>$id,
							'%OPT_TEXT%'=> $question,
							'%EXTRA%'=>NULL,
							'%SELECTED%'=> ($id == $questionId ? "selected" : NULL),
						);
					$questionHtml .= get_view(DIR_TMPL . "option-nct.tpl.php",$replace);
				}else{

				}
			}

		return $questionHtml;
	}

	public function hideEmail($email){
		$start = $end = "";
		$prop=2;
		$domain = substr(strrchr($email, "@"), 1);

		$mailname=str_replace($domain,'',$email);

		$name_l=strlen($mailname);
		$domain_l=strlen($domain);
		for($i=0;$i<=$name_l/$prop-1;$i++)
		{
		$start.='*';
		}

		for($i=0;$i<=$domain_l/$prop-1;$i++)
		{
		$end.='*';
		}

		return substr_replace($mailname, $start, 2, $name_l/$prop).substr_replace($domain, $end, 2, $domain_l/$prop);
	}

	public function getBankDetailContent(){
		$bank_html = NULL;
		$banktplUrl = DIR_TMPL . $this->module . "/bank-detail-nct.tpl.php";
		$bankQry = $this->db->select('tbl_users',array('paypalEmail','bankName','bankAccountNumber','bankIfscCode','bankAccountName'),array('id'=>$this->sessUserId,'isActive'=>'y'))->result();
		$bankName = filtering($bankQry['bankName']);
		$bankAccountNumber = filtering($bankQry['bankAccountNumber']);
		$bankIfscCode = filtering($bankQry['bankIfscCode']);
		$bankAccountName = filtering($bankQry['bankAccountName']);
		$paypalEmail = filtering($bankQry['paypalEmail']);
		if($this->sessRequestType == 'web'){
			$replaceArr = array(
								'%BANK_NAME%' => $bankName,
								'%BANK_AC_NO%' => $bankAccountNumber,
								'%BANK_IFSC_CODE%' => $bankIfscCode,
								'%BANK_AC_HOLDER_NAME%' => $bankAccountName,
								'%PAYMENT_GATEWAY_ID%'=>$paypalEmail,
								);
			$bank_html = get_view($banktplUrl,$replaceArr);
		}
		return $bank_html;
	}

	public function submitSocialDetail($request = array()){
		extract($request);
		unset($request['action']);
		foreach ($request as $key => $value) {
			$updateArr[$key] = filtering($value);
		}
		$this->db->update('tbl_users',$updateArr,array('id'=>$this->sessUserId));

		$returnResponse = array(
								'redirectLink' => '',
								'status'       => true,
								'type'         => 'success',
								'message'      => MSG_DETAIL_SUBMITTED_SUC,
								'data'         => array()
							);
		return $returnResponse;
	}

	public function submitDeactivateAccount($request = array()){
		extract($request);
		if($reason > 0){
			$email = getTableValue('tbl_users','email',array('id'=>$this->sessUserId));
			$reasonTitle = getTableValue('tbl_deactive_account_reason','reason',array('id'=>$reason));
			$updateArr['email'] = $email.'_'.$this->sessUserId;
			$updateArr['isActive'] = 'd';
			$updateArr['deactivateReason'] = filtering(issetor($reasonTitle),'input');
			$this->db->update('tbl_users',$updateArr,array('id'=>$this->sessUserId));

			$msgType = $_SESSION["msgType"] = disMessage(array('type'=>'err','var'=>MSG_ACCOUNT_DEACTIVATED_SUCCESSFULLY));

			unset($_SESSION["user_id"]);
			unset($_SESSION["sessUserName"]);

			$returnResponse = array(
									'redirectLink'  => SITE_URL,
									'status'        => true,
									'type'      => 'success',
									'message'       => MSG_ACCOUNT_DEACTIVATED_SUCCESSFULLY,
									'data'          => array()
								);
		}else{

			$returnResponse = array(
									'redirectLink'  => '',
									'status'        => false,
									'type'      => 'error',
									'message'       => MSG_FILL_ALL_VALUE,
									'data'          => array()
								);
		}
		return $returnResponse;
	}

	public function submitSecurityQuestion($request = array()){
		extract($request);
		$securityQry = $this->db->select("tbl_user_security_question_answer",array('*'),array('userId'=>$this->sessUserId));
		$arr['questionId'] = $questionId;
		$arr['answer'] = filtering(issetor($answer),'input');
		$arr['userId'] = $this->sessUserId;
		$arr['ipAddress'] = get_ip_address();

		if($securityQry->affectedRows() > 0) {
			$security = $securityQry->result();
			$this->db->update('tbl_user_security_question_answer',$arr,array('id'=>$security['id']));
		}else{

			$date =  date('Y-m-d H:i:s');
			$arr['createdDate'] = $date;
			$this->db->insert('tbl_user_security_question_answer',$arr);
		}

		$returnResponse = array(
								'redirectLink'  => '',
								'status'        => true,
								'type'      => 'success',
								'message'       => MSG_SECURITY_ANSWER_SUBMITTED_SUC,
								'data'          => array()
							);
		return $returnResponse;
	}

	public function submitBillingDetail($request = array()){
		extract($request);
		$billingQry = $this->db->select("tbl_user_billing_detail",array('*'),array('userId'=>$this->sessUserId));
		$arr['countryId'] = $countryId;
		$arr['businessName'] = filtering(issetor($businessName),'input');
		$arr['address1'] = filtering(issetor($address1),'input');
		$arr['address2'] = filtering(issetor($address2),'input');
		$arr['vatId'] = filtering(issetor($vatId),'input');
		$arr['requireInvoice'] = filtering(issetor($requireInvoice,'n'),'input');
		$arr['userId'] = $this->sessUserId;
		$arr['ipAddress'] = get_ip_address();


		if($billingQry->affectedRows() > 0) {
			$billing = $billingQry->result();
			$this->db->update('tbl_user_billing_detail',$arr,array('id'=>$billing['id']));
		}else{

			$date =  date('Y-m-d H:i:s');
			$arr['createdDate'] = $date;
			$this->db->insert('tbl_user_billing_detail',$arr);
		}

		$returnResponse = array(
								'redirectLink'  => '',
								'status'        => true,
								'type'      => 'success',
								'message'       => MSG_BILLING_DETAIL_SUBMITTED_SUC,
								'data'          => array()
							);
		return $returnResponse;
	}

	public function submitNotification($request = array()){
		extract($request);
		$notificationQry = $this->db->select('tbl_notifications',array('*'))->results();
		$getId = getTableValue("tbl_users_notifications",'id',array('userId'=>$this->sessUserId,'notifyId'=>$notification));
		if($getId > 0){
			$this->db->delete('tbl_users_notifications',array('id' => $getId));
		}else{
			$instArr['notifyId'] = $notification;
			$instArr['userId'] = $this->sessUserId;
			$instArr['creadtedDate'] = date('Y-m-d H:i:s');
			$this->db->insert('tbl_users_notifications',$instArr);
		}
		/*$this->db->delete('tbl_users_notifications',array('userId' => $this->sessUserId));
		foreach ($notificationQry as $key => $notifyValue) {
			if(!in_array($notifyValue['id'], $request['notification'])){
				$instArr['notifyId'] = $notifyValue['id'];
				$instArr['userId'] = $this->sessUserId;
				$instArr['creadtedDate'] = date('Y-m-d H:i:s');
				$this->db->insert('tbl_users_notifications',$instArr);
			}
		}*/
		/*MSG_NOTIFICATION_UPDATED_SUC*/
		$returnResponse = array(
								'redirectLink'  => '',
								'status'        => true,
								'type'      => 'success',
								'message'       => '',
								'data'          => array()
							);
		return $returnResponse;
	}

	public function submitBankDetails($request = array()){
		extract($request);

		$arr['bankName'] = filtering(issetor($bankName),'input');
		$arr['bankAccountName'] = filtering(issetor($bankAccountName),'input');
		$arr['bankAccountNumber'] = filtering(issetor($bankAccountNumber),'input');
		$arr['bankIfscCode'] = filtering(issetor($bankIfscCode),'input');
		$arr['paypalEmail'] = filtering(issetor($paypalEmail),'input');

		$this->db->update('tbl_users',$arr,array('id'=>$this->sessUserId));

		$returnResponse = array(
								'redirectLink'  => '',
								'status'        => true,
								'type'      => 'success',
								'message'       => MSG_BANK_DETAIL_SUBMITTED_SUC,
								'data'          => array()
							);
		return $returnResponse;
	}
}

?>
