var msgUrl = SITE_URL+'message-room'
$(document).ready(function() {
	if(defaultReceiverId == ""){
		defaultReceiverId =  $(".getChat:first").attr('data-id');
	}
	/*getRightPanel(defaultReceiverId);*/
	/*$(document).on('click', '.load_thread', function(event) {

		event.preventDefault();
		$this = $(this);
		$(this).remove();
		$('.message_thread_list').removeClass('last');

		$('.message_thread').prepend(list);

		$(document).find(".message_thread_list:eq(2)").addClass('last');


		$('.message_thread').animate({
	        scrollTop: $('.last').offset().top
	    }, 100);

	});*/
	$(document).on('click', '.getChat', function(event) {
		$('.getChat').removeClass('active');
		$this = $(this);
		var receiverId = $this.attr('data-id');
		getRightPanel(receiverId);
	});

	$(document).on('click', '#searchButton', function(event) {
		event.preventDefault();
		searchNm = $("#searchTextBox").val();
		$("#txtSearch").val(searchNm);
		getUserList();
	});

	$(document).on('change', '#filter', function(event) {
		getUserList();
	});

	$(document).on('submit', '#formSearch', function(event) {
		event.preventDefault();
		searchNm = $("#searchTextBox").val();
		$("#txtSearch").val(searchNm);
		getUserList();
	});

	$(document).on('click', '.loadPrev', function(event) {
		event.preventDefault();
		var $this = $(this);
		var receiverId = $("#receiverId").val();
		var pageNo = $this.attr('data-page');

		$.ajax({
			url: msgUrl,
			dataType: 'json',
			type: 'post',
			data: {
				action: 'getMessages',
				receiverId: receiverId,
				pageNo: pageNo,
			},
			beforeSend: function() {
				showLoader();
			},
			success: function(response) {
				if (response.status) {
					$('.loadPrev').remove();
					$("#messageBunch").prepend(response.data)
					$(document).find('.message_thread_list').removeClass('last');
					$(document).find(".message_thread_list:eq(3)").addClass('last');
					$('#messageBunch').animate({
				        scrollTop: $('.last').offset().top
				    }, 100);
				} else {
					toastr['error'](lang.MSG_SOMETHING_WRONG);
				}
				hideLoader();
			},
			error: function(response) {
				hideLoader();
				$(function() {
					toastr['error'](lang.MSG_SOMETHING_WRONG);
				});
			}
		});
	});

	$(document).on('change', '#msgFile', function(event) {
		event.preventDefault();
		var $this = $(this);
		var filechk = $(this).val();
		fileSize = this.files[0].size;
		size = getSize(fileSize);
		if(size < MAX_ATTACH_FILE_SIZE){
			if( $('.attachment_form_div').length < MAX_ATTACH_FILE_LIMIT){
				if(filechk){
					var formData = new FormData();
					var receiverId = $("#receiverId").val();
					formData.append('msgFile', this.files[0]);
					formData.append('receiverId', receiverId);
					formData.append('returnType', 'y');
					formData.append('action', 'storeTempFile');
					$.ajax({
						url: msgUrl,
						type: 'post',
						data: formData,
						dataType: 'json',
						contentType: false,
						processData: false,
						beforeSend: function() {
							showLoader();
						},
						success: function(response) {
							if (response.type == 'success') {
								hideLoader();
								$("#formAttachment").removeClass('hide');
								$("#formAttachment").append(response.data);
							} else {
								toastr[response.type](response.message);
								hideLoader();
							}
							$this.val('');
						},
						error: function(response) {
							$this.val('');
							hideLoader();
							$(function() {
								toastr['error'](lang.MSG_SOMETHING_WRONG);
							});
						}
					});
				}else{
					toastr['error'](lang.MSG_SOMETHING_WRONG);
					$this.val('');
				}
			}else{
				var maxLimitAttMsg =  lang.MSG_SELECT_FILE_LIMIT.replace("%MAX_LIMIT%", MAX_ATTACH_FILE_LIMIT);
				toastr['error'](maxLimitAttMsg)
				$this.val('');
			}
		}else{
			var sizeLimitMsg =  lang.MSG_SELECT_FILE_SIZE_LIMIT.replace("%FILE_SIZE%", MAX_ATTACH_FILE_SIZE);

			toastr['error'](sizeLimitMsg)
			$this.val('');
		}
	});

	$(document).on('click', '.deleteAttachment', function(event) {
		$this =$(this);
		receiverId = $("#receiverId").val();
		fileName = $(this).siblings('.attachmentName').val();
		console.log(fileName);
		if (confirm(lang.MSG_CONFIRM_DELETE_FILE)) {
			if (receiverId > 0) {
				$.ajax({
					url: msgUrl,
					dataType: 'json',
					type: 'post',
					data: {
						action: 'removeTempFile',
						receiverId: receiverId,
						fileName: fileName,
					},
					beforeSend: function() {
						showLoader();
					},
					success: function(response) {
						if (response.status) {
							$this.closest('.attachment_form_div').remove();
							if( $('.attachment_form_div').length <= 0){
								$("#formAttachment").addClass('hide');
							}
						} else {
							toastr['error'](lang.MSG_SOMETHING_WRONG);
						}
						hideLoader();
					},
					error: function(response) {
						hideLoader();
						$(function() {
							toastr['error'](lang.MSG_SOMETHING_WRONG);
						});
					}
				});
			}
		}
	});

	$(document).on('click', '#cancel', function(event) {
		$this =$(this);
		receiverId = $("#receiverId").val();
		fileLength =  $('.attachment_form_div').length;

		if (receiverId > 0 && fileLength > 0) {
			$.ajax({
				url: msgUrl,
				dataType: 'json',
				type: 'post',
				data: {
					action: 'removeAllTempFile',
					receiverId: receiverId,
				},
				beforeSend: function() {
					showLoader();
				},
				success: function(response) {
					if (response.status) {
						$('.attachment_form_div').remove();
						$("#formAttachment").addClass('hide');
					} else {
						toastr['error'](lang.MSG_SOMETHING_WRONG);
					}
					hideLoader();
				},
				error: function(response) {
					hideLoader();
					$(function() {
						toastr['error'](lang.MSG_SOMETHING_WRONG);
					});
				}
			});
		}
	});

	$(document).on('submit', '#msgForm', function(event) {

		event.preventDefault();
		$this = $(this);
		var receiverId = $("#receiverId").val();
		var formData = new FormData(this);
		formData.append('returnType', 'y');
		formData.append('action', 'sendMessage');
		var message =  $("#message").val();
		var main_string = message.replace(/[\n\r\t\"\'\ ]+/g, " ").replace(/ /g, '').replace("[at]", "@").replace("dot", ".").replace("dotcom", ".com").replace(/(.)(?=\1)/gi, "");

        /* email check */
        var res1 = main_string.split(' ').join('');
        var res1 = res1.replace(/[^a-z0-9\.\@\s\ ]/gi, '').replace(/[_\s]/g, '-');
        var result1 = !ValidateEmail(res1);

        /* mobno check */
        var main_string = message.replace(/[\n\r\t\"\'\ ]+/g, " ").replace(/ /g, '');
        var res1 = main_string.split(' ').join('');
        var res1 = res1.replace(/[^a-z0-9]/gi, '').replace(/[_\s]/g, '-');
        var result2 = !ValidateMobNo(res1);


        /*if (result1 == false) {
            toastr['error']("Email address exist in your message. kindly remove it to submit form.");
        } else */if (result2 == false) {
            toastr['error']("Mobile number exist in your message. kindly remove it to submit form.");
        } else if (main_string.indexOf('skype') > -1) {
            toastr['error']("Skype Name exist in your message. kindly remove it to submit form.");
        } /*else if(/^[a-zA-Z0-9-,. ]*$/.test(message) == false){
            toastr['error']("Your message contains special characters. kindly remove it to submit form.");
        }*/
        else {
			$.ajax({
				url: msgUrl,
				dataType: 'json',
				type: 'post',
				data: formData,
				contentType: false,
				processData: false,
				beforeSend: function() {
					showLoader();
				},
				success: function(response) {
					if(response.status){
						$("#msgForm")[0].reset();
						$('.attachment_form_div').remove();
						$("#formAttachment").addClass('hide');
						$('#messageBunch').append(response.data);
						$("#last_msg_"+receiverId).html(response.plainMsg);
						msgThreadScollBottom();
					}else{
						if(response.reload == 'y'){
							window.location.reload();
						}else{
							toastr['error'](response.message);
						}
					}
					hideLoader();
				},
				error: function(response) {
					hideLoader();
					$(function() {
						toastr['error'](lang.MSG_SOMETHING_WRONG);
					});
				}
			});
		}
	});

	$(document).on('click', '.actionFilter', function(event) {
		event.preventDefault();
		$this = $(this);
		var actionType =$this.attr('data-action');
		var receiverId = $("#receiverId").val();

		$.ajax({
			url: msgUrl,
			dataType: 'json',
			type: 'post',
			data: {
				action: 'actionFilter',
				type: actionType,
				receiverId: receiverId
			},
			beforeSend: function() {
				showLoader();
			},
			success: function(response) {
				if(actionType == 'star'){
					if ($this.find('i').hasClass("fa")) {
						$this.removeClass('isStar');
						$this.find('i').removeClass('fa').addClass('far');
					}else{
						$this.addClass('isStar');
						$this.find('i').removeClass('far').addClass('fa');
					}
				}else if(actionType == 'unread'){
					$this.addClass('isUnread');
					$("#unread_count_"+receiverId).html(response.unreadCount).removeClass('hide');
				}else if(actionType == 'archive'){
					if($this.hasClass('isArchive')){
						$this.removeClass('isArchive');
					}else{
						$this.addClass('isArchive');
					}
				}
				hideLoader();
			},
			error: function(response) {
				hideLoader();
				$(function() {
					toastr['error'](lang.MSG_SOMETHING_WRONG);
				});
			}
		});
	});

	$.validator.addMethod('customvalidation',function (value, element) {
		if(this.optional(element) || /<\/?[^>]+(>|$)/g.test(value)){
	        return false;
	    } else {
	        return true;
	    }
		},lang.INVALID_MSG_ENTER
	);

	/*function Check(){
		var reg =/<(.|\n)*?>/g;
		if (reg.test($('#message').val()) == true) {
			toastr['error'](lang.INVALID_MSG_ENTER);
			return false;
	    }
	}*/
});


function ValidateEmail(email) {
        var expr = /^([a-z\d!#$%&'*+\-\/=?^_`{|}~\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF]+(\.[a-z\d!#$%&'*+\-\/=?^_`{|}~\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF]+)*|"((([ \t]*\r\n)?[ \t]+)?([\x01-\x08\x0b\x0c\x0e-\x1f\x7f\x21\x23-\x5b\x5d-\x7e\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF]|\\[\x01-\x09\x0b\x0c\x0d-\x7f\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF]))*(([ \t]*\r\n)?[ \t]+)?")@(([a-z\d\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF]|[a-z\d\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF][a-z\d\-._~\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF]*[a-z\d\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])\.)+([a-z\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF]|[a-z\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF][a-z\d\-._~\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF]*[a-z\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])\.?$/i;
        return expr.test(email);
}
function ValidateMobNo(mob_no) {
    var expr = /^\d{10}$/;
    return expr.test(mob_no);
}

function msgThreadScollBottom() {
	$(".message_thread").animate({ scrollTop: $('.message_thread').prop("scrollHeight")}, 1000);

}
function getSize(size = 0){

    fileSize = size / 1048576; //size in mb
    fileSize = Math.round(fileSize);
	return fileSize;
}

function validate() {
	$msgForm = "#msgForm"; {
		$($msgForm).validate({
			rules: {
				message: {
					required: true,
					customvalidation:true
				},
			},
			messages: {
				message: {
					required: lang.ENTER_MSG
				},
			},
			errorPlacement: function(error, element) {
				if (element.attr("data-error-container")) {
					error.appendTo(element.attr("data-error-container"));
				} else {
					error.insertAfter(element);
				}
			}
		});
	}
}

function getUserList() {

	var name = $('#txtSearch').val();
	var filter = $('#filter').val();

	$.ajax({
		url: msgUrl,
		dataType: 'json',
		type: 'post',
		data: {
			action: 'getLeftPanel',
			searchName: name,
			filter: filter
		},
		beforeSend: function() {
			showLoader();
		},
		success: function(response) {
			$("#leftPanel").html(response.data);
			hideLoader();
		},
		error: function(response) {
			hideLoader();
			$(function() {
				toastr['error'](lang.MSG_SOMETHING_WRONG);
			});
		}
	});
}

function getRightPanel(receiverId) {
	if (receiverId > 0) {
		$.ajax({
			url: msgUrl,
			dataType: 'json',
			type: 'post',
			data: {
				action: 'getRightPanel',
				receiverId: receiverId,
			},
			beforeSend: function() {
				showLoader();
			},
			success: function(response) {
				if (response.status) {
					$("*[data-id="+receiverId+"]").addClass('active');
					$("*[data-id="+receiverId+"]").find('.countmy').html(0).addClass('hide');
					$('#rightPanel').html(response.data);
					$(document).find(".message_thread_list:nth-last-child(2)").addClass('moveScroll');
					msgThreadScollBottom();
					/*scrollToElement('.moveScroll');*/
					if (response.count > 0) {
						//$("#noti_count_msg").removeClass('d-none');
						$("#noti_count_msg").html(response.count);
						$("#noti_count_msg").removeClass('hide');
					} else {
						$("#noti_count_msg").html(response.count);
						$("#noti_count_msg").addClass('hide');
					}
					validate();
				} else {
					toastr['error'](lang.MSG_SOMETHING_WRONG);
				}
				hideLoader();
			},
			error: function(response) {
				hideLoader();
				$(function() {
					toastr['error'](lang.MSG_SOMETHING_WRONG);
				});
			}
		});
	}
}