function getPaginationData(page){
	page = (page && page !== null && page !== undefined && page > 0) ? page : 1;
	var status = $("#fil_status").val();
	var type = $("#fil_type").val();
	var keyword = $("#filt_keyword").val();
	$.ajax({
		url: currentPageURL,
		type: "POST",
		cache:false,
		data: {
			action: 'ajaxPagination',
			page: page,
			status:status,
			type:type,
			keyword:keyword
		},
		dataType : 'json',
		beforeSend : function(){
			showLoader();
		},
		success: function(data) {
			$(".contact-table .inner_loader").remove();
			$(".contact-table .tbody").remove();
			$(".manage_sales_div").append(data.html);
			if(data.status == true){
				$(".pagination_div").html(data.pagination);
			}
			else{
				$(".pagination_div").html('');
			}
			scrollToElement(".manage-purchases");
			hideLoader();

		}
	});
}

$(document).ready(function() {
	getPaginationData(1);
});
$(document).on("click",".buttonPage",function(){
	var pageNo = $(this).data('page');
	getPaginationData(pageNo);
});
$(document).on("change","#fil_status,#fil_type,#filt_keyword",function(){
	getPaginationData(1);
});

$(document).on("click",".active_order_now",function(e){
	var id = $(this).data('id');
	if(confirm(lang.MANAGE_SALES_PAGE_ORDER_STATUS_CHANGE_CONFIRM)){
		$.ajax({
			url: currentPageURL,
			type: "POST",
			cache:false,
			data: {
				action: 'activeOrderForSeller',
				orderId : id
			},
			dataType : 'json',
			beforeSend : function(){
				showLoader();
			},
			success: function(data) {
				hideLoader();
				if(data.status == true){
					toastr['success'](data.message);
					getPaginationData(1);
				}
				else{
					if(data.message != ''){
						toastr['error'](data.message);
					}
				}
			}
		});
	}
});