function completeSubmit(response){
    if(response && response.redirectLink && response.redirectLink !== undefined && response.redirectLink != ''){
        //toastr['success'][response.message];
        window.location.href=response.redirectLink;
    }
}

$(document).on('submit','#editProfileForm',function(e){
    if($("#editProfileForm").valid()){
        ajaxFormSubmit("form#editProfileForm","completeSubmit");
        return false;
    }else{
        return false;
    }
});

$(document).ready(function(){
    $.validator.addMethod('customvalidation',function (value, element) {
        return /^[a-zA-Z0-9][a-zA-Z0-9\-\ ]*$/.test(value);
        },lang.REGISTER_ERR_USER_NAME
    );


    var autocomplete =  new google.maps.places.Autocomplete($("#location")[0], {
        types: ["geocode"],
    });

    google.maps.event.addListener(autocomplete, 'place_changed',
    function(){
        var place = autocomplete.getPlace();
        if(place && place.geometry && place.geometry !== undefined && place.geometry !== null ){
            var lat = place.geometry.location.lat();
            var lng = place.geometry.location.lng();
            $("#locLate").val(lat);
            $("#locLong").val(lng);
        }
    });

    $("#location").keypress(function(e) {
      if (e.which === 13) {
        return false;
      }
    });

    //generating cropper for profile image
    var cropperObj = {aspectRatio:'1:1'};
    generateCropperScript('profileImage','profileImage',crop_url,call_url,lang.EDIT_PROFILE_PAGE_LBL_CROP_PROFILE_IMG,cropperObj);
    //generating cropper for profile image

    $("#editProfileForm").validate({
        ignore : '',
        rules:{
            userName:{required:true,customvalidation: true},
            aboutMe:{required:true},
            "languages[]":{required:true},
            skills:{required:true},
            education:{required:true},
            certification:{required:true},
            portfolio:{required:true},
            profileImage : {accept:'jpg|jpeg|png'},
            profileVideo : {accept:'mp4|webm'}
        },
        messages:{
            userName:{required:lang.EDIT_PROFILE_PAGE_ERR_ENTER_USER_NAME},
            aboutMe:{required:lang.EDIT_PROFILE_PAGE_ERR_ENTER_DESCRIPTION},
            "languages[]":{required:lang.EDIT_PROFILE_PAGE_ERR_ADD_LANGAUGES},
            skills:{required:lang.EDIT_PROFILE_PAGE_ERR_ADD_SKILLS},
            education:{required:lang.EDIT_PROFILE_PAGE_ERR_ENTER_EDUCATION},
            certification:{required:lang.EDIT_PROFILE_PAGE_ERR_ENTER_CERTIFICATION},
            portfolio:{required:lang.EDIT_PROFILE_PAGE_ERR_ENTER_PORTFOLIO},
            profileImage : {accept:lang.ADD_SERVICE_PAGE_ERR_ONLY_PDF_OR_DOC_ALLOWED},
            profileVideo : {accept:lang.EDIT_PROFILE_PAGE_ERR_ONLY_MP4_OR_WEBM_ALLOWED}
        },
        highlight: function (element, errorClass, validClass) {
            //$(element).closest('.form-group').addClass('has-error');
        },
        unhighlight: function (element, errorClass, validClass) {
            //$(element).closest('.form-group').removeClass('has-error');
        },
        errorPlacement: function (error, element) {
            if (element.attr("data-error-container")){
                error.appendTo(element.attr("data-error-container"));
            } else {
                error.appendTo(element.closest('.col-md-8'));
            }
            error.addClass('error');
        }
    });

    $('#skills').tokenfield({
        autocomplete: {
            source: function (request, response){
                if(request.term != ''){
                    $(".tag_complete").addClass('tag_suggest');
                    jQuery.get(currentPageURL,{
                        query: request.term,
                        action:'skills_suggection',
                        return_type:'json'
                    },function (data) {
                        data = $.parseJSON(data);
                        $(".tag_complete").removeClass('tag_suggest');
                        response(data);
                    });
                }
              },
            delay: 100
        },
        showAutocompleteOnFocus: true
    });
    $('#skills').tokenfield('setTokens', skills);
});

$(document).on('tokenfield:createtoken','#skills',function(event){
    var existingTokens = $(this).tokenfield('getTokens');
    $.each(existingTokens, function(index, token) {
        if (token.value === event.attrs.value)
            event.preventDefault();
    });
});