// For Dashboard Graph Only
function load_new_order_chart(data) {
    Highcharts.chart('new_order_chart', {
        chart: {
            zoomType: 'x'
        },
        title: {
            text: lang.DASHBOARD_PAGE_NEW_ORDER_CHART_TITLE
        },
        subtitle: {
            text: document.ontouchstart === undefined ? lang.DASHBOARD_PAGE_CHART_DRAG_ZOOM : lang.DASHBOARD_PAGE_CHART_PINCH_TO_ZOOM
        },
        xAxis: {
            type: 'datetime'
        },
        yAxis: {
            title: {
                text: lang.DASHBOARD_PAGE_NEW_ORDER_CHART_TEXT
            }
        },
        legend: {
            enabled: false
        },
		exporting:{
            allowHTML: true
		},
        lang: {
            noData: lang.DASHBOARD_PAGE_CHART_NO_NEW_ORDER_MSG
        },
        plotOptions: {
            area: {
                fillColor: {
                    linearGradient: {
                        x1: 0,
                        y1: 0,
                        x2: 0,
                        y2: 1
                    },
                    stops: [
                        [0, Highcharts.getOptions().colors[0]],
                        [1, Highcharts.Color(Highcharts.getOptions().colors[0]).setOpacity(0).get('rgba')]
                    ]
                },
                marker: {
                    radius: 2
                },
                lineWidth: 1,
                states: {
                    hover: {
                        lineWidth: 1
                    }
                },
                threshold: null
            }
        },
        series: [{
            type: 'area',
            name: lang.DASHBOARD_PAGE_NEW_ORDER_CHART_TITLE,
            data: data
        }]
    });
}

// For Dashboard Graph Only
function load_extra_order_chart(data) {

    Highcharts.chart('extra_order_chart', {
        chart: {
            zoomType: 'x'
        },
        title: {
            text: lang.DASHBOARD_PAGE_EXTRA_ORDER_CHART_TITLE
        },
        subtitle: {
            text: document.ontouchstart === undefined ? lang.DASHBOARD_PAGE_CHART_DRAG_ZOOM : lang.DASHBOARD_PAGE_CHART_PINCH_TO_ZOOM
        },
        xAxis: {
            type: 'datetime'
        },
        yAxis: {
            title: {
                text: lang.DASHBOARD_PAGE_EXTRA_ORDER_CHART_TEXT
            }
        },
        legend: {
            enabled: false
        },
		exporting:{
            allowHTML: true
		},
        lang: {
            noData: lang.DASHBOARD_PAGE_CHART_NO_EXTRA_ORDER_MSG
        },
        plotOptions: {
            area: {
                fillColor: {
                    linearGradient: {
                        x1: 0,
                        y1: 0,
                        x2: 0,
                        y2: 1
                    },
                    stops: [
                        [0, Highcharts.getOptions().colors[0]],
                        [1, Highcharts.Color(Highcharts.getOptions().colors[0]).setOpacity(0).get('rgba')]
                    ]
                },
                marker: {
                    radius: 2
                },
                lineWidth: 1,
                states: {
                    hover: {
                        lineWidth: 1
                    }
                },
                threshold: null
            }
        },
        series: [{
            type: 'area',
            name: lang.DASHBOARD_PAGE_EXTRA_ORDER_CHART_TEXT,
            data: data
        }]
    });
}	

// For Dashboard Graph Only
function load_delivered_order_chart(data){
    
    Highcharts.chart('delivered_order_chart', {
        chart: {
            zoomType: 'x'
        },
        title: {
            text: lang.DASHBOARD_PAGE_DELIVERED_ORDER_CHART_TEXT
        },
        subtitle: {
            text: document.ontouchstart === undefined ?
                    lang.DASHBOARD_PAGE_CHART_DRAG_ZOOM  : lang.DASHBOARD_PAGE_CHART_PINCH_TO_ZOOM
        },
        xAxis: {
            type: 'datetime'
        },
        yAxis: {
            title: {
                text: lang.DASHBOARD_PAGE_DELIVERED_ORDER_CHART_TEXT
            }
        },
        legend: {
            enabled: false
        },
		exporting:{
		  allowHTML: true
		},
        lang: {
            noData: lang.DASHBOARD_PAGE_CHART_NO_DELIVERED_ORDER_MSG
        },
        plotOptions: {
            area: {
                fillColor: {
                    linearGradient: {
                        x1: 0,
                        y1: 0,
                        x2: 0,
                        y2: 1
                    },
                    stops: [
                        [0, Highcharts.getOptions().colors[0]],
                        [1, Highcharts.Color(Highcharts.getOptions().colors[0]).setOpacity(0).get('rgba')]
                    ]
                },
                marker: {
                    radius: 2
                },
                lineWidth: 1,
                states: {
                    hover: {
                        lineWidth: 1
                    }
                },
                threshold: null
            }
        },
        series: [{
            type: 'area',
            name: lang.DASHBOARD_PAGE_DELIVERED_ORDER_CHART_TEXT,
            data: data
        }]
    });
}

function load_rating_chart(data){
    
    if(data.length > 0){
        $('.posistive_progress').css('width', data[0]['y']+'%').attr('aria-valuenow', data[0]['y']);    
        $('.posistive_progress_text').text(data[0]['y']+'%');  
        $('.negative_progress').css('width', data[1]['y']+'%').attr('aria-valuenow', data[1]['y']); 
        $('.negative_progress_text').text(data[1]['y']+'%'); 
        $('.not_rated_progress').css('width', data[2]['y']+'%').attr('aria-valuenow', data[2]['y']);  
        $('.not_rated_progress_text').text(data[2]['y']+'%');  
    }
    Highcharts.chart('order_pie_chart', {
        chart: {
            plotBackgroundColor: null,
            plotBorderWidth: null,
            plotShadow: false,
            type: 'pie'
        },
        title: {
            text: lang.DASHBOARD_PAGE_RATING_CHART_TEXT
        },
        tooltip: {
            pointFormat: '{series.name}: <b>{point.percentage:.1f}%</b>'
        },
        exporting:{
            allowHTML: false
        },
        lang: {
            noData: lang.DASHBOARD_PAGE_CHART_NO_REVIEW_ORDER_MSG
        },
        plotOptions: {
            pie: {
                allowPointSelect: true,
                cursor: 'pointer',
                dataLabels: {
                    enabled: false
                },
                showInLegend: true
            }
        },
        series: [{
            name: lang.DASHBOARD_PAGE_RATING_CHART_PERCENTAGE_TEXT,
            colorByPoint: true,
            data: data
        }]
    });
}

function load_profile_chart(data){
    Highcharts.chart('profile_completed_pie_chart',{
        chart: {
            type: 'solidgauge'
        },
        title: {
            text: lang.DASHBOARD_PAGE_PROFILE_CHART_TEXT
        },
        exporting:{
          allowHTML: true
        },
        lang: {
            noData: lang.DASHBOARD_PAGE_PROFILE_CHART_NRF
        },
        tooltip: {
            enabled: false
        },
        pane: {
            startAngle: 0,
            endAngle: 360,
            background: [{ 
                outerRadius: '112%',
                innerRadius: '88%',
                backgroundColor: Highcharts.Color(Highcharts.getOptions().colors[0])
                    .setOpacity(0.3)
                    .get(),
                borderWidth: 0
            }]
        },
        yAxis: {
            min: 0,
            max: 100,
            lineWidth: 0,
            tickPositions: []
        },
        plotOptions: {
            solidgauge: {
                dataLabels: {
                    y: -25,
                    borderWidth: 0,
                    backgroundColor: 'none',
                    shadow: false,
                    useHTML: true,
                    format: '<div style="font-size:2em; color: {point.color}; font-weight: bold;text-align:center;">{y}%</span><br/><span style = "font-size:14px;color:black">{series.name}</span></div>'
                },
                linecap: 'round',
                stickyTracking: false,
                rounded: true
            }
        },
        series: [{
            name: lang.DASHBOARD_PAGE_PROFILE_CHART_NAME,
            data: [{
                    color: Highcharts.getOptions().colors[0],
                    radius: '112%',
                    innerRadius: '88%',
                    y: data
                }]
        }]
    });
}

$(document).ready(function(){
    $('[data-toggle="tooltip"]').tooltip();
    get_new_order_chart('new_orders');
    get_new_order_chart('extra_orders');
    get_new_order_chart('delivered_orders');
    get_new_order_chart('rating');
    //get_new_order_chart('profile');
});

function get_new_order_chart(type){
    type = (typeof(type) !== undefined && type !== null && type !== undefined && type != '') ? type : '';
    if(type == 'rating'){
        get_new_order_chart('profile');
        $('.posistive_progress').css('width', 0+'%').attr('aria-valuenow', 0);    
        $('.posistive_progress_text').text('-');  
        $('.not_rated_progress').css('width', 0+'%').attr('aria-valuenow', 0);  
        $('.not_rated_progress_text').text('-');  
        $('.negative_progress').css('width', 0+'%').attr('aria-valuenow', 0); 
        $('.negative_progress_text').text('-'); 
    }
    $.ajax({
        url: window.location.href,
        type: "POST",
        cache:false,
        data: {
            action: 'get_chart_data',
            type: type
        },
        dataType : 'json',
        beforeSend : function(){
            showLoader();
        },
        success: function(data) {
            if(type == 'new_orders')
                load_new_order_chart(data.data);
            else if(type == 'extra_orders')
                load_extra_order_chart(data.data);
            else if(type == 'delivered_orders')
                load_delivered_order_chart(data.data);
            else if(type == 'rating'){
                load_rating_chart(data.data);
            }
            else if(type == 'profile'){  
                load_profile_chart(data.data);
            }
            else{}
            hideLoader();
        }
    });
}