<?php
class SubCategory extends Home
{

    public $constantValue;
    public $constantName;
    public $data = array();

    public function __construct($module, $id = 0, $searchArray = array(), $type = '')
    {
        global $db, $fb, $fields, $sessCataId;
        $this->db         = $db;
        $this->data['id'] = $this->id = $id;
        $this->fields     = $fields;
        $this->module     = $module;
        $this->table      = 'tbl_subcategories';

        $this->type        = ($this->id > 0 ? 'edit' : 'add');
        $this->searchArray = $searchArray;
        parent::__construct();
        if ($this->id > 0) {
            $fetchRes = $this->db->pdoQuery("SELECT s.*,c.cateName_$this->langId,c.cateName
                    FROM tbl_subcategories AS s
                    LEFT JOIN tbl_categories AS c On c.id = s.categoryId
                    WHERE s.id = ? ",array($this->id))->result();

            foreach ($fetchRes as $k => $v) {
                $this->{$k} = filtering($v);
            }

        } else {

            $fetchRes = $this->db->pdoQuery("SHOW COLUMNS FROM " . $this->table)->results();
            foreach ($fetchRes as $k => $v) {
                $this->{$v["Field"]} = $v["Default"];
            }
        }

        switch ($type) {
            case 'add':{
                    $this->data['content'] = (in_array('add', $this->Permission)) ? $this->getForm() : '';
                    break;
                }
            case 'import_excel':{
                    $this->data['content'] = (in_array('import', $this->Permission)) ? $this->getImportCsvForm() : '';
                    break;
                }
            case 'edit':{
                    $this->data['content'] = (in_array('edit', $this->Permission)) ? $this->getForm() : '';
                    break;
                }
            case 'view':{
                    $this->data['content'] = $this->viewForm();
                    break;
                }
            case 'delete':{
                    $this->data['content'] = (in_array('delete', $this->Permission)) ? json_encode($this->dataGrid()) : '';
                    break;
                }
            case 'datagrid':{
                    $this->data['content'] = (in_array('module', $this->Permission)) ? json_encode($this->dataGrid()) : '';
                }
        }

    }
    public function viewForm(){    	
        $image = '<img width="100px" height="100px" src="'.checkImage($this->image,4,$this->id).'" alt="'.$this->subCategoryName.'" />';
        $languages = $this->db->select("tbl_language", '*', array("1" => '1'))->results();
        $content = $this->displayBox(array("label" => "Category Name&nbsp;:", "value" => $this->cateName));
        $content = $this->displayBox(array("label" => "Image&nbsp;:", "value" => $image));
        foreach ($languages as $key => $value) {
            $content .= $this->displayBox(array("label" => "Subcategory Name&nbsp;(".($value['languageName'])."):", "value" => $this->{"subCategoryName_" . $value['id']})) .
            $this->displayBox(array("label" => "Descrption&nbsp;(".($value['languageName'])."):", "value" => filtering($this->{"description_" . $value['id']}, 'output', 'text')));
        }
        return $content;
    }
    public function getForm(){
    	$content = '';
        $languages = $this->db->select("tbl_language", '*', array("1" => '1'))->results();
        $html = null;
        foreach ($languages as $key => $value) {    
            $html .= get_view(DIR_ADMIN_TMPL . $this->module . "/textfield.tpl.php", array(
            	'%label%'          => 'Sub Category Name',
            	'%id%'             => $value['id'], 
                '%IS_ENG%'         => ($value['langCode'] == 'en' ? 'is_english' : ''),
            	'%languageName%'   => $value['languageName'], 
            	'%fieldName%'      => 'subCategoryName['.$value['id'].']',
            	'%fieldValue%'     => (isset($this->{"cateName_" . $value['id']}) ? $this->{"cateName_" . $value['id']} : null)));
            $html .= get_view(DIR_ADMIN_TMPL . $this->module . "/textarea.tpl.php", array(
            	'%label%' => 'Description',
            	'%id%' => $value['id'], 
            	'%languageName%' => $value['languageName'], 
            	'%fieldName%' => 'description['.$value['id'].']',
            	'%fieldValue%' => (isset($this->{"description_" . $value['id']}) ? $this->{"description_" . $value['id']} : null)));

        }
        $replace = array(
            "%CATEGORY_OPTION%" =>$this->getCategorySelection($this->categoryId),
            "%html%"            => $html,
            '%IMAGE%'           => checkImage($this->image,4,$this->id),
            '%IGNORECLASS%'     => ($this->type == 'add' ? '' : 'ignore'),
            '%REQUIRED%'        => ($this->type == 'add' ? 'required' : ''),
            "%DEST_SITE_URL%"   => SITE_UPD.'subcategory/temp_dir/',
            "%DEST_DIR_URL%"    => DIR_UPD.'subcategory/temp_dir/',
            "%STATUS_A%"        => ($this->isActive == 'y' ? 'checked' : ''),
            "%STATUS_D%"        => ($this->isActive == 'n' ? 'checked' : ''),
            "%TYPE%"            => $this->type,
            "%ID%"              => $this->id,
        );

        $content = get_view(DIR_ADMIN_TMPL . $this->module . "/form-nct.tpl.php", $replace);
        return sanitize_output($content);
        
    }

    public function getCategorySelection($categoryId = ''){
        $content= '';
        $c_q= $this->db->pdoQuery("SELECT id,cateName_1 FROM tbl_categories WHERE 1 = ? ",array(1));
        $main_content = new MainTemplater(DIR_ADMIN_TMPL."/option-nct.tpl.php");
        $main_content = $main_content->parse();
        if($c_q->affectedRows() > 0){
            foreach ($c_q->results() as $key => $value) {
                $selected = ($categoryId == $value['id'] ? 'selected' : '');
                $replace = array(
                    '%OPT_VALUE%'=>$value['id'],
                    '%EXTRA%'=>'',
                    '%SELECTED%'=>$selected,
                    '%OPT_TEXT%'=>$value['cateName_1']
                );
                $content .= str_replace(array_keys($replace),array_values($replace),$main_content); 
            }
        }
        return $content;
    }

    public function dataGrid(){
        $content = $operation = $whereCond = $whereCond1 = $totalRow = null;
        $result  = $tmp_rows  = $row_data  = array();
        extract($this->searchArray);
        $langId  = isset($langId) ? $langId : 1;
        $sWhere = ' WHERE 1 = ? ';
        $aWhere = array(1);
        $chr     = isset($chr) ? str_replace(array('_', '%', "'"), array('\_', '\%', "\'"), $chr) : '';
        if (isset($chr) && $chr != '') {
            $sWhere .= " AND (s.subCategoryName_$langId LIKE ? OR  s.description_$langId LIKE ? OR c.cateName_$langId LIKE ?  )";
            $aWhere[] = "%$chr%";
            $aWhere[] = "%$chr%";
            $aWhere[] = "%$chr%";
        }
        if (isset($sort))
            $sorting = $sort . ' ' . $order;
        else
            $sorting = 's.id DESC';


        $totalRowTmp = $this->db->pdoQuery("SELECT COUNT(s.id) AS nmrows 
                    FROM tbl_subcategories AS s
                    LEFT JOIN tbl_categories AS c On c.id = s.categoryId
                    $sWhere", $aWhere)->result();
        $totalRow = $totalRowTmp['nmrows'];


        $qrySel = $this->db->pdoQuery("SELECT s.*,c.cateName_$langId
                    FROM tbl_subcategories AS s
                    LEFT JOIN tbl_categories AS c On c.id = s.categoryId
                    $sWhere ORDER BY $sorting limit $offset , $rows", $aWhere)->results();

        foreach ($qrySel as $fetchRes){
            $status = ($fetchRes['isActive'] == "y") ? "checked" : "";
            
            $id     = $fetchRes['id'];

            $switch = (in_array('status', $this->Permission)) ? $this->toggel_switch(array("action" => "ajax." . $this->module . ".php?id=" . $id . "", "check" => $status)) : '';

            $operation =(in_array('view', $this->Permission)) ? '&nbsp;&nbsp;' . $this->operation(array("href" => "ajax." . $this->module . ".php?action=view&id=" . $fetchRes['id'] . "", "class" => "btn default blue btn-xs btn-viewbtn", "value" => '<i class="fa fa-laptop"></i>&nbsp;View')) : '';

            $operation .= (in_array('edit', $this->Permission)) ? '&nbsp;&nbsp;' . $this->operation(array("href" => SITE_ADM_MOD . $this->module . "/ajax." . $this->module . ".php?action=edit&id=" . $id, "class" => "btn default btn-xs black btnEdit", "value" => '<i class="fa fa-edit"></i>&nbsp;Edit')) : '';

            $operation .= (in_array('delete', $this->Permission)) ? '&nbsp;&nbsp;' . $this->operation(array("href" => "ajax." . $this->module . ".php?action=delete&id=" . $fetchRes['id'] . "", "class" => "btn default btn-xs red btn-delete", "value" => '<i class="fa fa-trash-o"></i>&nbsp;Delete')) : '';
            $image = '<img width="100px" height="100px" src="'.checkImage($fetchRes['image'],4,$id).'" alt="'.$fetchRes["subCategoryName_".$langId].'" />';
            $final_array = array(
                $id,
                $image,
                stripslashes($fetchRes["cateName_".$langId]),
                stripslashes($fetchRes["subCategoryName_".$langId]),
                //myTruncate(stripslashes($fetchRes["description_".$langId]),40),
                convertDate($fetchRes['createdDate'])
            );
            if (in_array('status', $this->Permission)) {
                $final_array = array_merge($final_array, array($switch));
            }
            if (in_array('edit', $this->Permission) || in_array('delete', $this->Permission) || in_array('view', $this->Permission)) {
                $final_array = array_merge($final_array, array($operation));
            }

            $row_data[] = $final_array;
        }
        $result["sEcho"]                = $sEcho;
        $result["iTotalRecords"]        = (int) $totalRow;
        $result["iTotalDisplayRecords"] = (int) $totalRow;
        $result["aaData"]               = $row_data;
        return $result;

    }

    public function displaybox($text) {

        $text['label'] = isset($text['label']) ? $text['label'] : 'Enter Text Here: ';
        $text['value'] = isset($text['value']) ? $text['value'] : '';
        $text['name'] = isset($text['name']) ? $text['name'] : '';
        $text['class'] = isset($text['class']) ? 'form-control-static ' . trim($text['class']) : 'form-control-static';
        $text['onlyField'] = isset($text['onlyField']) ? $text['onlyField'] : false;
        $text['extraAtt'] = isset($text['extraAtt']) ? $text['extraAtt'] : '';

        $main_content = new MainTemplater(DIR_ADMIN_TMPL . $this->module . '/displaybox.tpl.php');
        $main_content = $main_content->parse();
        $fields = array("%LABEL%", "%CLASS%", "%VALUE%");
        $fields_replace = array($text['label'], $text['class'], $text['value']);
        return str_replace($fields, $fields_replace, $main_content);
    }

    public function toggel_switch($text)
    {
        $text['action']   = isset($text['action']) ? $text['action'] : 'Enter Action Here: ';
        $text['check']    = isset($text['check']) ? $text['check'] : '';
        $text['name']     = isset($text['name']) ? $text['name'] : '';
        $text['class']    = isset($text['class']) ? '' . trim($text['class']) : '';
        $text['extraAtt'] = isset($text['extraAtt']) ? $text['extraAtt'] : '';

        $main_content   = new MainTemplater(DIR_ADMIN_TMPL . $this->module . '/switch-nct.tpl.php');
        $main_content   = $main_content->parse();
        $fields         = array("%NAME%", "%CLASS%", "%ACTION%", "%EXTRA%", "%CHECK%");
        $fields_replace = array($text['name'], $text['class'], $text['action'], $text['extraAtt'], $text['check']);
        return str_replace($fields, $fields_replace, $main_content);
    }
    public function operation($text)
    {

        $text['href']     = isset($text['href']) ? $text['href'] : 'Enter Link Here: ';
        $text['value']    = isset($text['value']) ? $text['value'] : '';
        $text['name']     = isset($text['name']) ? $text['name'] : '';
        $text['class']    = isset($text['class']) ? '' . trim($text['class']) : '';
        $text['extraAtt'] = isset($text['extraAtt']) ? $text['extraAtt'] : '';
        $main_content     = new MainTemplater(DIR_ADMIN_TMPL . $this->module . '/operation-nct.tpl.php');
        $main_content     = $main_content->parse();
        $fields           = array("%HREF%", "%CLASS%", "%VALUE%", "%EXTRA%");
        $fields_replace   = array($text['href'], $text['class'], $text['value'], $text['extraAtt']);
        return str_replace($fields, $fields_replace, $main_content);
    }
    public function getPageContent()
    {
        $final_result             = null;
        $main_content             = new MainTemplater(DIR_ADMIN_TMPL . $this->module . "/" . $this->module . ".tpl.php");
        $main_content->breadcrumb = $this->getBreadcrumb();
        $main_content->getForm    = $this->getForm();

        $final_result = $main_content->parse();
        return $final_result;
    }
}
