<?php
$reqAuth=true;
require_once("../../../includes-nct/config-nct.php");
require_once("class.manage-services-nct.php");
$module = "manage-services-nct";
$table = "tbl_services";
$styles = array(array("data-tables/DT_bootstrap.css",SITE_ADM_PLUGIN),
	array("bootstrap-switch/css/bootstrap-switch.min.css",SITE_ADM_PLUGIN),
	array("toggle-switch.css",SITE_ADM_CSS),
	array("cropper.min.css", SITE_ADM_CSS),
	array("select-multiple/bootstrap-select.min.css", SITE_ADM_JS),
	array("bootstrap-tokenfield/bootstrap-tokenfield.css",SITE_ADM_PLUGIN),
	array("bootstrap-tokenfield/jquery-ui-1.12.1/jquery-ui.css",SITE_ADM_PLUGIN));

$scripts= array("core/datatable.js",
	array("data-tables/jquery.dataTables.js",SITE_ADM_PLUGIN),
	array("data-tables/DT_bootstrap.js",SITE_ADM_PLUGIN),
	array("cropper.min.js", SITE_ADM_JS),
	array("bootstrap-switch/js/bootstrap-switch.min.js",SITE_ADM_PLUGIN),
	array("select-multiple/bootstrap-select.min.js", SITE_ADM_JS),
	array("bootstrap-tokenfield/bootstrap-tokenfield.js",SITE_ADM_PLUGIN),
	array("cropper.js", SITE_ADM_JS));

chkPermission($module);
$Permission=chkModulePermission($module);
$metaTag = getMetaTags(array("description"=>"Admin Panel",
		"keywords"=>'Admin Panel',
		'author'=>AUTHOR));

$id = isset($_GET["id"]) ? (int)trim($_GET["id"]) : 0;
$postType = isset($_POST["type"])?trim($_POST["type"]):'';
$type = isset($_GET["type"])?trim($_GET["type"]):$postType;

$headTitle = $type == 'add' ? 'Add' : ($type == 'edit' ? 'Edit' : 'Manage').' Services';
$winTitle = $headTitle.' - '.SITE_NM;
$breadcrumb = array($headTitle);



if(isset($_POST["submitAddRemoveCollectionForm"]) && $_SERVER["REQUEST_METHOD"] == "POST") {
	extract($_POST);
	$collections = isset($collections) ? $collections : array();
	$response = array();
    $response['status'] = false;
    if($type == 'edit' && $id > 0){
		if(in_array('edit',$Permission)){
			if(count($collections) <= 0){
				$db->delete('tbl_trending_collections_services',array('serviceId'=>$id));
				$response['status'] = true;
	            $response['success'] =  "Service has been removed from trending collection successfully.";
	            echo json_encode($response);
	            exit;
			}
			else{
				$db->delete('tbl_trending_collections_services',array('serviceId'=>$id));
				foreach ($collections as $key => $value) {
					/*$check = $db->pdoQuery("SELECT id FROM tbl_trending_collections_services WHERE serviceId = ?  AND trendingId = ? LIMIT 1 ",array($id,$value))->affectedRows();
					if($check <= 0){*/
						$db->insert('tbl_trending_collections_services',array('serviceId'=>$id,'trendingId'=>$value));
					/*}*/
				}
				$response['status'] = true;
	            $response['success'] =  "Service has been added to trending collections successfully.";
	            echo json_encode($response);
	            exit;
			}
		}
		else{
			$response['status'] = false;
            $response['error'] =  "You don't have permission to perform this action.";
            echo json_encode($response);
            exit;
		}
	}
	else{
		$response['status'] = false;
        $response['error'] =  "Something went wrong please try again later.";
        echo json_encode($response);
        exit;
	}
}
if(isset($_POST["submitAddForm"]) && $_SERVER["REQUEST_METHOD"] == "POST" && $_POST["action"] == "firstStepSubmit"){
	extract($_POST);
	$response = array();
    $response['status'] = false;
    $response['data'] =  array('id'=>$id,'form_no'=>1);
	$objPost = new stdClass();
	$objPost->title     		= filtering(issetor($title,''),'input');
	$objPost->categoryId    	= filtering(issetor($categoryId,''),'input','int');
	$objPost->subCategoryId 	= filtering(issetor($subCategoryId,0),'input','int');
	$objPost->description   	= filtering(issetor($description,''),'input','text');
	$objPost->durationType  	= filtering(issetor($durationType,''),'input');
	$objPost->duration     		= filtering(issetor($duration,0),'input','int');
	$objPost->additionalInfo    = filtering(issetor($additionalInfo,''),'input','text');
	$tags     = isset($tags) ? trim($tags) : '';
	$objPost->isActive     	= isset($status) ? $status : 'n';
	$objPost->updatedDate 	= date('Y-m-d H:i:s');
	$objPost->isAdminEdited = 'y';
	$objPost->adminEditedDate = date('Y-m-d H:i:s');
	if($type == 'edit' && $id > 0){
		if(in_array('edit',$Permission)){
			if($objPost->title != '' && $objPost->categoryId != '' && $objPost->subCategoryId != '' && $objPost->description != '' && $objPost->durationType != '' && $objPost->duration != ''){
				$objPost->slug     = makeSlug($objPost->title, $table, $field = 'id', $whereCol = 'slug', $extra = 'url', $id);
				$db->update($table,(array)$objPost,array('id'=>$id));
				//adding tags for service
				$db->delete('tbl_service_tags',array('serviceId'=>$id));
				if($tags != ''){
					$i = 0;
					$insArray = array();
					foreach (explode(',',$tags) as $key => $value){
						$value = trim($value);
						$check = $db->pdoQuery("SELECT id FROM tbl_tags WHERE tagName = ? LIMIT 1 ",array($value));
						if($check->affectedRows() > 0){
							$check_d = $check->result();
							$insArray[] = array(
								'serviceId'			=>$id,
								'tagId'				=>$check_d['id'],
								'createdDate'		=>date("Y-m-d H:i:s")
							);
						}
						else{
							$tid = $db->insert('tbl_tags',array('tagName'=>$value,'createdDate'=>date('Y-m-d H:i:s')))->getLastInsertId();
							$insArray[] = array(
								'serviceId'			=>$id,
								'tagId'				=>$tid,
								'createdDate'		=>date("Y-m-d H:i:s")
							);
						}
						if($i == 500){
							$db->insertBatch('tbl_service_tags',$insArray,true);
							$insArray = array();
						}
						$i = ($i == 500 ? 0 : $i);
						$i++;
					}
					if(!empty($insArray)){
						$db->insertBatch('tbl_service_tags',$insArray,true);
						$insArray = array();
					}
				}
				//adding tags for service

				$activity_array = array("id"=>$id,"module"=>$module,"activity"=>'edit');
				add_admin_activity($activity_array);
				$response['status'] = true;
				$response['data'] =  array('id'=>$id,'form_no'=>2);
	            $response['success'] =  'Record has been updated successfully.';
	            echo json_encode($response);
	            exit;
			}
			else{
				$response['status'] = false;
	            $response['error'] =  "Please fill all values properly.";
	            echo json_encode($response);
	            exit;
			}
		}else{
			$response['status'] = false;
            $response['error'] =  "You don't have permission to perform this action.";
            echo json_encode($response);
            exit;
		}
	} else {
		$response['status'] = false;
        $response['error'] =  "Something went wrong please try agina later.";
        echo json_encode($response);
        exit;
	}
}
else if(isset($_POST["submitAddForm"]) && $_SERVER["REQUEST_METHOD"] == "POST" && $_POST["action"] == "secondStepSubmit"){
	extract($_POST);
	$response = array();
    $response['status'] = false;
    $response['data'] =  array('id'=>$id,'form_no'=>2);
	$description     	= isset($description) ? $description : array();	
	$deliveryDays     	= isset($deliveryDays) ? $deliveryDays : array();
	$price     			= isset($price) ? $price : array();
	$extraService     	= isset($extraService) ? $extraService : array();
	$extraServicePrice = isset($extraServicePrice) ? $extraServicePrice : array();
	$updatedDate 	= date('Y-m-d H:i:s');
	$isAdminEdited = 'y';
	$adminEditedDate = date('Y-m-d H:i:s');
	if($type == 'edit' && $id > 0){
		if(in_array('edit',$Permission)){
			if(count($description) > 0){
				foreach ($description as $key => $value){
					$check = $db->pdoQuery("SELECT id FROM tbl_service_packages WHERE serviceId = ? AND packageId = ? ",array($id,$key));
					$extraServicePrice[$key] = ($extraServicePrice[$key] > 0) ? $extraServicePrice[$key] : 0;
					$inserArray = array(
						'description'		=>filtering($description[$key],'input','text'),
						'deliveryDays'		=>filtering($deliveryDays[$key],'input','int'),
						'price'				=>strval(filtering($price[$key],'input','float')),
						'updatedDate'		=>date('Y-m-d H:i:s')
					);
					if($extraService[$key] != ''){
						$inserArray['extraService'] = filtering($extraService[$key],'input','string');
						$inserArray['extraServicePrice'] =strval(filtering($extraServicePrice[$key],'input','float'));
					}
					if($check->affectedRows() > 0){
						$db->update('tbl_service_packages',(array)$inserArray,array('serviceId'=>$id,'packageId'=>$key));
					}
					else{
						$inserArray['serviceId'] = $id;
						$inserArray['createdDate'] = date('Y-m-d H:i:s');
						$inserArray['packageId'] = $key;
						$db->insert('tbl_service_packages',(array)$inserArray);
					}
				}
				$db->update('tbl_services',array('isAdminEdited'=>'y','adminEditedDate'=>date('Y-m-d H:i:s')),array('id'=>$id));
				$response['status'] = true;
				$response['data'] =  array('id'=>$id,'form_no'=>3);
	            $response['success'] =  "Packages details updated successfully.";
	            echo json_encode($response);
	            exit;
			}
			else{
				$response['status'] = false;
	            $response['error'] =  "Please enter atleast one package details.";
	            echo json_encode($response);
	            exit;
			}
		}
		else{
			$response['status'] = false;
            $response['error'] =  "You don't have permission to perform this action.";
            echo json_encode($response);
            exit;
		}
	}
	else{
		$response['status'] = false;
        $response['error'] =  "Something went wrong please try agina later.";
        echo json_encode($response);
        exit;
	}
}
else if(isset($_POST["submitAddForm"]) && $_SERVER["REQUEST_METHOD"] == "POST" && $_POST["action"] == "thirdStepSubmit"){
	extract($_POST);
	$response = array();
    $response['status'] = false;
    $response['data'] = array('id'=>0,'form_no'=>3);
	$question     	= isset($question) ? $question : array();	
	$answer     	= isset($answer) ? $answer : array();
	$updatedDate 	= date('Y-m-d H:i:s');
	$isAdminEdited = 'y';
	$adminEditedDate = date('Y-m-d H:i:s');
	if($type == 'edit' && $id > 0){
		if(in_array('edit',$Permission)){
			if(count($question) > 0){
				$remaning_faq = array();
				foreach ($question as $key => $value){
					$check = $db->pdoQuery("SELECT id FROM tbl_service_faq WHERE serviceId = ? AND id = ? ",array($id,$key));
					$question_in = filtering($question[$key],'input','text');
                	$answer_in = filtering($answer[$key],'input','text');
					$inserArray = array(
						'question'		=>$question_in,
						'answer'		=>$answer_in,
						'updatedDate'	=>date('Y-m-d H:i:s')
					);
					if($check->affectedRows() > 0){
						$db->update('tbl_service_faq',(array)$inserArray,array('serviceId'=>$id,'id'=>$key));
						$remaning_faq[] = $key;
					}
					else{
						$inserArray['serviceId'] = $id;
						$inserArray['createdDate'] = date('Y-m-d H:i:s');
						$fid = $db->insert('tbl_service_faq',(array)$inserArray)->getLastInsertId();
						$remaning_faq[] = $fid;
					}
				}
				//removing other faqs
	            if(count($remaning_faq) > 0){
	                $remaning_faq_list = implode(',',$remaning_faq);
	                $db->pdoQuery("DELETE FROM tbl_service_faq WHERE id NOT IN (".$remaning_faq_list.") ");
	            }
	            //removing other faqs
			}
			else{
				$db->delete('tbl_service_faq',array('serviceId'=>$id));
			}
			$db->update('tbl_services',array('isAdminEdited'=>'y','adminEditedDate'=>date('Y-m-d H:i:s')),array('id'=>$id));
			$response['status'] = true;
			$response['data'] = array('id'=>$id,'form_no'=>4);
            $response['success'] =  "Faq details has been updated successfully.";
            echo json_encode($response);
            exit;
		}
		else{
			$response['status'] = false;
            $response['error'] =  "You don't have permission to perform this action.";
            echo json_encode($response);
            exit;
		}
	}
	else{
		$response['status'] = false;
        $response['error'] =  "Something went wrong please try agina later.";
        echo json_encode($response);
        exit;
	}
}
else if(isset($_POST["submitAddForm"]) && $_SERVER["REQUEST_METHOD"] == "POST" && $_POST["action"] == "forthStepSubmit"){
	extract($_POST);
	$response = array();
    $response['status'] = false;
    $response['data'] = array('id'=>0,'form_no'=>4,'requirementId'=>0);
	$requirementId     	= isset($requirementId) ? $requirementId : 0;	
	$requirement     	= isset($requirement) ? trim($requirement) : '';	
	$select_type     	= isset($select_type) ? trim($select_type) : '';
	$text     			= isset($text) ? trim($text) : '';
	$mul_text     			= isset($mul_text) ? $mul_text : array();
	$updatedDate 	= date('Y-m-d H:i:s');
	if($type == 'edit' && $id > 0 && $requirementId > 0){
		if(in_array('edit',$Permission)){
			if($requirement != '' && $select_type != ''){
				$file_name = '';
				//upload file
	            if($select_type == 'f' && isset($_FILES['file']) && isset($_FILES['file']['name']) && $_FILES['file']['name'] !=''){
	                $imageName = $_FILES['file']['name'];
	                $tmp_name  = $_FILES['file']['tmp_name'];
	                $imageType = $_FILES['file']['type'];
	                $imageSize = $_FILES['file']['size'];
	                $error     = $_FILES['file']['error'];
	                if($error == 0){
	                    $upload_dir = DIR_UPD.'services/'.$id.'/';
	                    if(!file_exists($upload_dir)){
	                        mkdir($upload_dir,0755);
	                    }
	                    $ext        = '.'.strtolower(getExt($imageName));
	                    $file_name = $newName    = rand().time().$ext;
	                    move_uploaded_file($tmp_name, $upload_dir.$newName);
	                }
	            }
	            else{
	                if($requirementId > 0){
	                    $file_name = getTableValue('tbl_service_requirement','file',array('serviceId'=>$id));
	                }
	            }
	            //upload file
				$updateArray = array(
					'requirement'	=>$requirement,
					'type'			=>$select_type,
					'text'			=>($select_type == 'fr' ? $text : ''),
					'file'			=>($select_type == 'f' ? $file_name : '') 
				);
				$db->update('tbl_service_requirement',$updateArray,array('serviceId'=>$id));
				if($select_type == 'm' && count($mul_text) > 0){
					foreach ($mul_text as $key => $value){
						$check = $db->pdoQuery("SELECT id FROM tbl_service_requirement_list WHERE id = ? AND requirementId = ?  ",array($key,$requirementId));
						$inserArray = array(
							'text'		=>trim($mul_text[$key]),
							'updatedDate'	=>date('Y-m-d H:i:s')
						);
						if($check->affectedRows() > 0){
							$db->update('tbl_service_requirement_list',(array)$inserArray,array('requirementId'=>$requirementId,'id'=>$key));
						}
						else{
							$inserArray['requirementId'] = $requirementId;
							$inserArray['createdDate'] = date('Y-m-d H:i:s');
							$db->insert('tbl_service_requirement_list',(array)$inserArray);
						}
					}
				}
				else{
					$db->delete('tbl_service_requirement_list',array('requirementId'=>$requirementId));
				}
				$db->update('tbl_services',array('isAdminEdited'=>'y','adminEditedDate'=>date('Y-m-d H:i:s')),array('id'=>$id));
				$response['status'] = true;
				$response['data'] = array('id'=>$id,'form_no'=>5,'requirementId'=>$requirementId);
	            $response['success'] =  "Requirement details has been updated successfully.";
	            echo json_encode($response);
	            exit;
			}
			else{
				$response['status'] = false;
	            $response['error'] =  "Please fill all values properly.";
	            echo json_encode($response);
	            exit;
			}
		}
		else{
			$response['status'] = false;
            $response['error'] =  "You don't have permission to perform this action.";
            echo json_encode($response);
            exit;
		}
	}
	else{
		$response['status'] = false;
        $response['error'] =  "Something went wrong please try agina later.";
        echo json_encode($response);
        exit;
	}
}
else if(isset($_POST["submitAddForm"]) && $_SERVER["REQUEST_METHOD"] == "POST" && $_POST["action"] == "fifthStepSubmit"){
	extract($_POST);
	$response = array();
    $response['status'] = false;
    $response['data'] = array('id'=>0,'form_no'=>5);
    if($type == 'edit' && $id > 0){
		if(in_array('edit',$Permission)){

			$filesToKeep = array();
	        $gallery_data = $db->pdoQuery("SELECT id,fileName FROM tbl_service_gallery WHERE serviceId = ? ",array($id))->results();
	        foreach ($gallery_data as $key => $value){
	            $hidden_name = 'hiddenImgfile_'.$value['id'];
	            if(isset($_POST[$hidden_name]) && $_POST[$hidden_name] != ''){
	                $filesToKeep[] = $_POST[$hidden_name];
	            }
	            else{
	                //deleting other files
	                $db->delete('tbl_service_gallery',array('id'=>$value['id']));
	                $data_array = array('type'=>'services','path'=>$id.'/','fileName'=>$value['fileName']);
	                deletefile($data_array);
	                //deleting other files       
	            }
	        }
			if(count($_FILES)){
		    	foreach ($_FILES as $key => $value){
		    		$hidden_name = 'hiddenImg'.$key;
		    		if(isset($_POST[$hidden_name]) && $_POST[$hidden_name] != ''){
		    			$upload_dir = $id.'/';
		    			$filesToKeep[] =$_POST[$hidden_name];
		    			uploadImagewithResize($upload_dir,$_POST[$hidden_name],'services');
		    			$db->insert('tbl_service_gallery',array('serviceId'=>$id,'fileType'=>'i','fileName'=>$_POST[$hidden_name],'creadtedDate'=>date('Y-m-d H:i:s')));
		    		}
		    		else{
		    			$imageType = $_FILES[$key]['type'];
		    			if($imageType == 'video/mp4' || $imageType == 'video/ogg' || $imageType == 'video/webm'){
		    				$imageName = $_FILES[$key]['name'];
				            $ext = '.'.strtolower(getExt($imageName));
				            $newName = rand().time().$ext;
			    			$upload_dir = DIR_UPD.'services/'.$id.'/';
			    			$filesToKeep[] = $newName;
			    			move_uploaded_file($_FILES[$key]["tmp_name"],$upload_dir.$newName);
			    			$db->insert('tbl_service_gallery',array('serviceId'=>$id,'fileType'=>'v','fileName'=>$newName,'creadtedDate'=>date('Y-m-d H:i:s')));
		    			}
		    		}
		    	}	
		    	$data_array = array('type'=>'services','path'=>'temp_dir/'.$id.'/','filesToKeep'=>array()); 
				deletefile($data_array);
		    }
		    if(count($filesToKeep) <= 0){
	            $response['status'] = false;
	            $response['error'] =  "Please select atleast one gallery file for service.";
	            echo json_encode($response);
	            exit;
	        }
	        else{
	        	$db->update('tbl_services',array('isAdminEdited'=>'y','adminEditedDate'=>date('Y-m-d H:i:s')),array('id'=>$id));
	        	$response['status'] = true;
	        	$return['data'] = array('id'=>$id,'form_no'=>5);
	            $response['success'] =  "Service has been edited successfully.";
	            echo json_encode($response);
	            exit;
	        }
		}
		else{
			$response['status'] = false;
            $response['error'] =  "You don't have permission to perform this action.";
            echo json_encode($response);
            exit;
		}
	}
	else{
		$response['status'] = false;
        $response['error'] =  "Something went wrong please try agina later.";
        echo json_encode($response);
        exit;
	}
}else{}

$objCategory = new ManageServices($id);
$pageContent = $objCategory->getPageContent();

require_once(DIR_ADMIN_TMPL."parsing-nct.tpl.php");