<?php

class SubAdmin extends Home {

    public $data = array();

    public function __construct($module, $id = 0, $objPost = NULL, $searchArray = array(), $type = '') {
        global $db, $fields, $sessCataId;
        $this->db = $db;
        $this->data['id'] = $this->id = $id;
        $this->fields = $fields;
        $this->module = $module;
        $this->table = 'tbl_admin';

        $this->type = ($this->id > 0 ? 'edit' : 'add');
        $this->searchArray = $searchArray;
        parent::__construct();
        if ($this->id > 0) {
            $query = "SELECT a.*
                    FROM tbl_admin a
                    WHERE a.id = '" . $this->id . "' ";

            $qrySel = $this->db->pdoQuery($query)->result();

            $fetchRes = $qrySel;

            $this->data['uName'] = $this->uName = filtering($fetchRes['uName']);
            $this->data['uEmail'] = $this->uEmail = filtering($fetchRes['uEmail']);
            $this->data['isActive'] = $this->isActive = $fetchRes['isActive'];
        } else {
            $this->data['uName'] = $this->uName = '';
            $this->data['uEmail'] = $this->uEmail = '';
            $this->data['lastName'] = $this->lastName = '';
            $this->data['isActive'] = $this->isActive = 'a';
        }
        switch ($type) {
            case 'add' : {
                    $this->data['content'] = (in_array('add', $this->Permission)) ? $this->getForm() : '';
                    break;
                }
            case 'edit' : {
                    $this->data['content'] = (in_array('edit', $this->Permission)) ? $this->getForm() : '';
                    break;
                }
            case 'view' : {
                    $this->data['content'] = (in_array('view', $this->Permission)) ? $this->viewForm() : '';
                    break;
                }
            case 'delete' : {
                    $this->data['content'] = (in_array('delete', $this->Permission)) ? json_encode($this->dataGrid()) : '';
                    break;
                }
            case 'datagrid' : {
                    $this->data['content'] = (in_array('module', $this->Permission)) ? json_encode($this->dataGrid()) : '';
                }
        }
    }

    public function viewForm() {
        $content = /*$this->displayBox(array("label" => "User Type&nbsp;:", "value" => $this->user_type)) .*/
                $this->displayBox(array("label" => "First Name&nbsp;:", "value" => $this->uName)) .
                $this->displayBox(array("label" => "Email&nbsp;:", "value" => $this->uEmail)) .
                $this->displayBox(array("label" => "Status&nbsp;:", "value" => $this->isActive == 'a' ? 'Active' : 'Deactive'));
        return $content;
    }

    public function getForm() {
        $module_list = $content = '';

        $getSelectBoxOption = $this->getSelectBoxOption();
        $fields = array("%VALUE%", "%SELECTED%", "%DISPLAY_VALUE%");

        $main_content = new MainTemplater(DIR_ADMIN_TMPL . $this->module . "/form-nct.tpl.php");
        $main_content = $main_content->parse();
        $status_a = ($this->isActive == 'a' ? 'checked' : '');
        $status_d = ($this->isActive != 'a' ? 'checked' : '');
        /*get list of module*/
        $getModuleList = $this->db->pdoQuery("SELECT * FROM tbl_adminrole WHERE status = 'a' ORDER BY `title` ASC")->results();
        foreach ($getModuleList as $key => $moduleRes) {
            /*parse html*/
            $permission_html = new MainTemplater(DIR_ADMIN_TMPL . $this->module . "/permission_html-nct.tpl.php");
            $permission_html = $permission_html->parse();
            $permission_fields = array("%MODULE_NAME%","%PERMISSION_LIST%","%MODULE_ID%");

            /*get permission list*/
            $permission_list = "";
            $getPermissionList = $this->db->pdoQuery("SELECT * FROM tbl_subadmin_action")->results();

            foreach ($getPermissionList as $key => $permissionRes) {
                if(!in_array($permissionRes['id'], explode(',',$moduleRes['page_permission']))){
                    continue;
                }
                $permission_chkbox = new MainTemplater(DIR_ADMIN_TMPL . $this->module . "/permission_checkbox-nct.tpl.php");
                $permission_chkbox = $permission_chkbox->parse();
                $permission_chk_fields = array("%PERMISSION_ID%","%MODULE_ID%","%IS_CHECKED%","%PERMISSION_NAME%");

                /*get if is checked*/
                $getVal = $this->db->pdoQuery("SELECT id FROM tbl_admin_permission WHERE admin_id = ? AND page_id = ? AND FIND_IN_SET(?,permission)",array($this->id,$moduleRes['id'],$permissionRes['id']))->affectedRows();

                $checked = $getVal > 0 ? "checked" : "";
                $permission_chk_fields_replace = array($permissionRes['id'],$moduleRes['id'],$checked,$permissionRes['title']);
                $permission_list .= str_replace($permission_chk_fields, $permission_chk_fields_replace, $permission_chkbox);
            }
            $permission_fields_replace = array($moduleRes['title'],$permission_list,$moduleRes['id']);

            $module_list .= str_replace($permission_fields, $permission_fields_replace, $permission_html);

        }
        $fields = array(
            "%USER_NAME%",
            "%EMAIL_ADDRESS%",
            "%STATUS_A%",
            "%STATUS_D%",
            "%MODULE_LIST%",
            "%TYPE%",
            "%ID%"
        );

        $fields_replace = array(
            $this->data['uName'],
            $this->data['uEmail'],
            $status_a,
            $status_d,
            $module_list,
            $this->type,
            $this->id
        );

        $content = str_replace($fields, $fields_replace, $main_content);
        return filtering($content, 'output', 'text');
    }

    public function dataGrid() {
        $content = $operation = $whereCond = $totalRow = NULL;
        $result = $tmp_rows = $row_data = array();
        extract($this->searchArray);

        $chr = str_replace(array('_', '%'), array('\_', '\%'), $chr);

        //$whereCond = ' where  status!=\'a\'';
            $aWhere[] = "%$chr%";
            $aWhere[] = "%$chr%";
            $aWhere[] = "%$chr%";
        if (isset($chr) && $chr != '') {

            $whereCond .= " ";
        }


        if (isset($sort)) {
            $sorting = $sort . ' ' . $order;
        } else {
            $sorting = 'id DESC';
        }

        $query = "SELECT a.*
                    FROM tbl_admin a WHERE adminType = 'g'
                    AND (uName LIKE ?  OR uEmail LIKE ? OR DATE_FORMAT(created_date, '" . MYSQL_DATE_FORMAT . "') LIKE ?) ORDER BY " . $sorting;

        $query_with_limit = $query . " LIMIT " . $offset . " ," . $rows . " ";

        $totalUsers = $this->db->pdoQuery($query, $aWhere)->results();

        $qrySel = $this->db->pdoQuery($query_with_limit, $aWhere)->results();
        $totalRow = count($totalUsers);

        foreach ($qrySel as $fetchRes) {
            $status = ($fetchRes['isActive'] == "a") ? "checked" : "";
            $operation = '';

            $switch = (in_array('status', $this->Permission)) ? $this->toggel_switch(array("action" => "ajax." . $this->module . ".php?id=" . $fetchRes['id'] . "", "check" => $status)) : '';

            $operation .= (in_array('edit', $this->Permission)) ? $this->operation(array("href" => "ajax." . $this->module . ".php?action=edit&id=" . $fetchRes['id'] . "", "class" => "btn default btn-xs black btnEdit", "value" => '<i class="fa fa-edit"></i>&nbsp;Edit')) : '';
            $operation .=(in_array('delete', $this->Permission)) ? '&nbsp;&nbsp;' . $this->operation(array("href" => "ajax." . $this->module . ".php?action=delete&id=" . $fetchRes['id'] . "", "class" => "btn default btn-xs red btn-delete", "value" => '<i class="fa fa-trash-o"></i>&nbsp;Delete')) : '';

            $operation .=(in_array('view', $this->Permission)) ? '&nbsp;&nbsp;' . $this->operation(array("href" => "ajax." . $this->module . ".php?action=view&id=" . $fetchRes['id'] . "", "class" => "btn default blue btn-xs btn-viewbtn", "value" => '<i class="fa fa-laptop"></i>&nbsp;View')) : '';

            $uName = (isset($fetchRes["uName"]) && $fetchRes["uName"] != '') ? $fetchRes["uName"] : 'N/A';
            $uEmail = (isset($fetchRes["uEmail"]) && $fetchRes["uEmail"] != '') ? $fetchRes["uEmail"] : 'N/A';

            $final_array = array(
                filtering($fetchRes['id'], 'output', 'int'),
                filtering($uName),
                filtering($uEmail),
                date('d-m-Y',strtotime($fetchRes['created_date']))
            );
            if (in_array('status', $this->Permission)) {
                $final_array = array_merge($final_array, array($switch));
            }
            if (in_array('edit', $this->Permission) || in_array('delete', $this->Permission) || in_array('view', $this->Permission)) {
                $final_array = array_merge($final_array, array($operation));
            }
            //echo "<pre>";print_r($final_array);exit;
            $row_data[] = $final_array;
        }

        $result["sEcho"] = $sEcho;
        $result["iTotalRecords"] = (int) $totalRow;
        $result["iTotalDisplayRecords"] = (int) $totalRow;
        $result["aaData"] = $row_data;
        return $result;
    }

    public function displaybox($text) {

        $text['label'] = isset($text['label']) ? $text['label'] : 'Enter Text Here: ';
        $text['value'] = isset($text['value']) ? $text['value'] : '';
        $text['name'] = isset($text['name']) ? $text['name'] : '';
        $text['class'] = isset($text['class']) ? 'form-control-static ' . trim($text['class']) : 'form-control-static';
        $text['onlyField'] = isset($text['onlyField']) ? $text['onlyField'] : false;
        $text['extraAtt'] = isset($text['extraAtt']) ? $text['extraAtt'] : '';

        $main_content = new MainTemplater(DIR_ADMIN_TMPL . $this->module . '/displaybox.tpl.php');
        $main_content = $main_content->parse();
        $fields = array("%LABEL%", "%CLASS%", "%VALUE%");
        $fields_replace = array($text['label'], $text['class'], $text['value']);
        return str_replace($fields, $fields_replace, $main_content);
    }

    public function getSelectBoxOption() {
        $content = '';
        $main_content = new MainTemplater(DIR_ADMIN_TMPL . $this->module . "/select_option-nct.tpl.php");
        $content.= $main_content->parse();
        return sanitize_output($content);
    }

    public function toggel_switch($text) {
        $text['action'] = isset($text['action']) ? $text['action'] : 'Enter Action Here: ';
        $text['check'] = isset($text['check']) ? $text['check'] : '';
        $text['name'] = isset($text['name']) ? $text['name'] : '';
        $text['class'] = isset($text['class']) ? '' . trim($text['class']) : '';
        $text['extraAtt'] = isset($text['extraAtt']) ? $text['extraAtt'] : '';

        $main_content = new MainTemplater(DIR_ADMIN_TMPL . $this->module . '/switch-nct.tpl.php');
        $main_content = $main_content->parse();
        $fields = array("%NAME%", "%CLASS%", "%ACTION%", "%EXTRA%", "%CHECK%");
        $fields_replace = array($text['name'], $text['class'], $text['action'], $text['extraAtt'], $text['check']);
        return str_replace($fields, $fields_replace, $main_content);
    }

    public function operation($text) {

        $text['href'] = isset($text['href']) ? $text['href'] : 'Enter Link Here: ';
        $text['value'] = isset($text['value']) ? $text['value'] : '';
        $text['name'] = isset($text['name']) ? $text['name'] : '';
        $text['class'] = isset($text['class']) ? '' . trim($text['class']) : '';
        $text['extraAtt'] = isset($text['extraAtt']) ? $text['extraAtt'] : '';
        $main_content = new MainTemplater(DIR_ADMIN_TMPL . $this->module . '/operation-nct.tpl.php');
        $main_content = $main_content->parse();
        $fields = array("%HREF%", "%CLASS%", "%VALUE%", "%EXTRA%");
        $fields_replace = array($text['href'], $text['class'], $text['value'], $text['extraAtt']);
        return str_replace($fields, $fields_replace, $main_content);
    }

    public function getPageContent() {
        $final_result = NULL;
        $main_content = new MainTemplater(DIR_ADMIN_TMPL . $this->module . "/" . $this->module . ".tpl.php");
        $main_content->breadcrumb = $this->getBreadcrumb();

        $main_content_parsed = $final_result = $main_content->parse();

        $fields = array(
            "%VIEW_ALL_RECORDS_BTN%"
        );

        $view_all_records_btn = '';
        if (( isset($_GET['day']) && $_GET['day'] != '' ) || ( isset($_GET['month']) && $_GET['month'] != '' ) || ( isset($_GET['year']) && $_GET['year'] != '' )) {
            $view_all_records_btn = $this->getViewAllBtn();
        }

        $fields_replace = array(
            $view_all_records_btn
        );

        $final_result = str_replace($fields, $fields_replace, $main_content_parsed);

        return $final_result;
    }

}
