<?php
class BlogsDetail {
	function __construct($contentArray=array()) {
		foreach ($GLOBALS as $key => $values) {
			$this->$key = $values;

		}
		extract($contentArray);
		$this->module = $module;
		$this->slug = issetor($slug);

	}
	public function getPageContent($request = array()) {
		$content = "";
		$this->updateView();
		$blog = $this->db->pdoQuery("SELECT * FROM tbl_blog WHERE isActive = 'y' AND slug = ?",array($this->slug));
		if($blog->affectedRows() > 0){
			$blogData = $blog->result();
			$tplUrl = DIR_TMPL . $this->module . "/" . $this->module . ".tpl.php";


			$id = $blogData['id'];
			$blogTitle = filtering($blogData['title_'.$this->lId]);
			$blogDetail = $blogData['detail_'.$this->lId];
			$blogImg = checkImage($blogData['blogImage'],10,$id);
			$createdDate = convertDate($blogData['createdDate']);
			$url = SITE_URL.'blog-detail/'.$this->slug;
			$blogComment = $this->getBlogComment($id);

			$blogCommentForm = $this->getBlogCommentForm($id);;

			$ogData['title'] = $blogTitle;
			$ogData['detail'] = $blogDetail;
			$ogData['blogImage'] = $blogImg;
			if($this->sessRequestType == 'web'){
				$hideShowClass = 'hide';
				$show = getTableValue('tbl_blog_comments','id',array('blogId'=>$id));
				$totalComment = $this->db->pdoQuery("SELECT * FROM tbl_blog_comments WHERE blogId = ? AND parentId = 0",array($id))->affectedRows();
				if($show > 0){
					$hideShowClass = "";
				}
				$replaceArr = array(
									'%BLOG_LINK%' => $url,
									'%BLOG_TITLE_FULL%' => $blogTitle,
									'%BLOG_TITILE%' => myTruncate($blogTitle,30),
									'%BLOG_DATE%' => $createdDate,
									'%BLOG_IMG%' => $blogImg,
									'%BLOG_DETAIL%' => $blogDetail,
									'%TOTAL_COMMENT%'=>$totalComment,
									'%BLOG_COMMENT%' => $blogComment,
									'%BLOG_COMMENT_FORM%' => $blogCommentForm,
									'%BLOG_COMMENT_DIV_HIDE_SHOW%' => $hideShowClass,
								);
				$content = get_view($tplUrl,$replaceArr);
			}
			$returnContent['html'] = $content;
			$returnContent['ogData'] = $ogData;
			$returnResponse = array(
									'status' => true,
									'message'=> '',
									'data'=> $returnContent,
								);
		}else{
			$returnResponse = array(
									'status' => false,
									'message'=> MSG_SOMETHING_WRONG,
									'data'=> array(),
								);
		}
		return $returnResponse;
	}
	public function updateView($value=''){
		$getId = getTableValue('tbl_blog','id',array('slug'=>$this->slug));
		$ipAddress = get_ip_address();

		if($getId > 0){
			$isViewed = getTableValue('tbl_blog_view','id',array('blogId'=>$getId,'ipAddress'=>$ipAddress));
			if($isViewed <= 0){
				$insArr['blogId'] = $getId;
				$insArr['ipAddress'] = $ipAddress;
				$this->db->insert('tbl_blog_view',$insArr);
			}
		}else{
			$msgType = $_SESSION["msgType"] = disMessage(array('type'=>'err','var'=>MSG_SOMETHING_WRONG));
			redirectPage(SITE_URL.'blogs/');

		}
	}

	public function getBlogComment($blogId = 0){
		$returnResponse = '';
		$data = "";
		if($blogId > 0){
			$blogComment = $this->db->pdoQuery("SELECT bc.*,u.userName,u.profileImage FROM tbl_blog_comments AS bc INNER JOIN tbl_users AS u ON u.id = bc.userId WHERE bc.isActive = 'y' AND u.isActive ='y' AND bc.parentId = 0 AND bc.blogId = ?  ORDER BY bc.id DESC",array($blogId));
			if($blogComment->affectedRows() > 0){
				$comments = $blogComment->results();
				foreach ($comments as $key => $commentValue) {
					$commentId = $commentValue['id'];
					$userId = $commentValue['userId'];
					$blogId = $commentValue['blogId'];
					$blogComment = filtering($commentValue['blogComment']);
					$createdDate = convertDate($commentValue['createdDate']);
					$userName = filtering($commentValue['userName']);
					$profileImage = checkImage($commentValue['profileImage'],9,$userId);

					$blogCommentReply = $this->getBlogCommentReply($commentId);
					$blogCommentReplyForm = $this->getBlogCommentReplyForm($commentId);

					$likeCount = $this->db->pdoQuery("SELECT id FROM tbl_blog_comments_like  WHERE commentId = ?",array($commentId))->affectedRows();
					$replyCount = $this->db->pdoQuery("SELECT id FROM tbl_blog_comments  WHERE parentId = ?",array($commentId))->affectedRows();

					$liked = "like_action";
					$isLiked = getTableValue('tbl_blog_comments_like','id',array('commentId'=>$commentId,'userId'=>$this->sessUserId));
					if($isLiked > 0){
						$liked = "liked";
					}
					if($this->sessUserId <= 0){
						$liked = "";
					}
					if($this->sessRequestType == 'web'){
						$tplUrl = DIR_TMPL . $this->module . "/single-comment-nct.tpl.php";

						$replaceArr = array(

									'%PROFILE_URL%' => SITE_URL,
									'%PROFILE_PHOTO%' => $profileImage,
									'%USER_NAME%' => $userName,
									'%COMMENT%' => $blogComment,
									'%COMMENT_DATE%' => $createdDate,
									'%LIKE_COUNT%' => $likeCount,
									'%LIKED%'=>$liked,
									'%COMMENT_ID%'=>$commentId,
									'%REPLY_COUNT%' => $replyCount,
									'%BLOG_COMMENT_REPLY%' => $blogCommentReply,
									'%BLOG_COMMENT_REPLY_FORM%' => $blogCommentReplyForm,
								);
						$returnResponse .= get_view($tplUrl,$replaceArr);
					}else{
						$returnResponse = array(
									'status' => true,
									'message'=> '',
									'data'=> $data,
								);
					}
				}

			}

		}else{
			$returnResponse = array(
								'status' => false,
								'message'=> MSG_SOMETHING_WRONG,
								'data'=> array(),
							);
		}
		return $returnResponse;
	}

	public function getBlogCommentForm($blogId = 0){
		$content = "";
		if($this->sessUserId > 0){
			$tplUrl = DIR_TMPL . $this->module . "/blog-comment-form-nct.tpl.php";

			$replaceArr = array(
						'%BLOGID%' => $blogId,
					);
			$content = get_view($tplUrl,$replaceArr);
		}
		return $content;
	}
	public function getBlogCommentReply($commentId = 0){
		$data = "";
		$blogReply = $this->db->pdoQuery("SELECT bc.*,u.userName,u.profileImage FROM tbl_blog_comments AS bc INNER JOIN tbl_users AS u ON u.id = bc.userId WHERE bc.isActive = 'y' AND u.isActive ='y' AND bc.parentId = ? ORDER BY bc.id ASC",array($commentId));
			if($blogReply->affectedRows() > 0){
				$reply = $blogReply->results();
				foreach ($reply as $key => $commentReplyValue) {
					$commentId = $commentReplyValue['id'];
					$userId = $commentReplyValue['userId'];
					$blogId = $commentReplyValue['blogId'];
					$blogComment = filtering($commentReplyValue['blogComment']);
					$createdDate = convertDate($commentReplyValue['createdDate']);
					$userName = filtering($commentReplyValue['userName']);
					$profileImage = checkImage($commentReplyValue['profileImage'],9,$userId);

					if($this->sessRequestType == 'web'){
						$tplUrl = DIR_TMPL . $this->module . "/blog-comment-reply-nct.tpl.php";

						$replaceArr = array(
									'%PROFILE_URL%' => SITE_URL,
									'%PROFILE_PHOTO%' => $profileImage,
									'%USER_NAME%' => $userName,
									'%REPLY%' => $blogComment,
									'%REPLY_DATE%' => $createdDate,
								);
						$data .= get_view($tplUrl,$replaceArr);
					}else{

					}
				}
				if($this->sessRequestType == 'web'){
					return $data;
				}else{
					$returnResponse = array(
									'status' => true,
									'message'=> '',
									'data'=> $appData,
								);
				}
			}else{
				return $data;
			}
			return $returnResponse;
	}
	public function getBlogCommentReplyForm($commentId = 0){
		$content = "";
		if($this->sessUserId > 0){
			$tplUrl = DIR_TMPL . $this->module . "/blog-comment-reply-form-nct.tpl.php";

			$replaceArr = array(
						'%PARENT_ID%' => $commentId,
					);
			$content = get_view($tplUrl,$replaceArr);
		}
		return $content;
	}

	public function likeAction($request = array()){
		extract($request);
		$isLiked = getTableValue('tbl_blog_comments_like','id',array('commentId'=>$commentId,'userId'=>$this->sessUserId));
		if($isLiked <= 0){
			$createdDate = date('Y-m-d H:i:s');
			$ipAddress = get_ip_address();
			$instArr['commentId'] = $commentId;
			$instArr['createdDate'] = $createdDate;
			$instArr['ipAddress'] = $ipAddress;
			$instArr['userId'] = $this->sessUserId;
			$this->db->insert('tbl_blog_comments_like',$instArr);

			$likeCount = $this->db->pdoQuery("SELECT id FROM tbl_blog_comments_like  WHERE commentId = ?",array($commentId))->affectedRows();

			$returnResponse = array(
							'redirectLink' 	=> SITE_URL,
							'status'		=> true,
							'message'   	=> MSG_YOU_LIKED_THIS_COMMENT,
							'data'  		=> array('likeCount'=>$likeCount));
		}else{
			$returnResponse = array(
							'redirectLink' 	=> SITE_URL,
							'status'		=> true,
							'message'   	=> MSG_YOU_ALREADY_LIKE,
							'data'  		=> array());
		}
		return $returnResponse;
	}

	public function submitCommentForm($request = array()){
		extract($request);
		if($this->sessUserId > 0){

			$createdDate = date('Y-m-d H:i:s');
			$ipAddress = get_ip_address();

			$instArr['blogId'] = $blogId;
			$instArr['userId'] = $this->sessUserId;
			$instArr['blogComment'] = filtering($blogComment,'input');
			$instArr['createdDate'] = $createdDate;
			$instArr['ipAddress'] = $ipAddress;
			$lastId = $this->db->insert('tbl_blog_comments',$instArr)->getLastInsertId();

			if($this->sessRequestType == 'web'){
				$tplUrl = DIR_TMPL . $this->module . "/single-comment-nct.tpl.php";
				$userName = $this->sessUserName;
				$profileImg = getTableValue('tbl_users','profileImage',array('id'=>$this->sessUserId));
				$profileImage = checkImage($profileImg,9,$this->sessUserId);
				$liked = "like_action";
				$replyCount = 0;
				$likeCount = 0;
				$blogCommentReply = '';
				$blogCommentReplyForm = $this->getBlogCommentReplyForm($lastId);
				$replaceArr = array(

							'%PROFILE_URL%' => SITE_URL,
							'%PROFILE_PHOTO%' => $profileImage,
							'%USER_NAME%' => $userName,
							'%COMMENT%' => $blogComment,
							'%COMMENT_DATE%' => convertDate($createdDate),
							'%LIKE_COUNT%' => $likeCount,
							'%LIKED%'=>$liked,
							'%COMMENT_ID%'=>$lastId,
							'%REPLY_COUNT%' => $replyCount,
							'%BLOG_COMMENT_REPLY%' => $blogCommentReply,
							'%BLOG_COMMENT_REPLY_FORM%' => $blogCommentReplyForm,
						);
				$comment = get_view($tplUrl,$replaceArr);
			}else{

			}
			$totalComment = $this->db->pdoQuery("SELECT * FROM tbl_blog_comments WHERE blogId = ? AND parentId = 0",array($blogId))->affectedRows();

			$returnResponse = array(
								'redirectLink' 	=> SITE_URL,
								'status'		=> true,
								'message'   	=> MSG_YOUR_COMMENT_POSTED,
								'data'  		=> array('comment'=>$comment,'totalComment'=>$totalComment));
		}else{

			$returnResponse = array(
								'redirectLink' 	=> SITE_URL,
								'status'		=> false,
								'message'   	=> MSG_PLZ_LOGIN_FIRST,
								'data'  		=> array());
		}
		return $returnResponse;
	}

	public function submitCommentReplyForm($request = array()){
		extract($request);
		if($this->sessUserId > 0){

			$createdDate = date('Y-m-d H:i:s');
			$ipAddress = get_ip_address();
			$instArr['parentId'] = $parentId;
			$instArr['blogId'] = getTableValue('tbl_blog_comments','blogId',array('id'=>$parentId));
			$instArr['userId'] = $this->sessUserId;
			$instArr['blogComment'] = filtering($blogComment,'input');
			$instArr['createdDate'] = $createdDate;
			$instArr['ipAddress'] = $ipAddress;
			$lastId = $this->db->insert('tbl_blog_comments',$instArr)->getLastInsertId();
			$replyCount = $this->db->pdoQuery("SELECT id FROM tbl_blog_comments  WHERE parentId = ?",array($parentId))->affectedRows();
			if($this->sessRequestType == 'web'){
				$tplUrl = DIR_TMPL . $this->module . "/blog-comment-reply-nct.tpl.php";
				$userName = $this->sessUserName;
				$profileImg = getTableValue('tbl_users','profileImage',array('id'=>$this->sessUserId));
				$profileImage = checkImage($profileImg,9,$this->sessUserId);

				$replaceArr = array(
							'%PROFILE_URL%' => SITE_URL,
							'%PROFILE_PHOTO%' => $profileImage,
							'%USER_NAME%' => $userName,
							'%REPLY%' => $blogComment,
							'%REPLY_DATE%' => convertDate($createdDate),
						);
				$comment = get_view($tplUrl,$replaceArr);
			}else{

			}
			$returnResponse = array(
								'redirectLink' 	=> SITE_URL,
								'status'		=> true,
								'message'   	=> MSG_YOUR_COMMENT_POSTED,
								'data'  		=> array('comment'=>$comment,'replyCount'=>$replyCount));
		}else{

			$returnResponse = array(
								'redirectLink' 	=> SITE_URL,
								'status'		=> false,
								'message'   	=> MSG_PLZ_LOGIN_FIRST,
								'data'  		=> array());
		}
		return $returnResponse;
	}


}

?>
