<?php
class AddNewService {
	function __construct($module = "",$id=0,$step='') {
		foreach ($GLOBALS as $key => $values) {
			$this->$key = $values;
		}
		$this->module = $module;
        //edit service
        if($id == 0 && isset($_REQUEST['slug']) &&  $_REQUEST['slug'] != ''){
            $slug = $_REQUEST['slug'];
            $check_id = $this->db->pdoQuery("SELECT id,status FROM tbl_services WHERE userId = ? AND slug = ? LIMIT 1 ",array($this->sessUserId,$slug));
            if($check_id->affectedRows() > 0){
                $check_id_data = $check_id->result();
                if($check_id_data['status'] != 'p'){
                    $msgType = $_SESSION["msgType"] = disMessage(array('type' => 'err','var' =>ADD_SERVICE_PAGE_MSG_CAN_NOT_EDIT_SERVICE));
                    redirectPage(SITE_URL);
                }
                else{
                    $id = $check_id_data['id'];
                }
            }
            else{
                $msgType = $_SESSION["msgType"] = disMessage(array('type' => 'err','var' =>ADD_SERVICE_PAGE_MSG_SERVICE_NOT_FOUND));
                redirectPage(SITE_URL);
            }
        }
        else if($id > 0){
            $check = $this->db->pdoQuery("SELECT id,status FROM tbl_services WHERE userId = ? AND id = ? AND status = ?  LIMIT 1 ",array($this->sessUserId,$id,'p'))->affectedRows();
            if($check <= 0){
                $msgType = $_SESSION["msgType"] = disMessage(array('type' => 'err','var' =>ADD_SERVICE_PAGE_MSG_SERVICE_NOT_FOUND));
                redirectPage(SITE_URL);
            }
        }
        else{}
        //edit service

		$this->id = $id;
		$this->type = ($id > 0 ? 'edit' : 'add');
		$this->step = $step;
		$this->active_step = 0;
        /*$this->id = 171;
        $this->step = 'gallery';*/
		if($this->id > 0){
			if($this->step == 'service-details')
				$this->active_step = 1;
			else if($this->step == 'pricing')
				$this->active_step = 2;
			else if($this->step == 'faq')
				$this->active_step = 3;
			else if($this->step == 'requirements')
				$this->active_step = 4;
			else if($this->step == 'gallery')
				$this->active_step = 5;
			else
				$this->active_step = 1;
		}else{
			$this->active_step = 1;
		}
	}

	public function getPageContent(){
		$content = "";
		$form_content = '';
		if($this->active_step == 1){
            $first = $this->getStep1FormContent();
			$form_content = $first['html'];
        }
		else if($this->active_step == 2){
			$second = $this->getStep2FormContent();
            $form_content = $second['html'];
        }
		else if($this->active_step == 3){
			$third = $this->getStep3FormContent();
            $form_content = $third['html'];
        }
		else if($this->active_step == 4){
			$fourth = $this->getStep4FormContent();
            $form_content = $fourth['html'];
        }
		else if($this->active_step == 5){
			$fifth = $this->getStep5FormContent();
            $form_content = $fifth['html'];
        }
		else {
			$first = $this->getStep1FormContent();
            $form_content = $first['html'];
        }
		$replace = array(
			'%FORM_CONTENT%'=>$form_content
		);
		$content .= get_view(DIR_TMPL . $this->module . "/" . $this->module . ".tpl.php",$replace);
		return $content;
	}

	/*get step 1 details*/
	public function getStep1FormContent($data=array()){
		extract($data);
		$return = array();
		$return['status'] = false;
		$return['redirectLink'] = '';
		$return['message'] = '';
		$return['data'] = array();

        $content = array();

		$q_res = array();
		if($this->id > 0){
			$q = $this->db->pdoQuery("SELECT s.id,s.userId,s.categoryId,s.subCategoryId,s.title,s.slug,s.status,s.isFeatured,s.createdDate,sc.subCategoryName,c.cateName_$this->lId as cateName,u.userName,s.description,s.durationType,s.duration,s.additionalInfo,s.isActive,u.profileImage,u.email,sr.requirement,sr.type as srtype,sr.text,sr.file,sr.id as requirementId
                FROM tbl_services AS s
                INNER JOIN tbl_users AS u ON u.id = s.userId
                LEFT JOIN tbl_categories AS c ON c.id = s.categoryId
                LEFT JOIN tbl_subcategories AS sc ON sc.id = s.subCategoryId
                LEFT JOIN tbl_service_requirement AS sr ON sr.serviceId = s.id
                WHERE s.id = ? AND ( s.status = ? OR s.isActive = ? ) LIMIT 1 ",array($this->id,'p','i'));
			if($q->affectedRows() > 0){
				$q_res = $q->result();
			}
			else{
				$return['message'] = ADD_SERVICE_PAGE_SERVICE_DETAILS_NOT_FOUND;
				$return['status'] = false;
			}
		}
		$title = filtering(issetor($q_res['title'],''));
		$categoryId = issetor($q_res['categoryId'],0);
		$subCategoryId = issetor($q_res['subCategoryId'],0);
		$description = filtering(issetor($q_res['description'],''),'output','text');
		$durationType = filtering(issetor($q_res['durationType'],''));
		$duration = filtering(issetor($q_res['duration'],''));
		$additionalInfo = filtering(issetor($q_res['additionalInfo'],''),'output','text');

        if($this->sessRequestType == 'web'){
            global $js_variables;
            $js_variables .='tags = '.$this->getServiceTags(array('id'=>$this->id,'return_type'=>'json')).';';
            $replace = array(
                '%STEP_PROCESS%'    =>$this->getStepsContent(1),
                '%TITLE%'           =>$title,
                '%CATEGORY_OPT%'    =>$this->getCategorySelection($categoryId),
                '%SUBCATEGORY_OPT%' =>$this->getSubCategorySelection($categoryId,$subCategoryId),
                '%DESCRIPTION%'     =>$description,
                '%DURATION_TYPE_H%' =>($durationType == 'h' ? 'selected="selected"' : ''),
                '%DURATION_TYPE_D%' =>($durationType == 'd' ? 'selected="selected"' : ''),
                '%DURATION_OPT%'    =>$this->getDurationSelection($durationType,$duration),
                '%ADDITIONAL_INFO%' =>$additionalInfo,
                '%TAGS%'            =>$this->getServiceTags(array('id'=>$this->id,'return_type'=>'json')),
                '%SUG_TAGS%'        =>json_encode(array()),
                '%TYPE%'            =>$this->type,
                '%ID%'              =>$this->id,
                '%VIDEO_TAG%'       =>get_view(DIR_TMPL . $this->module . "/video-tag-nct.tpl.php"),
            );
            $content['html'] = get_view(DIR_TMPL . $this->module . "/form-step1-nct.tpl.php",$replace);
            $content['tags'] = $this->getServiceTags(array('id'=>$this->id,'return_type'=>'array'));
        }
        else{
            $return['data'] = array(
                'title'=>$title,
                'categoryId'=>($categoryId > 0 ? $categoryId : 0),
                'subCategoryId'=>($subCategoryId > 0 ? $subCategoryId : 0),
                'description'=>$description,
                'duration'=>$duration,
                'additionalInfo'=>$additionalInfo,
                'durationType'=>($durationType == '' ? 'h' : $durationType),
                'tags'=>$this->getServiceTags(array('id'=>$this->id,'return_type'=>'array')),
                'type'=>$this->type,
                'id'=>$this->id
            );
            $return['status'] = true;
        }
		return getreturnType($return,$content);
	}

    public function firstStepSubmit($data=array()){
        extract($data);
        $return = array();
        $return['status'] = false;
        $return['redirectLink'] = '';
        $return['message'] = '';
        $return['data'] = array('id'=>0,'form_no'=>1);

        $objPost = new stdClass();
        $objPost->title             = filtering(issetor($title,''),'input');
        $objPost->categoryId        = filtering(issetor($categoryId,0),'input','int');
        $objPost->subCategoryId     = filtering(issetor($subCategoryId,0),'input','int');
        $objPost->description       = filtering(issetor($description,''),'input','text');
        $objPost->durationType      = filtering(issetor($durationType,''),'input');
        $objPost->duration          = filtering(issetor($duration,0),'input','int');
        $objPost->additionalInfo    = filtering(issetor($additionalInfo,''),'input','text');

        $objPost->isActive      = 'i';
        $objPost->updatedDate   = date('Y-m-d H:i:s');
        $objPost->ipAddress   = get_ip_address();

        if($objPost->title != '' && $objPost->categoryId != '' && $objPost->subCategoryId != '' && $objPost->description != '' && $objPost->durationType != '' && $objPost->duration != ''){
            $objPost->slug     = makeSlug($objPost->title,'tbl_services', $field = 'id', $whereCol = 'slug', $extra = 'url', $this->id);
            if($this->id > 0){
                $this->db->update('tbl_services',(array)$objPost,array('id'=>$this->id));
                $return['status'] = true;
            }
            else{
                $objPost->createdDate   = date('Y-m-d H:i:s');
                $objPost->userId   = $this->sessUserId;
                $this->id = $this->db->insert('tbl_services',(array)$objPost)->getLastInsertId();
                $return['status'] = true;
            }

            if($return['status'] == true){
                //adding tags for service
                $this->db->delete('tbl_service_tags',array('serviceId'=>$this->id));
                if($tags != ''){
                    $i = 0;
                    $insArray = array();
                    foreach (explode(',',$tags) as $key => $value){
                        $value = filtering($value,'input','string');
                        $check = $this->db->pdoQuery("SELECT id FROM tbl_tags WHERE tagName = ? LIMIT 1 ",array($value));
                        if($check->affectedRows() > 0){
                            $check_d = $check->result();
                            $insArray[] = array(
                                'serviceId'         =>$this->id,
                                'tagId'             =>$check_d['id'],
                                'createdDate'       =>date("Y-m-d H:i:s")
                            );
                        }
                        else{
                            $tid = $this->db->insert('tbl_tags',array('tagName'=>$value,'createdDate'=>date('Y-m-d H:i:s')))->getLastInsertId();
                            $insArray[] = array(
                                'serviceId'         =>$this->id,
                                'tagId'             =>$tid,
                                'createdDate'       =>date("Y-m-d H:i:s")
                            );
                        }
                        if($i == 500){
                            $this->db->insertBatch('tbl_service_tags',$insArray,true);
                            $insArray = array();
                        }
                        $i = ($i == 500 ? 0 : $i);
                        $i++;
                    }
                    if(!empty($insArray)){
                        $this->db->insertBatch('tbl_service_tags',$insArray,true);
                        $insArray = array();
                    }
                }
                //adding tags for service
                $return['data'] = array('id'=>$this->id,'form_no'=>2);
            }
        }
        else{
            $return['error'] =  ADD_SERVICE_PAGE_MSG_PLEASE_FILL_ALL_VALUES;
        }
        return $return;
    }

    public function getServiceTags($data=array()){
        extract($data);
        $q = $this->db->pdoQuery("SELECT GROUP_CONCAT(t.tagName) as tags
                FROM tbl_service_tags AS st
                LEFT JOIN tbl_tags AS t ON t.id = st.tagId
                WHERE st.serviceId = ? ",array($id))->result();
        if(isset($q['tags']) && $q['tags'] != ''){
            if($return_type == 'string'){
                return $q['tags'];
            }
            else if($return_type == 'json'){
                return json_encode(explode(',',$q['tags']));
            }
            else{
                return explode(',',$q['tags']);
            }
        }
        else{
            if($return_type == 'string'){
                return '';
            }
            else if($return_type == 'json'){
                return json_encode(array());
            }
            else{
                return array();
            }
        }
    }

    public function getServiceTagsSuggestions($data=array()){
        extract($data);
        if(isset($query) && $query != ''){
            $query = str_replace(array('_', '%', "'"), array('\_', '\%', "\'"), $query);
            $q = $this->db->pdoQuery("SELECT GROUP_CONCAT(t.tagName) as tags
                    FROM tbl_tags AS t
                    WHERE tagName LIKE '%$query%'  ")->result();
            if(isset($q['tags']) && $q['tags'] != ''){
                if($return_type == 'string'){
                    return $q['tags'];
                }
                else if($return_type == 'json'){
                    return json_encode(explode(',',$q['tags']));
                }
                else{
                    return explode(',',$q['tags']);
                }
            }
            else{
                if($return_type == 'string'){
                    return '';
                }
                else if($return_type == 'json'){
                    return json_encode(array());
                }
                else{
                    return array();
                }
            }
        }
    }

    public function getDurationSelection($durationType='',$duration=''){
        $return = array();
        $return['status'] = true;
        $return['redirectLink'] = '';
        $return['message'] = '';
        $return['data'] = array();

        $content = '';
         $count = ($durationType == 'h' ? 23 : 31);
        for ($i=1; $i <= $count ;$i++) {
            $replace = array(
                '%OPT_VALUE%'   =>$i,
                '%EXTRA%'       =>'',
                '%SELECTED%'    =>($duration == $i ? 'selected="selected"' : ''),
                '%OPT_TEXT%'    =>$i
            );
            if($this->sessRequestType == 'web'){
                $content .= get_view(DIR_TMPL."/option-nct.tpl.php",$replace);
            }
            else{
                $return['data'][] = array(
                    'id'    =>$i,
                    'name'  =>$i
                );
            }
        }
        return getreturnType($return,$content);
    }
	/*get step 1 details*/

    /*get step 2 details*/
    public function getStep2FormContent($data=array()){
        extract($data);
        $return = array();
        $return['status'] = false;
        $return['redirectLink'] = '';
        $return['message'] = '';
        $return['data'] = array();
        $content = '';
        $packages_list = '';
        $q = $this->db->pdoQuery("SELECT sp.*,p.name,p.id as pid
            FROM tbl_service_packages AS sp
            INNER JOIN tbl_packages AS p ON p.id = sp.packageId
            WHERE sp.serviceId = ? ",array($this->id));


        if($this->sessRequestType === 'web'){
            if($q->affectedRows() > 0){
                foreach ($q->results() as $key => $value) {
                    $packages_list .= $this->getServicePackageContent($value);
                }
            }
            else{
                $packages_list .= $this->getServicePackageContent(array('pid'=>1));
            }
            $replace = array(
                '%STEP_PROCESS%'    =>$this->getStepsContent(2),
                '%PACKAHES_LIST%'   =>$packages_list,
                '%TYPE%'            =>$this->type,
                '%ID%'              =>$this->id,
                '%VIDEO_TAG%'       =>get_view(DIR_TMPL . $this->module . "/video-tag-nct.tpl.php"),
            );
            $content = get_view(DIR_TMPL . $this->module . "/form-step2-nct.tpl.php",$replace);
        }
        else{
            if($q->affectedRows() > 0){
                foreach ($q->results() as $key => $value) {
                    $return['data']['packages_list'] = $this->getServicePackageContent($value);
                }
            }
            $return['data']['id'] = $this->id;
        }
        return getreturnType($return,$content);
    }

    public function getServicePackageContent($data = array()){
        extract($data);
        $return = array();
        $return['status'] = false;
        $return['redirectLink'] = '';
        $return['message'] = '';
        $return['data'] = array();
        $content = '';
        $id                 = issetor($data['pid'],0);
        $name               = getTableValue('tbl_packages','name',array('id'=>$id));
        $name               = filtering(issetor($name,''));
        $description        = filtering(issetor($data['description'],''),'output','text');
        $deliveryDays       = issetor($data['deliveryDays'],'');
        $price              = issetor($data['price'],'');
        $extraService       = filtering(issetor($data['extraService'],''),'output','text');
        $extraServicePrice  = issetor($data['extraServicePrice'],'');

        if($this->sessRequestType === 'web'){

            /*multi currency change*/
            if($price > 0){
                $price = exchange($price,DEFAULT_CURRENCY_CODE,$this->cCode,$this->id,'s');
            }
            if($extraServicePrice > 0){
                $extraServicePrice = exchange($extraServicePrice,DEFAULT_CURRENCY_CODE,$this->cCode,$this->id,'s');
            }
            /*multi currency change*/

            $replace = array(
                '%PID%'                 =>$id,
                '%PACKAGE_NAME%'        =>$name,
                '%DESCRIPTION%'         =>$description,
                '%DELIVERYDAYS%'        =>$deliveryDays,
                '%PRICE%'               =>($price > 0 ? $price : ''),
                '%EXTRA_SERVICE%'       =>($extraService != '' ? $extraService : ''),
                '%EXTRA_SERVICE_PRICE%' =>($extraServicePrice > 0 ? $extraServicePrice : '')
            );
            $content .= get_view(DIR_TMPL . $this->module . "/packages-form-nct.tpl.php",$replace);
        }
        else{
            $return['data'] = array(
                'pid'               =>$id,
                'name'              =>$name,
                'description'       =>$description,
                'deliveryDays'      =>$deliveryDays,
                'price'             =>$price,
                'extraService'      =>$extraService,
                'extraServicePrice' =>$extraServicePrice,
            );
        }
        return getreturnType($return,$content);
    }

    public function removePackageFromService($data=array()){
        extract($data);
        $return = array();
        $return['status'] = false;
        $return['redirectLink'] = '';
        $return['message'] = '';
        $return['data'] = array();

        if($package_id > 0 && $id > 0){
            $check = $this->db->pdoQuery("SELECT sp.id
                FROM tbl_service_packages AS sp
                INNER JOIN tbl_services AS s ON s.id = sp.serviceId
                WHERE sp.packageId = ? AND sp.serviceId = ? AND s.userId = ?  LIMIT 1 ",array($package_id,$id,$this->sessUserId));
            if($check->affectedRows() > 0){
                $check_d = $check->result();
                $this->db->delete('tbl_service_packages',array('id'=>$check_d['id']));
                $return['status'] = true;
                $return['message'] = ADD_SERVICE_PAGE_MSG_PKG_DELETED_SUCCESS;
            }
            else{
                $return['status'] = true;
                $return['message'] = ADD_SERVICE_PAGE_MSG_PKG_DELETED_SUCCESS;
            }
        }
        return $return;
    }

    public function secondStepSubmit($data=array()){
        extract($data);
        $return = array();
        $return['status'] = false;
        $return['redirectLink'] = '';
        $return['message'] = '';
        $return['data'] = array('id'=>0,'form_no'=>2);

        $description        = isset($description) ? $description : array();
        $deliveryDays       = isset($deliveryDays) ? $deliveryDays : array();
        $price              = isset($price) ? $price : array();
        $extraService       = isset($extraService) ? $extraService : array();
        $extraServicePrice  = isset($extraServicePrice) ? $extraServicePrice : array();
        $updatedDate        = date('Y-m-d H:i:s');
        if(count($description) > 0){
            foreach ($description as $key => $value) {
                $check_count = $this->db->pdoQuery("SELECT id FROM tbl_service_packages WHERE serviceId = ? AND packageId = ? ",array($this->id,$key))->affectedRows();

                $description_in         = filtering($description[$key],'input','text');
                $deliveryDays_in        = filtering($deliveryDays[$key],'input','int');
                $price_in               = filtering($price[$key],'input','double');
                $extraService_in        = filtering($extraService[$key],'input','string');
                $extraServicePrice_in   = filtering($extraServicePrice[$key],'input','double');

                /*multi currency change*/
                $price_in_db = exchange($price_in,$this->cCode,DEFAULT_CURRENCY_CODE,$this->id,'s','insert');
                $extraServicePrice_in_db = exchange($extraServicePrice_in,$this->cCode,DEFAULT_CURRENCY_CODE,$this->id,'s','insert');
                /*multi currency change*/

                /*Multi Currency Conversation*/
                $qryCur = $this->db->pdoQuery("SELECT * FROM tbl_currency WHERE isActive = 'y' ")->results();
                $check_c_q = $this->db->pdoQuery("SELECT id FROM tbl_currency_past_rates WHERE entityId = ? AND type = ? LIMIT 1 ",array($this->id,'s'));
                if($check_c_q->affectedRows() > 0){
                    $insArr = array();
                    $insArr['cId'] = $this->cId;
                    foreach ($qryCur as $curVal){
                        $insArr[$curVal['currencyCode']] = $curVal['rate_to_usd'];
                    }
                    $this->db->update('tbl_currency_past_rates',$insArr,array('entityId' => $this->id,'type'=>'s'));
                }
                else{
                    $insArr['cId'] = $this->cId;
                    $insArr['entityId'] = $this->id;
                    $insArr['type'] = 's';
                    foreach ($qryCur as $curVal) {
                        $insArr[$curVal['currencyCode']] = $curVal['rate_to_usd'];
                    }
                    $this->db->insert('tbl_currency_past_rates',$insArr);
                }
                /*Multi Currency Conversation*/

                $inserArray = array(
                    'description'       =>$description_in,
                    'deliveryDays'      =>$deliveryDays_in,
                    'price'             =>strval($price_in_db),
                    'updatedDate'       =>date('Y-m-d H:i:s')
                );
                if($extraService[$key] != ''){
                    $inserArray['extraService'] = $extraService_in;
                    $inserArray['extraServicePrice'] = strval($extraServicePrice_in_db);
                }
                if($check_count > 0){
                    $this->db->update('tbl_service_packages',(array)$inserArray,array('serviceId'=>$this->id,'packageId'=>$key));
                }
                else{
                    $inserArray['serviceId'] = $this->id;
                    $inserArray['createdDate'] = date('Y-m-d H:i:s');
                    $inserArray['packageId'] = $key;
                    $this->db->insert('tbl_service_packages',(array)$inserArray);
                }
            }
            $return['status'] = true;
            $return['data'] = array('id'=>$this->id,'form_no'=>3);
            $response['message'] =  ADD_SERVICE_PAGE_MSG_PKG_SAVED_SUCCESS;
        }
        else{
            $response['message'] =  ADD_SERVICE_PAGE_MSG_ENTER_PKG_DETAILS;
        }
        return $return;
    }
    /*get step 2 details*/

    /*get step 3 details*/
    public function getStep3FormContent($data=array()){
        extract($data);
        $return = array();
        $return['status'] = false;
        $return['redirectLink'] = '';
        $return['message'] = '';
        $return['data'] = array();
        $content = '';
        $faq_list = '';
        $q = $this->db->pdoQuery("SELECT sf.id as fid,sf.question,sf.answer
            FROM tbl_service_faq AS sf
            WHERE sf.serviceId = ? ",array($this->id));

        if($this->sessRequestType === 'web'){
            if($q->affectedRows() > 0){
                foreach ($q->results() as $key => $value) {
                    $value['count'] = ($key + 1);
                    $faq_list .= $this->getServiceFaqContent($value);
                }
            }
            /*else{
                $faq_list .= $this->getServiceFaqContent(array('fid'=>1));
            }*/
            $replace = array(
                '%STEP_PROCESS%'    =>$this->getStepsContent(3),
                '%FAQ_LIST%'        =>$faq_list,
                '%TYPE%'            =>$this->type,
                '%ID%'              =>$this->id,
                '%VIDEO_TAG%'       =>get_view(DIR_TMPL . $this->module . "/video-tag-nct.tpl.php"),
            );
            $content = get_view(DIR_TMPL . $this->module . "/form-step3-nct.tpl.php",$replace);
        }
        else{
            if($q->affectedRows() > 0){
                foreach ($q->results() as $key => $value) {
                    $return['data']['faq_list'] = $this->getServiceFaqContent($value);
                }
            }
            $return['data']['id'] = $this->id;
        }
        return getreturnType($return,$content);
    }

    public function getServiceFaqContent($data = array()){
        extract($data);
        $return = array();
        $return['status'] = false;
        $return['redirectLink'] = '';
        $return['message'] = '';
        $return['data'] = array();
        $content = '';

        $id               = issetor($data['fid'],0);
        $count            = issetor($data['count'],0);
        $question         = filtering(issetor($question,''),'output','text');
        $answer           = filtering(issetor($answer,''),'output','text');

        if($this->sessRequestType === 'web'){
            $replace = array(
                '%FID%'                 =>($id > 0 ? $id : $count),
                '%COUNT%'               =>$count,
                '%QUESTION%'            =>$question,
                '%ANSWER%'              =>$answer
            );
            $content .= get_view(DIR_TMPL . $this->module . "/faq-form-nct.tpl.php",$replace);
        }
        else{
            $return['data'] = array(
                'fid'           =>$id,
                'question'      =>$question,
                'answer'        =>$answer
            );
        }
        return getreturnType($return,$content);
    }

    public function thirdStepSubmit($data=array()){
        extract($data);
        $return = array();
        $return['status'] = false;
        $return['redirectLink'] = '';
        $return['message'] = '';
        $return['data'] = array('id'=>0,'form_no'=>3);

        $question       = isset($question) ? $question : array();
        $answer         = isset($answer) ? $answer : array();
        $updatedDate    = date('Y-m-d H:i:s');
        if(count($question) > 0){
            $remaning_faq = array();
            foreach ($question as $key => $value){
                $check = $this->db->pdoQuery("SELECT id FROM tbl_service_faq WHERE serviceId = ? AND id = ? ",array($this->id,$key));
                $question_in = filtering($question[$key],'input','text');
                $answer_in = filtering($answer[$key],'input','text');
                $inserArray = array(
                    'question'      =>trim($question_in),
                    'answer'        =>trim($answer_in),
                    'updatedDate'   =>date('Y-m-d H:i:s')
                );
                if($check->affectedRows() > 0){
                    $this->db->update('tbl_service_faq',(array)$inserArray,array('serviceId'=>$this->id,'id'=>$key));
                    $remaning_faq[] = $key;
                }
                else{
                    $inserArray['serviceId'] = $this->id;
                    $inserArray['createdDate'] = date('Y-m-d H:i:s');
                    $fid = $this->db->insert('tbl_service_faq',(array)$inserArray)->getLastInsertId();
                    $remaning_faq[] = $fid;
                }
            }
            //removing other faqs
            if(count($remaning_faq) > 0){
                $remaning_faq_list = implode(',',$remaning_faq);
                $this->db->pdoQuery("DELETE FROM tbl_service_faq WHERE id NOT IN (".$remaning_faq_list.") ");
            }
            //removing other faqs
        }
        else{
            $this->db->delete('tbl_service_faq',array('serviceId'=>$this->id));
        }
        $return['status'] = true;
        $return['data'] = array('id'=>$this->id,'form_no'=>4);
        $response['message'] =  ADD_SERVICE_PAGE_MSG_FAQ_SAVED_SUCCESS;
        return $return;
    }
    /*get step 3 details*/

    /*get step 4 details*/
    public function getStep4FormContent($data=array()){
        extract($data);
        $return = array();
        $return['status'] = false;
        $return['redirectLink'] = '';
        $return['message'] = '';
        $return['data'] = array();
        $content = array();
        $content['html'] = '';
        $content['requirementId'] = 0;
        $text_list = '';

        $main_q_data = array();
        $main_q = $this->db->pdoQuery("SELECT sr.id as requirementId,sr.requirement,sr.type as srtype,sr.text,sr.file
            FROM tbl_service_requirement AS sr
            WHERE sr.serviceId = ? LIMIT 1 ",array($this->id));
        if($main_q->affectedRows() > 0){

            $main_q_data = $main_q->result();
            $q = $this->db->pdoQuery("SELECT rl.id as rid,rl.text
                FROM tbl_service_requirement_list AS rl
                WHERE rl.requirementId = ? GROUP BY rl.id ",array($main_q_data['requirementId']));

            if($this->sessRequestType === 'web'){

                if($q->affectedRows() > 0){
                    foreach ($q->results() as $key => $value) {
                        $value['count'] = ($key+1);
                        $text_list .= $this->getServiceRequirementTextContent($value);
                    }
                }
                else{
                    $text_list .= $this->getServiceRequirementTextContent(array('rid'=>1));
                }
                $main_q_data['requirement'] = filtering($main_q_data['requirement'],'output','text');
                $main_q_data['text'] = filtering($main_q_data['text'],'output','text');
                $replace = array(
                    '%STEP_PROCESS%'    =>$this->getStepsContent(4),
                    '%REQUIREMENT_ID%'  =>$main_q_data['requirementId'],
                    '%TEXT_LIST%'       =>$text_list,
                    '%REQUIRMENT%'      =>$main_q_data['requirement'],
                    '%SELECT_TYPE%'     =>($main_q_data['srtype'] != '' ? $main_q_data['srtype'] : 'fr'),
                    '%TEXT%'            =>$main_q_data['text'],
                    '%OPT_MUL_SELECTED%'=>($main_q_data['srtype'] == 'm' ? 'selected="selected"' : ''),
                    '%OPT_FREE_SELECTED%'=>($main_q_data['srtype'] == 'fr' ? 'selected="selected"' : ''),
                    '%OPT_FILE_SELECTED%'=>($main_q_data['srtype'] == 'f' ? 'selected="selected"' : ''),
                    '%REQUIRED_FILE%'   =>(($main_q_data['srtype'] == 'f' && $main_q_data['file'] == '') ? 'required' : ''),
                    '%TYPE%'            =>$this->type,
                    '%ID%'              =>$this->id,
                    '%VIDEO_TAG%'       =>get_view(DIR_TMPL . $this->module . "/video-tag-nct.tpl.php"),
                    '%FILE_VALUE%'      =>(($main_q_data['srtype'] == 'f' && $main_q_data['file'] == '') ? '' : $main_q_data['file']),
                );
                $content['html'] = get_view(DIR_TMPL . $this->module . "/form-step4-nct.tpl.php",$replace);
                $content['requirementId'] = $main_q_data['requirementId'];
            }
            else{
                $return['status'] = true;
                $return['data']['text_list'] = array();
                if($q->affectedRows() > 0){
                    foreach ($q->results() as $key => $value) {
                        $return['data']['text_list'][] = $this->getServiceRequirementTextContent($value);
                    }
                }
                $return['data']['id'] = $this->id;
                $return['data']['requirementId'] = $main_q_data['requirementId'];
                $return['data']['requirement'] = $main_q_data['requirement'];
                $return['data']['type'] = $main_q_data['srtype'];
                $return['data']['text'] = $main_q_data['text'];
            }
        }
        else{
            $replace = array(
                '%STEP_PROCESS%'    =>$this->getStepsContent(4),
                '%REQUIREMENT_ID%'  =>0,
                '%TEXT_LIST%'       =>$text_list,
                '%REQUIRMENT%'      =>'',
                '%SELECT_TYPE%'     =>'fr',
                '%TEXT%'            =>'',
                '%OPT_MUL_SELECTED%'=>'',
                '%OPT_FREE_SELECTED%'=>'selected="selected"',
                '%REQUIRED_FILE%'   =>'required',
                '%OPT_FILE_SELECTED%'=>'',
                '%TYPE%'            =>$this->type,
                '%ID%'              =>$this->id
            );
            $content['html'] = get_view(DIR_TMPL . $this->module . "/form-step4-nct.tpl.php",$replace);
        }
        return getreturnType($return,$content);
    }

    public function getServiceRequirementTextContent($data = array()){
        extract($data);
        $return = array();
        $return['status'] = false;
        $return['redirectLink'] = '';
        $return['message'] = '';
        $return['data'] = array();
        $content = '';

        $id         = issetor($data['rid'],0);
        $count      = issetor($data['count'],0);
        $text       = filtering(issetor($text,''),'output','text');

        if($this->sessRequestType === 'web'){
            $replace = array(
                '%RID%'     =>$id,
                '%COUNT%'   =>($count > 0 ? $count : $rid),
                '%TEXT%'    =>$text
            );
            $content .= get_view(DIR_TMPL . $this->module . "/text-list-nct.tpl.php",$replace);
        }
        else{
            $return['data'] = array(
                'rid'           =>$id,
                'text'          =>$text
            );
        }
        return getreturnType($return,$content);
    }

    public function fourthStepSubmit($data=array()){
        extract($data);
        $return = array();
        $return['status'] = false;
        $return['redirectLink'] = '';
        $return['message'] = '';
        $return['data'] = array('id'=>0,'form_no'=>4,'requirementId'=>0);

        $requirementId      = filtering(issetor($requirementId,0),'input','int');
        $requirement        = filtering(issetor($requirement,''),'input','text');
        $select_type        = filtering(issetor($select_type,'fr'),'input','string');
        $text               = filtering(issetor($text,''),'input','text');
        $mul_text           = isset($mul_text) ? $mul_text : array();
        $updatedDate        = date('Y-m-d H:i:s');

        if($requirement != '' && $select_type != ''){
            $file_name = '';
            //upload file
            if($select_type == 'f' && isset($_FILES['file']) && isset($_FILES['file']['name']) && $_FILES['file']['name'] !=''){
                $imageName = $_FILES['file']['name'];
                $tmp_name  = $_FILES['file']['tmp_name'];
                $imageType = $_FILES['file']['type'];
                $imageSize = $_FILES['file']['size'];
                $error     = $_FILES['file']['error'];
                if($error == 0){
                    $upload_dir = DIR_UPD.'services/'.$this->id.'/';
                    if(!file_exists($upload_dir)){
                        mkdir($upload_dir,0755);
                    }
                    $ext        = '.'.strtolower(getExt($imageName));
                    $file_name = $newName    = rand().time().$ext;
                    move_uploaded_file($tmp_name, $upload_dir.$newName);
                }
            }
            else{
                if($requirementId > 0){
                    $file_name = getTableValue('tbl_service_requirement','file',array('serviceId'=>$this->id));
                }
            }
            //upload file

            $updateArray = array(
                'requirement'   =>$requirement,
                'type'          =>$select_type,
                'text'          =>($select_type == 'fr' ? $text : ''),
                'file'          =>($select_type == 'f' ? $file_name : '')
            );
            if($requirementId > 0){
                $this->db->update('tbl_service_requirement',$updateArray,array('serviceId'=>$this->id));
            }
            else{
                $updateArray['serviceId'] = $this->id;
                $updateArray['creadtedDate'] = date('Y-m-d H:i:s');
                $requirementId = $this->db->insert('tbl_service_requirement',$updateArray)->getLastInsertId();
            }
            if($select_type == 'm' && count($mul_text) > 0){
                foreach ($mul_text as $key => $value){
                    $mul_text[$key] = filtering(issetor($mul_text[$key],''),'input','text');
                    if($mul_text[$key] != ''){
                        $check = $this->db->pdoQuery("SELECT id FROM tbl_service_requirement_list WHERE id = ? AND requirementId = ?  ",array($key,$requirementId));
                        $inserArray = array(
                            'text'          =>$mul_text[$key],
                            'updatedDate'   =>date('Y-m-d H:i:s')
                        );
                        if($check->affectedRows() > 0){
                            $this->db->update('tbl_service_requirement_list',(array)$inserArray,array('requirementId'=>$requirementId,'id'=>$key));
                        }
                        else{
                            $inserArray['requirementId'] = $requirementId;
                            $inserArray['createdDate'] = date('Y-m-d H:i:s');
                            $this->db->insert('tbl_service_requirement_list',(array)$inserArray);
                        }
                    }
                }
            }
            else{
                $this->db->delete('tbl_service_requirement_list',array('requirementId'=>$requirementId));
            }
            $return['status'] = true;
            $return['data'] = array('id'=>$this->id,'form_no'=>5,'requirementId'=>$requirementId);
            $response['message'] =  ADD_SERVICE_PAGE_MSG_REQ_DETAILS_SAVED_SUCCESS;
        }
        else{
            $response['message'] =  ADD_SERVICE_PAGE_MSG_PLEASE_FILL_ALL_VALUES;
        }
        return $return;
    }
    /*get step 4 details*/

    /*get step 5 details*/
    public function getStep5FormContent($data=array()){
        extract($data);
        $return = array();
        $return['status'] = false;
        $return['redirectLink'] = '';
        $return['message'] = '';
        $return['data'] = array();
        $content = array();
        $content['html'] = '';
        $gallery_list = '';

        $q = $this->db->pdoQuery("SELECT sg.id as gid,sg.fileType,sg.fileName
            FROM tbl_service_gallery AS sg
            WHERE sg.serviceId = ? ",array($this->id));
        if($this->sessRequestType === 'web'){
            if($q->affectedRows() > 0){
                foreach ($q->results() as $key => $value) {
                    $value['count'] = ($key+1);
                    $gallery_list .= $this->getServiceGalleryContent($value);
                }
            }
            /*else{
                $gallery_list .= $this->getServiceGalleryContent(array('gid'=>1));
            } */
            $replace = array(
                '%STEP_PROCESS%'    =>$this->getStepsContent(5),
                '%GALLERY_LIST%'    =>$gallery_list,
                '%TYPE%'            =>$this->type,
                '%ID%'              =>$this->id,
                '%VIDEO_TAG%'       =>get_view(DIR_TMPL . $this->module . "/video-tag-nct.tpl.php"),
            );
            $content['html'] = get_view(DIR_TMPL . $this->module . "/form-step5-nct.tpl.php",$replace);
        }
        else{
            if($q->affectedRows() > 0){
                foreach ($q->results() as $key => $value) {
                    $return['data']['gallery_list'] = $this->getServiceGalleryContent($value);
                }
            }
            $return['data']['id'] = $this->id;
        }
        return getreturnType($return,$content);
    }

    public function getServiceGalleryContent($data = array()){
        extract($data);
        $return = array();
        $return['status'] = false;
        $return['redirectLink'] = '';
        $return['message'] = '';
        $return['data'] = array();
        $content = '';

        $id             = issetor($data['gid'],0);
        $count          = issetor($data['count'],0);
        $fileName       = filtering(issetor($data['fileName'],''),'output','string');
        $fileType       = filtering(issetor($data['fileType'],''),'output','string');
        if($fileName != ''){
            $image = checkImage($data['fileName'],8,$this->id);
        }
        else{
            $image = SITE_IMG.'gallery_noimage.jpg';
        }

        if($this->sessRequestType === 'web'){
            $replace = array(
                '%GID%'             =>$id,
                '%COUNT%'           =>$data['count'],
                '%IMAGE%'           =>$image,
                '%IMAGE_CLASS%'     =>($fileType == 'v' ? 'hide1' : ''),
                '%VIDEO_CLASS%'     =>(($fileType == 'i' || $fileType == '') ? 'hide1' : ''),
                '%VIDEO%'           =>($fileType == 'v' ? SITE_UPD.'services/'.$this->id.'/'.$fileName : ''),
                '%HIDDEN_IMG_VALUE%'=>$fileName,
                '%FILE_NAME%'       =>$fileName,
                '%DEST_SITE_URL%'   =>SITE_UPD.'services/temp_dir/'.$this->id.'/',
                "%DEST_DIR_URL%"    =>DIR_UPD.'services/temp_dir/'.$this->id.'/'
            );
            $temp_file = 'gallery-nct.tpl.php';
            if($id > 0 && $fileName != ''){
                $temp_file = 'preview-gallery-nct.tpl.php';
            }
            else{
                $temp_file = 'gallery-nct.tpl.php';
            }
            $content .= get_view(DIR_TMPL . $this->module . "/".$temp_file,$replace);
        }
        else{
            $return['data'] = array(
                'gid'       =>$id,
                'fileName'  =>$fileName,
                'file'      =>checkImage($data['fileName'],8,$this->id)
            );
        }
        return getreturnType($return,$content);
    }

    public function fifthStepSubmit($data=array()){
        extract($data);
        $return = array();
        $return['status'] = false;
        $return['redirectLink'] = '';
        $return['message'] = '';
        $return['data'] = array('id'=>0,'form_no'=>5);

        $filesToKeep = array();
        $gallery_data = $this->db->pdoQuery("SELECT id,fileName FROM tbl_service_gallery WHERE serviceId = ? ",array($this->id))->results();
        foreach ($gallery_data as $key => $value){
            $hidden_name = 'hiddenImgfile_'.$value['id'];
            if(isset($_POST[$hidden_name]) && $_POST[$hidden_name] != ''){
                $filesToKeep[] = $_POST[$hidden_name];
            }
            else{
                //deleting other files
                $this->db->delete('tbl_service_gallery',array('id'=>$value['id']));
                $data_array = array('type'=>'services','path'=>$this->id.'/','fileName'=>$value['fileName']);
                deletefile($data_array);
                //deleting other files
            }
        }
        if(count($_FILES)){
            foreach ($_FILES as $key => $value){
                $hidden_name = 'hiddenImg'.$key;
                if(isset($_POST[$hidden_name]) && $_POST[$hidden_name] != ''){
                    //upload new images selected
                    $upload_dir = $this->id.'/';
                    $filesToKeep[] =$_POST[$hidden_name];
                    uploadImagewithResize($upload_dir,$_POST[$hidden_name],'services');
                    $this->db->insert('tbl_service_gallery',array('serviceId'=>$this->id,'fileType'=>'i','fileName'=>$_POST[$hidden_name],'creadtedDate'=>date('Y-m-d H:i:s')));
                    //upload new images selected
                }
                else{
                    //upload video file
                    $imageType = $_FILES[$key]['type'];
                    if($imageType == 'video/mp4' || $imageType == 'video/ogg' || $imageType == 'video/webm'){
                        $imageName = $_FILES[$key]['name'];
                        $ext = '.'.strtolower(getExt($imageName));
                        $newName = rand().time().$ext;
                        $upload_dir = DIR_UPD.'services/'.$this->id.'/';
                        if(!file_exists($upload_dir)){
                            mkdir($upload_dir,0777);
                        }
                        $filesToKeep[] = $newName;
                        move_uploaded_file($_FILES[$key]["tmp_name"],$upload_dir.$newName);
                        $this->db->insert('tbl_service_gallery',array('serviceId'=>$this->id,'fileType'=>'v','fileName'=>$newName,'creadtedDate'=>date('Y-m-d H:i:s')));
                    }
                    //upload video file
                }
            }
            //deleting files from temp
            $data_array = array('type'=>'services','path'=>'temp_dir/'.$this->id.'/','filesToKeep'=>array());
            deletefile($data_array);
            //deleting files from temp
        }

        if(count($filesToKeep) <= 0){
            $response['message'] =  ADD_SERVICE_PAGE_MSG_NEED_ATLEAST_ONE_GALLERY;
        }
        else{
            $this->db->update('tbl_services',array('isActive'=>'y','updatedDate'=>date('Y-m-d H:i:s')),array('id'=>$this->id));
            $return['status'] = true;
            $return['redirectLink'] = SITE_URL.'my-services/';
            $return['data'] = array('id'=>$this->id,'form_no'=>5);
            $msgType = $_SESSION["msgType"] = disMessage(array('type' => 'suc','var' => ADD_SERVICE_PAGE_MSG_SERVICE_SENT_FOR_APPROVAL));
            $response['message'] =  ADD_SERVICE_PAGE_MSG_SERVICE_SENT_FOR_APPROVAL;
        }
        return $return;
    }
    /*get step 5 details*/

	/*Extra function to call*/
	public function getCategorySelection($categoryId=0){
        $return = array();
		$return['status'] = false;
		$return['redirectLink'] = '';
		$return['message'] = '';
		$return['data'] = array();

		$content = '';

        $c_q= $this->db->pdoQuery("SELECT id,cateName_$this->lId as cateName FROM tbl_categories WHERE isActive = ? ORDER BY cateName_$this->lId ",array('y'));
        if($c_q->affectedRows() > 0){
            foreach ($c_q->results() as $key => $value) {
                $selected = ($categoryId == $value['id'] ? 'selected' : '');
            	if($this->sessRequestType == 'web'){
            		$replace = array(
	                    '%OPT_VALUE%'=>$value['id'],
	                    '%EXTRA%'=>'',
	                    '%SELECTED%'=>$selected,
	                    '%OPT_TEXT%'=>$value['cateName']
	                );
	                $content .= get_view(DIR_TMPL."/option-nct.tpl.php",$replace);
            	}
            	else{
            		$return['data'][] = array(
						'id'	=>$value['id'],
						'name'	=>$value['cateName']
					);
            	}
            }
            $return['status'] = true;
        }
        return getreturnType($return,$content);
    }

    public function getSubCategorySelection($categoryId=0,$subCategoryId=0){
        $return = array();
		$return['status'] = false;
		$return['redirectLink'] = '';
		$return['message'] = '';
		$return['data'] = array();

		$content = '';

        $c_q= $this->db->pdoQuery("SELECT id,subCategoryName_$this->lId as subCategoryName FROM tbl_subcategories WHERE categoryId = ? AND isActive = ? ORDER BY subCategoryName_$this->lId ASC ",array($categoryId,'y'));
        if($c_q->affectedRows() > 0){
            foreach ($c_q->results() as $key => $value) {
                $selected = ($subCategoryId == $value['id'] ? 'selected' : '');
                if($this->sessRequestType == 'web'){
                	$replace = array(
	                    '%OPT_VALUE%'=>$value['id'],
	                    '%EXTRA%'=>'',
	                    '%SELECTED%'=>$selected,
	                    '%OPT_TEXT%'=>$value['subCategoryName']
	                );
	                $content .= get_view(DIR_TMPL."/option-nct.tpl.php",$replace);
                }
                else{
                	$return['data'][] = array(
						'id'	=>$value['id'],
						'name'	=>$value['subCategoryName']
					);
                }
                $return['status'] = true;
            }
        }
        return getreturnType($return,$content);
    }

	public function getStepsContent($active_step = 1) {
        $content = '';
        $replace = array(
            '%STEP1_CLASS%'=>($active_step == 1 ? 'active' : ($active_step > 1 ? 'completed' : '')),
            '%STEP2_CLASS%'=>($active_step == 2 ? 'active' : ($active_step > 2 ? 'completed' : '')),
            '%STEP3_CLASS%'=>($active_step == 3 ? 'active' : ($active_step > 3 ? 'completed' : '')),
            '%STEP4_CLASS%'=>($active_step == 4 ? 'active' : ($active_step > 4 ? 'completed' : '')),
            '%STEP5_CLASS%'=>($active_step == 5 ? 'active' : ($active_step > 5 ? 'completed' : '')),
            '%STEP1_ACTION%'=>'1',
            '%STEP2_ACTION%'=>'2',
            '%STEP3_ACTION%'=>'3',
            '%STEP4_ACTION%'=>'4',
            '%STEP5_ACTION%'=>'5'
        );
        $content = get_view(DIR_TMPL . $this->module . "/step-process-nct.tpl.php",$replace);
        return $content;
    }

    public function getServiceFormDetails($data=array()){
        extract($_POST);
        $content = '';

        if($form_type == 'editstep1')
            $content = $this->getStep1FormContent();
        else if($form_type == 'editstep2')
            $content = $this->getStep2FormContent();
        else if($form_type == 'editstep3')
            $content = $this->getStep3FormContent();
        else if($form_type == 'editstep4')
            $content = $this->getStep4FormContent();
        else if($form_type == 'editstep5')
            $content = $this->getStep5FormContent();
        else
            $content = $this->getStep1FormContent();
       return $content;
    }
    /*Extra function to call*/
}

?>
