function getPaginationData(page){
	page = (page && page !== null && page !== undefined && page > 0) ? page : 1;
	$.ajax({
		url: currentPageURL,
		type: "POST",
		cache:false,
		data: {
			action: 'ajaxPagination',
			page: page,
		},
		dataType : 'json',
		beforeSend : function(){
			showLoader();
		},
		success: function(data) {
			$(".services_list_div .inner_loader").remove();
			$(".services_list_div").append(data.html);
			if(data.view_more == 'n'){
				$(".view_more_services").remove();
			}
			setTimeout(function(){
				equalHeight("services_list_div", "service_title");
    			equalHeight("services_list_div", "service_block");
			},500);
			dispRatting();
			hideLoader();
		}
	});
}


function getPaginationDataForReviews(page){
	page = (page && page !== null && page !== undefined && page > 0) ? page : 1;
	$.ajax({
		url: currentPageURL,
		type: "POST",
		cache:false,
		data: {
			action: 'ajaxPaginationReviews',
			page: page,
		},
		dataType : 'json',
		beforeSend : function(){
			showLoader();
		},
		success: function(data) {
			$(".review_list_div .inner_loader").remove();
			$(".review_list_div").append(data.html);
			if(data.view_more == 'n'){
				$(".view_more_reviews").remove();
			}
			dispRatting();
			hideLoader();
		}
	});
}

function completesubmit(response){
	$(".contact_user_modal_content #ContactUserModal").modal('hide');
}

$(document).ready(function($) {
	dispRatting();
	getPaginationData(1);
	getPaginationDataForReviews(1);
	$(".view_more_details").shorten({
        "showChars" : 200,
        "moreText"  : VIEW_MORE,
        "lessText"  : VIEW_LESS,
    });
    $('[data-toggle="tooltip"]').tooltip();
});
$(document).on("click",".view_more_services",function(){
	var count = 0;
    $(".services_list_div .service_listing").each(function(){ 
        count++;
    });
	var pageNo = (count / PER_PAGE_LIMIT_PROFILE_PAGE) + 1;
	if(pageNo > 0){
		getPaginationData(parseInt(pageNo));
	}
});

$(document).on("click",".view_more_reviews",function(){
	var count = 0;
    $(".review_list_div .review_listing").each(function(){ 
        count++;
    });
	var pageNo = (count / PER_PAGE_LIMIT) + 1;
	if(pageNo > 0){
		getPaginationDataForReviews(parseInt(pageNo));
	}
});

$(document).on('click',".contact_user_now",function(){
	$.ajax({
		url: currentPageURL,
		type: "POST",
		cache:false,
		data: {
			action: 'getContactUserContent'
		},
		dataType : 'json',
		beforeSend : function(){
			showLoader();
		},
		success: function(data) {
			if(data.status == true){
				$(".contact_user_modal_content").html(data.data);
				$(".contact_user_modal_content #ContactUserModal").modal('show');
			}
			else{
				if(data.message != ''){
					toastr['error'](data.message);
				}
			}
			hideLoader();
		}
	});
});

$(document).on('submit','#frmContactUser',function(){
	$("#frmContactUser").validate({
		rules:{
			message:{required:true},
		},
		messages:{
			message:{required:lang.PROFILE_PAGE_ERR_ENTER_MSG},
		},
		highlight: function (element, errorClass, validClass) {
		},            
		unhighlight: function (element, errorClass, validClass) {
		},
		errorPlacement: function (error, element) { 
			if (element.attr("data-error-container")){
				error.appendTo(element.attr("data-error-container"));
			} else {
				error.insertAfter(element);
			}
			error.addClass('error');
		}
	});
	if($("#frmContactUser").valid()){
        ajaxFormSubmit("form#frmContactUser","completesubmit");
        return false;
    }else{
        return false;
    }
});


$(document).on('click','.report_user',function(){
	if(confirm(lang.PROFILE_PAGE_MSG_REPORT_CONFIRM)){
		$.ajax({
			url: currentPageURL,
			type: "POST",
			cache:false,
			data: {
				action: 'reportUserAsSpam'
			},
			dataType : 'json',
			beforeSend : function(){
				showLoader();
			},
			success: function(data) {
				if(data.status == true){
					if(data.message != ''){
						toastr['success'](data.message);
					}
				}
				else{
					if(data.message != ''){
						toastr['error'](data.message);
					}
				}
				hideLoader();
			}
		});
	}
});