$(document).ready(function($) {
   	readMore();
    $(document).on("click",".buttonPage",function(){
		var pageNo = $(this).data('page');
		$('#pageNo').val(pageNo);
	    getMyRequestList();

	});
	$(document).on('change', '#reqCategory', function(event) {
		$('#pageNo').val(1);
		getMyRequestList();
	});

	$(document).on('click', '.post-review', function(event) {
		$this = $(this);
		var reqSlug = $this.attr('data-id');
		if(reqSlug != ""){
			$.ajax({
		        url: SITE_URL+'my-requests/',
		        type: 'POST',
		        data: {
					    reqSlug: reqSlug,
					    action: 'getPostReviewPopup'
				    },
		        dataType: 'json',
		        beforeSend: function() {
					showLoader();
				},
				success: function(response) {
					if(response.status){
						$('.modal-container-div').html(response.data);
						$("#rating_div").raty({
					        scoreName: 'star_ratings',
					        score: 0,
					        half: true,
					        starHalf: SITE_PLUGIN+'raty/images/star-half.png',
					        starOff: SITE_PLUGIN+'raty/images/star-off.png',
					        starOn: SITE_PLUGIN+'raty/images/star-on.png',
					        hints: [lang.SERVICE_DETAILS_PAGE_LBL_RATING_BAD,lang.SERVICE_DETAILS_PAGE_LBL_RATING_POOR,lang.SERVICE_DETAILS_PAGE_LBL_RATING_REGULAR, lang.SERVICE_DETAILS_PAGE_LBL_RATING_GOOD, lang.SERVICE_DETAILS_PAGE_LBL_RATING_EXCELLENT],
						  click: function(score, evt){
						  	$("#rating").val(score);
						  	$("#rating").valid();
						  }
					    });
						$(".modal-container-div #PostReviewForRequestModal").modal('show');

					}else{
						toastr['error'](response.message);
					}
					hideLoader();
				},
				error: function(response) {
					hideLoader();
					$(function() {
						toastr['error'](lang.MSG_SOMETHING_WRONG);
					});
				}
		    });
		}else{

		}
	});

	$(document).on('submit','#frmPostReviewForRequest',function(e){
		e.preventDefault();
		$("#frmPostReviewForRequest").validate({
			ignore : '',
			rules:{
				orderId:{required:true},
				rating:{required:true,min:0.5},
				review:{required:true}
			},
			messages:{
				orderId:{required:lang.REQUEST_PAGE_ERR_ORDER_REQUIRED},
				rating:{required:lang.REQUEST_PAGE_ERR_SELECT_RATING,min:lang.REQUEST_PAGE_ERR_MIN_RATING},
				review:{required:lang.REQUEST_PAGE_ERR_ENTER_REVIEW}
			},
			highlight: function (element, errorClass, validClass) {
			},
			unhighlight: function (element, errorClass, validClass) {
			},
			errorPlacement: function (error, element) {
				if (element.attr("data-error-container")){
					error.appendTo(element.attr("data-error-container"));
				} else {
					error.insertAfter(element);
				}
				error.addClass('error');
			}
		});
		if($("#frmPostReviewForRequest").valid()){
			if($("#rating").val() > 0){
				var form = $('#frmPostReviewForRequest').serializeArray();

				var uniquekey = {
				      name: "action",
				      value: "postReviewForRequest"
				};
				form.push(uniquekey);
				var reqSlug = $('#frmPostReviewForRequest').find("#reqSlug").val();
				$.ajax({
			        url: SITE_URL+'my-requests/',
			        type: 'POST',
			        data: form,
			        dataType: 'json',
			        beforeSend: function() {
						showLoader();
					},
					success: function(response) {
						if(response.status){
							$("#PostReviewForRequestModal").modal('hide');
							$("."+reqSlug).html(response.data);
							dispRatting();
							$('*[data-id="'+reqSlug+'"]').remove();
							toastr['success'](response.message);

						}else{
							toastr['error'](response.message);
						}
						readMore();
						hideLoader();
					},
					error: function(response) {
						hideLoader();
						$(function() {
							toastr['error'](lang.MSG_SOMETHING_WRONG);
						});
					}
			    });
			}
			else{
				toastr["error"](lang.REQUEST_PAGE_ERR_SELECT_RATING);
			}
	        return false;
	    }else{
	        return false;
	    }
	});
});
function readMore() {
	$(".requestDetail").shorten({
        "showChars" : 200,
        "moreText"  : VIEW_MORE,
        "lessText"  : VIEW_LESS,
    });
}
function getMyRequestList() {
	var catSlug = $('#reqCategory').val();
	var pageNo = $('#pageNo').val();
	/*dataurl = SITE_URL + 'my-requests/?action=getMyRequestList&' +'catSlug='+catSlug+'&keyword='+keyword+'&pageNo='+pageNo; */
	$.ajax({
        url: SITE_URL+'my-requests/',
        type: 'POST',
        data: {
			    catSlug: catSlug,
			    pageNo: pageNo,
			    action: 'getMyRequestList'
		    },
        dataType: 'json',
        beforeSend: function() {
			showLoader();
		},
		success: function(response) {
			/*if (typeof (history.pushState) != "undefined") {
		        var obj = { Title: 'search', Url: dataurl };
		        history.pushState(obj, obj.Title, obj.Url);
		    }*/
			if(response.status){
				$('#request_content_list').html(response.data.html);
				$('.pagination_div').html(response.data.pagination);
			}
			readMore();
			dispRatting();
			hideLoader();
		},
		error: function(response) {
			hideLoader();
			$(function() {
				toastr['error'](lang.MSG_SOMETHING_WRONG);
			});
		}
    });
}



function completesubmitpostreview(response){
	$(".modal-container-div #PostReviewForRequestModal").modal('hide');
	location.reload();
}