collectionUrl = siteUrl+'my-collections/'
function getPaginationData(page){
	//page = (page && page !== null && page !== undefined && page > 0) ? page : 1;
	page = $("#pageNo").val();
	keyword = $("#keyword").val();
	$.ajax({
		url: collectionUrl,
		type: "POST",
		cache:false,
		data: {
			action: 'ajaxPagination',
			page: page,
			keyword: keyword,
		},
		dataType : 'json',
		beforeSend : function(){
			showLoader();
		},
		success: function(data) {
			$(".collection_group_div").html(data.html);
			if(data.status == true){
				$(".pagination_div").html(data.pagination);
			}
			else{
				$(".pagination_div").html('');
			}
			scrollToElement(".trending_upper_block");
			hideLoader();

		}
	});
}

$(document).ready(function($) {
	$(document).on("click",".buttonPage",function(){
		var pageNo = $(this).data('page');
		$("#pageNo").val(pageNo);
		getPaginationData();
	});
	getPaginationData();
	$(document).on('click', '.deleteCollection', function(event) {
		if (confirm(lang.MSG_CONFIRM_DELETE_FILE)) {
			return true;
		}else{
			return false;
		}
	});
	$(document).on('keypress', '.search', function(event) {
		var myVal = $(this).val();
		var keycode = (event.keyCode ? event.keyCode : event.which);
	    if(keycode == '13'){
			$("#keyword").val(myVal);
			$("#pageNo").val(1);
			getPaginationData();
	    }
	});
	

});