<?php

$reqAuth = true;
require_once("../../../includes-nct/config-nct.php");
include("class.currency-nct.php");
$module = "currency-nct";
$table = "tbl_currency";


$styles = array(array("data-tables/DT_bootstrap.css", SITE_ADM_PLUGIN),
    array("bootstrap-switch/css/bootstrap-switch.min.css", SITE_ADM_PLUGIN));

$scripts = array("core/datatable.js",
    array("data-tables/jquery.dataTables.js", SITE_ADM_PLUGIN),
    array("data-tables/DT_bootstrap.js", SITE_ADM_PLUGIN),
    array("bootstrap-switch/js/bootstrap-switch.min.js", SITE_ADM_PLUGIN));

chkPermission($module);
$Permission = chkModulePermission($module);

$metaTag = getMetaTags(array("description" => "Admin Panel",
    "keywords" => 'Admin Panel',
    'author' => AUTHOR));

$id = isset($_GET["id"]) ? (int) trim($_GET["id"]) : 0;
$postType = isset($_POST["type"]) ? trim($_POST["type"]) : '';
$type = isset($_GET["type"]) ? trim($_GET["type"]) : $postType;

$headTitle = $type == 'add' ? 'Add' : ($type == 'edit' ? 'Edit' : 'Manage') . ' Currency';
$winTitle = $headTitle . ' - ' . SITE_NM;
$breadcrumb = array($headTitle);

$objCurrency = new Currency($module);

if(isset($_POST["submitAddForm"]) && $_SERVER["REQUEST_METHOD"] == "POST")
{
    extract($_POST);

    $objPost->currencyName = isset($currencyName) ? $currencyName : '';
    $objPost->currencyCode = isset($currencyCode) ? $currencyCode : '';
    $objPost->currencySign = isset($currencySign) ? $currencySign : '';
    $objPost->rate_to_usd = isset($rate_to_usd) ? $rate_to_usd : '';
    $objPost->isActive       = isset($isActive) ? $isActive : 'n';
    if($objPost->currencyName != "")
    {
        if($type == 'edit' && $id > 0)
        {
            if(in_array('edit',$Permission))
            {
                $valArray = array();

                $valArray['updateDate'] = date('Y-m-d H:i:s');
                $valArray['currencyName'] = $objPost->currencyName;
                $valArray['currencyCode'] = $objPost->currencyCode;
                $valArray['currencySign'] = $objPost->currencySign;
                $valArray['rate_to_usd'] = $objPost->rate_to_usd;
                if(in_array('status',$Permission))
                {
                    $valArray['isActive'] = $objPost->isActive;
                }

                $db->update($table,$valArray, array("id"=>$id));

                $activity_array = array("id"=>$id,"module"=>$module,"activity"=>'edit');
                add_admin_activity($activity_array);
                $toastr_message = $_SESSION["toastr_message"] = disMessage(array('type'=>'suc','var'=>'recEdited'));
            }else{
                $toastr_message = $_SESSION["toastr_message"] = disMessage(array('type'=>'err','var'=>'NoPermission'));
            }
        } else {
            if(in_array('add',$Permission))
            {
                $getCur  = $db->select($table, array('id'), array("currencyName"=>$objPost->currencyName))->affectedRows();
                $getCurCod  = $db->select($table, array('id'), array("currencyCode"=>$objPost->currencyCode))->affectedRows();
                if($getCur <=0 && $getCurCod <= 0)
                {
                    $objPost->createdDate = date('Y-m-d H:i:s');

                    $valArray = array();
                    $valArray['currencyName'] = $objPost->currencyName;
                    $valArray['currencyCode'] = $objPost->currencyCode;
                    $valArray['currencySign'] = $objPost->currencySign;
                    $valArray['rate_to_usd'] = $objPost->rate_to_usd;
                    if(in_array('status', $Permission))
                    {
                        $valArray['isActive'] = $objPost->isActive;
                    }
                    $valArray['createdDate'] = $objPost->createdDate;

                    $insertId = $db->insert($table ,$valArray)->getLastInsertId();


                    /*ADD TO past rate*/

                    /*$alterTableColorvalue=$db->prepare("ALTER TABLE `tbl_currency_past_rates` ADD `".$objPost->currencyCode."` FLOAT(12,4)  NULL");

                    $alterTableColorvalue->execute();

                    $updateTableColorName=$db->prepare("UPDATE `tbl_currency_past_rates` SET  ".$objPost->currencyCode." = ".$objPost->rate_to_usd);

                    $updateTableColorName->execute();*/

                    $activity_array = array("id"=>$insertId,"module"=>$module,"activity"=>'add');

                    add_admin_activity($activity_array);

                    //start:: alter tabel

                    $toastr_message = $_SESSION["toastr_message"] = disMessage(array('type'=>'suc','var'=>'recAdded'));
                }else{
                    $toastr_message = $_SESSION["toastr_message"] = disMessage(array('type'=>'err','var'=>'recExist'));
                }
            }else{
                    $toastr_message = $_SESSION["toastr_message"] = disMessage(array('type'=>'err','var'=>'NoPermission'));
            }
        }

        redirectPage(SITE_ADM_MOD.$module);
    }
    else {
        $toastr_message = disMessage(array('type'=>'err','var'=>'fillAllvalues'));
    }
}
$pageContent = $objCurrency->getPageContent();
require_once(DIR_ADMIN_TMPL . "parsing-nct.tpl.php");
