<?php

class Currency extends Home {

    public $data = array();

    public function __construct($module, $id = 0, $objPost = NULL, $searchArray = array(), $type = '') {
        global $db, $fields, $sessCataId;
        $this->db = $db;
        $this->data['id'] = $this->id = $id;
        $this->fields = $fields;
        $this->module = $module;

        $this->type = ($this->id > 0 ? 'edit' : 'add');
        $this->searchArray = $searchArray;
        parent::__construct();
        $this->table = 'tbl_currency';
            if($this->id>0){
                    $qrySel = $this->db->select($this->table, array("*"),array("id"=>$id))->result();
                    $fetchRes = $qrySel;
                    $this->data['currencyName'] = $this->currencyName = $fetchRes['currencyName'];
                    $this->data['isActive'] = $this->isActive = $fetchRes['isActive'];
                    $this->data['default_cur'] = $this->default_cur = $fetchRes['default_cur'];
                    $this->data['currencyCode'] = $this->currencyCode = $fetchRes['currencyCode'];
                    $this->data['currencySign'] = $this->currencySign = $fetchRes['currencySign'];
                    $this->data['rate_to_usd'] = $this->rate_to_usd = $fetchRes['rate_to_usd'];
                    $this->data['createdDate'] = $this->createdDate = $fetchRes['createdDate'];
            }else{
                    $this->data['currencyName'] = $this->currencyName = '';
                    $this->data['isActive'] = $this->isActive = 'y';
                    $this->data['default_cur'] = $this->default_cur = 'n';
                    $this->data['currencyCode'] = $this->currencyCode = '';
                    $this->data['currencySign'] = $this->currencySign = '';
                    $this->data['createdDate'] = $this->createdDate = '';
                    $this->data['rate_to_usd'] = $this->rate_to_usd = '';
            }
        switch ($type) {
            case 'add' : {
                    $this->data['content'] = (in_array('add', $this->Permission)) ? $this->getForm() : '';
                    break;
                }
            case 'edit' : {
                    $this->data['content'] = (in_array('edit', $this->Permission)) ? $this->getForm() : '';
                    break;
                }
            case 'view' : {
                    $this->data['content'] = (in_array('view', $this->Permission)) ? $this->viewForm() : '';
                    break;
                }
            case 'delete' : {
                    $this->data['content'] = (in_array('delete', $this->Permission)) ? json_encode($this->dataGrid()) : '';
                    break;
                }
            case 'datagrid' : {
                    $this->data['content'] = (in_array('module', $this->Permission)) ? json_encode($this->dataGrid()) : '';
                }
        }
    }

    public function viewForm() {
        $content = "";
        $content = $this->displayBox(array("label" => "Currency Name&nbsp;:", "value" => $this->currencyName)) .
                $this->displayBox(array("label" => "Currency Code&nbsp;:", "value" => $this->currencyCode)).
                $this->displayBox(array("label" => "Currency Sign&nbsp;:", "value" => $this->currencySign)) .
                $this->displayBox(array("label" => "Currency Rate<BR>(compare to <b>USD</b>)&nbsp;:", "value" => $this->rate_to_usd)) .
                $this->displayBox(array("label" => "Created date&nbsp;:", "value" => $this->createdDate)) .
                $this->displayBox(array("label" => "Status&nbsp;:", "value" => $this->isActive == 'y' ? 'Active' : 'Deactive'));
        return $content;
    }

  public function getForm() {
            $content = '';
            $main_content = new MainTemplater(DIR_ADMIN_TMPL.$this->module.'/form-nct.tpl.php');
            $main_content = $main_content->parse();
            $hideShow=($this->default_cur=='y'?'hide':'');
            $default_y=($this->default_cur=='y'?'checked':'');
            $default_n=($this->default_cur!='y'?'checked':'');
            $status_a=($this->isActive == 'y' ? 'checked':'');
            $status_d=($this->isActive != 'y' ? 'checked':'');

            $fields = array("%MEND_SIGN%","%CURRENCY_NAME%","%CURRENCY_CODE%","%CURRENCY_SIGN%","%CURRENCY_RATE%","%STATUS_A%","%STATUS_D%","%TYPE%","%ID%","%HIDE_SHOW%");
            $fields_replace = array(MEND_SIGN,$this->currencyName,$this->currencyCode,$this->currencySign,$this->rate_to_usd,$status_a,$status_d,$this->type,$this->id,$hideShow);
            $content=str_replace($fields,$fields_replace,$main_content);
            return sanitize_output($content);
    }

   public function dataGrid()
    {
            $content = $operation = $whereCond = $totalRow = NULL;
            $result = $tmp_rows = $row_data = array();
            extract($this->searchArray);
            $chr = str_replace(array('_', '%'), array('\_', '\%'),$chr );

            $aWhere = array();
            if (isset($chr) && $chr != '') {
                $aWhere[] = "%$chr%";
                $whereCond .= " AND currencyName LIKE ? ";
            }
            if(isset($sort))
                    $sorting = $sort.' '. $order;
            else
                    $sorting = 'isActive ASC,default_cur ASC,currencyName ASC';


            $qry = "SELECT * FROM tbl_currency WHERE showToAdmin = 'y' ".$whereCond;

            $totalRow = $this->db->pdoQuery($qry, $aWhere)->affectedRows();

            $qrySel = $this->db->pdoQuery($qry . " order by " . $sorting . " limit " . $offset . " ," . $rows . " " , $aWhere)->results();

            foreach($qrySel as $fetchRes)
            {
                    $id =  $fetchRes['id'];
                    $status = $fetchRes['isActive'];
                    $status = ($status=='y')?"checked":"";
                    $default_cur = (isset($fetchRes['default_cur']))?$fetchRes['default_cur']:"";

                    $switch  = $this->toggel_switch(array("action"=>"ajax.".$this->module.".php?id=".$fetchRes['id']."","check"=>$status));
                    $switch=($default_cur!='y')?$switch:'Default';

                    $operation = (in_array('edit',$this->Permission))?$this->operation(array("href"=>"ajax.".$this->module.".php?action=edit&id=".$fetchRes['id']."","class"=>"btn default btn-xs black btnEdit","value"=>'<i class="fa fa-edit"></i>&nbsp;Edit')):'';

                    //$operation .=(in_array('delete',$this->Permission) && $default_cur!='y')?'&nbsp;&nbsp;'.$this->operation(array("href"=>"ajax.".$this->module.".php?action=delete&id=".$fetchRes['id']."","class"=>"btn default btn-xs red btn-delete  ","value"=>'<i class="fa fa-trash-o"></i>&nbsp;Delete')):'';


                    $operation .=(in_array('view', $this->Permission)) ? '&nbsp;&nbsp;' . $this->operation(array("href" => "ajax." . $this->module . ".php?action=view&id=" . $fetchRes['id'] . "", "class" => "btn default blue btn-xs btn-viewbtn", "value" => '<i class="fa fa-laptop"></i>&nbsp;View')) : '';

                    $final_array = array($id,$fetchRes["currencyName"].(($default_cur=='y')?' (Default Currency)':''),$fetchRes['currencyCode'],$fetchRes['rate_to_usd']);

                    if(in_array('status',$this->Permission))
                    {
                            $final_array =  array_merge($final_array, array($switch));
                    }
                    if(in_array('edit',$this->Permission) || in_array('delete',$this->Permission) || in_array('view',$this->Permission) ){
                            $final_array =  array_merge($final_array, array($operation));
                    }
                    $row_data[] = $final_array;
            }
            $result["sEcho"]=$sEcho;
            $result["iTotalRecords"] = (int)$totalRow;
            $result["iTotalDisplayRecords"] = (int)$totalRow;
            $result["aaData"] = $row_data;
            return $result;
    }

    public function displaybox($text) {

        $text['label'] = isset($text['label']) ? $text['label'] : 'Enter Text Here: ';
        $text['value'] = isset($text['value']) ? $text['value'] : '';
        $text['name'] = isset($text['name']) ? $text['name'] : '';
        $text['class'] = isset($text['class']) ? 'form-control-static ' . trim($text['class']) : 'form-control-static';
        $text['onlyField'] = isset($text['onlyField']) ? $text['onlyField'] : false;
        $text['extraAtt'] = isset($text['extraAtt']) ? $text['extraAtt'] : '';

        $main_content = new MainTemplater(DIR_ADMIN_TMPL . $this->module . '/displaybox.tpl.php');
        $main_content = $main_content->parse();
        $fields = array("%LABEL%", "%CLASS%", "%VALUE%");
        $fields_replace = array($text['label'], $text['class'], $text['value']);
        return str_replace($fields, $fields_replace, $main_content);
    }

    public function getSelectBoxOption() {
        $content = '';
        $main_content = new MainTemplater(DIR_ADMIN_TMPL . $this->module . "/select_option-nct.tpl.php");
        $content.= $main_content->parse();
        return sanitize_output($content);
    }

    public function toggel_switch($text) {
        $text['action'] = isset($text['action']) ? $text['action'] : 'Enter Action Here: ';
        $text['check'] = isset($text['check']) ? $text['check'] : '';
        $text['name'] = isset($text['name']) ? $text['name'] : '';
        $text['class'] = isset($text['class']) ? '' . trim($text['class']) : '';
        $text['extraAtt'] = isset($text['extraAtt']) ? $text['extraAtt'] : '';

        $main_content = new MainTemplater(DIR_ADMIN_TMPL . $this->module . '/switch-nct.tpl.php');
        $main_content = $main_content->parse();
        $fields = array("%NAME%", "%CLASS%", "%ACTION%", "%EXTRA%", "%CHECK%");
        $fields_replace = array($text['name'], $text['class'], $text['action'], $text['extraAtt'], $text['check']);
        return str_replace($fields, $fields_replace, $main_content);
    }

    public function operation($text) {

        $text['href'] = isset($text['href']) ? $text['href'] : 'Enter Link Here: ';
        $text['value'] = isset($text['value']) ? $text['value'] : '';
        $text['name'] = isset($text['name']) ? $text['name'] : '';
        $text['class'] = isset($text['class']) ? '' . trim($text['class']) : '';
        $text['extraAtt'] = isset($text['extraAtt']) ? $text['extraAtt'] : '';
        $main_content = new MainTemplater(DIR_ADMIN_TMPL . $this->module . '/operation-nct.tpl.php');
        $main_content = $main_content->parse();
        $fields = array("%HREF%", "%CLASS%", "%VALUE%", "%EXTRA%");
        $fields_replace = array($text['href'], $text['class'], $text['value'], $text['extraAtt']);
        return str_replace($fields, $fields_replace, $main_content);
    }

    public function getPageContent() {
        $final_result = NULL;
        $main_content = new MainTemplater(DIR_ADMIN_TMPL . $this->module . "/" . $this->module . ".tpl.php");
        $main_content->breadcrumb = $this->getBreadcrumb();

        $main_content_parsed = $final_result = $main_content->parse();
        return $final_result;

    }


}
