<?php
class Forms {

    public $category;
    public $status;
    public $data = array();

    public function __construct($module, $id=0, $objPost=NULL, $searchArray=array(), $type='') {
        global $db, $fields, $sessCataId,$lId;
        $this->db          = $db;
        $this->data['id']  = $this->id = $id;
        $this->fields      = $fields;
        $this->module      = $module;
        $this->table       = 'tbl_services';
        $this->type        = ($this->id > 0 ? 'edit' : 'add');
        $this->searchArray = $searchArray;
        $this->action      = isset($searchArray['action']) ? $searchArray['action'] : '';
        if($this->action == 'add_dependency'){
            $type = 'edit';
        }

        $this->dep_id = isset($searchArray['dep_id']) ? $searchArray['dep_id'] : 0;
        $this->langId = isset($searchArray['langId']) ? $searchArray['langId'] : $lId;
        if($this->id>0){
        $qrySel1 = $this->db->select("tbl_forms_elements", array('*'), array('id'=>$this->id))->results();
            foreach($qrySel1 as $r){
                $this->data['form_id']         = $this->form_id = $r['form_id'];
                $this->data['element_type_id'] = $this->element_type_id = $r['element_type_id'];
                $this->data['createdDate']     = $this->createdDate = $r['createdDate'];
                $this->data['status']          = $this->status = $r['status'];
            }
        }
        else{
                $this->data['form_id']         = $this->form_id = 0;
                $this->data['element_type_id'] = $this->element_type_id = 0;
                $this->data['createdDate']     = $this->createdDate = '';
                $this->data['status']          = $this->status = '';
        }
        switch($type){
            case 'add' : {
                $this->data['content'] =  $this->getForm();
                break;
            }
            case 'edit' : {
                $this->data['content'] =  $this->getForm();
                break;
            }
            case 'edit-fields' : {
                $this->data['content'] =  $this->getEditForm();
                break;
            }
            case 'view' : {
                $this->data['content'] =  $this->viewForm();
                break;
            }
            case 'delete' : {
                $this->data['content'] =  json_encode($this->dataGrid());
                break;
            }
            default : {
                $this->data['content'] =  json_encode($this->dataGrid());
            }
        }
    }

    public function viewForm(){
        $content        =NULL;
        $category       = getTableValue("tbl_category_values",'fieldvalue',array('contentid' =>$this->cateId,'langid' =>1,'fieldid' =>1));
        $subCategory_id = getTableValue("tbl_sub_category",'id',array('cat_id' =>$this->cateId,'id' =>$this->subCatId));
        $subCategory    = getTableValue("tbl_sub_category_values",'fieldvalue',array('contentid' =>$subCategory_id,'langid' =>1,'fieldid' =>1));
        $status         = ($this->status == 1) ? 'Active' : 'InActive';
        $content =
            $this->fields->displayBox(array("label"=>"Template Name&nbsp;:","value"=>$this->templateName)).
            $this->fields->displayBox(array("label"=>"Category&nbsp;:","value"=>$category)).
            $this->fields->displayBox(array("label"=>"Sub-Category&nbsp;:","value"=>$subCategory)).
            $this->fields->displayBox(array("label"=>"Total Fields&nbsp;:","value"=>$this->numOfFields)).
            $this->fields->displayBox(array("label"=>"Created Date&nbsp;:","value"=>$this->createdDate)).
            $this->fields->displayBox(array("label"=>"Status&nbsp;:","value"=>$status));
            if($this->numOfFields > 0)
            {
                $content .='<div class="clearfix"></div><hr/><h4>Fields detail</h4>';
                $qrySel1 = $this->db->select("tbl_fields", array('*'), array('templateId'=>$this->id))->results();

                foreach($qrySel1 as $r){
                    $this->data['fieldName']    = $this->fieldName = $r['fieldName'];
                    $this->data['label']        = $this->label = $r['label'];
                    $this->data['name']         = $this->name = $r['name'];
                    $this->data['field_values'] = $this->field_values = $r['field_values'];
                    $this->data['defaultValue'] = $this->defaultValue = $r['defaultValue'];

                    $content .= '<div class="clearfix"></div><hr/>'.
                    $this->fields->displayBox(array("label"=>"Field Type&nbsp;:","value"=>$this->fieldName)).
                    $this->fields->displayBox(array("label"=>"Field Label&nbsp;:","value"=>$this->label)).
                    $this->fields->displayBox(array("label"=>"Field Name&nbsp;:","value"=>$this->name)).
                    $this->fields->displayBox(array("label"=>"Field Value&nbsp;:","value"=>$this->field_values)).
                    $this->fields->displayBox(array("label"=>"Default Value&nbsp;:","value"=>$this->defaultValue));
                }

            }

        return $content;
    }
     public function child_tree($parent, $spacing = '', $user_tree_array = '', $whereS = '')
    {
        if (!is_array($user_tree_array))
            $user_tree_array = array();
        $sqlCategory = "SELECT id,caption_1,dependent_qid FROM tbl_forms_elements WHERE id = '" . $parent . "' ORDER BY id ASC";
        $resCategory = $this->db->pdoQuery($sqlCategory)->result();
        $num_rows    = $this->db->pdoQuery($sqlCategory)->affectedRows();
        if ($num_rows > 0) {
            $user_tree_array[] = array(
                "queId" => $resCategory['dependent_qid'],
                "caption" => $spacing . (wordwrap($resCategory['caption_1'],50,"<br>\n"))
            );
            $user_tree_array   = $this->child_tree($resCategory['dependent_qid'], '&nbsp;' . $spacing . '<i class="fa fa-arrow-right" aria-hidden="true"></i>&nbsp;', $user_tree_array);
        }
        //pr($user_tree_array);
        return $user_tree_array;
    }
    public function getForm() {

        $content = '';

        $content .='
                <div id="getDropDown" class="hide">
                    <div class ="par">
                        <div class="form-group ">
                            <label for="fieldType_new[]" class="control-label col-md-3">'.MEND_SIGN.'Field type: &nbsp;</label>
                                <div class="col-md-4">
                                    <div class="input-group">'.
                    $this->selectBox(array(
                        "label"=>"".MEND_SIGN."Field type:",
                        "name"=>"element[][element_id]",
                        "defaultValue"=>false,
                        "allow_null"=>1,
                        "allow_null_value"=>NULL,
                        "onlyField"=>true,
                        "extraAtt"=>"data-count='-1' data-error-container='.error-div-1'",
                        "class"=>"selectBox-bg fieldType required",
                        "choices"=>array(""=>""),
                        "defaultValue"=>true,
                        "multiple"=>false,
                        "optgroup"=>false,
                        "intoDB"=>array("val"=>true,
                                "table"=>"tbl_elements_types",
                                "custom"    =>true,
                                "fields"=>"*",
                                "where"=>"status = 'y'",
                                "orderBy"=>"id",
                                "valField"=>"id",
                                "dispField"=>"name")
                    ))."
                <span class='input-group-addon'>
                    <a href='javascript:void(0)' class='remove_new' title='Remove' data-eleId = '0'>
                        <i class='fa fa-trash-o'></i>
                    </a>
                </span>
                </div>
                <div class='error-div-x'></div>
             </div>
           </div>
           <div class='contentdiv'>";
           $content .="</div>
           </div>
         </div>";
        $content .= '<form action="'.SITE_ADM_MOD.'forms-nct/index.php" name="frmCont" id="frmCont" method="post" class="form-horizontal" novalidate="novalidate" enctype="multipart/form-data">
            <div class="form-body">';
            if($this->action == 'add_dependency'){
                $getFrmId =  getTableValue("tbl_forms_elements",'form_id',array('id' =>$this->dep_id));
            }else{
                $getFrmId = $this->id;
            }
            $formName = getTableValue("tbl_forms",'name',array('id' =>$getFrmId));
            $content .='<div class="form-group ">
                                <label for="fieldType_new[]" class="control-label col-md-3">Form Name: &nbsp;</label>
                                <div class="col-md-4">
                                   <input type="text" value="'.$formName.'" class="form-control"  disabled>
                                   <input type="hidden" value="'.$getFrmId.'" name="form_id">
                                </div>
                        </div>';
            if($this->action == 'add_dependency'){
                $depName = getTableValue("tbl_forms_elements",'caption_1',array('id' =>$this->dep_id));
                $content .= '<input type="hidden" value="'.$this->action.'" name="action">';
                $content .='<div class="form-group ">
                                <label for="dep_que" class="control-label col-md-3">Dependent Question : &nbsp;</label>
                                <div class="col-md-4">
                                    <label>'.$depName.'</label>
                                    <input type="hidden" value="'.$this->dep_id.'" name="dependent_qid">
                                </div>
                        </div>';
                $getLstAns = $this->db->pdoQuery("SELECT * FROM tbl_elements_list_values WHERE element_id = ?",array($this->dep_id))->results();
                $content .='<div class="form-group ">
                                <label for="dependent_opt_id" class="control-label col-md-3">'.MEND_SIGN.'Select Dependent Answer: &nbsp;</label>
                                <div class="col-md-4">
                                        <select name="dependent_opt_id" id="dependent_opt_id" class="form-control selectBox-bg required">';
                foreach ($getLstAns as $lstValue) {
                    $content .= "<option value=".$lstValue['id'].">".filtering($lstValue['value_1'])."</div>";
                }
                $content .= '
                                        </select>
                                </div>
                            </div>';
            }
            $content.= '<div class="divAddMore">';
            $content.= '<input type="hidden" id="ele" value="0">';

            $elementList = $this->db->pdoQuery("SELECT * FROM tbl_forms_elements WHERE form_id = ?",array($this->id));
            if($elementList->affectedRows() > 0 && $this->action != 'add_dependency'){
                $elementValueList = $elementList->results();
                $extele = '';
                $eleTot = 0;
                $totEle = $this->db->pdoQuery("SELECT id FROM tbl_forms_elements WHERE form_id = ?",array($this->id))->affectedRows();
                $totEle = $totEle - 1;
                if($totEle < 0){
                    $totEle = 0;
                }
                foreach ($elementValueList as $key => $list) {
                    $content .="<div class='col-lg-12 removeValueDiv'>";
                    $content .="<div class='col-lg-7 dottedBorder'>";
                    $elementType = getTableValue('tbl_elements_types','name',array('id' =>$list['element_type_id']));
                    /*display dependency*/
                    if($list['is_dependent'] == 'y' && $list['dependent_qid'] > 0 && $list['dependent_opt_id'] > 0){
                        $depName = getTableValue("tbl_forms_elements",'caption_1',array('id' => $list['dependent_qid']));
                        $level           = $list['caption_1'];
                        $QueDetails = $this->child_tree($list['dependent_qid'], '<br> <i class="fa fa-arrow-right" aria-hidden="true"></i> ');
                        foreach ($QueDetails as $k => $v) {
                            $level .= $v['caption'];
                        }
                        $dispLevel = $level;
                        $content .='
                                <div class="form-group dep_div">
                                    <label for="dep_que" class="control-label col-md-5">Selected Dependent Question : &nbsp;</label>
                                    <div class="col-md-7">
                                        <label>'.$level.'</label>
                                    </div>
                                </div>';
                    }
                   $content .='
                        <div class ="par">
                            <div class="form-group ">
                                <label for="fieldType_new[]" class="control-label col-md-5">'.MEND_SIGN.'Field type: &nbsp;</label>
                                    <div class="col-md-4">
                                        <div class="input-group">
                                        <label for="" class="control-label ">'.
                                 $elementType."
                                 </label>
                                    </div>
                                </div>
                            </div>
                        <div class='contentdiv'>";
                            $fields = $this->db->pdoQuery("SELECT * FROM tbl_elements_types WHERE id = ?",array($list['element_type_id']))->result();
                            $language = $this->db->pdoQuery("SELECT l.id as lid,l.languageName FROM  tbl_language as l WHERE l.status= ? AND l.id = ? ORDER BY l.id ASC ",array('a',$this->langId))->results();

                        foreach ($language as $lang) {
                            $content .='
                                <div class="form-group">
                                    <label for="" class="control-label col-md-5">'.MEND_SIGN.''.$fields['name'].' Label ('.$lang['languageName'].'): &nbsp;
                                    </label>
                                    <div class="col-md-4">
                                        <label for="" class="">
                                        '.filtering($list['caption_'.$lang['lid']]).'
                                        </label>
                                    </div>
                                </div>';
                        }
                        if($list['element_type_id'] > 2){
                            $tot = $this->db->pdoQuery("SELECT * FROM tbl_elements_list_values WHERE form_id = ? AND element_id = ?",array($this->id,$list['id']));
                            $totCount = $tot->affectedRows();

                            $resultValue = $tot->results();
                            $i=1;
                            foreach ($resultValue as $key => $value) {
                                foreach ($language as $lang) {

                                    $content .='
                                        <div class="form-group">
                                            <label for="" class="control-label col-md-5">'.MEND_SIGN.$fields['name'].' Value  ('.$lang['languageName'].'): &nbsp;
                                            </label>
                                            <div class="col-md-7">
                                                <label for="" class="">
                                                    '.filtering($value['value_'.$lang['lid']]).'
                                                </label>
                                            </div>
                                        </div>';
                                }
                                if($list['element_type_id'] == 6){

                                    $image = checkImage("form_images/".$value['element_id']."/",$value['image']);
                                    $content .='
                                        <div class="form-group">
                                            <label for="" class="control-label col-md-5"> Images: &nbsp;
                                            </label>
                                            <div class="col-md-7">
                                                <img src="'.$image.'" width="100px" >
                                            </div>
                                        </div>';
                                }
                                $content .='<input type="hidden" name="element['.$eleTot.'][value_edit_id][]" value="'.$value['id'].'">';

                                $i++;
                            }
                        }
                        $content .="</div>
                            </div>";
                        $content .='
                        <div class="col-md-12">
                            <div class="col-md-offset-4 col-md-2 mrg-btm">
                                <span class="input-group-btn">
                                    <a class="btn btn-success blue btnEdit" href="'.SITE_ADM_MOD.'forms-nct/ajax.'.$this->module.'.php?action=edit-fields&id='.$list['id'].'" data-type ="edit-fields">
                                        <i class="fa fa-pencil"></i>&nbsp;Edit
                                    </a>
                                </span>
                            </div>
                            <div class="col-md-2 mrg-btm">
                                <span class="input-group-btn">
                                    <a class="btn btn-success red removeElement" href="'.SITE_ADM_MOD.'forms-nct/ajax.'.$this->module.'.php?action=removeElements&id='.$list['id'].'">
                                        <i class="fa fa-trash-o"></i>&nbsp;Delete
                                    </a>
                                </span>
                            </div>
                        </div>
                        <div class="col-md-12">';
                         if($list['element_type_id'] == 3 || $list['element_type_id'] == 4){
                             $content .='
                                    <div class="col-md-offset-4 col-md-2 mrg-btm">
                                        <span class="input-group-btn">
                                            <a class="btn btn-success yellow btnEdit" href="'.SITE_ADM_MOD.'forms-nct/ajax.'.$this->module.'.php?action=add_dependency&id='.$list['id'].'" data-type ="add_dependency">
                                                <i class="fa fa-sitemap" aria-hidden="true"></i>&nbsp;Add dependency
                                            </a>
                                        </span>
                                    </div>
                                ';
                        }
                        if($list['is_dependent'] == 'y'){
                            /**/
                            $content .='<div class="clearfix"></div>
                                    <div class="col-md-offset-4 col-md-2 mrg-btm">
                                        <span class="input-group-btn">
                                            <a class="btn btn-success red btn-delete" href="'.SITE_ADM_MOD.'forms-nct/ajax.'.$this->module.'.php?action=remove_dependency&id='.$list['id'].'" data-type ="remove_dependency">
                                                <i class="fa fa-times" aria-hidden="true"></i>&nbsp;Remove dependency
                                            </a>
                                        </span>
                                    </div>
                                ';
                        }
                        $eleTot++;
                        $content .="
                        </div>
                            </div>

                            </div>";
                }
                 //$content .= $extele;
                /*<div class='col-lg-1 padding0 cross' >
                    <a href='javascript:void(0)' class='removeValuess' data-valueId = ".$value['id']." >
                        <i class='fa fa-times colorRed'></i>
                    </a>
                </div>*/
            }else{
            }

            $content .='</div><label class="col-md-3">&nbsp;</label><div class="col-md-4"><span class="input-group-btn"><button class="btn btn-success add-more" type="button"><i class="fa fa-plus"></i>&nbsp;Add more</button></span></div><div class="clearfix"></div>';

            $content .= '<input type="hidden" value="'.$this->type.'" name="type" id="type" />
                    <input type="hidden" value="'.$this->id.'" name="id" id="id" />
                    </div>
            <div class="form-actions fluid">
            <div class="col-md-offset-3 col-md-9">
            <input type="hidden" name="submitAddForm">'.
            $this->button(array("onlyField"=>true,"name"=>"submitAddForm", "type"=>"submit", "class"=>"green", "value"=>"Submit", "extraAtt"=>"")).
            $this->button(array("onlyField"=>true,"name"=>"cn", "type"=>"button", "class"=>"btn-toggler", "value"=>"Cancel", "extraAtt"=>"")).'
            </div></div>';

            $content .= '</form>';
        return sanitize_output($content);
    }
    public function getEditForm(){
        $content ='';
        $eleTot = 0;
            $language = $this->getLanguage();
            $fQuery = $this->db->pdoQuery("SELECT * FROM tbl_forms_elements WHERE id = ?",array($this->id));
            if($fQuery->affectedRows() > 0){
                $list = $fQuery->result();
                $frmId = $list['form_id'];
                $i = 0;
                $labelName = getTableValue('tbl_elements_types','name',array('id' =>$list['element_type_id']));

                 $content .='
                <form action="'.SITE_ADM_MOD.'forms-nct/ajax.forms-nct.php" name="frmEditCont" id="frmEditCont" method="post" class="form-horizontal" novalidate="novalidate" enctype="multipart/form-data">';
                    $tot = $this->db->pdoQuery("SELECT * FROM tbl_elements_list_values WHERE element_id = ?",array($this->id));
                    $resultValue = $tot->results();
                    if($list['is_dependent'] == 'y' && $list['dependent_qid'] > 0 && $list['dependent_opt_id'] > 0){
                        $depName = getTableValue("tbl_forms_elements",'caption_1',array('id' => $list['dependent_qid']));
                        $content .= '<input type="hidden" value="edit_dependency" name="edit_action">';
                        $content .='<div class="form-group ">
                                        <label for="dep_que" class="control-label col-md-3">Dependent Question : &nbsp;</label>
                                        <div class="col-md-4">
                                            <label>'.$depName.'</label>
                                            <input type="hidden" value="'. $list['dependent_qid'].'" name="dependent_qid">
                                        </div>
                                </div>';
                        $getLstAns = $this->db->pdoQuery("SELECT * FROM tbl_elements_list_values WHERE element_id = ?",array( $list['dependent_qid']))->results();
                        $content .='<div class="form-group ">
                                        <label for="dependent_opt_id" class="control-label col-md-3">'.MEND_SIGN.'Select Dependent Answer: &nbsp;</label>
                                        <div class="col-md-4">
                                                <select name="dependent_opt_id" id="dependent_opt_id" class="form-control selectBox-bg required">';
                        foreach ($getLstAns as $lstValue) {
                            $selected = ($lstValue['id'] == $list['dependent_opt_id'] ? "selected = 'selected'"  : "");
                            $content .= "<option ".$selected." value=".$lstValue['id'].">".$lstValue['value_1']."</div>";
                        }
                        $content .= '
                                                </select>
                                        </div>
                                    </div>';
                    }
                    $content .='<div class="form-group">
                                    <label class="control-label col-md-3"> Field Type: &nbsp;
                                    </label>
                                    <div class="col-md-4">
                                       <label class="">
                                       '.$labelName.'
                                    </label>
                                    </div>
                                </div>';
                    foreach ($language as $lang) {
                            $content .='
                                <div class="form-group">
                                    <label for="element[label_e]['.$lang['lid'].']" class="control-label col-md-3">'.MEND_SIGN.''.$labelName.' Label ('.$lang['languageName'].') : &nbsp;
                                    </label>
                                    <div class="col-md-4">
                                        <input type="text" class="form-control required" name="element[label_e]['.$lang['lid'].']" value="'.filtering($list['caption_'.$lang['lid']]).'" >
                                        <input type="hidden" name="element[edit_id]" value="'.$list['id'].'"">
                                    </div>
                                </div>';
                    }
                    if($list['element_type_id'] > 2){
                        foreach ($resultValue as $key => $value) {
                            $content .="<div class='col-lg-12 removeValueDiv'>";

                            $content .="<div class='col-lg-7 dottedBorder'>";
                            foreach ($language as $lang) {
                                    $content .='
                                        <div class="form-group">
                                            <label for="" class="control-label col-md-5">'.MEND_SIGN.$labelName.' Value  ('.$lang['languageName'].'): &nbsp;
                                            </label>
                                            <div class="col-md-7">
                                                <input type="text" class="form-control required" name="element[value_e]['.$eleTot.']['.$lang['lid'].']" value="'.filtering($value['value_'.$lang['lid']]).'" >

                                            </div>
                                        </div>';
                            }
                            $content .='<input type="hidden" name="element[value_edit_id][]" value="'.$value['id'].'">';

                            if($list['element_type_id'] == 6){
                                $image = checkImage("form_images/".$value['element_id']."/",$value['image']);
                                $content .='
                                            <div class="form-group">
                                                <label for="element[value]['.$lang['lid'].']" class="control-label col-md-5">'.MEND_SIGN.'Select Images'.': &nbsp;
                                                </label>
                                                <div class="col-md-7">
                                                    <input type="file" name="file_e['.$eleTot.']" class="">
                                                </div>
                                            </div>';
                                $content .='
                                    <div class="form-group">
                                        <label for="" class="control-label col-md-5"> Images: &nbsp;
                                        </label>
                                        <div class="col-md-7">
                                            <img src="'.$image.'" width="100px" >
                                        </div>
                                    </div>';
                            }
                            $content .='</div>
                                        <div class="col-lg-1 padding0 cross">
                                        <a href="javascript:void(0)" class="removeValue" data-valueId = "'.$value['id'].'" >
                                            <i class="fa fa-times colorRed"></i>
                                        </a>
                                    </div>
                                    </div>';
                            $content .="<div class='clearfix'></div>";
                            $eleTot++;
                        }

                        $content .='
                        <div class="par">
                            <div class="contentdiv"></div>
                            <div class="col-md-offset-3 col-md-2 mrg-btm">
                                <span class="input-group-btn">
                                    <button class="btn btn-success blue " id="editAddNew" type="button" >
                                        <i class="fa fa-plus"></i>&nbsp;Add More
                                    </button>
                                </span>
                            </div>
                        </div>
                        <div class="clearfix"></div>';
                    }


                $content .="<input type='hidden' id='element_type_id' name='element_type_id' value='".$list['element_type_id']."' >";
                $content .="<input type='hidden' name='formId' value='".$frmId."' >";

                $content .= '
                    <input type="hidden" value="'.$this->type.'" name="type" id="type" />
                    <input type="hidden" value="'.$this->id.'" name="id" id="id" />
                    </div>
                <div class="form-actions fluid">
                <div class="col-md-offset-3 col-md-9">
                <input type="hidden" name="submitEditForm">'.
                $this->button(array("onlyField"=>true,"name"=>"submitEditForm", "type"=>"submit", "class"=>"green", "value"=>"Submit", "extraAtt"=>"")).'
                <a href="'.SITE_ADM_MOD.'forms-nct/ajax.'.$this->module.'.php?action=edit&id='.$frmId.'" name="cn" class="btn default btn-toggler btnEdit" id="cn" data-formid="'.$frmId.'">Cancel</a>
                </div></div>';

                $content .= '</form>';
                }


        return $content;
    }

    public function getFieldValue() {

    }
     public function button($btn) {
        $btn['value']                = isset($btn['value']) ? $btn['value'] : '';
        $btn['name']                 = isset($btn['name']) ? $btn['name'] : '';
        $btn['class']                = isset($btn['class']) ? 'btn ' . $btn['class'] : 'btn';
        $btn['type']                 = isset($btn['type']) ? $btn['type'] : '';
        $btn['src']                  = isset($btn['src']) ? $btn['src'] : '';
        $btn['extraAtt']             = isset($btn['extraAtt']) ? ' ' . $btn['extraAtt'] : '';
        $btn['onlyField']            = isset($btn['onlyField']) ? $btn['onlyField'] : false;
        $btn["src"]                  = ($btn["type"] == "image" && $btn["src"] != '') ? $btn["src"] : '';

        $main_content_only_field     = new MainTemplater(DIR_ADMIN_FIELDS_HTML . 'button_onlyfield.tpl.php');
        $main_content_only_field     = $main_content_only_field->parse();
        $fields                      = array("%TYPE%", "%NAME%", "%CLASS%", "%ID%", "%SRC%", "%EXTRA%", "%VALUE%");
        $fields_replace              = array($btn["type"], $btn["name"], $btn["class"], $btn["name"], $btn["src"], $btn['extraAtt'], $btn["value"]);
        $sub_final_result_only_field = str_replace($fields, $fields_replace, $main_content_only_field);

        if ($btn['onlyField'] == true) {
            return $sub_final_result_only_field;
        } else {
            $main_content = new MainTemplater(DIR_ADMIN_FIELDS_HTML . 'button.tpl.php');
            $main_content = $main_content->parse();
            $fields = array("%BUTTON%");
            $fields_replace = array($sub_final_result_only_field);
            return str_replace($fields, $fields_replace, $main_content);
        }
    }
    function selectBox($field = array()) {
        global $db;
        $fields                     = '';
        $field['label']             = isset($field['label']) ? $field['label'] : array();
        $field['id']                = isset($field['id']) ? $field['id'] : $field['name'];
        $field['value']             = isset($field['value']) ? $field['value'] : '';
        $field['class']             = isset($field['class']) ? 'form-control ' . $field['class'] : 'form-control';
        $field['multiple']          = isset($field['multiple']) ? $field['multiple'] : false;
        $field['arr']               = isset($field['arr']) ? $field['arr'] : true;
        $field['defaultValue']      = isset($field['defaultValue']) ? $field['defaultValue'] : false;
        $field['allow_null']        = isset($field['allow_null']) ? $field['allow_null'] : false;
        $field['allow_null_value']  = isset($field['allow_null_value']) ? $field['allow_null_value'] : 0;
        $field['choices']           = isset($field['choices']) ? $field['choices'] : array();
        $field['optgroup']          = isset($field['optgroup']) ? $field['optgroup'] : false;
        $field['onlyField']         = isset($field['onlyField']) ? $field['onlyField'] : false;
        $field['intoDB']            = isset($field['intoDB']) ? $field['intoDB'] : array();

        $field['intoDB']["val"]     = isset($field['intoDB']["val"]) ? $field['intoDB']["val"] : false;
        $field['intoDB']["groupBy"] = isset($field['intoDB']["groupBy"]) ? ' ' . $field['intoDB']["groupBy"] : '';
        $field['intoDB']["orderBy"] = isset($field['intoDB']["orderBy"]) ? ' ' . $field['intoDB']["orderBy"] : '';
        $field['intoDB']["where"] = isset($field['intoDB']["where"]) ? ' ' . $field['intoDB']["where"] : '';
        $field['intoDB']["custom"] = isset($field['intoDB']["custom"]) ? ' ' . $field['intoDB']["custom"] : '';

        $field['extraAtt']          = isset($field['extraAtt']) ? ' ' . $field['extraAtt'] : '';
        $field['isArray']           = isset($field['isArray']) ? $field['isArray'] : '';
        $optiongroup_flag           = false;
        $final_result_suboptions    = NULL;
        if (empty($field['choices'])) {
            return false;
        }
        if ($field['intoDB']["val"] == true) {
            $field['choices'] = array();

            if ($field['intoDB']["custom"] == true) {
                $get1 = $db->pdoQuery("select " . $field['intoDB']["fields"] . " from " . $field['intoDB']["table"] . " where " . $field['intoDB']["where"] . " order by " . $field['intoDB']["orderBy"] . " ")->results();
            } else {
                $get1 = $db->select($field['intoDB']["table"], $field['intoDB']["fields"], $field['intoDB']["where"], "ORDER BY " . $field['intoDB']["orderBy"])->results();
            }
            foreach ($get1 as $checkVal) {
                $field['choices'][$checkVal[$field['intoDB']["valField"]]] = $checkVal[$field['intoDB']["dispField"]];
            }
        }

        $multiple = '';
        if ($field['multiple'] == 'true' || $field['multiple'] == true) {
            $multiple = ' multiple="multiple" size="5" ';
            if ($field['arr'] == 'true') {
                $field['name'] .= '[]';
            }
        }
        $id = ($field['isArray'] != 'true') ? $field['id'] : "";

        $main_content_only_field = new MainTemplater(DIR_ADMIN_FIELDS_HTML . 'select_onlyfield.tpl.php');
        $main_content_only_field = $main_content_only_field->parse();

        $fields.='<select name="' . $field['name'] . '" id="' . $id . '"  class="' . $field['class'] . '" ' . $multiple . ' ' . $field['extraAtt'] . '>';

        // null
        $main_content_options = new MainTemplater(DIR_ADMIN_FIELDS_HTML . 'select_options.tpl.php');
        $main_content_options = $main_content_options->parse();
        $content_fields = array("%VALUE%", "%SELECTED%", "%DISPLAY_VALUE%");
        $final_result_options = '';
        if ($field['allow_null'] == '1') {
            //$fields.= '<option value="'.$field['allow_null_value'].'">Please Select</option>';
            $content_fields_replace = array($field['allow_null_value'], '', 'Please Select');
            $final_result_options .= str_replace($content_fields, $content_fields_replace, $main_content_options);
        }


        // loop through values and add them as options
        foreach ($field['choices'] as $key => $value) {
            if ($field['optgroup']) {
                $main_content_optiongroup = new MainTemplater(DIR_ADMIN_FIELDS_HTML . 'select_optiongroup.tpl.php');
                $main_content_optiongroup = $main_content_optiongroup->parse();
                $content_fields_optiongroup = array("%VALUE%", "%OPTIONS%");

                // this select is grouped with optgroup

                if ($value) {
                    foreach ($value as $id => $label) {
                        $selected = '';
                        if (is_array($field['value']) && in_array($id, $field['value'])) {
                            $selected = 'selected="selected"';
                        } else {
                            // 3. this is not a multiple select, just check normaly
                            if ($id == $field['value']) {
                                $selected = 'selected="selected"';
                            }
                        }
                        $content_fields_replace = array($id, $selected, $label);
                        $final_result_suboptions .= str_replace($content_fields, $content_fields_replace, $main_content_options);
                    }
                }
                if ($key != '') {
                    $optiongroup_flag = true;
                    $content_fields_optiongroup_replace = array($key, '', $final_result_suboptions);
                    $final_result_optiongroup .= str_replace($content_fields_optiongroup, $content_fields_optiongroup_replace, $main_content_optiongroup);
                }
            } else {
                $selected = '';
                if (is_array($field['value']) && in_array($key, $field['value'])) {
                    // 2. If the value is an array (multiple select), loop through values and check if it is selected
                    $selected = 'selected="selected"';
                } else {
                    // 3. this is not a multiple select, just check normaly
                    if ($key == $field['value']) {
                        $selected = 'selected="selected"';
                    }
                }

                $content_fields_replace = array($key, $selected, ucfirst(stripslashes($value)));
                $final_result_options .= str_replace($content_fields, $content_fields_replace, $main_content_options);
            }
        }
        $final_result_options .=($optiongroup_flag == true) ? $final_result_optiongroup : $final_result_suboptions;

        $content_fields = array("%NAME%", "%ID%", "%CLASS%", "%MULTIPLE%", "%EXTRA%", "%OPTIONS%");
        $content_fields_replace = array($field['name'], $id, $field['class'], $multiple, $field['extraAtt'], $final_result_options);
        $final_result_only_field = str_replace($content_fields, $content_fields_replace, $main_content_only_field);

        if ($field["onlyField"] == true) {
            return $final_result_only_field;
        } else {
            $main_content           = new MainTemplater(DIR_ADMIN_FIELDS_HTML . 'select.tpl.php');
            $main_content           = $main_content->parse();
            $content_fields         = array("%LABEL%", "%SELECT_BOX%");
            $content_fields_replace = array($field['label'], $final_result_only_field);
            $final_result           = str_replace($content_fields, $content_fields_replace, $main_content);
            return $final_result;
        }
    }
    public function getLanguage($id=0) {
        $whr = ($id>0 ? "$id = ".$id : '');
        $language = $this->db->pdoQuery("SELECT l.id as lid,l.languageName FROM  tbl_language as l WHERE l.status= ? ".$whr." ORDER BY l.id ASC ",array('a'))->results();
        return $language;
    }
    public function dataGrid() {
        $content = $operation = $whereCond = $totalRow = NULL;
        $result = $tmp_rows = $row_data = array();
        extract($this->searchArray);
        $chr = str_replace(array('_', '%'), array('\_', '\%'),$chr );
        $aWhere['isactive'] = 'y';
        $sWhere = '';
        if(isset($chr) && $chr != '') {
            $aWhere["pagename LIKE"] = "%$chr%";
        }
        if(isset($sort))
            $sorting = $sort.' '. $order;
        else
            $sorting = 'id DESC';

        $totalRow = $this->db->count("tbl_category", $aWhere);

        $qrySel = $this->db->select("tbl_category", array('id,pagename'), $aWhere, " ORDER BY $sorting LIMIT $offset , $rows")->results();

        foreach($qrySel as $fetchRes) {
            $qryCnt = "SELECT * FROM tbl_forms WHERE cat_id = '".$fetchRes['id']."'";
            $qrySelcnt = $this->db->query($qryCnt);
            $total =0;
            foreach($qrySelcnt as $qryCnt) {
                $total += 1;
            }

            $row_ques = array();
            $qrySel1 = $this->db->select("tbl_forms", array('*'), array('cat_id'=>(int)$fetchRes['id']), " ORDER BY id DESC")->results();
            foreach($qrySel1 as $r){
                $cateId = getTableValue("tbl_category",'pagename',array('id' =>$r['cat_id']));
                $subCatId = getTableValue("tbl_sub_category",'pagename',array('cat_id' =>$r['cat_id'],'id'=>$r['sub_cat_id']));
                $tot = $this->db->pdoQuery("SELECT COUNT(id) AS total FROM tbl_forms_elements WHERE form_id = ?",array($r['id']))->result();
                $totFields = $tot['total'];
                $switch  = '<div class="switch-small"><input type="checkbox" class="make-switch" data-action="ajax.'.$this->module.'.php?id='.$r['id'].'" '.($r['status'] == 'y' ? 'checked="checked"' : '').' data-on-label="<i class=\'fa fa-check\'></i>" data-off-label="<i class=\'fa fa-times\' ></i>" ></div>';
                $operation1 = '<a href="ajax.forms-nct.php?action=view&id='.$r['id'].'"class="btn default blue btn-xs btn-viewbtn"><i class="fa fa-laptop"></i>&nbsp;View</a>&nbsp;&nbsp;<a href="ajax.'.$this->module.'.php?action=edit&id='.$r['id'].'" class="btn default btn-xs black btnEdit"><i class="fa fa-edit"></i>&nbsp;Edit</a>&nbsp;&nbsp;<a href="ajax.'.$this->module.'.php?action=delete&id='.$r['id'].'" class="btn default btn-xs red btn-delete"><i class="fa fa-trash-o"></i>&nbsp;Delete</a>';
                $row_ques[] = array($r['id'],'templateName'=>$r['name'],'numOfFields'=>$totFields,'status'=>$switch, 'operation'=>$operation1);
            }
            $row_data[] = array('pagename'=>$fetchRes['pagename'],'operation'=>$total,'details'=>$row_ques);
        }
        $result["sEcho"]=$sEcho;
        $result["iTotalRecords"] = (int)$totalRow;
        $result["iTotalDisplayRecords"] = (int)$totalRow;
        $result["aaData"] = $row_data;
        return $result;
    }
}