<?php
class Form_List extends Home {

	public $constantValue;
	public $constantName;
	public $data = array();

	public function __construct($module,$id=0, $searchArray=array(), $type='') {
		global $db, $fields, $sessCataId;
		$this->db = $db;
		$this->data['id'] = $this->id = $id;
		$this->fields = $fields;
		$this->module = $module;
		$this->table = 'tbl_forms';

		$this->type = ($this->id > 0 ? 'edit' : 'add');
		$this->searchArray = $searchArray;
		parent::__construct();
		$this->image1 = array();
		if($this->id>0){
			$qrySel = $this->db->select($this->table, array('*'),array("id"=>$id))->result();
			$fetchRes = $qrySel;
			$this->data['name']   = $this->name = $fetchRes['name'];
			$this->data['id']            = $this->id = $fetchRes['id'];
			$this->data['created_date']   = $this->created_date = $fetchRes['created_date'];
			$this->data['status']      = $this->status = $fetchRes['status'];
		}
		else{
			$this->data['id']            = $this->id = '';
			$this->data['name']   = $this->name = '';
			$this->data['created_date']   = $this->created_date = '';
			$this->data['status']      = $this->status = 'y';
		}

		switch($type){
			case 'add' : {
				$this->data['content'] =  (in_array('add',$this->Permission))?$this->getForm():'';
				break;
			}
			case 'edit' : {
				$this->data['content'] =  (in_array('edit',$this->Permission))?$this->getForm():'';
				break;
			}
			case 'view' : {
				$this->data['content'] =  (in_array('view',$this->Permission))?$this->viewForm():'';
				break;
			}
			case 'delete' : {
				$this->data['content'] = (in_array('delete',$this->Permission))?json_encode($this->dataGrid()):'';
				break;
			}case 'langArray':{
                $qryLang = $this->db->select("tbl_language", array("id", "languageName"), array("status" => 'a'), "ORDER BY languageName")->results();
                foreach ($qryLang as $fetchLang) {
                    $this->langArray[$fetchLang['id']] = $fetchLang['languageName'];
                }
                break;
            }
			case 'datagrid' :  {
				$this->data['content'] = (in_array('module',$this->Permission))?json_encode($this->dataGrid()):'';
			}
		}

	}

	public function displaybox($text){

	}


	public function getForm() {

		$status_a=($this->status == 'y' ? 'checked':'');
		$status_d=($this->status != 'y' ? 'checked':'');
        $main_content = new MainTemplater(DIR_ADMIN_TMPL.$this->module.'/form-nct.tpl.php');
        $main_content = $main_content->parse();

		$fields = array("%MEND_SIGN%","%FORM_NAME%","%STATUS_A%","%STATUS_D%","%TYPE%","%ID%",'%REQUIRED%');

		$fields_replace = array(MEND_SIGN,$this->name,$status_a,$status_d,$this->type,$this->id,($this->type != 'edit' ? 'required' : ''));

		$content=str_replace($fields,$fields_replace,$main_content);
		return sanitize_output($content);

	}
	public function textBox($text) {

		$text['label']     = isset($text['label']) ? $text['label'] : 'Enter Text Here: ';
		$text['value']     = isset($text['value']) ? $text['value'] : '';
		$text['name']      = isset($text['name']) ? $text['name'] : '';
		$text['class']     = isset($text['class']) ? 'form-control ' . trim($text['class']) : 'form-control';
		$text['onlyField'] = isset($text['onlyField']) ? $text['onlyField'] : false;
		$text['extraAtt']  = isset($text['extraAtt']) ? $text['extraAtt'] : '';

        if ($text["onlyField"] == true) {
            $main_content = new MainTemplater(DIR_ADMIN_TMPL . $this->module  . '/textbox_onlyfield.tpl.php');
        } else {
            $main_content = new MainTemplater(DIR_ADMIN_TMPL . $this->module  . '/textbox.tpl.php');
        }
        $main_content = $main_content->parse();
        $fields = array("%CLASS%", "%NAME%", "%ID%", "%VALUE%", "%EXTRA%", "%LABEL%");
        $fields_replace = array($text['class'], $text['name'], $text['name'], $text['value'], $text['extraAtt'], $text['label']);
        return str_replace($fields, $fields_replace, $main_content);
    }
 	public function textArea($text) {
		$text['label']     = isset($text['label']) ? $text['label'] : 'Enter Password Here: ';
		$text['value']     = isset($text['value']) ? $text['value'] : '';
		$text['name']      = isset($text['name']) ? $text['name'] : '';
		$text['class']     = isset($text['class']) ? "form-control " . $text['class'] : 'form-control';
		$text['extraAtt']  = isset($text['extraAtt']) ? ' ' . $text['extraAtt'] : '';
		$text['onlyField'] = isset($text['onlyField']) ? $text['onlyField'] : false;
		if ($text["onlyField"] == true) {
			$main_content = new MainTemplater(DIR_ADMIN_TMPL . $this->module . '/textarea_onlyfield.tpl.php');
		} else {
			$main_content = new MainTemplater(DIR_ADMIN_TMPL . $this->module . '/textarea.tpl.php');
		}
		$main_content   = $main_content->parse();
		$fields         = array("%CLASS%", "%NAME%", "%ID%", "%VALUE%", "%EXTRA%", "%LABEL%");
		$fields_replace = array($text['class'], $text['name'], $text['name'], $text['value'], $text['extraAtt'], $text['label']);
		return str_replace($fields, $fields_replace, $main_content);
	}
	public function dataGrid() {
		$content = $operation = $whereCond = $whereCond1= $totalRow = NULL;
		$result = $tmp_rows = $row_data = array();
		extract($this->searchArray);
		$langId = isset($langId)?$langId:1;
		$chr = isset($chr)?str_replace(array('_', '%'), array('\_', '\%'),$chr ) : '';
		$whrCond = '';
		/*$whrArr = array();*/
        $aWhere[] = "%$chr%";

		if(isset($chr) && $chr != '') {
			$whrCond =" AND p.name LIKE '%".$chr."%'";

		}
		if(isset($sort))
			$sorting = $sort.' '. $order;
		else
			$sorting = 'name ASC';

		$totalRowTmp = $this->db->pdoQuery('SELECT * FROM tbl_forms AS p WHERE 1  AND p.name LIKE ? ORDER BY '.$sorting,$aWhere)->affectedRows();

		$totalRow = $totalRowTmp;


		$qrysel = $this->db->pdoQuery("SELECT *	FROM tbl_forms AS p  WHERE 1  AND p.name LIKE ? ORDER BY $sorting ",$aWhere)->results();



		foreach($qrysel as $fetchRes) {

			$id = $fetchRes['id'];
			$status = ($fetchRes['status']=="y") ? "checked" : "";
			$switch  =(in_array('status',$this->Permission))?$this->toggel_switch(array("action"=>"ajax.".$this->module.".php?id=".$fetchRes['id']."","check"=>$status)):'';

			$operation ='';
			$totEle = $this->db->pdoQuery("SELECT id FROM tbl_forms_elements WHERE form_id = ?",array($fetchRes['id']))->affectedRows();
			if($totEle < 0){
                $totEle = 0;
            }
			$operation .=(in_array('edit',$this->Permission))?'&nbsp;&nbsp;'.$this->operation(array("href"=>SITE_ADM_MOD.$this->module."/ajax.".$this->module.".php?action=edit&id=".$id,"class"=>"btn default btn-xs black btnEdit hideAdd","value"=>'<i class="fa fa-edit"></i>&nbsp;Edit')):'';
			$operation .=(in_array('delete',$this->Permission))?'&nbsp;&nbsp;'.$this->operation(array("href"=>"ajax.".$this->module.".php?action=delete&id=".$id,"class"=>"btn default btn-xs red btn-delete","value"=>'<i class="fa fa-trash-o"></i>&nbsp;Delete')):'';
			$operation .= (in_array('manage_fields',$this->Permission))?'&nbsp;&nbsp;'.$this->operation(array("href"=>SITE_ADM_MOD.'forms-nct/ajax.forms-nct.php?action=edit&id='.$fetchRes['id'],"class"=>"btn default blue btn-xs manageFields btnEdit","value"=>'<i class="fa fa-tasks"></i>&nbsp;Manage Fields','extraAtt'=>'data-fields="'.$totEle.'" data-type="langType"')) : '';

			$final_array = array($id,stripslashes($fetchRes["name"]));

			if(in_array('status',$this->Permission)){
				$final_array =  array_merge($final_array, array($switch));
			}
			if(in_array('edit',$this->Permission) || in_array('delete',$this->Permission) || in_array('view',$this->Permission) || in_array('manage_fields',$this->Permission) ){
				$final_array =  array_merge($final_array, array($operation));
			}

			$row_data[] = $final_array;
		}
		$result["sEcho"]=$sEcho;
		$result["iTotalRecords"] = (int)$totalRow;
		$result["iTotalDisplayRecords"] = (int)$totalRow;
		$result["aaData"] = $row_data;
		return $result;

	}
	public function toggel_switch($text){
		$text['action']   = isset($text['action']) ? $text['action'] : 'Enter Action Here: ';
		$text['check']    = isset($text['check']) ? $text['check'] : '';
		$text['name']     = isset($text['name']) ? $text['name'] : '';
		$text['class']    = isset($text['class']) ? ''.trim($text['class']) : '';
		$text['extraAtt'] = isset($text['extraAtt']) ? $text['extraAtt'] : '';
		$main_content     = new MainTemplater(DIR_ADMIN_TMPL.$this->module.'/switch-nct.tpl.php');
		$main_content     =$main_content->parse();
		$fields           = array("%NAME%","%CLASS%","%ACTION%","%EXTRA%","%CHECK%");
		$fields_replace   = array($text['name'],$text['class'],$text['action'],$text['extraAtt'],$text['check']);
		return str_replace($fields,$fields_replace,$main_content);
	}
	public function operation($text){

		$text['href']     = isset($text['href']) ? $text['href'] : 'Enter Link Here: ';
		$text['value']    = isset($text['value']) ? $text['value'] : '';
		$text['name']     = isset($text['name']) ? $text['name'] : '';
		$text['class']    = isset($text['class']) ? ''.trim($text['class']) : '';
		$text['extraAtt'] = isset($text['extraAtt']) ? $text['extraAtt'] : '';
		$main_content     = new MainTemplater(DIR_ADMIN_TMPL.$this->module.'/operation-nct.tpl.php');
		$main_content     =$main_content->parse();
		$fields           = array("%HREF%","%CLASS%","%VALUE%","%EXTRA%");
		$fields_replace   = array($text['href'],$text['class'],$text['value'],$text['extraAtt']);
		return str_replace($fields,$fields_replace,$main_content);
	}
	public function getPageContent(){
		$final_result             = NULL;
		$main_content             = new MainTemplater(DIR_ADMIN_TMPL.$this->module."/".$this->module.".tpl.php");
		$main_content->breadcrumb = $this->getBreadcrumb();
		$main_content->getForm    = $this->getForm();
        $main_content->langArray  = $this->langArray;
		$final_result             = $main_content->parse();
		return $final_result;
	}

}